/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_machdep.C	1.12 95/11/22"

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#ifdef SOLARIS2
#include <stropts.h>
#include <sys/systeminfo.h>
#include <sys/byteorder.h>
#include <sys/debug.h>
#endif

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include <sys/errno.h>
#include "Bstream.h"
#include "Bigint.h"
#include "ObjId.h"
#include "Time.h"
#include "Name.h"

#include "skip_conf.h"
#include "skip_proto.h"
#include "skip_types.h"
#include "skip_keymgr.h"
#include "skip_log.h"
#include "skip_keymgrmsgs.h"
#include "skip_cache.h"

extern int errno;
extern int skip_fetch_cert;
extern int skip_disk_cache;
extern secret_cache kij_cache;
int readrc;
static int certfd[2];
static int max_fds;
extern int keyfd; 		// XXX

int
open_device(char *dev)
{
	int	fd;
	skip_log(SKIP_NOTICE,"Opening %s",dev);
	fd = open(dev, O_RDWR);
	if (fd < 0) {
		skip_log(SKIP_ERROR,"Opening %s: %s",dev,strerror(errno));
		exit(12);
	}
	return (fd);
}

#ifdef SYSV
void catch_hup(int sig)
#else
void catch_hup(int sig,...)
#endif
{
	signal(SIGHUP,catch_hup);
	skip_log(SKIP_NOTICE,"HUP Signal received - purging cache");
	kij_cache.purge();
	skip_keymgr_init(keyfd);
	if (readrc) {
		flush_resolvers();
		keymgrd_read_rc();	
	}	
}

int
skip_open_device()
{
	int res;
	int fd;
	signal(SIGHUP, catch_hup);
	fd=open_device(KEYMGR);
	max_fds=fd;
	return fd;
}

void skip_setup_fetch(int keyfd) 
{
	signal(SIGPIPE,SIG_IGN);
	pipe(certfd);
	max_fds=(certfd[0]>keyfd)?certfd[0]:keyfd;

}

int 
get_skip_request(int fd, void *buf, int buflen )
{
#ifdef SOLARIS2
        struct strbuf           ctlbuf;
        int                     rc, flags;
 
        ctlbuf.maxlen = buflen;
        ctlbuf.buf = (char *)buf;
        flags = 0;
 
        rc = getmsg(fd, &ctlbuf, NULL, &flags);
 
        return (rc < 0 ? rc : ctlbuf.len);
#else
        return(read(fd, (char *) buf, buflen));
#endif
}


int put_skip_msg(int fd, void *buf, int buflen)
{
#ifdef SOLARIS2
        struct strbuf           ctlbuf;
        int                     rc, flags;
 
        ctlbuf.len = buflen;
        ctlbuf.buf = (char *)buf;
        flags = 0;
 
        rc = putmsg(fd, &ctlbuf, NULL, flags);
 
        return (rc < 0 ? rc : ctlbuf.len);
#else
        return(write(fd, (char *) buf, buflen));
#endif
}

#define MAX_CERT_MSG	4096

int get_skip_msg(int fd, void *buf, int maxsize)
{
	int	n;
	fd_set	select_fds;
	void 	*msg;
	struct timeval *timeout;
	struct timeval t;
	timeout=NULL;
	do {
		FD_ZERO(&select_fds);
		FD_SET(fd, &select_fds);
		if (skip_fetch_cert) 
			FD_SET(certfd[0], &select_fds);

		if (skip_disk_cache) {
			t.tv_sec = 30;
			t.tv_usec = 0;
			timeout=&t;
		}

		n=select(max_fds+1, &select_fds, 0, 0, timeout);

		// Update the on disk secret cache.  This could be expensive.
		// A fork may be the right thing to do here.  This may not
		// be the best way do it anyway.  The select above will 
		// fire if a request isn't received after 30 seconds.  A
		// HEAVILY loaded system may not update the cache if there's
		// too much activity.  Probably better to check to see if
		// some predetermined time has been reached and then 
		// write the cache. 
		if (n < 0)
			continue;

		if (n == 0) {
			if (skip_disk_cache)
				kij_cache.save(SKIP_SECRET_CACHE);
			continue;
		}	

		if (FD_ISSET(certfd[0], &select_fds)) {
			Bstream cert;
			msg=malloc(MAX_CERT_MSG);
			n=read(certfd[0], (char *)msg, MAX_CERT_MSG);
			waitpid(-1, NULL, WNOHANG); /* let the child die */
			cert=Bstream(n, (u_char *)msg);
			skip_fetch_rsp(fd, cert);
			free((char *)msg);
			continue;
        	}
	} while (n <= 0);
	return get_skip_request(fd, buf, maxsize);
}

void
skip_send_cert_reply(Bstream &cert)
{
	int n;
	n=write(certfd[1], (const char *)cert.getdatap(), cert.getlength());
	return;
}

Bstream
get_timestr(int len)
{
       struct timeval time;
       gettimeofday(&time, (struct timezone *)0);
       if (len == 0)
               len=sizeof(time);
         return Bstream(len, (byte *)&time);
}

// Negative value if file1<file2.  Positive if file2>file1, zero if same
int
FileTimeDiff(char *file1, char *file2)
{
	struct stat stat1, stat2;
	int r1, r2;

	r1=stat(file1, &stat1);
	r2=stat(file2, &stat2);

	if (r1) {			
		if (r2) {
			return 0; 	// File1 and file2 are gone, equal
		}
		else {		    	//File 2 is present, but not 1
			return 1; 	//File 2 is newer
		}
	} else {
		if (r2) {
			return -1;	// File1 is present, but 2 is not
					// file 1 is newer
		}
	}
	// We'll go by mtime (modification)
	return stat2.st_mtime-stat1.st_mtime;
}
