#ifndef _AUTH_H
#define _AUTH_H

#include "des.h" 	/* keyType exported from des.h */
#define destroyKey desDestroyKey

typedef void *cipherKey;

#if defined(__STDC__) || defined(__cplusplus)
extern keyType   challenge(int fd, char *keyString, unsigned timeout);
extern keyType   signature(int fd, char *keyString, unsigned timeout);
extern keyType   mkKey(char *keyString);		/* create CFB key */
extern cipherKey mkCipherKey(keyType key, int mode);
extern void	 cipherData(char *dst, char *src, unsigned size, cipherKey c);
extern void	 destroyCipherKey(cipherKey *c);
extern int	 getUserPhrase(
   char *fname, char *phrase, unsigned size, char *uname, keyType key);
#else
extern keyType   challenge();
extern keyType   signature();
extern keyType   mkKey();
extern cipherKey mkCipherKey();
extern void	 cipherData();
extern void	 destroyCipherKey();
extern int	 getUserPhrase();
#endif
#endif
