#define _POSIX_SOURCE
#include <unistd.h>	/* close getlogin */
#include <stdlib.h>	/* atexit exit */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>	/* for fcntl.h */
#include <fcntl.h>
#include <termios.h>
#include "posignal.h"
#include "tty.h"
#include "auth.h"
#include "socket.h"
#include "deslogin.h"

extern int  optind;
extern char *optarg;

#if defined(__STDC__) || defined(__cplusplus)
extern int askTty(char *, char *, unsigned, int);
#else
extern int askTty();
#endif

#define DLPWDSERVER "dlpwdserv"

static char ident[] = 
" @(#) dlpasswd.c\n";
static char RCSid[] = 
   " @(#) dlpasswd.c\\n";

char *progName;
int  debug = 0;
int  verbose = 0;

char unknownLoginName[] = "unknown";

unsigned long inBytes = 0;
unsigned long outBytes = 0;

int fixfd = -1;

void handler(sig)
   int sig;
{
   exit(0);		/* calls fixtty via atexit */
}


/*
 * Perform a client handshake with the server
 */
char *clientHandshake(nfd, string1, string2)
   int nfd;
   char *string1, *string2;
{
   int count, res;
   static char protover[VERS_SIZE];

   count = getString(nfd, protover, VERS_SIZE-1, SETUP_TIMEOUT);
   if (count == 0) {
      fprintf(stderr, "%s: network read of (protover) failed--%s\n", 
	  progName, ERRMSG);
      return 0;
   }
   res = write(nfd, PROTOCOL_VERS, strlen(PROTOCOL_VERS)+1);
   if (res < 0) {
      fprintf(stderr, "%s: gateway network write of \"%s\" failed--%s\n", 
	 progName, PROTOCOL_VERS, ERRMSG);
      return 0;
   }
   if (protover[0] != PROTOCOL_VERS[0]) {
      fprintf(stderr, 
	 "%s: remote protocol version (%s) incompatable with local (%s)\n",
	  progName, protover, PROTOCOL_VERS);
      return 0;
   }
   res = write(nfd, string1, strlen(string1)+1);
   if (res < 0) {
      fprintf(stderr, "%s: gateway network write of \"%s\" failed--%s\n", 
	 progName, string1, ERRMSG);
      return 0;
   }
   res = write(nfd, string2, strlen(string2)+1);
   if (res < 0) {
      fprintf(stderr, "%s: gateway network write of \"%s\" failed--%s\n", 
	  progName, string2, ERRMSG);
      return 0;
   }
   return protover;
}

int main(argc, argv)
   int argc;
   char *argv[];
{
   int ch, count, res;
   unsigned bufSize = 127;
   char aport[16];
   char *chp, *hostName = (char *) 0;
   char *loginName, *ruser = (char *) 0;
   int nfd, port = DLPASSWD_PORT, gport = 0, loginLen, userLen;
   char passPhrase[PHRASE_SIZE], target[128], *tp = (char *) 0;
   char old[PHRASE_SIZE],new[PHRASE_SIZE],temp[PHRASE_SIZE];
   char buff[PHRASE_SIZE];
   char *pwdserver = DLPWDSERVER;

   keyType key;

   progName = *argv;
   if ((chp = strrchr(progName, '/')) != (char *) 0) progName = chp + 1;

   while ((ch = getopt(argc, argv, "dvh")) != EOF) switch (ch) {
   case 'h':
      goto usage;
      break;
   case 'v':
      verbose++;
      break;
   case 'd':
      debug++;
      break;
   default:
usage:
      fprintf(stderr, 
	 "usage: %s [user[@domain[:port]]]\n", 
	 progName);
      exit(1);
   }
   argc -= optind;
   argv += optind;

   if (argc != 0) {
      tp = *argv++; --argc;
   }

   if (tp == (char *) 0) {
      
      strcpy(target, loginName = (char *) getLoginName());		/* NOT getlogin!; see utmp.c */
      if (loginName == (char *) 0) {
      	 fprintf(stderr, "%s: Warning--getLoginName failed\n", progName);
      	 loginName = unknownLoginName;
      }
      strcat(target,"@");
      strcat(target,pwdserver);
      tp =target;
   }

   chp = strchr(tp, '@');
   if (chp != (char *) 0) {
      *chp = '\0';
      ruser     = tp;
      hostName  = chp+1;
   } else {
      ruser = tp;
      hostName  = pwdserver;
   }

   chp = strchr(hostName, ':');
   if (chp != (char *) 0) {
      *chp = '\0';
      count = sscanf(chp+1, "%u", &port);
      if (count != 1) goto usage;
   }
   sprintf(aport, "%d", port);

   loginName = (char *) getLoginName();		/* NOT getlogin!; see utmp.c */
   if (loginName == (char *) 0) {
      fprintf(stderr, "%s: Warning--getLoginName failed\n", progName);
      loginName = unknownLoginName;
   }
   loginLen = strlen(loginName);

   if (ruser == (char *) 0) {
      ruser = loginName;
      if (loginName == unknownLoginName) {
	 fprintf(stderr, 
	 "%s: unknown local login name; must specify remote user\n", progName);
	 exit(1);
      }
   }
   userLen = strlen(ruser);

   nfd = openClient(hostName, port);
   if (nfd < 0) {
	 exit(1);
   }

   chp = clientHandshake(nfd, loginName, ruser);
   if (!chp) {
      close(nfd);
      exit(1);
   }
   res = askTty("Old pass phrase: ", passPhrase, PHRASE_SIZE-1, 0);
   if (res < 0) {
      fprintf(stderr, "%s: couldn't get pass phrase\n", progName);
      close(nfd);
      exit(1);
   }
   key = signature(nfd, passPhrase, SETUP_TIMEOUT);
   memset(passPhrase, '\0', PHRASE_SIZE);
   

   res = read(nfd,temp,4);
   if (res < 0)
   {
    fprintf(stderr,"Network read failed.\n");
    close(nfd);
    exit(0);
   }
   ndbm_cipherstring(buff,temp,4,key,1);
   
   if (strcmp("ok.",buff))
   { 
    fprintf(stderr,"Incorrect pass phrase.\n");
    close(nfd);
    exit(0); 
   } 
   
   do 
   {
    memset(new,0,PHRASE_SIZE);
    memset(temp,0,PHRASE_SIZE);
    res = askTty("New pass phrase: ",new,PHRASE_SIZE-1,0);
    if (res < 0)
    {
     fprintf(stderr,"Couldn't get pass phrase.\n");
     close(nfd);
     exit(0);
    }
    res = askTty("Verify new pass phrase: ",temp,PHRASE_SIZE-1,0);
    if (res < 0)
    {
     fprintf(stderr,"Couldn't get pass phrase.\n");
     close(nfd);
     exit(0);
    }
    if (strcmp(new,temp))
     fprintf(stderr,"Verify error please re-enter pass phrase.\n");

   } while (strcmp(new,temp));
  
   ndbm_cipherstring(buff,new,PHRASE_SIZE,key,0);

   res = write(nfd,buff,PHRASE_SIZE);
   if (res < 0)
   {
    fprintf(stderr,"Network write failed.\n");
    close(nfd);
    exit(0);
   }

   res = read(nfd,temp,PHRASE_SIZE);
   if (res < 0)
   {
    fprintf(stderr,"Network read failed.\n");
    close(nfd);
    exit(0);
   }

   if(strcmp(buff,temp))
   {
    fprintf(stderr,"Network error.\n");
    close(nfd);
    exit(0);
   }

   ndbm_cipherstring(temp,"okproceed.",11,key,0);

   res = write(nfd,temp,11);
   if (res < 0)
   {
    fprintf(stderr,"Network write failed.\n");
    close(nfd);
    exit(0);
   }

   res = read(nfd,temp,11);
   if (res < 0)
   {
    fprintf(stderr,"Network read failed.\n");
    close(nfd);
    exit(0);
   }
   ndbm_cipherstring(buff,temp,11,key,1);

   if (strcmp("okchanged.",buff))
   {
    fprintf(stderr,"Error passphrase unchanged.\n");
    close(nfd);
    exit(0);
   }

   fprintf(stderr,"Pass phrase changed.\n");
   
   destroyKey(&key);
   close(nfd);
   return 0;
}
