#define BLOCKBITS	64		/* bits per block */
#define KEYBITS		56		/* bits per key */
#define STAGECOUNT	16		/* number of stages */
#define DES_BLOCKSIZE	8		/* bytes per block */

#define BASE		1		/* a kludge for 0 vs 1 arrays */

typedef unsigned char  u8;

#if defined(__alpha)			/* 64-bit longs on DEC alpha! */
#define _SIZES
typedef unsigned short u16;
typedef	unsigned int   u32;
typedef		 int   s32;
typedef unsigned long  uFast;		/* An unsigned >= 32 bits */
#endif

#if defined(__msdos) || defined(__MSDOS__)	/* 16-bit ints on PC's */
#define _SIZES
typedef unsigned int   u16;
typedef	unsigned long  u32;
typedef		 long  s32;
typedef          u32   uFast;		/* An unsigned >= 32 bits */
#endif

#if !defined(_SIZES)			/* default */
typedef unsigned short u16;
typedef	unsigned long  u32;
typedef		 long  s32;
typedef          u32   uFast;		/* An unsigned >= 32 bits */
#endif

typedef u8	bit;			/* 1 bit quantity */
typedef u8	u4;			/* 4 bit quantity */
typedef u8	u6;			/* 6 bit quantity */

typedef u8 	blockBitIndex;		/* 1..BLOCKBITS */
typedef u8	keyBitIndex;		/* 1..KEYBITS */

typedef blockBitIndex	bitIndex;	/* generic index into a bitVector */
typedef bitIndex	bitIndexVector[];	/* a vector of bit indices */

typedef	bit		blockType[BLOCKBITS];

typedef struct {
   u32		left;				/* Lowest address = bit 1 */
   u32		right;				/* Highest address = bit 64 */
} desPair;

typedef	u6		u6Block[8];		/* Optimization 6 */
typedef	u32		u32Key[2];		/* Optimization 20 */

#ifndef OLDDES
typedef	u32Key		keyVector[STAGECOUNT];	/* Optimization 20 */
#else
#ifndef NEWDES
typedef	u6Block		keyVector[STAGECOUNT];	/* Optimization 6 */
#else
typedef	desPair		keyVector[STAGECOUNT];	/* Optimization 6 */
#endif
#endif

typedef	u4		stageRange;		/* 1..STAGECOUNT */

typedef union {
   desPair	pair;
   u8 		bytes[8];			/* 0 = LSB, 7 = MSB */
} desUnion;

typedef struct {
   keyVector 	bits;
   u8		decr;			/* encrypt, decrypt flag */
} desKeyType;

extern uFast sBoxp[8][64];
