.TH FTPTOOL 1 "13 Nov 1992" "X Version 11"
.SH NAME
ftptool \- A windowed interface to ftp.
.SH SYNOPSIS
.B ftptool 
[
.I 
generic-tool-arguments 
]
[
.I 
filename.tar
]
.SH DESCRIPTION
.LP
Ftptool is a (hopefully) easier interface to ftp. It hides the interaction with
ftp and the need for knowing commands like 'get' and 'put', and the difference
between 'get' and 'mget'. It provides the ability to transfer directories, 
which ftp by itself does not do, and has an extended form of ftp's .netrc file.
.SH OPTIONS
.TP
.B generic-tool-arguments
ftptool (should) accept the generic tool arguments described in xview(1).
.TP
.B filename.tar
The argument is a tar file (extension .tar). Instead of starting up as ftptool,
start up to examine the tar file. This is a simple tool to list the contents
of the tar file, and extract into a specified directory. Provided in this
manner to avoid a proliferation of programs.
.SH USAGE
.SS .Xdefaults File Options
.LP
You can specify a number of defaults using the .Xdefaults file. These can all
be set using the Properties window (options affecting window placement or
visibility are currently set depending on the current window configuration). 
Other than those controlling the size and placement of the windows, the 
options are, with the first value being the default:

.in +4

.nf
ftptool.AutoConnect                (False/True)
ftptool.AutoShowStatus             (False/True)
ftptool.BatchWindowVisible         (False/True)
ftptool.ConfirmDeletes             (True/False)
ftptool.ConfirmOverWrites          (False/True)
ftptool.DefaultViewer              (textedit %f)
ftptool.DirectoryCacheSize         (5 {0 - 20})
ftptool.GenUniqueLocalNames        (False/True)
ftptool.GenUniqueRemoteNames       (False/True)
ftptool.HostInfoAdvancedVisible    (False/True)
ftptool.HostInfoVisible            (False/True)
ftptool.IgnoreCase                 (False/True)
ftptool.InitialPassword            (login@hostname)
ftptool.KeepConnectionAlive        (False/True)
ftptool.LocalShowHiddenFiles       (False/True)
ftptool.LocalSortField             (Name/Date/Size)
ftptool.LocalSortGrouping          (False/True)
ftptool.LocalSortOrder             (0/1) {Alphabetical}
ftptool.LocalWindowVisible         (False/True)
ftptool.LogSession                 (False/True)
ftptool.OpenLookMode               (True/False)
ftptool.ShowHiddenFiles            (False/True)
ftptool.SortField                  (Name/Date/Size)
ftptool.SortGrouping               (False/True)
ftptool.SortOrder                  (0/1) {Alphabetical}
ftptool.TryProxy                   (False/True)
.fi

.in -4
.LP
When saving defaults, ftptool now saves them in .ftptooldefaults in your
home directory (overwriting the existing information).
.SS Batch mode
.LP
Ftptool has a batch mode. Instead of selecting files in a directory, then having
to transfer all those files before leaving the directory, selections will
be saved in either a Send or Receive list. When you finally decide to copy
the files, they will all be copied at once (and they can be in different
directories). The hierarchy on the source machine is duplicated starting
at the current directory on the destination machine. For example, if you 
have these files in your Batch Receive list:
.in +4
	/export/source/BSD
	/usr/source/Games/NetHack3.10.tar.Z
	/pub/gnu/gcc.tar.Z
.in -4
If your current local directory is /var/tmp, copying these to the local 
machine will create the files:
.in +4
	/var/tmp/export/source/BSD
	/var/tmp/usr/source/Games/NetHack3.10.tar.Z
	/var/tmp/pub/gnu/gcc.tar.Z
.in -4
(and any other directories and files that are in a selected directory. 
Directories are recursively copied, as always). When this occurs is determined
by the Batch window.

.SS The Remote Window
.LP
This is where you usually interact with ftptool. It operates from the various
buttons described below.

.sp .5
.B File Menu
.sp .5
.RS
.TP 10
.B Copy
Copy selected files and/or directories from the local machine to the remote
machine, or from the remote machine to the local machine.
.TP
.B Delete
Delete selected files from the local machine, or the remote machine.
.TP
.B List Directory
List the current remote directory in the Session Log window. There are
two options, DIR and LS. They do the corresponding ftp commands. DIR can
be used to determine the output format of the host, so you can set the
DIR template appropriately.
.TP
.B Compress File
Compress the selected local files.
.TP
.B Uncompress File
Uncompress the selected local files.
.TP
.B Create Tar File
Create a tar file containing the selected local files.
.TP
.B Extract Tar File
Extract the selected tar files. This starts the 'tar viewer' for each file, 
which by default is ftptool.
.RE
.LP
.B View Menu
.sp .5
.RS
.TP 10
.B Remote File
Transfer the remote file to a temporary directory, uncompress if necessary,
then start the appropriate file viewer on the file. This will be the tar
viewer if the file ends in .tar, pageview if it is a PostScript file, or
the default viewer (textedit) otherwise. This will vary if you modify
the extensions ftptool understands in the property window.
.TP
.B Local File
Uncompress if necessary, then start the appropriate file viewer on the file.
This will be the tar viewer if the file ends in .tar, pageview if it is a
PostScript file, or the default viewer (textedit) otherwise. This will 
vary if you modify the extensions ftptool understands in the property window.
.TP
.B Local Directory List
Show the local directory window.
.TP
.B Session Log
Show the session log window. Only active if logging is enabled.
.TP
.B Host Information
Show the host information window.
.TP
.B Transfer Status
Show the transfer status window.
.TP
.B Batch Schedule
Show the Batch Schedule window
.TP
.B About Ftptool
Show the About window.
.RE
.LP
.LP
.B Properties Menu
.sp .5
.RS
.TP 10
.B Tool Properties
Bring up the tool properties window. See the Properties section.
.TP
.B Local File
Show the local file properties window. This shows such elements as
permissions, owner, and group for the last selected file.
.TP
.B Remote File
Show the remote file properties window. This shows such elements as
permissions, owner, and group for the last selected file. If connected
to a non-UNIX machine, or one that has non-ls style 'dir' command output,
most fields will be "unknown".
.TP
.B Save Layout
Save the layout of ftptool. This includes the sizes of the windows, and
whether some of them are visibile. The layout is now saved in the 
file .ftptooldefaults in your home directory.
.RE
.TP
.B Connect Button
Try to connect to the host listed in the Host Information window. If
that window is not displayed, it will be displayed and a connection
will not be attempted.
.TP
.B Abort Button
Active only during a transfer. Abort the transfer of all the files selected
after the current one completes.
.TP
.B Remote Directory Field
Shows the current remote directory. This field is also editable, so you can
type in a directory and press return to change to it. Changing directories
in this way forces ftptool to re-read the remote directory (even if
it is cached). A quick way to do this for the current directory is to
press Return in this field.
.TP
.B Remote Directory List
List of remote files in the current remote directory. Directories are
in bold, with a trailing '/'. You can double-click on a directory to change
to it, or use the pop-up menu. Sorting is controlled by properties. Several
useful functions are in the pop-up menu.
.SS Host Information Window
.TP
.B New Connection
Selecting this button clears the fields in the window. This would be selected
if you wish to connect to a new site. It does not try to connect.
.TP
.B Hosts
This is a menu of the hosts in your host list. Selecting a host fills in
the information below. In addition, if auto-connect is set, it will try
to connect to the host.
.TP
.B Host List
.sp .5
.RS
.TP 10
.B Save
Save the current host list. It will attempt to save to a file named .ftptoolrc
in your home directory. If that fails, it goes to the current directory.
.TP
.B Load 
Load the current host list. It will attempt to load from a file named .ftptoolrc
in your home directory. If that fails, it looks in your current directory.
.TP
.B Append .netrc
When ftptool is first started, it automatically reads the .ftptoolrc file.
If that is not found, it will look for a .netrc file and load from that using
a (very) basic method. If you already have a .ftptoolrc, and want to load
the .netrc too, use this option (this is primarily for earlier versions that
did not read the .netrc).
.B Add 
Add the current information into the list, based on the name in
the Alias field.
.TP
.B Change
This is the same as Add, but it will not ask for confirmation if the
alias already exists.
.TP
.B Delete
Delete the alias named by the Alias field from the list.
.RE
.LP
.TP
.B The Plus Button
When pressed, show the more advanced options of ftptool. There is
a companion Minus button which will hide those options.
.TP
.B Alias
The alias name. When .netrc entries are loaded, they appear as 'machine login'.
.TP
.B Last Visited
The last time you successfully connected to the host described by this alias.
If you have never connected, then "Never" is displayed. When ftptool updates
this field, the host alias list is marked as modified. It is not automatically
saved for you at this point. This field is only updated if you connect through
the host list, and not the current host window.
.B Comment
A comment describing this ftp sit (X sources, GNU software).
.TP
.B Proxy Host
The name of the host supporting proxy ftp. ftptool handles this the
way the Iftp program does (which is part of some consulting special).
.TP
.B Remote Host
The name of the remote host.
.TP
.B Login
The login name to use on the remote host.
.TP
.B Password
The password to give on the remote host. Characters in your password will 
be displayed as '*'. In the .ftptoolrc file, this field will be encrypted.
WARNING: The encryption algorithm is fairly simple, and made even more
breakable since ftptool source is freely available. Encrypting the password
allows you to look at it without divulging your passwords, but is not
unbreakable. For this reason, the .ftptoolrc file is mode 600.
.TP
.B Account
The account to give when logging in to the remote
host. This is not usually needed. Pressing return 
in this field will automatically attempt to connect.
If this field is empty, an account will not be
passed.
.TP
.B Remote host runs
Indicates which type of operating system the 
remote system runs, so ftptool knows how to 
interpret the output of directory listings. 
Most UNIX systems should use UNIX, and VMS 
systems should use VMS. If ftptool is confused 
by the directory listing, it will just list 
the filenames (and you will lose all type 
and permission information). If this occurs, 
you can choose Other, and specify the pattern 
that ftptool should look for. 
.TP
.B Transfer Mode
The mode of transfer to use on the remote host. Before any transfer, this
is read, so you can change it as you work.
.TP
.B Remote Directory
The remote directory to change to upon connection. Perhaps you always want to
go to /pub/gnu on prep.ai.mit.edu.
.TP
.B Local Directory
The local directory to change to upon connection. Perhaps you always want to
go to /home/gnu when connecting to prep.ai.mit.edu.
.TP
.B DIR Template
Since ftptool can not know the format the 'dir' command (which is used to 
fill the remote list) displays on each host, you can tell ftptool the
format on a per-host basis. ftptool uses a default format, so unless
you have problems, you probably should leave it alone. If you need to
determine the format, either connect using normal ftp, or connect with
ftptool and use 'dir' in the Custom field. This will display in the session
window, so make sure you are logging.

The template is a series of keywords separated by whitespace or characters
that must match (so if there are dashes in the date, you theoretically
give MONTH-DAY-YEAR). The keywords are:
.in +4
.nf
PERMS - Normal UNIX permissions (drwxrwxrwx)
LINKS - Link count. Currently matched, but discarded.
USER - User name/number
GROUP - Group name/number
SIZE - File size
MONTH - Month (Dec, Jan, ...)
DAY	 - Day of week (number)
TIME - Hour:minute (09:49) or year (1991)
NAME - Filename.
SKIP - Discard characters until the next whitespace.
.fi
.in -4
Anything else must be matched exactly. The default is given in ftptool.h
as:
.in +4
PERMS LINKS USER GROUP SIZE MONTH DAY TIME NAME
.in -4
which matches the 'ls -lg' output:

.nf
-rw-r--r--  1 mike_s   develop      8636 Dec 20 09:49 transfer.o
.fi
A special case is the pattern NONUNIX. If this is present anywhere
in the template, it sets non-UNIX mode. Ftptool will only use 'ls' to
get directory listings, and will not expand environment variables
when trying to cd with the Remote Directory text field.
Also, ftptool will assume that all directory entries are normal files.
You can still attempt to double-click on the files to cd, though.

Another special case is the pattern LOWERNAMES. This causes all file
names read from the remote machine to be converted to lowercase. This
is for those machines that output data in uppercase, but can't handle
it in return (such as VMS).

.SS Local Directory Window
.TP
.B Local Directory Field
Shows the current local directory. This field is also editable, so you can
type in a directory and press return to change to it.
.TP
.B Free Space
Gives the amount and percentage of free space available in the file system
the directory is in.
.TP
.B Local Directory List
List of local files in the current local directory. Directories are
in bold, with a trailing '/'. You can double-click on a directory to change
to it, or use the pop-up menu. Sorting is controlled by properties. Several
useful functions are in the pop-up menu.

.SS Session Log Window
.LP
Shows all data sent to ftp, as well as all responses from ftp. This is
primarily for debugging, but is also useful if the remote machine shows
a message of the day.

.SS Transfer Status Window
.LP
This shows you how far along each file transfer is. It shows the name
and transfer direction, the size, and a gauge showing the percent complete.
It updates every 8K block transferred.

.SS Batch Schedule Window
.LP
This allows you to perform batch transfers. The Batch Send list 
shows all the files pending transfer from the local host to the remote host,
and the Batch Receive list shows all the files pending transfer from the remote
host to the local one. Only one list is shown at a time, based on the
setting of the Action item. Addition to a list is performed by selecting the 
files (or directories) in either the Remote Window (for the Receive list) or 
the Local Window (for the Send list), then selecting the 'Add to Batch List'
option on the list pop-up. Deletion or starting the batch transfer is
accomplished in the list pop-up. To schedule a batch transfer, construct
a list, and use Set Current to create the appropriate batch name. Then,
set appropriate parameters on the Host Information window (such as the
remote and local directories). Also, set the time for the transfer. You
can do this for multiple hosts, but nothing will happen until you choose
the Process Batch item. At that point, the batch list will be processed.
Make sure that you bring up the session log before you start or you will
not have a log.

.SS About Ftptool Window
.LP
Shows information about Ftptool. Who I am, why it was written, and a few
credits. Also allows you to send feedback to me.

.SS Properties
.LP
In addition to the properties listed below, applying your properties will
also save the current state of your pop-up windows (visible or non-visible).
At this time, location is not saved.

.RE
.LP
.TP
.B Ftptool options
.sp .5
.RS
.TP 10
.B FTP options
The Log Session option causes ftptool to display the Session Log, and
to actually write to it. The Keep Connection Alive option is not part of ftp, 
but by choosing it ftptool will send a command every 10 minutes so that the 
remote server does not time out and disconnect (which it does after 15 
minutes of inactivity).
.TP
.B Generate unique
The Local Filenames options cause ftptool to generate unique local
filenames of the form N.filename, where N is a number, if filename
already exists on the local machine. The Remote Filenames option
causes ftptool to use the Store Unique FTP command when sending
files, to make the remote server generate unique filenames if filename
exists.
.TP
.B Automatically
The Connect option causes ftptool to immediately try to connect 
to the host selected from the Hosts menu. The Show Status option forces
the Transfer Status window to be displayed when beginning a transfer.
The Try Sun Proxy FTP option causes ftptool to automatically try to 
use Sun's proxy FTP (from Sun Consulting) if it cannot resolve the 
hostname (the host is unknown) or it receives a 'Network unreachable' 
error when connecting.  This is primarily used by Sun folks trying 
to get out to the Internet.
.TP
.B Window manager
If selected, ftptool assumes it is running under an OPEN LOOK Window Manager,
and does not provide a Quit button. Also, Viewing a window that is 
already displayed will cause it to be hidden.
.TP
.B Initial Password
The initial password to use, primarily for anonymous ftp.
.TP
.B Case sensitivity
Controls whether or not to respect the case of characters when
sorting the Hosts menu and the directory lists.
.TP
.B Confirm
The deletions button controls whether or not to request confirmation 
when deleting files. If you delete directories with this on, it will ask 
for each file in the directory. The overwrites button causes ftptool
to ask for confirmation when receiving a file would overwrite an existing
file. If you decide not to overwrite, the entire transfer is aborted.
.RE
.LP
.TP
.B Directory List options
.sp .5
.RS
.TP 10
.B Unlimit Cache Size
This option causes ftptool to cache _all_ directories. It could be quite 
a memory waster.
.TP
.B Directory Cache Size
Determines how many directory listings ftptool will remember. This is managed 
as an LRU cache, so every time you CD into a directory ftptool first looks in 
the cache. If it finds it, then instead of actually reading the directory it 
just displays the list in the cache. This can speed up directory listings on 
slow links.  The larger you make the cache, the more memory you will use and 
(if you keep listing the same directories) the less likely you'll have to 
talk to the remote server. However, the larger the cache, the less likely it 
is that you'll see any changes being made on the cached directories. To 
effectively not cache at all, set this to 1. 
 
There are two caches, one for local directories and one for remote. 
This property controls both (setting it to 2 actually means you'll
cache 4 directories: 2 local and 2 remote). 
.TP
.B Sort remote files by
Controls which field in the remote file list to sort by.
You can sort by name, date, size, or type.
.TP
.B Sort order
Controls how to sort the field. For sorting by name: either alphabetical 
or reverse alphabetical. For sorting by the date: either least recently
changed or most recently changed. For sorting by the size: either smallest 
first or largest first. For sorting by type: either alphabetical or
reverse alphabetical (within the types of files).
.TP
.B Hidden files
Controls whether or not to display hidden files (those beginning with a
period).
.TP
.B Group files by type
If set, then files are grouped by types (directories first, then regular
files, ...) in addition to being sorted as normal.
.TP
.B Sort local files by
Controls which field in the local file list to sort by.
You can sort by name, date, size, or type.
.TP
.B Sort order
Controls how to sort the field. For sorting by name: either alphabetical 
or reverse alphabetical. For sorting by the date: either least recently
changed or most recently changed. For sorting by the size: either smallest 
first or largest first. For sorting by type: either alphabetical or
reverse alphabetical (within the types of files).
.TP
.B Hidden files
Controls whether or not to display hidden files (those beginning with a
period).
.TP
.B Group files by type
If set, then files are grouped by types (directories first, then regular
files, ...) in addition to being sorted as normal.
.RE
.LP
.TP
.B Viewer options
.sp .5
.RS
.TP 10
.B Default file viewer
The default viewer for files of unknown (usually text) type. This is a
command line, which will be broken up into arguments. '%f' will be
replaced by the file name to view; if not specified, the file name will
be passed as the last argument.
.TP
.B Known extensions
A scrolling list of extensions known to ftptool. Selecting one fills
in the fields below. The Add, Delete, and Change buttons work based
on the Extension field below.
.TP
.B Extension
The extension ftptool will look for when examining file types. This
is the key used to index the entry, so usually you fill this (and the
following information) in, then select Add. If that extension already
exists, it will ask if you really want to replace it (Change will not
ask). Delete also operates on this field. Note that you are actually
specifying the last N characters of the filename, so you must include
the period if it should be there (I think this is more flexible than
inserting a period for you). Ftptool preloads pageview for PostScript
files and tar for tarfiles (or, if you specified others for the older
properties, it should load those first).
.TP
.B Contents begin with
This specifies the first N characters of the file. When Viewing a
file, ftptool determines the type both by the extension and the contents
of this field. If there is a discrepency (the file is X.GIF but is
actually a Raster file), ftptool uses the program associated with
the Contents (this field overrides the extension). If you leave this
field alone (as an empty line), it is not used.
.TP
.B Program to run
The program to invoke to view the file. This is a command line, 
which will be broken up into arguments. '%f' will be replaced by the 
file name to view; if not specified, the file name will be passed as the 
last argument.
.SH AUTHOR
.RE
.LP
Mike Sullivan (Mike.Sullivan@Sun.COM)
