sub _die ($) {
    # CPAN smokers report FAIL if Makefile.PL dies, it should exit with status 0
    my $err = shift;
    warn $err;
    exit 0;
}

use strict;
use Getopt::Long;
use ExtUtils::MakeMaker;

my $tclsh_default = 'tclsh';
# for FreeBSD users, try to guess their name for tclsh; see ticket 6086
if ($^O eq 'freebsd') {
    for my $ver (qw(8.9 8.8 8.7 8.6 8.5 8.4 8.3 8.2 8.1 8.0)) {
       system "which tclsh$ver >/dev/null 2>&1";
       if ($? == 0) {
	    $tclsh_default = "tclsh$ver"; # ok will use that as default
	    last;
	}
    }
}

GetOptions(
    "tclsh=s", \(my $tclsh=$tclsh_default),
    "force!",  \(my $force=0),
    "help!",   \ my $help,
) || usage();
usage() if $help;
sub usage {
    _die <<'EOT';
Usage: perl Makefile.PL [--tclsh <path>] [--force] [<makemaker opts>...]

if Tcl/Tk already have required treectrl package, then do nothing.
--force option means that rebuilding of treectrl will happen anyway.

--tclsh option is mostly for users, who want specific setup.
Default autodetection should be fine.
EOT
}

use Tcl::Tk;
my $int = new Tcl::Tk;
my $current_treectrl = eval {
    $int->_packageRequireTreectrl;
};
print STDERR "cur ver = $current_treectrl\n";

my @c = (
    qw(
	    ../generic/qebind
	    ../generic/tkTreeColumn
	    ../generic/tkTreeCtrl
	    ../generic/tkTreeDisplay
	    ../generic/tkTreeDrag
	    ../generic/tkTreeElem
	    ../generic/tkTreeHeader
	    ../generic/tkTreeItem
	    ../generic/tkTreeMarquee
	    ../generic/tkTreeNotify
	    ../generic/tkTreeStyle
	    ../generic/tkTreeTheme
	    ../generic/tkTreeUtils
    ),
    ($^O eq 'MSWin32' ? '../win/tkWinTree' : ()),
    ($^O eq 'linux' ? '../unix/tkUnixTree' : ()),
    ($^O eq 'linux' ? '../macosx/tkMacOSXTree' : ()),
);

my $DEFS="-DUSE_TCL_STUBS=1 -DUSE_TK_STUBS=1";


if ($current_treectrl && $current_treectrl ge '2.4.3' && !$force) {
    # tcl/tk already have the module - generate dummy module
    open my $fh, ">treectrl.pm";
    print $fh <<'EOS';
package Tcl::Tk::Tkwidget::treectrl;
# ATTENTION! this autogenerated dummy module here because your tcl/tk setup
# happen to already have the required treectrl widget
sub init {
    my $int = shift;
    $int->Eval('package require treectrl');
}
1;
EOS
    close $fh;
    WriteMakefile(
	NAME => "Tcl::Tk::Tkwidget::treectrl",
	PM => {'treectrl.pm' => 'Tcl/Tk/Tkwidget'},
	XS => {},
    );
}
else {
    # read tcl compile options
    # TODO let's $int know these values
    open my $fh, "<".$int->GetVar('tcl_library')."/../tclConfig.sh";
    my $tcl_config = join '', <$fh>;
    close $fh;
    open $fh, "<".$int->GetVar('tcl_library')."/../tkConfig.sh";
    my $tk_config = join '', <$fh>;
    close $fh;
    my ($tcl_incspec, $tcl_libspec, $tk_libspec, $tcl_defs, $tk_defs) = (
	$tcl_config=~/^TCL_INCLUDE_SPEC='(.*?)'/m, 
	              $tcl_config=~/^TCL_LIB_SPEC='(.*?)'/m,
				    $tk_config=~/^TK_LIB_SPEC='(.*?)'/m,
		       			         $tcl_config=~/^TCL_DEFS='(.*?)'/m,
							    $tk_config=~/^TK_DEFS='(.*?)'/m);
    $DEFS = "$tcl_defs -DUSE_TCL_STUBS=1 $tk_defs -DUSE_TK_STUBS=1"=~y/\\//dr;
print STDERR "(tcl_incspec,tcl_libspec,tk_libspec)=($tcl_incspec, $tcl_libspec, $tk_libspec)\n";
    open my $fh_out, ">treectrl.pm";
    print $fh_out <<'EOS';
package Tcl::Tk::Tkwidget::treectrl;
require DynaLoader;
our @ISA = qw(DynaLoader);
__PACKAGE__->bootstrap;

# happen to NOT have the required treectrl widget
sub init {
    my $int = shift;
    $INC{'Tcl/Tk/Tkwidget/treectrl.pm'} =~ /^(.*)\// or die "?";
    $int->SetVar('::treectrl_library',"$1/../library");
    Tcl::Tk::Tkwidget::treectrl::Treectrl_Init($int);
    #$int->Eval('package require treectrl');
}
1;
EOS
    close $fh_out;
    WriteMakefile(
	NAME => "Tcl::Tk::Tkwidget::treectrl",
	VERSION => '2.4.2',
	LICENSE => 'perl',
	MIN_PERL_VERSION => '5.006',
	META_MERGE => {
	    "meta-spec" => { version => 2 },
	    resources => {
		repository => {
		    type => 'git',
		    web => 'https://github.com/vadrer/tktreectrl',
		    url => 'https://github.com/vadrer/tktreectrl',
		},
		MailingList => 'mailto:tcltk@perl.org',
	    },
	    keywords => [qw(Tk Tcl/Tk tktreectrl GUI)],
	},
	PREREQ_PM => {
	    'Tcl::Tk' => 1.0,
	},
	PMLIBDIRS    => ['../library', '../demos', '../doc'],
	INC          => "$tcl_incspec -I../generic",
	LIBS         => "$tcl_libspec $tk_libspec" . ($^O eq 'MSWin32' ? ' -lUxTheme' : ''),
	OBJECT       => 'treectrl.o ' . join(' ', map {s/^.*\///r . ".o"} @c),
	DEFINE       => $DEFS,
	dist         => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    );
}
sub MY::postamble {
    return join '', map {my $c = s/^.*\///r; <<"EOS"} @c;
$c\$(OBJ_EXT) : $_.c
	\$(CCCMD) \$(CCCDLFLAGS) "-I\$(PERL_INC)" \$(PASTHRU_DEFINE) \$(DEFINE) $_.c
EOS
}

