#!perl
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/test-dist-zilla-files.t
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Test-Dist-Zilla.
#
#   perl-Test-Dist-Zilla is free software: you can redistribute it and/or modify it under the terms
#   of the GNU General Public License as published by the Free Software Foundation, either version
#   3 of the License, or (at your option) any later version.
#
#   perl-Test-Dist-Zilla is distributed in the hope that it will be useful, but WITHOUT ANY
#   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Test-Dist-Zilla. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC';
use Test::Routine;
with 'Test::Dist::Zilla';

use Test::Fatal;
use Test::More;
use Test::Routine::Util;
use Test::Deep qw{ cmp_deeply };
use Path::Tiny;

#   This test checks how `Test::Dist::Zilla` generates source files. Do not confuse with
#   `test-dist-zilla-built-files.t`, which checks `Test::Dist::Zilla::BuiltFiles` test.

test 'Files' => sub {

    my ( $self ) = @_;
    my $expected = $self->expected;
    my $files = $expected->{ files };

    plan tests => keys( %$files ) * 2;

    my $root = path( $self->tzil->root );
    for my $name ( sort( keys( %$files ) ) ) {
        my $file = $root->child( $name );
        ok( $file->exists, "file $name exists" );
        my @lines = $file->lines_utf8( { chomp => 1 } );
        cmp_deeply( \@lines, $expected->{ files }->{ $name }, "file $name content" );
    };

    done_testing;

};

# --------------------------------------------------------------------------------------------------

plan tests => 4;

run_me 'one line in string' => {
    files => {
        'lib/Dummy.pm' => "package Dummy; 1;\n",
    },
    expected => {
        files => {
            'lib/Dummy.pm' => [ 'package Dummy; 1;' ],
        },
    },
};

run_me 'two lines in staring' => {
    files => {
        'lib/Dummy.pm' => "package Dummy;\n1;\n",
    },
    expected => {
        files => {
            'lib/Dummy.pm' => [ 'package Dummy;', '1;' ],
        },
    },
};

run_me 'array of lines' => {
    files => {
        'lib/Dummy.pm' => [ 'package Dummy;', '1;' ],
    },
    expected => {
        files => {
            'lib/Dummy.pm' => [ 'package Dummy;', '1;' ],
        },
    },
};

run_me 'two files' => {
    files => {
        'lib/Dummy.pm' => [ 'package Dummy;', '1;' ],
        'README'       => "README\nReadMe\nreadme\n",
    },
    expected => {
        files => {
            'lib/Dummy.pm' => [ 'package Dummy;', '1;' ],
            'README'       => [ 'README', 'ReadMe', 'readme' ],
        },
    },
};

done_testing;

exit( 0 );

# end of file #
