use strict;
use warnings;
use SOOT ':all';
use Math::Trig;

sub testAll {
  use constant N => 100000;
  my $cpn = 100000./N;

  my $r1 = TRandom->new;
  my $r2 = TRandom2->new;
  my $r3 = TRandom3->new;

  my $sw = TStopwatch->new;
  printf("Distribution            microseconds/call\n");
  printf("                    TRandom  TRandom2 TRandom3\n");

  my $x;
  $sw->Start();
  for my $i (0..N-1) {
    $x = $r1->Rndm($i);
  }
  printf("Rndm.............. %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for my $i (0..N-1) {
    $x = $r2->Rndm($i);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for my $i (0..N-1) {
    $x = $r3->Rndm($i);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Gaus(0,1);
  }
  printf("Gaus.............. %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Gaus(0,1);
  }
  printf(" %8.3f", $sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Gaus(0,1);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Landau(0,1);
  }
  printf("Landau............ %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Landau(0,1);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Landau(0,1);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Binomial(5,0.5);
  }
  printf("Binomial(5,0.5)... %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Binomial(5,0.5);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Binomial(5,0.5);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Binomial(15,0.5);
  }
  printf("Binomial(15,0.5).. %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Binomial(15,0.5);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Binomial(15,0.5);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Poisson(3);
  }
  printf("Poisson(3)........ %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Poisson(3);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Poisson(3);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Poisson(10);
  }
  printf("Poisson(10)....... %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Poisson(10);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Poisson(10);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Poisson(70);
  }
  printf("Poisson(70)....... %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Poisson(70);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r3->Poisson(70);
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r1->Poisson(100);
  }
  printf("Poisson(100)...... %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  for (0..N-1) {
    $x = $r2->Poisson(100);
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $sw->Start();
  $x = $r3->Poisson(100) for (0..N-1);
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  my $f1 = TF1->new("f1","gaus",-4,4);
  $f1->SetParameters(new array::Array('d',[1,0,1]));

  $gRandom->($r1);
  $sw->Start();
  for (0..N-1) {
     $x = $f1->GetRandom();
  }
  printf("GausTF1........... %8.3f",$sw->CpuTime()*$cpn);

  $gRandom->($r2);
  $sw->Start();
  for (0..N-1) {
     $x = $f1->GetRandom();
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $gRandom->($r3); # FIXME Assignment operators or similar (see TODO)
  $sw->Start();
  for (0..N-1) {
     $x = $f1->GetRandom();
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);

  my $f2 = TF1->new("f2","landau",-5,15);
  $f2->SetParameters(new array::Array('d',[1,0,1]));

  $gRandom->($r1);
  $sw->Start();
  for (0..N-1) {
     $x = $f2->GetRandom();
  }
  printf("LandauTF1......... %8.3f",$sw->CpuTime()*$cpn);

  $gRandom->($r2);
  $sw->Start();
  for (0..N-1) {
     $x = $f2->GetRandom();
  }
  printf(" %8.3f",$sw->CpuTime()*$cpn);

  $gRandom->($r3);
  $sw->Start();
  for (0..N-1) {
     $x = $f2->GetRandom();
  }
  printf(" %8.3f\n",$sw->CpuTime()*$cpn);
}

sub testRandom3 {

  my $RefValue = [
     0.81733006,0.99906090,0.51035437,0.13153291,0.03541635,0.99246953,0.62570870,0.06259195,
     0.41071051,0.13477367,0.98087230,0.83739344,0.96552844,0.22128745,0.44443750,0.33807132,
     0.70534207,0.03319661,0.36874827,0.42297428,0.58917768,0.31198491,0.90208136,0.70879117,
     0.45695755,0.54116575,0.07224296,0.22841073,0.21145732,0.78509043,0.52266975,0.15731867,
     0.74431815,0.24225334,0.71237144,0.71139078,0.65817271,0.67160887,0.71958352,0.52671765,
     0.81637290,0.48441294,0.38109662,0.99952637,0.47448673,0.57408927,0.29098035,0.00700452,
     0.02613592,0.31053063,0.20498745,0.07792653,0.77710219,0.00397776,0.24915641,0.49163196,
     0.26287272,0.64487490,0.04627505,0.49447185,0.78513214,0.15551811,0.28760017,0.32910048,
     0.54834635,0.72919981,0.31700058,0.79623664,0.87401422,0.61549255,0.19901847,0.65743758,
     0.36394627,0.64682013,0.78236511,0.30151095,0.62095993,0.95354393,0.18781735,0.86562104,
     0.24958360,0.84537539,0.17959665,0.26342110,0.86091750,0.99298659,0.31777386,0.66680234,
     0.25841019,0.71407696,0.64696258,0.92890438,0.20011200,0.03900434,0.25476924,0.45721227,
     0.29274370,0.40278521,0.02927933,0.24882571,0.41015308,0.49048318,0.24055835,0.22030061,
     0.25621529,0.11392559,0.55531160,0.15336550,0.77020781,0.55553334,0.02459224,0.46012777,
     0.35751076,0.07315001,0.29045640,0.49781675,0.64193243,0.56658425,0.92454871,0.45266960,
     0.55095565,0.59174837,0.99767534,0.05236326,0.33946435,0.50946936,0.85102374,0.22797478,
     0.29799012,0.63136922,0.95319405,0.53548567,0.49403618,0.58334783,0.43009950,0.69254489,
     0.80089172,0.38947293,0.05254629,0.58134491,0.14240379,0.92969809,0.81686257,0.38736825,
     0.17661743,0.38507002,0.39606030,0.88077117,0.77854230,0.60595983,0.14658502,0.86708308,
     0.08412199,0.62269042,0.33618395,0.95572246,0.03277188,0.98509318,0.10418194,0.17320687,
     0.65619013,0.31015625,0.06194080,0.07175284,0.03035102,0.71576738,0.72023646,0.37316047,
     0.43220056,0.78602933,0.72523767,0.08624364,0.33417859,0.15025760,0.21162379,0.56819255,
     0.37239232,0.58210006,0.18396678,0.85786951,0.94358435,0.36472649,0.06869341,0.96937716,
     0.69800896,0.15787523,0.85394390,0.29648328,0.82789802,0.17741989,0.25410572,0.41110448,
     0.98677803,0.79315873,0.88411529,0.09048238,0.50307567,0.08148165,0.32418417,0.83330672,
     0.14074385,0.83302705,0.54050764,0.88252641,0.74173695,0.51913331,0.26276695,0.20602320,
     0.77550233,0.74370025,0.15857482,0.18634406,0.46725959,0.60993159,0.36738095,0.83240586,
     0.52622445,0.85894528,0.38599805,0.61522709,0.67019941,0.72176407,0.10916136,0.96260655,
     0.95708292,0.44343951,0.45103833,0.73053001,0.84836401,0.19097768,0.71441120,0.78900459,
     0.98617819,0.60887900,0.36223114,0.35412423,0.24378622,0.38721935,0.91932366,0.25089762,
     0.69778047,0.75226990,0.47017556,0.20146258,0.47643465,0.73658783,0.06264829,0.52467006,
     0.06467187,0.25951195,0.62394357,0.23024284,0.21489860,0.11107103,0.27047458,0.68687182,
     0.48635525,0.81884360,0.32680150,0.27568774,0.82213186,0.70811095,0.78211868,0.49311790,
     0.35617696,0.29174889,0.42600296,0.62369889,0.49800726,0.73278784,0.10412470,0.24892372,
     0.88282504,0.18740641,0.83361413,0.39586229,0.21048279,0.01735519,0.30001581,0.40672912,
     0.10188941,0.18197491,0.27156564,0.59752112,0.99950864,0.94920455,0.92408342,0.71184385,
     0.48303596,0.85067874,0.13648935,0.74769050,0.60639437,0.76909182,0.01186354,0.49329672,
     0.10714793,0.78120836,0.11658467,0.39158614,0.02654157,0.27961507,0.72004317,0.07286112,
     0.91178413,0.59644492,0.86471944,0.52164190,0.14834674,0.45319741,0.75070517,0.52213560,
     0.58789377,0.22021929,0.65313632,0.43755274,0.88293108,0.00881952,0.28076366,0.81677460,
     0.62997773,0.72974092,0.73809120,0.00210845,0.50009595,0.88197326,0.56397940,0.28592215,
     0.29689698,0.32257535,0.02991649,0.15802567,0.57426849,0.63224317,0.09780467,0.09221793,
     0.40275296,0.96533188,0.09078909,0.23537767,0.18503637,0.14755087,0.83069161,0.05797206,
     0.29209753,0.46332474,0.33187428,0.51277665,0.65900698,0.88450671,0.80162803,0.06285642,
     0.65370611,0.41792440,0.37322222,0.31673850,0.42032287,0.12915823,0.99183469,0.50494915,
     0.10313063,0.87186173,0.83058283,0.28692706,0.86617909,0.07066538,0.82276822,0.49743861,
     0.65517282,0.71056031,0.65894907,0.73515636,0.74182474,0.24757007,0.96248561,0.47191825,
     0.02204604,0.00993510,0.51349674,0.04662995,0.74141249,0.28316860,0.45211229,0.44299580,
     0.96397909,0.45046886,0.61147180,0.24238744,0.75822703,0.46695985,0.08545828,0.59658000,
     0.97305912,0.09186353,0.86482636,0.72104425,0.86841101,0.82149848,0.34538708,0.19123514,
     0.47904939,0.73141185,0.14705495,0.54148300,0.83091474,0.53555212,0.06001840,0.80458720,
     0.66447743,0.05214252,0.54033370,0.05829573,0.82837277,0.21585693,0.07343976,0.45574279,
     0.16894963,0.77891380,0.25957446,0.42626845,0.44766521,0.88144142,0.79273048,0.56690366,
     0.31655285,0.20033301,0.69382520,0.20676850,0.14943414,0.04203240,0.77226726,0.93434004,
     0.00665110,0.24343808,0.96196466,0.05028409,0.08433921,0.52343028,0.71457802,0.79246257,
     0.42211837,0.41186206,0.93308887,0.28888652,0.00323350,0.81831010,0.89112996,0.77793345,
     0.46166572,0.47337993,0.99742385,0.87176229,0.16908698,0.90926109,0.43674447,0.47276792,
     0.65706547,0.77427418,0.39377904,0.70637717,0.39966382,0.36218531,0.61958411,0.46097110,
     0.52431923,0.29710511,0.77794336,0.44065830,0.51102742,0.11329236,0.58040572,0.13812234,
     0.18067337,0.29238623,0.53972462,0.71159170,0.03686473,0.57088434,0.78560214,0.08681037,
     0.26271669,0.08707718,0.56324526,0.19315938,0.68643390,0.54113702,0.03742116,0.33642405,
     0.17822265,0.88021518,0.13789732,0.07373062,0.54532172,0.33518099,0.78282745,0.66610581,
     0.25997006,0.70633347,0.32169739,0.30070857,0.45696895,0.51743666,0.28306410,0.83102753,
     0.37514942,0.27281418,0.71187608,0.75990978,0.71379176,0.18195183,0.43799556,0.87754865,
     0.27787586,0.66214825,0.80039407,0.50308127,0.09761988,0.64426099,0.93303703,0.30862984,
     0.97503342,0.94690058,0.76828286,0.03591404,0.45211060,0.26951636,0.16420588,0.20041079,
     0.30508215,0.44198933,0.81286523,0.07283472,0.79325444,0.23966486,0.80650448,0.63822675,
     0.62994282,0.61568470,0.15902616,0.22079987,0.61860009,0.38280795,0.66446975,0.19140073,
     0.17553973,0.37348454,0.40893456,0.79177487,0.65256982,0.52810438,0.88118109,0.70080330,
     0.09183587,0.42844970,0.61741237,0.28062020,0.82689390,0.66541543,0.58731742,0.85583051,
     0.28754463,0.80540403,0.04342987,0.30965563,0.54072529,0.25111917,0.02636629,0.56375924,
     0.76976160,0.04933231,0.19725465,0.24075160,0.55275752,0.17601844,0.57611845,0.43910581,
     0.83540259,0.77444162,0.17398828,0.73866963,0.94636429,0.47407761,0.82412350,0.66616686,
     0.76924418,0.55549670,0.17107736,0.18734632,0.26965591,0.48438918,0.57178814,0.47970533,
     0.28482623,0.59927202,0.77796561,0.74676815,0.38522871,0.28586360,0.41433794,0.98753382,
     0.91795320,0.64912250,0.02104557,0.28765939,0.56002049,0.95388346,0.49398375,0.56624579,
     0.61676996,0.08280439,0.93088510,0.82063055,0.21403632,0.18384002,0.57404210,0.05138611,
     0.68620413,0.30963975,0.86843956,0.28382975,0.70009432,0.06553222,0.88487274,0.17017184,
     0.51737725,0.95630554,0.62574404,0.75923421,0.86190631,0.89923650,0.32888148,0.39459141,
     0.17985475,0.16045021,0.52749047,0.81488465,0.66252785,0.59856171,0.45339297,0.93769466,
     0.44489423,0.89846779,0.93638325,0.94966682,0.79465849,0.69384779,0.50030870,0.34862620,
     0.47509697,0.72458342,0.51266543,0.85502048,0.69921358,0.88701421,0.86361008,0.76017494,
     0.39756695,0.25727441,0.85957870,0.44207373,0.54087748,0.17149436,0.53558357,0.72188831,
     0.07041658,0.29999474,0.46125135,0.84884899,0.37471755,0.79585295,0.85398628,0.12487134,
     0.70795774,0.59243011,0.09883110,0.37293453,0.05747022,0.62335461,0.66017320,0.26258314,
     0.19813686,0.48144864,0.87688960,0.23327933,0.88500531,0.75490883,0.36335473,0.39153243,
     0.59674457,0.81137417,0.61825663,0.40660643,0.82674346,0.94034309,0.17119000,0.92063020,
     0.95492463,0.73737746,0.45790558,0.36707067,0.04820434,0.54420593,0.79276160,0.78515019,
     0.53871723,0.35180979,0.91601484,0.03539422,0.53669714,0.23358341,0.88200486,0.63750977,
     0.62103354,0.94898313,0.91268509,0.91611582,0.22251574,0.86644709,0.44068809,0.44828197,
     0.82204251,0.01335423,0.11663959,0.88761171,0.72659529,0.77960883,0.61659203,0.68707521,
     0.67666380,0.97686601,0.46010131,0.13248757,0.74619763,0.19479952,0.99025307,0.93819672,
     0.27181737,0.73673592,0.28543724,0.22792783,0.90523485,0.93823619,0.78501439,0.61656516,
     0.07955141,0.18168917,0.29082605,0.65797642,0.32823333,0.81331039,0.57147047,0.69893420,
     0.20831241,0.95777075,0.63984640,0.88738242,0.07848082,0.82684414,0.98029069,0.66526810,
     0.38557133,0.71149557,0.94858490,0.62926765,0.90885914,0.63053097,0.30342354,0.15757158,
     0.00025002,0.79558801,0.12340674,0.15472735,0.91599988,0.26034480,0.37218003,0.31505156,
     0.82802884,0.89673239,0.18346699,0.84168200,0.61789605,0.08168748,0.59156852,0.07958038,
     0.96195833,0.66408685,0.08095598,0.07095613,0.84685589,0.27739931,0.98959400,0.51626225,
     0.84261701,0.54025792,0.37685974,0.02342340,0.92266817,0.77435713,0.77067911,0.51277625,
     0.56118371,0.43209985,0.36942455,0.44084938,0.98089105,0.71676238,0.69984047,0.84869031,
     0.63547183,0.04148475,0.43743286,0.84123202,0.52038168,0.28615072,0.28352163,0.79736192,
     0.47167238,0.59169495,0.81284136,0.19419823,0.34367688,0.12288628,0.73169755,0.23054063,
     0.82395547,0.25653393,0.05918229,0.49808932,0.71105968,0.84663708,0.36985755,0.76035179,
     0.74522674,0.76960632,0.39913976,0.67396122,0.06664612,0.55662705,0.25707708,0.40266841,
     0.60609242,0.40501726,0.54303688,0.91351521,0.22723418,0.70937689,0.99817752,0.67228136,
     0.74630914,0.65870585,0.92889114,0.25387954,0.64329686,0.46943028,0.04378946,0.13098710,
     0.27603392,0.92670784,0.68034038,0.74874919,0.22048594,0.65726347,0.18700630,0.43129192,
     0.53484836,0.65180659,0.40891688,0.53964046,0.31092230,0.15700634,0.67510544,0.93051722,
     0.70192617,0.06589912,0.81070749,0.88715652,0.63461777,0.17327079,0.85346016,0.13309837,
     0.74074193,0.41495818,0.13114635,0.29676602,0.55575998,0.08474479,0.68264860,0.14314954,
     0.38683757,0.10459365,0.81642443,0.79792244,0.61012448,0.11771586,0.75822460,0.07478109,
     0.90581110,0.47274042,0.27752421,0.80769814,0.22061377,0.13478922,0.50175379,0.12971842,
     0.08710200,0.39966582,0.24793967,0.53151429,0.51359819,0.17133100,0.48634444,0.90454564,
     0.35394807,0.77980258,0.95855173,0.85080743,0.83472335,0.50540362,0.95554870,0.33335771,
     0.20280484,0.72904434,0.94055151,0.75802221,0.35794192,0.99512716,0.64422638,0.71713156,
     0.56521412,0.39549143,0.11438263,0.68851566,0.93209728,0.38786572,0.67497578,0.08170274,
     0.78648148,0.01316856,0.64208455,0.69919498,0.70325948,0.25694323,0.06213494,0.75401522,
     0.02352755,0.50620675,0.99215984,0.78649662,0.99722138,0.38401222,0.56054967,0.27620015,
     0.11796089,0.19867418,0.12293884,0.78472313,0.79924393,0.00775441,0.17381195,0.20126848,
     0.20433789,0.12794894,0.58498394,0.40009110,0.43708467,0.90969847,0.81032084,0.28461705,
     0.68974048,0.44176976,0.13168968,0.20271071,0.42777169,0.48731570,0.48192040,0.09814809,
     0.12716694,0.87015685,0.47095372,0.02672373,0.24331047,0.34338493,0.00177808,0.91418113,
     0.19211809,0.90684713,0.52045770,0.98002315,0.31741128,0.38021534,0.60643025,0.34356139,
     0.08454933,0.68452069,0.79046616,0.64493681,0.60069897,0.78646781,0.44859417,0.30481706 
   ];

   my $r = TRandom3->new(4357);
   my $x;

   # check whether the sequence is ok or not
   my $rc1 = 0;
   for (0..999) {
     $x = $r->Rndm();
     if (abs($x-$RefValue->[$_]) > 10e-8) {
       printf("i=%d x=%.8f but should be %.8f\n", $_, $x, $RefValue->[$_]);
       $rc1 += 1;
     }
   }

   # check whether a state can be saved and restored
   my $file = TFile->new("random3.root","RECREATE");
   $file->SetCompressionLevel(0);
   $r->Write("r");
   $file->Close;

   $file = TFile->new("random3.root");
   my $rs = $file->Get("r");
   my $rc2 = 0;
   for (0..999) {
     $rc2 += 1 if ($r->Rndm() - $rs->Rndm() != 0); 
   }
   printf("state restoration failed\n") if ($rc2 != 0);

   return $rc1 + $rc2;
}
sub testrandom {
  testRandom3;
  testAll;
}


testrandom;
