use Config;
use ExtUtils::MakeMaker;

%XS = qw(
         RPM.xs             RPM.c
         RPM/Constants.xs   RPM/Constants.c
         RPM/Database.xs    RPM/Database.c
         RPM/Header.xs      RPM/Header.c
        );

@OBJECT = values %XS;
for (@OBJECT)
{
    s/\.c\b/\$(OBJ_EXT)/g;
}
$OBJECT = join(' ', @OBJECT);

%PM = map { ($from = $_) =~ s/xs$/pm/;
            ($from, "\$(INST_LIBDIR)/$from"); } (sort keys %XS);
$PM{q(RPM/Error.pm)} = '$(INST_LIBDIR)/RPM/Error.pm';

@SAMPLES = qw(utils/rpmprune);
%PL_SCRIPTS = map { sprintf("%s.PL", $_) => "$_" } @SAMPLES;

# This shouldn't be necessary, I don't think, but for now it is
unlink 'RPM/typemap';
symlink '../typemap', 'RPM/typemap';

# Cruft that MakeMaker wouldn't inherently know about
$CLEAN = join(' ', values %XS) . " $OBJECT @SAMPLES";
$CLEAN .= ' pod2html-* */pod2html-* *.html */*.html RPM/typemap';

#
# Check for non-Perl dependancies:
#
print "Checking for required software components...\n";
chomp($rpm_devel = qx(rpm -q rpm-devel 2>/dev/null));
chomp($popt = qx(rpm -q popt 2>/dev/null));
unless ($rpm_devel and $popt)
{
    die "The Perl-RPM package relies on both the popt and rpm-devel packages
being installed. Stopped";
}

WriteMakefile(
              NAME         => 'RPM',
              DISTNAME     => 'Perl-RPM',
              VERSION_FROM => 'RPM.pm',
              LIBS         => '-lrpm -lpopt',
              DEFINE       => '',
              PM           => \%PM,
              XS           => \%XS,
              PL_FILES     => \%PL_SCRIPTS,
              EXE_FILES    => [ @SAMPLES ],
              OBJECT       => $OBJECT,
              INC          => '-I/usr/include/rpm',
              DIR          => [],
              dist         => { COMPRESS => 'gzip -9f' },
              clean        => { FILES => $CLEAN },
             );

sub MY::c_o
{
    package MY; # so that "SUPER" works right

    my $text = shift->SUPER::c_o(@_);

    $text =~ s/CCCMD.*$/$& -o \$*\$(OBJ_EXT)/gm;

    $text;
}

sub MY::postamble
{
    join("\n",
         '',
         (map { "$_: RPM.h\n" } @OBJECT),
         '');
}
