#!/usr/bin/perl
#-------------------------------------------------------------------------------
# Command line build of an Android apk
# Philip R Brenan at gmail dot com, Appa Apps Ltd, 2017
#-------------------------------------------------------------------------------

use warnings FATAL => qw(all);
use strict;
use Android::Build;
use Data::Dump qw(dump);
use Data::Table::Text qw(:all);
use Carp;

my $a = &Android::Build::new();

$a->title        = qq(Generic App);                                             # Title of the app as seen under the icon
$a->domain       = qq(com.appaapps);                                            # Domain name in reverse order
$a->activity     = qq(Activity);                                                # Name of Activity = $activity.java file containing onCreate() for this app
$a->icon         = qq(~/images/Jets/EEL.jpg);                                   # Image that will be scaled to make an icon using Imagemagick
$a->sdk          = qq(~/Android/sdk/);                                          # Android SDK on the local machine
$a->sdkLevels    = [15,25];                                                     # Min sdk, target sdk for manifest
$a->androidJar   = $a->sdk."platforms/android-25/android.jar";                  # Android sdk jar
$a->keyAlias     = qq(xxx);                                                     # Alias of key to be used to sign this app
$a->keyStoreFile = qq(~/keystore/release-key.keystore);                         # Key store file
$a->keyStorePwd  = qq(xxx);                                                     # Password for keystore

$a->build(qw(run));
