#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Future;

use Future::AsyncAwait qw( async );

my $before;
my $after;

async sub identity
{
   $before++;
   await $_[0];
   $after++;

   return "done";
}

# scalar
{
   my $f1 = Future->new;
   my $f2 = identity( $f1 );

   ok(  $before, 'Code before await is invoked' );
   ok( !$after,  'Code after await not yet invoked' );

   isa_ok( $f2, "Future", 'identity() returns a Future' ) and do {
      ok( !$f2->is_ready, '$f2 is not immediate for pending scalar' );
   };

   $f1->done( "result" );

   ok( $after, 'Code after await now invoked' );

   is( scalar $f2->get, "done", '$f2->get for done scalar' );
}

done_testing;
