package Bencher::Scenario::JSONDecodeRegexp;

our $DATE = '2016-09-03'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark JSON decoding',
    participants => [
        {
            fcall_template => 'JSON::Decode::Regexp::from_json(<data>)',
        },
        {
            fcall_template => 'JSON::PP::decode_json(<data>)',
        },
    ],
    datasets => [
        {name => 'array0'  , args=>{data=>'[]'}},
        {name => 'array1'  , args=>{data=>'[1]'}},
        {name => 'array10' , args=>{data=>'[1,2,3,4,5,6,7,8,9,10]'}},
        {name => 'array100', args=>{data=>'[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100]'}},
        {name => 'hash0'   , args=>{data=>'{}'}},
        {name => 'hash1'   , args=>{data=>'{"1":1}'}},
        {name => 'hash10'  , args=>{data=>'{"01":1,"02":1,"03":1,"04":1,"05":1,"06":1,"07":1,"08":1,"09":1,"10":1}'}},
        {name => 'hash100' , args=>{data=>'{"001":1,"002":1,"003":1,"004":1,"005":1,"006":1,"007":1,"008":1,"009":1,"010":1,"011":1,"012":1,"013":1,"014":1,"015":1,"016":1,"017":1,"018":1,"019":1,"020":1,"021":1,"022":1,"023":1,"024":1,"025":1,"026":1,"027":1,"028":1,"029":1,"030":1,"031":1,"032":1,"033":1,"034":1,"035":1,"036":1,"037":1,"038":1,"039":1,"040":1,"041":1,"042":1,"043":1,"044":1,"045":1,"046":1,"047":1,"048":1,"049":1,"050":1,"051":1,"052":1,"053":1,"054":1,"055":1,"056":1,"057":1,"058":1,"059":1,"060":1,"061":1,"062":1,"063":1,"064":1,"065":1,"066":1,"067":1,"068":1,"069":1,"070":1,"071":1,"072":1,"073":1,"074":1,"075":1,"076":1,"077":1,"078":1,"079":1,"080":1,"081":1,"082":1,"083":1,"084":1,"085":1,"086":1,"087":1,"088":1,"089":1,"090":1,"091":1,"092":1,"093":1,"094":1,"095":1,"096":1,"097":1,"098":1,"099":1,"100":1}'}},
    ],
};

1;
# ABSTRACT: Benchmark JSON decoding

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::JSONDecodeRegexp - Benchmark JSON decoding

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::JSONDecodeRegexp (from Perl distribution Bencher-Scenarios-JSONDecodeRegexp), released on 2016-09-03.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m JSONDecodeRegexp

To run module startup overhead benchmark:

 % bencher --module-startup -m JSONDecodeRegexp

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<JSON::Decode::Regexp> 0.08

L<JSON::PP> 2.27300

=head1 BENCHMARK PARTICIPANTS

=over

=item * JSON::Decode::Regexp::from_json (perl_code)

Function call template:

 JSON::Decode::Regexp::from_json(<data>)



=item * JSON::PP::decode_json (perl_code)

Function call template:

 JSON::PP::decode_json(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * array0

=item * array1

=item * array10

=item * array100

=item * hash0

=item * hash1

=item * hash10

=item * hash100

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with C<< bencher -m JSONDecodeRegexp --include-path archive/JSON-Decode-Regexp-0.03/lib --include-path archive/JSON-Decode-Regexp-0.04/lib --include-path archive/JSON-Decode-Regexp-0.06/lib --include-path archive/JSON-Decode-Regexp-0.07/lib --multimodver JSON::Decode::Regexp >>:

 #table1#
 {dataset=>"array0"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.04   |     10000 |     97    |        1   | 2.4e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |     12000 |     84    |        1.2 | 2.3e-07 |      21 |
 | JSON::Decode::Regexp::from_json | 0.03   |     17000 |     58    |        1.7 | 1.9e-07 |      24 |
 | JSON::PP::decode_json           |        |    190000 |      5.3  |       18   | 6.7e-09 |      20 |
 | JSON::Decode::Regexp::from_json | 0.08   |    281000 |      3.55 |       27.3 | 1.4e-09 |      30 |
 | JSON::Decode::Regexp::from_json | 0.07   |    284000 |      3.52 |       27.6 | 1.5e-09 |      25 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"array1"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.04   |     10000 |     100   |        1   | 1.1e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |     11000 |      87   |        1.2 | 1.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.03   |     15000 |      68   |        1.5 |   8e-08 |      20 |
 | JSON::PP::decode_json           |        |    110000 |       9.5 |       11   | 2.7e-08 |      20 |
 | JSON::Decode::Regexp::from_json | 0.08   |    180000 |       5.7 |       18   | 6.5e-09 |      21 |
 | JSON::Decode::Regexp::from_json | 0.07   |    182000 |       5.5 |       18.3 | 1.7e-09 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"array10"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.04   |      7400 |     130   |       1    | 1.1e-06 |      21 |
 | JSON::Decode::Regexp::from_json | 0.03   |      7600 |     130   |       1    | 2.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |      8900 |     110   |       1.2  | 2.5e-07 |      23 |
 | JSON::PP::decode_json           |        |     25000 |      40   |       3.4  | 5.3e-08 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |     39000 |      25.6 |       5.26 | 1.2e-08 |      24 |
 | JSON::Decode::Regexp::from_json | 0.08   |     39100 |      25.6 |       5.27 | 1.3e-08 |      21 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"array100"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |      1300 |       800 |       1    | 1.4e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.04   |      2400 |       420 |       1.9  | 1.3e-06 |      22 |
 | JSON::PP::decode_json           |        |      2700 |       380 |       2.1  | 5.5e-07 |      23 |
 | JSON::Decode::Regexp::from_json | 0.06   |      3380 |       296 |       2.71 | 2.5e-07 |      22 |
 | JSON::Decode::Regexp::from_json | 0.08   |      4550 |       220 |       3.64 | 1.4e-07 |      27 |
 | JSON::Decode::Regexp::from_json | 0.07   |      5100 |       200 |       4.1  |   2e-07 |      22 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"hash0"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.04   |     10000 |     97    |        1   | 3.4e-07 |      21 |
 | JSON::Decode::Regexp::from_json | 0.06   |     12000 |     84    |        1.1 | 1.7e-07 |      23 |
 | JSON::Decode::Regexp::from_json | 0.03   |     18000 |     56    |        1.7 | 1.9e-07 |      24 |
 | JSON::PP::decode_json           |        |    188000 |      5.31 |       18.2 | 1.6e-09 |      21 |
 | JSON::Decode::Regexp::from_json | 0.08   |    320000 |      3.1  |       31   | 6.2e-09 |      23 |
 | JSON::Decode::Regexp::from_json | 0.07   |    380000 |      2.6  |       37   | 3.3e-09 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"hash1"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.04   |      8000 |     100   |       1    | 1.4e-06 |      23 |
 | JSON::Decode::Regexp::from_json | 0.06   |      9200 |     110   |       1.1  | 2.5e-07 |      22 |
 | JSON::Decode::Regexp::from_json | 0.03   |     11000 |      92   |       1.3  | 1.9e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.08   |     66000 |      15   |       8    | 2.7e-08 |      20 |
 | JSON::PP::decode_json           |        |     72300 |      13.8 |       8.67 | 6.7e-09 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |     75000 |      13   |       9    | 2.7e-08 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"hash10"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |      4600 |       217 |        1   | 2.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |      5100 |       200 |        1.1 |   2e-07 |      22 |
 | JSON::Decode::Regexp::from_json | 0.04   |      6000 |       200 |        1   |   2e-06 |      25 |
 | JSON::Decode::Regexp::from_json | 0.08   |      9600 |       100 |        2.1 | 1.9e-07 |      26 |
 | JSON::Decode::Regexp::from_json | 0.07   |     11000 |        90 |        2.4 | 1.1e-07 |      20 |
 | JSON::PP::decode_json           |        |     13000 |        80 |        2.7 | 1.9e-07 |      33 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"hash100"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |       444 |     2.25  |       1    | 1.8e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |      1020 |     0.982 |       2.29 | 8.5e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.04   |      1040 |     0.965 |       2.33 | 8.5e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.08   |      1120 |     0.892 |       2.53 | 6.9e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |      1150 |     0.868 |       2.6  | 4.3e-07 |      20 |
 | JSON::PP::decode_json           |        |      1320 |     0.756 |       2.98 | 2.7e-07 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-JSONDecodeRegexp>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-JSONDecodeRegexp>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-JSONDecodeRegexp>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
