/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mjpeg;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class MJPEGGenerator {
    int width = 0;
    int height = 0;
    double framerate = 0.0;
    int numFrames = 0;
    File aviFile = null;
    FileOutputStream aviOutput = null;
    FileChannel aviChannel = null;
    long riffOffset = 0L;
    long aviMovieOffset = 0L;
    AVIIndexList indexlist = null;

    public MJPEGGenerator(File file, int n, int n2, double d, int n3) throws IOException {
        this.aviFile = file;
        this.width = n;
        this.height = n2;
        this.framerate = d;
        this.numFrames = n3;
        this.aviOutput = new FileOutputStream(file);
        this.aviChannel = this.aviOutput.getChannel();
        RIFFHeader rIFFHeader = new RIFFHeader();
        this.aviOutput.write(rIFFHeader.toBytes());
        this.aviOutput.write(new AVIMainHeader().toBytes());
        this.aviOutput.write(new AVIStreamList().toBytes());
        this.aviOutput.write(new AVIStreamHeader().toBytes());
        this.aviOutput.write(new AVIStreamFormat().toBytes());
        this.aviOutput.write(new AVIJunk().toBytes());
        this.aviMovieOffset = this.aviChannel.position();
        this.aviOutput.write(new AVIMovieList().toBytes());
        this.indexlist = new AVIIndexList();
    }

    public void addImage(Image image) throws IOException {
        long l;
        byte[] byArray = new byte[]{48, 48, 100, 98};
        byte[] byArray2 = this.writeImageToBytes(image);
        int n = byArray2.length;
        int n2 = (n + (int)(l = this.aviChannel.position())) % 4;
        if (n2 > 0) {
            n += n2;
        }
        this.indexlist.addAVIIndex((int)l, n);
        this.aviOutput.write(byArray);
        this.aviOutput.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(n)));
        this.aviOutput.write(byArray2);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                this.aviOutput.write(0);
            }
        }
        byArray2 = null;
    }

    public void finishAVI() throws IOException {
        byte[] byArray = this.indexlist.toBytes();
        this.aviOutput.write(byArray);
        this.aviOutput.close();
        long l = this.aviFile.length();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.aviFile, "rw");
        randomAccessFile.seek(4L);
        randomAccessFile.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt((int)l - 8)));
        randomAccessFile.seek(this.aviMovieOffset + 4L);
        randomAccessFile.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt((int)(l - 8L - this.aviMovieOffset - (long)byArray.length))));
        randomAccessFile.close();
    }

    public static int swapInt(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public static short swapShort(short s) {
        return (short)(s >>> 8 | s << 8);
    }

    public static byte[] intBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] shortBytes(short s) {
        byte[] byArray = new byte[]{(byte)(s >>> 8), (byte)(s & 0xFF)};
        return byArray;
    }

    private byte[] writeImageToBytes(Image image) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, this.width, this.height, null);
        ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        byteArrayOutputStream.close();
        bufferedImage = null;
        graphics2D = null;
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        double d = 12.0;
        double d2 = 1.0;
        double d3 = 3.0;
        File file = new File(stringArray[0]);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith("jpg");
            }
        });
        int n = (int)((double)fileArray.length * d * (d3 + d2) + d2 * d);
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(new File(stringArray[1]), 640, 480, d, n);
        for (int i = 0; i < fileArray.length; ++i) {
            System.out.println("processing file " + i);
            ImageIcon imageIcon = new ImageIcon(fileArray[i].getCanonicalPath());
            mJPEGGenerator.addImage(imageIcon.getImage());
        }
        mJPEGGenerator.finishAVI();
    }

    private class AVIJunk {
        public byte[] fcc = new byte[]{74, 85, 78, 75};
        public int size = 1808;
        public byte[] data = new byte[this.size];

        public AVIJunk() {
            Arrays.fill(this.data, (byte)0);
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.size)));
            byteArrayOutputStream.write(this.data);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIIndex {
        public byte[] fcc = new byte[]{48, 48, 100, 98};
        public int dwFlags = 16;
        public int dwOffset = 0;
        public int dwSize = 0;

        public AVIIndex(int n, int n2) {
            this.dwOffset = n;
            this.dwSize = n2;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwFlags)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwOffset)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwSize)));
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIIndexList {
        public byte[] fcc = new byte[]{105, 100, 120, 49};
        public int cb = 0;
        public ArrayList ind = new ArrayList();

        public void addAVIIndex(AVIIndex aVIIndex) {
            this.ind.add(aVIIndex);
        }

        public void addAVIIndex(int n, int n2) {
            this.ind.add(new AVIIndex(n, n2));
        }

        public byte[] toBytes() throws IOException {
            this.cb = 16 * this.ind.size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.cb)));
            for (int i = 0; i < this.ind.size(); ++i) {
                AVIIndex aVIIndex = (AVIIndex)this.ind.get(i);
                byteArrayOutputStream.write(aVIIndex.toBytes());
            }
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIMovieList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int listSize = 0;
        public byte[] fcc2 = new byte[]{109, 111, 118, 105};

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.listSize)));
            byteArrayOutputStream.write(this.fcc2);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIStreamFormat {
        public byte[] fcc = new byte[]{115, 116, 114, 102};
        public int cb = 40;
        public int biSize = 40;
        public int biWidth = 0;
        public int biHeight = 0;
        public short biPlanes = 1;
        public short biBitCount = (short)24;
        public byte[] biCompression = new byte[]{77, 74, 80, 71};
        public int biSizeImage = 0;
        public int biXPelsPerMeter = 0;
        public int biYPelsPerMeter = 0;
        public int biClrUsed = 0;
        public int biClrImportant = 0;

        public AVIStreamFormat() {
            this.biWidth = MJPEGGenerator.this.width;
            this.biHeight = MJPEGGenerator.this.height;
            this.biSizeImage = MJPEGGenerator.this.width * MJPEGGenerator.this.height;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.cb)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biSize)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biWidth)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biHeight)));
            byteArrayOutputStream.write(MJPEGGenerator.shortBytes(MJPEGGenerator.swapShort(this.biPlanes)));
            byteArrayOutputStream.write(MJPEGGenerator.shortBytes(MJPEGGenerator.swapShort(this.biBitCount)));
            byteArrayOutputStream.write(this.biCompression);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biSizeImage)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biXPelsPerMeter)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biYPelsPerMeter)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biClrUsed)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.biClrImportant)));
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIStreamHeader {
        public byte[] fcc = new byte[]{115, 116, 114, 104};
        public int cb = 64;
        public byte[] fccType = new byte[]{118, 105, 100, 115};
        public byte[] fccHandler = new byte[]{77, 74, 80, 71};
        public int dwFlags = 0;
        public short wPriority = 0;
        public short wLanguage = 0;
        public int dwInitialFrames = 0;
        public int dwScale = 0;
        public int dwRate = 1000000;
        public int dwStart = 0;
        public int dwLength = 0;
        public int dwSuggestedBufferSize = 0;
        public int dwQuality = -1;
        public int dwSampleSize = 0;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        public AVIStreamHeader() {
            this.dwScale = (int)(1.0 / MJPEGGenerator.this.framerate * 1000000.0);
            this.dwLength = MJPEGGenerator.this.numFrames;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.cb)));
            byteArrayOutputStream.write(this.fccType);
            byteArrayOutputStream.write(this.fccHandler);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwFlags)));
            byteArrayOutputStream.write(MJPEGGenerator.shortBytes(MJPEGGenerator.swapShort(this.wPriority)));
            byteArrayOutputStream.write(MJPEGGenerator.shortBytes(MJPEGGenerator.swapShort(this.wLanguage)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwInitialFrames)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwScale)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwRate)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwStart)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwLength)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwSuggestedBufferSize)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwQuality)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwSampleSize)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.left)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.top)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.right)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.bottom)));
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIStreamList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int size = 124;
        public byte[] fcc2 = new byte[]{115, 116, 114, 108};

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.size)));
            byteArrayOutputStream.write(this.fcc2);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class AVIMainHeader {
        public byte[] fcc = new byte[]{97, 118, 105, 104};
        public int cb = 56;
        public int dwMicroSecPerFrame = 0;
        public int dwMaxBytesPerSec = 10000000;
        public int dwPaddingGranularity = 0;
        public int dwFlags = 65552;
        public int dwTotalFrames = 0;
        public int dwInitialFrames = 0;
        public int dwStreams = 1;
        public int dwSuggestedBufferSize = 0;
        public int dwWidth = 0;
        public int dwHeight = 0;
        public int[] dwReserved = new int[4];

        public AVIMainHeader() {
            this.dwMicroSecPerFrame = (int)(1.0 / MJPEGGenerator.this.framerate * 1000000.0);
            this.dwWidth = MJPEGGenerator.this.width;
            this.dwHeight = MJPEGGenerator.this.height;
            this.dwTotalFrames = MJPEGGenerator.this.numFrames;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.cb)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwMicroSecPerFrame)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwMaxBytesPerSec)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwPaddingGranularity)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwFlags)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwTotalFrames)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwInitialFrames)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwStreams)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwSuggestedBufferSize)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwWidth)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwHeight)));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwReserved[0])));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwReserved[1])));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwReserved[2])));
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.dwReserved[3])));
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private class RIFFHeader {
        public byte[] fcc = new byte[]{82, 73, 70, 70};
        public int fileSize = 0;
        public byte[] fcc2 = new byte[]{65, 86, 73, 32};
        public byte[] fcc3 = new byte[]{76, 73, 83, 84};
        public int listSize = 200;
        public byte[] fcc4 = new byte[]{104, 100, 114, 108};

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.fcc);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.fileSize)));
            byteArrayOutputStream.write(this.fcc2);
            byteArrayOutputStream.write(this.fcc3);
            byteArrayOutputStream.write(MJPEGGenerator.intBytes(MJPEGGenerator.swapInt(this.listSize)));
            byteArrayOutputStream.write(this.fcc4);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }
}

