#############################################################
# This file was automatically generated on 2020-05-19.      #
#                                                           #
# Perl Bindings Version 2.1.27                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletAccelerometerV2 - Measures acceleration in three axis

=cut

package Tinkerforge::BrickletAccelerometerV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Accelerometer Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2130;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Accelerometer Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'Accelerometer Bricklet 2.0';

=item CALLBACK_ACCELERATION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ACCELERATION callback.

=cut

use constant CALLBACK_ACCELERATION => 8;

=item CALLBACK_CONTINUOUS_ACCELERATION_16_BIT

This constant is used with the register_callback() subroutine to specify
the CALLBACK_CONTINUOUS_ACCELERATION_16_BIT callback.

=cut

use constant CALLBACK_CONTINUOUS_ACCELERATION_16_BIT => 11;

=item CALLBACK_CONTINUOUS_ACCELERATION_8_BIT

This constant is used with the register_callback() subroutine to specify
the CALLBACK_CONTINUOUS_ACCELERATION_8_BIT callback.

=cut

use constant CALLBACK_CONTINUOUS_ACCELERATION_8_BIT => 12;

=item FUNCTION_GET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION => 1;

=item FUNCTION_SET_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CONFIGURATION => 2;

=item FUNCTION_GET_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CONFIGURATION => 3;

=item FUNCTION_SET_ACCELERATION_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ACCELERATION_CALLBACK_CONFIGURATION => 4;

=item FUNCTION_GET_ACCELERATION_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION_CALLBACK_CONFIGURATION => 5;

=item FUNCTION_SET_INFO_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_INFO_LED_CONFIG => 6;

=item FUNCTION_GET_INFO_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_INFO_LED_CONFIG => 7;

=item FUNCTION_SET_CONTINUOUS_ACCELERATION_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CONTINUOUS_ACCELERATION_CONFIGURATION => 9;

=item FUNCTION_GET_CONTINUOUS_ACCELERATION_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CONTINUOUS_ACCELERATION_CONFIGURATION => 10;

=item FUNCTION_SET_FILTER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FILTER_CONFIGURATION => 13;

=item FUNCTION_GET_FILTER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FILTER_CONFIGURATION => 14;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant DATA_RATE_0_781HZ => 0;
use constant DATA_RATE_1_563HZ => 1;
use constant DATA_RATE_3_125HZ => 2;
use constant DATA_RATE_6_2512HZ => 3;
use constant DATA_RATE_12_5HZ => 4;
use constant DATA_RATE_25HZ => 5;
use constant DATA_RATE_50HZ => 6;
use constant DATA_RATE_100HZ => 7;
use constant DATA_RATE_200HZ => 8;
use constant DATA_RATE_400HZ => 9;
use constant DATA_RATE_800HZ => 10;
use constant DATA_RATE_1600HZ => 11;
use constant DATA_RATE_3200HZ => 12;
use constant DATA_RATE_6400HZ => 13;
use constant DATA_RATE_12800HZ => 14;
use constant DATA_RATE_25600HZ => 15;
use constant FULL_SCALE_2G => 0;
use constant FULL_SCALE_4G => 1;
use constant FULL_SCALE_8G => 2;
use constant INFO_LED_CONFIG_OFF => 0;
use constant INFO_LED_CONFIG_ON => 1;
use constant INFO_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant RESOLUTION_8BIT => 0;
use constant RESOLUTION_16BIT => 1;
use constant IIR_BYPASS_APPLIED => 0;
use constant IIR_BYPASS_BYPASSED => 1;
use constant LOW_PASS_FILTER_NINTH => 0;
use constant LOW_PASS_FILTER_HALF => 1;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 1], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ACCELERATION_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_INFO_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_INFO_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CONTINUOUS_ACCELERATION_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CONTINUOUS_ACCELERATION_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FILTER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_FILTER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_ACCELERATION} = shared_clone([20, 'l l l']);
	$self->{callback_formats}->{&CALLBACK_CONTINUOUS_ACCELERATION_16_BIT} = shared_clone([68, 's30']);
	$self->{callback_formats}->{&CALLBACK_CONTINUOUS_ACCELERATION_8_BIT} = shared_clone([68, 'c60']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_acceleration()

Returns the acceleration in x, y and z direction. The values
are given in gₙ/10000 (1gₙ = 9.80665m/s²). The range is
configured with :func:`Set Configuration`.

If you want to get the acceleration periodically, it is recommended
to use the :cb:`Acceleration` callback and set the period with
:func:`Set Acceleration Callback Configuration`.

=cut

sub get_acceleration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION, [], '', 20, 'l l l');
}

=item set_configuration()

Configures the data rate and full scale range.
Possible values are:

* Data rate of 0.781Hz to 25600Hz.
* Full scale range of ±2g up to ±8g.

Decreasing data rate or full scale range will also decrease the noise on
the data.

=cut

sub set_configuration
{
	my ($self, $data_rate, $full_scale) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CONFIGURATION, [$data_rate, $full_scale], 'C C', 0, '');
}

=item get_configuration()

Returns the configuration as set by :func:`Set Configuration`.

=cut

sub get_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CONFIGURATION, [], '', 10, 'C C');
}

=item set_acceleration_callback_configuration()

The period is the period with which the :cb:`Acceleration`
callback is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

If this callback is enabled, the :cb:`Continuous Acceleration 16 Bit` callback
and :cb:`Continuous Acceleration 8 Bit` callback will automatically be disabled.

=cut

sub set_acceleration_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ACCELERATION_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', 0, '');
}

=item get_acceleration_callback_configuration()

Returns the callback configuration as set by
:func:`Set Acceleration Callback Configuration`.

=cut

sub get_acceleration_callback_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION_CALLBACK_CONFIGURATION, [], '', 13, 'L ?');
}

=item set_info_led_config()

Configures the info LED (marked as "Force" on the Bricklet) to be either turned off,
turned on, or blink in heartbeat mode.

=cut

sub set_info_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_INFO_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_info_led_config()

Returns the LED configuration as set by :func:`Set Info LED Config`

=cut

sub get_info_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_INFO_LED_CONFIG, [], '', 9, 'C');
}

=item set_continuous_acceleration_configuration()

For high throughput of acceleration data (> 1000Hz) you have to use the
:cb:`Continuous Acceleration 16 Bit` or :cb:`Continuous Acceleration 8 Bit`
callbacks.

You can enable the callback for each axis (x, y, z) individually and choose a
resolution of 8 bit or 16 bit.

If at least one of the axis is enabled and the resolution is set to 8 bit,
the :cb:`Continuous Acceleration 8 Bit` callback is activated. If at least
one of the axis is enabled and the resolution is set to 16 bit,
the :cb:`Continuous Acceleration 16 Bit` callback is activated.

The returned values are raw ADC data. If you want to put this data into
a FFT to determine the occurrences of specific frequencies we recommend
that you use the data as is. It has all of the ADC noise in it. This noise
looks like pure noise at first glance, but it might still have some frequnecy
information in it that can be utilized by the FFT.

Otherwise you have to use the following formulas that depend on the configured
resolution (8/16 bit) and the full scale range (see :func:`Set Configuration`) to calculate
the data in gₙ/10000 (same unit that is returned by :func:`Get Acceleration`):

* 16 bit, full scale 2g: acceleration = value * 625 / 1024
* 16 bit, full scale 4g: acceleration = value * 1250 / 1024
* 16 bit, full scale 8g: acceleration = value * 2500 / 1024

If a resolution of 8 bit is used, only the 8 most significant bits will be
transferred, so you can use the following formulas:

* 8 bit, full scale 2g: acceleration = value * 256 * 625 / 1024
* 8 bit, full scale 4g: acceleration = value * 256 * 1250 / 1024
* 8 bit, full scale 8g: acceleration = value * 256 * 2500 / 1024

If no axis is enabled, both callbacks are disabled. If one of the continuous
callbacks is enabled, the :cb:`Acceleration` callback is disabled.

The maximum throughput depends on the exact configuration:

.. csv-table::
 :header: "Number of axis enabled", "Throughput 8 bit", "Throughout 16 bit"
 :widths: 20, 20, 20

 "1", "25600Hz", "25600Hz"
 "2", "25600Hz", "15000Hz"
 "3", "20000Hz", "10000Hz"

=cut

sub set_continuous_acceleration_configuration
{
	my ($self, $enable_x, $enable_y, $enable_z, $resolution) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CONTINUOUS_ACCELERATION_CONFIGURATION, [$enable_x, $enable_y, $enable_z, $resolution], '? ? ? C', 0, '');
}

=item get_continuous_acceleration_configuration()

Returns the continuous acceleration configuration as set by
:func:`Set Continuous Acceleration Configuration`.

=cut

sub get_continuous_acceleration_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CONTINUOUS_ACCELERATION_CONFIGURATION, [], '', 12, '? ? ? C');
}

=item set_filter_configuration()

Configures IIR Bypass filter mode and low pass filter roll off corner frequency.

The filter can be applied or bypassed and the corner frequency can be
half or a ninth of the output data rate.

.. image:: /Images/Bricklets/bricklet_accelerometer_v2_filter.png
   :scale: 100 %
   :alt: Accelerometer filter
   :align: center
   :target: ../../_images/Bricklets/bricklet_accelerometer_v2_filter.png

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_filter_configuration
{
	my ($self, $iir_bypass, $low_pass_filter) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_FILTER_CONFIGURATION, [$iir_bypass, $low_pass_filter], 'C C', 0, '');
}

=item get_filter_configuration()

Returns the configuration as set by :func:`Set Filter Configuration`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_filter_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_FILTER_CONFIGURATION, [], '', 10, 'C C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 24, 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 9, 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 9, 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', 0, '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 9, 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 9, 'C');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', 0, '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
The Raspberry Pi HAT (Zero) Brick is always at position 'i' and the Bricklet
connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always as
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
