## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Ka_t8m v1.1.3;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Ka_t8m::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Ka_t8m> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-ka.t8m.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: georgian (ka)
% encoding: t8m
%
% This file has been auto-generated from hyph-ka.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"A1="A1
\lccode"A2="A2
\lccode"A3="A3
\lccode"A4="A4
\lccode"A5="A5
\lccode"A6="A6
\lccode"A7="A7
\lccode"A8="A8
\lccode"A9="A9
\lccode"AA="AA
\lccode"AB="AB
\lccode"AC="AC
\lccode"AD="AD
\lccode"AE="AE
\lccode"AF="AF
\lccode"B0="B0
\lccode"B1="B1
\lccode"B2="B2
\lccode"B3="B3
\lccode"B4="B4
\lccode"B5="B5
\lccode"B6="B6
\lccode"B7="B7
\lccode"B8="B8
\lccode"B9="B9
\lccode"BA="BA
\lccode"BB="BB
\lccode"BC="BC
\lccode"E0="E0
\lccode"E1="E1
\lccode"E2="E2
\lccode"E3="E3
\lccode"E4="E4
\patterns{
.^^a1^^a64^^b1^^e0^^b8^^a1
.^^a1^^a92^^a1
.^^a5^^b12^^a8^^e2
.^^a5^^b12^^b3
.^^a9^^b12^^b3
.^^b4^^b12^^b3
.^^b4^^b5^^b12
.^^b5^^b12
^^a11^^a1
^^a11^^a2
^^a1^^a23^^ab^^a4
^^a1^^a23^^ad^^a6
^^a1^^a23^^b1^^aa
^^a1^^a2^^b13^^e0
^^a1^^a23^^b2^^aa
^^a1^^a23^^b2^^b3
^^a11^^a3
^^a1^^a33^^a3^^a6
^^a1^^a33^^a3^^a7
^^a1^^a33^^a6^^a2
^^a1^^a33^^a6^^a4
^^a1^^a33^^a6^^a8
^^a1^^a33^^a6^^aa
^^a1^^a33^^a6^^ab
^^a1^^a33^^a6^^ac
^^a1^^a33^^a6^^ad
^^a1^^a33^^a6^^b1
^^a1^^a33^^a6^^b2
^^a1^^a33^^a6^^b6
^^a1^^a33^^a6^^b8
^^a1^^a33^^a6^^b9
^^a1^^a33^^a6^^ba
^^a1^^a33^^a6^^bb
^^a1^^a33^^a6^^bc
^^a1^^a33^^a6^^e0
^^a1^^a33^^a6^^e1
^^a1^^a33^^a6^^e2
^^a1^^a33^^a7^^ab
^^a1^^a33^^a7^^ad
^^a12^^a31^^ab
^^a12^^a31^^ac
^^a1^^a33^^ac^^ad
^^a1^^a33^^b1^^ba
^^a1^^a33^^b2^^a6
^^a1^^a33^^b2^^ac
^^a1^^a33^^b2^^e2
^^a1^^a33^^b8^^a6
^^a12^^a3^^b9
^^a1^^a33^^b9^^a9
^^a1^^a33^^bb^^a4
^^a1^^a33^^bc^^a6
^^a1^^a33^^bc^^b1
^^a1^^a33^^e1^^b1
^^a1^^a33^^e2^^a6
^^a1^^a33^^e2^^b2
^^a11^^a4
^^a1^^a43^^a3^^ad
^^a12^^a41^^a7
^^a1^^a43^^ab^^ac
^^a1^^a43^^ab^^b5
^^a1^^a43^^ac^^b8
^^a12^^a41^^ad
^^a11^^a5
^^a11^^a6
^^a1^^a63^^a2^^ad
^^a1^^a63^^a2^^b1
^^a1^^a63^^a3^^a7
^^a1^^a63^^a4^^a3
^^a1^^a63^^a7^^a6
^^a1^^a63^^a7^^b9
^^a1^^a63^^a8^^a2
^^a1^^a63^^a8^^ac
^^a1^^a63^^aa^^ac
^^a1^^a63^^aa^^b1
^^a1^^a63^^ab^^a4
^^a1^^a63^^ab^^ad
^^a1^^a63^^ac^^a4
^^a1^^a63^^ac^^b2
^^a1^^a63^^ac^^b9
^^a1^^a63^^ac^^e3
^^a1^^a63^^ad^^a4
^^a1^^a63^^ad^^bc
^^a1^^a63^^b1^^a2
^^a1^^a63^^b1^^a4
^^a1^^a63^^b1^^a8
^^a1^^a63^^b1^^aa
^^a1^^a63^^b1^^ac
^^a1^^a63^^b1^^ba
^^a1^^a63^^b1^^bb
^^a1^^a63^^b1^^e0
^^a1^^a63^^b2^^a4
^^a1^^a63^^b2^^a6
^^a1^^a63^^b2^^a8
^^a1^^a63^^b2^^aa
^^a1^^a63^^b2^^ac
^^a1^^a63^^b2^^b3
^^a1^^a63^^b2^^bc
^^a1^^a63^^b2^^e0
^^a1^^a63^^b2^^e2
^^a1^^a63^^b2^^e3
^^a1^^a63^^b3^^a6
^^a1^^a63^^b8^^a6
^^a1^^a63^^b8^^b1
^^a1^^a63^^b9^^a6
^^a1^^a63^^b9^^ab
^^a1^^a63^^b9^^ad
^^a1^^a63^^b9^^b1
^^a1^^a63^^b9^^b3
^^a1^^a63^^bb^^a4
^^a1^^a63^^bb^^ab
^^a1^^a63^^bb^^ad
^^a1^^a63^^bc^^a6
^^a1^^a63^^bc^^b1
^^a1^^a63^^e0^^a6
^^a1^^a63^^e1^^b1
^^a1^^a63^^e2^^a4
^^a1^^a63^^e2^^a6
^^a1^^a63^^e2^^b2
^^a1^^a63^^e2^^b3
^^a1^^a63^^e3^^a4
^^a11^^a7
^^a1^^a73^^b1^^a4
^^a1^^a73^^b1^^a7
^^a1^^a73^^b1^^a8
^^a1^^a73^^b1^^ac
^^a1^^a73^^b2^^aa
^^a11^^a8
1^^a1^^a8^^a1^^b2
^^a1^^a83^^a3^^a6
^^a1^^a83^^a3^^b1
^^a12^^a81^^a6
^^a1^^a83^^a6^^ab
^^a1^^a83^^a6^^b1
^^a1^^a83^^aa^^a6
^^a12^^a81^^ab
^^a1^^a83^^ac^^b5
^^a1^^a83^^ac^^b8
^^a1^^a83^^b1^^a3
^^a13^^a82^^b6^^ae
^^a11^^a9
^^a11^^aa
^^a1^^aa^^a1^^b14^^a3^^b2.
^^a12^^aa^^a2
^^a1^^aa3^^a2^^a5
^^a1^^aa1^^a4
^^a1^^aa3^^a6^^a4
^^a1^^aa3^^a6^^a8
^^a1^^aa3^^a6^^ab
^^a1^^aa3^^a6^^ad
^^a1^^aa3^^a6^^b1
^^a1^^aa3^^ab^^a4
^^a1^^aa3^^ab^^a8
^^a1^^aa3^^b1^^a8
^^a11^^ab
^^a1^^ab3^^a3^^a6
^^a1^^ab3^^a3^^a7
^^a1^^ab3^^a4^^b9
^^a1^^ab3^^a8^^ac
^^a1^^ab3^^ac^^a4
^^a1^^ab3^^ac^^e2
^^a1^^ab3^^b2^^aa
^^a1^^ab3^^b2^^b3
^^a1^^ab3^^b3^^a2
^^a1^^ab3^^b3^^b1
^^a1^^ab3^^b7^^b1
^^a1^^ab3^^b8^^a7
^^a1^^ab3^^b9^^a6
^^a1^^ab3^^bb^^b1
^^a1^^ab3^^e0^^a6
^^a1^^ab3^^e2^^a7
^^a1^^ab3^^e2^^a8
^^a1^^ab3^^e2^^b2
^^a1^^ab3^^e2^^b9
^^a11^^ac
2^^a1^^ac^^a2^^a1^^a6^^a9.
^^a1^^ac3^^a2^^ab
^^a1^^ac3^^a2^^ad
^^a1^^ac3^^a2^^b1
^^a1^^ac3^^a3^^a6
^^a1^^ac3^^a3^^a7
^^a1^^ac3^^a3^^b1
^^a1^^ac3^^a4^^a3
^^a1^^ac3^^a4^^a6
^^a1^^ac3^^a6^^ab
^^a1^^ac3^^a7^^b1
^^a1^^ac3^^a8^^b1
^^a1^^ac3^^a8^^b6
^^a1^^ac3^^aa^^a6
^^a1^^ac3^^aa^^ab
^^a1^^ac3^^aa^^b1
^^a1^^ac3^^ab^^a7
^^a1^^ac3^^ad^^a8
^^a1^^ac3^^af^^ab
^^a1^^ac3^^b1^^a3
^^a1^^ac3^^b1^^a8
^^a1^^ac3^^b1^^b3
^^a1^^ac3^^b1^^b7
^^a1^^ac3^^b1^^ba
^^a1^^ac3^^b1^^e3
^^a1^^ac3^^b2^^a3
^^a1^^ac3^^b2^^a6
^^a1^^ac3^^b2^^b3
^^a1^^ac3^^b2^^e0
^^a1^^ac3^^b2^^e1
^^a1^^ac3^^b2^^e2
^^a1^^ac3^^b2^^e3
^^a1^^ac3^^b3^^a6
^^a1^^ac3^^b3^^b1
^^a1^^ac3^^b5^^ab
^^a1^^ac3^^b5^^b2
^^a1^^ac3^^b7^^a6
^^a1^^ac3^^b7^^ab
^^a1^^ac3^^b8^^a6
^^a1^^ac3^^b8^^ad
^^a1^^ac3^^b8^^b1
^^a1^^ac3^^b9^^a6
^^a1^^ac3^^b9^^ab
^^a1^^ac3^^b9^^b1
^^a1^^ac3^^ba^^ad
^^a1^^ac3^^bb^^a4
^^a1^^ac3^^bb^^a6
^^a1^^ac3^^bb^^a8
^^a1^^ac3^^bb^^ad
^^a1^^ac3^^bc^^ab
^^a1^^ac3^^e0^^a6
^^a1^^ac3^^e0^^aa
^^a1^^ac3^^e1^^b1
^^a1^^ac3^^e2^^a4
^^a1^^ac3^^e2^^a6
^^a1^^ac3^^e2^^ad
^^a1^^ac3^^e2^^b1
^^a1^^ac3^^e2^^b2
^^a1^^ac3^^e3^^a4
^^a11^^ad
^^a1^^ad3^^a3^^a6
^^a1^^ad3^^a3^^a8
^^a1^^ad3^^a3^^b1
^^a1^^ad3^^a3^^e3
^^a1^^ad3^^a4^^a3
^^a1^^ad3^^a4^^a6
^^a1^^ad3^^a4^^ab
^^a1^^ad3^^a4^^ac
^^a1^^ad3^^a4^^b1
^^a1^^ad3^^a4^^b2
^^a1^^ad3^^a4^^b9
^^a1^^ad3^^a6^^a8
^^a1^^ad3^^a6^^ab
^^a1^^ad3^^a6^^ac
^^a1^^ad3^^a6^^b1
^^a1^^ad3^^a6^^b2
^^a1^^ad3^^a6^^bb
^^a1^^ad3^^a7^^b1
^^a1^^ad3^^a8^^b1
^^a1^^ad3^^a8^^b6
^^a1^^ad3^^aa^^ac
^^a1^^ad3^^aa^^b9
^^a1^^ad3^^ac^^a3
^^a1^^ad3^^ac^^a4
^^a1^^ad3^^ac^^a7
^^a1^^ad3^^ac^^b1
^^a1^^ad3^^ac^^b2
^^a1^^ad3^^ac^^b3
^^a1^^ad3^^ac^^e2
^^a1^^ad3^^ac^^e3
^^a1^^ad3^^b2^^a6
^^a1^^ad3^^b2^^ac
^^a1^^ad3^^b2^^af
^^a1^^ad3^^b2^^b9
^^a1^^ad3^^b2^^bb
^^a1^^ad3^^b2^^e0
^^a1^^ad3^^b2^^e2
^^a1^^ad3^^b2^^e3
^^a1^^ad3^^b3^^a6
^^a1^^ad3^^b3^^a8
^^a1^^ad3^^b3^^ac
^^a1^^ad3^^b7^^a6
^^a1^^ad3^^b8^^b1
^^a1^^ad3^^b9^^b3
^^a1^^ad3^^bb^^a4
^^a1^^ad3^^bb^^a6
^^a1^^ad3^^bb^^ab
^^a1^^ad3^^bb^^ac
^^a1^^ad3^^bc^^ab
^^a1^^ad3^^bc^^b1
^^a1^^ad3^^e1^^a6
^^a1^^ad3^^e1^^ad
^^a1^^ad3^^e2^^a6
^^a1^^ad3^^e2^^ab
^^a1^^ad3^^e2^^b1
^^a1^^ad3^^e3^^a3
^^a1^^ad3^^e3^^a4
^^a11^^ae
^^a11^^af
^^a11^^b0
^^a1^^b03^^b1^^b0
^^a12^^b0^^b7
^^a11^^b1
^^a1^^b1^^a1^^e22^^a6
^^a1^^b13^^a2^^a4
^^a1^^b13^^a2^^b9
^^a1^^b13^^a3^^a2
^^a1^^b13^^a3^^a4
^^a1^^b13^^a3^^a6
^^a1^^b13^^a3^^a7
^^a1^^b13^^a3^^ad
^^a1^^b13^^a3^^b2
^^a1^^b13^^a3^^bc
^^a1^^b13^^a4^^a3
^^a1^^b13^^a4^^a6
^^a1^^b13^^a4^^a8
^^a1^^b13^^a4^^ab
^^a1^^b13^^a4^^ac
^^a1^^b13^^a4^^b9
^^a12^^b11^^a5^^b1
^^a1^^b13^^a6^^ab
^^a1^^b13^^a6^^b8
^^a1^^b13^^a6^^e0
^^a1^^b13^^a7^^ad
^^a1^^b13^^a8^^a7
^^a1^^b13^^a8^^a8
^^a1^^b13^^a8^^ac
^^a1^^b13^^a8^^ad
^^a1^^b13^^a8^^b6
^^a1^^b13^^a8^^b9
^^a1^^b13^^aa^^a6
^^a1^^b13^^aa^^ab
^^a1^^b13^^aa^^ac
^^a1^^b13^^ac^^a8
^^a1^^b13^^ac^^b8
^^a1^^b13^^b2^^a4
^^a1^^b13^^b2^^aa
^^a1^^b13^^b2^^b3
^^a1^^b13^^b3^^a6
^^a1^^b13^^b3^^ac
^^a1^^b13^^b3^^b1
^^a1^^b13^^b5^^ab
^^a1^^b13^^b7^^a6
^^a1^^b13^^b7^^ad
^^a1^^b13^^b8^^a6
^^a1^^b13^^b9^^a6
^^a1^^b13^^b9^^b1
^^a1^^b13^^ba^^ad
^^a1^^b13^^bb^^a6
^^a1^^b13^^bb^^a8
^^a1^^b13^^bb^^ac
^^a12^^b11^^bc
^^a1^^b13^^bc^^ab
^^a1^^b13^^e2^^a6
^^a1^^b13^^e2^^ad
^^a11^^b2
^^a1^^b21^^a1^^b2^^a9
^^a1^^b2^^a1^^e24^^ab^^b2.
^^a1^^b23^^a3^^a6
^^a1^^b23^^a3^^a7
^^a1^^b23^^a4^^a3
^^a1^^b23^^a4^^b1
^^a1^^b21^^a5^^b6
^^a1^^b23^^a6^^a8
^^a1^^b23^^a6^^ab
^^a1^^b23^^a6^^b1
^^a1^^b23^^a8^^ac
^^a1^^b23^^a8^^b1
^^a1^^b23^^a8^^b6
^^a1^^b23^^aa^^a4
^^a1^^b23^^aa^^a6
^^a1^^b23^^aa^^ad
^^a1^^b23^^ac^^a5
^^a12^^b21^^ad
^^a1^^b23^^af^^b9
^^a1^^b23^^b1^^a6
^^a1^^b23^^b1^^b9
^^a1^^b23^^b2^^a8
^^a1^^b23^^b3^^a7
^^a1^^b23^^b3^^b1
^^a1^^b23^^b9^^b3
^^a1^^b23^^bb^^a4
^^a1^^b23^^bb^^ab
^^a1^^b23^^bb^^ad
^^a1^^b23^^bc^^ab
^^a1^^b23^^bc^^b1
^^a1^^b23^^e0^^a6
^^a1^^b23^^e1^^b1
^^a1^^b23^^e2^^a4
^^a1^^b23^^e2^^a6
^^a1^^b23^^e2^^ab
^^a1^^b23^^e2^^b1
^^a11^^b3
^^a1^^b31^^a6
^^a1^^b33^^a6^^b1
^^a12^^b31^^aa
^^a1^^b33^^aa^^ad
^^a1^^b33^^aa^^b1
^^a1^^b31^^b1
^^a1^^b33^^b1^^ab
^^a1^^b33^^b1^^b5
^^a1^^b33^^b1^^b9
^^a1^^b33^^b2^^aa
^^a12^^b3^^b5
^^a1^^b33^^b5^^ae
^^a12^^b3^^b9
^^a1^^b33^^b9^^a9
^^a11^^b4
^^a11^^b5
^^a1^^b53^^a8^^b1
^^a1^^b53^^ab^^e0
^^a1^^b53^^b1^^a4
^^a1^^b53^^b1^^b6
^^a1^^b61^^a6
^^a1^^b63^^a6^^a4
^^a1^^b63^^a6^^ad
^^a1^^b63^^ac^^ad
^^a1^^b63^^b1^^ad
^^a1^^b63^^b3^^a7
^^a1^^b63^^b3^^ac
^^a11^^b7
^^a1^^b73^^a3^^a7
^^a1^^b73^^a4^^a3
^^a1^^b71^^a6
^^a1^^b73^^a6^^ab
^^a1^^b73^^a6^^ad
^^a1^^b73^^a6^^b1
^^a1^^b73^^a6^^b9
^^a1^^b73^^a7^^b1
^^a1^^b73^^a8^^b6
^^a1^^b73^^aa^^a6
^^a1^^b73^^ab^^a4
^^a1^^b73^^ab^^a8
^^a1^^b73^^ab^^ac
^^a1^^b73^^ac^^a3
^^a1^^b73^^ac^^a4
^^a1^^b73^^ac^^a7
^^a1^^b73^^ac^^aa
^^a1^^b73^^ac^^b1
^^a1^^b73^^ac^^bc
^^a1^^b73^^ac^^e0
^^a1^^b73^^ac^^e2
^^a1^^b73^^b1^^ac
^^a1^^b73^^b1^^b7
^^a1^^b73^^b2^^a4
^^a1^^b73^^b2^^b1
^^a1^^b73^^b5^^b1
^^a1^^b73^^bc^^a6
^^a1^^b73^^bc^^b1
^^a11^^b8
^^a1^^b81^^a4
^^a1^^b83^^a4^^b1
^^a1^^b83^^a6^^a7
^^a1^^b83^^a6^^ab
^^a1^^b81^^b1
^^a1^^b83^^b1^^a4
^^a11^^b9
^^a1^^b93^^a6^^b1
^^a12^^b9^^a7
^^a1^^b93^^ab^^a7
^^a1^^b93^^b3^^b1
^^a12^^b9^^b5
^^a1^^b93^^b5^^a1
^^a1^^b93^^b5^^ae
^^a11^^ba
^^a1^^ba3^^ad^^a4
^^a1^^ba3^^b1^^a4
^^a11^^bb
^^a1^^bb3^^a6^^ab
^^a1^^bb3^^a8^^ac
^^a1^^bb3^^ac^^ab
^^a12^^bb1^^b6
^^a1^^bb3^^b6^^a5
^^a1^^bb3^^b6^^a6
^^a11^^bc
^^a1^^bc^^a1^^b14^^bb^^a6.
^^a1^^bc3^^a6^^b1
^^a1^^bc3^^b1^^e0
^^a11^^e0
^^a1^^e03^^a6^^a4
^^a1^^e03^^a6^^ad
^^a1^^e03^^a6^^b1
^^a12^^e0^^ab
^^a12^^e0^^ac
^^a1^^e03^^ac^^b8
^^a12^^e01^^b1
^^a1^^e03^^b1^^a8
^^a11^^e1
^^a1^^e13^^a6^^a7
^^a1^^e13^^a6^^b1
^^a1^^e13^^ac^^ab
^^a11^^e2
^^a1^^e21^^a6
^^a1^^e23^^a6^^a4
^^a1^^e23^^a6^^b1
^^a1^^e21^^a7
^^a1^^e23^^ab^^a4
^^a1^^e23^^ab^^a8
^^a1^^e23^^ab^^aa
^^a1^^e23^^ab^^ac
^^a1^^e23^^ab^^b2
^^a1^^e23^^ab^^b9
^^a12^^e21^^ac
^^a1^^e21^^b1
^^a1^^e23^^b1^^ba
^^a1^^e23^^b1^^e0
^^a1^^e23^^b2^^b1
^^a1^^e23^^b3^^a7
^^a1^^e23^^b3^^ad
^^a1^^e23^^b3^^b1
^^a1^^e23^^b9^^a8
^^a1^^e23^^b9^^ac
^^a11^^e3
^^a12^^e31^^a6
^^a12^^e3^^ac
^^a1^^e43^^aa^^a6
^^a1^^e43^^aa^^b1
^^a1^^e43^^b8^^a6
^^a1^^e43^^b8^^b1
^^a1^^e43^^e2^^a6
^^a1^^e43^^e2^^b2
1^^a2^^a1
^^a2^^a13^^a82^^a6
2^^a21^^a3
2^^a21^^a4
1^^a2^^a5
2^^a21^^a62
2^^a21^^a72
2^^a21^^a82
1^^a2^^a9
2^^a21^^ab2
2^^a21^^ac
2^^a21^^ad2
1^^a2^^ae
^^a2^^ae3^^a82^^b6
2^^a21^^b0
2^^a21^^b12
2^^a21^^b22
1^^a2^^b4
2^^a21^^b6
1^^a2^^b72
2^^a21^^b9
2^^a21^^ba
2^^a21^^bb
2^^a21^^e1
2^^a21^^e3
2^^a31^^a2
2^^a31^^a32
2^^a31^^a4
2^^a31^^a62
^^a33^^a6^^a8^^a1
2^^a31^^a72
2^^a31^^a82
^^a3^^a9^^a5^^b14^^a8^^b2.
^^a3^^a92^^ac^^ae
2^^a31^^aa2
^^a31^^ab^^a5
3^^a3^^ab^^a5^^e3^^a6
^^a3^^ac2
2^^a31^^ad
2^^a31^^af
2^^a31^^b0
2^^a31^^b12
2^^a31^^b22
2^^a31^^b3
1^^a3^^b4
2^^a31^^b7
2^^a31^^b82
^^a32^^b92
^^a31^^b9^^b1
2^^a31^^ba
2^^a31^^bb2
2^^a31^^bc2
2^^a31^^e0
2^^a31^^e12
2^^a31^^e22
2^^a31^^e3
2^^a41^^a2
2^^a41^^a32
2^^a41^^a4
^^a4^^a53^^b1^^a9
^^a4^^a5^^b72
^^a4^^a53^^b7^^b1
2^^a41^^a6
2^^a41^^a82
2^^a4^^a9^^b7^^a2^^a1^^ab^^ac
2^^a4^^a9^^b7^^a2^^ab^^a9^^b2
2^^a41^^aa
2^^a41^^ab2
2^^a41^^ac2
1^^a4^^ad
^^a41^^ad^^a1
2^^a41^^af
2^^a41^^b0
2^^a41^^b12
^^a43^^b1^^b2^^a1
2^^a42^^b22
^^a42^^b5
2^^a41^^b6
^^a4^^b72
2^^a41^^b8
2^^a41^^b92
2^^a41^^ba
2^^a41^^e0
2^^a41^^e2
2^^a41^^e3
2^^a41^^e42
^^a51^^a1
^^a5^^a1^^b1^^a13
^^a51^^a2
^^a5^^a23^^b2^^a6
^^a5^^a23^^b2^^a8
^^a5^^a23^^b2^^ac
^^a51^^a3
^^a5^^a33^^a6^^aa
^^a5^^a33^^a6^^af
^^a5^^a33^^a6^^b1
^^a5^^a33^^a6^^b9
^^a5^^a33^^a6^^e0
^^a5^^a33^^a6^^e1
^^a5^^a33^^a6^^e2
^^a52^^a3^^ab
^^a52^^a31^^ac
^^a5^^a33^^ac^^a6
^^a5^^a33^^b1^^ba
^^a5^^a33^^b8^^a6
^^a52^^a3^^b9
^^a5^^a33^^b9^^a9
^^a5^^a33^^b9^^b1
^^a5^^a33^^bb^^a4
^^a5^^a33^^bc^^ab
^^a5^^a33^^e2^^a6
^^a51^^a4
^^a52^^a41^^a7
^^a52^^a41^^ad
^^a5^^a43^^b1^^a4
^^a5^^a43^^b1^^aa
^^a5^^a43^^b2^^a1
^^a51^^a5
2^^a5^^a5^^b3
^^a51^^a6
^^a5^^a63^^a2^^b1
^^a5^^a63^^a4^^a3
^^a5^^a63^^a8^^ac
^^a5^^a63^^aa^^b1
^^a5^^a63^^ab^^a8
^^a5^^a63^^ab^^ac
^^a5^^a63^^ab^^b9
^^a5^^a63^^ab^^ba
^^a5^^a63^^ac^^bb
^^a5^^a63^^b1^^a3
^^a5^^a63^^b1^^a4
^^a5^^a63^^b1^^a7
^^a5^^a63^^b1^^aa
^^a5^^a63^^b1^^ac
^^a5^^a63^^b1^^ad
^^a5^^a63^^b1^^b2
^^a5^^a63^^b1^^ba
^^a5^^a63^^b1^^bb
^^a5^^a63^^b1^^e3
^^a5^^a63^^b2^^aa
^^a5^^a63^^b2^^b1
^^a5^^a63^^b2^^e0
^^a5^^a63^^b2^^e2
^^a5^^a63^^b8^^a6
^^a5^^a63^^bb^^a4
^^a5^^a63^^bb^^a6
^^a5^^a63^^bc^^a6
^^a5^^a63^^bc^^ab
^^a5^^a63^^e2^^a6
^^a5^^a63^^e2^^b3
^^a5^^a63^^e3^^a4
^^a51^^a7
^^a5^^a73^^b1^^a2
^^a5^^a73^^b1^^a4
^^a51^^a8
^^a52^^a81^^a6
^^a5^^a83^^a6^^ab
^^a5^^a83^^a6^^b1
^^a52^^a81^^ab
^^a5^^a83^^b1^^a3
^^a5^^a83^^b1^^a6
^^a5^^a83^^b1^^b2
^^a5^^a83^^b1^^e0
^^a5^^a83^^b6^^ab
^^a51^^a9
^^a51^^aa
^^a5^^aa1^^a4
^^a5^^aa3^^a6^^b1
^^a5^^aa3^^b1^^a8
^^a51^^ab
^^a5^^ab3^^a3^^a6
^^a5^^ab3^^a4^^b9
^^a5^^ab3^^a6^^b8
^^a5^^ab3^^ac^^b8
^^a5^^ab3^^ac^^bc
^^a5^^ab3^^ac^^e0
^^a5^^ab3^^ac^^e2
^^a5^^ab3^^b8^^a6
^^a5^^ab3^^e0^^a6
^^a51^^ac
^^a5^^ac^^a14^^b2^^ac^^a5^^a8
^^a5^^ac3^^a2^^b1
^^a5^^ac3^^a3^^a7
^^a5^^ac3^^a4^^a3
^^a5^^ac3^^a4^^b1
^^a5^^ac3^^aa^^a6
^^a5^^ac3^^aa^^b1
^^a5^^ac3^^ab^^a4
^^a5^^ac3^^ab^^ac
^^a5^^ac3^^af^^ac
^^a5^^ac3^^b1^^ba
^^a5^^ac3^^b1^^bb
^^a5^^ac3^^b2^^a3
^^a5^^ac3^^b2^^aa
^^a5^^ac3^^b2^^b1
^^a5^^ac3^^b2^^b8
^^a5^^ac3^^b2^^e0
^^a5^^ac3^^b2^^e3
^^a5^^ac3^^b9^^a6
^^a5^^ac3^^b9^^ab
^^a5^^ac3^^ba^^ad
^^a5^^ac3^^bb^^a2
^^a5^^ac3^^bb^^a4
^^a5^^ac3^^bb^^a6
^^a5^^ac3^^bc^^a6
^^a5^^ac3^^bc^^ab
^^a5^^ac3^^e0^^a6
^^a5^^ac3^^e1^^ac
^^a5^^ac3^^e2^^a6
^^a5^^ac3^^e2^^b1
^^a51^^ad
^^a5^^ad3^^a4^^a4
^^a5^^ad3^^a4^^b1
^^a5^^ad3^^a4^^b2
^^a5^^ad3^^a8^^b6
^^a5^^ad3^^b2^^aa
^^a5^^ad3^^b2^^ac
^^a5^^ad3^^b3^^a8
^^a5^^ad3^^b3^^ac
^^a5^^ad3^^b3^^b1
^^a5^^ad3^^ba^^a6
^^a51^^ae
^^a51^^af
^^a51^^b1
^^a52^^b11^^a1^^b1
^^a5^^b13^^a3^^a7
^^a5^^b13^^a4^^a3
^^a5^^b13^^a4^^b9
^^a5^^b13^^a6^^ab
^^a5^^b13^^a8^^a2
^^a5^^b13^^a8^^a3
^^a5^^b13^^a8^^a4
^^a5^^b13^^a8^^a7
^^a5^^b13^^a8^^a8
^^a5^^b13^^a8^^aa
^^a5^^b13^^a8^^ac
^^a5^^b13^^a8^^ad
^^a5^^b13^^a8^^b2
^^a5^^b13^^a8^^b5
^^a5^^b13^^a8^^b9
^^a5^^b12^^a8^^e2^^a1
^^a5^^b13^^aa^^a6
^^a5^^b13^^ac^^aa
^^a5^^b11^^ae^^b5
^^a5^^b13^^af^^ab
^^a5^^b13^^b2^^a7
^^a5^^b13^^b2^^ac
^^a5^^b13^^b2^^af
^^a5^^b13^^b2^^b3
^^a5^^b13^^b3^^a2
^^a5^^b13^^b3^^a7
^^a5^^b13^^b3^^ac
^^a5^^b13^^b5^^ab
^^a5^^b13^^b5^^ac
^^a5^^b13^^b7^^a6
^^a5^^b13^^b9^^ab
^^a5^^b13^^ba^^e2
^^a5^^b13^^bb^^a6
^^a52^^b11^^bc
^^a5^^b13^^bc^^ad
^^a5^^b13^^e0^^a6
^^a5^^b13^^e0^^aa
^^a5^^b13^^e2^^a4
^^a5^^b13^^e2^^a6
^^a5^^b13^^e2^^a7
^^a5^^b13^^e2^^a8
^^a5^^b13^^e2^^b2
^^a51^^b2
^^a5^^b23^^a4^^a3
^^a5^^b23^^a6^^a3
^^a5^^b23^^a6^^ab
^^a5^^b23^^a6^^ac
^^a5^^b23^^a6^^b1
^^a5^^b23^^a8^^b6
^^a5^^b23^^aa^^ad
^^a5^^b23^^aa^^b1
^^a5^^b23^^ab^^ac
^^a52^^b2^^ad
^^a5^^b23^^b3^^ac
^^a5^^b23^^b3^^ad
^^a5^^b23^^bc^^ab
^^a5^^b23^^bc^^b1
^^a5^^b23^^e2^^a4
^^a5^^b23^^e2^^a6
^^a5^^b23^^e2^^a7
^^a51^^b3
^^a5^^b33^^a3^^a6
^^a52^^b31^^aa
^^a5^^b33^^ab^^a8
^^a5^^b33^^ab^^ac
^^a5^^b33^^ab^^b9
^^a5^^b31^^b1
^^a5^^b33^^b1^^b5
^^a52^^b3^^b9
^^a5^^b33^^b9^^a9
^^a5^^b33^^ba^^a6
^^a5^^b33^^e2^^ad
^^a51^^b4
^^a51^^b5
^^a5^^b61^^a6
^^a5^^b63^^a6^^a8
^^a5^^b63^^a6^^b2
^^a5^^b63^^ac^^ad
^^a5^^b63^^b1^^a8
^^a5^^b63^^b2^^aa
^^a5^^b63^^b2^^af
^^a5^^b63^^b2^^b3
^^a5^^b63^^b2^^bb
^^a5^^b63^^b3^^a7
^^a5^^b63^^b3^^ac
^^a5^^b63^^bb^^ad
^^a51^^b7
^^a5^^b71^^a6
^^a51^^b8
^^a5^^b81^^ad
^^a5^^b83^^ad^^a4
^^a5^^b81^^b1
^^a5^^b83^^b1^^a4
^^a51^^b9
^^a5^^b93^^a6^^ad
^^a5^^b93^^b3^^b1
^^a52^^b9^^b5
^^a5^^b93^^b5^^ae
^^a51^^ba
^^a51^^bb
^^a5^^bb3^^a6^^ab
^^a52^^bb^^b6
^^a5^^bb3^^b6^^a5
^^a5^^bb3^^b6^^a9
^^a51^^bc
^^a5^^bc3^^a6^^b1
^^a51^^e0
^^a5^^e03^^a6^^a7
^^a5^^e03^^aa^^a6
^^a52^^e0^^ac
^^a52^^e01^^b1
^^a5^^e13^^a6^^a4
^^a5^^e13^^a6^^ac
^^a51^^e2
^^a5^^e23^^a4^^a3
^^a5^^e21^^a6
^^a5^^e23^^a6^^a4
^^a5^^e23^^a6^^a7
^^a5^^e21^^a7
^^a52^^e21^^ac
^^a5^^e23^^ac^^bc
^^a5^^e23^^b3^^ad
^^a5^^e21^^b8
^^a5^^e21^^e4
^^a51^^e3
^^a5^^e31^^a3
^^a5^^e33^^a3^^a6
^^a52^^e31^^a6
^^a52^^e3^^ad
^^a5^^e43^^aa^^b1
^^a5^^e43^^b8^^a6
2^^a61^^a22
2^^a61^^a32
2^^a61^^a42
2^^a61^^a62
2^^a61^^a72
2^^a61^^a82
^^a6^^a92^^b1^^b4
2^^a61^^aa2
^^a6^^aa^^a1^^b14^^a3^^b2.
2^^a61^^ab2
2^^a61^^ac2
2^^a61^^ad2
2^^a61^^ae^^e2
2^^a61^^af
^^a6^^b02
2^^a61^^b12
^^a63^^b1^^b2^^a1
2^^a61^^b22
^^a6^^b23^^a8^^e2
2^^a61^^b32
1^^a6^^b4
2^^a61^^b52
2^^a61^^b62
2^^a61^^b7
2^^a61^^b82
2^^a61^^b92
2^^a61^^ba
2^^a61^^bb2
2^^a61^^bc2
2^^a61^^e02
2^^a61^^e12
2^^a61^^e22
2^^a61^^e32
2^^a71^^a2
2^^a71^^a3
2^^a71^^a4
2^^a71^^a62
2^^a71^^a7
2^^a71^^a8
2^^a71^^ab2
2^^a71^^ac2
2^^a71^^ad
2^^a71^^b12
^^a73^^b1^^b2^^a1
2^^a71^^b22
^^a7^^b72
2^^a71^^b9
^^a8^^a12^^b2^^a1^^a8
^^a8^^a12^^b2^^a5
2^^a81^^a2
2^^a81^^a32
2^^a81^^a42
^^a8^^a62
^^a81^^a6^^a1
^^a81^^a6^^ae
^^a81^^a6^^b1
2^^a81^^a7
2^^a81^^a8
^^a82^^a8^^e2
2^^a81^^a9^^b6
2^^a81^^aa2
^^a8^^ab2
^^a81^^ab^^a4
2^^a81^^ac2
2^^a81^^ad
2^^a81^^ae^^bb^^a4^^a1^^a1
2^^a81^^b12
2^^a81^^b22
2^^a81^^b52
2^^a81^^b62
2^^a81^^b7
2^^a81^^b9
2^^a81^^bb2
^^a8^^e22
2^^a8^^e2.
2^^a8^^e2^^b2
3^^a8^^e2^^b2^^a1
2^^a81^^e3
^^a91^^a1
^^a9^^a13^^ac2^^a7
^^a91^^a2
^^a9^^a23^^a6^^ab
^^a9^^a23^^b1^^a7
^^a9^^a23^^b1^^b3
^^a9^^a23^^b1^^e1
^^a9^^a23^^b1^^e3
^^a91^^a3
^^a9^^a33^^a6^^b1
^^a9^^a33^^a6^^b8
^^a92^^a31^^ab
^^a92^^a3^^ac
^^a9^^a33^^b1^^a3
^^a92^^a3^^b9
^^a9^^a33^^b9^^a9
^^a91^^a4
^^a9^^a43^^a3^^a6
^^a9^^a43^^a3^^ad
^^a92^^a41^^a7
^^a9^^a43^^ac^^ad
^^a9^^a43^^ac^^af
^^a92^^a41^^ad
^^a9^^a43^^b1^^a4
^^a9^^a43^^b1^^a6
^^a9^^a43^^b1^^ad
^^a9^^a43^^b2^^a1
^^a9^^a43^^b9^^a6
^^a91^^a5
^^a91^^a6
^^a9^^a63^^a2^^b1
^^a9^^a63^^a4^^a3
^^a9^^a63^^a8^^a8
^^a9^^a63^^ab^^a4
^^a92^^a6^^b0
^^a9^^a63^^b1^^a2
^^a9^^a63^^b1^^a4
^^a9^^a63^^b1^^a7
^^a9^^a63^^b1^^b9
^^a9^^a63^^b1^^bb
^^a9^^a63^^b2^^b7
^^a9^^a63^^b5^^b2
^^a9^^a63^^b8^^a6
^^a9^^a63^^bc^^ab
^^a9^^a63^^e0^^a6
^^a9^^a63^^e2^^a6
^^a9^^a63^^e3^^a4
^^a91^^a7
^^a9^^a73^^a6^^ad
^^a9^^a73^^ab^^a4
^^a9^^a73^^ac^^a7
^^a9^^a73^^ac^^a8
^^a9^^a73^^ac^^ac
^^a9^^a73^^ac^^b1
^^a9^^a73^^ac^^b9
^^a9^^a73^^b1^^a4
^^a91^^a8
^^a92^^a81^^a6
^^a9^^a83^^a6^^ab
^^a9^^a83^^a6^^b1
^^a92^^a81^^ab
^^a9^^a83^^ab^^a4
^^a9^^a83^^ac^^aa
^^a9^^a83^^ac^^ac
^^a9^^a83^^ac^^af
^^a9^^a83^^b1^^a3
^^a9^^a83^^b1^^a4
^^a9^^a83^^b1^^ac
^^a9^^a83^^b5^^ab
^^a9^^a83^^bb^^ad
^^a91^^a9
^^a91^^aa
^^a9^^aa3^^a2^^a9
^^a9^^aa1^^a4
^^a9^^aa3^^a6^^a4
^^a9^^aa3^^a6^^ab
^^a9^^aa3^^a6^^ad
^^a91^^ab
^^a9^^ab3^^ac^^b2
^^a9^^ab3^^b3^^a6
^^a9^^ab3^^b7^^a6
^^a9^^ab3^^b9^^a6
^^a9^^ab3^^e2^^a6
^^a91^^ac
^^a9^^ac3^^a3^^a7
^^a9^^ac3^^a4^^a3
^^a9^^ac3^^a4^^b1
^^a9^^ac3^^aa^^a6
^^a9^^ac3^^ad^^a4
^^a9^^ac3^^b1^^a2
^^a9^^ac3^^b1^^a8
^^a9^^ac3^^b2^^a6
^^a9^^ac3^^b2^^e2
^^a9^^ac3^^b2^^e3
^^a9^^ac3^^b3^^a6
^^a9^^ac3^^b8^^ad
^^a9^^ac3^^b8^^b1
^^a9^^ac3^^b9^^a6
^^a9^^ac3^^b9^^ad
^^a9^^ac3^^b9^^b1
^^a9^^ac3^^ba^^ad
^^a9^^ac3^^bc^^ab
^^a9^^ac3^^e2^^a4
^^a9^^ac3^^e2^^ad
^^a91^^ad
^^a9^^ad3^^a3^^b1
^^a9^^ad3^^a4^^a2
^^a9^^ad3^^a4^^a4
^^a9^^ad3^^a4^^a6
^^a9^^ad3^^a4^^a8
^^a9^^ad3^^a4^^b1
^^a9^^ad3^^a4^^b9
^^a9^^ad3^^a8^^a7
^^a9^^ad3^^a8^^b6
^^a9^^ad3^^aa^^a6
^^a9^^ad3^^aa^^ab
^^a9^^ad3^^aa^^b1
^^a9^^ad3^^b2^^aa
^^a9^^ad3^^b2^^af
^^a9^^ad3^^b2^^b3
^^a9^^ad3^^b2^^bb
^^a9^^ad3^^b2^^e0
^^a9^^ad3^^b3^^ab
^^a9^^ad3^^b3^^b1
^^a9^^ad3^^b6^^ab
^^a9^^ad3^^b7^^ab
^^a9^^ad3^^bb^^a4
^^a9^^ad3^^bb^^ab
^^a9^^ad3^^bc^^ab
^^a9^^ad3^^bc^^ac
^^a9^^ad3^^bc^^b1
^^a9^^ad3^^e0^^a6
^^a9^^ad3^^e2^^a6
^^a91^^ae
^^a91^^af
^^a91^^b0
^^a92^^b0^^b7
^^a91^^b1
^^a9^^b13^^a3^^a6
^^a9^^b13^^a8^^ac
^^a9^^b13^^aa^^a6
^^a9^^b13^^aa^^b9
^^a9^^b13^^ac^^b9
^^a9^^b13^^b2^^a8
^^a9^^b13^^b2^^ac
^^a9^^b13^^b2^^b2
^^a9^^b13^^b2^^b9
^^a9^^b11^^b4^^ad
^^a9^^b13^^b7^^a6
^^a9^^b13^^b8^^a6
^^a9^^b13^^e2^^b9
^^a9^^b23^^a4^^a3
^^a9^^b23^^a4^^b1
^^a9^^b23^^a6^^ab
^^a9^^b23^^a6^^ac
^^a9^^b23^^a6^^b1
^^a9^^b23^^a8^^b6
^^a9^^b23^^aa^^a4
^^a9^^b23^^aa^^a6
^^a9^^b23^^aa^^a7
^^a9^^b23^^aa^^b1
^^a9^^b23^^aa^^b9
^^a9^^b23^^ac^^a3
^^a9^^b23^^ac^^b2
^^a9^^b23^^ac^^b3
^^a9^^b23^^ac^^b6
^^a9^^b23^^ac^^b8
^^a9^^b23^^ac^^b9
^^a9^^b23^^ac^^bb
^^a9^^b23^^ac^^bc
^^a9^^b21^^ad
^^a9^^b23^^b3^^a4
^^a9^^b23^^b3^^a6
^^a9^^b23^^b3^^a8
^^a9^^b23^^b3^^ac
^^a9^^b23^^b3^^b1
^^a9^^b23^^b5^^b1
^^a9^^b23^^b9^^a6
^^a9^^b23^^bb^^a6
^^a9^^b23^^e0^^a6
^^a9^^b23^^e2^^a4
^^a9^^b23^^e2^^a6
^^a9^^b23^^e2^^ab
^^a91^^b3
^^a9^^b31^^a6
^^a9^^b33^^a6^^ab
^^a92^^b31^^aa
^^a9^^b33^^ac^^b9
^^a9^^b31^^b1
^^a91^^b4
^^a91^^b5
^^a9^^b53^^b1^^a4
^^a9^^b53^^b1^^b6
^^a9^^b53^^b9^^a6
^^a9^^b61^^a6
^^a9^^b63^^a6^^ad
^^a9^^b63^^ac^^ad
^^a9^^b63^^ad^^a3
^^a9^^b63^^ad^^ac
^^a9^^b63^^b1^^a4
^^a9^^b63^^b1^^a8
^^a9^^b63^^b1^^ac
^^a9^^b63^^b1^^b2
^^a9^^b63^^b1^^b9
^^a9^^b63^^bb^^a6
^^a9^^b63^^bb^^ad
^^a91^^b7
1^^a9^^b7^^a2^^a1^^ab^^ac
^^a9^^b73^^a2^^ab
1^^a9^^b7^^a2^^ab^^a9^^b2
^^a9^^b71^^a6
^^a9^^b73^^a6^^b1
^^a9^^b73^^a6^^e0
^^a9^^b73^^b1^^ac
^^a9^^b73^^b1^^e1
^^a91^^b8
^^a9^^b83^^a6^^a4
^^a9^^b83^^a6^^ad
^^a9^^b93^^a6^^ab
^^a9^^b93^^a6^^ad
^^a9^^b93^^aa^^b1
^^a9^^b93^^b5^^ae
^^a9^^b93^^e2^^ab
^^a91^^ba
^^a92^^ba^^ab
^^a9^^ba3^^ad^^a4
^^a9^^ba3^^b1^^a4
^^a91^^bb
^^a9^^bb3^^a6^^ab
^^a9^^bb3^^a6^^ad
^^a92^^bb^^b6
^^a9^^bb3^^b6^^a5
^^a9^^bb3^^b6^^ad
^^a91^^bc
^^a9^^bc3^^a3^^ad
^^a9^^bc3^^a6^^b1
^^a9^^bc3^^ab^^b9
^^a9^^bc3^^b1^^ad
^^a91^^e0
^^a9^^e03^^a6^^a4
^^a9^^e03^^a6^^ad
^^a9^^e03^^a6^^b1
^^a9^^e03^^aa^^ad
^^a9^^e03^^aa^^b1
^^a92^^e0^^ac
^^a92^^e01^^b1
^^a9^^e03^^b1^^a8
^^a91^^e1
^^a9^^e13^^a6^^b1
^^a92^^e11^^a7
^^a91^^e2
^^a9^^e21^^a6
^^a9^^e23^^a6^^a4
^^a9^^e23^^a6^^ad
^^a92^^e21^^ac
^^a9^^e21^^b1
^^a9^^e23^^b1^^ba
^^a9^^e23^^b1^^e0
^^a91^^e3
^^a92^^e31^^a7
^^a92^^e31^^ad
^^a9^^e43^^a3^^a6
^^a9^^e43^^aa^^b1
^^a9^^e43^^b8^^a6
1^^aa2^^a2
2^^aa^^a4
^^aa1^^a4^^a9
^^aa1^^a4^^ae
1^^aa^^a5
2^^aa1^^a62
2^^aa1^^a7
2^^aa1^^a8
2^^aa1^^ab2
2^^aa1^^ac2
2^^aa1^^ad
^^aa^^ae3^^ac2^^b2
2^^aa^^af
2^^aa1^^b12
2^^aa1^^b2
2^^aa1^^b6
2^^aa1^^b9
2^^aa1^^e4
1^^ab^^a1
^^ab^^a13^^ac2^^e1
2^^ab1^^a2
^^ab^^a2^^b13^^b3
^^ab^^a2^^b13^^e1
2^^ab1^^a32
2^^ab1^^a42
^^ab3^^a4^^b2^^a1
2^^ab^^a5^^e2
2^^ab^^a5^^e3^^a6
2^^ab1^^a62
2^^ab1^^a7
2^^ab1^^a82
^^ab^^a93^^a82^^b6
2^^ab1^^aa
2^^ab1^^ab
2^^ab1^^ac2
2^^ab1^^ad2
^^ab^^ae1
2^^ab1^^af
2^^ab1^^b0
2^^ab1^^b1
2^^ab1^^b22
2^^ab1^^b32
1^^ab^^b4
2^^ab1^^b5
2^^ab1^^b62
2^^ab1^^b72
2^^ab1^^b82
2^^ab1^^b92
2^^ab1^^ba2
2^^ab1^^bb2
2^^ab1^^bc
2^^ab1^^e02
2^^ab1^^e22
2^^ab1^^e3
2^^ab1^^e42
1^^ac^^a1
^^ac^^a13^^b22^^ac
^^ac^^a13^^b82^^ab
^^ac^^a1^^e23^^a6
2^^ac1^^a22
2^^ac1^^a32
2^^ac1^^a42
^^ac2^^a4^^b7
2^^ac1^^a62
2^^ac1^^a72
2^^ac1^^a82
1^^ac^^a9
^^ac^^a9^^b24^^b3^^b1^^b2.
2^^ac1^^aa2
2^^ac1^^ab2
2^^ac1^^ac
2^^ac1^^ad2
2^^ac1^^ae^^a8^^e2^^b2
2^^ac1^^af2
2^^ac1^^b0
2^^ac1^^b12
2^^ac1^^b22
2^^ac1^^b32
^^ac^^b43^^b2^^ae
2^^ac1^^b52
2^^ac1^^b62
2^^ac1^^b72
2^^ac1^^b82
2^^ac1^^b92
2^^ac1^^ba2
2^^ac1^^bb2
2^^ac1^^bc2
2^^ac1^^e02
2^^ac1^^e12
2^^ac1^^e22
2^^ac1^^e32
2^^ad1^^a2
2^^ad1^^a32
2^^ad1^^a42
^^ad^^a4^^a52^^b1
2^^ad1^^a62
2^^ad1^^a72
2^^ad1^^a82
1^^ad^^a9
^^ad^^a9^^a13^^b9^^b3
^^ad^^a93^^a82^^b6
^^ad^^a9^^b24^^b3^^b1^^b2.
2^^ad1^^aa2
2^^ad1^^ab
2^^ad1^^ac2
2^^ad1^^ad
2^^ad1^^af
2^^ad1^^b0
2^^ad1^^b1
2^^ad1^^b22
2^^ad1^^b32
^^ad3^^b3^^b2^^a1
^^ad3^^b3^^b2^^b3
1^^ad^^b4
2^^ad1^^b52
2^^ad1^^b62
2^^ad1^^b72
2^^ad1^^b82
2^^ad1^^b92
2^^ad1^^ba2
2^^ad1^^bb2
2^^ad1^^bc2
2^^ad1^^e02
2^^ad1^^e12
2^^ad1^^e22
2^^ad1^^e32
^^ae1^^a1
^^ae1^^a2
^^ae^^a23^^a8^^ac
^^ae^^a23^^ab^^a4
^^ae^^a23^^b1^^a4
^^ae^^a23^^b1^^ac
^^ae^^a23^^b1^^b9
^^ae^^a23^^b1^^e1
^^ae1^^a3
^^ae^^a33^^a6^^a2
^^ae^^a33^^a6^^a3
^^ae^^a33^^a6^^a4
^^ae^^a33^^a6^^a6
^^ae^^a3^^a63^^a8^^e2
^^ae^^a33^^a6^^aa
^^ae^^a33^^a6^^ab
^^ae^^a33^^a6^^ac
^^ae^^a33^^a6^^ad
^^ae^^a33^^a6^^b1
^^ae^^a33^^a6^^b2
^^ae^^a33^^a6^^b8
^^ae^^a33^^a6^^b9
^^ae^^a33^^a6^^bb
^^ae^^a33^^a6^^bc
^^ae^^a33^^a6^^e0
^^ae^^a33^^a6^^e2
^^ae^^a33^^aa^^ab
^^ae^^a33^^aa^^b1
^^ae2^^a31^^ab
^^ae2^^a3^^ac
^^ae^^a33^^b2^^a6
^^ae^^a33^^b8^^a6
^^ae2^^a3^^b9
^^ae^^a33^^b9^^a9
^^ae^^a33^^e0^^a6
^^ae^^a33^^e2^^a6
^^ae1^^a4
^^ae^^a43^^a3^^ad
^^ae2^^a41^^a7
^^ae2^^a41^^ad
^^ae1^^a5
^^ae1^^a6
^^ae^^a63^^a2^^b1
^^ae^^a63^^a4^^a3
^^ae^^a63^^a7^^b2
^^ae^^a63^^a7^^b9
^^ae^^a63^^a8^^b6
^^ae^^a63^^aa^^a6
^^ae^^a63^^aa^^ab
^^ae^^a63^^ab^^a2
^^ae^^a63^^ab^^a7
^^ae^^a63^^ac^^bb
^^ae^^a63^^ad^^a4
^^ae^^a63^^b1^^a4
^^ae^^a63^^b1^^a8
^^ae^^a63^^b1^^ba
^^ae^^a63^^b2^^a6
^^ae^^a63^^b2^^aa
^^ae^^a63^^b2^^af
^^ae^^a63^^b2^^e2
^^ae^^a63^^b8^^a6
^^ae^^a63^^b9^^a6
^^ae^^a63^^ba^^ad
^^ae^^a63^^bb^^a4
^^ae^^a63^^bb^^a6
^^ae^^a63^^bb^^ad
^^ae^^a63^^bc^^a6
^^ae^^a63^^e0^^a6
^^ae^^a63^^e1^^b1
^^ae^^a63^^e2^^a6
^^ae^^a63^^e2^^b3
^^ae^^a63^^e3^^a4
^^ae1^^a7
^^ae^^a73^^a6^^b1
^^ae^^a73^^b1^^a4
^^ae1^^a8
^^ae2^^a8^^a6
^^ae^^a83^^a6^^ab
^^ae^^a83^^a6^^b1
^^ae2^^a81^^ab
^^ae^^a83^^ab^^b9
^^ae1^^a9
^^ae1^^aa
^^ae^^aa1^^a4
^^ae^^aa3^^a6^^a4
^^ae^^aa3^^a6^^ab
^^ae^^aa3^^a6^^ad
^^ae^^aa3^^a6^^b1
^^ae^^aa3^^ab^^a4
^^ae1^^ab
^^ae^^ab3^^a4^^b9
^^ae^^ab3^^b2^^aa
^^ae^^ab3^^b9^^a6
^^ae1^^ac
^^ae^^ac3^^a2^^b1
^^ae^^ac3^^a3^^a4
^^ae^^ac3^^a3^^a6
^^ae^^ac3^^a3^^a7
^^ae^^ac3^^a3^^b1
^^ae^^ac3^^a4^^a3
^^ae^^ac3^^a6^^ab
^^ae^^ac3^^aa^^a6
^^ae^^ac3^^aa^^ab
^^ae^^ac3^^aa^^b1
^^ae^^ac3^^af^^ab
^^ae^^ac3^^af^^b1
^^ae^^ac3^^b1^^a8
^^ae^^ac3^^b1^^ba
^^ae^^ac3^^b2^^a6
^^ae^^ac3^^b2^^aa
^^ae^^ac3^^b2^^af
^^ae^^ac3^^b2^^e2
^^ae^^ac3^^b3^^b1
^^ae^^ac3^^b7^^a6
^^ae^^ac3^^b8^^a6
^^ae^^ac3^^b9^^a6
^^ae^^ac3^^bb^^a4
^^ae^^ac3^^bb^^a6
^^ae^^ac3^^bc^^a6
^^ae^^ac3^^e0^^a6
^^ae^^ac3^^e2^^a4
^^ae^^ac3^^e2^^a6
^^ae^^ac3^^e2^^b1
^^ae^^ac3^^e3^^a4
^^ae1^^ad
^^ae^^ad3^^a3^^b1
^^ae^^ad3^^a4^^b1
^^ae^^ad3^^aa^^b1
^^ae^^ad3^^ac^^a4
^^ae^^ad3^^b2^^aa
^^ae^^ad3^^b2^^af
^^ae^^ad3^^b2^^b3
^^ae^^ad3^^b3^^b1
^^ae^^ad3^^b5^^ab
^^ae^^ad3^^e2^^ab
^^ae1^^ae
^^ae1^^af
^^ae1^^b1
^^ae^^b13^^a2^^ab
^^ae^^b13^^a8^^ac
^^ae^^b13^^a8^^b6
^^ae^^b13^^aa^^a6
^^ae^^b13^^ac^^e2
^^ae^^b13^^b2^^ac
^^ae^^b13^^b3^^ac
^^ae^^b13^^b3^^b1
^^ae^^b13^^b3^^b2
^^ae^^b13^^ba^^ad
^^ae^^b13^^bb^^a4
^^ae^^b13^^bb^^a6
^^ae^^b13^^bb^^a7
^^ae^^b13^^bb^^ac
^^ae^^b13^^bb^^ad
^^ae^^b13^^bb^^b9
^^ae2^^b11^^bc
^^ae1^^b2
^^ae^^b23^^a4^^a3
^^ae^^b23^^a6^^ab
^^ae^^b23^^a6^^b1
^^ae^^b23^^a8^^b6
^^ae^^b23^^aa^^a4
^^ae2^^b21^^ad
^^ae^^b23^^b3^^ab
^^ae^^b23^^b3^^b1
^^ae^^b23^^b5^^b1
^^ae^^b23^^bb^^a4
^^ae^^b23^^bb^^a6
^^ae^^b23^^bb^^b1
^^ae^^b23^^bc^^a6
^^ae^^b23^^e0^^a6
^^ae^^b23^^e1^^b1
^^ae^^b23^^e2^^a4
^^ae1^^b3
^^ae2^^b31^^aa
^^ae^^b31^^b1
^^ae^^b33^^b1^^a4
^^ae2^^b3^^b9
^^ae^^b33^^b9^^a9
^^ae1^^b4
^^ae1^^b5
^^ae^^b53^^ab^^ac
^^ae2^^b61^^a6
^^ae^^b63^^ac^^a7
^^ae^^b63^^ac^^ad
^^ae^^b63^^ac^^b9
^^ae^^b63^^b1^^a8
^^ae^^b63^^b2^^a8
^^ae^^b63^^b3^^b1
^^ae1^^b7
^^ae^^b71^^a6
^^ae^^b73^^a6^^b1
1^^ae^^b7^^ab
^^ae1^^b8^^a1
^^ae1^^b8^^a5
^^ae^^b83^^a6^^ad
^^ae1^^b8^^ae
^^ae^^b81^^b1
^^ae1^^b8^^b4
^^ae1^^b9
^^ae^^b93^^aa^^a7
^^ae1^^ba
^^ae^^ba3^^ad^^a4
^^ae1^^bb
^^ae^^bb3^^a6^^ab
^^ae2^^bb^^b6
^^ae^^bb3^^b6^^b1
^^ae1^^bc
^^ae^^bc3^^a6^^b1
^^ae1^^e0
^^ae^^e03^^a6^^a4
^^ae^^e03^^a6^^ad
^^ae^^e03^^a6^^b1
^^ae2^^e0^^ac
^^ae^^e03^^ac^^a4
^^ae2^^e0^^b1
^^ae^^e11^^ab
^^ae1^^e2
^^ae^^e21^^a6
^^ae^^e23^^a6^^a4
^^ae^^e23^^a6^^ad
^^ae2^^e2^^ac
^^ae^^e21^^b1
^^ae^^e23^^b1^^ba
^^ae^^e23^^b3^^ad
^^ae1^^e3
^^ae^^e43^^a3^^a6
^^ae^^e43^^aa^^a6
^^ae^^e43^^aa^^ab
^^ae^^e43^^aa^^b1
^^ae^^e43^^b8^^a6
^^ae^^e43^^e2^^a6
2^^af1^^a4
2^^af1^^a6
2^^af1^^a7
^^af1^^aa
2^^af1^^ab2
2^^af1^^ac
2^^af1^^ad
2^^af1^^b12
2^^af^^b2
2^^af1^^b3
^^af^^b82
2^^af1^^b9
2^^af1^^ba
2^^af1^^e02
2^^b01^^a2
2^^b01^^a4
2^^b01^^a6
2^^b01^^a7
2^^b01^^a8
1^^b0^^a9
2^^b01^^aa
2^^b01^^ab
3^^b02^^ab^^a5^^b3^^a1
2^^b01^^ac
1^^b0^^ae
2^^b01^^b12
2^^b0^^b2
^^b01^^b7^^a5
2^^b01^^b9
2^^b11^^a1^^ac^^a2
3^^b1^^a1^^ac^^a2^^a1^^a6^^a9.
2^^b11^^a1^^ba^^a1
2^^b11^^a22
2^^b11^^a32
^^b13^^a3^^b2^^a1
2^^b11^^a42
^^b13^^a4^^b2^^a1
2^^b11^^a5^^aa^^ae
^^b11^^a5^^b5^^a5
2^^b11^^a62
2^^b11^^a72
2^^b11^^a82
^^b1^^a8^^a5^^b14^^a8^^b2.
^^b13^^a8^^b2^^a1
^^b13^^a8^^e2^^ac
1^^b1^^a9
^^b1^^a92^^a2^^b7
^^b1^^a93^^ac^^b7
2^^b11^^aa2
2^^b11^^ab
2^^b11^^ac
^^b1^^ac2^^a8
^^b1^^ac2^^b8
2^^b11^^ad
^^b1^^ae1
2^^b1^^ae^^b5
2^^b11^^af2
2^^b11^^b0
2^^b11^^b22
2^^b11^^b32
1^^b1^^b4
^^b1^^b43^^b2^^ae
2^^b11^^b52
2^^b11^^b62
2^^b11^^b72
2^^b11^^b82
2^^b11^^b92
2^^b11^^ba2
^^b12^^ba^^e2
^^b13^^ba^^e2^^a5
2^^b11^^bb2
^^b1^^bc2
^^b11^^bc^^ab
2^^b11^^e02
2^^b11^^e1
2^^b11^^e22
2^^b11^^e32
2^^b11^^e42
1^^b2^^a1
2^^b21^^a2
2^^b21^^a32
2^^b21^^a42
1^^b2^^a5
2^^b21^^a62
2^^b21^^a7
2^^b21^^a82
1^^b2^^a9
^^b2^^a93^^b12^^a6
2^^b21^^aa2
2^^b21^^ab2
2^^b21^^ac2
^^b21^^ad^^ae
1^^b2^^ae
2^^b21^^ae^^b1^^a1
^^b21^^ae^^b7
2^^b21^^af2
2^^b21^^b12
2^^b21^^b2
2^^b21^^b32
1^^b2^^b4
2^^b21^^b52
^^b21^^b6
2^^b21^^b7
2^^b21^^b8
2^^b21^^b92
2^^b21^^ba
2^^b21^^bb2
2^^b21^^bc2
2^^b21^^e02
2^^b21^^e12
2^^b21^^e22
2^^b21^^e3
^^b3^^a13^^e3^^a3
2^^b31^^a2
2^^b31^^a32
2^^b31^^a4
^^b3^^a5^^b64^^b2^^b3^^b2.
2^^b3^^a62
^^b31^^a6^^a1
2^^b31^^a7
2^^b31^^a8
^^b3^^aa2
^^b31^^aa^^b4
2^^b31^^ab2
2^^b31^^ac2
2^^b31^^ad
2^^b31^^af
2^^b3^^b12
^^b31^^b1^^ae
^^b31^^b1^^b5
2^^b31^^b22
2^^b31^^b3
^^b32^^b5
^^b3^^b82
^^b32^^b9
2^^b31^^ba2
2^^b31^^bb
2^^b31^^e0
2^^b31^^e22
2^^b31^^e3
^^b41^^a1
^^b42^^a1^^a1
^^b4^^a23^^ab^^a7
^^b4^^a23^^ab^^b9
^^b4^^a23^^b1^^aa
^^b4^^a23^^b1^^b8
^^b41^^a3
^^b42^^a3^^ac
^^b4^^a33^^b1^^ad
^^b41^^a4
^^b4^^a43^^a3^^ad
^^b4^^a43^^a3^^b1
^^b42^^a41^^a7
^^b4^^a43^^b1^^b3
^^b4^^a43^^b2^^a1
^^b41^^a5
^^b41^^a6
^^b41^^a7
^^b4^^a73^^b1^^a4
^^b41^^a8
^^b42^^a81^^a5^^b6
^^b42^^a81^^a6
^^b4^^a83^^a6^^ab
^^b4^^a83^^a6^^ad
^^b4^^a83^^b2^^a6
^^b41^^a9
^^b4^^a92^^a1
^^b41^^aa
^^b4^^aa3^^a6^^a4
^^b4^^aa3^^ab^^a4
^^b41^^ab
^^b42^^ab1^^a1^^b5
^^b4^^ab3^^a3^^b1
^^b4^^ab3^^a4^^a3
^^b42^^ab1^^a5^^aa
^^b4^^ab3^^a8^^a2
^^b4^^ab3^^a8^^ad
^^b4^^ab3^^ac^^aa
^^b4^^ab3^^ac^^e2
^^b4^^ab3^^ad^^a4
^^b4^^ab3^^b7^^a6
^^b4^^ab3^^ba^^a6
^^b41^^ac
^^b4^^ac3^^a4^^a3
^^b4^^ac3^^aa^^a6
^^b4^^ac3^^b2^^a3
^^b4^^ac3^^b2^^e2
^^b4^^ac2^^b3^^b8
^^b4^^ac3^^b7^^a6
^^b4^^ac3^^b9^^a6
^^b4^^ac3^^ba^^ad
^^b4^^ac3^^bb^^b1
^^b41^^ad
^^b4^^ad3^^a3^^a4
^^b4^^ad3^^a3^^b1
^^b4^^ad3^^a4^^a3
^^b4^^ad3^^a4^^ac
^^b4^^ad3^^a4^^b1
^^b4^^ad3^^a8^^b6
^^b4^^ad3^^aa^^ab
^^b4^^ad3^^b3^^b1
^^b4^^ad3^^b7^^b1
^^b4^^ad3^^bc^^a7
^^b4^^ad3^^bc^^ac
^^b4^^ad3^^bc^^b1
^^b4^^ad3^^e2^^b1
^^b41^^ae
^^b41^^af
^^b4^^af3^^b1^^b9
^^b41^^b0
^^b41^^b1
^^b4^^b13^^a2^^ab
^^b4^^b13^^a2^^ad
^^b4^^b13^^a3^^a7
^^b4^^b13^^a4^^a8
^^b4^^b13^^a4^^b2
^^b4^^b13^^a6^^ab
^^b4^^b13^^a8^^a2
^^b4^^b13^^a8^^ac
^^b4^^b13^^aa^^a6
^^b4^^b13^^aa^^ab
^^b4^^b13^^aa^^b1
^^b4^^b13^^b2^^a7
^^b4^^b13^^b2^^ac
^^b4^^b13^^b2^^b9
^^b4^^b13^^b3^^ab
^^b4^^b13^^b5^^b2
^^b4^^b13^^b7^^a6
^^b4^^b13^^ba^^b6
^^b4^^b13^^bb^^ab
^^b4^^b13^^e3^^a4
^^b4^^b23^^a6^^ab
^^b4^^b23^^a6^^ac
^^b4^^b23^^a6^^b1
^^b4^^b23^^aa^^a4
^^b4^^b23^^aa^^b1
^^b42^^b2^^ae
^^b4^^b23^^b1^^a6
^^b4^^b23^^b1^^ad
^^b4^^b23^^b3^^a4
^^b4^^b23^^b3^^a6
^^b4^^b23^^b3^^ac
^^b4^^b23^^e2^^a4
^^b4^^b23^^e2^^a6
^^b41^^b3
^^b42^^b31^^aa
^^b4^^b31^^b1
^^b41^^b4
^^b4^^b53^^ab^^a4
^^b4^^b53^^e3^^a3
^^b4^^b61^^a6
^^b4^^b61^^a8
^^b4^^b63^^ac^^a4
^^b4^^b63^^ac^^ad
^^b4^^b63^^ac^^b1
^^b4^^b63^^b2^^a6
^^b41^^b7
^^b4^^b73^^b1^^ac
^^b41^^b8
^^b4^^b81^^a4
^^b41^^b9
^^b4^^b93^^a6^^b1
^^b4^^b93^^b3^^ac
^^b4^^b93^^b3^^b1
^^b41^^ba
^^b4^^ba3^^ad^^a4
^^b41^^bb
^^b4^^bb3^^a6^^ab
^^b42^^bb^^b6
^^b4^^bb3^^b6^^a4
^^b4^^bb3^^b6^^a9
^^b4^^bb3^^b6^^b4
^^b41^^bc^^a1
^^b41^^bc^^a5
^^b4^^bc3^^a6^^ab
^^b4^^bc3^^a6^^b1
^^b41^^e0
^^b4^^e03^^a6^^a4
^^b4^^e03^^a6^^b1
^^b42^^e0^^b9
^^b41^^e1
^^b4^^e13^^a6^^b1
^^b4^^e13^^aa^^a6
^^b42^^e1^^b9
^^b41^^e2
^^b4^^e21^^a6
^^b4^^e23^^a6^^a4
^^b4^^e23^^ab^^a7
^^b4^^e23^^ab^^ac
^^b4^^e23^^ab^^b9
^^b42^^e21^^ac
^^b4^^e21^^b1
^^b4^^e23^^b1^^ba
^^b4^^e23^^b3^^a6
^^b41^^e3
^^b42^^e3^^ab
^^b4^^e33^^b1^^a1
^^b4^^e33^^b1^^a9
^^b41^^e4
1^^b5^^a1
2^^b51^^a2
2^^b51^^a4
1^^b5^^a5
2^^b51^^a6
2^^b51^^a7
2^^b51^^a82
1^^b5^^a9
2^^b51^^a9^^a1^^b1
2^^b51^^aa
2^^b51^^ab2
2^^b51^^ac
2^^b51^^ad
1^^b5^^ae
2^^b51^^b1
^^b5^^b12^^a4
^^b5^^b12^^b6
2^^b51^^b22
2^^b51^^b3
1^^b5^^b4
2^^b51^^b6
2^^b51^^b92
2^^b51^^ba
2^^b51^^bb
^^b5^^e22
^^b51^^e32
1^^b6^^a1
^^b61^^a3
^^b61^^a4
1^^b6^^a5
^^b6^^a62
^^b61^^a6^^a4
^^b63^^a6^^a8^^ae
^^b63^^a6^^b2^^ac
^^b63^^a6^^b2^^ae
^^b61^^a7
1^^b6^^a9
2^^b6^^ab2
^^b61^^ab^^a5
^^b61^^ab^^ae
^^b61^^ac2
^^b61^^ad2
1^^b6^^ae
^^b61^^b0
^^b61^^b12
^^b61^^b22
^^b61^^b32
1^^b6^^b4
^^b61^^b6
^^b61^^b7
^^b61^^b9
^^b61^^bb2
1^^b7^^a1^^b3
2^^b71^^a22
^^b71^^a3
2^^b71^^a42
2^^b7^^a62
^^b71^^a6^^a9
^^b71^^a6^^b9
2^^b71^^a7
2^^b71^^a82
^^b71^^aa2
2^^b71^^ab2
2^^b71^^ac2
2^^b71^^ad
2^^b71^^b12
2^^b71^^b22
^^b71^^b3
^^b72^^b3^^b8
^^b71^^b5
^^b7^^b5^^b12
^^b71^^b62
2^^b71^^b9
^^b71^^bc2
2^^b71^^e0
^^b71^^e1
2^^b81^^a2
2^^b8^^a42
2^^b81^^a62
2^^b81^^a7
2^^b81^^a8
2^^b8^^ab2
2^^b81^^ac2
2^^b8^^ad2
^^b81^^ad^^a5
^^b81^^ad^^ae
2^^b8^^b12
^^b81^^b1^^a5
2^^b8^^b2
2^^b81^^b9
1^^b9^^a1
^^b9^^a13^^e2^^a6
^^b91^^a3
2^^b91^^a4
1^^b9^^a5
2^^b91^^a62
^^b91^^a7
2^^b91^^a8
1^^b9^^a9
^^b9^^a9^^a13^^a82
2^^b91^^aa2
2^^b91^^ab2
2^^b91^^ac
2^^b91^^ad
1^^b9^^ae
2^^b91^^af
2^^b91^^b1
2^^b91^^b2
2^^b91^^b32
^^b92^^b3^^a5^^b1^^a9
^^b92^^b3^^a5^^b1^^ae
1^^b9^^b4
^^b92^^b5
2^^b91^^b62
2^^b91^^b9
2^^b91^^ba
2^^b91^^e22
2^^b91^^e3
2^^ba1^^a2
2^^ba1^^a4
2^^ba1^^a62
2^^ba1^^a7
2^^ba1^^a8
2^^ba1^^ac
2^^ba1^^ad2
^^ba^^ae1
2^^ba1^^b12
2^^ba^^b2
2^^ba1^^b62
2^^ba1^^b9
^^ba^^e22
2^^bb1^^a2
2^^bb1^^a4
2^^bb1^^a62
2^^bb1^^a7
2^^bb1^^a82
2^^bb1^^aa
2^^bb1^^ab
2^^bb1^^ac2
2^^bb1^^ad
2^^bb1^^b1
2^^bb1^^b2
^^bb2^^b62
^^bb1^^b6^^a4
^^bb1^^b6^^ad
^^bb1^^b6^^b1
2^^bb1^^b7
2^^bb1^^b9
^^bb^^e22
^^bc^^a1^^b14^^bb^^a6^^b2.
2^^bc1^^a32
2^^bc1^^a62
2^^bc1^^a7
2^^bc^^a8
1^^bc^^a9
2^^bc1^^ab2
2^^bc1^^ac
2^^bc^^ad
^^bc1^^ad^^a5
2^^bc1^^b12
2^^bc^^b2
1^^bc^^b4
1^^bc^^b72
^^bc2^^e1
^^e0^^a13^^a3^^ab
2^^e01^^a2
2^^e01^^a3
2^^e01^^a62
2^^e01^^aa2
^^e01^^ab^^a9
^^e0^^ac2
^^e01^^ac^^a4
^^e01^^ac^^a5
^^e01^^ac^^ae
^^e01^^ac^^b8
2^^e01^^ad
^^e0^^b12
^^e01^^b1^^a8
^^e0^^b82
1^^e1^^a1
2^^e11^^a4
1^^e1^^a5
2^^e11^^a62
1^^e1^^a9
^^e11^^aa2
^^e11^^ab^^ae
2^^e11^^ac2
2^^e11^^ad
1^^e1^^ae
2^^e11^^b1
1^^e1^^b4
^^e1^^b82
^^e2^^a12^^ab1^^a1^^e2
2^^e21^^a2
^^e2^^a32
2^^e21^^a42
2^^e2^^a62
^^e21^^a6^^a5
^^e21^^a6^^a9
^^e21^^a6^^b1
2^^e2^^a72
2^^e21^^a8
2^^e21^^ab2
^^e2^^ac2
2^^e21^^ad
2^^e21^^af
2^^e2^^b12
2^^e21^^b22
2^^e21^^b32
2^^e21^^b6
2^^e2^^b8
2^^e21^^b92
2^^e21^^ba
2^^e21^^bb
2^^e21^^e0
2^^e21^^e2
2^^e2^^e42
2^^e3^^a32
2^^e31^^a4
^^e3^^a62
2^^e31^^a8
^^e3^^ae2^^b11
^^e3^^ae3^^b1^^a9
^^e32^^b1
^^e31^^b1^^a1
2^^e31^^b2
^^e32^^b9
1^^e4^^a1
^^e41^^a32
1^^e4^^a5
1^^e4^^a9
^^e41^^aa2
^^e41^^ac
^^e41^^af
^^e41^^b1
^^e41^^b2
^^e41^^b5
^^e41^^b6
^^e41^^b7
^^e41^^b82
^^e41^^e22
}
\egroup

