=begin Quest For Glory (Sierra) Game System

=head1 AI messaging system, Message.pm6, AIMessage.pm6, AI.pm6

A Messsage (Message.pm6) has 4 attributes : an originator (source 
instance of the message), an acceptor (target intstance of the message), 
friend-or-foe and a message body, which needs to be parsed when passing
a message to an entity.

There is a split-message which returns an array with each attribute in it.

An AIMessage (AIMessage.pm6) has a fifth attribute which is a timestamp. 

The method pass-message($entity, $msg) dispatches the AIMessage $msg to 
Entity $entity. A subclass of Entity then parses the message $msg.

A single send to the acceptor entity is done with the method 
send-message-to-target($msg, @entities), it matches for an acceptor instance
in the @entities list, then returns a return-message if non-Nil.

flush everything, without targets, everything might be a target with
method flush-messages-to-all-entities(@entities), which empties the
message list cache in the AI.pm6 instance.

The method flush-first-message-to-entities(@entities) takes the first message
from AI.pm6's and dispatches it to all entities in the list @entities. 

flush-message-to-entities($msg, @entities) does the same as 
flush-messages-to-all-entities, except that it takes a $msg argument.

=head2 Entity.pm6 and Room.pm6

These are base classes for NPCs (Non-Player Characters) and rooms in the game.

Entity has a pass-message($msg) method and a paint($screen) for use with the
graphics system (e.g. SDL2, SDL).

Room also has a paint($screen) method. A subclass might take messages.

=head3 Entity and Room subclasses

There are several Quest For Glory subclassed entities and rooms which will be
used for the knowledge/rule-based system to send messages to. An example is
Baron.pm6 and Baronscastle.pm6.

=head4 TODO

The rule-based system is not coded yet but will provide Quest for Glory rules
for building Non-Player Characters (NPCs) in rooms.


=end
