use v6.c;
use Mathx::Stat::DistributionPopulation;

class Bayes::Learn::DecisionRule is Mathx::Stat::DistributionPopulation {

	### has $.decisions;

	method BUILD(:@decisiondistrib) {
		@.population = @decisiondistrib;
	}

	method gen {
		return @.population[(0..^@.population.elems).rand];
	}	

	method decide-on-risk($action) {
		my $p = self.gen;
			
		return $action.BayesianLoss($p); ### Risk on cond P or P
	}	

}

