class NESROMAgent is Agent 
{
	has $.romdb;
	
	method BUILD($stat) {
		super.BUILD($stat);

		.romdb = new ROMDB();	

	}

	method ask(%args) {
		my $string = super.ask(%args) . 
				"ask about roms\n" .
				"get roms\n" .
				"agent\n";
		
		return $string;
	}


	method ask_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {

			if (.romdb.search($key)) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .musicdb.search($key));
		}
		return @roms;
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process roms or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask about roms" { self.ask_roms(%optargs) }
		when "get roms" { self.get_roms(%optargs) }
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
