class NESMusicAgent is MusicAgent
{	
	method BUILD($stat) {
		super.BUILD($stat);
	}

	method ask(%args) {
		my $string = super.ask(%args) . 
				"ask about music roms\n" .
				"get music roms\n" .
				"list music roms\n" .
				"agent\n";
		
		return $string;
	}


	method ask_music_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {
			if (.musicdb.search($key) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_music_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .musicdb.search($key));
		}
		return @roms;
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process music or anything from $agent here

		return &$agent.dispatch;
	} 

	method dispatch($msg, %optargs) {
		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask about music roms" { self.ask_music_roms(%optargs) }
		when "get music roms" { self.get_music_roms(%optargs) }
		when "list music roms" { self.list_musicdb_keys(%optargs) } 
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
