package Foo::Testmysqlorm::Team;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';
use Foo::Testmysqlorm::Team::ResultClass;
use Foo::Testmysqlorm::Team::ResultClassX;

extends 'MySQL::ORM';

with 'Foo::Testmysqlorm::Team::CustomRole';

has table_name => (
    is       => 'ro',
    isa      => 'Str',
    init_arg => undef,
    default  => 'team',
);

method delete (
    Num|HashRef :$team_id,
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city
) {
    my %a = @_;
    my %w;

    foreach my $arg ( keys %a ) {
        $w{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::delete(
        table => $self->table_name,
        where => \%w
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method get_id (
    Str|HashRef :$team_name,
    Num|HashRef :$league_id
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        $where{$arg} = $a{$arg};
    }

    my $rows = $self->SUPER::select(
        table => $self->table_name,
        where => \%where
    );

    if ( @$rows == 1 ) {
        my $row = shift @$rows;
        return $row->{league_id};
    }

    confess "too many rows returned" if @$rows > 1;

    return;
}

method insert (
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city
) {
    my %a = @_;
    my %v;

    foreach my $arg ( keys %a ) {
        $v{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::insert(
        table  => $self->table_name,
        values => \%v
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method is_primary_key_autoinc (
) {
    return 1;
}

method select (
    Num|HashRef :$team_id,
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city,
    ArrayRef :$order_by
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        next if $arg eq 'order_by';
        $where{$arg} = $a{$arg};
    }

    my %s;
    $s{table}    = $self->table_name;
    $s{where}    = \%where;
    $s{order_by} = $order_by if $order_by;

    my $rows = $self->SUPER::select(%s);

    my @obj;
    foreach my $row (@$rows) {
        push @obj, Foo::Testmysqlorm::Team::ResultClass->new(%$row);
    }

    return @obj;
}

method select_one (
    Num|HashRef :$team_id,
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        $where{$arg} = $a{$arg};
    }

    my $row = $self->SUPER::select_one(
        table => $self->table_name,
        where => \%where
    );
    if ($row) {
        return Foo::Testmysqlorm::Team::ResultClass->new(%$row);
    }

    return;
}

method selectx (
    Num|HashRef :$team_id,
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id,
    Bool :$left_join,
    ArrayRef :$order_by
) {
    my %table2alias = (
        'league' => 't2',
        'team'   => 't1',
    );

    my %arg2table = (
        city        => 'team',
        league_id   => 'team',
        league_name => 'league',
        sport_id    => 'league',
        team_id     => 'team',
        team_name   => 'team',
    );

    my $sql = qq{
        select
            t1.team_id,
            t1.team_name,
            t1.league_id,
            t1.city,
            t2.league_name,
            t2.sport_id
        from
            team t1
        left
            join league t2 on (
                t1.league_id = t2.league_id
            )
    };

    my %a = $self->prune_ddl_args( [@_] );

    my %where;

    foreach my $arg ( keys %a ) {
        my $table = $arg2table{$arg};
        my $alias = $table2alias{$table};
        my $col   = "$alias.$arg";
        $where{$col} = $a{$arg};
    }

    my ( $where, @bind ) = $self->make_where_clause( where => \%where );
    $sql .= $where;

    if ($order_by) {
        my @order;
        foreach my $col (@$order_by) {
            my $table = $arg2table{$col};
            my $alias = $table2alias{$table};
            push @order, "$alias.$col";
        }
        $sql .= "order by " . join( ', ', @order );
    }

    my $sth = $self->dbh->prepare($sql);
    $sth->execute(@bind);

    my @obj;

    while ( my $row = $sth->fetchrow_hashref ) {
        push @obj, Foo::Testmysqlorm::Team::ResultClassX->new(%$row);
    }

    return @obj;
}

method selectx_one (
    Num|HashRef :$team_id,
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id,
    Bool :$left_join
) {
    my @rows = $self->selectx(@_);
    if (@rows) {
        return shift @rows;
    }

    return;
}

method update (
    Foo::Testmysqlorm::Team::ResultClass :$set,
    Num|HashRef :$team_id,
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        next if $arg eq 'set';
        $where{$arg} = $a{$arg};
    }

    my %values;
    my @attrs = $set->get_touched_attributes;
    foreach my $attr (@attrs) {
        $values{$attr} = $set->$attr;
    }

    my $ret = $self->SUPER::update(
        table  => $self->table_name,
        values => \%values,
        where  => \%where
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method upsert (
    Str|HashRef :$team_name,
    Num|HashRef :$league_id,
    Str|HashRef :$city
) {
    my %a = @_;
    my %v;

    foreach my $arg ( keys %a ) {
        $v{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::upsert(
        table  => $self->table_name,
        values => \%v
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

1;
