// Do not edit this file - Generated by Perlito5 9.0
//
// lib/Perlito5/Javascript2/Runtime.js
//
// Runtime for "Perlito" Perl5-in-Javascript2
//
// AUTHORS
//
// Flavio Soibelmann Glock  fglock@gmail.com
//
// COPYRIGHT
//
// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.
//
// This program is free software; you can redistribute it and/or modify it
// under the same terms as Perl itself.
//
// See http://www.perl.com/perl/misc/Artistic.html

"use strict";
var isNode = typeof require != "undefined";

if (typeof p5pkg !== "object") {
    var p5pkg = {};
    var p5LOCAL = [];

    var universal = function () {};
    p5pkg.UNIVERSAL = new universal();
    p5pkg.UNIVERSAL._ref_ = "UNIVERSAL";
    p5pkg.UNIVERSAL.isa = function (List__) {
        // TODO - use @ISA
        return List__[0]._class_._ref_ == List__[1]
    };
    p5pkg.UNIVERSAL.can = function (List__) {
        var o = List__[0];
        var s = List__[1];
        if ( s.indexOf("::") == -1 ) {
            return p5method_lookup(s, o._class_._ref__, {})
        }
        var c = s.split("::");
        s = c.pop(); 
        return p5method_lookup(s, c.join("::"), {});
    };
    p5pkg.UNIVERSAL.DOES = p5pkg.UNIVERSAL.can;

    var core = function () {};
    p5pkg["CORE"] = new core();
    p5pkg["CORE"]._ref_ = "CORE";

    var core_global = function () {};
    core_global.prototype = p5pkg.CORE;
    p5pkg["CORE::GLOBAL"] = new core_global();
    p5pkg["CORE::GLOBAL"]._ref_ = "CORE::GLOBAL";

    var p5_error = function (type, v) {
        this.type = type;
        this.v = this.message = v;
        this.toString = function(){
            if (this.type == 'break') {
                return 'Can\'t "break" outside a given block'
            }
            if (this.type == 'next' || this.type == 'last' || this.type == 'redo') {
                if (this.v == "") { return 'Can\'t "' + this.type + '" outside a loop block' }
                return 'Label not found for "' + this.type + ' ' + this.v + '"';
            }
            return this.v;
        };
    };
    p5_error.prototype = Error.prototype;
}

function p5make_package(pkg_name) {
    if (!p5pkg.hasOwnProperty(pkg_name)) {
        var tmp = function () {};
        tmp.prototype = p5pkg["CORE::GLOBAL"];
        p5pkg[pkg_name] = new tmp();
        p5pkg[pkg_name]._ref_ = pkg_name;
        p5pkg[pkg_name]._class_ = p5pkg[pkg_name];  // XXX memory leak
        p5pkg[pkg_name]._is_package_ = 1;

        // TODO - add the other package global variables
        p5pkg[pkg_name]["List_ISA"] = [];
        p5pkg[pkg_name]["v_a"] = null;
        p5pkg[pkg_name]["v_b"] = null;
        p5pkg[pkg_name]["v__"] = null;
        p5pkg[pkg_name]["v_AUTOLOAD"] = null;
    }
    return p5pkg[pkg_name];
}

function p5code_lookup_by_name(package_name, sub_name) {
    // sub_name can be a function already
    if (typeof sub_name === "function") {
        return sub_name;
    }
    // sub_name can have an optional namespace
    var parts = sub_name.split(/::/);
    if (parts.length > 1) {
        sub_name = parts.pop();
        package_name = parts.join("::");
    }
    if (p5pkg.hasOwnProperty(package_name)) {
        var c = p5pkg[package_name];
        if ( c.hasOwnProperty(sub_name) ) {
            return c[sub_name]
        }
    }
    return null;
}

function p5get_class_for_method(method, class_name, seen) {
    // default mro
    // TODO - cache the methods that were already looked up
    if ( p5pkg[class_name].hasOwnProperty(method) ) {
        return class_name
    }
    var isa = p5pkg[class_name].List_ISA;
    if (isa) {
        for (var i = 0; i < isa.length; i++) {
            if (!seen[isa[i]]) {
                var m = p5get_class_for_method(method, isa[i], seen);
                if (m) {
                    return m 
                }
                seen[isa[i]]++;
            }
        }
    }
}

function p5method_lookup(method, class_name, seen) {
    var c = p5get_class_for_method(method, class_name, seen);
    if (c) {
        return p5pkg[c][method]
    }
    if ( p5pkg.UNIVERSAL.hasOwnProperty(method) ) {
        return p5pkg.UNIVERSAL[method]
    }
}

function p5method_not_found(method, class_name) {
    return "Can't locate object method \""
        + method + "\" via package \"" + class_name + "\" (perhaps you forgot to load \""
        + class_name + "\"?)";
}

function p5call(invocant, method, list, p5want) {
    var invocant_original = invocant;
    if (typeof invocant === "string") {
        list.unshift(invocant);
        invocant = p5make_package(invocant);
    }
    else if ( invocant.hasOwnProperty("_is_package_") ) {
        list.unshift(invocant._ref_);   // invocant is a "package" object
    }
    else {
        list.unshift(invocant);
    }

    if ( invocant.hasOwnProperty("_class_") ) {

        if ( invocant._class_.hasOwnProperty(method) ) {
            return invocant._class_[method](list, p5want)
        }
        var m = p5method_lookup(method, invocant._class_._ref_, {});
        if (m) {
            return m(list, p5want)
        }

        // method can have an optional namespace
        var pkg_name = method.split(/::/);
        if (pkg_name.length > 1) {
            var name = pkg_name.pop();
            pkg_name = pkg_name.join("::");
            m = p5method_lookup(name, pkg_name, {});
            if (m) {
                return m(list, p5want)
            }
            p5pkg.CORE.die([p5method_not_found(name, pkg_name)]);
        }

        if (method == "print" || method == "printf" || method == "say" || method == "close") {
            list.shift();
            return p5pkg['Perlito5::IO'][method]( invocant_original, list, p5want);
        }

        pkg_name = p5get_class_for_method('AUTOLOAD', invocant._class_._ref_, {}) || p5get_class_for_method('AUTOLOAD', "UNIVERSAL", {});
        if (pkg_name) {
            p5pkg[pkg_name]["v_AUTOLOAD"] = invocant._class_._ref_ + "::" + method;
            return p5pkg[pkg_name]["AUTOLOAD"](list, p5want);
        }
        p5pkg.CORE.die([p5method_not_found(method, invocant._class_._ref_)]);
    }
    p5pkg.CORE.die(["Can't call method ", method, " on unblessed reference"]);
}

function p5call_sub(namespace, name, list, p5want) {
    if(p5pkg[namespace].hasOwnProperty(name)) {
        return p5pkg[namespace][name](list, p5want)
    }
    if(p5pkg[namespace].hasOwnProperty("AUTOLOAD")) {
        p5pkg[namespace]["v_AUTOLOAD"] = namespace + "::" + name;
        return p5pkg[namespace]["AUTOLOAD"](list, p5want)
    }
    p5pkg.CORE.die(["Undefined subroutine &" + namespace + "::" + name]);
}

function p5sub_exists(name, current_pkg_name) {
    var v = name;
    var pkg_name = v.split(/::/);
    if (pkg_name.length > 1) {
        v = pkg_name.pop();
        pkg_name = pkg_name.join("::");
    }
    else {
        pkg_name = current_pkg_name;
    }
    var c = v.charCodeAt(0);
    if (c < 27) {
        v = String.fromCharCode(c + 64) + v.substr(1);
        pkg_name = 'main';
    }
    return p5pkg.hasOwnProperty(pkg_name) && p5pkg[pkg_name].hasOwnProperty(v) 
}

function p5sub_prototype(name, current_pkg_name) {
    if (!name) {
        return null;
    }
    if (typeof name === "function") {
        return name._prototype_;
    }
    var v = name;
    var pkg_name = v.split(/::/);
    if (pkg_name.length > 1) {
        v = pkg_name.pop();
        pkg_name = pkg_name.join("::");
    }
    else {
        pkg_name = current_pkg_name;
    }
    var c = v.charCodeAt(0);
    if (c < 27) {
        v = String.fromCharCode(c + 64) + v.substr(1);
        pkg_name = 'main';
    }
    if (p5pkg.hasOwnProperty(pkg_name) && p5pkg[pkg_name].hasOwnProperty(v)) {
        return p5pkg[pkg_name][v]._prototype_
    }
    return p5pkg["Perlito5"].v_PROTO._hash_[name] || p5pkg["Perlito5"].v_CORE_PROTO._hash_[name]
}

function p5scalar_deref(v, current_pkg_name, autoviv_type) {
    if (typeof v === "string") {
        var pkg_name = v.split(/::/);
        if (pkg_name.length > 1) {
            v = pkg_name.pop();
            pkg_name = pkg_name.join("::");
        }
        else {
            pkg_name = current_pkg_name;
        }
        var c = v.charCodeAt(0);
        if (c < 27) {
            v = String.fromCharCode(c + 64) + v.substr(1);
            pkg_name = 'main';
        }
        var name = "v_"+v;
        if (!p5make_package(pkg_name)[name]) {
            if (autoviv_type == 'array') {
                p5pkg[pkg_name][name] = new p5ArrayRef([]);
            }
            else if (autoviv_type == 'hash') {
                p5pkg[pkg_name][name] = new p5HashRef([]);
            }
            else if (autoviv_type == 'scalar') {
                p5pkg[pkg_name][name] = new p5ScalarRef([]);
            }
        }
        return p5pkg[pkg_name][name];
    }
    if (!v._scalar_) {
        if (autoviv_type == 'array') {
            v._scalar_ = new p5ArrayRef([]);
        }
        else if (autoviv_type == 'hash') {
            v._scalar_ = new p5HashRef([]);
        }
        else if (autoviv_type == 'scalar') {
            v._scalar_ = new p5ScalarRef([]);
        }
    }
    return v._scalar_;
}

function p5scalar_deref_set(v, n, current_pkg_name) {
    if (typeof v === "string") {
        var pkg_name = v.split(/::/);
        if (pkg_name.length > 1) {
            v = pkg_name.pop();
            pkg_name = pkg_name.join("::");
        }
        else {
            pkg_name = current_pkg_name;
        }
        var c = v.charCodeAt(0);
        if (c < 27) {
            v = String.fromCharCode(c + 64) + v.substr(1);
            pkg_name = 'main';
        }
        var name = "v_"+v;
        p5make_package(pkg_name)[name] = n;
        return p5pkg[pkg_name][name];
    }
    v._scalar_ = n;
    return v._scalar_;
}

function p5array_deref(v, current_pkg_name) {
    if (typeof v === "string") {
        var pkg_name = v.split(/::/);
        if (pkg_name.length > 1) {
            v = pkg_name.pop();
            pkg_name = pkg_name.join("::");
        }
        else {
            pkg_name = current_pkg_name;
        }
        var c = v.charCodeAt(0);
        if (c < 27) {
            v = String.fromCharCode(c + 64) + v.substr(1);
            pkg_name = 'main';
        }
        var name = "List_"+v;
        if (!p5make_package(pkg_name)[name]) {
                p5pkg[pkg_name][name] = [];
        }
        return p5pkg[pkg_name][name];
    }
    return v._array_;
}

function p5hash_deref(v, current_pkg_name) {
    if (typeof v === "string") {
        var pkg_name = v.split(/::/);
        if (pkg_name.length > 1) {
            v = pkg_name.pop();
            pkg_name = pkg_name.join("::");
        }
        else {
            pkg_name = current_pkg_name;
        }
        var c = v.charCodeAt(0);
        if (c < 27) {
            v = String.fromCharCode(c + 64) + v.substr(1);
            pkg_name = 'main';
        }
        var name = "Hash_"+v;
        if (!p5make_package(pkg_name)[name]) {
                p5pkg[pkg_name][name] = [];
        }
        return p5pkg[pkg_name][name];
    }
    return v._hash_;
}

// regex globals
p5make_package("Regex");
var p5_last_regex = new RegExp("", "");
var p5_regex_capture = [];

p5make_package("main");
p5make_package("Perlito5");
p5pkg["Perlito5"].v_PKG_NAME = "main";
p5make_package("main::STDIN").file_handle = { id : 0, readline_buffer : '' };
p5make_package("main::STDOUT").file_handle = { id : 1 };
p5make_package("main::STDERR").file_handle = { id : 2 };
p5make_package("ARGV").file_handle = { id : null };
p5pkg["STDOUT"] = p5pkg["main::STDOUT"];
p5pkg["STDERR"] = p5pkg["main::STDERR"];
p5pkg["STDIN"] = p5pkg["main::STDIN"];
p5pkg["Perlito5"].v_SELECT = "main::STDOUT";
p5pkg["main"]["v_@"] = [];      // $@
p5pkg["main"]["v_|"] = 0;       // $|
p5pkg["main"]["v_/"] = "\n";    // $/
p5pkg["main"]['v_"'] = " ";     // $"
p5pkg["main"]["List_#"] = [];   // @#
p5scalar_deref_set(String.fromCharCode(15), isNode ? "node.js" : "javascript2");  // $^O
p5pkg["main"]["List_INC"] = [];
p5pkg["main"]["Hash_INC"] = {};
p5pkg["main"]["List_ARGV"] = [];
p5pkg["main"]["Hash_ENV"] = {};
p5pkg["main"]["Hash_SIG"] = {};
if (isNode) {
    p5pkg["main"]["List_ARGV"] = process.argv.splice(2);

    p5pkg["main"]["Hash_ENV"] = {};
    for (var e in process.env) p5pkg["main"]["Hash_ENV"][e] = process.env[e];

    p5pkg["main"]["v_$"] = process.pid;   // $$
    p5scalar_deref_set(String.fromCharCode(24), process.argv[0]);  // $^X
} else if (typeof arguments === "object") {
    p5pkg["main"]["List_ARGV"] = arguments;
}

p5make_package("Perlito5::IO");
p5make_package("Perlito5::Runtime");
p5make_package("Perlito5::Grammar");

var sigils = { '@' : 'List_', '%' : 'Hash_', '$' : 'v_', '&' : '' };

function p5typeglob_set(namespace, name, obj) {
    p5make_package(namespace);
    if ( obj.hasOwnProperty("_ref_") ) {
        if ( obj._ref_ == "HASH" ) {
            p5pkg[namespace][sigils['%'] + name] = obj._hash_;
        }
        else if ( obj._ref_ == "ARRAY" ) {
            p5pkg[namespace][sigils['@'] + name] = obj._array_;
        }
        else if ( obj._ref_ == "SCALAR" ) {
            p5pkg[namespace][sigils['$'] + name] = obj._scalar_;
        }
        else if ( obj._ref_ == "CODE" ) {
            p5pkg[namespace][sigils['&'] + name] = obj._code_;
        }
        else if ( obj._ref_ == "GLOB" ) {
            // TODO
            p5pkg[namespace][name] = obj;
        }
    }
    else {
        p5pkg[namespace][name] = obj;   // native CODE
        // TODO - non-reference
    }
    return p5pkg[namespace][name];  // TODO - return GLOB
}

function p5typeglob_deref_set(v, obj, current_pkg_name) {
    if (typeof v === "string") {
        var pkg_name = v.split(/::/);
        if (pkg_name.length > 1) {
            v = pkg_name.pop();
            pkg_name = pkg_name.join("::");
        }
        else {
            pkg_name = current_pkg_name;
        }
        return p5typeglob_set(pkg_name, v, obj);
    }
    CORE.die(["TODO: can't p5typeglob_deref_set()"]);
}

function p5cleanup_local(idx, value) {
    while (p5LOCAL.length > idx) {
        var l = p5LOCAL.pop();
        l();
    }
    return value;
}

//-------- Reference

var p5id = Math.floor(Math.random() * 1000000000) + 1000000000;

function p5HashRef(o) {
    this._hash_ = o;
    this._ref_ = "HASH";
    this.bool = function() { return 1 };
}

function p5ArrayRef(o) {
    this._array_ = o;
    this._ref_ = "ARRAY";
    this.bool = function() { return 1 };
}

function p5ScalarRef(o) {
    this._scalar_ = o;
    this._ref_ = "SCALAR";
    this.bool = function() { return 1 };
}

function p5GlobRef(o) {
    this._scalar_ = o;
    this._ref_ = "GLOB";
    this.bool = function() { return 1 };
}

function p5CodeRef(o) {
    this._code_ = o;
    this._ref_ = "CODE";
    this.bool = function() { return 1 };
}

//-------- Hash 

Object.defineProperty( Object.prototype, "p5hget", {
    enumerable : false,
    value : function (i) { return this[i] }
});
Object.defineProperty( Object.prototype, "p5hset", {
    enumerable : false,
    value : function (i, v) { this[i] = v; return this[i] }
});

Object.defineProperty( Object.prototype, "p5incr", {
    enumerable : false,
    value : function (i) {
        this[i] = p5incr_(this[i]);
        return this[i];
    }
});
Object.defineProperty( Object.prototype, "p5postincr", {
    enumerable : false,
    value : function (i) {
        var v = this[i];
        this[i] = p5incr_(this[i]);
        return v;
    }
});
Object.defineProperty( Object.prototype, "p5decr", {
    enumerable : false,
    value : function (i) {
        this[i] = p5decr_(this[i]);
        return this[i];
    }
});
Object.defineProperty( Object.prototype, "p5postdecr", {
    enumerable : false,
    value : function (i) {
        var v = this[i];
        this[i] = p5decr_(this[i]);
        return v;
    }
});

Object.defineProperty( Object.prototype, "p5hget_array", {
    enumerable : false,
    value : function (i) {
        if (this[i] == null) { this[i] = new p5ArrayRef([]) }
        return this[i]
    }
});
Object.defineProperty( Object.prototype, "p5hget_hash", {
    enumerable : false,
    value : function (i) {
        if (this[i] == null) { this[i] = new p5HashRef({}) }
        return this[i]
    }
});

//-------


var p5context = function(List__, p5want) {
    if (p5want) {
        return p5list_to_a(List__);
    }
    // scalar: return the last value
    var o = List__;
    if (o instanceof Array) {
        o =   o.length
            ? o[o.length-1]
            : null;
    }
    if (o instanceof Array) {
        o =   o.length
    }
    return o;
}

var p5list_to_a = function(args) {
    var res = [];
    for (var i = 0; i < args.length; i++) {
        var o = args[i];
        if  (  o == null
            || o._class_    // perl5 blessed reference
            || o._ref_      // perl5 un-blessed reference
            )
        {
            res.push(o);
        }
        else if (o instanceof Array) {
            // perl5 array
            for (var j = 0; j < o.length; j++) {
                res.push(o[j]);
            }
        }
        else if (typeof o === "object") {
            // perl5 hash
            for(var j in o) {
                if (o.hasOwnProperty(j)) {
                    res.push(j);
                    res.push(o[j]);
                }
            }
        }
        else {
            // non-ref
            res.push(o);
        }
    }
    return res;
};

var p5_list_of_refs = function(a) {
    // implements \( @a )
    var res = [];
    for (var i = 0; i < a.length; i++) {
        res.push(new p5ScalarRef(a[i]));
    }
    return res;
};

var p5a_to_h = function(a) {
    var res = {};
    for (var i = 0; i < a.length; i+=2) {
        res[p5str(a[i])] = a[i+1];
    }
    return res;
};

var p5idx = function(a, i) {
    return i >= 0 ? i : a.length + i
};

var p5smrt_scalar = function(a1, a2) {
    if (a2 == null) {
        return a1 == null;
    }
    if (typeof a2 == "string") {
        return p5str(a1) == a2;
    }
    if (typeof a2 == "number") {
        return p5num(a1) == a2;
    }
    CORE.die("Not implemented: smartmatch operator with argument type '", (typeof a2), "'");
};

var p5str = function(o) {
    if (o == null) {
        return "";
    }
    if (typeof o === "object") {
        if (o instanceof Array) {
            return CORE.join([""].concat(o));
        }
        if ( o.hasOwnProperty("_ref_") ) {
            var class_name = '';
            if (o._class_ && typeof o._class_._ref_ === "string") {
                // blessed reference
                // test for overload
                var meth = p5method_lookup('(""', o._class_._ref_, {});
                if (meth) {
                    return p5str(meth([o], 0));
                }
                // TODO - test the "fallback" flag
                meth = p5method_lookup('(0+', o._class_._ref_, {});
                if (meth) {
                    return p5str(meth([o], 0));
                }
                // no overload, strigify the reference instead
                class_name = o._class_._ref_ + '=';
            }
            if (!o._id_) { o._id_ = p5id++ }
            return [class_name, o._ref_, '(0x', o._id_.toString( 16 ), ')'].join('');
        }
    }
    if (typeof o === "function") {
        var class_name = '';
        if (o._class_ && typeof o._class_._ref_ === "string") {
            // blessed reference
            class_name = o._class_._ref_ + '=';
        }
        if (!o._id_) { o._id_ = p5id++ }
        return [class_name, 'CODE(0x', o._id_.toString( 16 ), ')'].join('');
    }
    if (typeof o == "number" && Math.abs(o) < 0.0001 && o != 0) {
        return o.toExponential().replace(/e-(\d)$/,"e-0$1");
    }
    if (typeof o === "boolean") {
        return o ? "1" : "";
    }
    if (typeof o !== "string") {
        return "" + o;
    }
    return o;
};

var p5num = function(o) {
    if (o == null) {
        return 0;
    }
    if (typeof o === "object") {
        if (o instanceof Array) {
            return o.length;
        }
        if ( o.hasOwnProperty("_ref_") ) {
            if (o._class_ && typeof o._class_._ref_ === "string") {
                // blessed reference
                // test for overload
                var meth = p5method_lookup('(0+', o._class_._ref_, {});
                if (meth) {
                    return p5num(meth([o], 0));
                }
                // TODO - test the "fallback" flag
                meth = p5method_lookup('(""', o._class_._ref_, {});
                if (meth) {
                    return p5num(meth([o], 0));
                }
            }
        }
    }
    if (typeof o !== "number") {
        var s = p5str(o).trim();
        var s1 = s.substr(0, 3).toUpperCase();
        if ( s1 == "NAN" ) { return NaN };
        if ( s1 == "INF" ) { return Infinity };
        s1 = s.substr(0, 4).toUpperCase();
        if ( s1 == "-NAN" ) { return NaN };
        if ( s1 == "-INF" ) { return -Infinity };
        s1 = parseFloat(s);
        if ( isNaN(s1) ) { return 0 };
        return s1;
    }
    return o;
};

var p5bool = function(o) {
    if (o) {
        if (typeof o === "boolean") {
            return o;
        }
        if (typeof o === "number") {
            return o;
        }
        if (typeof o === "string") {
            return o != "" && o != "0";
        }
        if (typeof o.length === "number") {
            return o.length;
        }
        if (o instanceof Error) {
            return true;
        }
        for (var i in o) {
            return true;
        }
    }
    return false;
};

var p5incr_ = function(o) {
    if (typeof o === "number") {
        return o + 1;
    }
    return p5str_inc(p5str(o));
};

var p5decr_ = function(o) {
    if (typeof o === "number") {
        return o - 1;
    }
    return p5num(o) - 1;
};

var p5modulo = function(o, k) {
    var m = o % k;
    if ( k < 0 && m > 0 ) {
        m = m + k;
    }
    else if ( k > 0 && m < 0 ) {
        m = m + k;
    }
    return m;
};

var p5shift_left = function(o, k) {
    return k < 31 ? o << k : o * Math.pow(2, k);
};

var p5and = function(a, fb) {
    if (p5bool(a)) {
        return fb();
    }
    return a;
};

var p5or = function(a, fb) {
    if (p5bool(a)) {
        return a;
    }
    return fb();
};

var p5defined_or = function(a, fb) {
    if (a == null) {
        return fb();
    }
    return a;
};

var p5xor = function(a, fb) {
    return p5bool(a) ? !p5bool(fb()) : fb()
};

var p5cmp = function(a, b) {
    return a > b ? 1 : a < b ? -1 : 0 
};

var p5complement = function(a) {
    return a < 0 ? ~a : 4294967295 - a
    // return a < 0 ? ~a : 18446744073709551615 - a
};

var p5str_replicate = function(o, n) {
    n = Math.floor(n);
    return n > 0 ? Array(n + 1).join(o) : "";
};

var p5list_replicate = function(o, n, want) {
    o = p5list_to_a([o]);
    n = p5num(n);

    if (!want) {
        return p5str_replicate(o.pop(), n);   // scalar context
    }

    var out = [];
    for(var i = 0; i < n; i++) {
        for(var j = 0; j < o.length; j++) {
            out.push(o[j]);
        }
    }
    return (want ? out : out.length)
};

var p5list_slice = function(o, ix, want) {
    var out = [];
    for (var i=0, l=ix.length; i<l; ++i) {
        if (ix[i] < o.length) {
            out[i] = o[ix[i]];
        }
    }
    if (want) { return out }
    return out.length ? out[out.length-1] : null;
}

var p5hash_slice = function(o, ix, want) {
    var out = [];
    for (var i=0, l=ix.length; i<l; ++i) {
        out.push(ix[i]);
        out.push(o[ix[i]]);
    }
    if (want) { return out }
    return out.length ? out[out.length-1] : null;
}

var p5list_lookup_slice = function(o, ix, want) {
    var out = [];
    for (var i=0, l=ix.length; i<l; ++i) {
        out[i] = o[ix[i]];
    }
    if (want) { return out }
    return out.length ? out[out.length-1] : null;
}

var p5hash_lookup_slice = function(o, ix, want) {
    var out = [];
    for (var i=0, l=ix.length; i<l; ++i) {
        out.push(ix[i]);
        out.push(o[ix[i]]);
    }
    if (want) { return out }
    return out.length ? out[out.length-1] : null;
}

var p5str_inc = function(s) {
    if (s.length < 2) {
        if ((s >= "0" && s <= "8") || (s >= "A" && s <= "Y") || (s >= "a" && s <= "y")) {
            return String.fromCharCode(s.charCodeAt(0) + 1);
        }
        if (s == "9") {
            return "10";
        }
        if (s == "Z") {
            return "AA";
        }
        if (s == "z") {
            return "aa";
        }
        return "1";
    }
    var c0 = s.substr(0, 1);
    if (c0 >= "0" && c0 <= "9") {
        return p5str(p5num(s)+1);
    }
    var c = p5str_inc(s.substr(s.length-1, 1));
    if (c.length == 1) {
        return s.substr(0, s.length-1) + c;
    }
    return p5str_inc(s.substr(0, s.length-1)) + c.substr(c.length-1, 1);
};

var p5range_state = {};
var p5range = function(a, b, p5want, id, three_dots) {
    if (p5want) {
        // list context
        var tmp = [];
        if (typeof a === "number" || typeof b === "number") {
            a = p5num(a);
            b = p5num(b);
            while (a <= b) {
                tmp.push(a);
                a++;
            }
        }
        else {
            a = p5str(a);
            b = p5str(b);
            var c = a.substr(0, 1);
            if ( c == '+' ) {
                if (a == "+") {
                    return [a]
                }
                a = a.substr(1)
            }
            else if ( c == '-' ) {
                if (a == "-") {
                    return [a]
                }
                return p5range(p5num(a), b, p5want, id, three_dots)
            }
            c = b.substr(0, 1);
            if ( c == '+' ) {
                b = b.substr(1)
            }
            while (  (a.length < b.length)
                  || (a.length == b.length && a <= b) ) {
                tmp.push(a);
                a = p5incr_(a);
            }
        }
        return tmp;
    }
    // flip-flop operator
    var v;
    if (p5range_state[id]) {
        v = ++p5range_state[id];
        if (p5bool(b)) {
            p5range_state[id] = 0;
            v = v + "E0";
        }
        return v;
    }
    else {
        p5range_state[id] = 0;
        if (p5bool(a)) {
            p5range_state[id]++;
            v = p5range_state[id];
        }
        if (v && !three_dots && p5bool(b)) {
            p5range_state[id] = 0;
            v = v + "E0";
        }
        return v;
    }
};

var p5negative = function(o) {
    if (o == null) {
        return '-0';
    }
    if (typeof o === "object" && (o instanceof Array)) {
        return -(o.length);
    }
    if (typeof o !== "number") {
        var s = p5str(o);
        var c = s.substr(0, 1);
        if ( c == '+' ) { s = s.substr(1); return '-' + s }
        if ( c == '-' ) { s = s.substr(1); return '+' + s }
        var s1 = parseFloat(s.trim());
        if ( isNaN(s1) ) {
            if ( c.length && !c.match(/[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz]/) ) {
                if ( s.trim().substr(0,1) == "-" ) { return 0 };
                return '-0';
            };
            return '-' + s
        };
        return -s1;
    }
    return -o;
};

var p5qr = function(search, modifier) {
    // TODO - "Regex" stringification
    var re = new RegExp(search, modifier);
    return CORE.bless([(new p5ScalarRef(re)), 'Regex']);
};

var p5m = function(s, search, modifier, want) {
    // TODO - captures
    var re;
    if (search.hasOwnProperty('_scalar_')) {
        // search is a Regex object
        re = search._scalar_;
    }
    else {
        re = new RegExp(search, modifier);
    }

    p5_regex_capture = [];
    var res = [];
    var myArray;
    while ((myArray = re.exec(s)) !== null) {
        var m = myArray.shift();
        if (myArray.length) {
            res = res.concat(myArray);
            p5_regex_capture = p5_regex_capture.concat(myArray);
        }
        else {
            res.push(m);
        }
        if (re.lastIndex == 0) {
            return (want ? res : res.length)
        }
    }
    return (want ? res : res.length)
};

var p5s = function(s, search, fun_replace, modifier, want) {
    // TODO - captures
    var count = null;
    var re;
    if (search.hasOwnProperty('_scalar_')) {
        // search is a Regex object
        re = search._scalar_;
    }
    else {
        re = new RegExp(search, modifier);
    }

    p5_regex_capture = [];
    var res = [];
    var myArray;
    var last_index = 0;
    while ((myArray = re.exec(s)) !== null) {
        var m = myArray.shift();
        p5_regex_capture = [].concat(myArray);
        if (myArray.index > last_index) {
            res.push(s.substr(last_index, myArray.index - last_index));
        }
        res.push(fun_replace());
        last_index = re.lastIndex;
        if (last_index == 0) {
            count = 1;
            last_index = myArray.index + m.length;
            if (s.length > last_index) {
                res.push(s.substr(last_index, s.length - last_index));
            }
            return [res.join(''), count]
        }
        count++;
    }
    if (s.length > last_index) {
        res.push(s.substr(last_index, s.length - last_index));
    }
    return [res.join(''), count]
};

var p5tr = function(s, search, replace, modifier, want) {
    var count = 0;
    // TODO - expand character lists in spec
    // TODO - modifiers
    search = search.split("");
    replace = replace.split("");
    while (search.length > replace.length) {
        replace.push(replace[replace.length-1]);
    }
    var tr = {};
    for(var i = 0; i < search.length; i++) {
        tr[search[i]] = replace[i];
    }
    var res = s.split("");
    for(var i = 0; i < res.length; i++) {
        if (tr.hasOwnProperty(res[i])) {
            res[i] = tr[res[i]];
            count++;
        }
    }
    return [res.join(''), count]
};

var p5chop = function(s) {
    // TODO - array, hash
    return [s.substr(-1,1), s.substr(0,s.length-1)]
};

var p5chomp = function(s) {
    // TODO - array, hash
    // TODO - special cases of $/ - empty string, reference
    var sep = p5pkg["main"]["v_/"];  // $/
    var c = s.substr(-sep.length);
    if (c == sep) {
        return [c.length, s.substr(0,s.length-sep.length)]
    }
    else {
        return [0, s]
    }
};

var p5for = function(namespace, var_name, func, args, cont, label) {
    var local_idx = p5LOCAL.length;
    var v_old = namespace[var_name];
    var _redo;
    p5LOCAL.push(function(){ namespace[var_name] = v_old });
    for(var i = 0; i < args.length; i++) {
        namespace[var_name] = args[i];
        do {
            _redo = false;
            try {
                func()
            }
            catch(err) {
                if (err instanceof p5_error && (err.v == label || err.v == '')) {
                    if (err.type == 'last') {
                        p5cleanup_local(local_idx, null);
                        return
                    }
                    else if (err.type == 'redo') { _redo = true }
                    else if (err.type != 'next') { throw(err) }
                }
                else {
                    throw(err)
                }
            }
            if (cont) {
                try {
                    if (!_redo) { cont() }
                }
                catch(err) {
                    if (err instanceof p5_error && (err.v == label || err.v == '')) {
                        if (err.type == 'last') {
                            p5cleanup_local(local_idx, null);
                            return
                        }
                        else if (err.type == 'redo') { _redo = true }
                        else if (err.type != 'next') { throw(err) }
                    }            
                    else {
                        throw(err)
                    }
                }
            }
        } while (_redo);
    }
    p5cleanup_local(local_idx, null);
};

var p5for_lex = function(set_var, func, args, cont, label) {
    var local_idx = p5LOCAL.length;
    var _redo;
    for(var i = 0; i < args.length; i++) {
        set_var(args[i]);
        do {
            _redo = false;
            try {
                func()
            }
            catch(err) {
                if (err instanceof p5_error && (err.v == label || err.v == '')) {
                    if (err.type == 'last') {
                        p5cleanup_local(local_idx, null);
                        return
                    }
                    else if (err.type == 'redo') { _redo = true }
                    else if (err.type != 'next') { throw(err) }
                }            
                else {
                    throw(err)
                }
            }
            if (cont) {
                try {
                    if (!_redo) { cont() }
                }
                catch(err) {
                    if (err instanceof p5_error && (err.v == label || err.v == '')) {
                        if (err.type == 'last') {
                            p5cleanup_local(local_idx, null);
                            return
                        }
                        else if (err.type == 'redo') { _redo = true }
                        else if (err.type != 'next') { throw(err) }
                    }            
                    else {
                        throw(err)
                    }
                }
            }
        } while (_redo);
    }
    p5cleanup_local(local_idx, null);
};

var p5block = function(set_var, func, args, cont, label) {
    var local_idx = p5LOCAL.length;
    var _redo;
    for(var i = 0; i < args.length; i++) {
        set_var(args[i]);
        do {
            _redo = false;
            try {
                return func()
            }
            catch(err) {
                if (err instanceof p5_error && (err.v == label || err.v == '')) {
                    if (err.type == 'last') {
                        p5cleanup_local(local_idx, null);
                        return
                    }
                    else if (err.type == 'redo') { _redo = true }
                    else if (err.type != 'next') { throw(err) }
                }            
                else {
                    throw(err)
                }
            }
            if (cont) {
                try {
                    if (!_redo) { cont() }
                }
                catch(err) {
                    if (err instanceof p5_error && (err.v == label || err.v == '')) {
                        if (err.type == 'last') {
                            p5cleanup_local(local_idx, null);
                            return
                        }
                        else if (err.type == 'redo') { _redo = true }
                        else if (err.type != 'next') { throw(err) }
                    }            
                    else {
                        throw(err)
                    }
                }
            }
        } while (_redo);
    }
    p5cleanup_local(local_idx, null);
};


var p5while = function(func, cond, cont, label, redo) {
    var local_idx = p5LOCAL.length;
    while (redo || p5bool(cond())) {
        redo = false;
        try {
            func()
        }
        catch(err) {
            if (err instanceof p5_error && (err.v == label || err.v == '')) {
                if (err.type == 'last') {
                    p5cleanup_local(local_idx, null);
                    return
                }
                else if (err.type == 'redo') { redo = true }
                else if (err.type != 'next') { throw(err) }
            }            
            else {
                throw(err)
            }
        }
        if (cont) {
            try {
                if (!redo) { cont() }
            }
            catch(err) {
                if (err instanceof p5_error && (err.v == label || err.v == '')) {
                    if (err.type == 'last') {
                        p5cleanup_local(local_idx, null);
                        return
                    }
                    else if (err.type == 'redo') { redo = true }
                    else if (err.type != 'next') { throw(err) }
                }            
                else {
                    throw(err)
                }
            }
        }
    }
    p5cleanup_local(local_idx, null);
};

var p5map = function(namespace, func, args) {
    var v_old = p5pkg["main"]["v__"];
    var out = [];
    for(var i = 0; i < args.length; i++) {
        p5pkg["main"]["v__"] = args[i];
        var o = p5list_to_a([func(1)]);
        for(var j = 0; j < o.length; j++) {
            out.push(o[j]);
        }
    }
    p5pkg["main"]["v__"] = v_old;
    return out;
};

var p5grep = function(namespace, func, args) {
    var v_old = p5pkg["main"]["v__"];
    var out = [];
    for(var i = 0; i < args.length; i++) {
        p5pkg["main"]["v__"] = args[i];
        if (p5bool(func(0))) {
            out.push(args[i])
        }
    }
    p5pkg["main"]["v__"] = v_old;
    return out;
};

var p5sort = function(namespace, func, args) {
    var a_old = namespace["v_a"];
    var b_old = namespace["v_b"];
    var out = 
        func == null
        ? args.sort()
        : args.sort(
            function(a, b) {
                namespace["v_a"] = a;
                namespace["v_b"] = b;
                return func(0);
            }
        );
    namespace["v_a"] = a_old;
    namespace["v_b"] = b_old;
    return out;
};

//
// lib/Perlito5/Javascript2/Runtime.js
//
// Runtime for "Perlito" Perl5-in-Javascript2
//
// AUTHORS
//
// Flavio Soibelmann Glock  fglock@gmail.com
//
// COPYRIGHT
//
// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.
//
// This program is free software; you can redistribute it and/or modify it
// under the same terms as Perl itself.
//
// See http://www.perl.com/perl/misc/Artistic.html

//-------- Array 

Object.defineProperty( Array.prototype, "p5aget", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        return this[i] 
    }
});
Object.defineProperty( Array.prototype, "p5aset", {
    enumerable : false,
    value : function (i, v) {
        if (i < 0) { i =  this.length + i };
        this[i] = v;
        return this[i]
    }
});

Object.defineProperty( Array.prototype, "p5incr", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        this[i] = p5incr_(this[i]);
        return this[i];
    }
});
Object.defineProperty( Array.prototype, "p5postincr", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        var v = this[i];
        this[i] = p5incr_(this[i]);
        return v;
    }
});
Object.defineProperty( Array.prototype, "p5decr", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        this[i] = p5decr_(this[i]);
        return this[i];
    }
});
Object.defineProperty( Array.prototype, "p5postdecr", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        var v = this[i];
        this[i] = p5decr_(this[i]);
        return v;
    }
});

Object.defineProperty( Array.prototype, "p5aget_array", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        if (this[i] == null) { this[i] = new p5ArrayRef([]) }
        return this[i]
    }
});
Object.defineProperty( Array.prototype, "p5aget_hash", {
    enumerable : false,
    value : function (i) {
        if (i < 0) { i =  this.length + i };
        if (this[i] == null) { this[i] = new p5HashRef({}) }
        return this[i]
    }
});
Object.defineProperty( Array.prototype, "p5unshift", {
    enumerable : false,
    configurable : true,
    value : function (args) { 
        for(var i = args.length-1; i >= 0; i--) {
            this.unshift(args[i]);
        }
        return this.length; 
    }
});
Object.defineProperty( Array.prototype, "p5push", {
    enumerable : false,
    configurable : true,
    value : function (args) { 
        for(var i = 0; i < args.length; i++) {
            this.push(args[i]);
        }
        return this.length; 
    }
});

var p5tie_array = function(v, List__) {
    var pkg_name = p5str(List__.shift());

    var res = p5call(pkg_name, 'TIEARRAY', List__, null);
    
    // TODO
    
    //  A class implementing an ordinary array should have the following methods:
    //      TIEARRAY pkg_name, LIST
    //      FETCH this, key
    //      STORE this, key, value
    //      FETCHSIZE this
    //      STORESIZE this, count
    //      CLEAR this
    //      PUSH this, LIST
    //      POP this
    //      SHIFT this
    //      UNSHIFT this, LIST
    //      SPLICE this, offset, length, LIST
    //      EXTEND this, count
    //      DESTROY this
    //      UNTIE this
    
    Object.defineProperty( v, "p5aget", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            return p5call(res, 'FETCH', [i]);
        }
    });
    Object.defineProperty( v, "p5aset", {
        enumerable : false,
        configurable : true,
        value : function (i, value) {
            p5call(res, 'STORE', [i, value]);
            return value;
        }
    });
    Object.defineProperty( v, "p5incr", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            var value = p5incr_(p5call(res, 'FETCH', [i]));
            p5call(res, 'STORE', [i, value]);
            return value;
        }
    });
    Object.defineProperty( v, "p5postincr", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            var value = p5call(res, 'FETCH', [i]);
            p5call(res, 'STORE', [i, p5incr_(value)]);
            return value;
        }
    });
    Object.defineProperty( v, "p5decr", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            var value = p5decr_(p5call(res, 'FETCH', [i]));
            p5call(res, 'STORE', [i, value]);
            return value;
        }
    });
    Object.defineProperty( v, "p5postdecr", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            var value = p5call(res, 'FETCH', [i]);
            p5call(res, 'STORE', [i, p5decr_(value)]);
            return value;
        }
    });
    
    Object.defineProperty( v, "p5aget_array", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            var value = p5call(res, 'FETCH', [i]);
            if (value == null) {
                value = new p5ArrayRef([]);
                p5call(res, 'STORE', [i, value]);
            }
            return value;
        }
    });
    Object.defineProperty( v, "p5aget_hash", {
        enumerable : false,
        configurable : true,
        value : function (i) {
            var value = p5call(res, 'FETCH', [i]);
            if (value == null) {
                value = new p5HashRef({});
                p5call(res, 'STORE', [i, value]);
            }
            return value;
        }
    });
    Object.defineProperty( v, "p5untie", {
        enumerable : false,
        configurable : true,
        value : function (i) { return p5call(res, 'UNTIE', []) }
    });
    Object.defineProperty( v, "shift", {
        enumerable : false,
        configurable : true,
        value : function () { return p5call(res, 'SHIFT', []) }
    });
    Object.defineProperty( v, "pop", {
        enumerable : false,
        configurable : true,
        value : function () { return p5call(res, 'POP', []) }
    });
    Object.defineProperty( v, "p5unshift", {
        enumerable : false,
        configurable : true,
        value : function (args) { 
            for(var i = args.length-1; i >= 0; i--) {
                p5call(res, 'UNSHIFT', [args[i]]);
            }
            return p5call(res, 'FETCHSIZE', []); 
        }
    });
    Object.defineProperty( v, "p5push", {
        enumerable : false,
        configurable : true,
        value : function (args) { 
            for(var i = 0; i < args.length; i++) {
                p5call(res, 'PUSH', [args[i]]);
            }
            return p5call(res, 'FETCHSIZE', []); 
        }
    });

    return res;
};

var p5untie_array = function(v) {
    if (v.hasOwnProperty('p5untie')) {
        var res = v.p5untie();  // call UNTIE
        delete v.p5aget;
        delete v.p5aset;
        delete v.p5incr;
        delete v.p5postincr;
        delete v.p5decr;
        delete v.p5postdecr;
        delete v.p5aget_array;
        delete v.p5aget_hash;
        delete v.p5untie;
        delete v.shift;
        delete v.pop;
        delete v.p5unshift;
        delete v.p5push;
        return res;
    }
    else {
        return null;
    }
};


function p5ArrayOfAlias(o) {

    // this is the structure that represents @_
    // _array = [ ref, index,
    //            ref, index,
    //            ...
    //          ]

    // TODO - autovivify array cells

    this._array_ = o;

    this.p5aget = function (i) {
        if (i < 0) { i =  this.length + i };
        return this._array_[i+i][this._array_[i+i+1]]; 
    }
    this.p5aset = function (i, v) {
        if (i < 0) { i =  this.length + i };
        this._array_[i+i][this._array_[i+i+1]] = v;
        return this._array_[i+i][this._array_[i+i+1]]
    }
    this.p5incr = function (i) {
        if (i < 0) { i =  this.length + i };
        this._array_[i+i][this._array_[i+i+1]] = p5incr_(this._array_[i+i][this._array_[i+i+1]]);
        return this._array_[i+i][this._array_[i+i+1]];
    }
    this.p5postincr = function (i) {
        if (i < 0) { i =  this.length + i };
        var v = this._array_[i+i][this._array_[i+i+1]];
        this._array_[i+i][this._array_[i+i+1]] = p5incr_(this._array_[i+i][this._array_[i+i+1]]);
        return v;
    }
    this.p5decr = function (i) {
        if (i < 0) { i =  this.length + i };
        this._array_[i+i][this._array_[i+i+1]] = p5decr_(this._array_[i+i][this._array_[i+i+1]]);
        return this._array_[i+i][this._array_[i+i+1]];
    }
    this.p5postdecr = function (i) {
        if (i < 0) { i =  this.length + i };
        var v = this._array_[i+i][this._array_[i+i+1]];
        this._array_[i+i][this._array_[i+i+1]] = p5decr_(this._array_[i+i][this._array_[i+i+1]]);
        return v;
    }
    this.p5aget_array = function (i) {
        if (i < 0) { i =  this.length + i };
        if (this._array_[i+i][this._array_[i+i+1]] == null) {
            this._array_[i+i][this._array_[i+i+1]] = new p5ArrayRef([])
        }
        return this._array_[i+i][this._array_[i+i+1]]
    }
    this.p5aget_hash = function (i) {
        if (i < 0) { i =  this.length + i };
        if (this._array_[i+i][this._array_[i+i+1]] == null) {
            this._array_[i+i][this._array_[i+i+1]] = new p5HashRef({})
        }
        return this._array_[i+i][this._array_[i+i+1]]
    }
    this.p5unshift = function (args) { 
        for(var i = args.length-1; i >= 0; i--) {
            this.unshift(0);
            this.unshift([args[i]]);
        }
        return this._array_.length / 2; 
    }
    this.p5push = function (args) { 
        for(var i = 0; i < args.length; i++) {
            this.push([args[i]]);
            this.push(0);
        }
        return this._array_.length / 2; 
    }
    this.shift = function () { 
        var v0 = this._array_.shift();
        return v0[this._array_.shift()];
    }
    this.pop = function () { 
        var v1 = this._array_.pop();
        var v0 = this._array_.pop();
        return v0[v1];
    }
}


//
//
// lib/Perlito5/Javascript2/CORE.js
//
// CORE functions for "Perlito" Perl5-in-Javascript2
//
// AUTHORS
//
// Flavio Soibelmann Glock  fglock@gmail.com
//
// COPYRIGHT
//
// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.
//
// This program is free software; you can redistribute it and/or modify it
// under the same terms as Perl itself.
//
// See http://www.perl.com/perl/misc/Artistic.html

var CORE = p5pkg.CORE;

var isNode = typeof require != "undefined";


if (isNode) {
    try {
        var sleep = require("sleep");
        CORE.sleep = function(List__) {
            var n = p5num(List__[0]) || 1;
            sleep.usleep(n * 1000000);  // sleep for n seconds (1 second is 1000000 microseconds)
            return n;
        }
    }
    catch (err) {
        CORE.sleep = function(List__) {
            CORE.die("sleep() function failed. Maybe you need 'npm install sleep'?\n" + err);
        }
    }
}
if (!CORE.sleep) {
    CORE.sleep = function(List__) {
        CORE.die("sleep() not supported for this platform");
    }
}

CORE.time = function(List__) {
    return CORE.int([Date.now() / 1000]);
}
var _fmt_date = function(date) {
    return ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'][date.getDay()] + ' ' +
        ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'][date.getMonth()] + ' ' +
        date.getDate() + ' ' + 
        CORE.sprintf([ "%02d:%02d:%02d ", date.getHours(), date.getMinutes(), date.getSeconds() ]) +
        date.getFullYear();
}
var _list_date = function(date) {
    var year_start = new Date(date);
    year_start.setMonth(0, 1);
    var year_day = Math.round((date-year_start)/8.64e7);

    var isdst = 0;  // not implemented

    return [date.getSeconds(),date.getMinutes(),date.getHours(),date.getDate(),
        date.getMonth(),date.getFullYear()-1900,date.getDay(),
        year_day,
        isdst
    ];
}
CORE.localtime = function(List__, want) {
    var n = List__.length ? p5num(List__[0]) : CORE.time() ;
    var date = new Date(n*1000);
    if (!want) {
        return _fmt_date(date);
    }
    return _list_date(date);
}
CORE.gmtime = function(List__, want) {
    var n = List__.length ? p5num(List__[0]) : CORE.time() ;
    var ofs = new Date().getTimezoneOffset() * 60;
    var date = new Date((n + ofs)*1000);
    if (!want) {
        return _fmt_date(date);
    }
    return _list_date(date);
}

CORE.bless = function(List__) {
    var o        = List__[0];
    var pkg_name = List__[1];
    if (typeof pkg_name === "object") {
        // bless {}, Class
        o._class_ = pkg_name;
        return o;
    }
    if (!p5pkg.hasOwnProperty(pkg_name)) {
        p5make_package(pkg_name);
    }
    o._class_ = p5pkg[pkg_name];
    return o;
};

CORE.caller = function(List__, want) {
    if (p5pkg["Perlito5"].v_CALLER && p5pkg["Perlito5"].v_CALLER._array_ && p5pkg["Perlito5"].v_CALLER._array_.p5aget(0) ) {
        // TODO
        return p5pkg["Perlito5"].v_CALLER._array_.p5aget(0)._array_
    }
    return p5context([], want);
};

CORE.chr = function(List__) {
    var v = p5num(List__[0]);
    return String.fromCharCode(v >= 0 ? v : 65533);
};

CORE.ord = function(List__) {
    return p5str(List__[0]).charCodeAt(0);
};

CORE.hex = function(List__) {
    var v = List__[0];

    for(var i = 0; i < v.length; i++) {
        if (v.charCodeAt(i) > 255) {
            CORE.die(["Wide character in hex"]);
        }
    }

    var b1 = v.substr(0,1);
    var b2 = v.substr(0,2);
    if (b1 == "x" || b1 == "X" || b2 == "0x" || b2 == "0X") {
        return CORE.oct(List__);
    }
    v = "0x" + v;
    return CORE.oct([v]);
};

CORE.oct = function(List__) {
    var v = List__[0];
    v = v.trim();

    for(var i = 0; i < v.length; i++) {
        if (v.charCodeAt(i) > 255) {
            CORE.die(["Wide character in oct"]);
        }
    }

    var b = v.substr(0,1);
    if (b == "b" || b == "B" || b == "x" || b == "X") {
        v = "0" + v;
    }
    b = v.substr(0,2);

    for(var i = 2; i < v.length; i++) {
        if (v.substr(i,2) == "__") {
            v = v.substr(0, i);
        }
    }

    var re = new RegExp('_', 'g');
    v = v.replace(re, "");

    if (b == "0b" || b == "0B") {
        for(var i = 2; i < v.length; i++) {
            var c = v.substr(i,1);
            if (c >= "0" && c <= "1") {}
            else {
                v = v.substr(0, i);
            }
        }
        if (v.length == 2) { return 0 }
        return parseInt(v.substr(2), 2);
    }

    if (b == "0x" || b == "0X") {
        for(var i = 2; i < v.length; i++) {
            var c = v.substr(i,1);
            if (c >= "0" && c <= "9" || c >= "A" && c <= "F" || c >= "a" && c <= "f") {}
            else {
                v = v.substr(0, i);
            }
        }
        if (v.length == 2) { return 0 }
        return parseInt(v.substr(2), 16);
    }

    return parseInt(v, 8);
};

CORE.abs   = function(List__) { return Math.abs(List__[0]) };
CORE.exp   = function(List__) { return Math.exp(List__[0]) };
CORE.log   = function(List__) { return Math.log(List__[0]) };
CORE.cos   = function(List__) { return Math.cos(List__[0]) };
CORE.sin   = function(List__) { return Math.sin(List__[0]) };
CORE.sqrt  = function(List__) { return Math.sqrt(List__[0]) };
CORE.atan2 = function(List__) { return Math.atan2(List__[0], List__[1]) };
CORE.int   = function(List__) { return List__[0] > 0 ? Math.floor(List__[0]) : Math.ceil(List__[0]) };

var p5rand = function(v) { return Math.random() * v };
CORE.srand = function(List__) {
    if (List__.length > 0) {
        var v = p5num(List__[0]) || 1;
        p5rand = function() {
            v = Math.sin(v) * 10000;
            return v - Math.floor(v);
        };
        return List__[0];
    }
    return CORE.int(CORE.rand(100000));
};
CORE.rand = function(List__) {
    var v = p5num(List__[0]) || 1;
    return p5rand(v);
};

CORE.lc      = function(List__) { return p5str(List__[0]).toLowerCase() };
CORE.uc      = function(List__) { return p5str(List__[0]).toUpperCase() };

CORE.lcfirst = function(List__) {
    var s = p5str(List__[0]);
    var c = s.length > 0 ? s.slice(0,1).toLowerCase() : "";
    s = s.length > 1 ? s.substr(1) : "";
    return c + s
};

CORE.ucfirst = function(List__) {
    var s = p5str(List__[0]);
    var c = s.length > 0 ? s.slice(0,1).toUpperCase() : "";
    s = s.length > 1 ? s.substr(1) : "";
    return c + s
};

CORE.quotemeta = function(List__) {
    var s = p5str(List__[0]);
    var out = [];
    for(var i = 0; i < s.length; i++) {
        if (s.substr(i, 1).match(/[^0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz]/)) {
            out.push(String.fromCharCode(92));
        }
        out.push(s.substr(i, 1));
    }
    return out.join("");       
};

CORE.substr = function(List__) {
    var expr        = List__[0];
    var offset      = List__[1];
    var length      = List__[2];
    var replacement = List__[3];
    if (length < 0) {
        var s = p5str(expr);
        length = s.length - offset + length;
    } 
    return p5str(expr).substr(offset, length);
};

CORE.values = function(List__, p5want) {
    var o = List__[0];
    delete o["_each_"];
    if (p5want) {
        if (o == null) {
            return [];
        };
        if (typeof o.values === "function") {
            return o.values();
        }
        var out = [];
        for (var i in o) {
            out.push(o[i]);
        }
        return out;
    }
    return CORE.keys(List__, p5want);
};

CORE.keys = function(List__, p5want) {
    var o = List__[0];
    delete o["_each_"];
    if (p5want) {
        if (o == null) {
            return [];
        }
        if (typeof o.keys === "function") {
            return o.keys();
        }
        var out = [];
        for (var i in o) {
            out.push(i);
        }
        return out;
    }
    else {
        if (o == null) {
            return 0;
        }
        if (typeof o.keys === "function") {
            return p5num(o.keys());
        }
        var out = 0;
        for (var i in o) {
            out++;
        }
        return out;
    }
};

CORE.each = function(List__, p5want) {
    var o = List__[0];
    if (o.hasOwnProperty("_each_")) {
        return o._each_(p5want)
    }
    var keys = CORE.keys([o], 1);
    var i = 0;
    o._each_ = function () {
        if (i < keys.length) {
            i++;
            return p5want ? [keys[i-1], o[keys[i-1]]] : keys[i-1];
        }
        i = 0;
        return p5want ? [] : null;
    };
    return o._each_(p5want);
};

CORE.reverse = function(List__) {
    var o = List__;
    if (o == null) {
        return "";
    }
    if (typeof o === "string") {
        return o.split("").reverse().join("")
    }
    var out = [];
    for(var i = 0; i < o.length; i++) {
        out.unshift(o[i]);
    }
    return out;
};

CORE.splice = function(List__, p5want) {
    var array  = List__.shift();
    // CORE.say([ array ]);
    var offset = p5num(List__.shift());
    var limit  = List__.length ? p5num(List__.shift()) : (array.length + 1);

    if (limit < 0) {
        limit = array.length + limit - 1;
    }

    var list = [offset, limit];
    for(var i = 0; i < List__.length; i++) {
        list = p5list_to_a([ list, List__[i] ]);
    }

    var out = array.splice.apply(array, list);
    // CORE.say([ CORE.join([":",array]), " ofs=", offset, " lim=", limit, " list=", list, " out=", CORE.join([":",out])  ]);
    return p5want ? out : out.pop();
};

CORE.join = function(List__) {
    var s = List__.shift();
    var o = [];
    for (var i = 0; i < List__.length; i++) {
        o.push(p5str(List__[i]));
    }
    return o.join(s);
};

CORE.index = function(List__) {
    var o = List__[0];
    var s = List__[1];
    try {
        return o.indexOf(s, p5num(List__[2]));
    }
    catch(err) {
        return -1;
    }
};
CORE.rindex = function(List__) {
    var o = List__[0];
    var s = List__[1];
    try {
        if (List__.length > 2) {
            var i = p5num(List__[2]);
            if (i < 0) {
                if (s.length == 0) {
                    return 0;
                }
                return -1;
            }
            return o.lastIndexOf(s, i);
        }
        return o.lastIndexOf(s);
    }
    catch(err) {
        return -1;
    }
};

CORE.length = function(List__) {
    return p5str(List__[0]).length;
};

CORE.pack    = function(List__) { CORE.warn([ "CORE::pack not implemented" ]) };
CORE.unpack  = function(List__) { CORE.warn([ "CORE::unpack not implemented" ]) };

CORE.ref = function(List__) {
    var o = List__[0];
    if (o == null) {
        return "";
    }
    if (o._class_ && typeof o._class_._ref_ === "string") {
        // blessed reference
        return o._class_._ref_;
    }
    if (typeof o._ref_ === "string") {
        // un-blessed reference
        return o._ref_;
    }
    if (typeof o === "function") {
        return "CODE";
    }
    return "";
};

CORE.split = function(List__, want) {
    var pattern = List__[0];
    var s       = p5str(List__[1]);
    var limit   = p5num(List__[2]);
    if (!want) {
        // scalar context
        return p5num(CORE.split(List__, 1));
    }
    if (limit == 0) {
        // strip trailing empty strings and undef
        var res = CORE.split([pattern, s, -1], 1);
        while (res.length && (res[res.length - 1] == '' || typeof res[res.length - 1] == "undefined") ) {
            res.pop()
        }
        return res;
    }
    if (s == '') {
        return []
    }
    // make sure pattern is a RegExp
    if (typeof pattern === "object" && (pattern instanceof RegExp)) {
        pattern = pattern.source;
    }
    else {
        pattern = p5str(pattern);
        if (pattern == " ") {
            // single space string is special
            pattern = "(?: |\t|\n)+";
            s = s.replace(/^(?: |\t|\n)+/, "");
        }
    }
    // add "g", "m" modifiers
    var flags = "g";
    if (pattern.substr(0, 1) == "^" || pattern.substr(-1,1) == "$") {
        flags = flags + "m";
    }
    pattern = new RegExp(pattern, flags);
    var res = [];
    var pos = 0;
    var count = 0;
    while (1) {
        if (limit > 0 && limit <= (count + 1)) {
            res.push(s.substr(pos));
            return res;
        }
        var m = pattern.exec(s);
        if (m === null) {
            // no match
            res.push(s.substr(pos));
            return res;
        }
        if (m[0].length == 0 && m.index == pos) {
            // pointer didn't move
            pattern.lastIndex = pattern.lastIndex + 1;
        }
        else {
            var part = s.substr(pos, m.index - pos);
            res.push(part);
            count++;
            pos = m.index + m[0].length;
            pattern.lastIndex = pos;
        }
        for (var i = 1; i < m.length ; i++) {
            res.push(m[i]);     // captured substrings; don't increment count
        }
    }
};


//
//
// lib/Perlito5/Javascript2/IO.js
//
// I/O functions for "Perlito" Perl5-in-Javascript2
//
// AUTHORS
//
// Flavio Soibelmann Glock  fglock@gmail.com
//
// COPYRIGHT
//
// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.
//
// This program is free software; you can redistribute it and/or modify it
// under the same terms as Perl itself.
//
// See http://www.perl.com/perl/misc/Artistic.html

var isNode = typeof require != "undefined";
if (isNode) {

    var fs = require("fs");

    p5typeglob_set("Perlito5::IO", "print", function (filehandle, List__, p5want) {
        try {
            var v = filehandle;
            var pkg;
            if (CORE.ref([v])) {
                // looks like a filehandle
                pkg = v;
            }
            else {
                // looks like a package name
                pkg = p5make_package(v);
            }
            if (!pkg.file_handle) {
                pkg.file_handle = {};
            }
            var handle_id = pkg.file_handle.id;
            if (handle_id == 1) {
                for (var i = 0; i < List__.length; i++) {
                    process.stdout.write(p5str(List__[i]));
                }
            }
            else if (handle_id == 2) {
                for (var i = 0; i < List__.length; i++) {
                    process.stderr.write(p5str(List__[i]));
                }
            }
            else {
                for (var i = 0; i < List__.length; i++) {
                    fs.writeSync(handle_id, p5str(List__[i]));
                }
            }
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    } );

    var p5_extra_buffer_size = 100;
    p5typeglob_set("Perlito5::IO", "read", function (filehandle, List__, p5want) {
        try {
            var v = filehandle;
            var length = List__.shift();
            var pkg;
            if (CORE.ref([v])) {
                // looks like a filehandle
                pkg = v;
            }
            else {
                // looks like a package name
                pkg = p5make_package(v);
            }
            if (!pkg.file_handle) {
                pkg.file_handle = {};
            }
            var handle_id = pkg.file_handle.id;

            if (!pkg.file_handle.buffer) {
                // we don't have any data yet
                var length_wanted = length + 2 * p5_extra_buffer_size;
                var buffer = new Buffer(length_wanted);
                var bytes_read = fs.readSync(handle_id, buffer, 0, length_wanted, null);
                if (bytes_read < length_wanted) {
                    pkg.file_handle.buffer_eof = 1;
                }
                pkg.file_handle.buffer = buffer;
                pkg.file_handle.buffer_start = 0;
                pkg.file_handle.buffer_end = bytes_read;
                pkg.file_handle.buffer_length = pkg.file_handle.buffer_end;
            }
            else if (pkg.file_handle.buffer_length > (length + p5_extra_buffer_size)) {
                // we have enough data
            }
            else if (!pkg.file_handle.buffer_eof) {
                // we have some data; append more data to the internal buffer
                var length_wanted = length + 2 * p5_extra_buffer_size;
                var buffer = new Buffer(pkg.file_handle.buffer_length + length_wanted);
                pkg.file_handle.buffer.copy(buffer, 0, pkg.file_handle.buffer_start, pkg.file_handle.buffer_end);
                var bytes_read = fs.readSync(handle_id, buffer, pkg.file_handle.buffer_length, length_wanted, null);
                if (bytes_read < length_wanted) {
                    pkg.file_handle.buffer_eof = 1;
                }
                pkg.file_handle.buffer = buffer;
                pkg.file_handle.buffer_start = 0;
                pkg.file_handle.buffer_end = pkg.file_handle.buffer_length + bytes_read;
                pkg.file_handle.buffer_length = pkg.file_handle.buffer_end;
            }

            var s = pkg.file_handle.buffer.toString('utf-8', pkg.file_handle.buffer_start, pkg.file_handle.buffer_end).substr(0, length);

            // how many bytes we actually used
            var buffer_used = Buffer.byteLength(s, 'utf-8');

            pkg.file_handle.buffer_start = pkg.file_handle.buffer_start + buffer_used;
            pkg.file_handle.buffer_length = pkg.file_handle.buffer_length - buffer_used;

            if ( handle_id == 0) {
                // STDIN
                pkg.file_handle.buffer_eof = (s.length ? 0 : 1);
                pkg.file_handle.eof = (s.length ? 0 : 1);
            }
            else if ( pkg.file_handle.buffer_eof && pkg.file_handle.buffer_length <= 0 ) {
                pkg.file_handle.eof = 1;
            }

            return [s.length, s];
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return [];
        }
    } );

    var p5ARGV = 0;
    p5typeglob_set("Perlito5::IO", "readline", function (List__, p5want) {
        var filehandle = List__.shift();

        if (p5want) {
            var out = [];
            while (1) {
                var s = p5pkg["Perlito5::IO"].readline([filehandle], 0);
                if (s == null) {
                    return out;
                }
                out.push(s);
            }
        }

        var v = filehandle;
        var pkg;
        if (CORE.ref([v])) {
            // looks like a filehandle
            pkg = v;
        }
        else {
            // looks like a package name
            pkg = p5make_package(v);
            if (v == "ARGV") {
                // ARGV is magical
                if (pkg.file_handle.id == null) {
                    if (!p5ARGV) {
                        if (p5pkg["main"]["List_ARGV"].length == 0) {
                            p5pkg["main"]["List_ARGV"].push('-');
                        }
                    }
                    p5ARGV = 1;
                    // TODO - open $ARGV[1], ...
                    var filename = p5pkg["main"]["List_ARGV"].shift();
                    CORE.open([ "ARGV", "<", filename ]) || CORE.die([ p5pkg["main"]["v_!"] ]);
                }
            }
        }
        if (!pkg.file_handle) {
            pkg.file_handle = {};
        }

        if (CORE.eof([v])) {
            return null;
        }

        var separator = p5pkg["main"]["v_/"];  // input record separator
        var buf = pkg.file_handle.readline_buffer;
        var pos;

        if (separator) {
            pos = buf.indexOf(separator);
            while ( pos < 0 && !pkg.file_handle.eof ) {
                var r = p5pkg["Perlito5::IO"].read(filehandle, [100]);
                buf = buf + r[1];
                pos = buf.indexOf(separator);
            }
        }
        else {
            // no separator
            pos = -1;
            while ( !pkg.file_handle.eof ) {
                var r = p5pkg["Perlito5::IO"].read(filehandle, [100]);
                buf = buf + r[1];
            }
        }

        if (pos < 0) {
            pkg.file_handle.readline_buffer = '';
            if (!buf.length) {
                pkg.file_handle.readline_buffer = '';
                pkg.file_handle.eof = 1;
                return null
            }
            return buf;
        }
        var s = buf.substr(0, pos + separator.length);
        pkg.file_handle.readline_buffer = buf.substr(pos + separator.length);
        if (!s.length) {
            pkg.file_handle.readline_buffer = '';
            pkg.file_handle.eof = 1;
            return null
        }
        return s;
    } );

    p5typeglob_set("Perlito5::IO", "close", function (filehandle, List__, p5want) {
        try {
            var v = filehandle;
            var pkg;
            if (CORE.ref([v])) {
                // looks like a filehandle
                pkg = v;
            }
            else {
                // looks like a package name
                pkg = p5make_package(v);
            }
            if (!pkg.file_handle) {
                pkg.file_handle = {};
            }
            var handle_id = pkg.file_handle.id;
            if (handle_id == 1) {
                process.stdout.close();
            }
            else if (handle_id == 2) {
                process.stderr.close();
            }
            else {
                fs.closeSync(handle_id);
            }
            pkg.file_handle.id = null;
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    } );

    CORE.eof = function(List__) {
        try {
            var filehandle = List__.shift();
            var v = filehandle;
            var pkg;
            if (CORE.ref([v])) {
                // looks like a filehandle
                pkg = v;
            }
            else {
                // looks like a package name
                pkg = p5make_package(v);
            }
            if (!pkg.file_handle) {
                pkg.file_handle = {};
            }
            var handle_id = pkg.file_handle.id;
            if (handle_id == null) {
                return 1;  // file is not open
            }
            return pkg.file_handle.eof && pkg.file_handle.readline_buffer.length == 0;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    };

    CORE.open = function(List__) {
        try {
            var filehandle = List__.shift();
            var flags = List__.shift();
            var path;
            if (List__.length) {
                path = List__.shift();
            }
            else {
                // 2-argument open
                var re = new RegExp("^([<>+|]*)(.*)$", "");
                var capture = re.exec(flags);
                flags = capture[1];
                path = capture[2];
            }
            var v = filehandle;
            var pkg;
            if (CORE.ref([v])) {
                // looks like a filehandle
                pkg = v;
            }
            else {
                // looks like a package name
                pkg = p5make_package(v);
                if (path == "-") {
                    if (flags == '>' || flags == '>>' || flags == '+>' || flags == '+>>') {
                        pkg.file_handle = p5pkg["STDOUT"].file_handle;
                    }
                    else {
                        pkg.file_handle = p5pkg["STDIN"].file_handle;
                    }
                }
            }
            if (!pkg.file_handle) {
                pkg.file_handle = {};
            }
            var handle_id = pkg.file_handle.id;
            if (handle_id != null) {
                if (handle_id < 2) {
                    return 1;   // STDIN, STDOUT, STDERR
                }
                p5pkg["Perlito5::IO"].close(filehandle, []);
            }
            if (flags == '>') {
                flags = 'w'
            }
            else if (flags == '>>') {
                flags = 'a'
            }
            else if (flags == '<' || flags == '' || flags == '<:encoding(UTF-8)') {
                flags = 'r'
            }
            else if (flags == '+>') {
                flags = 'w+'
            }
            else if (flags == '+>>') {
                flags = 'a+'
            }
            else if (flags == '+<') {
                flags = 'r+'
            }
            else {
                CORE.die([ "don't know what to do with MODE '", flags, "'" ]);
            }
            var id = fs.openSync(path, flags);
            pkg.file_handle = { id : id, readline_buffer : '' };
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    };

    var p5atime = function(s) {
        try {
            var stat = fs.statSync(s); return stat["atime"];
        }
        catch(err) {
            return '';
        }
    };
    var p5mtime = function(s) {
        try {
            var stat = fs.statSync(s); return stat["mtime"];
        }
        catch(err) {
            return '';
        }
    };
    var p5ctime = function(s) {
        try {
            var stat = fs.statSync(s); return stat["ctime"];
        }
        catch(err) {
            return '';
        }
    };
    var p5size = function(s) {
        try {
            var stat = fs.statSync(s); return stat["size"];
        }
        catch(err) {
            return '';
        }
    };
    var p5is_file = function(s) {
        try {
            var stat = fs.statSync(s); return stat.isFile() ? 1 : 0;
        }
        catch(err) {
            return '';
        }
    };
    var p5is_directory = function(s) {
        try {
            var stat = fs.statSync(s); return stat.isDirectory() ? 1 : 0;
        }
        catch(err) {
            return '';
        }
    };
    var p5file_exists = function(s) {
        return p5is_file(s) || p5is_directory(s);
    };

    CORE.binmode = function(List__) {
        try {
            // TODO
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    };

    CORE.rmdir = function(List__) {
        try {
            fs.rmdir(p5str(List__[0]));
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    };

    CORE.chdir = function(List__) {
        try {
            process.chdir(p5str(List__[0]));
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    };

    CORE.exit = function(List__) {
        process.exit(List__[0]);
    };

    CORE.rename = function(List__) {
        try {
            fs.renameSync(p5str(List__[0]), p5str(List__[1]));
            return 1;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return '';
        }
    };

    CORE.unlink = function(List__) {
        var count = 0;
        try {
            for(var i = 0; i < List__.length; i++) {
                fs.unlinkSync(p5str(List__[i]));
                count++;
            }
            return count;
        }
        catch(err) {
            p5pkg["main"]["v_!"] = err;
            return count;
        }
    };

} else {
    // not running in node.js
    p5typeglob_set("Perlito5::IO", "print", function (filehandle, List__, p5want) {
        var s = "";
        for (var i = 0; i < List__.length; i++) {
            s = s + p5str(List__[i]);
        }
        if (typeof write === 'function') {
            // d8 shell uses "write"
            write(s);
        }
        else if (typeof print === 'function') {
            // Rhino uses "print"
            print(s);
        }
        else if (console && typeof console.log === 'function') {
            console.log(s);
        }
        else {
            alert(s);
        }
        return 1;
    });
}

p5typeglob_set("Perlito5::IO", "say", function (filehandle, List__, p5want) {
    p5pkg['Perlito5::IO'].print( filehandle, List__);
    p5pkg['Perlito5::IO'].print( filehandle, ["\n"]);
    return 1;
} );
p5typeglob_set("Perlito5::IO", "printf", function (filehandle, List__, p5want) {
    p5pkg["Perlito5::IO"].print( filehandle, CORE.sprintf(List__));
    return 1;
} );

CORE.select = function(List__) {
    if (List__.length == 1) {
        var v = List__[0];
        p5pkg["Perlito5"].v_SELECT = v;
    }
    return p5pkg["Perlito5"].v_SELECT;
};

CORE.die = function(List__) {
    var i;
    var s = "";
    for (var i = 0; i < List__.length; i++) {
        s = s + p5str(List__[i]);
    }
    if (s.substr(-1, 1) != "\n") {
        try {
            if (s == "") {
                s = "Died";
            }
            s = s + " at " + p5pkg["Perlito5"].v_FILE_NAME + " line " + p5pkg["Perlito5"].v_LINE_NUMBER;
            s = s + "\n" + new Error().stack + "\n";
        }
        catch(err) { }
    }
    p5pkg["main"]["v_@"] = s;
    throw(new p5_error("die", s));
};

CORE.say = function(List__) {
    return p5pkg['Perlito5::IO'].say( 'STDOUT', List__);
};
CORE.print = function(List__) {
    return p5pkg['Perlito5::IO'].print( 'STDOUT', List__);
};
CORE.printf = function(List__) {
    return p5pkg['Perlito5::IO'].printf( 'STDOUT', List__);
};
CORE.readline = function(List__, p5want) {
    return p5pkg['Perlito5::IO'].readline(List__, p5want);
};

CORE.warn = function(List__) {
    var i;
    var s = "";
    for (var i = 0; i < List__.length; i++) {
        s = s + p5str(List__[i]);
    }
    if (s.substr(-1, 1) != "\n") {
        try {
            if (s == "") {
                s = "Warning: something's wrong";
            }
            s = s + " at " + p5pkg["Perlito5"].v_FILE_NAME + " line " + p5pkg["Perlito5"].v_LINE_NUMBER;
            s = s + "\n" + new Error().stack + "\n";
        }
        catch(err) { }
    }
    p5pkg['Perlito5::IO'].print( 'STDERR', [s]);
};


/**
 * Copyright (c) 2010 Jakob Westhoff
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

CORE.sprintf = function(List__) {
    var format = List__.shift();
    var list = List__;

    // Check for format definition
    if ( typeof format != 'string' ) {
        CORE.die(["sprintf: The first arguments need to be a valid format string."]);
    }
    
    /**
     * Define the regex to match a formating string
     * The regex consists of the following parts:
     * percent sign to indicate the start
     * (optional) sign specifier
     * (optional) padding specifier
     * (optional) alignment specifier
     * (optional) width specifier
     * (optional) precision specifier
     * type specifier:
     *  % - literal percent sign
     *  b - binary number
     *  c - ASCII character represented by the given value
     *  d - signed decimal number
     *  f - floating point value
     *  o - octal number
     *  s - string
     *  x - hexadecimal number (lowercase characters)
     *  X - hexadecimal number (uppercase characters)
     */
    var r = new RegExp( /%(\+)?([0 ]|'(.))?(-)?([0-9]+)?(\.([0-9]+))?([%bcdfosxX])/g );

    /**
     * Each format string is splitted into the following parts:
     * 0: Full format string
     * 1: sign specifier (+)
     * 2: padding specifier (0/<space>/'<any char>)
     * 3: if the padding character starts with a ' this will be the real 
     *    padding character
     * 4: alignment specifier
     * 5: width specifier
     * 6: precision specifier including the dot
     * 7: precision specifier without the dot
     * 8: type specifier
     */
    var parts      = [];
    var paramIndex = 0;
    var part;
    while ( part = r.exec( format ) ) {
        // Check if an input value has been provided, for the current
        // format string
        if ( paramIndex >= list.length ) {
            CORE.die(["sprintf: At least one argument was missing."]);
        }

        parts[parts.length] = {
            /* beginning of the part in the string */
            begin: part.index,
            /* end of the part in the string */
            end: part.index + part[0].length,
            /* force sign */
            sign: ( part[1] == '+' ),
            /* is the given data negative */
            negative: ( parseInt( list[paramIndex] ) < 0 ) ? true : false,
            /* padding character (default: <space>) */
            padding: ( part[2] == undefined )
                     ? ( ' ' ) /* default */
                     : ( ( part[2].substring( 0, 1 ) == "'" ) 
                         ? ( part[3] ) /* use special char */
                         : ( part[2] ) /* use normal <space> or zero */
                       ),
            /* should the output be aligned left?*/
            alignLeft: ( part[4] == '-' ),
            /* width specifier (number or false) */
            width: ( part[5] != undefined ) ? part[5] : false,
            /* precision specifier (number or false) */
            precision: ( part[7] != undefined ) ? part[7] : false,
            /* type specifier */
            type: part[8],
            /* the given data associated with this part converted to a string */
            data: ( part[8] != '%' ) ? String ( list[paramIndex++] ) : false
        };
    }

    var newString = "";
    var start = 0;
    // Generate our new formated string
    for( var i=0; i<parts.length; ++i ) {
        // Add first unformated string part
        newString += format.substring( start, parts[i].begin );
        
        // Mark the new string start
        start = parts[i].end;

        // Create the appropriate preformat substitution
        // This substitution is only the correct type conversion. All the
        // different options and flags haven't been applied to it at this
        // point
        var preSubstitution = "";
        switch ( parts[i].type ) {
            case '%':
                preSubstitution = "%";
            break;
            case 'b':
                preSubstitution = Math.abs( parseInt( parts[i].data ) ).toString( 2 );
            break;
            case 'c':
                preSubstitution = String.fromCharCode( Math.abs( parseInt( parts[i].data ) ) );
            break;
            case 'd':
                preSubstitution = String( Math.abs( parseInt( parts[i].data ) ) );
            break;
            case 'f':
                preSubstitution = ( parts[i].precision == false )
                                  ? ( String( ( Math.abs( parseFloat( parts[i].data ) ) ) ) )
                                  : ( Math.abs( parseFloat( parts[i].data ) ).toFixed( parts[i].precision ) );
            break;
            case 'o':
                preSubstitution = Math.abs( parseInt( parts[i].data ) ).toString( 8 );
            break;
            case 's':
                preSubstitution = parts[i].data.substring( 0, parts[i].precision ? parts[i].precision : parts[i].data.length ); /* Cut if precision is defined */
            break;
            case 'x':
                preSubstitution = Math.abs( parseInt( parts[i].data ) ).toString( 16 ).toLowerCase();
            break;
            case 'X':
                preSubstitution = Math.abs( parseInt( parts[i].data ) ).toString( 16 ).toUpperCase();
            break;
            default:
                throw 'sprintf: Unknown type "' + parts[i].type + '" detected. This should never happen. Maybe the regex is wrong.';
        }

        // The % character is a special type and does not need further processing
        if ( parts[i].type ==  "%" ) {
            newString += preSubstitution;
            continue;
        }

        // Modify the preSubstitution by taking sign, padding and width
        // into account

        // Pad the string based on the given width
        if ( parts[i].width != false ) {
            // Padding needed?
            if ( parts[i].width > preSubstitution.length ) 
            {
                var origLength = preSubstitution.length;
                for( var j = 0; j < parts[i].width - origLength; ++j ) 
                {
                    preSubstitution = ( parts[i].alignLeft == true ) 
                                      ? ( preSubstitution + parts[i].padding )
                                      : ( parts[i].padding + preSubstitution );
                }
            }
        }

        // Add a sign symbol if neccessary or enforced, but only if we are
        // not handling a string
        if ( parts[i].type == 'b' 
          || parts[i].type == 'd' 
          || parts[i].type == 'o' 
          || parts[i].type == 'f' 
          || parts[i].type == 'x' 
          || parts[i].type == 'X' ) {
            if ( parts[i].negative == true ) {
                preSubstitution = "-" + preSubstitution;
            }
            else if ( parts[i].sign == true ) {
                preSubstitution = "+" + preSubstitution;
            }
        }

        // Add the substitution to the new string
        newString += preSubstitution;
    }

    // Add the last part of the given format string, which may still be there
    newString += format.substring( start, format.length );

    return newString;
};

var p5want;
var List__ = [];
(function () {
	null;
	p5make_package('Perlito5');
	(function () {
		p5make_package('feature');
		p5typeglob_set('feature', 'import', (function () {
			var tmp3320;
			tmp3320 = function (List__, p5want) {
				return p5want ? [] : null
			};
			tmp3320._prototype_ = null;
			return tmp3320
		})());
		p5typeglob_set('feature', 'unimport', (function () {
			var tmp3321;
			tmp3321 = function (List__, p5want) {
				return p5want ? [] : null
			};
			tmp3321._prototype_ = null;
			return tmp3321
		})());
		1;
	})();
	// use feature
;
	(function () {
		p5make_package('strict');
		p5typeglob_set('strict', 'import', (function () {
			var tmp3322;
			tmp3322 = function (List__, p5want) {
				return ((p5make_package('Perlito5')['v_STRICT'] = (1)));
			};
			tmp3322._prototype_ = null;
			return tmp3322
		})());
		p5typeglob_set('strict', 'unimport', (function () {
			var tmp3323;
			tmp3323 = function (List__, p5want) {
				return ((p5make_package('Perlito5')['v_STRICT'] = (0)));
			};
			tmp3323._prototype_ = null;
			return tmp3323
		})());
		1;
	})();
	(function () {
		p5make_package('warnings');
		p5typeglob_set('warnings', 'import', (function () {
			var tmp3324;
			tmp3324 = function (List__, p5want) {
				return ((p5make_package('Perlito5')['v_WARNINGS'] = (1)));
			};
			tmp3324._prototype_ = null;
			return tmp3324
		})());
		p5typeglob_set('warnings', 'unimport', (function () {
			var tmp3325;
			tmp3325 = function (List__, p5want) {
				return ((p5make_package('Perlito5')['v_WARNINGS'] = (0)));
			};
			tmp3325._prototype_ = null;
			return tmp3325
		})());
		1;
	})();
	(function () {
		null;
		p5make_package('Perlito5::Match');
		p5typeglob_set('Perlito5::Match', 'flat', (function () {
			var tmp3326;
			tmp3326 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (( ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('capture') != null) ? (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('capture') : CORE.substr(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('str'), (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('from'), (p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('to')) - p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('from')))]), p5want)));
			};
			tmp3326._prototype_ = null;
			return tmp3326
		})());
		1;
	})();
	(function () {
		p5block(function (v) {}, function () {
				p5make_package('main');
				p5make_package('Perlito5::Grammar');
				// use Perlito5::Grammar::Expression
;
				// use Perlito5::Grammar::Statement
;
				// use Perlito5::Grammar::Control
;
				// use Perlito5::Grammar::String
;
				// use Perlito5::Grammar::Sigil
;
				// use Perlito5::Grammar::Use
;
				// use Perlito5::Grammar::Block
;
				// use Perlito5::Grammar::Space
;
				// use Perlito5::Grammar::Print
;
				// use Perlito5::Grammar::Map
;
				// use Perlito5::Grammar::Attribute
;
				// use Perlito5::Grammar::Number
;
				p5typeglob_set('Perlito5::Grammar', 'word', (function () {
					var tmp3327;
					tmp3327 = function (List__, p5want) {
						return (( p5bool(p5m(p5str(List__.p5aget(0)).substr(p5num(List__.p5aget(1)), 1), String.fromCharCode(92) + 'w', '', 0)) ? (new p5HashRef(p5a_to_h(p5list_to_a(['str', List__.p5aget(0), 'from', List__.p5aget(1), 'to', (p5num(List__.p5aget(1)) + 1)])))) : 0));
					};
					tmp3327._prototype_ = null;
					return tmp3327
				})());
				p5typeglob_set('Perlito5::Grammar', 'ident', (function () {
					var tmp3328;
					tmp3328 = function (List__, p5want) {
						try {
							p5and(p5context([p5or(!(p5m(p5str(List__.p5aget(0)).substr(p5num(List__.p5aget(1)), 1), String.fromCharCode(92) + 'w', '', 0)), function () {
								return p5m(p5str(List__.p5aget(0)).substr(p5num(List__.p5aget(1)), 1), String.fromCharCode(92) + 'd', '', 0)
							})], 0), function () {
								throw(p5context([], p5want))
							});
							var v_m;
							v_m = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', List__.p5aget(0), 'from', List__.p5aget(1), 'to', (p5num(List__.p5aget(1)) + 1)])))));
							(function () {
								p5while(function () {
									(v_m || (v_m = new p5HashRef({})))._hash_.p5postincr('to');
								}, function () {
									return p5m(p5str(List__.p5aget(0)).substr(p5num((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to')), 1), String.fromCharCode(92) + 'w', '', 0)
								}, false, '', 0)
							})();
							return (p5context([v_m], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3328._prototype_ = null;
					return tmp3328
				})());
				p5typeglob_set('Perlito5::Grammar', 'caret_char', (function () {
					var tmp3329;
					tmp3329 = function (List__, p5want) {
						try {
							var v_c;
							v_c = (p5str(List__.p5aget(0)).substr(p5num(List__.p5aget(1)), 1));
							var v_pos;
							v_pos = (List__.p5aget(1));
							(function () {
								if ( (p5str(v_c) == '^') ) {
								(function () {
									var tmp3330 = v_pos;
									v_pos = p5incr_(tmp3330);
									return tmp3330
								})();
								v_c = (p5str(List__.p5aget(0)).substr(p5num(v_pos), 1));
								p5and(p5context([p5or((p5str(v_c) < 'A'), function () {
									return (p5str(v_c) > 'Z')
								})], 0), function () {
									throw(p5context([0], p5want))
								});
								v_c = (p5pkg['Perlito5::Grammar'].chr([((p5pkg['Perlito5::Grammar'].ord([v_c], 0) - p5pkg['Perlito5::Grammar'].ord(['A'], 0)) + 1)], 0));
							}
							else (function () {
								if ( p5bool(p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([List__.p5aget(0), v_pos]), 0)) ) {
								throw(p5context([0], p5want));
							}
							})()
							})();
							p5and(p5context([p5or((p5str(v_c) < p5pkg['Perlito5::Grammar'].chr([1], 0)), function () {
								return (p5str(v_c) > p5pkg['Perlito5::Grammar'].chr([26], 0))
							})], 0), function () {
								throw(p5context([0], p5want))
							});
							return ((new p5HashRef(p5a_to_h(p5list_to_a(['str', List__.p5aget(0), 'from', List__.p5aget(1), 'to', (p5num(v_pos) + 1), 'capture', v_c])))));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3329._prototype_ = null;
					return tmp3329
				})());
				p5typeglob_set('Perlito5::Grammar', 'full_ident', (function () {
					var tmp3331;
					tmp3331 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5context([(function () {
											var v_last_match_null;
											v_last_match_null = (0);
											var v_m;
											v_m = (v_MATCH);
											var v_to;
											v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
											(function () {
												p5while(function () {
													(function () {
														if ( (p5num(v_to) == p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'))) ) {
														v_last_match_null = ((p5num(v_last_match_null) + 1));
													}
													else {
														v_last_match_null = (0);
													}
													})();
													v_m = (v_MATCH);
													v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
												}, function () {
													return p5and(p5context([p5and(p5context([p5and(('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0), function () {
														return p5context([(function () {
															var v_m2;
															v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0)
													})], 0), function () {
														return p5context([(p5num(v_last_match_null) < 2)], 0)
													})
												}, false, '', 0)
											})();
											v_MATCH = (v_m);
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_to));
											return ((1));
										})()], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3331._prototype_ = null;
					return tmp3331
				})());
				p5typeglob_set('Perlito5::Grammar', 'namespace_before_ident', (function () {
					var tmp3332;
					tmp3332 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5and(p5context([(function () {
											var v_tmp;
											v_tmp = (v_MATCH);
											v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
											var v_res;
											v_res = (p5context([p5and(('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0));
											v_MATCH = (v_tmp);
											return ((( p5bool(v_res) ? 1 : 0)));
										})()], 0), function () {
											return p5context([(function () {
												var v_last_match_null;
												v_last_match_null = (0);
												var v_m;
												v_m = (v_MATCH);
												var v_to;
												v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
												(function () {
													p5while(function () {
														(function () {
															if ( (p5num(v_to) == p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'))) ) {
															v_last_match_null = ((p5num(v_last_match_null) + 1));
														}
														else {
															v_last_match_null = (0);
														}
														})();
														v_m = (v_MATCH);
														v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
													}, function () {
														return p5and(p5context([p5and(p5context([p5and(('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5context([(function () {
																	var v_tmp;
																	v_tmp = (v_MATCH);
																	v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
																	var v_res;
																	v_res = (p5context([p5and(('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
																				return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																			})], 0));
																	v_MATCH = (v_tmp);
																	return ((( p5bool(v_res) ? 1 : 0)));
																})()], 0)
															})
														})], 0), function () {
															return p5context([(p5num(v_last_match_null) < 2)], 0)
														})
													}, false, '', 0)
												})();
												v_MATCH = (v_m);
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_to));
												return ((1));
											})()], 0)
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3332._prototype_ = null;
					return tmp3332
				})());
				p5typeglob_set('Perlito5::Grammar', 'optional_namespace_before_ident', (function () {
					var tmp3333;
					tmp3333 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar'].namespace_before_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('namespace_before_ident', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([(function () {
															var v_last_match_null;
															v_last_match_null = (0);
															var v_m;
															v_m = (v_MATCH);
															var v_to;
															v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
															(function () {
																p5while(function () {
																	(function () {
																		if ( (p5num(v_to) == p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'))) ) {
																		v_last_match_null = ((p5num(v_last_match_null) + 1));
																	}
																	else {
																		v_last_match_null = (0);
																	}
																	})();
																	v_m = (v_MATCH);
																	v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																}, function () {
																	return p5and(p5context([p5and(('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5context([(p5num(v_last_match_null) < 2)], 0)
																	})
																}, false, '', 0)
															})();
															v_MATCH = (v_m);
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_to));
															return ((1));
														})()], 0), function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('namespace_before_ident')]), 0)));
																return ((1));
															})()], 0)
														})
													})], 0)));
											})()], 0), function () {
												return p5or(p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([p5and(p5context([p5and(('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar'].optional_namespace_before_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('optional_namespace_before_ident', (v_m2));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	var v_name;
																	v_name = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('optional_namespace_before_ident')]), 0));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ('main'));
																	p5and((p5str(v_name) != ''), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((p5str((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('capture')) + ('::' + p5str(v_name)))))], 0)
																	});
																	return ((1));
																})()], 0)
															})
														})], 0)));
												})()], 0), function () {
													return p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
														return ((p5context([p5and(1, function () {
																return p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (''));
																	return ((1));
																})()], 0)
															})], 0)));
													})()], 0)
												})
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3333._prototype_ = null;
					return tmp3333
				})());
				p5typeglob_set('Perlito5::Grammar', 'exp_stmts2', (function () {
					var tmp3334;
					tmp3334 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar'].exp_stmts(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('exp_stmts', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5context([(function () {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('exp_stmts')]), 0)));
											return ((1));
										})()], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3334._prototype_ = null;
					return tmp3334
				})());
				p5typeglob_set('Perlito5::Grammar', 'exp', (function () {
					var tmp3335;
					tmp3335 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar::Expression'].exp_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::exp_parse', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5context([(function () {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::exp_parse')]), 0)));
											return ((1));
										})()], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3335._prototype_ = null;
					return tmp3335
				})());
				p5typeglob_set('Perlito5::Grammar', 'exp2', (function () {
					var tmp3336;
					tmp3336 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar::Expression'].exp_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::exp_parse', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5context([(function () {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::exp_parse')]), 0)));
											return ((1));
										})()], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3336._prototype_ = null;
					return tmp3336
				})());
				p5typeglob_set('Perlito5::Grammar', 'opt_type', (function () {
					var tmp3337;
					tmp3337 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(p5context([(function () {
														var v_m;
														v_m = (v_MATCH);
														(function () {
															if ( !( (('::' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)) && p5bool((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))))) ) {
															v_MATCH = (v_m);
														}
														})();
														return ((1));
													})()], 0), function () {
														return p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5pkg['Perlito5::Grammar'].full_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('full_ident', (v_m2));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('full_ident')]), 0)));
																return ((1));
															})()], 0)
														})
													})], 0)));
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([p5and(1, function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (''));
																return ((1));
															})()], 0)
														})], 0)));
												})()], 0)
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3337._prototype_ = null;
					return tmp3337
				})());
				p5typeglob_set('Perlito5::Grammar', 'var_sigil', (function () {
					var tmp3338;
					tmp3338 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(('$' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0)));
											})()], 0), function () {
												return p5or(p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([p5and(('%' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0)));
												})()], 0), function () {
													return p5or(p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
														return ((p5context([p5and(('@' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0)));
													})()], 0), function () {
														return p5or(p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
															return ((p5context([p5and(('&' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																	return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																})], 0)));
														})()], 0), function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([p5and(('*' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0)));
															})()], 0)
														})
													})
												})
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3338._prototype_ = null;
					return tmp3338
				})());
				p5typeglob_set('Perlito5::Grammar', 'var_name', (function () {
					var tmp3339;
					tmp3339 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar'].full_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('full_ident', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0)));
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([(function () {
															var v_m2;
															v_m2 = (p5call_sub('Perlito5::Grammar::Number', 'digits', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Number::digits', (v_m2));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0)));
												})()], 0)
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3339._prototype_ = null;
					return tmp3339
				})());
				p5typeglob_set('Perlito5::Grammar', 'var_ident', (function () {
					var tmp3340;
					tmp3340 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar'].var_sigil(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('var_sigil', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar'].optional_namespace_before_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('optional_namespace_before_ident', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												var v_m2;
												v_m2 = (p5pkg['Perlito5::Grammar'].var_name(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
												return (function () {
													if ( p5bool(v_m2) ) {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('var_name', (v_m2));
													return ((1));
												}
												else {
													return ((0));
												}
												})()
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::Var', 'new', p5list_to_a(['sigil', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('var_sigil')]), 1), 'namespace', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('optional_namespace_before_ident')]), 1), 'name', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('var_name')]), 1)]), 0)));
													return ((1));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3340._prototype_ = null;
					return tmp3340
				})());
				p5typeglob_set('Perlito5::Grammar', 'block', (function () {
					var tmp3341;
					tmp3341 = function (List__, p5want) {
						return (p5call_sub('Perlito5::Grammar::Block', 'block', p5list_to_a([List__]), p5want));
					};
					tmp3341._prototype_ = null;
					return tmp3341
				})());
				p5typeglob_set('Perlito5::Grammar', 'block2', (function () {
					var tmp3342;
					tmp3342 = function (List__, p5want) {
						return (p5call_sub('Perlito5::Grammar::Block', 'block', p5list_to_a([List__]), p5want));
					};
					tmp3342._prototype_ = null;
					return tmp3342
				})());
				p5typeglob_set('Perlito5::Grammar', 'opt_continue_block', (function () {
					var tmp3343;
					tmp3343 = function (List__, p5want) {
						return (p5call_sub('Perlito5::Grammar::Block', 'opt_continue_block', p5list_to_a([List__]), p5want));
					};
					tmp3343._prototype_ = null;
					return tmp3343
				})());
				var List_PKG = [];
				p5typeglob_set('Perlito5::Grammar', 'exp_stmts', (function () {
					var tmp3344;
					tmp3344 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						List_PKG.p5push([p5make_package('Perlito5')['v_PKG_NAME']]);
						var v_has_semicolon;
						var List_stmts = [];
						var v_m;
						v_m = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', [v_str, v_pos], 0));
						v_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
						(function () {
								p5while(function () {
									(function () {
										if ( (p5str(v_str).substr(p5num(v_pos), 1) == ';') ) {
										v_has_semicolon = (1);
										v_m = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', [v_str, (p5num(v_pos) + 1)], 0));
										v_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
									}
									else {
										v_m = (p5call_sub('Perlito5::Grammar::Statement', 'statement_parse', [v_str, v_pos], 0));
										(function () {
											if ( p5bool(v_m) ) {
											List_stmts.p5push(p5list_to_a([(v_m || (v_m = new p5HashRef({})))._hash_.p5hget('capture')]));
											v_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
											(function () {
												if ( (p5str(v_str).substr(p5num(v_pos), 1) == ';') ) {
												v_has_semicolon = (1);
												v_pos = ((p5num(v_pos) + 1));
											}
											})();
											v_m = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', [v_str, v_pos], 0));
											v_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
										}
										})();
									}
									})();
								}, function () {
									return v_m
								}, false, '', 0)
							})();
						p5make_package('Perlito5')['v_PKG_NAME'] = (List_PKG.pop());
						(p5make_package('Perlito5')['v_BLOCK_HAS_SEMICOLON'] = (p5or(p5make_package('Perlito5')['v_BLOCK_HAS_SEMICOLON'], function () {
										return v_has_semicolon
									})));
						return ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'to', v_pos, 'capture', (new p5ArrayRef(List_stmts))])))));
					};
					tmp3344._prototype_ = null;
					return tmp3344
				})());
			}, [0], false, ''
		);
		1;
	})();
	(function () {
		p5block(function (v) {}, function () {
				p5make_package('main');
				p5make_package('Perlito5::Grammar');
				// use strict
;
				// use Perlito5::Grammar::Expression
;
				// use Perlito5::Grammar::Statement
;
				p5typeglob_set('Perlito5::Grammar', 'unless', (function () {
					var tmp3345;
					tmp3345 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('unless' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 6)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((6 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([(function () {
													var v_m2;
													v_m2 = (p5pkg['Perlito5::Grammar::Expression'].term_paren(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::term_paren', (v_m2));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})()], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5and(p5context([(function () {
																var v_pos1;
																v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																return ((p5or(p5context([(function () {
																		return ((p5context([p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5and(p5context([p5and(('else' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 4)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((4 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0), function () {
																					return p5and(p5context([(function () {
																						var v_m2;
																						v_m2 = (p5pkg['Perlito5::Grammar'].block2(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block2', (v_m2));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})()], 0), function () {
																						return p5context([(function () {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::If', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_paren')]), p5want)._array_.p5aget(2), 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block2')]), 1), 'otherwise', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1)]), 0)));
																							return ((1));
																						})()], 0)
																					})
																				})
																			})], 0)));
																	})()], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																			return ((p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::If', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_paren')]), p5want)._array_.p5aget(2), 'body', p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', (new p5ArrayRef([]))]), 1), 'otherwise', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1)]), 0)));
																					return ((1));
																				})()], 0)));
																		})()], 0)
																	})));
															})()], 0), function () {
																return p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
																	return ((1));
																})()], 0)
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3345._prototype_ = null;
					return tmp3345
				})());
				p5typeglob_set('Perlito5::Grammar', 'if_', (function () {
					var tmp3346;
					tmp3346 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('if' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([(function () {
													var v_m2;
													v_m2 = (p5pkg['Perlito5::Grammar::Expression'].term_paren(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::term_paren', (v_m2));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})()], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5and(p5context([(function () {
																var v_pos1;
																v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																return ((p5or(p5context([(function () {
																		return ((p5context([p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5and(p5context([p5and(('else' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 4)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((4 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0), function () {
																					return p5and(p5context([(function () {
																						var v_m2;
																						v_m2 = (p5pkg['Perlito5::Grammar'].block2(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block2', (v_m2));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})()], 0), function () {
																						return p5context([(function () {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::If', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_paren')]), p5want)._array_.p5aget(2), 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1), 'otherwise', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block2')]), 1)]), 0)));
																							return ((1));
																						})()], 0)
																					})
																				})
																			})], 0)));
																	})()], 0), function () {
																		return p5or(p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																			return ((p5context([p5and(p5context([(function () {
																					var v_m2;
																					v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																					return (function () {
																						if ( p5bool(v_m2) ) {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																						return ((1));
																					}
																					else {
																						return ((0));
																					}
																					})()
																				})()], 0), function () {
																					return p5and(p5context([p5and(('els' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 3)), function () {
																						return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((3 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																					})], 0), function () {
																						return p5and(p5context([(function () {
																							var v_m2;
																							v_m2 = (p5pkg['Perlito5::Grammar'].if_(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																							return (function () {
																								if ( p5bool(v_m2) ) {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('if_', (v_m2));
																								return ((1));
																							}
																							else {
																								return ((0));
																							}
																							})()
																						})()], 0), function () {
																							return p5context([(function () {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::If', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_paren')]), p5want)._array_.p5aget(2), 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1), 'otherwise', p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('if_')]), 1)])))]), 1)]), 0)));
																								return ((1));
																							})()], 0)
																						})
																					})
																				})], 0)));
																		})()], 0), function () {
																			return p5context([(function () {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																				return ((p5context([(function () {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::If', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_paren')]), p5want)._array_.p5aget(2), 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1), 'otherwise', p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', (new p5ArrayRef([]))]), 1)]), 0)));
																						return ((1));
																					})()], 0)));
																			})()], 0)
																		})
																	})));
															})()], 0), function () {
																return p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
																	return ((1));
																})()], 0)
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3346._prototype_ = null;
					return tmp3346
				})());
				p5typeglob_set('Perlito5::Grammar', 'when', (function () {
					var tmp3347;
					tmp3347 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('when' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 4)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((4 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([(function () {
													var v_m2;
													v_m2 = (p5pkg['Perlito5::Grammar::Expression'].term_paren(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::term_paren', (v_m2));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})()], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5and(p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::When', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_paren')]), p5want)._array_.p5aget(2), 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1)]), 0)));
																return ((1));
															})()], 0), function () {
																return p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
																	return ((1));
																})()], 0)
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3347._prototype_ = null;
					return tmp3347
				})());
				p5typeglob_set('Perlito5::Grammar', 'for', (function () {
					var tmp3348;
					tmp3348 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('for' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 3)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((3 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m;
											v_m = (v_MATCH);
											(function () {
												if ( !( (('each' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 4)) && p5bool((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((4 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))))) ) {
												v_MATCH = (v_m);
											}
											})();
											return ((1));
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([(function () {
													var v_pos1;
													v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
													return ((p5or(p5context([(function () {
															return ((p5context([p5and(p5context([(function () {
																	var v_pos1;
																	v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																	return ((p5or(p5context([(function () {
																			return ((p5context([p5and(p5context([(function () {
																					var v_m2;
																					v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																					return (function () {
																						if ( p5bool(v_m2) ) {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																						return ((1));
																					}
																					else {
																						return ((0));
																					}
																					})()
																				})()], 0), function () {
																					return p5and(p5context([(function () {
																						var v_m2;
																						v_m2 = (p5pkg['Perlito5::Grammar::Expression'].term_declarator(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::term_declarator', (v_m2));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})()], 0), function () {
																						return p5context([(function () {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('_tmp', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::term_declarator')]), p5want)._array_.p5aget(1)));
																							return ((1));
																						})()], 0)
																					})
																				})], 0)));
																		})()], 0), function () {
																			return p5context([(function () {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																				return ((p5context([p5and(p5context([(function () {
																						var v_m2;
																						v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})()], 0), function () {
																						return p5and(p5context([(function () {
																							var v_tmp;
																							v_tmp = (v_MATCH);
																							v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
																							var v_res;
																							v_res = (p5context([p5and(('$' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																									})], 0));
																							v_MATCH = (v_tmp);
																							return ((( p5bool(v_res) ? 1 : 0)));
																						})()], 0), function () {
																							return p5and(p5context([(function () {
																								var v_m2;
																								v_m2 = (p5call_sub('Perlito5::Grammar::Sigil', 'term_sigil', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																								return (function () {
																									if ( p5bool(v_m2) ) {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Sigil::term_sigil', (v_m2));
																									return ((1));
																								}
																								else {
																									return ((0));
																								}
																								})()
																							})()], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('_tmp', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Sigil::term_sigil')]), p5want)._array_.p5aget(1)));
																									return ((1));
																								})()], 0)
																							})
																						})
																					})], 0)));
																			})()], 0)
																		})));
																})()], 0), function () {
																	return p5and(p5context([(function () {
																		var v_m2;
																		v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																		return (function () {
																			if ( p5bool(v_m2) ) {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																			return ((1));
																		}
																		else {
																			return ((0));
																		}
																		})()
																	})()], 0), function () {
																		return p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::paren_parse', (v_m2));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0), function () {
																					return p5and(p5context([(function () {
																						var v_m2;
																						v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})()], 0), function () {
																						return p5and(p5context([(function () {
																							var v_m2;
																							v_m2 = (p5pkg['Perlito5::Grammar'].opt_continue_block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																							return (function () {
																								if ( p5bool(v_m2) ) {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('opt_continue_block', (v_m2));
																								return ((1));
																							}
																							else {
																								return ((0));
																							}
																							})()
																						})()], 0), function () {
																							return p5context([(function () {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																								var v_body;
																								v_body = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 0));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::For', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::paren_parse')]), 1), 'body', v_body, 'continue', (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('opt_continue_block')._hash_.p5hget('capture'), 'topic', (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('_tmp')]), 0)));
																								return ((1));
																							})()], 0)
																						})
																					})
																				})
																			})
																		})
																	})
																})], 0)));
														})()], 0), function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([p5and(p5context([(function () {
																		var v_m2;
																		v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																		return (function () {
																			if ( p5bool(v_m2) ) {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																			return ((1));
																		}
																		else {
																			return ((0));
																		}
																		})()
																	})()], 0), function () {
																		return p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5and(p5context([(function () {
																				var v_pos1;
																				v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																				return ((p5or(p5context([(function () {
																						return ((p5context([p5and(p5context([(function () {
																								var v_m2;
																								v_m2 = (p5pkg['Perlito5::Grammar::Expression'].exp_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																								return (function () {
																									if ( p5bool(v_m2) ) {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::exp_parse', (v_m2));
																									return ((1));
																								}
																								else {
																									return ((0));
																								}
																								})()
																							})()], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																									p5pkg['Perlito5::Grammar::Scope'].check_variable_declarations([], null);
																									return ((1));
																								})()], 0)
																							})], 0)));
																					})()], 0), function () {
																						return p5or(p5context([(function () {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																							return ((p5context([], 0)));
																						})()], 0), function () {
																							return p5context([(function () {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																								return ((p5context([p5and(p5context([(function () {
																										var v_m2;
																										v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																										return (function () {
																											if ( p5bool(v_m2) ) {
																											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																											return ((1));
																										}
																										else {
																											return ((0));
																										}
																										})()
																									})()], 0), function () {
																										return p5context([(function () {
																											var v_tmp;
																											v_tmp = (v_MATCH);
																											v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
																											var v_res;
																											v_res = (p5context([p5and((';' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																													})], 0));
																											v_MATCH = (v_tmp);
																											return ((( p5bool(v_res) ? 1 : 0)));
																										})()], 0)
																									})], 0)));
																							})()], 0)
																						})
																					})));
																			})()], 0), function () {
																				return p5and(p5context([(function () {
																					var v_pos1;
																					v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																					return ((p5or(p5context([(function () {
																							return ((p5context([p5and(p5context([p5and((';' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																									return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																								})], 0), function () {
																									return p5and(p5context([(function () {
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('c_style_for', (1));
																										return ((1));
																									})()], 0), function () {
																										return p5and(p5context([(function () {
																											var v_pos1;
																											v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																											return ((p5or(p5context([(function () {
																													return ((p5context([p5and(p5context([(function () {
																															var v_m2;
																															v_m2 = (p5pkg['Perlito5::Grammar'].exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																															return (function () {
																																if ( p5bool(v_m2) ) {
																																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::exp', (v_m2));
																																return ((1));
																															}
																															else {
																																return ((0));
																															}
																															})()
																														})()], 0), function () {
																															return p5context([(function () {
																																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																																p5pkg['Perlito5::Grammar::Scope'].check_variable_declarations([], null);
																																return ((1));
																															})()], 0)
																														})], 0)));
																												})()], 0), function () {
																													return p5or(p5context([(function () {
																														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																														return ((p5context([], 0)));
																													})()], 0), function () {
																														return p5context([(function () {
																															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																															return ((p5context([(function () {
																																	var v_m2;
																																	v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																																	return (function () {
																																		if ( p5bool(v_m2) ) {
																																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																																		return ((1));
																																	}
																																	else {
																																		return ((0));
																																	}
																																	})()
																																})()], 0)));
																														})()], 0)
																													})
																												})));
																										})()], 0), function () {
																											return p5and(p5context([p5and((';' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																											})], 0), function () {
																												return p5context([(function () {
																													var v_pos1;
																													v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																													return ((p5or(p5context([(function () {
																															return ((p5context([(function () {
																																	var v_m2;
																																	v_m2 = (p5pkg['Perlito5::Grammar'].exp2(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																																	return (function () {
																																		if ( p5bool(v_m2) ) {
																																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::exp2', (v_m2));
																																		return ((1));
																																	}
																																	else {
																																		return ((0));
																																	}
																																	})()
																																})()], 0)));
																														})()], 0), function () {
																															return p5or(p5context([(function () {
																																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																																return ((p5context([], 0)));
																															})()], 0), function () {
																																return p5context([(function () {
																																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																																	return ((p5context([(function () {
																																			var v_m2;
																																			v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																																			return (function () {
																																				if ( p5bool(v_m2) ) {
																																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																																				return ((1));
																																			}
																																			else {
																																				return ((0));
																																			}
																																			})()
																																		})()], 0)));
																																})()], 0)
																															})
																														})));
																												})()], 0)
																											})
																										})
																									})
																								})], 0)));
																						})()], 0), function () {
																							return p5context([(function () {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																								return ((1));
																							})()], 0)
																						})));
																				})()], 0), function () {
																					return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																						return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																					})], 0), function () {
																						return p5and(p5context([(function () {
																							var v_m2;
																							v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																							return (function () {
																								if ( p5bool(v_m2) ) {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																								return ((1));
																							}
																							else {
																								return ((0));
																							}
																							})()
																						})()], 0), function () {
																							return p5and(p5context([(function () {
																								var v_m2;
																								v_m2 = (p5pkg['Perlito5::Grammar'].opt_continue_block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																								return (function () {
																									if ( p5bool(v_m2) ) {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('opt_continue_block', (v_m2));
																									return ((1));
																								}
																								else {
																									return ((0));
																								}
																								})()
																							})()], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																									var v_header;
																									var v_body;
																									v_body = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 0));
																									var v_topic;
																									(function () {
																										if ( p5bool((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('c_style_for')) ) {
																										v_header = ((new p5ArrayRef(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('Perlito5::Grammar::Expression::exp_parse')._hash_.p5hget('capture'), (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('Perlito5::Grammar::exp')._hash_.p5hget('capture'), (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('Perlito5::Grammar::exp2')._hash_.p5hget('capture')]))));
																									}
																									else {
																										v_header = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('Perlito5::Grammar::Expression::exp_parse')._hash_.p5hget('capture'));
																										v_topic = (p5call('Perlito5::AST::Var', 'new', ['namespace', '', 'name', '_', 'sigil', '$'], 0));
																									}
																									})();
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::For', 'new', p5list_to_a(['cond', v_header, 'body', v_body, 'continue', (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('opt_continue_block')._hash_.p5hget('capture'), 'topic', v_topic]), 0)));
																									return ((1));
																								})()], 0)
																							})
																						})
																					})
																				})
																			})
																		})
																	})], 0)));
															})()], 0)
														})));
												})()], 0), function () {
													return p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
														p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
														return ((1));
													})()], 0)
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3348._prototype_ = null;
					return tmp3348
				})());
				p5typeglob_set('Perlito5::Grammar', 'while', (function () {
					var tmp3349;
					tmp3349 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('while' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 5)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((5 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
													return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
												})], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::paren_parse', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5and(p5context([(function () {
																	var v_m2;
																	v_m2 = (p5pkg['Perlito5::Grammar'].opt_continue_block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																	return (function () {
																		if ( p5bool(v_m2) ) {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('opt_continue_block', (v_m2));
																		return ((1));
																	}
																	else {
																		return ((0));
																	}
																	})()
																})()], 0), function () {
																	return p5and(p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																		var v_cond;
																		v_cond = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::paren_parse')]), 0));
																		(function () {
																			if ( (p5str(v_cond) == '*undef*') ) {
																			v_cond = (p5call('Perlito5::AST::Int', 'new', ['int', 1], 0));
																		}
																		})();
																		var v_stmt;
																		v_stmt = (p5call('Perlito5::AST::While', 'new', p5list_to_a(['cond', v_cond, 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1), 'continue', (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('opt_continue_block')._hash_.p5hget('capture')]), 0));
																		var v_out;
																		v_out = (p5pkg['Perlito5::Macro'].while_file([v_stmt], 0));
																		p5and(v_out, function () {
																			return p5context([v_stmt = (v_out)], 0)
																		});
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (v_stmt));
																		return ((1));
																	})()], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
																			return ((1));
																		})()], 0)
																	})
																})
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3349._prototype_ = null;
					return tmp3349
				})());
				p5typeglob_set('Perlito5::Grammar', 'until', (function () {
					var tmp3350;
					tmp3350 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('until' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 5)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((5 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
													return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
												})], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::paren_parse', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5and(p5context([(function () {
																	var v_m2;
																	v_m2 = (p5pkg['Perlito5::Grammar'].opt_continue_block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																	return (function () {
																		if ( p5bool(v_m2) ) {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('opt_continue_block', (v_m2));
																		return ((1));
																	}
																	else {
																		return ((0));
																	}
																	})()
																})()], 0), function () {
																	return p5and(p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																		var v_cond;
																		v_cond = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::paren_parse')]), 0));
																		(function () {
																			if ( (p5str(v_cond) == '*undef*') ) {
																			v_cond = (p5call('Perlito5::AST::Int', 'new', ['int', 1], 0));
																		}
																		})();
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::While', 'new', p5list_to_a(['cond', p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['arguments', (new p5ArrayRef([v_cond])), 'code', 'prefix:<!>', 'namespace', '']), 1), 'body', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 1), 'continue', (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('opt_continue_block')._hash_.p5hget('capture')]), 0)));
																		return ((1));
																	})()], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
																			return ((1));
																		})()], 0)
																	})
																})
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3350._prototype_ = null;
					return tmp3350
				})());
				p5typeglob_set('Perlito5::Grammar', 'given', (function () {
					var tmp3351;
					tmp3351 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('given' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 5)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((5 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												p5pkg['Perlito5::Grammar::Scope'].create_new_compile_time_scope([], null);
												return ((1));
											})()], 0), function () {
												return p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
													return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
												})], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Expression::paren_parse', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('block', (v_m2));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5and(p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	var v_body;
																	v_body = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('block')]), 0));
																	(v_body || (v_body = new p5HashRef({})))._hash_.p5hset('sig', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::var_ident')]), 0)));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::AST::Given', 'new', p5list_to_a(['cond', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Expression::paren_parse')]), 1), 'body', v_body]), 0)));
																	return ((1));
																})()], 0), function () {
																	return p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																		p5pkg['Perlito5::Grammar::Scope'].end_compile_time_scope([], null);
																		return ((1));
																	})()], 0)
																})
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3351._prototype_ = null;
					return tmp3351
				})());
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['if', p5pkg['Perlito5::Grammar'].if_]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['for', p5pkg['Perlito5::Grammar'].for]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['foreach', p5pkg['Perlito5::Grammar'].for]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['when', p5pkg['Perlito5::Grammar'].when]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['while', p5pkg['Perlito5::Grammar'].while]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['until', p5pkg['Perlito5::Grammar'].until]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['given', p5pkg['Perlito5::Grammar'].given]), null);
				p5call_sub('Perlito5::Grammar::Statement', 'add_statement', p5list_to_a(['unless', p5pkg['Perlito5::Grammar'].unless]), null);
			}, [0], false, ''
		);
		1;
	})();
	(function () {
		p5make_package('Perlito5::Grammar::Precedence');
		// use feature
;
		p5typeglob_set('Perlito5::Grammar::Precedence', 'new', (function () {
			var tmp3352;
			tmp3352 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Grammar::Precedence'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3352._prototype_ = null;
			return tmp3352
		})());
		var v_Operator;
		v_Operator = ((new p5HashRef({})));
		var v_Precedence;
		v_Precedence = ((new p5HashRef({})));
		var v_PrefixPrecedence;
		v_PrefixPrecedence = ((new p5HashRef({})));
		var v_Assoc;
		v_Assoc = ((new p5HashRef({})));
		p5typeglob_set('Perlito5::Grammar::Precedence', 'is_assoc_type', (function () {
			var tmp3353;
			tmp3353 = function (List__, p5want) {
				var v_assoc_type;
				v_assoc_type = (List__.shift());
				var v_op_name;
				v_op_name = (List__.shift());
				return ((v_Assoc || (v_Assoc = new p5HashRef({})))._hash_.p5hget_hash(p5str(v_assoc_type))._hash_.p5hget(p5str(v_op_name)));
			};
			tmp3353._prototype_ = null;
			return tmp3353
		})());
		p5typeglob_set('Perlito5::Grammar::Precedence', 'is_fixity_type', (function () {
			var tmp3354;
			tmp3354 = function (List__, p5want) {
				var v_fixity_type;
				v_fixity_type = (List__.shift());
				var v_op_name;
				v_op_name = (List__.shift());
				return ((v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget_hash(p5str(v_fixity_type))._hash_.p5hget(p5str(v_op_name)));
			};
			tmp3354._prototype_ = null;
			return tmp3354
		})());
		p5typeglob_set('Perlito5::Grammar::Precedence', 'is_term', (function () {
			var tmp3355;
			tmp3355 = function (List__, p5want) {
				var v_token;
				v_token = (List__.shift());
				return (p5or(p5context([(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) == 'term')], 0), function () {
							return p5or(p5context([(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) == 'postfix_or_term')], 0), function () {
								return p5context([(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) == 'postfix')], p5want)
							})
						}));
			};
			tmp3355._prototype_ = null;
			return tmp3355
		})());
		p5typeglob_set('Perlito5::Grammar::Precedence', 'is_num', (function () {
			var tmp3356;
			tmp3356 = function (List__, p5want) {
				return (p5and((p5str(List__.p5aget(0)) >= '0'), function () {
							return (p5str(List__.p5aget(0)) <= '9')
						}));
			};
			tmp3356._prototype_ = null;
			return tmp3356
		})());
		p5typeglob_set('Perlito5::Grammar::Precedence', 'is_ident_middle', (function () {
			var tmp3357;
			tmp3357 = function (List__, p5want) {
				var v_c;
				v_c = (List__.shift());
				return (p5or(p5context([p5and((p5str(v_c) >= 'a'), function () {
							return (p5str(v_c) <= 'z')
						})], 0), function () {
							return p5or(p5context([p5and((p5str(v_c) >= '0'), function () {
								return (p5str(v_c) <= '9')
							})], 0), function () {
								return p5context([(p5str(v_c) == '_')], p5want)
							})
						}));
			};
			tmp3357._prototype_ = null;
			return tmp3357
		})());
		var List_Parsed_op_chars = [];
		List_Parsed_op_chars = [2, 1];
		var Hash_Parsed_op = {};
		Hash_Parsed_op = p5a_to_h(['?', (function () {
					var tmp3363;
					tmp3363 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].term_ternary(p5list_to_a([p5list_slice(List__, [0], 1), p5list_slice(List__, [1], 1)]), p5want));
					};
					tmp3363._prototype_ = null;
					return tmp3363
				})(), '(', (function () {
					var tmp3364;
					tmp3364 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].term_paren(p5list_to_a([p5list_slice(List__, [0], 1), p5list_slice(List__, [1], 1)]), p5want));
					};
					tmp3364._prototype_ = null;
					return tmp3364
				})(), '[', (function () {
					var tmp3365;
					tmp3365 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].term_square(p5list_to_a([p5list_slice(List__, [0], 1), p5list_slice(List__, [1], 1)]), p5want));
					};
					tmp3365._prototype_ = null;
					return tmp3365
				})(), '{', (function () {
					var tmp3366;
					tmp3366 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].term_curly(p5list_to_a([p5list_slice(List__, [0], 1), p5list_slice(List__, [1], 1)]), p5want));
					};
					tmp3366._prototype_ = null;
					return tmp3366
				})(), '->', (function () {
					var tmp3367;
					tmp3367 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].term_arrow(p5list_to_a([p5list_slice(List__, [0], 1), p5list_slice(List__, [1], 1)]), p5want));
					};
					tmp3367._prototype_ = null;
					return tmp3367
				})()]);
		var List_Term_chars = [];
		var Hash_Term = {};
		p5typeglob_set('Perlito5::Grammar::Precedence', 'add_term', (function () {
			var tmp3368;
			tmp3368 = function (List__, p5want) {
				var v_name;
				v_name = (List__.shift());
				var v_param;
				v_param = (List__.shift());
				Hash_Term.p5hset(p5str(v_name), (v_param));
				(function () {
						p5while(function () {
							return (List_Term_chars.p5unshift([(p5num((List_Term_chars.length)) + 1)]));
						}, function () {
							return (p5num(List_Term_chars.length) < p5pkg['Perlito5::Grammar::Precedence'].length([v_name], 0))
						}, false, '', 0)
					})()
			};
			tmp3368._prototype_ = null;
			return tmp3368
		})());
		var v_End_token;
		var v_End_token_chars;
		var Hash_Op = {};
		var List_Op_chars = [];
		List_Op_chars = [3, 2, 1];
		p5typeglob_set('Perlito5::Grammar::Precedence', 'op_parse', (function () {
			var tmp3369;
			tmp3369 = function (List__, p5want) {
				try {
					var v_str;
					v_str = (List__.shift());
					var v_pos;
					v_pos = (List__.shift());
					var v_last_is_term;
					v_last_is_term = (List__.shift());
					(function () {
						var v_len;
						(function(){ var v_len; p5for_lex(function (v) { v_len = v }, function () {
								var v_term;
								v_term = (CORE.substr([v_str, v_pos, v_len], 0));
								(function () {
									if ( (v_End_token)._hash_.hasOwnProperty(v_term) ) {
									(function () {
										var v_c1;
										v_c1 = (p5str(v_str).substr(((p5num(v_pos) + p5num(v_len)) - 1), 1));
										var v_c2;
										v_c2 = (p5str(v_str).substr((p5num(v_pos) + p5num(v_len)), 1));
										(function () {
											if ( (!( (p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_ident_middle([v_c1], 0)) && p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_ident_middle([v_c2], 0)))) && !( ((p5str(v_c1) == '<') && (p5str(v_c2) == '<')))) ) {
											throw((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', v_pos, 'to', v_pos, 'capture', (new p5ArrayRef(['end', v_term]))])))));
										}
										})();
									})();
								}
								})();
							}, p5list_to_a([p5array_deref((v_End_token_chars || (v_End_token_chars = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence')]), false, '') })()
					})();
					(function () {
						if ( !( p5bool(v_last_is_term)) ) {
						(function () {
							var v_len;
							(function(){ var v_len; p5for_lex(function (v) { v_len = v }, function () {
									var v_term;
									v_term = (CORE.substr([v_str, v_pos, v_len], 0));
									(function () {
										if ( (Hash_Term).hasOwnProperty(v_term) ) {
										(function () {
											var v_c1;
											v_c1 = (p5str(v_str).substr(((p5num(v_pos) + p5num(v_len)) - 1), 1));
											var v_c2;
											v_c2 = (p5str(v_str).substr((p5num(v_pos) + p5num(v_len)), 1));
											(function () {
												if ( (p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_num([v_c1], 0)) || (!( p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_ident_middle([v_c1], 0))) || !( p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_ident_middle([v_c2], 0))))) ) {
												(function () {
													var v_m;
													v_m = ((Hash_Term.p5hget(p5str(v_term)))([v_str, v_pos], 0));
													p5and(v_m, function () {
														throw(p5context([v_m], p5want))
													});
												})();
											}
											})();
										})();
									}
									})();
								}, p5list_to_a([List_Term_chars]), false, '') })()
						})();
					}
					})();
					(function () {
						var v_len;
						(function(){ var v_len; p5for_lex(function (v) { v_len = v }, function () {
								var v_op;
								v_op = (CORE.substr([v_str, v_pos, v_len], 0));
								(function () {
									if ( (Hash_Parsed_op).hasOwnProperty(v_op) ) {
									(function () {
										var v_m;
										v_m = ((Hash_Parsed_op.p5hget(p5str(v_op)))([v_str, v_pos], 0));
										p5and(v_m, function () {
											throw(p5context([v_m], p5want))
										});
									})();
								}
								})();
							}, p5list_to_a([List_Parsed_op_chars]), false, '') })()
					})();
					(function () {
						var v_len;
						(function(){ var v_len; p5for_lex(function (v) { v_len = v }, function () {
								var v_op;
								v_op = (CORE.substr([v_str, v_pos, v_len], 0));
								(function () {
									if ( (Hash_Op).hasOwnProperty(v_op) ) {
									(function () {
										var v_c1;
										v_c1 = (p5str(v_str).substr(((p5num(v_pos) + p5num(v_len)) - 1), 1));
										var v_c2;
										v_c2 = (p5str(v_str).substr((p5num(v_pos) + p5num(v_len)), 1));
										(function () {
											if ( ((!( (p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_ident_middle([v_c1], 0)) && p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_ident_middle([v_c2], 0)))) && !( ((p5str(v_c1) == '&') && (p5str(v_c2) == '&')))) || ((p5str(v_c1) == 'x') && ((p5str(v_c2) >= '0') && (p5str(v_c2) <= '9')))) ) {
											(function () {
												if ( (((v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget('infix'))._hash_.hasOwnProperty(v_op) && (!( ((v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget('prefix'))._hash_.hasOwnProperty(v_op)) && !( p5bool(v_last_is_term)))) ) {}
											else {
												throw((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', v_pos, 'to', (p5num(v_pos) + p5num(v_len)), 'capture', (new p5ArrayRef(['op', v_op]))])))));
											}
											})();
										}
										})();
									})();
								}
								})();
							}, p5list_to_a([List_Op_chars]), false, '') })()
					})();
					return (p5call_sub('Perlito5::Grammar::Bareword', 'term_bareword', [v_str, v_pos], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3369._prototype_ = null;
			return tmp3369
		})());
		p5typeglob_set('Perlito5::Grammar::Precedence', 'add_op', (function () {
			var tmp3370;
			tmp3370 = function (List__, p5want) {
				var v_fixity;
				var v_names;
				var v_precedence;
				var v_param;
				var tmp3371 = p5list_to_a([List__]);
					v_fixity = tmp3371.shift();
					v_names = tmp3371.shift();
					v_precedence = tmp3371.shift();
					v_param = tmp3371.shift();
				(v_param = (p5defined_or(v_param, function () {
								return (new p5HashRef({}))
							})));
				var v_assoc;
				v_assoc = (p5or((v_param || (v_param = new p5HashRef({})))._hash_.p5hget('assoc'), function () {
								return 'left'
							}));
				(function () {
						var v_name;
						(function(){ var v_name; p5for_lex(function (v) { v_name = v }, function () {
								(v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget_hash(p5str(v_fixity))._hash_.p5hset(p5str(v_name), (1));
								(v_Precedence || (v_Precedence = new p5HashRef({})))._hash_.p5hset(p5str(v_name), (v_precedence));
								p5and((p5str(v_fixity) == 'prefix'), function () {
									return (v_PrefixPrecedence || (v_PrefixPrecedence = new p5HashRef({})))._hash_.p5hset(p5str(v_name), (v_precedence))
								});
								(v_Assoc || (v_Assoc = new p5HashRef({})))._hash_.p5hget_hash(p5str(v_assoc))._hash_.p5hset(p5str(v_name), (1));
								return (Hash_Op.p5hset(p5str(v_name), (1)));
							}, p5list_to_a([p5array_deref((v_names || (v_names = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence')]), false, '') })()
					})()
			};
			tmp3370._prototype_ = null;
			return tmp3370
		})());
		var v_prec;
		v_prec = (100);
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['postfix', (new p5ArrayRef(['.( )', '.[ ]', '.{ }', '( )', '[ ]', 'funcall', 'funcall_no_params', 'methcall', 'methcall_no_params', 'block', 'hash'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['prefix', (new p5ArrayRef(['++', '--'])), v_prec]), null);
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['postfix', (new p5ArrayRef(['++', '--'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['**'])), v_prec, (new p5HashRef({'assoc' : 'right'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['prefix', (new p5ArrayRef([String.fromCharCode(92), '+', '-', '~', '!'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['=~', '!~'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['*', '/', '%', 'x'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['+', '-'])), v_prec]), null);
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['.'])), v_prec, (new p5HashRef({'assoc' : 'list'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['<<', '>>'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['prefix', (new p5ArrayRef(['-r', '-w', '-x', '-o', '-R', '-W', '-X', '-O', '-e', '-z', '-s', '-f', '-d', '-l', '-p', '-S', '-b', '-c', '-t', '-u', '-g', '-k', '-T', '-B', '-M', '-A', '-C'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['lt', 'le', 'gt', 'ge', '<=', '>=', '<', '>'])), v_prec, (new p5HashRef({'assoc' : 'chain'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['<=>', 'cmp', '==', '!=', 'ne', 'eq'])), v_prec, (new p5HashRef({'assoc' : 'chain'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['&'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['|', '^'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['..', '...'])), v_prec]), null);
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['~~'])), v_prec, (new p5HashRef({'assoc' : 'chain'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['&&'])), v_prec, (new p5HashRef({'assoc' : 'right'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['||'])), v_prec, (new p5HashRef({'assoc' : 'right'}))]), null);
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['//'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['ternary', (new p5ArrayRef(['? :'])), v_prec, (new p5HashRef({'assoc' : 'right'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['=', '**=', '+=', '-=', '*=', '/=', 'x=', '|=', '&=', '.=', '<<=', '>>=', '%=', '||=', '&&=', '^=', '//='])), v_prec, (new p5HashRef({'assoc' : 'right'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['=>'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['list', (new p5ArrayRef([','])), v_prec, (new p5HashRef({'assoc' : 'list'}))]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['prefix', (new p5ArrayRef(['not'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['and'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['or', 'xor'])), v_prec]), null);
		v_prec = ((p5num(v_prec) - 1));
		p5pkg['Perlito5::Grammar::Precedence'].add_op(p5list_to_a(['infix', (new p5ArrayRef(['*start*'])), v_prec]), null);
		p5typeglob_set('Perlito5::Grammar::Precedence', 'get_token_precedence', (function () {
			var tmp3372;
			tmp3372 = function (List__, p5want) {
				try {
					var v_token;
					v_token = (List__.p5aget(0));
					(function () {
						if ( (p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) == 'prefix') ) {
						throw((v_PrefixPrecedence || (v_PrefixPrecedence = new p5HashRef({})))._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1))));
					}
					})();
					return ((v_Precedence || (v_Precedence = new p5HashRef({})))._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1))));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3372._prototype_ = null;
			return tmp3372
		})());
		p5typeglob_set('Perlito5::Grammar::Precedence', 'precedence_parse', (function () {
			var tmp3373;
			tmp3373 = function (List__, p5want) {
				var v_self;
				v_self = (List__.shift());
				var v_get_token;
				v_get_token = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('get_token'));
				var v_reduce;
				v_reduce = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('reduce'));
				var v_last_end_token;
				v_last_end_token = (v_End_token);
				var v_last_end_token_chars;
				v_last_end_token_chars = (v_End_token_chars);
				v_End_token = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('end_token'));
				v_End_token_chars = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('end_token_chars'));
				var v_op_stack;
				v_op_stack = ((new p5ArrayRef([])));
				var v_num_stack;
				v_num_stack = ((new p5ArrayRef([])));
				var v_last;
				v_last = ((new p5ArrayRef(['op', '*start*'])));
				var v_last_is_term;
				v_last_is_term = (0);
				var v_token;
				v_token = ((v_get_token)([v_last_is_term], 0));
				(function () {
						if ( (p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) == 'space') ) {
						v_token = ((v_get_token)([v_last_is_term], 0));
					}
					})();
				(function () {
						p5while(function () {
							var v_token_is_term;
							v_token_is_term = (p5pkg['Perlito5::Grammar::Precedence'].is_term([v_token], 0));
							(function () {
								if ( ((p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1)) == ',') && ((p5str((v_last || (v_last = new p5ArrayRef([])))._array_.p5aget(1)) == '*start*') || (p5str((v_last || (v_last = new p5ArrayRef([])))._array_.p5aget(1)) == ','))) ) {
								p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence').p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['term', null])))]));
							}
							})();
							(function () {
								if ( (p5bool((v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget_hash('prefix')._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1)))) && ((p5str((v_last || (v_last = new p5ArrayRef([])))._array_.p5aget(1)) == '*start*') || !( p5bool(v_last_is_term)))) ) {
								(v_token || (v_token = new p5ArrayRef([])))._array_.p5aset(0, ('prefix'));
								p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence').p5unshift([v_token]);
							}
							else (function () {
								if ( (p5bool((v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget_hash('postfix')._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1)))) && p5bool(v_last_is_term)) ) {
								(function () {
									var v_pr;
									v_pr = ((v_Precedence || (v_Precedence = new p5HashRef({})))._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1))));
									(function () {
										p5while(function () {
											(v_reduce)([v_op_stack, v_num_stack], null);
										}, function () {
											return p5and((p5num(p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence'))), function () {
												return p5context([(p5num(v_pr) <= p5num(p5pkg['Perlito5::Grammar::Precedence'].get_token_precedence(p5list_to_a([(v_op_stack || (v_op_stack = new p5ArrayRef([])))._array_.p5aget(0)]), 0)))], 0)
											})
										}, false, '', 0)
									})();
									(function () {
										if ( (p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) != 'postfix_or_term') ) {
										(v_token || (v_token = new p5ArrayRef([])))._array_.p5aset(0, ('postfix'));
									}
									})();
									p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence').p5unshift([v_token]);
									v_token_is_term = (1);
								})();
							}
							else (function () {
								if ( p5bool(v_token_is_term) ) {
								(function () {
									if ( p5bool(v_last_is_term) ) {
									p5pkg["Perlito5::IO"].print("STDOUT", p5list_to_a(['#      last:  ', p5pkg['Data::Dumper'].Dumper([v_last], 1)]));
									p5pkg["Perlito5::IO"].print("STDOUT", p5list_to_a(['#      token: ', p5pkg['Data::Dumper'].Dumper([v_token], 1)]));
									p5pkg['Perlito5::Grammar::Precedence'].die([].concat(['Value tokens must be separated by an operator']), null);
								}
								})();
								(v_token || (v_token = new p5ArrayRef([])))._array_.p5aset(0, ('term'));
								p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence').p5push([v_token]);
							}
							else (function () {
								if ( p5bool((v_Precedence || (v_Precedence = new p5HashRef({})))._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1)))) ) {
								(function () {
									var v_pr;
									v_pr = ((v_Precedence || (v_Precedence = new p5HashRef({})))._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1))));
									(function () {
										if ( p5bool((v_Assoc || (v_Assoc = new p5HashRef({})))._hash_.p5hget_hash('right')._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1)))) ) {
										(function () {
											p5while(function () {
												(v_reduce)([v_op_stack, v_num_stack], null);
											}, function () {
												return p5and((p5num(p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence'))), function () {
													return p5context([(p5num(v_pr) < p5num(p5pkg['Perlito5::Grammar::Precedence'].get_token_precedence(p5list_to_a([(v_op_stack || (v_op_stack = new p5ArrayRef([])))._array_.p5aget(0)]), 0)))], 0)
												})
											}, false, '', 0)
										})();
									}
									else {
										(function () {
											p5while(function () {
												(v_reduce)([v_op_stack, v_num_stack], null);
											}, function () {
												return p5and((p5num(p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence'))), function () {
													return p5context([(p5num(v_pr) <= p5num(p5pkg['Perlito5::Grammar::Precedence'].get_token_precedence(p5list_to_a([(v_op_stack || (v_op_stack = new p5ArrayRef([])))._array_.p5aget(0)]), 0)))], 0)
												})
											}, false, '', 0)
										})();
									}
									})();
									(function () {
										if ( p5bool((v_Operator || (v_Operator = new p5HashRef({})))._hash_.p5hget_hash('ternary')._hash_.p5hget(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1)))) ) {
										(v_token || (v_token = new p5ArrayRef([])))._array_.p5aset(0, ('ternary'));
									}
									else {
										(v_token || (v_token = new p5ArrayRef([])))._array_.p5aset(0, ('infix'));
									}
									})();
									p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence').p5unshift([v_token]);
								})();
							}
							else {
								p5pkg['Perlito5::Grammar::Precedence'].die([].concat(p5list_to_a(['Unknown token: ' + String.fromCharCode(39), (v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(1), String.fromCharCode(39)])), null);
							}
							})()
							})()
							})()
							})();
							v_last = (v_token);
							v_last_is_term = (v_token_is_term);
							v_token = ((v_get_token)([v_last_is_term], 0));
							(function () {
								if ( (p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) == 'space') ) {
								v_token = ((v_get_token)([v_last_is_term], 0));
							}
							})();
						}, function () {
							return p5and(p5context([(v_token != null)], 0), function () {
								return p5context([(p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) != 'end')], 0)
							})
						}, false, '', 0)
					})();
				(function () {
						if ( ((v_token != null) && (p5str((v_token || (v_token = new p5ArrayRef([])))._array_.p5aget(0)) != 'end')) ) {
						p5pkg['Perlito5::Grammar::Precedence'].die([].concat(['Unexpected end token: ', v_token]), null);
					}
					})();
				(function () {
						p5while(function () {
							(v_reduce)([v_op_stack, v_num_stack], null);
						}, function () {
							return (p5num(p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Precedence')))
						}, false, '', 0)
					})();
				v_End_token = (v_last_end_token);
				v_End_token_chars = (v_last_end_token_chars);
				return (p5context([v_num_stack], p5want));
			};
			tmp3373._prototype_ = null;
			return tmp3373
		})());
		1;
	})();
	(function () {
		p5block(function (v) {}, function () {
				p5make_package('main');
				p5make_package('Perlito5::Grammar::Expression');
				// use Perlito5::Grammar::Precedence
;
				// use Perlito5::Grammar::Bareword
;
				// use Perlito5::Grammar::Attribute
;
				// use Perlito5::Grammar::Statement
;
				p5typeglob_set('Perlito5::Grammar::Expression', 'expand_list', (function () {
					var tmp3374;
					tmp3374 = function (List__, p5want) {
						try {
							var v_param_list;
							v_param_list = (List__.shift());
							return (function () {
								if ( ((p5pkg['Perlito5::Grammar::Expression'].ref([v_param_list], 0) == 'Perlito5::AST::Apply') && (p5str(p5call(v_param_list, 'code', [], 0)) == 'list:<,>')) ) {
								(function () {
									throw((new p5ArrayRef(p5list_to_a([p5grep(p5pkg['Perlito5::Grammar::Expression'], function (p5want) {
	return ((p5make_package('main')['v__'] != null));
}, p5list_to_a([p5array_deref(p5call(v_param_list, 'arguments', [], p5want), 'Perlito5::Grammar::Expression')]))]))))
								})()
							}
							else return (function () {
								if ( (p5str(v_param_list) == '*undef*') ) {
								(function () {
									throw((new p5ArrayRef([])))
								})()
							}
							else {
								(function () {
									throw((new p5ArrayRef([v_param_list])))
								})()
							}
							})()
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3374._prototype_ = null;
					return tmp3374
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'block_or_hash', (function () {
					var tmp3375;
					tmp3375 = function (List__, p5want) {
						try {
							var v_o;
							v_o = (List__.shift());
							(function () {
								if ( (p5call(v_o, 'sig', [], 0) != null) ) {
								throw(p5context([v_o], p5want));
							}
							})();
							var v_stmts;
							v_stmts = (p5call(v_o, 'stmts', [], 0));
							(function () {
								if ( (!( (v_stmts != null)) || (p5num((p5num(p5array_deref((v_stmts || (v_stmts = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) == 0)) ) {
								throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'circumfix:<{ }>', 'namespace', '', 'arguments', (new p5ArrayRef([]))]), p5want));
							}
							})();
							(function () {
								if ( (p5num((p5num(p5array_deref((v_stmts || (v_stmts = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) != 1) ) {
								throw(p5context([v_o], p5want));
							}
							})();
							var v_stmt;
							v_stmt = ((v_stmts || (v_stmts = new p5ArrayRef([])))._array_.p5aget(0));
							(function () {
								if ( (p5pkg['Perlito5::Grammar::Expression'].ref([v_stmt], 0) == 'Perlito5::AST::Var') ) {
								throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'circumfix:<{ }>', 'namespace', '', 'arguments', (new p5ArrayRef([v_stmt]))]), p5want));
							}
							})();
							(function () {
								if ( (p5pkg['Perlito5::Grammar::Expression'].ref([v_stmt], 0) != 'Perlito5::AST::Apply') ) {
								throw(p5context([v_o], p5want));
							}
							})();
							(function () {
								if ( ((p5str(p5call(v_stmt, 'code', [], 0)) == 'infix:<=>>') || ((p5str(p5call(v_stmt, 'code', [], 0)) == 'prefix:<%>') || (p5str(p5call(v_stmt, 'code', [], 0)) == 'prefix:<@>'))) ) {
								throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'circumfix:<{ }>', 'namespace', '', 'arguments', (new p5ArrayRef([v_stmt]))]), p5want));
							}
							})();
							(function () {
								if ( (p5str(p5call(v_stmt, 'code', [], 0)) != 'list:<,>') ) {
								throw(p5context([v_o], p5want));
							}
							})();
							return (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'circumfix:<{ }>', 'namespace', '', 'arguments', p5pkg['Perlito5::Grammar::Expression'].expand_list([v_stmt], 1)]), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3375._prototype_ = null;
					return tmp3375
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'pop_term', (function () {
					var tmp3376;
					tmp3376 = function (List__, p5want) {
						try {
							var v_num_stack;
							v_num_stack = (List__.shift());
							var v_v;
							v_v = (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').pop());
							(function () {
								if ( (p5pkg['Perlito5::Grammar::Expression'].ref([v_v], 0) == 'ARRAY') ) {
								p5and(p5pkg['Perlito5::Grammar::Expression'].ref([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)], 0), function () {
									throw((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1))
								});
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'methcall_no_params') ) {
									v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', null, 'method', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2), 'arguments', (new p5ArrayRef([]))]), 0));
									throw(p5context([v_v], p5want));
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'funcall_no_params') ) {
									v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(3), 'namespace', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2), 'arguments', (new p5ArrayRef([])), 'bareword', 1]), 0));
									throw(p5context([v_v], p5want));
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'methcall') ) {
									(function () {
										var v_param_list;
										v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(3)]), 0));
										v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', null, 'method', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2), 'arguments', v_param_list]), 0));
										throw(p5context([v_v], p5want));
									})();
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'funcall') ) {
									(function () {
										var v_param_list;
										v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(4)]), 0));
										v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(3), 'arguments', v_param_list, 'namespace', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
										throw(p5context([v_v], p5want));
									})();
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '( )') ) {
									(function () {
										var v_param_list;
										v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
										v_v = (p5call('Perlito5::AST::Apply', 'new', ['code', 'circumfix:<( )>', 'arguments', v_param_list, 'namespace', ''], 0));
										throw(p5context([v_v], p5want));
									})();
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '[ ]') ) {
									(function () {
										var v_param_list;
										v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
										v_v = (p5call('Perlito5::AST::Apply', 'new', ['code', 'circumfix:<[ ]>', 'arguments', v_param_list, 'namespace', ''], 0));
										throw(p5context([v_v], p5want));
									})();
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'block') ) {
									v_v = (p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2), 'sig', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(3)]), 0));
									v_v = (p5pkg['Perlito5::Grammar::Expression'].block_or_hash([v_v], 0));
									throw(p5context([v_v], p5want));
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '.( )') ) {
									v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', null, 'method', 'postcircumfix:<( )>', 'arguments', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
									throw(p5context([v_v], p5want));
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '.[ ]') ) {
									v_v = (p5call('Perlito5::AST::Index', 'new', p5list_to_a(['obj', null, 'index_exp', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
									throw(p5context([v_v], p5want));
								}
								})();
								(function () {
									if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '.{ }') ) {
									v_v = (p5call('Perlito5::AST::Lookup', 'new', p5list_to_a(['obj', null, 'index_exp', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
									throw(p5context([v_v], p5want));
								}
								})();
								throw((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1));
							}
							})();
							return (p5context([v_v], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3376._prototype_ = null;
					return tmp3376
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'reduce_postfix', (function () {
					var tmp3377;
					tmp3377 = function (List__, p5want) {
						try {
							var v_op;
							v_op = (List__.shift());
							var v_value;
							v_value = (List__.shift());
							var v_v;
							v_v = (v_op);
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'methcall_no_params') ) {
								v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', v_value, 'method', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2), 'arguments', (new p5ArrayRef([]))]), 0));
								throw(p5context([v_v], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'funcall_no_params') ) {
								p5pkg['Perlito5::Grammar::Expression'].die([].concat(['Bareword found where operator expected']), null);
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'methcall') ) {
								(function () {
									var v_param_list;
									v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(3)]), 0));
									v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', v_value, 'method', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2), 'arguments', v_param_list]), 0));
									throw(p5context([v_v], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'funcall') ) {
								p5pkg['Perlito5::Grammar::Expression'].die([].concat(['unexpected function call']), null);
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '( )') ) {
								(function () {
									var v_param_list;
									v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
									(function () {
										if ( ((p5pkg['Perlito5::Grammar::Expression'].ref([v_value], 0) == 'Perlito5::AST::Apply') && !( (p5call(v_value, 'arguments', [], 0) != null))) ) {
										(v_value || (v_value = new p5HashRef({})))._hash_.p5hset('arguments', (v_param_list));
										throw(p5context([v_value], p5want));
									}
									})();
									(function () {
										if ( ((p5pkg['Perlito5::Grammar::Expression'].ref([v_value], 0) == 'Perlito5::AST::Call') && !( (p5call(v_value, 'arguments', [], 0) != null))) ) {
										(v_value || (v_value = new p5HashRef({})))._hash_.p5hset('arguments', (v_param_list));
										throw(p5context([v_value], p5want));
									}
									})();
									v_v = (p5call('Perlito5::AST::Call', 'new', ['invocant', v_value, 'method', 'postcircumfix:<( )>', 'arguments', v_param_list], 0));
									throw(p5context([v_v], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '[ ]') ) {
								(function () {
									if ( (p5pkg['Perlito5::Grammar::Expression'].ref([v_value], 0) == 'Perlito5::AST::Var') ) {
									(v_value || (v_value = new p5HashRef({})))._hash_.p5hset('_real_sigil', ('@'));
								}
								})();
								v_v = (p5call('Perlito5::AST::Index', 'new', p5list_to_a(['obj', v_value, 'index_exp', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
								throw(p5context([v_v], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == 'block') ) {
								(function () {
									if ( (p5pkg['Perlito5::Grammar::Expression'].ref([v_value], 0) == 'Perlito5::AST::Var') ) {
									(v_value || (v_value = new p5HashRef({})))._hash_.p5hset('_real_sigil', ('%'));
								}
								})();
								v_v = (p5call('Perlito5::AST::Lookup', 'new', p5list_to_a(['obj', v_value, 'index_exp', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget_array(2)._array_.p5aget(0)]), 0));
								throw(p5context([v_v], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '.( )') ) {
								(function () {
									var v_param_list;
									v_param_list = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([(v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
									v_v = (p5call('Perlito5::AST::Call', 'new', ['invocant', v_value, 'method', 'postcircumfix:<( )>', 'arguments', v_param_list], 0));
									throw(p5context([v_v], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '.[ ]') ) {
								v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', v_value, 'method', 'postcircumfix:<[ ]>', 'arguments', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
								throw(p5context([v_v], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)) == '.{ }') ) {
								v_v = (p5call('Perlito5::AST::Call', 'new', p5list_to_a(['invocant', v_value, 'method', 'postcircumfix:<{ }>', 'arguments', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(2)]), 0));
								throw(p5context([v_v], p5want));
							}
							})();
							p5array_deref((v_op || (v_op = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push([v_value]);
							return (p5context([v_op], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3377._prototype_ = null;
					return tmp3377
				})());
				var v_reduce_to_ast;
				v_reduce_to_ast = ((function () {
							var tmp3378;
							tmp3378 = function (List__, p5want) {
								try {
									var v_op_stack;
									v_op_stack = (List__.shift());
									var v_num_stack;
									v_num_stack = (List__.shift());
									var v_last_op;
									v_last_op = (p5array_deref((v_op_stack || (v_op_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').shift());
									return (function () {
										if ( (p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(0)) == 'prefix') ) {
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', '', 'code', ('prefix:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1)])))]), 1)])));
									}
									else return (function () {
										if ( (p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(0)) == 'postfix') ) {
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', '', 'code', ('postfix:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1)])))]), 1)])));
									}
									else return (function () {
										if ( (p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(0)) == 'postfix_or_term') ) {
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].reduce_postfix(p5list_to_a([v_last_op, p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1)]), 1)])));
									}
									else return (function () {
										if ( p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_assoc_type(p5list_to_a(['list', (v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)]), 0)) ) {
										var v_arg;
										(function () {
											if ( (p5num((p5num(p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) < 2) ) {
											(function () {
												var v_v2;
												v_v2 = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 0));
												(function () {
													if ( ((p5pkg['Perlito5::Grammar::Expression'].ref([v_v2], 0) == 'Perlito5::AST::Apply') && (p5str(p5call(v_v2, 'code', [], 0)) == ('list:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'))) ) {
													p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', p5call(v_v2, 'namespace', [], 1), 'code', p5call(v_v2, 'code', [], 1), 'arguments', (new p5ArrayRef(p5list_to_a([p5array_deref(p5call(v_v2, 'arguments', [], p5want), 'Perlito5::Grammar::Expression')])))]), 1)]));
												}
												else {
													p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', '', 'code', ('list:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', (new p5ArrayRef([v_v2]))]), 1)]));
												}
												})();
												throw(p5context([], p5want));
											})();
										}
										else {
											(function () {
												var v_v2;
												v_v2 = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 0));
												v_arg = ((new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1), v_v2]))));
											})();
										}
										})();
										(function () {
											if ( ((p5pkg['Perlito5::Grammar::Expression'].ref([(v_arg || (v_arg = new p5ArrayRef([])))._array_.p5aget(0)], 0) == 'Perlito5::AST::Apply') && ((p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(0)) == 'infix') && (p5str(p5call((v_arg || (v_arg = new p5ArrayRef([])))._array_.p5aget(0), 'code', [], 0)) == ('list:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>')))) ) {
											p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', '', 'code', p5call(p5context([(v_arg || (v_arg = new p5ArrayRef([])))._array_.p5aget(0)], 0), 'code', [], 1), 'arguments', (new p5ArrayRef(p5list_to_a([p5array_deref(p5call(p5context([(v_arg || (v_arg = new p5ArrayRef([])))._array_.p5aget(0)], 0), 'arguments', [], p5want), 'Perlito5::Grammar::Expression'), (v_arg || (v_arg = new p5ArrayRef([])))._array_.p5aget(1)])))]), 1)]));
											throw(p5context([], p5want));
										}
										})();
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', ['namespace', '', 'code', ('list:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', v_arg], 1)])));
									}
									else return (function () {
										if ( p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_assoc_type(p5list_to_a(['chain', (v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)]), 0)) ) {
										(function () {
											if ( (p5num((p5num(p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) < 2) ) {
											p5pkg['Perlito5::Grammar::Expression'].die([].concat([('Missing value after operator ' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)))]), null);
										}
										})();
										var v_v2;
										v_v2 = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 0));
										var v_arg;
										v_arg = ((new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1), v_v2]))));
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', ['namespace', '', 'code', ('infix:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', v_arg], 1)])));
									}
									else return (function () {
										if ( (p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(0)) == 'ternary') ) {
										(function () {
											if ( (p5num((p5num(p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) < 2) ) {
											p5pkg['Perlito5::Grammar::Expression'].die([].concat(['Missing value after ternary operator']), null);
										}
										})();
										var v_v2;
										v_v2 = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 0));
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', '', 'code', ('ternary:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1), (v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(2), v_v2])))]), 1)])));
									}
									else {
										(function () {
											if ( (p5num((p5num(p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) < 2) ) {
											p5pkg['Perlito5::Grammar::Expression'].die([].concat([('missing value after operator ' + p5pkg['Perlito5::Grammar::Expression'].chr([39], 0) + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + p5pkg['Perlito5::Grammar::Expression'].chr([39], 0))]), null);
										}
										})();
										var v_v2;
										v_v2 = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 0));
										return (p5array_deref((v_num_stack || (v_num_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').p5push(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['namespace', '', 'code', ('infix:<' + p5str((v_last_op || (v_last_op = new p5ArrayRef([])))._array_.p5aget(1)) + '>'), 'arguments', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Grammar::Expression'].pop_term([v_num_stack], 1), v_v2])))]), 1)])));
									}
									})()
									})()
									})()
									})()
									})()
									})()
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3378._prototype_ = null;
							return tmp3378
						})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_arrow', (function () {
					var tmp3379;
					tmp3379 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('->' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5context([(function () {
												var v_pos1;
												v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
												return ((p5or(p5context([(function () {
														return ((p5context([p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0), function () {
																return p5and(p5context([(function () {
																	var v_m2;
																	v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																	return (function () {
																		if ( p5bool(v_m2) ) {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('paren_parse', (v_m2));
																		return ((1));
																	}
																	else {
																		return ((0));
																	}
																	})()
																})()], 0), function () {
																	return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', '.( )', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('paren_parse')]), 1)])))));
																			return ((1));
																		})()], 0)
																	})
																})
															})], 0)));
													})()], 0), function () {
														return p5or(p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
															return ((p5context([p5and(p5context([p5and(('[' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																	return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																})], 0), function () {
																	return p5and(p5context([(function () {
																		var v_m2;
																		v_m2 = (p5pkg['Perlito5::Grammar::Expression'].square_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																		return (function () {
																			if ( p5bool(v_m2) ) {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('square_parse', (v_m2));
																			return ((1));
																		}
																		else {
																			return ((0));
																		}
																		})()
																	})()], 0), function () {
																		return p5and(p5context([p5and((']' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5context([(function () {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', '.[ ]', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('square_parse')]), 1)])))));
																				return ((1));
																			})()], 0)
																		})
																	})
																})], 0)));
														})()], 0), function () {
															return p5or(p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([p5and(p5context([p5and(('{' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5and(p5context([(function () {
																			var v_m2;
																			v_m2 = (p5pkg['Perlito5::Grammar::Expression'].curly_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																			return (function () {
																				if ( p5bool(v_m2) ) {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('curly_parse', (v_m2));
																				return ((1));
																			}
																			else {
																				return ((0));
																			}
																			})()
																		})()], 0), function () {
																			return p5and(p5context([(function () {
																				var v_pos1;
																				v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																				return ((p5or(p5context([(function () {
																						return ((p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																								return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																							})], 0)));
																					})()], 0), function () {
																						return p5context([(function () {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																							return ((p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																									p5pkg['Perlito5::Grammar::Expression'].die([].concat(['Missing right curly or square bracket']), null);
																									return ((1));
																								})()], 0)));
																						})()], 0)
																					})));
																			})()], 0), function () {
																				return p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', '.{ }', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('curly_parse')]), 1)])))));
																					return ((1));
																				})()], 0)
																			})
																		})
																	})], 0)));
															})()], 0), function () {
																return p5or(p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																	return ((p5context([p5and(p5context([p5and(('$' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::ident', (v_m2));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5and(p5context([(function () {
																					var v_m2;
																					v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																					return (function () {
																						if ( p5bool(v_m2) ) {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																						return ((1));
																					}
																					else {
																						return ((0));
																					}
																					})()
																				})()], 0), function () {
																					return p5context([(function () {
																						var v_pos1;
																						v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																						return ((p5or(p5context([(function () {
																								return ((p5context([p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																									})], 0), function () {
																										return p5and(p5context([(function () {
																											var v_m2;
																											v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																											return (function () {
																												if ( p5bool(v_m2) ) {
																												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('paren_parse', (v_m2));
																												return ((1));
																											}
																											else {
																												return ((0));
																											}
																											})()
																										})()], 0), function () {
																											return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																											})], 0), function () {
																												return p5context([(function () {
																													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', 'methcall', p5call('Perlito5::AST::Var', 'new', p5list_to_a(['sigil', '$', 'namespace', '', 'name', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::ident')]), 1)]), 1), p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('paren_parse')]), 1)])))));
																													return ((1));
																												})()], 0)
																											})
																										})
																									})], 0)));
																							})()], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																									return ((p5context([(function () {
																											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', 'methcall_no_params', p5call('Perlito5::AST::Var', 'new', p5list_to_a(['sigil', '$', 'namespace', '', 'name', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::ident')]), 1)]), 1)])))));
																											return ((1));
																										})()], 0)));
																								})()], 0)
																							})));
																					})()], 0)
																				})
																			})
																		})], 0)));
																})()], 0), function () {
																	return p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																		return ((p5context([p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5pkg['Perlito5::Grammar'].full_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::full_ident', (v_m2));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5and(p5context([(function () {
																					var v_m2;
																					v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																					return (function () {
																						if ( p5bool(v_m2) ) {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																						return ((1));
																					}
																					else {
																						return ((0));
																					}
																					})()
																				})()], 0), function () {
																					return p5context([(function () {
																						var v_pos1;
																						v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																						return ((p5or(p5context([(function () {
																								return ((p5context([p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																									})], 0), function () {
																										return p5and(p5context([(function () {
																											var v_m2;
																											v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																											return (function () {
																												if ( p5bool(v_m2) ) {
																												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('paren_parse', (v_m2));
																												return ((1));
																											}
																											else {
																												return ((0));
																											}
																											})()
																										})()], 0), function () {
																											return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																											})], 0), function () {
																												return p5context([(function () {
																													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', 'methcall', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::full_ident')]), 1), p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('paren_parse')]), 1)])))));
																													return ((1));
																												})()], 0)
																											})
																										})
																									})], 0)));
																							})()], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																									return ((p5context([(function () {
																											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', 'methcall_no_params', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::full_ident')]), 1)])))));
																											return ((1));
																										})()], 0)));
																								})()], 0)
																							})));
																					})()], 0)
																				})
																			})], 0)));
																	})()], 0)
																})
															})
														})
													})));
											})()], 0)
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3379._prototype_ = null;
					return tmp3379
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_ternary', (function () {
					var tmp3380;
					tmp3380 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('?' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar::Expression'].ternary5_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('ternary5_parse', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([p5and((':' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
											})], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['op', '? :', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('ternary5_parse')]), 1)])))));
													return ((1));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3380._prototype_ = null;
					return tmp3380
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_paren', (function () {
					var tmp3381;
					tmp3381 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('paren_parse', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
											})], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', '( )', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('paren_parse')]), 1)])))));
													return ((1));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3381._prototype_ = null;
					return tmp3381
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_square', (function () {
					var tmp3382;
					tmp3382 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('[' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar::Expression'].square_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('square_parse', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([p5and((']' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
											})], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', '[ ]', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('square_parse')]), 1)])))));
													return ((1));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3382._prototype_ = null;
					return tmp3382
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_curly', (function () {
					var tmp3383;
					tmp3383 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('{' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m;
											v_m = (v_MATCH);
											(function () {
												if ( !( p5bool((function () {
													var v_m2;
													v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})())) ) {
												v_MATCH = (v_m);
											}
											})();
											return ((1));
										})()], 0), function () {
											return p5context([(function () {
												var v_pos1;
												v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
												return ((p5or(p5context([(function () {
														return ((p5context([p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::ident', (v_m2));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5and(p5context([(function () {
																	var v_m;
																	v_m = (v_MATCH);
																	(function () {
																		if ( !( p5bool((function () {
																			var v_m2;
																			v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																			return (function () {
																				if ( p5bool(v_m2) ) {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																				return ((1));
																			}
																			else {
																				return ((0));
																			}
																			})()
																		})())) ) {
																		v_MATCH = (v_m);
																	}
																	})();
																	return ((1));
																})()], 0), function () {
																	return p5and(p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', 'block', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['arguments', (new p5ArrayRef([])), 'bareword', 1, 'code', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::ident')]), 1), 'namespace', '']), 1)])))])))));
																			return ((1));
																		})()], 0)
																	})
																})
															})], 0)));
													})()], 0), function () {
														return p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
															return ((p5context([p5and(p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('_save_scope', ((new p5ArrayRef(p5list_to_a([p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT']])))));
																	p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = [];
																	return ((1));
																})()], 0), function () {
																	return p5and(p5context([(function () {
																		var v_m2;
																		v_m2 = (p5pkg['Perlito5::Grammar'].exp_stmts(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																		return (function () {
																			if ( p5bool(v_m2) ) {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::exp_stmts', (v_m2));
																			return ((1));
																		}
																		else {
																			return ((0));
																		}
																		})()
																	})()], 0), function () {
																		return p5and(p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = p5list_to_a([p5array_deref((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_array('_save_scope'), 'Perlito5::Grammar::Expression')]);
																			return ((1));
																		})()], 0), function () {
																			return p5and(p5context([(function () {
																				var v_m;
																				v_m = (v_MATCH);
																				(function () {
																					if ( !( p5bool((function () {
																						var v_m2;
																						v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})())) ) {
																					v_MATCH = (v_m);
																				}
																				})();
																				return ((1));
																			})()], 0), function () {
																				return p5and(p5context([(function () {
																					var v_pos1;
																					v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																					return ((p5or(p5context([(function () {
																							return ((p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																									return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																								})], 0)));
																						})()], 0), function () {
																							return p5context([(function () {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																								return ((p5context([(function () {
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																										p5pkg['Perlito5::Grammar::Expression'].die([].concat(['Missing right curly or square bracket']), null);
																										return ((1));
																									})()], 0)));
																							})()], 0)
																						})));
																				})()], 0), function () {
																					return p5context([(function () {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['postfix_or_term', 'block', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::exp_stmts')]), 1)])))));
																						return ((1));
																					})()], 0)
																				})
																			})
																		})
																	})
																})], 0)));
														})()], 0)
													})));
											})()], 0)
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3383._prototype_ = null;
					return tmp3383
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'declarator', (function () {
					var tmp3384;
					tmp3384 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(('my' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 2)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((2 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0)));
											})()], 0), function () {
												return p5or(p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([p5and(('state' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 5)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((5 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0)));
												})()], 0), function () {
													return p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
														return ((p5context([p5and(('our' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 3)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((3 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0)));
													})()], 0)
												})
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3384._prototype_ = null;
					return tmp3384
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_declarator', (function () {
					var tmp3385;
					tmp3385 = function (List__, p5want) {
						try {
							var v_str;
							v_str = (List__.p5aget(0));
							var v_pos;
							v_pos = (List__.p5aget(1));
							var v_MATCH;
							v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
							var v_tmp;
							v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar::Expression'].declarator(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('declarator', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5and(p5context([(function () {
											var v_pos1;
											v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
											return ((p5or(p5context([(function () {
													return ((p5context([p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5context([(function () {
																var v_pos1;
																v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																return ((p5or(p5context([(function () {
																		return ((p5context([p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5call_sub('Perlito5::Grammar::Block', 'named_sub', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Block::named_sub', (v_m2));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																					var v_sub;
																					v_sub = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('Perlito5::Grammar::Block::named_sub')._hash_.p5hget('capture'));
																					(v_sub || (v_sub = new p5HashRef({})))._hash_.p5hset('decl', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('declarator')]), 0)));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(['term', v_sub]))));
																					throw(p5context([v_MATCH], p5want));
																					return ((1));
																				})()], 0)
																			})], 0)));
																	})()], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																			return ((p5context([(function () {
																					var v_m2;
																					v_m2 = (p5pkg['Perlito5::Grammar'].opt_type(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																					return (function () {
																						if ( p5bool(v_m2) ) {
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																						(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::opt_type', (v_m2));
																						return ((1));
																					}
																					else {
																						return ((0));
																					}
																					})()
																				})()], 0)));
																		})()], 0)
																	})));
															})()], 0)
														})], 0)));
												})()], 0), function () {
													return p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
														return ((1));
													})()], 0)
												})));
										})()], 0), function () {
											return p5and(p5context([(function () {
												var v_m2;
												v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
												return (function () {
													if ( p5bool(v_m2) ) {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
													return ((1));
												}
												else {
													return ((0));
												}
												})()
											})()], 0), function () {
												return p5and(p5context([(function () {
													var v_m2;
													v_m2 = (p5pkg['Perlito5::Grammar'].var_ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::var_ident', (v_m2));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})()], 0), function () {
													return p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5call_sub('Perlito5::Grammar::Attribute', 'opt_attribute', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Attribute::opt_attribute', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
															var v_declarator;
															v_declarator = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('declarator')]), 0));
															var v_type;
															v_type = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::opt_type')]), 0));
															p5and(v_type, function () {
																return p5and(!( p5bool((p5make_package('Perlito5')['v_PACKAGES'] || (p5make_package('Perlito5')['v_PACKAGES'] = new p5HashRef({})))._hash_.p5hget(p5str(v_type)))), function () {
																	return p5pkg['Perlito5::Grammar::Expression'].die([].concat([('No such class ' + p5str(v_type))]), null)
																})
															});
															var v_var;
															v_var = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget_hash('Perlito5::Grammar::var_ident')._hash_.p5hget('capture'));
															p5and((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
																return p5pkg['Perlito5::Grammar::Expression'].die([].concat([('No package name allowed for variable ' + p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('sigil')) + p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')) + ' in "' + p5str(v_declarator) + '"')]), null)
															});
															(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_decl', (v_declarator));
															(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_id', ((function () {
																		var tmp3386 = p5make_package('Perlito5')['v_ID'];
																		p5make_package('Perlito5')['v_ID'] = p5incr_(tmp3386);
																		return tmp3386
																	})()));
															p5and((p5str(v_declarator) == 'our'), function () {
																return p5context([(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_namespace', (p5make_package('Perlito5')['v_PKG_NAME']))], 0)
															});
															var v_decl;
															v_decl = (p5call('Perlito5::AST::Decl', 'new', p5list_to_a(['decl', v_declarator, 'type', v_type, 'var', v_var, 'attributes', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Attribute::opt_attribute')]), 1)]), 0));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(['term', v_decl]))));
															return ((1));
														})()], 0)
													})
												})
											})
										})
									})], 0)], 0));
							return (( p5bool(v_tmp) ? v_MATCH : 0));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3385._prototype_ = null;
					return tmp3385
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_not', (function () {
					var tmp3387;
					tmp3387 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('not' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 3)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((3 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([p5and(('(' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
												return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
											})], 0), function () {
												return p5and(p5context([(function () {
													var v_m2;
													v_m2 = (p5pkg['Perlito5::Grammar::Expression'].paren_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('paren_parse', (v_m2));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})()], 0), function () {
													return p5and(p5context([p5and((')' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0), function () {
														return p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['term', p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'prefix:<not>', 'arguments', p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('paren_parse')]), 1)]), 1), 'namespace', '']), 1)])))));
															return ((1));
														})()], 0)
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3387._prototype_ = null;
					return tmp3387
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_local', (function () {
					var tmp3388;
					tmp3388 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('local' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 5)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((5 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												var v_m2;
												v_m2 = (p5call_sub('Perlito5::Grammar::Sigil', 'term_sigil', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
												return (function () {
													if ( p5bool(v_m2) ) {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Sigil::term_sigil', (v_m2));
													return ((1));
												}
												else {
													return ((0));
												}
												})()
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
													var v_declarator;
													v_declarator = ('local');
													var v_type;
													v_type = ('');
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Sigil::term_sigil')]), p5want)._array_.p5aget(1)));
													v_MATCH = (p5call_sub('Perlito5::Grammar::String', 'double_quoted_var_with_subscript', [v_MATCH], 0));
													var v_var;
													v_var = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('capture'));
													var v_look;
													v_look = (p5pkg['Perlito5::Grammar::Scope'].lookup_variable([v_var], 0));
													(function () {
														if ( (p5bool(v_look) && ((p5str((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_decl')) == 'my') || (p5str((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_decl')) == 'state'))) ) {
														p5pkg['Perlito5::Grammar::Expression'].die([].concat([('Can' + p5pkg['Perlito5::Grammar::Expression'].chr([39], 0) + 't localize lexical variable ' + p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('sigil')) + p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')))]), null);
													}
													})();
													(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_id', ((function () {
																var tmp3389 = p5make_package('Perlito5')['v_ID'];
																p5make_package('Perlito5')['v_ID'] = p5incr_(tmp3389);
																return tmp3389
															})()));
													(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_decl', (v_declarator));
													p5and(!( p5bool((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('namespace'))), function () {
														return p5and(!( p5bool((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('_namespace'))), function () {
															return p5context([(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_namespace', (p5make_package('Perlito5')['v_PKG_NAME']))], 0)
														})
													});
													var v_decl;
													v_decl = (p5call('Perlito5::AST::Decl', 'new', ['decl', v_declarator, 'type', v_type, 'var', v_var], 0));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(['term', v_decl]))));
													return ((1));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3388._prototype_ = null;
					return tmp3388
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_return', (function () {
					var tmp3390;
					tmp3390 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('return' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 6)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((6 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												var v_m2;
												v_m2 = (p5pkg['Perlito5::Grammar::Expression'].list_parse(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
												return (function () {
													if ( p5bool(v_m2) ) {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('list_parse', (v_m2));
													return ((1));
												}
												else {
													return ((0));
												}
												})()
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
													var v_args;
													v_args = (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('list_parse')]), 0));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['term', p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'return', 'arguments', ( (p5str(v_args) == '*undef*') ? (new p5ArrayRef([])) : (new p5ArrayRef([v_args]))), 'namespace', '']), 1)])))));
													return ((1));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3390._prototype_ = null;
					return tmp3390
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'term_eval', (function () {
					var tmp3391;
					tmp3391 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('eval' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 4)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((4 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar'].block(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::block', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['term', p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'eval', 'arguments', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::block')]), 1)]))), 'namespace', '']), 1)])))));
												return ((1));
											})()], 0)
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3391._prototype_ = null;
					return tmp3391
				})());
				var v_Expr_end_token_chars;
				v_Expr_end_token_chars = ((new p5ArrayRef([7, 6, 5, 4, 3, 2, 1])));
				var v_Expr_end_token;
				v_Expr_end_token = ((new p5HashRef({']' : 1, ')' : 1, '}' : 1, ';' : 1, 'if' : 1, 'for' : 1, 'else' : 1, 'when' : 1, 'while' : 1, 'until' : 1, 'elsif' : 1, 'unless' : 1, 'foreach' : 1})));
				var v_List_end_token;
				v_List_end_token = ((new p5HashRef(p5a_to_h(p5list_to_a([':', 1, 'or', 1, 'and', 1, 'xor', 1, p5hash_deref((v_Expr_end_token || (v_Expr_end_token = new p5HashRef({}))), 'Perlito5::Grammar::Expression')])))));
				var v_Argument_end_token;
				v_Argument_end_token = ((new p5HashRef(p5a_to_h(p5list_to_a([',', 1, '<', 1, '>', 1, '=', 1, '|', 1, '^', 1, '?', 1, '=>', 1, 'lt', 1, 'le', 1, 'gt', 1, 'ge', 1, '<=', 1, '>=', 1, '==', 1, '!=', 1, 'ne', 1, 'eq', 1, '..', 1, '~~', 1, '&&', 1, '||', 1, '+=', 1, '-=', 1, '*=', 1, '/=', 1, 'x=', 1, '|=', 1, '&=', 1, '.=', 1, '^=', 1, '%=', 1, '//', 1, '...', 1, '<=>', 1, 'cmp', 1, '<<=', 1, '>>=', 1, '||=', 1, '&&=', 1, '//=', 1, '**=', 1, p5hash_deref((v_List_end_token || (v_List_end_token = new p5HashRef({}))), 'Perlito5::Grammar::Expression')])))));
				p5typeglob_set('Perlito5::Grammar::Expression', 'list_parser', (function () {
					var tmp3392;
					tmp3392 = function (List__, p5want) {
						try {
							var v_str;
							var v_pos;
							var v_end_token;
							var tmp3393 = p5list_to_a([List__]);
							v_str = tmp3393.shift();
							v_pos = tmp3393.shift();
							v_end_token = tmp3393.shift();
							var v_expr;
							var v_last_pos;
							v_last_pos = (v_pos);
							var v_is_first_token;
							v_is_first_token = (1);
							var v_lexer_stack;
							v_lexer_stack = ((new p5ArrayRef([])));
							var v_last_token_was_space;
							v_last_token_was_space = (1);
							var v_get_token;
							v_get_token = ((function () {
										var tmp3394;
										tmp3394 = function (List__, p5want) {
											try {
												var v_last_is_term;
												v_last_is_term = (List__.p5aget(0));
												var v_v;
												(function () {
													if ( p5bool((p5num(p5array_deref((v_lexer_stack || (v_lexer_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) ) {
													v_v = (p5array_deref((v_lexer_stack || (v_lexer_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').pop());
													(function () {
														if ( (p5bool(v_is_first_token) && ((p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(0)) == 'op') && !( p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_fixity_type(p5list_to_a(['prefix', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)]), 0))))) ) {
														(v_v || (v_v = new p5ArrayRef([])))._array_.p5aset(0, ('end'));
													}
													})();
												}
												else {
													(function () {
														var v_m;
														v_m = (p5pkg['Perlito5::Grammar::Precedence'].op_parse([v_str, v_last_pos, v_last_is_term], 0));
														(function () {
															if ( p5bool(v_m) ) {
															(function () {
																var v_spc;
																v_spc = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																(function () {
																	if ( p5bool(v_spc) ) {
																	(v_m || (v_m = new p5HashRef({})))._hash_.p5hset('to', ((v_spc || (v_spc = new p5HashRef({})))._hash_.p5hget('to')));
																}
																})();
															})();
														}
														})();
														(function () {
															if ( !( p5bool(v_m)) ) {
															throw((new p5ArrayRef(['end', '*end*'])));
														}
														})();
														v_v = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('capture'));
														(function () {
															if ( (p5bool(v_is_first_token) && ((p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(0)) == 'op') && !( p5bool(p5pkg['Perlito5::Grammar::Precedence'].is_fixity_type(p5list_to_a(['prefix', (v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(1)]), 0))))) ) {
															(v_v || (v_v = new p5ArrayRef([])))._array_.p5aset(0, ('end'));
														}
														})();
														(function () {
															if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(0)) != 'end') ) {
															v_last_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
														}
														})();
													})();
												}
												})();
												v_last_token_was_space = (p5context([(p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(0)) == 'space')], 0));
												v_is_first_token = (0);
												return (p5context([v_v], p5want));
											}
											catch(err) {
												if ( err instanceof Error ) {
													throw(err);
												}
												else {
													return(err);
												}
											}
										};
										tmp3394._prototype_ = null;
										return tmp3394
									})());
							var v_prec;
							v_prec = (p5call('Perlito5::Grammar::Precedence', 'new', ['get_token', v_get_token, 'reduce', v_reduce_to_ast, 'end_token', v_end_token, 'end_token_chars', v_Expr_end_token_chars], 0));
							var v_res;
							v_res = (p5call(v_prec, 'precedence_parse', [], 0));
							(function () {
								if ( (p5num((p5num(p5array_deref((v_res || (v_res = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) == 0) ) {
								throw((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_last_pos, 'capture' : '*undef*'})));
							}
							})();
							var v_result;
							v_result = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_res], 0));
							return ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_last_pos, 'capture' : v_result})));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3392._prototype_ = null;
					return tmp3392
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'argument_parse', (function () {
					var tmp3395;
					tmp3395 = function (List__, p5want) {
						var v_str;
						var v_pos;
						var tmp3396 = p5list_to_a([List__]);
							v_str = tmp3396.shift();
							v_pos = tmp3396.shift();
						return (p5pkg['Perlito5::Grammar::Expression'].list_parser([v_str, v_pos, v_Argument_end_token], p5want));
					};
					tmp3395._prototype_ = null;
					return tmp3395
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'list_parse', (function () {
					var tmp3397;
					tmp3397 = function (List__, p5want) {
						var v_str;
						var v_pos;
						var tmp3398 = p5list_to_a([List__]);
							v_str = tmp3398.shift();
							v_pos = tmp3398.shift();
						return (p5pkg['Perlito5::Grammar::Expression'].list_parser([v_str, v_pos, v_List_end_token], p5want));
					};
					tmp3397._prototype_ = null;
					return tmp3397
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'circumfix_parse', (function () {
					var tmp3399;
					tmp3399 = function (List__, p5want) {
						var v_str;
						var v_pos;
						var v_delimiter;
						var tmp3400 = p5list_to_a([List__]);
							v_str = tmp3400.shift();
							v_pos = tmp3400.shift();
							v_delimiter = tmp3400.shift();
						var v_expr;
						var v_last_pos;
						v_last_pos = (v_pos);
						var v_get_token;
						v_get_token = ((function () {
										var tmp3401;
										tmp3401 = function (List__, p5want) {
											var v_last_is_term;
											v_last_is_term = (List__.p5aget(0));
											var v_m;
											v_m = (p5pkg['Perlito5::Grammar::Precedence'].op_parse([v_str, v_last_pos, v_last_is_term], 0));
											(function () {
													if ( p5bool(v_m) ) {
													(function () {
														var v_spc;
														v_spc = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														(function () {
															if ( p5bool(v_spc) ) {
															(v_m || (v_m = new p5HashRef({})))._hash_.p5hset('to', ((v_spc || (v_spc = new p5HashRef({})))._hash_.p5hget('to')));
														}
														})();
													})();
												}
												})();
											(function () {
													if ( !( p5bool(v_m)) ) {
													(function () {
														var v_msg;
														v_msg = (('Expected closing delimiter: ' + p5str(v_delimiter)));
														p5and(p5context([p5or((p5str(v_delimiter) == '}'), function () {
															return (p5str(v_delimiter) == ']')
														})], 0), function () {
															return p5context([v_msg = ('Missing right curly or square bracket')], 0)
														});
														p5pkg['Perlito5::Grammar::Expression'].die([].concat([(p5str(v_msg) + ' near '), v_last_pos]), null);
													})();
												}
												})();
											var v_v;
											v_v = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('capture'));
											(function () {
													if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(0)) != 'end') ) {
													v_last_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
												}
												})();
											return (p5context([v_v], p5want));
										};
										tmp3401._prototype_ = null;
										return tmp3401
									})());
						var Hash_delim_token = {};
						Hash_delim_token.p5hset(p5str(v_delimiter), (1));
						var v_prec;
						v_prec = (p5call('Perlito5::Grammar::Precedence', 'new', p5list_to_a(['get_token', v_get_token, 'reduce', v_reduce_to_ast, 'end_token', (new p5HashRef(Hash_delim_token)), 'end_token_chars', (new p5ArrayRef([p5pkg['Perlito5::Grammar::Expression'].length([v_delimiter], 1)]))]), 0));
						var v_res;
						v_res = (p5call(v_prec, 'precedence_parse', [], 0));
						v_res = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_res], 0));
						(function () {
								if ( !( (v_res != null)) ) {
								v_res = ('*undef*');
							}
							})();
						return ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_last_pos, 'capture' : v_res})));
					};
					tmp3399._prototype_ = null;
					return tmp3399
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'ternary5_parse', (function () {
					var tmp3402;
					tmp3402 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].circumfix_parse(p5list_to_a([List__, ':']), p5want));
					};
					tmp3402._prototype_ = null;
					return tmp3402
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'curly_parse', (function () {
					var tmp3403;
					tmp3403 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].circumfix_parse(p5list_to_a([List__, '}']), p5want));
					};
					tmp3403._prototype_ = null;
					return tmp3403
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'square_parse', (function () {
					var tmp3404;
					tmp3404 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].circumfix_parse(p5list_to_a([List__, ']']), p5want));
					};
					tmp3404._prototype_ = null;
					return tmp3404
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'paren_parse', (function () {
					var tmp3405;
					tmp3405 = function (List__, p5want) {
						return (p5pkg['Perlito5::Grammar::Expression'].circumfix_parse(p5list_to_a([List__, ')']), p5want));
					};
					tmp3405._prototype_ = null;
					return tmp3405
				})());
				p5typeglob_set('Perlito5::Grammar::Expression', 'exp_parse', (function () {
					var tmp3406;
					tmp3406 = function (List__, p5want) {
						try {
							var v_str;
							var v_pos;
							var tmp3407 = p5list_to_a([List__]);
							v_str = tmp3407.shift();
							v_pos = tmp3407.shift();
							var v_expr;
							var v_last_pos;
							v_last_pos = (v_pos);
							var v_lexer_stack;
							v_lexer_stack = ((new p5ArrayRef([])));
							var v_get_token;
							v_get_token = ((function () {
										var tmp3408;
										tmp3408 = function (List__, p5want) {
											try {
												var v_last_is_term;
												v_last_is_term = (List__.p5aget(0));
												var v_v;
												(function () {
													if ( p5bool((p5num(p5array_deref((v_lexer_stack || (v_lexer_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) ) {
													v_v = (p5array_deref((v_lexer_stack || (v_lexer_stack = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression').pop());
												}
												else {
													(function () {
														var v_m;
														v_m = (p5pkg['Perlito5::Grammar::Precedence'].op_parse([v_str, v_last_pos, v_last_is_term], 0));
														(function () {
															if ( p5bool(v_m) ) {
															(function () {
																var v_spc;
																v_spc = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																(function () {
																	if ( p5bool(v_spc) ) {
																	(v_m || (v_m = new p5HashRef({})))._hash_.p5hset('to', ((v_spc || (v_spc = new p5HashRef({})))._hash_.p5hget('to')));
																}
																})();
															})();
														}
														})();
														(function () {
															if ( !( p5bool(v_m)) ) {
															throw((new p5ArrayRef(['end', '*end*'])));
														}
														})();
														v_v = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('capture'));
														(function () {
															if ( (p5str((v_v || (v_v = new p5ArrayRef([])))._array_.p5aget(0)) != 'end') ) {
															v_last_pos = ((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to'));
														}
														})();
													})();
												}
												})();
												return (p5context([v_v], p5want));
											}
											catch(err) {
												if ( err instanceof Error ) {
													throw(err);
												}
												else {
													return(err);
												}
											}
										};
										tmp3408._prototype_ = null;
										return tmp3408
									})());
							var v_prec;
							v_prec = (p5call('Perlito5::Grammar::Precedence', 'new', ['get_token', v_get_token, 'reduce', v_reduce_to_ast, 'end_token', v_Expr_end_token, 'end_token_chars', v_Expr_end_token_chars], 0));
							var v_res;
							v_res = (p5call(v_prec, 'precedence_parse', [], 0));
							(function () {
								if ( (p5num((p5num(p5array_deref((v_res || (v_res = new p5ArrayRef([]))), 'Perlito5::Grammar::Expression')))) == 0) ) {
								throw(p5context([0], p5want));
							}
							})();
							var v_result;
							v_result = (p5pkg['Perlito5::Grammar::Expression'].pop_term([v_res], 0));
							return ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_last_pos, 'capture' : v_result})));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3406._prototype_ = null;
					return tmp3406
				})());
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['my', p5pkg['Perlito5::Grammar::Expression'].term_declarator]), null);
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['our', p5pkg['Perlito5::Grammar::Expression'].term_declarator]), null);
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['eval', p5pkg['Perlito5::Grammar::Expression'].term_eval]), null);
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['state', p5pkg['Perlito5::Grammar::Expression'].term_declarator]), null);
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['local', p5pkg['Perlito5::Grammar::Expression'].term_local]), null);
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['return', p5pkg['Perlito5::Grammar::Expression'].term_return]), null);
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['not', p5pkg['Perlito5::Grammar::Expression'].term_not]), null);
				1;
			}, [0], false, ''
		);
		1;
	})();
	(function () {
		null;
		p5make_package('Perlito5::Macro');
		// use strict
;
		p5block(function (v) {}, function () {
				p5make_package('Perlito5::AST::Apply');
				// use strict
;
				var Hash_op = {};
				Hash_op = {'infix:<+=>' : 'infix:<+>', 'infix:<-=>' : 'infix:<->', 'infix:<*=>' : 'infix:<*>', 'infix:</=>' : 'infix:</>', 'infix:<||=>' : 'infix:<||>', 'infix:<&&=>' : 'infix:<&&>', 'infix:<|=>' : 'infix:<|>', 'infix:<&=>' : 'infix:<&>', 'infix:<//=>' : 'infix:<//>', 'infix:<.=>' : 'list:<.>', 'infix:<x=>' : 'infix:<x>'};
				p5typeglob_set('Perlito5::AST::Apply', 'op_assign', (function () {
					var tmp3409;
					tmp3409 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var v_code;
							v_code = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
							p5and(p5pkg['Perlito5::AST::Apply'].ref([v_code], 0), function () {
								throw(p5context([0], p5want))
							});
							(function () {
								if ( (Hash_op).hasOwnProperty(v_code) ) {
								throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'infix:<=>', 'arguments', (new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', Hash_op.p5hget(p5str(v_code)), 'arguments', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 1)])))]), p5want));
							}
							})();
							return (p5context([0], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3409._prototype_ = null;
					return tmp3409
				})());
				var Hash_op_auto = {};
				Hash_op_auto = {'prefix:<++>' : 1, 'prefix:<-->' : 1, 'postfix:<++>' : 1, 'postfix:<-->' : 1};
				p5typeglob_set('Perlito5::AST::Apply', 'op_auto', (function () {
					var tmp3410;
					tmp3410 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var v_code;
							v_code = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
							p5and(p5pkg['Perlito5::AST::Apply'].ref([v_code], 0), function () {
								throw(p5context([0], p5want))
							});
							(function () {
								if ( (Hash_op_auto).hasOwnProperty(v_code) ) {
								(function () {
									var v_paren;
									v_paren = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( (p5str((v_paren || (v_paren = new p5HashRef({})))._hash_.p5hget('code')) == 'circumfix:<( )>') ) {
										(function () {
											var v_arg;
											v_arg = ((v_paren || (v_paren = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(p5num(p5negative( 1))));
											(function () {
												if ( (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'infix:<=>') ) {
												(function () {
													var v_var;
													v_var = ((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
													throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'do', 'arguments', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', (new p5ArrayRef(p5list_to_a([v_paren, p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', v_code, 'arguments', (new p5ArrayRef([v_var]))]), 1)])))]), 1)])))]), p5want));
												})();
											}
											})();
										})();
									}
									})();
								})();
							}
							})();
							return (p5context([0], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3410._prototype_ = null;
					return tmp3410
				})());
			}, [0], false, ''
		);
		p5typeglob_set('Perlito5::Macro', 'while_file', (function () {
			var tmp3411;
			tmp3411 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.p5aget(0));
					p5and((p5pkg['Perlito5::Macro'].ref([v_self], 0) != 'Perlito5::AST::While'), function () {
						throw(p5context([0], p5want))
					});
					var v_cond;
					v_cond = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'));
					(function () {
						if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget('code')) == 'readline')) ) {
						(v_self || (v_self = new p5HashRef({})))._hash_.p5hset('cond', (p5pkg['Perlito5::Macro'].bless([(new p5HashRef(p5a_to_h(p5list_to_a(['arguments', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Macro'].bless([(new p5HashRef(p5a_to_h(p5list_to_a(['arguments', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Var', 'new', ['name', '_', 'namespace', '', 'sigil', '$'], 1), v_cond]))), 'code', 'infix:<=>', 'namespace', ''])))), 'Perlito5::AST::Apply'], 1)]))), 'bareword', '', 'code', 'defined', 'namespace', ''])))), 'Perlito5::AST::Apply'], 0)));
						throw(p5context([v_self], p5want));
					}
					})();
					return (p5context([0], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3411._prototype_ = null;
			return tmp3411
		})());
	})();
	(function () {
		p5make_package('Perlito5::Grammar::Scope');
		// use strict
;
		if (typeof p5pkg[p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] || (p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] = {}), 'Perlito5::Grammar::Scope']['Hash_Special_var'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] || (p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] = {}), 'Perlito5::Grammar::Scope']['Hash_Special_var'] = {};}
		p5pkg[p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] || (p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] = {}), 'Perlito5::Grammar::Scope']['Hash_Special_var'] = {'ARGV' : 1, 'INC' : 1, 'ENV' : 1, 'SIG' : 1, '_' : 1};
		p5typeglob_set('Perlito5::Grammar::Scope', 'new', (function () {
			var tmp3412;
			tmp3412 = function (List__, p5want) {
				return ((new p5HashRef(p5a_to_h(p5list_to_a(['block', (new p5ArrayRef([]))])))));
			};
			tmp3412._prototype_ = null;
			return tmp3412
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'new_base_scope', (function () {
			var tmp3413;
			tmp3413 = function (List__, p5want) {
				return ((new p5HashRef(p5a_to_h(p5list_to_a(['block', (new p5ArrayRef([]))])))));
			};
			tmp3413._prototype_ = null;
			return tmp3413
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'create_new_compile_time_scope', (function () {
			var tmp3414;
			tmp3414 = function (List__, p5want) {
				var v_new_scope;
				v_new_scope = ((new p5HashRef(p5a_to_h(p5list_to_a(['block', (new p5ArrayRef([]))])))));
				p5array_deref((p5make_package('Perlito5')['v_SCOPE'] || (p5make_package('Perlito5')['v_SCOPE'] = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::Grammar::Scope').p5push([v_new_scope]);
				(function () {
						var tmp3415 = p5make_package('Perlito5')['v_SCOPE_DEPTH'];
						p5make_package('Perlito5')['v_SCOPE_DEPTH'] = p5incr_(tmp3415);
						return tmp3415
					})();
				return ((p5make_package('Perlito5')['v_SCOPE'] = (v_new_scope)));
			};
			tmp3414._prototype_ = null;
			return tmp3414
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'end_compile_time_scope', (function () {
			var tmp3416;
			tmp3416 = function (List__, p5want) {
				var v_pos;
				v_pos = (0);
				(function () {
						var tmp3417 = p5make_package('Perlito5')['v_SCOPE_DEPTH'];
						p5make_package('Perlito5')['v_SCOPE_DEPTH'] = p5decr_(tmp3417);
						return tmp3417
					})();
				p5make_package('Perlito5')['v_SCOPE'] = (p5make_package('Perlito5')['v_BASE_SCOPE']);
				(function () {
						p5while(function () {
							(function () {
								var tmp3418 = v_pos;
								v_pos = p5incr_(tmp3418);
								return tmp3418
							})();
							return ((p5make_package('Perlito5')['v_SCOPE'] = ((p5make_package('Perlito5')['v_SCOPE'] || (p5make_package('Perlito5')['v_SCOPE'] = new p5HashRef({})))._hash_.p5hget_array('block')._array_.p5aget(p5num(p5negative( 1))))));
						}, function () {
							return (p5num(p5make_package('Perlito5')['v_SCOPE_DEPTH']) > p5num(v_pos))
						}, false, '', 0)
					})()
			};
			tmp3416._prototype_ = null;
			return tmp3416
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'lookup_variable', (function () {
			var tmp3419;
			tmp3419 = function (List__, p5want) {
				try {
					var v_var;
					v_var = (List__.shift());
					var v_scope;
					v_scope = (p5defined_or(List__.shift(), function () {
								return p5make_package('Perlito5')['v_BASE_SCOPE']
							}));
					p5and((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
						throw(p5context([v_var], p5want))
					});
					p5and((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('_decl'), function () {
						throw(p5context([v_var], p5want))
					});
					var v_look;
					v_look = (p5pkg['Perlito5::Grammar::Scope'].lookup_variable_inner([v_var, v_scope, 0], 0));
					p5and(v_look, function () {
						throw(p5context([v_look], p5want))
					});
					var v_c;
					v_c = (p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')).substr(0, 1));
					(function () {
						if ( (p5bool(p5pkg[p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] || (p5make_package('Perlito5::Grammar::Scope')['Hash_Special_var'] = {}), 'Perlito5::Grammar::Scope']['Hash_Special_var'].p5hget(p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')))) || ((p5str(v_c) < 'A') || (((p5str(v_c) > 'Z') && (p5str(v_c) < 'a')) || (p5str(v_c) > 'z')))) ) {
						(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_decl', ('global'));
						(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_namespace', ('main'));
						throw(p5context([v_var], p5want));
					}
					})();
					(function () {
						if ( ((p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('sigil')) == '$') && ((p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')) == 'a') || (p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')) == 'b'))) ) {
						(function () {
							if ( !( p5bool((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('_real_sigil'))) ) {
							(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_decl', ('global'));
							(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_namespace', (p5make_package('Perlito5')['v_PKG_NAME']));
							throw(p5context([v_var], p5want));
						}
						})();
					}
					})();
					(function () {
						throw(p5context([], p5want))
					})()
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3419._prototype_ = null;
			return tmp3419
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'lookup_variable_inner', (function () {
			var tmp3420;
			tmp3420 = function (List__, p5want) {
				try {
					var v_var;
					var v_scope;
					var v_depth;
					var tmp3421 = p5list_to_a([List__]);
					v_var = tmp3421.shift();
					v_scope = tmp3421.shift();
					v_depth = tmp3421.shift();
					p5and((p5num(v_depth) > p5num(p5make_package('Perlito5')['v_SCOPE_DEPTH'])), function () {
						throw(p5context([], p5want))
					});
					var v_block;
					v_block = ((v_scope || (v_scope = new p5HashRef({})))._hash_.p5hget('block'));
					(function () {
						if ( (p5bool(p5num(p5array_deref((v_block || (v_block = new p5ArrayRef([]))), 'Perlito5::Grammar::Scope'))) && ((p5pkg['Perlito5::Grammar::Scope'].ref([(v_block || (v_block = new p5ArrayRef([])))._array_.p5aget(p5num(p5negative( 1)))], 0) == 'HASH') && p5bool((v_block || (v_block = new p5ArrayRef([])))._array_.p5aget_hash(p5num(p5negative( 1)))._hash_.p5hget('block')))) ) {
						(function () {
							var v_look;
							v_look = (p5pkg['Perlito5::Grammar::Scope'].lookup_variable_inner(p5list_to_a([v_var, (v_block || (v_block = new p5ArrayRef([])))._array_.p5aget(p5num(p5negative( 1))), (p5num(v_depth) + 1)]), 0));
							p5and(v_look, function () {
								throw(p5context([v_look], p5want))
							});
						})();
					}
					})();
					(function () {
						var v_item;
						(function(){ var v_item; p5for_lex(function (v) { v_item = v }, function () {
								(function () {
									if ( ((p5pkg['Perlito5::Grammar::Scope'].ref([v_item], 0) == 'Perlito5::AST::Var') && (p5bool((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_decl')) && ((p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_decl')) != 'global') && (p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('name')) == p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')))))) ) {
									(function () {
										var v_sigil;
										v_sigil = (p5or((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
													return (v_var || (v_var = new p5HashRef({})))._hash_.p5hget('sigil')
												}));
										var v_item_sigil;
										v_item_sigil = (p5or((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
													return (v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')
												}));
										(function () {
											if ( (p5str(v_sigil) == p5str(v_item_sigil)) ) {
											throw(p5context([v_item], p5want));
										}
										})();
									})();
								}
								})();
							}, p5list_to_a([p5pkg['Perlito5::Grammar::Scope'].reverse([].concat(p5list_to_a([p5array_deref((v_block || (v_block = new p5ArrayRef([]))), 'Perlito5::Grammar::Scope')])), 1)]), false, '') })()
					})();
					(function () {
						throw(p5context([], p5want))
					})()
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3420._prototype_ = null;
			return tmp3420
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'check_variable_declarations', (function () {
			var tmp3422;
			tmp3422 = function (List__, p5want) {
				(function () {
						var v_item;
						(function(){ var v_item; p5for_lex(function (v) { v_item = v }, function () {
								(function () {
									if ( (p5pkg['Perlito5::Grammar::Scope'].ref([v_item], 0) == 'Perlito5::AST::Var') ) {
									(function () {
										var v_var;
										v_var = (v_item);
										var v_look;
										v_look = (p5pkg['Perlito5::Grammar::Scope'].lookup_variable([v_var], 0));
										(function () {
											if ( p5bool(v_look) ) {
											p5and((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_id'), function () {
												return (v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_id', ((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_id')))
											});
											p5and((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_decl'), function () {
												return (v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_decl', ((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_decl')))
											});
											p5and((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_namespace'), function () {
												return (v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_namespace', ((v_look || (v_look = new p5HashRef({})))._hash_.p5hget('_namespace')))
											});
										}
										else {
											(function () {
												if ( p5bool(p5make_package('Perlito5')['v_STRICT']) ) {
												(function () {
													var v_sigil;
													v_sigil = (p5or((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
																return (v_var || (v_var = new p5HashRef({})))._hash_.p5hget('sigil')
															}));
													(function () {
														if ( ((p5str(v_sigil) != '*') && (p5str(v_sigil) != '&')) ) {
														p5pkg['Perlito5::Grammar::Scope'].die([].concat([('Global symbol "' + p5str(v_sigil) + p5str((v_var || (v_var = new p5HashRef({})))._hash_.p5hget('name')) + '"' + ' requires explicit package name' + ' at ' + p5str(p5make_package('Perlito5')['v_FILE_NAME']))]), null);
													}
													})();
												})();
											}
											})();
											(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_decl', ('global'));
											(v_var || (v_var = new p5HashRef({})))._hash_.p5hset('_namespace', (p5make_package('Perlito5')['v_PKG_NAME']));
										}
										})();
									})();
								}
								})();
							}, p5list_to_a([p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT']]), false, '') })()
					})();
				p5array_deref((p5make_package('Perlito5')['v_SCOPE'] || (p5make_package('Perlito5')['v_SCOPE'] = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::Grammar::Scope').p5push(p5list_to_a([p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT']]));
				return ((p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = []));
			};
			tmp3422._prototype_ = null;
			return tmp3422
		})());
		p5typeglob_set('Perlito5::Grammar::Scope', 'get_snapshot', (function () {
			var tmp3423;
			tmp3423 = function (List__, p5want) {
				var List_result = [];
				var v_scope;
				v_scope = (p5defined_or(List__.shift(), function () {
								return p5make_package('Perlito5')['v_BASE_SCOPE']
							}));
				var v_block;
				v_block = ((v_scope || (v_scope = new p5HashRef({})))._hash_.p5hget('block'));
				(function () {
						if ( (p5bool(p5num(p5array_deref((v_block || (v_block = new p5ArrayRef([]))), 'Perlito5::Grammar::Scope'))) && ((p5pkg['Perlito5::Grammar::Scope'].ref([(v_block || (v_block = new p5ArrayRef([])))._array_.p5aget(p5num(p5negative( 1)))], 0) == 'HASH') && p5bool((v_block || (v_block = new p5ArrayRef([])))._array_.p5aget_hash(p5num(p5negative( 1)))._hash_.p5hget('block')))) ) {
						(function () {
							var v_look;
							v_look = (p5pkg['Perlito5::Grammar::Scope'].get_snapshot(p5list_to_a([(v_block || (v_block = new p5ArrayRef([])))._array_.p5aget(p5num(p5negative( 1)))]), 0));
							List_result.p5unshift(p5list_to_a([p5array_deref((v_look || (v_look = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::Grammar::Scope')]));
						})();
					}
					})();
				(function () {
						var v_item;
						(function(){ var v_item; p5for_lex(function (v) { v_item = v }, function () {
								(function () {
									if ( ((p5pkg['Perlito5::Grammar::Scope'].ref([v_item], 0) == 'Perlito5::AST::Var') && p5bool((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_decl'))) ) {
									List_result.p5unshift([v_item]);
								}
								})();
							}, p5list_to_a([p5array_deref((v_block || (v_block = new p5ArrayRef([]))), 'Perlito5::Grammar::Scope')]), false, '') })()
					})();
				return ((new p5HashRef(p5a_to_h(p5list_to_a(['block', (new p5ArrayRef(List_result))])))));
			};
			tmp3423._prototype_ = null;
			return tmp3423
		})());
		1;
	})();
	(function () {
		p5make_package('Perlito5');
		// use Perlito5::Grammar::Scope
;
		// use strict
;
		p5or((p5scalar_deref(String.fromCharCode(15), 'Perlito5', "") != null), function () {
			return p5scalar_deref_set(String.fromCharCode(15), ('perlito5'), 'Perlito5')
		});
		p5or((p5make_package('main')['v_/'] != null), function () {
			return p5make_package('main')['v_/'] = (p5pkg['Perlito5'].chr([10], 0))
		});
		p5or((p5make_package('main')['v_"'] != null), function () {
			return p5make_package('main')['v_"'] = (' ')
		});
		p5or((p5make_package('main')['v_,'] != null), function () {
			return p5make_package('main')['v_,'] = (null)
		});
		p5or((p5make_package('main')['v_!'] != null), function () {
			return p5make_package('main')['v_!'] = ('')
		});
		p5or((p5make_package('main')['v_;'] != null), function () {
			return p5make_package('main')['v_;'] = (p5pkg['Perlito5'].chr([28], 0))
		});
		p5or((p5make_package('main')['v_?'] != null), function () {
			return p5make_package('main')['v_?'] = (0)
		});
		p5or(p5make_package('main')['v_]'], function () {
			return p5make_package('main')['v_]'] = ('5.020000')
		});
		p5or((p5scalar_deref(String.fromCharCode(22), 'Perlito5', "") != null), function () {
			return p5scalar_deref_set(String.fromCharCode(22), (p5pkg['Perlito5'].bless([(new p5HashRef(p5a_to_h(p5list_to_a(['original', 'v5.20.0', 'qv', 1, 'version', (new p5ArrayRef([5, 20, 0]))])))), 'version'], 0)), 'Perlito5')
		});
		// our p5make_package('Perlito5')['v_EXPAND_USE']
		p5make_package('Perlito5')['v_EXPAND_USE'] = (1);
		// our p5make_package('Perlito5')['v_EMIT_USE']
		p5make_package('Perlito5')['v_EMIT_USE'] = (0);
		// our p5make_package('Perlito5')['v_STRICT']
		p5make_package('Perlito5')['v_STRICT'] = (0);
		// our p5make_package('Perlito5')['v_WARNINGS']
		p5make_package('Perlito5')['v_WARNINGS'] = (0);
		// our p5make_package('Perlito5')['v_UTF8']
		p5make_package('Perlito5')['v_UTF8'] = (0);
		// our p5make_package('Perlito5')['v_BYTES']
		p5make_package('Perlito5')['v_BYTES'] = (0);
		// our p5make_package('Perlito5')['v_CALLER']
		p5make_package('Perlito5')['v_CALLER'] = ((new p5ArrayRef([])));
		if (typeof p5pkg[p5make_package('Perlito5')['Hash_DATA_SECTION'] || (p5make_package('Perlito5')['Hash_DATA_SECTION'] = {}), 'Perlito5']['Hash_DATA_SECTION'] == "undefined" ) { p5pkg[p5make_package('Perlito5')['Hash_DATA_SECTION'] || (p5make_package('Perlito5')['Hash_DATA_SECTION'] = {}), 'Perlito5']['Hash_DATA_SECTION'] = {};}
		p5pkg[p5make_package('Perlito5')['Hash_DATA_SECTION'] || (p5make_package('Perlito5')['Hash_DATA_SECTION'] = {}), 'Perlito5']['Hash_DATA_SECTION'] = {};
		// our p5make_package('Perlito5')['v_PKG_NAME']
		p5make_package('Perlito5')['v_PKG_NAME'] = ('');
		// our p5make_package('Perlito5')['v_LINE_NUMBER']
		p5make_package('Perlito5')['v_LINE_NUMBER'] = (0);
		// our p5make_package('Perlito5')['v_FILE_NAME']
		p5make_package('Perlito5')['v_FILE_NAME'] = ('');
		// our p5make_package('Perlito5')['v_BASE_SCOPE']
		p5make_package('Perlito5')['v_BASE_SCOPE'] = (p5call('Perlito5::Grammar::Scope', 'new_base_scope', [], 0));
		// our p5make_package('Perlito5')['v_SCOPE']
		p5make_package('Perlito5')['v_SCOPE'] = (p5make_package('Perlito5')['v_BASE_SCOPE']);
		// our p5make_package('Perlito5')['v_SCOPE_DEPTH']
		p5make_package('Perlito5')['v_SCOPE_DEPTH'] = (0);
		if (typeof p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] == "undefined" ) { p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = [];}
		p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = [];
		// our p5make_package('Perlito5')['v_ID']
		p5make_package('Perlito5')['v_ID'] = (100);
		// our p5make_package('Perlito5')['v_PACKAGES']
		p5make_package('Perlito5')['v_PACKAGES'] = ((new p5HashRef({'STDERR' : 1, 'STDOUT' : 1, 'STDIN' : 1, 'main' : 1, 'strict' : 1, 'warnings' : 1, 'utf8' : 1, 'bytes' : 1, 'encoding' : 1, 'UNIVERSAL' : 1, 'CORE' : 1, 'CORE::GLOBAL' : 1, 'Perlito5::IO' : 1})));
		p5for(p5make_package('main'), "v__", function () {
				p5pkg[p5make_package('main')['List_INC'] || (p5make_package('main')['List_INC'] = []), 'main']['List_INC'].p5push([p5make_package('main')['v__']]);
			}, p5list_to_a([CORE.split([':', p5context([p5or(p5pkg[p5make_package('main')['Hash_ENV'] || (p5make_package('main')['Hash_ENV'] = {}), 'main']['Hash_ENV'].p5hget('PERL5LIB'), function () {
	return ''
})], 0)], 1)]), false, '');
		// our p5make_package('Perlito5')['v_SPECIAL_VAR']
		p5make_package('Perlito5')['v_SPECIAL_VAR'] = ((new p5HashRef(p5a_to_h(p5list_to_a(['$_', 'ARG', '$&', '$MATCH', '$`', '$PREMATCH', '$' + String.fromCharCode(39), '$POSTMATCH', '$+', '$LAST_PAREN_MATCH', '@+', '@LAST_MATCH_END', '%+', '%LAST_PAREN_MATCH', '@-', '@LAST_MATCH_START', '$|', 'autoflush', '$/', '$RS', '@_', '@ARG', '< $', '$EUID', '$.', '$NR', '< $< ', '$UID', '$(', '$GID', '$#', null, '$@', '$EVAL_ERROR', '$=', '$FORMAT_LINES_PER_PAGE', '$,', '$OFS', '$?', '$CHILD_ERROR', '$*', null, '$[', null, '$$', '$PID', '%-', null, '$~', '$FORMAT_NAME', '$-', '$FORMAT_LINES_LEFT', '$&', '$MATCH', '$%', '$FORMAT_PAGE_NUMBER', '$)', '$EGID', '$]', null, '$!', '$ERRNO', '$;', '$SUBSEP', '$' + String.fromCharCode(92), '$ORS', '%!', null, '$"', '$LIST_SEPARATOR', '$_', '$ARG', '$:', 'FORMAT_LINE_BREAK_CHARACTERS'])))));
		// our p5make_package('Perlito5')['v_CORE_OVERRIDABLE']
		p5make_package('Perlito5')['v_CORE_OVERRIDABLE'] = ((new p5HashRef({'say' : 1, 'break' : 1, 'given' : 1, 'when' : 1, 'default' : 1, 'state' : 1, 'lock' : 1})));
		// our p5make_package('Perlito5')['v_CORE_PROTO']
		p5make_package('Perlito5')['v_CORE_PROTO'] = ((new p5HashRef(p5a_to_h(p5list_to_a(['CORE::shutdown', '*$', 'CORE::chop', '_', 'CORE::lstat', '*', 'CORE::rename', '$$', 'CORE::lock', String.fromCharCode(92) + '$', 'CORE::rand', ';$', 'CORE::gmtime', ';$', 'CORE::gethostbyname', '$', 'CORE::each', '+', 'CORE::ref', '_', 'CORE::syswrite', '*$;$$', 'CORE::msgctl', '$$$', 'CORE::getnetbyname', '$', 'CORE::write', ';*', 'CORE::alarm', '_', 'CORE::print', null, 'CORE::getnetent', '', 'CORE::semget', '$$$', 'CORE::use', null, 'CORE::abs', '_', 'CORE::break', '', 'CORE::undef', ';$', 'CORE::no', null, 'CORE::eval', '_', 'CORE::split', null, 'CORE::localtime', ';$', 'CORE::sort', null, 'CORE::chown', '@', 'CORE::endpwent', '', 'CORE::getpwent', '', 'CORE::pos', null, 'CORE::lcfirst', '_', 'CORE::kill', '@', 'CORE::send', '*$$;$', 'CORE::endprotoent', '', 'CORE::semctl', '$$$$', 'CORE::waitpid', '$$', 'CORE::utime', '@', 'CORE::dbmclose', String.fromCharCode(92) + '%', 'CORE::getpwnam', '$', 'CORE::substr', '$$;$$', 'CORE::listen', '*$', 'CORE::getprotoent', '', 'CORE::shmget', '$$$', 'CORE::our', null, 'CORE::readlink', '_', 'CORE::shmwrite', '$$$$', 'CORE::times', '', 'CORE::package', null, 'CORE::map', null, 'CORE::join', '$@', 'CORE::rmdir', '_', 'CORE::shmread', '$$$$', 'CORE::uc', '_', 'CORE::bless', '$;$', 'CORE::closedir', '*', 'CORE::getppid', '', 'CORE::tie', String.fromCharCode(92) + '[$@%]$;@', 'CORE::readdir', '*', 'CORE::gethostent', '', 'CORE::getlogin', '', 'CORE::last', null, 'CORE::gethostbyaddr', '$$', 'CORE::accept', '**', 'CORE::log', '_', 'CORE::tell', ';*', 'CORE::readline', ';*', 'CORE::tied', null, 'CORE::socket', '*$$$', 'CORE::umask', ';$', 'CORE::sysread', '*' + String.fromCharCode(92) + '$$;$', 'CORE::syscall', '$@', 'CORE::quotemeta', '_', 'CORE::dump', '', 'CORE::opendir', '*$', 'CORE::untie', null, 'CORE::truncate', '$$', 'CORE::select', ';*', 'CORE::sleep', ';$', 'CORE::seek', '*$$', 'CORE::read', '*' + String.fromCharCode(92) + '$$;$', 'CORE::rewinddir', '*', 'CORE::scalar', null, 'CORE::wantarray', '', 'CORE::oct', '_', 'CORE::bind', '*$', 'CORE::stat', '*', 'CORE::sqrt', '_', 'CORE::getc', ';*', 'CORE::fileno', '*', 'CORE::getpeername', '*', 'CORE::sin', '_', 'CORE::getnetbyaddr', '$$', 'CORE::grep', null, 'CORE::setservent', '$', 'CORE::sub', null, 'CORE::shmctl', '$$$', 'CORE::study', null, 'CORE::msgrcv', '$$$$$', 'CORE::setsockopt', '*$$$', 'CORE::int', '_', 'CORE::pop', ';+', 'CORE::link', '$$', 'CORE::exec', null, 'CORE::setpwent', '', 'CORE::mkdir', '_;$', 'CORE::sysseek', '*$$', 'CORE::endservent', '', 'CORE::chr', '_', 'CORE::when', null, 'CORE::getpwuid', '$', 'CORE::setprotoent', '$', 'CORE::reverse', '@', 'CORE::say', null, 'CORE::goto', null, 'CORE::getgrent', '', 'CORE::endnetent', '', 'CORE::hex', '_', 'CORE::binmode', '*;$', 'CORE::formline', '$@', 'CORE::getgrnam', '$', 'CORE::ucfirst', '_', 'CORE::chdir', ';$', 'CORE::setnetent', '$', 'CORE::splice', '+;$$@', 'CORE::unlink', '@', 'CORE::time', '', 'CORE::push', '+@', 'CORE::exit', ';$', 'CORE::endgrent', '', 'CORE::unshift', '+@', 'CORE::local', null, 'CORE::my', null, 'CORE::cos', '_', 'CORE::redo', null, 'CORE::warn', '@', 'CORE::getsockname', '*', 'CORE::pipe', '**', 'CORE::sprintf', '$@', 'CORE::open', '*;$@', 'CORE::setpgrp', ';$$', 'CORE::exp', '_', 'CORE::seekdir', '*$', 'CORE::getservbyport', '$$', 'CORE::given', null, 'CORE::pack', '$@', 'CORE::msgget', '$$', 'CORE::rindex', '$$;$', 'CORE::srand', ';$', 'CORE::telldir', '*', 'CORE::connect', '*$', 'CORE::getprotobyname', '$', 'CORE::msgsnd', '$$$', 'CORE::length', '_', 'CORE::state', null, 'CORE::die', '@', 'CORE::delete', null, 'CORE::getservent', '', 'CORE::getservbyname', '$$', 'CORE::setpriority', '$$$', 'CORE::lc', '_', 'CORE::fcntl', '*$$', 'CORE::chroot', '_', 'CORE::recv', '*' + String.fromCharCode(92) + '$$$', 'CORE::dbmopen', String.fromCharCode(92) + '%$$', 'CORE::socketpair', '**$$$', 'CORE::vec', '$$$', 'CORE::system', null, 'CORE::defined', '_', 'CORE::index', '$$;$', 'CORE::caller', ';$', 'CORE::close', ';*', 'CORE::atan2', '$$', 'CORE::semop', '$$', 'CORE::unpack', '$;$', 'CORE::ord', '_', 'CORE::chmod', '@', 'CORE::prototype', null, 'CORE::getprotobynumber', '$', 'CORE::values', '+', 'CORE::chomp', '_', 'CORE::ioctl', '*$$', 'CORE::eof', ';*', 'CORE::crypt', '$$', 'CORE::do', null, 'CORE::flock', '*$', 'CORE::wait', '', 'CORE::sethostent', '$', 'CORE::return', null, 'CORE::getsockopt', '*$$', 'CORE::fork', '', 'CORE::require', null, 'CORE::format', null, 'CORE::readpipe', '_', 'CORE::endhostent', '', 'CORE::getpgrp', ';$', 'CORE::setgrent', '', 'CORE::keys', '+', 'CORE::glob', null, 'CORE::getpriority', '$$', 'CORE::reset', ';$', 'CORE::sysopen', '*$$;$', 'CORE::continue', '', 'CORE::next', null, 'CORE::getgrgid', '$', 'CORE::default', null, 'CORE::shift', ';+', 'CORE::symlink', '$$', 'CORE::exists', '$', 'CORE::printf', '$@', 'CORE::m', null, 'CORE::q', null, 'CORE::qq', null, 'CORE::qw', null, 'CORE::qx', null, 'CORE::qr', null, 'CORE::s', null, 'CORE::tr', null, 'CORE::y', null, 'CORE::if', null, 'CORE::unless', null, 'CORE::when', null, 'CORE::for', null, 'CORE::foreach', null, 'CORE::while', null, 'CORE::given', null, 'CORE::and', null, 'CORE::or', null, 'CORE::xor', null, 'CORE::not', null, 'CORE::cmp', null, 'CORE::__FILE__', '', 'CORE::__LINE__', ''])))));
		p5typeglob_set('Perlito5', 'test_perl_version', (function () {
			var tmp3424;
			tmp3424 = function (List__, p5want) {
				var local_idx = p5LOCAL.length;
				var regex_tmp = p5_regex_capture;
				p5LOCAL.push(function(){ p5_regex_capture = regex_tmp });
				var v_version;
				v_version = (List__.shift());
				(function () {
							var tmp = p5s(v_version, '^v', function () {
								return ''
							}, '', 0);
							v_version = tmp[0];
							return tmp[1];
						})();
				(function () {
						if ( (p5bool(v_version) && (p5pkg['Perlito5'].ord([p5str(v_version).substr(0, 1)], 0) < 10)) ) {
						(function () {
							var List_v = [];
							List_v = p5list_to_a([CORE.split([new RegExp('', ''), v_version], 1)]);
							(function () {
								p5while(function () {
									List_v.p5push([p5pkg['Perlito5'].chr([0], 1)]);
								}, function () {
									return (p5num(List_v.length) < 3)
								}, false, '', 0)
							})();
							v_version = (p5pkg['Perlito5'].sprintf(['%d.%03d%03d'].concat(p5list_to_a([p5map(p5pkg['Perlito5'], function (p5want) {
											return (p5pkg['Perlito5'].ord([p5make_package('main')['v__']], 1));
										}, p5list_to_a([List_v]))])), 0));
						})();
					}
					else {
						(function () {
							var List_v = [];
							List_v = p5list_to_a([CORE.split([new RegExp(String.fromCharCode(92) + '.', ''), v_version], 1)]);
							(function () {
								p5while(function () {
									List_v.p5aset(1, ((p5str(List_v.p5aget(1)) + '0')));
								}, function () {
									return (p5pkg['Perlito5'].length([List_v.p5aget(1)], 0) < 3)
								}, false, '', 0)
							})();
							v_version = (p5pkg['Perlito5'].join(['.'].concat(p5list_to_a([List_v])), 0));
						})();
					}
					})();
				return (function () {
						if ( (p5str(v_version) > p5str(p5make_package('main')['v_]'])) ) {
						return (p5pkg['Perlito5'].die([].concat([('Perl v' + p5str(v_version) + ' required--this is only v' + p5str(p5make_package('main')['v_]']))]), p5want));
					}
					})()
				p5cleanup_local(local_idx, null);
			};
			tmp3424._prototype_ = null;
			return tmp3424
		})());
		1;
	})();
	(function () {
		p5make_package('Perlito5::Compiler');
		// use strict
;
		// use warnings
;
		// use Perlito5::Match
;
		// use Perlito5::Grammar
;
		// use Perlito5::Grammar::Control
;
		// use Perlito5::Grammar::Precedence
;
		// use Perlito5::Grammar::Expression
;
		// use Perlito5::Macro
;
		// use Perlito5::Runtime
;
		1;
	})();
	// use Perlito5::Compiler
;
	(function () {
		null;
		p5make_package('Perlito5::AST::CompUnit');
		p5typeglob_set('Perlito5::AST::CompUnit', 'new', (function () {
			var tmp3425;
			tmp3425 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::CompUnit'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3425._prototype_ = null;
			return tmp3425
		})());
		p5typeglob_set('Perlito5::AST::CompUnit', 'name', (function () {
			var tmp3426;
			tmp3426 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('name'));
			};
			tmp3426._prototype_ = null;
			return tmp3426
		})());
		p5typeglob_set('Perlito5::AST::CompUnit', 'body', (function () {
			var tmp3427;
			tmp3427 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('body'));
			};
			tmp3427._prototype_ = null;
			return tmp3427
		})());
		p5make_package('Perlito5::AST::Int');
		p5typeglob_set('Perlito5::AST::Int', 'new', (function () {
			var tmp3428;
			tmp3428 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Int'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3428._prototype_ = null;
			return tmp3428
		})());
		p5typeglob_set('Perlito5::AST::Int', 'int', (function () {
			var tmp3429;
			tmp3429 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('int'));
			};
			tmp3429._prototype_ = null;
			return tmp3429
		})());
		p5make_package('Perlito5::AST::Num');
		p5typeglob_set('Perlito5::AST::Num', 'new', (function () {
			var tmp3430;
			tmp3430 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Num'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3430._prototype_ = null;
			return tmp3430
		})());
		p5typeglob_set('Perlito5::AST::Num', 'num', (function () {
			var tmp3431;
			tmp3431 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('num'));
			};
			tmp3431._prototype_ = null;
			return tmp3431
		})());
		p5make_package('Perlito5::AST::Buf');
		p5typeglob_set('Perlito5::AST::Buf', 'new', (function () {
			var tmp3432;
			tmp3432 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Buf'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3432._prototype_ = null;
			return tmp3432
		})());
		p5typeglob_set('Perlito5::AST::Buf', 'buf', (function () {
			var tmp3433;
			tmp3433 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('buf'));
			};
			tmp3433._prototype_ = null;
			return tmp3433
		})());
		p5make_package('Perlito5::AST::Block');
		p5typeglob_set('Perlito5::AST::Block', 'new', (function () {
			var tmp3434;
			tmp3434 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Block'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3434._prototype_ = null;
			return tmp3434
		})());
		p5typeglob_set('Perlito5::AST::Block', 'sig', (function () {
			var tmp3435;
			tmp3435 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('sig'));
			};
			tmp3435._prototype_ = null;
			return tmp3435
		})());
		p5typeglob_set('Perlito5::AST::Block', 'stmts', (function () {
			var tmp3436;
			tmp3436 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('stmts'));
			};
			tmp3436._prototype_ = null;
			return tmp3436
		})());
		p5make_package('Perlito5::AST::Index');
		p5typeglob_set('Perlito5::AST::Index', 'new', (function () {
			var tmp3437;
			tmp3437 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Index'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3437._prototype_ = null;
			return tmp3437
		})());
		p5typeglob_set('Perlito5::AST::Index', 'obj', (function () {
			var tmp3438;
			tmp3438 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('obj'));
			};
			tmp3438._prototype_ = null;
			return tmp3438
		})());
		p5typeglob_set('Perlito5::AST::Index', 'index_exp', (function () {
			var tmp3439;
			tmp3439 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('index_exp'));
			};
			tmp3439._prototype_ = null;
			return tmp3439
		})());
		p5make_package('Perlito5::AST::Lookup');
		p5typeglob_set('Perlito5::AST::Lookup', 'new', (function () {
			var tmp3440;
			tmp3440 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Lookup'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3440._prototype_ = null;
			return tmp3440
		})());
		p5typeglob_set('Perlito5::AST::Lookup', 'obj', (function () {
			var tmp3441;
			tmp3441 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('obj'));
			};
			tmp3441._prototype_ = null;
			return tmp3441
		})());
		p5typeglob_set('Perlito5::AST::Lookup', 'index_exp', (function () {
			var tmp3442;
			tmp3442 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('index_exp'));
			};
			tmp3442._prototype_ = null;
			return tmp3442
		})());
		p5typeglob_set('Perlito5::AST::Lookup', 'autoquote', (function () {
			var tmp3443;
			tmp3443 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.shift());
					var v_index;
					v_index = (List__.shift());
					(function () {
						if ( (p5bool(p5call(v_index, 'isa', ['Perlito5::AST::Apply'], 0)) && p5bool((v_index || (v_index = new p5HashRef({})))._hash_.p5hget('bareword'))) ) {
						(function () {
							var v_full_name;
							v_full_name = ((p5str(( p5bool((v_index || (v_index = new p5HashRef({})))._hash_.p5hget('namespace')) ? (p5str((v_index || (v_index = new p5HashRef({})))._hash_.p5hget('namespace')) + '::') : '')) + p5str((v_index || (v_index = new p5HashRef({})))._hash_.p5hget('code'))));
							(function () {
								if ( !( (p5make_package('Perlito5')['v_PROTO'])._hash_.hasOwnProperty(v_full_name)) ) {
								throw(p5call('Perlito5::AST::Buf', 'new', ['buf', v_full_name], p5want));
							}
							})();
						})();
					}
					else (function () {
						if ( (p5bool(p5call(v_index, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_index, 'code', [], 0)) == 'prefix:<->') || (p5str(p5call(v_index, 'code', [], 0)) == 'prefix:<+>'))) ) {
						(function () {
							var v_arg;
							v_arg = (p5call(v_index, 'arguments', [], p5want)._array_.p5aget(0));
							p5and(v_arg, function () {
								throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', p5call(v_index, 'code', [], 1), 'namespace', p5call(v_index, 'namespace', [], 1), 'arguments', (new p5ArrayRef(p5list_to_a([p5call(v_self, 'autoquote', [v_arg], 1)])))]), p5want))
							});
						})();
					}
					else (function () {
						if ( (p5bool(p5call(v_index, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call(v_index, 'code', [], 0)) == 'list:<,>')) ) {
						(function () {
							var v_obj;
							v_obj = (p5call(v_self, 'obj', [], 0));
							(function () {
								if ( (p5str(p5call(v_obj, 'sigil', [], 0)) == '@') ) {
								throw(p5context([v_index], p5want));
							}
							})();
							var v_args;
							v_args = (p5call(v_index, 'arguments', [], 0));
							throw(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'join', 'namespace', '', 'arguments', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Var', 'new', ['name', ';', 'namespace', '', 'sigil', '$'], 1), p5map(p5pkg['Perlito5::AST::Lookup'], function (p5want) {
	return (( (p5make_package('main')['v__'] != null) ? p5make_package('main')['v__'] : p5call('Perlito5::AST::Buf', 'new', ['buf', ''], 1)));
}, p5list_to_a([p5array_deref((v_args || (v_args = new p5ArrayRef([]))), 'Perlito5::AST::Lookup')]))])))]), p5want));
						})();
					}
					})()
					})()
					})();
					return (p5context([v_index], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3443._prototype_ = null;
			return tmp3443
		})());
		p5make_package('Perlito5::AST::Var');
		p5typeglob_set('Perlito5::AST::Var', 'new', (function () {
			var tmp3444;
			tmp3444 = function (List__, p5want) {
				var v_class;
				var Hash_args = {};
				var tmp3445 = p5list_to_a([List__]);
					v_class = tmp3445.shift();
					Hash_args = p5a_to_h(tmp3445);
					tmp3445 = [];
				var v_var;
				v_var = (p5pkg['Perlito5::AST::Var'].bless([(new p5HashRef(Hash_args)), v_class], 0));
				p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'].p5push([v_var]);
				return (p5context([v_var], p5want));
			};
			tmp3444._prototype_ = null;
			return tmp3444
		})());
		p5typeglob_set('Perlito5::AST::Var', 'sigil', (function () {
			var tmp3446;
			tmp3446 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('sigil'));
			};
			tmp3446._prototype_ = null;
			return tmp3446
		})());
		p5typeglob_set('Perlito5::AST::Var', 'namespace', (function () {
			var tmp3447;
			tmp3447 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('namespace'));
			};
			tmp3447._prototype_ = null;
			return tmp3447
		})());
		p5typeglob_set('Perlito5::AST::Var', 'name', (function () {
			var tmp3448;
			tmp3448 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('name'));
			};
			tmp3448._prototype_ = null;
			return tmp3448
		})());
		p5typeglob_set('Perlito5::AST::Var', 'plain_name', (function () {
			var tmp3449;
			tmp3449 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.shift());
					(function () {
						if ( p5bool(p5call(v_self, 'namespace', [], 0)) ) {
						throw(p5context([(p5str(p5call(v_self, 'namespace', [], 0)) + '::' + p5str(p5call(v_self, 'name', [], 0)))], p5want));
					}
					})();
					return (p5call(v_self, 'name', [], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3449._prototype_ = null;
			return tmp3449
		})());
		p5make_package('Perlito5::AST::Call');
		p5typeglob_set('Perlito5::AST::Call', 'new', (function () {
			var tmp3450;
			tmp3450 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Call'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3450._prototype_ = null;
			return tmp3450
		})());
		p5typeglob_set('Perlito5::AST::Call', 'invocant', (function () {
			var tmp3451;
			tmp3451 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('invocant'));
			};
			tmp3451._prototype_ = null;
			return tmp3451
		})());
		p5typeglob_set('Perlito5::AST::Call', 'method', (function () {
			var tmp3452;
			tmp3452 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('method'));
			};
			tmp3452._prototype_ = null;
			return tmp3452
		})());
		p5typeglob_set('Perlito5::AST::Call', 'arguments', (function () {
			var tmp3453;
			tmp3453 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('arguments'));
			};
			tmp3453._prototype_ = null;
			return tmp3453
		})());
		p5make_package('Perlito5::AST::Apply');
		p5typeglob_set('Perlito5::AST::Apply', 'new', (function () {
			var tmp3454;
			tmp3454 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Apply'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3454._prototype_ = null;
			return tmp3454
		})());
		p5typeglob_set('Perlito5::AST::Apply', 'code', (function () {
			var tmp3455;
			tmp3455 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('code'));
			};
			tmp3455._prototype_ = null;
			return tmp3455
		})());
		p5typeglob_set('Perlito5::AST::Apply', 'special_arg', (function () {
			var tmp3456;
			tmp3456 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('special_arg'));
			};
			tmp3456._prototype_ = null;
			return tmp3456
		})());
		p5typeglob_set('Perlito5::AST::Apply', 'arguments', (function () {
			var tmp3457;
			tmp3457 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('arguments'));
			};
			tmp3457._prototype_ = null;
			return tmp3457
		})());
		p5typeglob_set('Perlito5::AST::Apply', 'namespace', (function () {
			var tmp3458;
			tmp3458 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('namespace'));
			};
			tmp3458._prototype_ = null;
			return tmp3458
		})());
		p5make_package('Perlito5::AST::If');
		p5typeglob_set('Perlito5::AST::If', 'new', (function () {
			var tmp3459;
			tmp3459 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::If'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3459._prototype_ = null;
			return tmp3459
		})());
		p5typeglob_set('Perlito5::AST::If', 'cond', (function () {
			var tmp3460;
			tmp3460 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('cond'));
			};
			tmp3460._prototype_ = null;
			return tmp3460
		})());
		p5typeglob_set('Perlito5::AST::If', 'body', (function () {
			var tmp3461;
			tmp3461 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('body'));
			};
			tmp3461._prototype_ = null;
			return tmp3461
		})());
		p5typeglob_set('Perlito5::AST::If', 'otherwise', (function () {
			var tmp3462;
			tmp3462 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('otherwise'));
			};
			tmp3462._prototype_ = null;
			return tmp3462
		})());
		p5make_package('Perlito5::AST::When');
		p5typeglob_set('Perlito5::AST::When', 'new', (function () {
			var tmp3463;
			tmp3463 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::When'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3463._prototype_ = null;
			return tmp3463
		})());
		p5typeglob_set('Perlito5::AST::When', 'cond', (function () {
			var tmp3464;
			tmp3464 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('cond'));
			};
			tmp3464._prototype_ = null;
			return tmp3464
		})());
		p5typeglob_set('Perlito5::AST::When', 'body', (function () {
			var tmp3465;
			tmp3465 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('body'));
			};
			tmp3465._prototype_ = null;
			return tmp3465
		})());
		p5make_package('Perlito5::AST::While');
		p5typeglob_set('Perlito5::AST::While', 'new', (function () {
			var tmp3466;
			tmp3466 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::While'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3466._prototype_ = null;
			return tmp3466
		})());
		p5typeglob_set('Perlito5::AST::While', 'init', (function () {
			var tmp3467;
			tmp3467 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('init'));
			};
			tmp3467._prototype_ = null;
			return tmp3467
		})());
		p5typeglob_set('Perlito5::AST::While', 'cond', (function () {
			var tmp3468;
			tmp3468 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('cond'));
			};
			tmp3468._prototype_ = null;
			return tmp3468
		})());
		p5typeglob_set('Perlito5::AST::While', 'continue', (function () {
			var tmp3469;
			tmp3469 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('continue'));
			};
			tmp3469._prototype_ = null;
			return tmp3469
		})());
		p5typeglob_set('Perlito5::AST::While', 'body', (function () {
			var tmp3470;
			tmp3470 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('body'));
			};
			tmp3470._prototype_ = null;
			return tmp3470
		})());
		p5make_package('Perlito5::AST::For');
		p5typeglob_set('Perlito5::AST::For', 'new', (function () {
			var tmp3471;
			tmp3471 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::For'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3471._prototype_ = null;
			return tmp3471
		})());
		p5typeglob_set('Perlito5::AST::For', 'cond', (function () {
			var tmp3472;
			tmp3472 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('cond'));
			};
			tmp3472._prototype_ = null;
			return tmp3472
		})());
		p5typeglob_set('Perlito5::AST::For', 'continue', (function () {
			var tmp3473;
			tmp3473 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('continue'));
			};
			tmp3473._prototype_ = null;
			return tmp3473
		})());
		p5typeglob_set('Perlito5::AST::For', 'body', (function () {
			var tmp3474;
			tmp3474 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('body'));
			};
			tmp3474._prototype_ = null;
			return tmp3474
		})());
		p5typeglob_set('Perlito5::AST::For', 'topic', (function () {
			var tmp3475;
			tmp3475 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('topic'));
			};
			tmp3475._prototype_ = null;
			return tmp3475
		})());
		p5make_package('Perlito5::AST::Given');
		p5typeglob_set('Perlito5::AST::Given', 'new', (function () {
			var tmp3476;
			tmp3476 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Given'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3476._prototype_ = null;
			return tmp3476
		})());
		p5typeglob_set('Perlito5::AST::Given', 'cond', (function () {
			var tmp3477;
			tmp3477 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('cond'));
			};
			tmp3477._prototype_ = null;
			return tmp3477
		})());
		p5typeglob_set('Perlito5::AST::Given', 'body', (function () {
			var tmp3478;
			tmp3478 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('body'));
			};
			tmp3478._prototype_ = null;
			return tmp3478
		})());
		p5make_package('Perlito5::AST::Decl');
		p5typeglob_set('Perlito5::AST::Decl', 'new', (function () {
			var tmp3479;
			tmp3479 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Decl'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3479._prototype_ = null;
			return tmp3479
		})());
		p5typeglob_set('Perlito5::AST::Decl', 'decl', (function () {
			var tmp3480;
			tmp3480 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('decl'));
			};
			tmp3480._prototype_ = null;
			return tmp3480
		})());
		p5typeglob_set('Perlito5::AST::Decl', 'type', (function () {
			var tmp3481;
			tmp3481 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('type'));
			};
			tmp3481._prototype_ = null;
			return tmp3481
		})());
		p5typeglob_set('Perlito5::AST::Decl', 'var', (function () {
			var tmp3482;
			tmp3482 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('var'));
			};
			tmp3482._prototype_ = null;
			return tmp3482
		})());
		p5typeglob_set('Perlito5::AST::Decl', 'attributes', (function () {
			var tmp3483;
			tmp3483 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('attributes'));
			};
			tmp3483._prototype_ = null;
			return tmp3483
		})());
		p5make_package('Perlito5::AST::Sub');
		p5typeglob_set('Perlito5::AST::Sub', 'new', (function () {
			var tmp3484;
			tmp3484 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Sub'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3484._prototype_ = null;
			return tmp3484
		})());
		p5typeglob_set('Perlito5::AST::Sub', 'name', (function () {
			var tmp3485;
			tmp3485 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('name'));
			};
			tmp3485._prototype_ = null;
			return tmp3485
		})());
		p5typeglob_set('Perlito5::AST::Sub', 'sig', (function () {
			var tmp3486;
			tmp3486 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('sig'));
			};
			tmp3486._prototype_ = null;
			return tmp3486
		})());
		p5typeglob_set('Perlito5::AST::Sub', 'block', (function () {
			var tmp3487;
			tmp3487 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('block'));
			};
			tmp3487._prototype_ = null;
			return tmp3487
		})());
		p5typeglob_set('Perlito5::AST::Sub', 'attributes', (function () {
			var tmp3488;
			tmp3488 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('attributes'));
			};
			tmp3488._prototype_ = null;
			return tmp3488
		})());
		p5make_package('Perlito5::AST::Use');
		p5typeglob_set('Perlito5::AST::Use', 'new', (function () {
			var tmp3489;
			tmp3489 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::AST::Use'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3489._prototype_ = null;
			return tmp3489
		})());
		p5typeglob_set('Perlito5::AST::Use', 'mod', (function () {
			var tmp3490;
			tmp3490 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('mod'));
			};
			tmp3490._prototype_ = null;
			return tmp3490
		})());
		p5typeglob_set('Perlito5::AST::Use', 'code', (function () {
			var tmp3491;
			tmp3491 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('code'));
			};
			tmp3491._prototype_ = null;
			return tmp3491
		})());
		1;
	})();
	(function () {
		null;
		// use Perlito5::AST
;
		// use strict
;
		p5make_package('Perlito5::CompileTime');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::CompileTime', 'emit_compile_time_block', (function () {
					var tmp3492;
					tmp3492 = function (List__, p5want) {
						var v_block;
						v_block = (List__.p5aget(0));
						return ((new p5ArrayRef(p5list_to_a(['block', p5map(p5pkg['Perlito5::CompileTime'], function (p5want) {
	return (p5and((p5make_package('main')['v__'] != null), function () {
		return p5call(p5make_package('main')['v__'], 'emit_compile_time', [], 1)
	}));
}, p5list_to_a([p5array_deref((v_block || (v_block = new p5ArrayRef([]))), 'Perlito5::CompileTime')]))]))));
					};
					tmp3492._prototype_ = null;
					return tmp3492
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::CompUnit');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::CompUnit', 'emit_compile_time', (function () {
					var tmp3493;
					tmp3493 = function (List__, p5want) {
						var v_self;
						(v_self || (v_self = new p5HashRef({})))._hash_.p5hset('body', (p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')]), 0)));
						return (p5context([v_self], p5want));
					};
					tmp3493._prototype_ = null;
					return tmp3493
				})());
				p5typeglob_set('Perlito5::AST::CompUnit', 'emit_compile_time_program', (function () {
					var tmp3494;
					tmp3494 = function (List__, p5want) {
						var v_comp_units;
						v_comp_units = (List__.p5aget(0));
						return (p5map(p5pkg['Perlito5::AST::CompUnit'], function (p5want) {
									return (p5call(p5make_package('main')['v__'], 'emit_compile_time', [], p5want));
								}, p5list_to_a([p5array_deref((v_comp_units || (v_comp_units = new p5ArrayRef([]))), 'Perlito5::AST::CompUnit')])));
					};
					tmp3494._prototype_ = null;
					return tmp3494
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Int');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Int', 'emit_compile_time', (function () {
					var tmp3495;
					tmp3495 = function (List__, p5want) {
						return (p5call(List__.p5aget(0), 'emit_perl5', [], p5want));
					};
					tmp3495._prototype_ = null;
					return tmp3495
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Num');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Num', 'emit_compile_time', (function () {
					var tmp3496;
					tmp3496 = function (List__, p5want) {
						return (p5call(List__.p5aget(0), 'emit_perl5', [], p5want));
					};
					tmp3496._prototype_ = null;
					return tmp3496
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Buf');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Buf', 'emit_compile_time', (function () {
					var tmp3497;
					tmp3497 = function (List__, p5want) {
						return (p5call(List__.p5aget(0), 'emit_perl5', [], p5want));
					};
					tmp3497._prototype_ = null;
					return tmp3497
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Block');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Block', 'emit_compile_time', (function () {
					var tmp3498;
					tmp3498 = function (List__, p5want) {
						var v_self;
						v_self = (List__.p5aget(0));
						var List_out = [];
						p5and((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
								return List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['label', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label')])))]))
							});
						(function () {
								if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')) ) {
								List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(p5list_to_a(['keyword', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')]))), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('stmts')]), 1)])))]));
							}
							else {
								List_out.p5push(p5list_to_a([p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('stmts')]), 1)]));
							}
							})();
						(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('continue')) && p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget_array('stmts'), 'Perlito5::AST::Block')))) ) {
								List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'continue'])), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget('stmts')]), 1)])))]));
							}
							})();
						return ((p5want ? List_out : List_out.length));
					};
					tmp3498._prototype_ = null;
					return tmp3498
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Index');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Index', 'emit_compile_time', (function () {
					var tmp3499;
					tmp3499 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && ((p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '$') || (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@')))) ) {
								throw((new p5ArrayRef(p5list_to_a(['apply', '[', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_compile_time', [], 1), p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_compile_time', [], 1)]))));
							}
							})();
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<%>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '%'))) ) {
								throw((new p5ArrayRef(p5list_to_a(['apply', '[', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_compile_time', [], 1), p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_compile_time', [], 1)]))));
							}
							})();
							(function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<$>')) ) {
								throw((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['op', 'circumfix:<[ ]>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_compile_time', [], 1)])))]))));
							}
							})();
							return ((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['op', 'circumfix:<[ ]>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_compile_time', [], 1)])))]))));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3499._prototype_ = null;
					return tmp3499
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Lookup');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_compile_time', (function () {
					var tmp3500;
					tmp3500 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && ((p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '$') || (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@')))) ) {
								throw((new p5ArrayRef(p5list_to_a(['apply', '{', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_compile_time', [], 1), p5call(p5call(v_self, 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_compile_time', [], 1)]))));
							}
							})();
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<%>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '%'))) ) {
								throw((new p5ArrayRef(p5list_to_a(['apply', '{', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_compile_time', [], 1), p5call(p5call(v_self, 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_compile_time', [], 1)]))));
							}
							})();
							(function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<$>')) ) {
								throw((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['op', 'circumfix:<{ }>', p5call(p5call(v_self, 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_compile_time', [], 1)])))]))));
							}
							})();
							return ((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['op', 'circumfix:<{ }>', p5call(p5call(v_self, 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_compile_time', [], 1)])))]))));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3500._prototype_ = null;
					return tmp3500
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Var');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Var', 'emit_compile_time', (function () {
					var tmp3501;
					tmp3501 = function (List__, p5want) {
						var v_self;
						(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_decl')) == 'my') ) {
								(v_self || (v_self = new p5HashRef({})))._hash_.p5hset('_decl', ('global'));
								(v_self || (v_self = new p5HashRef({})))._hash_.p5hset('namespace', ('MY'));
							}
							})();
						return (p5context([v_self], p5want));
					};
					tmp3501._prototype_ = null;
					return tmp3501
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Call');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Call', 'emit_compile_time', (function () {
					var tmp3502;
					tmp3502 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var v_invocant;
							v_invocant = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), 'emit_compile_time', [], 0));
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')) == 'postcircumfix:<[ ]>') ) {
								throw((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', v_invocant, (new p5ArrayRef(p5list_to_a(['op', 'circumfix:<[ ]>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), 'emit_compile_time', [], 1)])))]))));
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')) == 'postcircumfix:<{ }>') ) {
								throw((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', v_invocant, (new p5ArrayRef(p5list_to_a(['op', 'circumfix:<{ }>', p5call(p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 0), 'emit_compile_time', [], 1)])))]))));
							}
							})();
							var v_meth;
							v_meth = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method'));
							(function () {
								if ( (p5str(v_meth) == 'postcircumfix:<( )>') ) {
								(function () {
									if ( (((p5pkg['Perlito5::AST::Call'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant')], 0) == 'Perlito5::AST::Var') && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget('sigil')) == '&')) || ((p5pkg['Perlito5::AST::Call'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant')], 0) == 'Perlito5::AST::Apply') && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget('code')) == 'prefix:<&>'))) ) {
									throw((new p5ArrayRef(p5list_to_a(['apply', '(', v_invocant, p5map(p5pkg['Perlito5::AST::Call'], function (p5want) {
	return (p5call(p5make_package('main')['v__'], 'emit_compile_time', [], 1));
}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Call')]))]))));
								}
								})();
								v_meth = ('');
							}
							})();
							(function () {
								if ( (p5pkg['Perlito5::AST::Call'].ref([v_meth], 0) == 'Perlito5::AST::Var') ) {
								v_meth = (p5call(v_meth, 'emit_compile_time', [], 0));
							}
							})();
							(function () {
								if ( p5bool(v_meth) ) {
								throw((new p5ArrayRef(p5list_to_a(['call', v_invocant, v_meth, p5map(p5pkg['Perlito5::AST::Call'], function (p5want) {
	return (p5call(p5make_package('main')['v__'], 'emit_compile_time', [], 1));
}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Call')]))]))));
							}
							})();
							return ((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', v_invocant, (new p5ArrayRef(p5list_to_a(['op', 'list:<,>', p5map(p5pkg['Perlito5::AST::Call'], function (p5want) {
	return (p5call(p5make_package('main')['v__'], 'emit_compile_time', [], 1));
}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Call')]))])))]))));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3502._prototype_ = null;
					return tmp3502
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Apply');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Apply', 'emit_compile_time_args', (function () {
					var tmp3503;
					tmp3503 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							p5and(!( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'))), function () {
								throw(p5context([], p5want))
							});
							return (p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
									return (p5call(p5make_package('main')['v__'], 'emit_compile_time', [], p5want));
								}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')])));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3503._prototype_ = null;
					return tmp3503
				})());
				p5typeglob_set('Perlito5::AST::Apply', 'emit_compile_time', (function () {
					var tmp3504;
					tmp3504 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							(function () {
								if ( p5bool(p5pkg['Perlito5::AST::Apply'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')], 0)) ) {
								throw((new p5ArrayRef(p5list_to_a(['op', 'infix:<->>', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'), 'emit_compile_time', [], 1), p5call(v_self, 'emit_compile_time_args', [], 1)]))));
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) == 'infix:<=>>') ) {
								throw((new p5ArrayRef(p5list_to_a(['op', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'), p5call(p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0), 'emit_compile_time', [], 1), p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), 'emit_compile_time', [], 1)]))));
							}
							})();
							(function () {
								if ( p5bool(p5pkg[p5make_package('Perlito5::Perl5::PrettyPrinter')['Hash_op'] || (p5make_package('Perlito5::Perl5::PrettyPrinter')['Hash_op'] = {}), 'Perlito5::Perl5::PrettyPrinter']['Hash_op'].p5hget(p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')))) ) {
								throw((new p5ArrayRef(p5list_to_a(['op', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'), p5call(v_self, 'emit_compile_time_args', [], 1)]))));
							}
							})();
							var v_ns;
							v_ns = ('');
							(function () {
								if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) ) {
								v_ns = ((p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) + '::'));
							}
							})();
							var v_code;
							v_code = ((p5str(v_ns) + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'))));
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) == 'p5:s') ) {
								throw(p5context([('s!' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('buf')) + '!' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(1)._hash_.p5hget('buf')) + '!' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(2)._hash_.p5hget('buf')))], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) == 'p5:m') ) {
								(function () {
									var v_s;
									(function () {
										if ( p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'isa', ['Perlito5::AST::Buf'], 0)) ) {
										v_s = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('buf'));
									}
									else {
										(function () {
											var v_ast;
											(function(){ var v_ast; p5for_lex(function (v) { v_ast = v }, function () {
													(function () {
														if ( p5bool(p5call(v_ast, 'isa', ['Perlito5::AST::Buf'], 0)) ) {
														(v_s = ((p5str(v_s) + p5str((v_ast || (v_ast = new p5HashRef({})))._hash_.p5hget('buf')))));
													}
													else {
														(v_s = ((p5str(v_s) + p5str(p5call(v_ast, 'emit_compile_time', [], 0)))));
													}
													})();
												}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]), false, '') })()
										})();
									}
									})();
									throw(p5context([('m!' + p5str(v_s) + '!' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(1)._hash_.p5hget('buf')))], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) == 'p5:tr') ) {
								throw(p5context([('tr!' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('buf')) + '!' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(1)._hash_.p5hget('buf')) + '!')], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) == 'package') ) {
								throw((new p5ArrayRef(p5list_to_a(['stmt', 'package', (new p5ArrayRef(p5list_to_a(['bareword', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')])))]))));
							}
							})();
							(function () {
								if ( ((p5str(v_code) == 'map') || ((p5str(v_code) == 'grep') || (p5str(v_code) == 'sort'))) ) {
								(function () {
									if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
									throw((new p5ArrayRef(p5list_to_a(['op', ('prefix:<' + p5str(v_code) + '>'), (new p5ArrayRef(p5list_to_a(['block', p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
	return (p5call(p5make_package('main')['v__'], 'emit_compile_time', [], 1));
}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('special_arg')._hash_.p5hget_array('stmts'), 'Perlito5::AST::Apply')]))]))), (new p5ArrayRef(p5list_to_a(['op', 'list:<,>', p5call(v_self, 'emit_compile_time_args', [], 1)])))]))));
								}
								})();
								throw((new p5ArrayRef(p5list_to_a(['apply', '(', v_code, p5call(v_self, 'emit_compile_time_args', [], 1)]))));
							}
							})();
							(function () {
								if ( (((p5str(v_code) == 'eval') || (p5str(v_code) == 'do')) && (p5pkg['Perlito5::AST::Apply'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)], 0) == 'Perlito5::AST::Block')) ) {
								throw((new p5ArrayRef(p5list_to_a(['op', ('prefix:<' + p5str(v_code) + '>'), p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_compile_time', [], 1)]))));
							}
							})();
							(function () {
								if ( (p5str(v_code) == 'readline') ) {
								throw((new p5ArrayRef(p5list_to_a(['paren', '<', p5call(v_self, 'emit_compile_time_args', [], 1)]))));
							}
							})();
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('bareword')) && !( p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply'))))) ) {
								throw((new p5ArrayRef(['bareword', v_code])));
							}
							})();
							return ((new p5ArrayRef(p5list_to_a(['apply', '(', v_code, p5call(v_self, 'emit_compile_time_args', [], 1)]))));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3504._prototype_ = null;
					return tmp3504
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::If');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::If', 'emit_compile_time', (function () {
					var tmp3505;
					tmp3505 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')) && (p5pkg['Perlito5::AST::If'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block')) ) {
								throw((new p5ArrayRef(p5list_to_a(['stmt_modifier', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['stmt', 'if', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)])))]))));
							}
							})();
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise')) && (p5pkg['Perlito5::AST::If'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise')], 0) != 'Perlito5::AST::Block')) ) {
								throw((new p5ArrayRef(p5list_to_a(['stmt_modifier', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise'), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['stmt', 'unless', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)])))]))));
							}
							})();
							var List_out = [];
							List_out = p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'if'])), (new p5ArrayRef(p5list_to_a(['paren', '(', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)]))), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1)]), 1)])))]);
							var v_otherwise;
							v_otherwise = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise'));
							(function () {
								p5while(function () {
									List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'elsif'])), (new p5ArrayRef(p5list_to_a(['paren', '(', p5call((v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts')._array_.p5aget_hash(0)._hash_.p5hget('cond'), 'emit_compile_time', [], 1)]))), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts')._array_.p5aget_hash(0)._hash_.p5hget_hash('body')._hash_.p5hget('stmts')]), 1)])))]));
									v_otherwise = ((v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts')._array_.p5aget_hash(0)._hash_.p5hget('otherwise'));
								}, function () {
									return p5and(v_otherwise, function () {
										return p5and((p5num(p5num(p5array_deref((v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts'), 'Perlito5::AST::If'))) == 1), function () {
											return p5and((p5pkg['Perlito5::AST::If'].ref([(v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts')._array_.p5aget(0)], 0) == 'Perlito5::AST::If'), function () {
												return p5context([p5and((v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts')._array_.p5aget_hash(0)._hash_.p5hget('body'), function () {
													return (p5pkg['Perlito5::AST::If'].ref([(v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('stmts')._array_.p5aget_hash(0)._hash_.p5hget('body')], 0) == 'Perlito5::AST::Block')
												})], 0)
											})
										})
									})
								}, false, '', 0)
							})();
							p5and(!( (p5bool(v_otherwise) && p5bool((p5num(p5array_deref(p5call(v_otherwise, 'stmts', [], p5want), 'Perlito5::AST::If')))))), function () {
								throw((p5want ? List_out : List_out.length))
							});
							List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'else'])), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([p5call(v_otherwise, 'stmts', [], 1)]), 1)])))]));
							return ((p5want ? List_out : List_out.length));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3505._prototype_ = null;
					return tmp3505
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::When');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::When', 'emit_compile_time', (function () {
					var tmp3506;
					tmp3506 = function (List__, p5want) {
						var v_self;
						v_self = (List__.p5aget(0));
						return ((new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'when'])), (new p5ArrayRef(p5list_to_a(['paren', '(', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)]))), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1)]), 1)]))));
					};
					tmp3506._prototype_ = null;
					return tmp3506
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::While');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::While', 'emit_compile_time', (function () {
					var tmp3507;
					tmp3507 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var List_out = [];
							p5and((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
								return List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['label', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label')])))]))
							});
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')) && (p5pkg['Perlito5::AST::While'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block')) ) {
								throw(p5context([(p5want ? List_out : List_out.length), (new p5ArrayRef(p5list_to_a(['stmt_modifier', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'while'])), p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)])))])))], p5want));
							}
							})();
							List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'while'])), (new p5ArrayRef(p5list_to_a(['paren', '(', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)]))), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1)]), 1)])))]));
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('continue')) && p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget_array('stmts'), 'Perlito5::AST::While')))) ) {
								List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'continue'])), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget('stmts')]), 1)])))]));
							}
							})();
							return ((p5want ? List_out : List_out.length));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3507._prototype_ = null;
					return tmp3507
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::For');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::For', 'emit_compile_time', (function () {
					var tmp3508;
					tmp3508 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var List_out = [];
							p5and((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
								return List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['label', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label')])))]))
							});
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')) && (p5pkg['Perlito5::AST::For'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block')) ) {
								throw(p5context([(p5want ? List_out : List_out.length), (new p5ArrayRef(p5list_to_a(['stmt_modifier', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'emit_compile_time', [], 1), (new p5ArrayRef(p5list_to_a(['stmt', 'for', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)])))])))], p5want));
							}
							})();
							var v_cond;
							(function () {
								if ( (p5pkg['Perlito5::AST::For'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond')], 0) == 'ARRAY') ) {
								v_cond = ((new p5ArrayRef(p5list_to_a(['paren_semicolon', '(', ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(0)) ? p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(0), 'emit_compile_time', [], 1) : (new p5ArrayRef([]))), ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(1)) ? p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(1), 'emit_compile_time', [], 1) : (new p5ArrayRef([]))), ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(2)) ? p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(2), 'emit_compile_time', [], 1) : (new p5ArrayRef([])))]))));
							}
							else {
								v_cond = ((new p5ArrayRef(p5list_to_a(['paren', '(', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'), 'emit_compile_time', [], 1)]))));
							}
							})();
							var List_sig = [];
							var v_sig_ast;
							v_sig_ast = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('topic'));
							(function () {
								if ( !( p5bool(v_sig_ast)) ) {}
							else {
								List_sig = p5list_to_a([p5call(v_sig_ast, 'emit_compile_time', [], 1)]);
							}
							})();
							List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'for'])), List_sig, v_cond, p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1)]), 1)])))]));
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('continue')) && p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget_array('stmts'), 'Perlito5::AST::For')))) ) {
								List_out.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'continue'])), p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget('stmts')]), 1)])))]));
							}
							})();
							return ((p5want ? List_out : List_out.length));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3508._prototype_ = null;
					return tmp3508
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Decl');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Decl', 'emit_compile_time', (function () {
					var tmp3509;
					tmp3509 = function (List__, p5want) {
						var v_self;
						v_self = (List__.p5aget(0));
						return (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'emit_compile_time', [], p5want));
					};
					tmp3509._prototype_ = null;
					return tmp3509
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Sub');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Sub', 'emit_compile_time', (function () {
					var tmp3510;
					tmp3510 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var List_parts = [];
							p5and(((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sig') != null), function () {
								return List_parts.p5push(p5list_to_a([(new p5ArrayRef(p5list_to_a(['paren', '(', (new p5ArrayRef(p5list_to_a(['bareword', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sig')])))])))]))
							});
							p5and(((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('block') != null), function () {
								return List_parts.p5push(p5list_to_a([p5pkg['Perlito5::CompileTime'].emit_compile_time_block(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('block')._hash_.p5hget('stmts')]), 1)]))
							});
							p5and(!( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name'))), function () {
								throw((new p5ArrayRef(p5list_to_a(['op', 'prefix:<sub>', List_parts]))))
							});
							return ((new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'sub'])), (new p5ArrayRef(['bareword', (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) + '::' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')))])), List_parts]))));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3510._prototype_ = null;
					return tmp3510
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Use');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Use', 'emit_compile_time', (function () {
					var tmp3511;
					tmp3511 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.shift());
							p5call_sub('Perlito5::Grammar::Use', 'emit_time_eval', [v_self], null);
							return (function () {
								if ( p5bool(p5make_package('Perlito5')['v_EMIT_USE']) ) {
								(function () {
									throw((new p5ArrayRef(p5list_to_a(['stmt', (new p5ArrayRef(['keyword', 'use'])), (new p5ArrayRef(p5list_to_a(['bareword', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('mod')])))]))))
								})()
							}
							else {
								(function () {
									throw((new p5ArrayRef(['comment', ('# ' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) + ' ' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('mod')))])))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3511._prototype_ = null;
					return tmp3511
				})());
			}, [0], false, ''
		);
		1;
	})();
	// use Perlito5::CompileTime::Emitter
;
	(function () {
		p5make_package('Perlito5::CompileTime::Dumper');
		// use strict
;
		p5typeglob_set('Perlito5::CompileTime::Dumper', 'generate_eval_string', (function () {
			var tmp3512;
			tmp3512 = function (List__, p5want) {
				var v_source;
				var tmp3513 = p5list_to_a([List__]);
					v_source = tmp3513.shift();
				var v_m;
				v_m = (p5pkg['Perlito5::Grammar'].exp_stmts([v_source, 0], 0));
				var v_block;
				v_block = (p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', p5pkg['Perlito5::Match'].flat([v_m], 1)]), 0));
				var List_data = [];
				List_data = p5list_to_a([p5call(v_block, 'emit_perl5', [], 1)]);
				var v_out;
				v_out = ((new p5ArrayRef([])));
				p5pkg['Perlito5::Perl5::PrettyPrinter'].pretty_print(p5list_to_a([(new p5ArrayRef(List_data)), 0, v_out]), null);
				var v_source_new;
				p5list_to_a([(v_source_new = (p5pkg['Perlito5::CompileTime::Dumper'].join([''].concat(p5list_to_a([p5array_deref((v_out || (v_out = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper')])), 0))), ';1' + String.fromCharCode(10)]);
				return (p5context([v_source_new], p5want));
			};
			tmp3512._prototype_ = null;
			return tmp3512
		})());
		p5typeglob_set('Perlito5::CompileTime::Dumper', '_dumper', (function () {
			var tmp3514;
			tmp3514 = function (List__, p5want) {
				try {
					var v_obj;
					var v_tab;
					var v_seen;
					var v_pos;
					var tmp3515 = p5list_to_a([List__]);
					v_obj = tmp3515.shift();
					v_tab = tmp3515.shift();
					v_seen = tmp3515.shift();
					v_pos = tmp3515.shift();
					p5and(!( (v_obj != null)), function () {
						throw(p5context(['undef'], p5want))
					});
					var v_ref;
					v_ref = (p5pkg['Perlito5::CompileTime::Dumper'].ref([v_obj], 0));
					p5and(!( p5bool(v_ref)), function () {
						throw(p5pkg['Perlito5::Dumper'].escape_string([v_obj], p5want))
					});
					var v_as_string;
					v_as_string = (v_obj);
					p5and((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_as_string)), function () {
						throw((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_as_string)))
					});
					(v_seen || (v_seen = new p5HashRef({})))._hash_.p5hset(p5str(v_as_string), (v_pos));
					var v_tab1;
					v_tab1 = ((p5str(v_tab) + '    '));
					(function () {
						if ( (p5str(v_ref) == 'ARRAY') ) {
						(function () {
							p5or(p5num(p5array_deref((v_obj || (v_obj = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper')), function () {
								throw(p5context(['[]'], p5want))
							});
							var List_out = [];
							(function () {
								var v_i;
								(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
										var v_here;
										v_here = ((p5str(v_pos) + '->[' + p5str(v_i) + ']'));
										List_out.p5push(p5list_to_a([v_tab1, p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([(v_obj || (v_obj = new p5ArrayRef([])))._array_.p5aget(p5num(v_i)), v_tab1, v_seen, v_here]), 1), ',' + String.fromCharCode(10)]));
									}, p5list_to_a([p5range(0, (p5array_deref((v_obj || (v_obj = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').length - 1), 1, "tmp3516", 0)]), false, '') })()
							})();
							throw(p5context([p5pkg['Perlito5::CompileTime::Dumper'].join([''].concat(p5list_to_a(['[' + String.fromCharCode(10), List_out, v_tab, ']'])), p5want)], p5want));
						})();
					}
					else (function () {
						if ( (p5str(v_ref) == 'HASH') ) {
						(function () {
							p5or(p5pkg['Perlito5::CompileTime::Dumper'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::CompileTime::Dumper')], 0), function () {
								throw(p5context(['{}'], p5want))
							});
							var List_out = [];
							(function () {
								var v_i;
								(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
										var v_here;
										v_here = ((p5str(v_pos) + '->{' + p5str(v_i) + '}'));
										List_out.p5push(p5list_to_a([v_tab1, (String.fromCharCode(39) + p5str(v_i) + String.fromCharCode(39) + ' => '), p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([(v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget(p5str(v_i)), v_tab1, v_seen, v_here]), 1), ',' + String.fromCharCode(10)]));
									}, p5list_to_a([p5sort(p5pkg['Perlito5::CompileTime::Dumper'], function (p5want) {
										return (p5cmp(p5str(p5make_package('Perlito5::CompileTime::Dumper')['v_a']), p5str(p5make_package('Perlito5::CompileTime::Dumper')['v_b'])));
									}, p5list_to_a([p5pkg['Perlito5::CompileTime::Dumper'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::CompileTime::Dumper')], 1)]))]), false, '') })()
							})();
							throw(p5context([p5pkg['Perlito5::CompileTime::Dumper'].join([''].concat(p5list_to_a(['{' + String.fromCharCode(10), List_out, v_tab, '}'])), p5want)], p5want));
						})();
					}
					else (function () {
						if ( ((p5str(v_ref) == 'SCALAR') || (p5str(v_ref) == 'REF')) ) {
						throw(p5context([(String.fromCharCode(92) + p5str(p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([p5scalar_deref(v_obj, 'Perlito5::CompileTime::Dumper', ""), v_tab1, v_seen, v_pos]), 0)))], p5want));
					}
					else (function () {
						if ( (p5str(v_ref) == 'CODE') ) {
						(function () {
							var v_closure_flag;
							v_closure_flag = (p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({})), 'Perlito5::dump'], 0));
							var v_captures;
							v_captures = (p5defined_or((v_obj)([v_closure_flag], 0), function () {
										return (new p5HashRef({}))
									}));
							var List_vars = [];
							(function () {
								var v_var;
								(function(){ var v_var; p5for_lex(function (v) { v_var = v }, function () {
										List_vars.p5push([('my ' + p5str(v_var) + ' = ' + p5str(p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([(v_captures || (v_captures = new p5HashRef({})))._hash_.p5hget(p5str(v_var)), v_tab1, v_seen, v_pos]), 0)) + '; ')]);
									}, p5list_to_a([p5pkg['Perlito5::CompileTime::Dumper'].keys([p5hash_deref((v_captures || (v_captures = new p5HashRef({}))), 'Perlito5::CompileTime::Dumper')], 1)]), false, '') })()
							})();
							throw(p5context([p5pkg['Perlito5::CompileTime::Dumper'].join([''].concat(p5list_to_a(['do { ', List_vars, 'sub { "DUMMY" } ', '}'])), p5want)], p5want));
						})();
					}
					})()
					})()
					})()
					})();
					var List_out = [];
					(function () {
						var v_i;
						(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
								var v_here;
								v_here = ((p5str(v_pos) + '->{' + p5str(v_i) + '}'));
								List_out.p5push(p5list_to_a([v_tab1, (String.fromCharCode(39) + p5str(v_i) + String.fromCharCode(39) + ' => '), p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([(v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget(p5str(v_i)), v_tab1, v_seen, v_here]), 1), ',' + String.fromCharCode(10)]));
							}, p5list_to_a([p5sort(p5pkg['Perlito5::CompileTime::Dumper'], function (p5want) {
								return (p5cmp(p5str(p5make_package('Perlito5::CompileTime::Dumper')['v_a']), p5str(p5make_package('Perlito5::CompileTime::Dumper')['v_b'])));
							}, p5list_to_a([p5pkg['Perlito5::CompileTime::Dumper'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::CompileTime::Dumper')], 1)]))]), false, '') })()
					})();
					return (p5context([p5pkg['Perlito5::CompileTime::Dumper'].join([''].concat(p5list_to_a(['bless({' + String.fromCharCode(10), List_out, v_tab, ('}, ' + String.fromCharCode(39) + p5str(v_ref) + String.fromCharCode(39) + ')')])), p5want)], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3514._prototype_ = null;
			return tmp3514
		})());
		p5typeglob_set('Perlito5::CompileTime::Dumper', '_dump_global', (function () {
			var tmp3517;
			tmp3517 = function (List__, p5want) {
				try {
					var v_item;
					var v_seen;
					var v_dumper_seen;
					var v_vars;
					var v_tab;
					var tmp3518 = p5list_to_a([List__]);
					v_item = tmp3518.shift();
					v_seen = tmp3518.shift();
					v_dumper_seen = tmp3518.shift();
					v_vars = tmp3518.shift();
					v_tab = tmp3518.shift();
					var v_n;
					v_n = ((p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) + p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('namespace')) + '::' + p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('name'))));
					return (function () {
						if ( !( p5bool((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_n)))) ) {
						(function () {
							if ( (p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) == '$') ) {
							p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + (p5str(v_n) + ' = ') + p5str(p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([(function () {
	var p5want = 1;
	var r;
	p5pkg["main"]["v_@"] = "";
	var p5strict = p5pkg["Perlito5"]["v_STRICT"];
	p5pkg["Perlito5"]["v_STRICT"] = 1;
	try {
		r = eval(p5pkg["Perlito5::Javascript2::Runtime"].perl5_to_js([p5str(v_n), 'Perlito5::CompileTime::Dumper', 'list', (new p5ArrayRef(p5list_to_a([(new p5HashRef(p5a_to_h(p5list_to_a(['block', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 591, '_namespace' : 'Perlito5::Grammar::Scope', 'name' : 'Special_var', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 587, '_namespace' : 'Perlito5', 'name' : 'CORE_PROTO', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 586, '_namespace' : 'Perlito5', 'name' : 'CORE_OVERRIDABLE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 585, '_namespace' : 'Perlito5', 'name' : 'SPECIAL_VAR', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '_', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', '_real_sigil' : '%', 'name' : 'ENV', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '_', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : 'INC', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 584, '_namespace' : 'Perlito5', 'name' : 'PACKAGES', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 583, '_namespace' : 'Perlito5', 'name' : 'ID', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 582, '_namespace' : 'Perlito5', 'name' : 'SCOPE_STMT', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 581, '_namespace' : 'Perlito5', 'name' : 'SCOPE_DEPTH', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 579, '_namespace' : 'Perlito5', 'name' : 'BASE_SCOPE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 580, '_namespace' : 'Perlito5', 'name' : 'SCOPE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 579, '_namespace' : 'Perlito5', 'name' : 'BASE_SCOPE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 578, '_namespace' : 'Perlito5', 'name' : 'FILE_NAME', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 577, '_namespace' : 'Perlito5', 'name' : 'LINE_NUMBER', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 576, '_namespace' : 'Perlito5', 'name' : 'PKG_NAME', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 575, '_namespace' : 'Perlito5', 'name' : 'DATA_SECTION', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 574, '_namespace' : 'Perlito5', 'name' : 'CALLER', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 573, '_namespace' : 'Perlito5', 'name' : 'BYTES', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 572, '_namespace' : 'Perlito5', 'name' : 'UTF8', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 571, '_namespace' : 'Perlito5', 'name' : 'WARNINGS', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 570, '_namespace' : 'Perlito5', 'name' : 'STRICT', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 569, '_namespace' : 'Perlito5', 'name' : 'EMIT_USE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 568, '_namespace' : 'Perlito5', 'name' : 'EXPAND_USE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ']', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ']', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '?', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '?', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ';', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ';', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '!', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '!', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ',', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ',', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '"', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '"', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '/', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '/', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 339, 'name' : 'Op_chars', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 338, 'name' : 'Op', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 337, 'name' : 'End_token_chars', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 336, 'name' : 'End_token', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 333, 'name' : 'Term', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 332, 'name' : 'Term_chars', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 331, 'name' : 'Parsed_op', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 330, 'name' : 'Parsed_op_chars', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 323, 'name' : 'Assoc', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 322, 'name' : 'PrefixPrecedence', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 321, 'name' : 'Precedence', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 320, 'name' : 'Operator', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 112, 'name' : 'Use', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 112, 'name' : 'Use', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 101, 'name' : '_V5_COMPILER_VERSION', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 114, 'name' : 'copyright_message', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 113, 'name' : 'help_message', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 112, 'name' : 'Use', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 111, 'name' : 'wrapper_priority', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 110, 'name' : 'wrapper_end', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 109, 'name' : 'wrapper_begin', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 108, 'name' : 'bootstrapping', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 107, 'name' : 'boilerplate', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 106, 'name' : 'expand_use', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 105, 'name' : 'verbose', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 104, 'name' : 'execute', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 103, 'name' : 'backend', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 102, 'name' : 'source', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 101, 'name' : '_V5_COMPILER_VERSION', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 100, 'name' : '_V5_COMPILER_NAME', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 705, 'name' : 'n', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '_', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 704, 'name' : 'tab', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 703, 'name' : 'vars', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 702, 'name' : 'dumper_seen', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 701, 'name' : 'seen', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 705, 'name' : 'n', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 701, 'name' : 'seen', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1)])))]))))])))]))
	}
	catch(err) {
		if (err instanceof p5_error && (err.type == 'last' || err.type == 'redo' || err.type == 'next')) {
			throw(err)
		}
		else if ( err instanceof p5_error || err instanceof Error ) {
			p5pkg["main"]["v_@"] = err;
			if (p5str(p5pkg["main"]["v_@"]).substr(-1, 1) != "\n") {
				try {
					p5pkg["main"]["v_@"] = p5pkg["main"]["v_@"] + "\n" + err.stack + "\n";
				}
				catch(err) { }
			}
		}
		else {
			return(err);
		}
	}
	p5pkg["Perlito5"]["v_STRICT"] = p5strict;
	return r;
})(), '  ', v_dumper_seen, v_n]), 0)) + ';' + String.fromCharCode(10))]);
						}
						else (function () {
							if ( ((p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) == '@') || (p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) == '%')) ) {
							(function () {
								var v_ref;
								v_ref = ((String.fromCharCode(92) + p5str(v_n)));
								var v_d;
								v_d = (p5pkg['Perlito5::CompileTime::Dumper']._dumper(p5list_to_a([(function () {
	var p5want = 1;
	var r;
	p5pkg["main"]["v_@"] = "";
	var p5strict = p5pkg["Perlito5"]["v_STRICT"];
	p5pkg["Perlito5"]["v_STRICT"] = 1;
	try {
		r = eval(p5pkg["Perlito5::Javascript2::Runtime"].perl5_to_js([p5str(v_ref), 'Perlito5::CompileTime::Dumper', 'list', (new p5ArrayRef(p5list_to_a([(new p5HashRef(p5a_to_h(p5list_to_a(['block', (new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 591, '_namespace' : 'Perlito5::Grammar::Scope', 'name' : 'Special_var', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 587, '_namespace' : 'Perlito5', 'name' : 'CORE_PROTO', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 586, '_namespace' : 'Perlito5', 'name' : 'CORE_OVERRIDABLE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 585, '_namespace' : 'Perlito5', 'name' : 'SPECIAL_VAR', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '_', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', '_real_sigil' : '%', 'name' : 'ENV', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '_', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : 'INC', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 584, '_namespace' : 'Perlito5', 'name' : 'PACKAGES', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 583, '_namespace' : 'Perlito5', 'name' : 'ID', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 582, '_namespace' : 'Perlito5', 'name' : 'SCOPE_STMT', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 581, '_namespace' : 'Perlito5', 'name' : 'SCOPE_DEPTH', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 579, '_namespace' : 'Perlito5', 'name' : 'BASE_SCOPE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 580, '_namespace' : 'Perlito5', 'name' : 'SCOPE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 579, '_namespace' : 'Perlito5', 'name' : 'BASE_SCOPE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 578, '_namespace' : 'Perlito5', 'name' : 'FILE_NAME', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 577, '_namespace' : 'Perlito5', 'name' : 'LINE_NUMBER', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 576, '_namespace' : 'Perlito5', 'name' : 'PKG_NAME', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 575, '_namespace' : 'Perlito5', 'name' : 'DATA_SECTION', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 574, '_namespace' : 'Perlito5', 'name' : 'CALLER', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 573, '_namespace' : 'Perlito5', 'name' : 'BYTES', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 572, '_namespace' : 'Perlito5', 'name' : 'UTF8', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 571, '_namespace' : 'Perlito5', 'name' : 'WARNINGS', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 570, '_namespace' : 'Perlito5', 'name' : 'STRICT', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 569, '_namespace' : 'Perlito5', 'name' : 'EMIT_USE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'our', '_id' : 568, '_namespace' : 'Perlito5', 'name' : 'EXPAND_USE', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ']', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ']', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '?', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '?', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ';', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ';', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '!', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '!', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ',', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : ',', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '"', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '"', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '/', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '/', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 365, 'name' : 'prec', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 339, 'name' : 'Op_chars', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 338, 'name' : 'Op', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 337, 'name' : 'End_token_chars', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 336, 'name' : 'End_token', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 333, 'name' : 'Term', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 332, 'name' : 'Term_chars', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 331, 'name' : 'Parsed_op', 'namespace' : '', 'sigil' : '%'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 330, 'name' : 'Parsed_op_chars', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 323, 'name' : 'Assoc', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 322, 'name' : 'PrefixPrecedence', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 321, 'name' : 'Precedence', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 320, 'name' : 'Operator', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 112, 'name' : 'Use', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 112, 'name' : 'Use', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 101, 'name' : '_V5_COMPILER_VERSION', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 114, 'name' : 'copyright_message', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 113, 'name' : 'help_message', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 112, 'name' : 'Use', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 111, 'name' : 'wrapper_priority', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 110, 'name' : 'wrapper_end', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 109, 'name' : 'wrapper_begin', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 108, 'name' : 'bootstrapping', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 107, 'name' : 'boilerplate', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 106, 'name' : 'expand_use', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 105, 'name' : 'verbose', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 104, 'name' : 'execute', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 103, 'name' : 'backend', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 102, 'name' : 'source', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 101, 'name' : '_V5_COMPILER_VERSION', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 100, 'name' : '_V5_COMPILER_NAME', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 705, 'name' : 'n', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'global', '_namespace' : 'main', 'name' : '_', 'namespace' : '', 'sigil' : '@'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 704, 'name' : 'tab', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 703, 'name' : 'vars', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 702, 'name' : 'dumper_seen', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 701, 'name' : 'seen', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 705, 'name' : 'n', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 701, 'name' : 'seen', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 700, 'name' : 'item', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 705, 'name' : 'n', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1), p5pkg['Perlito5::CompileTime::Dumper'].bless([(new p5HashRef({'_decl' : 'my', '_id' : 706, 'name' : 'ref', 'namespace' : '', 'sigil' : '$'})), 'Perlito5::AST::Var'], 1)])))]))))])))]))
	}
	catch(err) {
		if (err instanceof p5_error && (err.type == 'last' || err.type == 'redo' || err.type == 'next')) {
			throw(err)
		}
		else if ( err instanceof p5_error || err instanceof Error ) {
			p5pkg["main"]["v_@"] = err;
			if (p5str(p5pkg["main"]["v_@"]).substr(-1, 1) != "\n") {
				try {
					p5pkg["main"]["v_@"] = p5pkg["main"]["v_@"] + "\n" + err.stack + "\n";
				}
				catch(err) { }
			}
		}
		else {
			return(err);
		}
	}
	p5pkg["Perlito5"]["v_STRICT"] = p5strict;
	return r;
})(), (p5str(v_tab) + '  '), v_dumper_seen, v_ref]), 0));
								(function () {
									if ( ((p5str(v_d) == '[]') || (p5str(v_d) == '{}')) ) {
									p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + (p5str(v_n) + ' = ();' + String.fromCharCode(10)))]);
								}
								else {
									p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + (p5str(v_n) + ' = ') + p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) + '{' + p5str(v_d) + '};' + String.fromCharCode(10))]);
								}
								})();
							})();
						}
						else (function () {
							if ( (p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) == '*') ) {
							p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + ('# ' + p5str(v_n) + String.fromCharCode(10)))]);
							p5for(p5make_package('main'), "v__", function () {
									var local_idx = p5LOCAL.length;
									(function () {
										var v_tmp3519 = (v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil');
										p5LOCAL.push(function(){ (v_item || (v_item = new p5HashRef({})))._hash_.p5hset('sigil', (v_tmp3519)) });
										return (v_item || (v_item = new p5HashRef({})))._hash_.p5hset('sigil', (null));
									})();
									(v_item || (v_item = new p5HashRef({})))._hash_.p5hset('sigil', (p5make_package('main')['v__']));
									p5pkg['Perlito5::CompileTime::Dumper']._dump_global([v_item, v_seen, v_dumper_seen, v_vars, v_tab], null);
									p5cleanup_local(local_idx, null);
								}, ['$', '@', '%'], false, '');
						}
						})()
						})()
						})();
						return ((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hset(p5str(v_n), (1)));
					}
					})()
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3517._prototype_ = null;
			return tmp3517
		})());
		p5typeglob_set('Perlito5::CompileTime::Dumper', '_emit_globals', (function () {
			var tmp3520;
			tmp3520 = function (List__, p5want) {
				try {
					var v_scope;
					var v_seen;
					var v_dumper_seen;
					var v_vars;
					var v_tab;
					var tmp3521 = p5list_to_a([List__]);
					v_scope = tmp3521.shift();
					v_seen = tmp3521.shift();
					v_dumper_seen = tmp3521.shift();
					v_vars = tmp3521.shift();
					v_tab = tmp3521.shift();
					var v_block;
					v_block = ((v_scope || (v_scope = new p5HashRef({})))._hash_.p5hget('block'));
					(function () {
						var v_item;
						(function(){ var v_item; p5for_lex(function (v) { v_item = v }, function () {
								(function () {
									if ( ((p5pkg['Perlito5::CompileTime::Dumper'].ref([v_item], 0) == 'Perlito5::AST::Var') && !( p5bool((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_decl')))) ) {
									(v_item || (v_item = new p5HashRef({})))._hash_.p5hset('_decl', ('global'));
								}
								})();
								(function () {
									if ( ((p5pkg['Perlito5::CompileTime::Dumper'].ref([v_item], 0) == 'Perlito5::AST::Var') && (p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_decl')) == 'global')) ) {
									(v_item || (v_item = new p5HashRef({})))._hash_.p5hset('namespace', (p5or((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
												return (v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_namespace')
											})));
									p5and(p5or((p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('name')) == '0'), function () {
										return (p5num((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('name')) > 0)
									}), function () {
										throw(new p5_error("next", ''))
									});
									p5pkg['Perlito5::CompileTime::Dumper']._dump_global([v_item, v_seen, v_dumper_seen, v_vars, v_tab], null);
								}
								})();
								(function () {
									if ( ((p5pkg['Perlito5::CompileTime::Dumper'].ref([v_item], 0) == 'Perlito5::AST::Var') && (p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_decl')) == 'my')) ) {
									(function () {
										var v_id;
										v_id = ((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('_id'));
										(function () {
											if ( !( p5bool((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_id)))) ) {
											p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + '# my ' + p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('sigil')) + p5str((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('name')) + ';' + String.fromCharCode(10))]);
										}
										})();
										(v_seen || (v_seen = new p5HashRef({})))._hash_.p5hset(p5str(v_id), (1));
									})();
								}
								})();
								return (function () {
									if ( ((p5pkg['Perlito5::CompileTime::Dumper'].ref([v_item], 0) == 'HASH') && p5bool((v_item || (v_item = new p5HashRef({})))._hash_.p5hget('block'))) ) {
									p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + '{' + String.fromCharCode(10))]);
									p5pkg['Perlito5::CompileTime::Dumper']._emit_globals([v_item, v_seen, v_dumper_seen, v_vars, (p5str(v_tab) + '  ')], null);
									return (p5array_deref((v_vars || (v_vars = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper').p5push([(p5str(v_tab) + '}' + String.fromCharCode(10))]));
								}
								})()
							}, p5list_to_a([p5array_deref((v_block || (v_block = new p5ArrayRef([]))), 'Perlito5::CompileTime::Dumper')]), false, '') })()
					})()
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3520._prototype_ = null;
			return tmp3520
		})());
		p5typeglob_set('Perlito5::CompileTime::Dumper', 'emit_globals', (function () {
			var tmp3522;
			tmp3522 = function (List__, p5want) {
				var v_scope;
				v_scope = (p5defined_or(List__.shift(), function () {
								return p5make_package('Perlito5')['v_BASE_SCOPE']
							}));
				var List_vars = [];
				var Hash_seen = {};
				var v_dumper_seen;
				v_dumper_seen = ((new p5HashRef({})));
				var v_tab;
				v_tab = ('');
				p5pkg['Perlito5::CompileTime::Dumper']._emit_globals(p5list_to_a([v_scope, (new p5HashRef(Hash_seen)), v_dumper_seen, (new p5ArrayRef(List_vars)), v_tab]), null);
				return (p5context([p5pkg['Perlito5::CompileTime::Dumper'].join([''].concat(p5list_to_a([List_vars])), p5want)], p5want));
			};
			tmp3522._prototype_ = null;
			return tmp3522
		})());
		1;
	})();
	// use Perlito5::CompileTime::Dumper
;
	(function () {
		p5block(function (v) {}, function () {
				p5make_package('main');
				p5make_package('Perlito5::Grammar::Regex6');
				// use Perlito5::Grammar::Precedence
;
				p5typeglob_set('Perlito5::Grammar::Regex6', 'term_token', (function () {
					var tmp3523;
					tmp3523 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([p5and(('token' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 5)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((5 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												var v_m2;
												v_m2 = (p5pkg['Perlito5::Grammar'].ident(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
												return (function () {
													if ( p5bool(v_m2) ) {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::ident', (v_m2));
													return ((1));
												}
												else {
													return ((0));
												}
												})()
											})()], 0), function () {
												return p5and(p5context([(function () {
													var v_m2;
													v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
													return (function () {
														if ( p5bool(v_m2) ) {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
														return ((1));
													}
													else {
														return ((0));
													}
													})()
												})()], 0), function () {
													return p5and(p5context([p5and(('{' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0), function () {
														return p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].rule(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Regex6::rule', (v_m2));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5and(p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0), function () {
																return p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																	var v_source;
																	v_source = ((p5str(p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::ident')]), 0)) + '{ ' + 'my $str     = $_[0]; ' + 'my $pos     = $_[1]; ' + 'my $MATCH = { str => $str, from => $pos, to => $pos }; ' + 'my $tmp = ( ' + p5str(p5call(p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Regex6::rule')]), 0), 'emit_perl5', [], 0)) + '); ' + '$tmp ? $MATCH : 0; ' + '}'));
																	var v_ast;
																	v_ast = (p5call_sub('Perlito5::Grammar::Block', 'named_sub_def', [v_source, 0], 0));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a(['term', p5pkg['Perlito5::Match'].flat([v_ast], 1)])))));
																	return ((1));
																})()], 0)
															})
														})
													})
												})
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3523._prototype_ = null;
					return tmp3523
				})());
				p5pkg['Perlito5::Grammar::Precedence'].add_term(p5list_to_a(['token', p5pkg['Perlito5::Grammar::Regex6'].term_token]), null);
				p5typeglob_set('Perlito5::Grammar::Regex6', 'any', (function () {
					var tmp3524;
					tmp3524 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(('' != p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
										return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3524._prototype_ = null;
					return tmp3524
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'literal', (function () {
					var tmp3525;
					tmp3525 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_last_match_null;
										v_last_match_null = (0);
										var v_m;
										v_m = (v_MATCH);
										var v_to;
										v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										(function () {
											p5while(function () {
												(function () {
													if ( (p5num(v_to) == p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'))) ) {
													v_last_match_null = ((p5num(v_last_match_null) + 1));
												}
												else {
													v_last_match_null = (0);
												}
												})();
												v_m = (v_MATCH);
												v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
											}, function () {
												return p5and(p5context([(function () {
													var v_pos1;
													v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
													return ((p5or(p5context([(function () {
															return ((p5context([p5and(p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([92], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																	return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																})], 0), function () {
																	return p5context([p5and(('' != p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0)
																})], 0)));
														})()], 0), function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([p5and(p5context([(function () {
																		var v_tmp;
																		v_tmp = (v_MATCH);
																		v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
																		var v_res;
																		v_res = (p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([39], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0));
																		v_MATCH = (v_tmp);
																		return ((( p5bool(v_res) ? 0 : 1)));
																	})()], 0), function () {
																		return p5context([p5and(('' != p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0)
																	})], 0)));
															})()], 0)
														})));
												})()], 0), function () {
													return p5context([(p5num(v_last_match_null) < 2)], 0)
												})
											}, false, '', 0)
										})();
										v_MATCH = (v_m);
										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_to));
										return ((1));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3525._prototype_ = null;
					return tmp3525
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'metasyntax_exp', (function () {
					var tmp3526;
					tmp3526 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_last_match_null;
										v_last_match_null = (0);
										var v_m;
										v_m = (v_MATCH);
										var v_to;
										v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										var v_count;
										v_count = (0);
										(function () {
											p5while(function () {
												(function () {
													if ( (p5num(v_to) == p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'))) ) {
													v_last_match_null = ((p5num(v_last_match_null) + 1));
												}
												else {
													v_last_match_null = (0);
												}
												})();
												v_m = (v_MATCH);
												v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
												v_count = ((p5num(v_count) + 1));
											}, function () {
												return p5and(p5context([p5and(p5context([(function () {
													var v_tmp;
													v_tmp = (v_MATCH);
													v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
													var v_res;
													v_res = (p5context([p5and(('>' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0));
													v_MATCH = (v_tmp);
													return ((( p5bool(v_res) ? 0 : 1)));
												})()], 0), function () {
													return p5context([p5and(('' != p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0)
												})], 0), function () {
													return p5context([(p5num(v_last_match_null) < 2)], 0)
												})
											}, false, '', 0)
										})();
										v_MATCH = (v_m);
										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_to));
										return (((p5num(v_count) > 0)));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3526._prototype_ = null;
					return tmp3526
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'string_code', (function () {
					var tmp3527;
					tmp3527 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_last_match_null;
										v_last_match_null = (0);
										var v_m;
										v_m = (v_MATCH);
										var v_to;
										v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										var v_count;
										v_count = (0);
										(function () {
											p5while(function () {
												(function () {
													if ( (p5num(v_to) == p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'))) ) {
													v_last_match_null = ((p5num(v_last_match_null) + 1));
												}
												else {
													v_last_match_null = (0);
												}
												})();
												v_m = (v_MATCH);
												v_to = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
												v_count = ((p5num(v_count) + 1));
											}, function () {
												return p5and(p5context([(function () {
													var v_pos1;
													v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
													return ((p5or(p5context([(function () {
															return ((p5context([p5and(p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([92], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																	return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																})], 0), function () {
																	return p5context([p5and(('' != p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0)
																})], 0)));
														})()], 0), function () {
															return p5or(p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([p5and(p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([39], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5and(p5context([(function () {
																			var v_m2;
																			v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].literal(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																			return (function () {
																				if ( p5bool(v_m2) ) {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																				return ((1));
																			}
																			else {
																				return ((0));
																			}
																			})()
																		})()], 0), function () {
																			return p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([39], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																				return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																			})], 0)
																		})
																	})], 0)));
															})()], 0), function () {
																return p5or(p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																	return ((p5context([p5and(p5context([p5and(('{' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].string_code(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0)
																			})
																		})], 0)));
																})()], 0), function () {
																	return p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																		return ((p5context([p5and(p5context([(function () {
																				var v_tmp;
																				v_tmp = (v_MATCH);
																				v_MATCH = ((new p5HashRef(p5a_to_h(p5list_to_a(['str', v_str, 'from', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to'), 'to', (v_tmp || (v_tmp = new p5HashRef({})))._hash_.p5hget('to')])))));
																				var v_res;
																				v_res = (p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																							return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																						})], 0));
																				v_MATCH = (v_tmp);
																				return ((( p5bool(v_res) ? 0 : 1)));
																			})()], 0), function () {
																				return p5context([p5and(('' != p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0)
																			})], 0)));
																	})()], 0)
																})
															})
														})));
												})()], 0), function () {
													return p5context([(p5num(v_last_match_null) < 2)], 0)
												})
											}, false, '', 0)
										})();
										v_MATCH = (v_m);
										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_to));
										return (((p5num(v_count) > 0)));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3527._prototype_ = null;
					return tmp3527
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'parsed_code', (function () {
					var tmp3528;
					tmp3528 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].string_code(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5context([(function () {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat([v_MATCH], 0)));
											return ((1));
										})()], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3528._prototype_ = null;
					return tmp3528
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'rule_term', (function () {
					var tmp3529;
					tmp3529 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(p5context([p5and(('<before' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 7)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((7 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0), function () {
														return p5and(p5context([(function () {
															var v_m2;
															v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
															return (function () {
																if ( p5bool(v_m2) ) {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																return ((1));
															}
															else {
																return ((0));
															}
															})()
														})()], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].rule(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('rule', (v_m2));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5and(p5context([p5and(('>' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																	return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																})], 0), function () {
																	return p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Before', 'new', p5list_to_a(['rule_exp', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('rule')]), 1)]), 0)));
																		return ((1));
																	})()], 0)
																})
															})
														})
													})], 0)));
											})()], 0), function () {
												return p5or(p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([p5and(p5context([p5and(('<!before' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 8)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((8 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0), function () {
															return p5and(p5context([(function () {
																var v_m2;
																v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})()], 0), function () {
																return p5and(p5context([(function () {
																	var v_m2;
																	v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].rule(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																	return (function () {
																		if ( p5bool(v_m2) ) {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('rule', (v_m2));
																		return ((1));
																	}
																	else {
																		return ((0));
																	}
																	})()
																})()], 0), function () {
																	return p5and(p5context([p5and(('>' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::NotBefore', 'new', p5list_to_a(['rule_exp', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('rule')]), 1)]), 0)));
																			return ((1));
																		})()], 0)
																	})
																})
															})
														})], 0)));
												})()], 0), function () {
													return p5or(p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
														return ((p5context([p5and(p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([39], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0), function () {
																return p5and(p5context([(function () {
																	var v_m2;
																	v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].literal(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																	return (function () {
																		if ( p5bool(v_m2) ) {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('literal', (v_m2));
																		return ((1));
																	}
																	else {
																		return ((0));
																	}
																	})()
																})()], 0), function () {
																	return p5and(p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([39], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Constant', 'new', p5list_to_a(['constant', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('literal')]), 1)]), 0)));
																			return ((1));
																		})()], 0)
																	})
																})
															})], 0)));
													})()], 0), function () {
														return p5or(p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
															return ((p5context([p5and(p5context([p5and(('<' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																	return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																})], 0), function () {
																	return p5context([(function () {
																		var v_pos1;
																		v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																		return ((p5or(p5context([(function () {
																				return ((p5context([p5and(p5context([p5and(('.' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																						return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																					})], 0), function () {
																						return p5and(p5context([(function () {
																							var v_m2;
																							v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].metasyntax_exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																							return (function () {
																								if ( p5bool(v_m2) ) {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('metasyntax_exp', (v_m2));
																								return ((1));
																							}
																							else {
																								return ((0));
																							}
																							})()
																						})()], 0), function () {
																							return p5and(p5context([p5and(('>' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																								return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																							})], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Subrule', 'new', p5list_to_a(['metasyntax', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('metasyntax_exp')]), 1), 'captures', 0]), 0)));
																									return ((1));
																								})()], 0)
																							})
																						})
																					})], 0)));
																			})()], 0), function () {
																				return p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																					return ((p5context([p5and(p5context([(function () {
																							var v_m2;
																							v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].metasyntax_exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																							return (function () {
																								if ( p5bool(v_m2) ) {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('metasyntax_exp', (v_m2));
																								return ((1));
																							}
																							else {
																								return ((0));
																							}
																							})()
																						})()], 0), function () {
																							return p5and(p5context([p5and(('>' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																								return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																							})], 0), function () {
																								return p5context([(function () {
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																									(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Subrule', 'new', p5list_to_a(['metasyntax', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('metasyntax_exp')]), 1), 'captures', 1]), 0)));
																									return ((1));
																								})()], 0)
																							})
																						})], 0)));
																				})()], 0)
																			})));
																	})()], 0)
																})], 0)));
														})()], 0), function () {
															return p5or(p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([p5and(p5context([p5and(('{' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																		return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																	})], 0), function () {
																		return p5and(p5context([(function () {
																			var v_m2;
																			v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].parsed_code(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																			return (function () {
																				if ( p5bool(v_m2) ) {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('parsed_code', (v_m2));
																				return ((1));
																			}
																			else {
																				return ((0));
																			}
																			})()
																		})()], 0), function () {
																			return p5and(p5context([p5and(('}' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																				return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																			})], 0), function () {
																				return p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Block', 'new', p5list_to_a(['closure', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('parsed_code')]), 1)]), 0)));
																					return ((1));
																				})()], 0)
																			})
																		})
																	})], 0)));
															})()], 0), function () {
																return p5or(p5context([(function () {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																	return ((p5context([p5and(p5context([p5and((p5pkg['Perlito5::Grammar::Regex6'].chr([92], 0) == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5context([(function () {
																				var v_pos1;
																				v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
																				return ((p5or(p5context([(function () {
																						return ((p5context([p5and(p5context([p5and(('c' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																								return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																							})], 0), function () {
																								return p5and(p5context([(function () {
																									var v_m2;
																									v_m2 = (p5call_sub('Perlito5::Grammar::Number', 'digits', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																									return (function () {
																										if ( p5bool(v_m2) ) {
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Number::digits', (v_m2));
																										return ((1));
																									}
																									else {
																										return ((0));
																									}
																									})()
																								})()], 0), function () {
																									return p5context([(function () {
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Constant', 'new', ['constant', p5pkg['Perlito5::Grammar::Regex6'].chr([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('Perlito5::Grammar::Number::digits')]), 0)], 1)], 0)));
																										return ((1));
																									})()], 0)
																								})
																							})], 0)));
																					})()], 0), function () {
																						return p5context([(function () {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																							return ((p5context([p5and(p5context([(function () {
																									var v_m2;
																									v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].any(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																									return (function () {
																										if ( p5bool(v_m2) ) {
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('any', (v_m2));
																										return ((1));
																									}
																									else {
																										return ((0));
																									}
																									})()
																								})()], 0), function () {
																									return p5context([(function () {
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																										(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::SpecialChar', 'new', p5list_to_a(['char', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('any')]), 1)]), 0)));
																										return ((1));
																									})()], 0)
																								})], 0)));
																						})()], 0)
																					})));
																			})()], 0)
																		})], 0)));
																})()], 0), function () {
																	return p5or(p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																		return ((p5context([p5and(p5context([p5and(('.' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																				return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																			})], 0), function () {
																				return p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Dot', 'new', [], 0)));
																					return ((1));
																				})()], 0)
																			})], 0)));
																	})()], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																			return ((p5context([p5and(p5context([p5and(('[' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																					return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																				})], 0), function () {
																					return p5and(p5context([(function () {
																						var v_m2;
																						v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].rule(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																						return (function () {
																							if ( p5bool(v_m2) ) {
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																							(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('rule', (v_m2));
																							return ((1));
																						}
																						else {
																							return ((0));
																						}
																						})()
																					})()], 0), function () {
																						return p5and(p5context([p5and((']' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																							return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																						})], 0), function () {
																							return p5context([(function () {
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																								(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('rule')]), 0)));
																								return ((1));
																							})()], 0)
																						})
																					})
																				})], 0)));
																		})()], 0)
																	})
																})
															})
														})
													})
												})
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3529._prototype_ = null;
					return tmp3529
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'quant_exp', (function () {
					var tmp3530;
					tmp3530 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(('?' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
														return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
													})], 0)));
											})()], 0), function () {
												return p5or(p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([p5and(('*' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0)));
												})()], 0), function () {
													return p5context([(function () {
														(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
														return ((p5context([p5and(('+' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
															})], 0)));
													})()], 0)
												})
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3530._prototype_ = null;
					return tmp3530
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'quantifier', (function () {
					var tmp3531;
					tmp3531 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Space::opt_ws', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].rule_term(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('rule_term', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5and(p5context([(function () {
												var v_m2;
												v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
												return (function () {
													if ( p5bool(v_m2) ) {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Space::opt_ws', (v_m2));
													return ((1));
												}
												else {
													return ((0));
												}
												})()
											})()], 0), function () {
												return p5context([(function () {
													var v_pos1;
													v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
													return ((p5or(p5context([(function () {
															return ((p5context([p5and(p5context([(function () {
																	var v_m2;
																	v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].quant_exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																	return (function () {
																		if ( p5bool(v_m2) ) {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('quant_exp', (v_m2));
																		return ((1));
																	}
																	else {
																		return ((0));
																	}
																	})()
																})()], 0), function () {
																	return p5and(p5context([(function () {
																		var v_m2;
																		v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'opt_ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																		return (function () {
																			if ( p5bool(v_m2) ) {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('Perlito5::Grammar::Space::opt_ws', (v_m2));
																			return ((1));
																		}
																		else {
																			return ((0));
																		}
																		})()
																	})()], 0), function () {
																		return p5context([(function () {
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																			(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Quantifier', 'new', p5list_to_a(['term', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('rule_term')]), 1), 'quant', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('quant_exp')]), 1)]), 0)));
																			return ((1));
																		})()], 0)
																	})
																})], 0)));
														})()], 0), function () {
															return p5context([(function () {
																(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																return ((p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('rule_term')]), 0)));
																		return ((1));
																	})()], 0)));
															})()], 0)
														})));
												})()], 0)
											})
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3531._prototype_ = null;
					return tmp3531
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'concat_list', (function () {
					var tmp3532;
					tmp3532 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].quantifier(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('quantifier', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5context([(function () {
															var v_pos1;
															v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
															return ((p5or(p5context([(function () {
																	return ((p5context([p5and(p5context([(function () {
																			var v_m2;
																			v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].concat_list(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																			return (function () {
																				if ( p5bool(v_m2) ) {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('concat_list', (v_m2));
																				return ((1));
																			}
																			else {
																				return ((0));
																			}
																			})()
																		})()], 0), function () {
																			return p5context([(function () {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('quantifier')]), 1), p5array_deref(p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('concat_list')]), p5want), 'Perlito5::Grammar::Regex6')])))));
																				return ((1));
																			})()], 0)
																		})], 0)));
																})()], 0), function () {
																	return p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																		return ((p5context([(function () {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('quantifier')]), 1)])))));
																				return ((1));
																			})()], 0)));
																	})()], 0)
																})));
														})()], 0)
													})], 0)));
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef([]))));
															return ((1));
														})()], 0)));
												})()], 0)
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3532._prototype_ = null;
					return tmp3532
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'concat_exp', (function () {
					var tmp3533;
					tmp3533 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_m2;
										v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].concat_list(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
										return (function () {
											if ( p5bool(v_m2) ) {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('concat_list', (v_m2));
											return ((1));
										}
										else {
											return ((0));
										}
										})()
									})()], 0), function () {
										return p5context([(function () {
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
											(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Concat', 'new', p5list_to_a(['concat', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('concat_list')]), 1)]), 0)));
											return ((1));
										})()], 0)
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3533._prototype_ = null;
					return tmp3533
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'or_list_exp', (function () {
					var tmp3534;
					tmp3534 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(p5context([(function () {
														var v_m2;
														v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].concat_exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
														return (function () {
															if ( p5bool(v_m2) ) {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('concat_exp', (v_m2));
															return ((1));
														}
														else {
															return ((0));
														}
														})()
													})()], 0), function () {
														return p5context([(function () {
															var v_pos1;
															v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
															return ((p5or(p5context([(function () {
																	return ((p5context([p5and(p5context([p5and(('|' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
																			return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
																		})], 0), function () {
																			return p5and(p5context([(function () {
																				var v_m2;
																				v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].or_list_exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																				return (function () {
																					if ( p5bool(v_m2) ) {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('or_list_exp', (v_m2));
																					return ((1));
																				}
																				else {
																					return ((0));
																				}
																				})()
																			})()], 0), function () {
																				return p5context([(function () {
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																					(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('concat_exp')]), 1), p5array_deref(p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('or_list_exp')]), p5want), 'Perlito5::Grammar::Regex6')])))));
																					return ((1));
																				})()], 0)
																			})
																		})], 0)));
																})()], 0), function () {
																	return p5context([(function () {
																		(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
																		return ((p5context([(function () {
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
																				(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef(p5list_to_a([p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('concat_exp')]), 1)])))));
																				return ((1));
																			})()], 0)));
																	})()], 0)
																})));
														})()], 0)
													})], 0)));
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((p5context([(function () {
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
															(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', ((new p5ArrayRef([]))));
															return ((1));
														})()], 0)));
												})()], 0)
											})));
									})()], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3534._prototype_ = null;
					return tmp3534
				})());
				p5typeglob_set('Perlito5::Grammar::Regex6', 'rule', (function () {
					var tmp3535;
					tmp3535 = function (List__, p5want) {
						var v_str;
						v_str = (List__.p5aget(0));
						var v_pos;
						v_pos = (List__.p5aget(1));
						var v_MATCH;
						v_MATCH = ((new p5HashRef({'str' : v_str, 'from' : v_pos, 'to' : v_pos})));
						var v_tmp;
						v_tmp = (p5context([p5context([p5and(p5context([(function () {
										var v_pos1;
										v_pos1 = ((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to'));
										return ((p5or(p5context([(function () {
												return ((p5context([p5and(p5context([(function () {
														var v_m;
														v_m = (v_MATCH);
														(function () {
															if ( !( p5bool((function () {
																var v_m2;
																v_m2 = (p5call_sub('Perlito5::Grammar::Space', 'ws', p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
																return (function () {
																	if ( p5bool(v_m2) ) {
																	(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
																	return ((1));
																}
																else {
																	return ((0));
																}
																})()
															})())) ) {
															v_MATCH = (v_m);
														}
														})();
														return ((1));
													})()], 0), function () {
														return p5context([p5and(('|' == p5str(v_str).substr(p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')), 1)), function () {
															return p5context([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((1 + p5num((v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')))))], 0)
														})], 0)
													})], 0)));
											})()], 0), function () {
												return p5context([(function () {
													(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', (v_pos1));
													return ((1));
												})()], 0)
											})));
									})()], 0), function () {
										return p5and(p5context([(function () {
											var v_m2;
											v_m2 = (p5pkg['Perlito5::Grammar::Regex6'].or_list_exp(p5list_to_a([v_str, (v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('to')]), 0));
											return (function () {
												if ( p5bool(v_m2) ) {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('to', ((v_m2 || (v_m2 = new p5HashRef({})))._hash_.p5hget('to')));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('or_list_exp', (v_m2));
												return ((1));
											}
											else {
												return ((0));
											}
											})()
										})()], 0), function () {
											return p5context([(function () {
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('str', (v_str));
												(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hset('capture', (p5call('Perlito5::Rul::Or', 'new', p5list_to_a(['or_list', p5pkg['Perlito5::Match'].flat(p5list_to_a([(v_MATCH || (v_MATCH = new p5HashRef({})))._hash_.p5hget('or_list_exp')]), 1)]), 0)));
												return ((1));
											})()], 0)
										})
									})], 0)], 0));
						return (( p5bool(v_tmp) ? v_MATCH : 0));
					};
					tmp3535._prototype_ = null;
					return tmp3535
				})());
			}, [0], false, ''
		);
		1;
	})();
	// use Perlito5::Grammar::Regex6
;
	(function () {
		null;
		p5make_package('Perlito5::Rul');
		p5typeglob_set('Perlito5::Rul', 'new', (function () {
			var tmp3536;
			tmp3536 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3536._prototype_ = null;
			return tmp3536
		})());
		p5typeglob_set('Perlito5::Rul', 'constant', (function () {
			var tmp3537;
			tmp3537 = function (List__, p5want) {
				try {
					var v_str;
					v_str = (List__.shift());
					var v_len;
					v_len = (p5pkg['Perlito5::Rul'].length([v_str], 0));
					(function () {
						if ( (p5str(v_str) == String.fromCharCode(92)) ) {
						v_str = (String.fromCharCode(92) + String.fromCharCode(92));
					}
					})();
					(function () {
						if ( (p5str(v_str) == String.fromCharCode(39)) ) {
						v_str = (String.fromCharCode(92) + String.fromCharCode(39));
					}
					})();
					return (function () {
						if ( p5bool(v_len) ) {
						return (p5context([('( ' + String.fromCharCode(39) + p5str(v_str) + String.fromCharCode(39) + ' eq substr( $str, $MATCH->{to}, ' + p5str(v_len) + ') ' + '&& ( $MATCH->{to} = ' + p5str(v_len) + ' + $MATCH->{to} )' + ')')], p5want));
					}
					else {
						(function () {
							throw(p5context(['1'], p5want))
						})()
					}
					})()
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3537._prototype_ = null;
			return tmp3537
		})());
		p5make_package('Perlito5::Rul::Quantifier');
		p5typeglob_set('Perlito5::Rul::Quantifier', 'new', (function () {
			var tmp3538;
			tmp3538 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Quantifier'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3538._prototype_ = null;
			return tmp3538
		})());
		p5typeglob_set('Perlito5::Rul::Quantifier', 'term', (function () {
			var tmp3539;
			tmp3539 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('term'));
			};
			tmp3539._prototype_ = null;
			return tmp3539
		})());
		p5typeglob_set('Perlito5::Rul::Quantifier', 'quant', (function () {
			var tmp3540;
			tmp3540 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('quant'));
			};
			tmp3540._prototype_ = null;
			return tmp3540
		})());
		p5typeglob_set('Perlito5::Rul::Quantifier', 'emit_perl5', (function () {
			var tmp3541;
			tmp3541 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.p5aget(0));
					(function () {
						if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('quant')) == '') ) {
						throw(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'emit_perl5', [], p5want));
					}
					})();
					(function () {
						if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('quant')) == '+') ) {
						p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'set_captures_to_array', [], null);
						throw(p5context([('(do { ' + 'my $last_match_null = 0; ' + 'my $m = $MATCH; ' + 'my $to = $MATCH->{to}; ' + 'my $count = 0; ' + 'while (' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'emit_perl5', [], 0)) + ' && ($last_match_null < 2)) ' + '{ ' + 'if ($to == $MATCH->{to}) { ' + '$last_match_null = $last_match_null + 1; ' + '} ' + 'else { ' + '$last_match_null = 0; ' + '}; ' + '$m = $MATCH; ' + '$to = $MATCH->{to}; ' + '$count = $count + 1; ' + '}; ' + '$MATCH = $m; ' + '$MATCH->{to} = $to; ' + '$count > 0; ' + '})')], p5want));
					}
					})();
					(function () {
						if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('quant')) == '*') ) {
						p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'set_captures_to_array', [], null);
						throw(p5context([('(do { ' + 'my $last_match_null = 0; ' + 'my $m = $MATCH; ' + 'my $to = $MATCH->{to}; ' + 'while (' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'emit_perl5', [], 0)) + ' && ($last_match_null < 2)) ' + '{ ' + 'if ($to == $MATCH->{to}) { ' + '$last_match_null = $last_match_null + 1; ' + '} ' + 'else { ' + '$last_match_null = 0; ' + '}; ' + '$m = $MATCH; ' + '$to = $MATCH->{to}; ' + '}; ' + '$MATCH = $m; ' + '$MATCH->{to} = $to; ' + '1 ' + '})')], p5want));
					}
					})();
					(function () {
						if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('quant')) == '?') ) {
						p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'set_captures_to_array', [], null);
						throw(p5context([('(do { ' + 'my $m = $MATCH; ' + 'if (!' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'emit_perl5', [], 0)) + ') ' + '{ ' + '$MATCH = $m; ' + '}; ' + '1 ' + '})')], p5want));
					}
					})();
					return (p5pkg['Perlito5::Rul::Quantifier'].die([].concat(['Perlito5::Rul::Quantifier:  not implemented']), p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3541._prototype_ = null;
			return tmp3541
		})());
		p5typeglob_set('Perlito5::Rul::Quantifier', 'set_captures_to_array', (function () {
			var tmp3542;
			tmp3542 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('term'), 'set_captures_to_array', [], p5want));
			};
			tmp3542._prototype_ = null;
			return tmp3542
		})());
		p5make_package('Perlito5::Rul::Or');
		p5typeglob_set('Perlito5::Rul::Or', 'new', (function () {
			var tmp3543;
			tmp3543 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Or'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3543._prototype_ = null;
			return tmp3543
		})());
		p5typeglob_set('Perlito5::Rul::Or', 'or_list', (function () {
			var tmp3544;
			tmp3544 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('or_list'));
			};
			tmp3544._prototype_ = null;
			return tmp3544
		})());
		p5typeglob_set('Perlito5::Rul::Or', 'emit_perl5', (function () {
			var tmp3545;
			tmp3545 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.p5aget(0));
					(function () {
						if ( (p5num((p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('or_list'), 'Perlito5::Rul::Or')))) == 1) ) {
						throw(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('or_list')._array_.p5aget(0), 'emit_perl5', [], p5want));
					}
					})();
					return (p5context([('(do { ' + 'my $pos1 = $MATCH->{to}; (do { ' + p5pkg['Perlito5::Rul::Or'].join(['}) || (do { $MATCH->{to} = $pos1; '].concat(p5list_to_a([p5map(p5pkg['Perlito5::Rul::Or'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_perl5', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('or_list'), 'Perlito5::Rul::Or')]))])), 0) + '}) })')], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3545._prototype_ = null;
			return tmp3545
		})());
		p5typeglob_set('Perlito5::Rul::Or', 'set_captures_to_array', (function () {
			var tmp3546;
			tmp3546 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5map(p5pkg['Perlito5::Rul::Or'], function (p5want) {
							return (p5call(p5make_package('main')['v__'], 'set_captures_to_array', [], p5want));
						}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('or_list'), 'Perlito5::Rul::Or')])));
			};
			tmp3546._prototype_ = null;
			return tmp3546
		})());
		p5make_package('Perlito5::Rul::Concat');
		p5typeglob_set('Perlito5::Rul::Concat', 'new', (function () {
			var tmp3547;
			tmp3547 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Concat'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3547._prototype_ = null;
			return tmp3547
		})());
		p5typeglob_set('Perlito5::Rul::Concat', 'concat', (function () {
			var tmp3548;
			tmp3548 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('concat'));
			};
			tmp3548._prototype_ = null;
			return tmp3548
		})());
		p5typeglob_set('Perlito5::Rul::Concat', 'emit_perl5', (function () {
			var tmp3549;
			tmp3549 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.p5aget(0));
					(function () {
						if ( (p5num((p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('concat'), 'Perlito5::Rul::Concat')))) == 1) ) {
						throw(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('concat')._array_.p5aget(0), 'emit_perl5', [], p5want));
					}
					})();
					return (p5context([('(' + p5pkg['Perlito5::Rul::Concat'].join([' && '].concat(p5list_to_a([p5map(p5pkg['Perlito5::Rul::Concat'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_perl5', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('concat'), 'Perlito5::Rul::Concat')]))])), 0) + ')')], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3549._prototype_ = null;
			return tmp3549
		})());
		p5typeglob_set('Perlito5::Rul::Concat', 'set_captures_to_array', (function () {
			var tmp3550;
			tmp3550 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5map(p5pkg['Perlito5::Rul::Concat'], function (p5want) {
							return (p5call(p5make_package('main')['v__'], 'set_captures_to_array', [], p5want));
						}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('concat'), 'Perlito5::Rul::Concat')])));
			};
			tmp3550._prototype_ = null;
			return tmp3550
		})());
		p5make_package('Perlito5::Rul::Subrule');
		p5typeglob_set('Perlito5::Rul::Subrule', 'new', (function () {
			var tmp3551;
			tmp3551 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Subrule'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3551._prototype_ = null;
			return tmp3551
		})());
		p5typeglob_set('Perlito5::Rul::Subrule', 'metasyntax', (function () {
			var tmp3552;
			tmp3552 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('metasyntax'));
			};
			tmp3552._prototype_ = null;
			return tmp3552
		})());
		p5typeglob_set('Perlito5::Rul::Subrule', 'captures', (function () {
			var tmp3553;
			tmp3553 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('captures'));
			};
			tmp3553._prototype_ = null;
			return tmp3553
		})());
		p5typeglob_set('Perlito5::Rul::Subrule', 'emit_perl5', (function () {
			var tmp3554;
			tmp3554 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				var v_meth;
				v_meth = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('metasyntax'));
				var v_code;
				(function () {
						if ( (p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('captures')) == 1) ) {
						v_code = (('if ($m2) { $MATCH->{to} = $m2->{to}; $MATCH->{' + String.fromCharCode(39) + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('metasyntax')) + String.fromCharCode(39) + '} = $m2; 1 } else { 0 }; '));
					}
					else (function () {
						if ( (p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('captures')) > 1) ) {
						v_code = (('if ($m2) { ' + '$MATCH->{to} = $m2->{to}; ' + 'if (exists $MATCH->{' + String.fromCharCode(39) + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('metasyntax')) + String.fromCharCode(39) + '}) { ' + 'push @{ $MATCH->{' + String.fromCharCode(39) + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('metasyntax')) + String.fromCharCode(39) + '} }, $m2; ' + '} ' + 'else { ' + '$MATCH->{' + String.fromCharCode(39) + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('metasyntax')) + String.fromCharCode(39) + '} = [ $m2 ]; ' + '}; ' + '1 ' + '} else { 0 }; '));
					}
					else {
						v_code = ('if ($m2) { $MATCH->{to} = $m2->{to}; 1 } else { 0 }; ');
					}
					})()
					})();
				return (p5context([('(do { ' + 'my $m2 = ' + p5str(v_meth) + '($str, $MATCH->{to}); ' + p5str(v_code) + '})')], p5want));
			};
			tmp3554._prototype_ = null;
			return tmp3554
		})());
		p5typeglob_set('Perlito5::Rul::Subrule', 'set_captures_to_array', (function () {
			var tmp3555;
			tmp3555 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (function () {
						if ( (p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('captures')) > 0) ) {
						return ((v_self || (v_self = new p5HashRef({})))._hash_.p5hset('captures', ((p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('captures')) + 1))));
					}
					})()
			};
			tmp3555._prototype_ = null;
			return tmp3555
		})());
		p5make_package('Perlito5::Rul::Constant');
		p5typeglob_set('Perlito5::Rul::Constant', 'new', (function () {
			var tmp3556;
			tmp3556 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Constant'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3556._prototype_ = null;
			return tmp3556
		})());
		p5typeglob_set('Perlito5::Rul::Constant', 'constant', (function () {
			var tmp3557;
			tmp3557 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('constant'));
			};
			tmp3557._prototype_ = null;
			return tmp3557
		})());
		p5typeglob_set('Perlito5::Rul::Constant', 'emit_perl5', (function () {
			var tmp3558;
			tmp3558 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				var v_str;
				v_str = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('constant'));
				return (p5pkg['Perlito5::Rul'].constant([v_str], p5want));
			};
			tmp3558._prototype_ = null;
			return tmp3558
		})());
		p5typeglob_set('Perlito5::Rul::Constant', 'set_captures_to_array', (function () {
			var tmp3559;
			tmp3559 = function (List__, p5want) {
				var v_self;
				return ((v_self = (List__.p5aget(0))));
			};
			tmp3559._prototype_ = null;
			return tmp3559
		})());
		p5make_package('Perlito5::Rul::Dot');
		p5typeglob_set('Perlito5::Rul::Dot', 'new', (function () {
			var tmp3560;
			tmp3560 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Dot'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3560._prototype_ = null;
			return tmp3560
		})());
		p5typeglob_set('Perlito5::Rul::Dot', 'emit_perl5', (function () {
			var tmp3561;
			tmp3561 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5context([('( ' + String.fromCharCode(39) + String.fromCharCode(39) + ' ne substr( $str, $MATCH->{to}, 1 ) ' + '&& ($MATCH->{to} = 1 + $MATCH->{to})' + ')')], p5want));
			};
			tmp3561._prototype_ = null;
			return tmp3561
		})());
		p5typeglob_set('Perlito5::Rul::Dot', 'set_captures_to_array', (function () {
			var tmp3562;
			tmp3562 = function (List__, p5want) {
				var v_self;
				return ((v_self = (List__.p5aget(0))));
			};
			tmp3562._prototype_ = null;
			return tmp3562
		})());
		p5make_package('Perlito5::Rul::SpecialChar');
		p5typeglob_set('Perlito5::Rul::SpecialChar', 'new', (function () {
			var tmp3563;
			tmp3563 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::SpecialChar'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3563._prototype_ = null;
			return tmp3563
		})());
		p5typeglob_set('Perlito5::Rul::SpecialChar', 'char', (function () {
			var tmp3564;
			tmp3564 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('char'));
			};
			tmp3564._prototype_ = null;
			return tmp3564
		})());
		p5typeglob_set('Perlito5::Rul::SpecialChar', 'emit_perl5', (function () {
			var tmp3565;
			tmp3565 = function (List__, p5want) {
				try {
					var v_self;
					v_self = (List__.p5aget(0));
					var v_char;
					v_char = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('char'));
					(function () {
						if ( (p5str(v_char) == 'n') ) {
						throw(p5call(p5call('Perlito5::Rul::Subrule', 'new', ['metasyntax', 'is_newline', 'captures', 0], 0), 'emit_perl5', [], p5want));
					}
					})();
					(function () {
						if ( (p5str(v_char) == 'N') ) {
						throw(p5call(p5call('Perlito5::Rul::Subrule', 'new', ['metasyntax', 'not_newline', 'captures', 0], 0), 'emit_perl5', [], p5want));
					}
					})();
					(function () {
						if ( (p5str(v_char) == 'd') ) {
						throw(p5call(p5call('Perlito5::Rul::Subrule', 'new', ['metasyntax', 'digit', 'captures', 0], 0), 'emit_perl5', [], p5want));
					}
					})();
					(function () {
						if ( (p5str(v_char) == 's') ) {
						throw(p5call(p5call('Perlito5::Rul::Subrule', 'new', ['metasyntax', 'space', 'captures', 0], 0), 'emit_perl5', [], p5want));
					}
					})();
					(function () {
						if ( (p5str(v_char) == 't') ) {
						throw(p5pkg['Perlito5::Rul'].constant([p5pkg['Perlito5::Rul::SpecialChar'].chr([9], 1)], p5want));
					}
					})();
					return (p5pkg['Perlito5::Rul'].constant([v_char], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3565._prototype_ = null;
			return tmp3565
		})());
		p5typeglob_set('Perlito5::Rul::SpecialChar', 'set_captures_to_array', (function () {
			var tmp3566;
			tmp3566 = function (List__, p5want) {
				var v_self;
				return ((v_self = (List__.p5aget(0))));
			};
			tmp3566._prototype_ = null;
			return tmp3566
		})());
		p5make_package('Perlito5::Rul::Block');
		p5typeglob_set('Perlito5::Rul::Block', 'new', (function () {
			var tmp3567;
			tmp3567 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Block'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3567._prototype_ = null;
			return tmp3567
		})());
		p5typeglob_set('Perlito5::Rul::Block', 'closure', (function () {
			var tmp3568;
			tmp3568 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('closure'));
			};
			tmp3568._prototype_ = null;
			return tmp3568
		})());
		p5typeglob_set('Perlito5::Rul::Block', 'emit_perl5', (function () {
			var tmp3569;
			tmp3569 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5context([('(do { ' + '$MATCH->{str} = $str; ' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('closure')) + '; 1 })')], p5want));
			};
			tmp3569._prototype_ = null;
			return tmp3569
		})());
		p5typeglob_set('Perlito5::Rul::Block', 'set_captures_to_array', (function () {
			var tmp3570;
			tmp3570 = function (List__, p5want) {
				var v_self;
				return ((v_self = (List__.p5aget(0))));
			};
			tmp3570._prototype_ = null;
			return tmp3570
		})());
		p5make_package('Perlito5::Rul::Before');
		p5typeglob_set('Perlito5::Rul::Before', 'new', (function () {
			var tmp3571;
			tmp3571 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::Before'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3571._prototype_ = null;
			return tmp3571
		})());
		p5typeglob_set('Perlito5::Rul::Before', 'rule_exp', (function () {
			var tmp3572;
			tmp3572 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('rule_exp'));
			};
			tmp3572._prototype_ = null;
			return tmp3572
		})());
		p5typeglob_set('Perlito5::Rul::Before', 'emit_perl5', (function () {
			var tmp3573;
			tmp3573 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5context([('(do { ' + 'my $tmp = $MATCH; ' + '$MATCH = { ' + String.fromCharCode(39) + 'str' + String.fromCharCode(39) + ' => $str, ' + String.fromCharCode(39) + 'from' + String.fromCharCode(39) + ' => $tmp->{to}, ' + String.fromCharCode(39) + 'to' + String.fromCharCode(39) + ' => $tmp->{to} }; ' + 'my $res = ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('rule_exp'), 'emit_perl5', [], 0)) + '; ' + '$MATCH = $tmp; ' + '$res ? 1 : 0 ' + '})')], p5want));
			};
			tmp3573._prototype_ = null;
			return tmp3573
		})());
		p5typeglob_set('Perlito5::Rul::Before', 'set_captures_to_array', (function () {
			var tmp3574;
			tmp3574 = function (List__, p5want) {
				var v_self;
				return ((v_self = (List__.p5aget(0))));
			};
			tmp3574._prototype_ = null;
			return tmp3574
		})());
		p5make_package('Perlito5::Rul::NotBefore');
		p5typeglob_set('Perlito5::Rul::NotBefore', 'new', (function () {
			var tmp3575;
			tmp3575 = function (List__, p5want) {
				var v_class;
				v_class = (List__.shift());
				return (p5pkg['Perlito5::Rul::NotBefore'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
			};
			tmp3575._prototype_ = null;
			return tmp3575
		})());
		p5typeglob_set('Perlito5::Rul::NotBefore', 'rule_exp', (function () {
			var tmp3576;
			tmp3576 = function (List__, p5want) {
				return (List__.p5aget_hash(0)._hash_.p5hget('rule_exp'));
			};
			tmp3576._prototype_ = null;
			return tmp3576
		})());
		p5typeglob_set('Perlito5::Rul::NotBefore', 'emit_perl5', (function () {
			var tmp3577;
			tmp3577 = function (List__, p5want) {
				var v_self;
				v_self = (List__.p5aget(0));
				return (p5context([('(do { ' + 'my $tmp = $MATCH; ' + '$MATCH = { ' + String.fromCharCode(39) + 'str' + String.fromCharCode(39) + ' => $str, ' + String.fromCharCode(39) + 'from' + String.fromCharCode(39) + ' => $tmp->{to}, ' + String.fromCharCode(39) + 'to' + String.fromCharCode(39) + ' => $tmp->{to} }; ' + 'my $res = ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('rule_exp'), 'emit_perl5', [], 0)) + '; ' + '$MATCH = $tmp; ' + '$res ? 0 : 1 ' + '})')], p5want));
			};
			tmp3577._prototype_ = null;
			return tmp3577
		})());
		p5typeglob_set('Perlito5::Rul::NotBefore', 'set_captures_to_array', (function () {
			var tmp3578;
			tmp3578 = function (List__, p5want) {
				var v_self;
				return ((v_self = (List__.p5aget(0))));
			};
			tmp3578._prototype_ = null;
			return tmp3578
		})());
		1;
	})();
	// use Perlito5::Emitter::Token
;
	(function () {
		p5make_package('Perlito5::Dumper');
		p5typeglob_set('Perlito5::Dumper', 'ast_dumper', (function () {
			var tmp3579;
			tmp3579 = function (List__, p5want) {
				var v_seen;
				v_seen = ((new p5HashRef({})));
				var v_level;
				v_level = ('');
				var v_pos;
				v_pos = ('[TODO - recursive structure in AST is not supported]');
				return (p5pkg['Perlito5::Dumper']._dumper(p5list_to_a([List__.p5aget(0), v_level, v_seen, v_pos]), p5want));
			};
			tmp3579._prototype_ = null;
			return tmp3579
		})());
		p5typeglob_set('Perlito5::Dumper', '_dumper', (function () {
			var tmp3580;
			tmp3580 = function (List__, p5want) {
				try {
					var v_obj;
					var v_tab;
					var v_seen;
					var v_pos;
					var tmp3581 = p5list_to_a([List__]);
					v_obj = tmp3581.shift();
					v_tab = tmp3581.shift();
					v_seen = tmp3581.shift();
					v_pos = tmp3581.shift();
					p5and(!( (v_obj != null)), function () {
						throw(p5context(['undef'], p5want))
					});
					var v_ref;
					v_ref = (p5pkg['Perlito5::Dumper'].ref([v_obj], 0));
					p5and(!( p5bool(v_ref)), function () {
						throw(p5pkg['Perlito5::Dumper'].escape_string([v_obj], p5want))
					});
					var v_as_string;
					v_as_string = (v_obj);
					p5and((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_as_string)), function () {
						throw((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_as_string)))
					});
					(v_seen || (v_seen = new p5HashRef({})))._hash_.p5hset(p5str(v_as_string), (v_pos));
					var v_tab1;
					v_tab1 = ((p5str(v_tab) + '    '));
					(function () {
						if ( (p5str(v_ref) == 'ARRAY') ) {
						(function () {
							p5or(p5num(p5array_deref((v_obj || (v_obj = new p5ArrayRef([]))), 'Perlito5::Dumper')), function () {
								throw(p5context(['[]'], p5want))
							});
							var List_out = [];
							(function () {
								var v_i;
								(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
										var v_here;
										v_here = ((p5str(v_pos) + '->[' + p5str(v_i) + ']'));
										List_out.p5push(p5list_to_a([v_tab1, p5pkg['Perlito5::Dumper']._dumper(p5list_to_a([(v_obj || (v_obj = new p5ArrayRef([])))._array_.p5aget(p5num(v_i)), v_tab1, v_seen, v_here]), 1), ',' + String.fromCharCode(10)]));
									}, p5list_to_a([p5range(0, (p5array_deref((v_obj || (v_obj = new p5ArrayRef([]))), 'Perlito5::Dumper').length - 1), 1, "tmp3582", 0)]), false, '') })()
							})();
							throw(p5context([p5pkg['Perlito5::Dumper'].join([''].concat(p5list_to_a(['[' + String.fromCharCode(10), List_out, v_tab, ']'])), p5want)], p5want));
						})();
					}
					else (function () {
						if ( (p5str(v_ref) == 'HASH') ) {
						(function () {
							p5or(p5pkg['Perlito5::Dumper'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::Dumper')], 0), function () {
								throw(p5context(['{}'], p5want))
							});
							var List_out = [];
							(function () {
								var v_i;
								(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
										var v_here;
										v_here = ((p5str(v_pos) + '->{' + p5str(v_i) + '}'));
										List_out.p5push(p5list_to_a([v_tab1, (String.fromCharCode(39) + p5str(v_i) + String.fromCharCode(39) + ' => '), p5pkg['Perlito5::Dumper']._dumper(p5list_to_a([(v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget(p5str(v_i)), v_tab1, v_seen, v_here]), 1), ',' + String.fromCharCode(10)]));
									}, p5list_to_a([p5sort(p5pkg['Perlito5::Dumper'], function (p5want) {
										return (p5cmp(p5str(p5make_package('Perlito5::Dumper')['v_a']), p5str(p5make_package('Perlito5::Dumper')['v_b'])));
									}, p5list_to_a([p5pkg['Perlito5::Dumper'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::Dumper')], 1)]))]), false, '') })()
							})();
							throw(p5context([p5pkg['Perlito5::Dumper'].join([''].concat(p5list_to_a(['{' + String.fromCharCode(10), List_out, v_tab, '}'])), p5want)], p5want));
						})();
					}
					else (function () {
						if ( ((p5str(v_ref) == 'SCALAR') || (p5str(v_ref) == 'REF')) ) {
						throw(p5context([(String.fromCharCode(92) + p5str(p5pkg['Perlito5::Dumper']._dumper(p5list_to_a([p5scalar_deref(v_obj, 'Perlito5::Dumper', ""), v_tab1, v_seen, v_pos]), 0)))], p5want));
					}
					else (function () {
						if ( (p5str(v_ref) == 'CODE') ) {
						throw(p5context(['sub { "DUMMY" }'], p5want));
					}
					})()
					})()
					})()
					})();
					var List_out = [];
					(function () {
						var v_i;
						(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
								var v_here;
								v_here = ((p5str(v_pos) + '->{' + p5str(v_i) + '}'));
								List_out.p5push(p5list_to_a([v_tab1, (String.fromCharCode(39) + p5str(v_i) + String.fromCharCode(39) + ' => '), p5pkg['Perlito5::Dumper']._dumper(p5list_to_a([(v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget(p5str(v_i)), v_tab1, v_seen, v_here]), 1), ',' + String.fromCharCode(10)]));
							}, p5list_to_a([p5sort(p5pkg['Perlito5::Dumper'], function (p5want) {
								return (p5cmp(p5str(p5make_package('Perlito5::Dumper')['v_a']), p5str(p5make_package('Perlito5::Dumper')['v_b'])));
							}, p5list_to_a([p5pkg['Perlito5::Dumper'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::Dumper')], 1)]))]), false, '') })()
					})();
					return (p5context([p5pkg['Perlito5::Dumper'].join([''].concat(p5list_to_a(['bless({' + String.fromCharCode(10), List_out, v_tab, ('}, ' + String.fromCharCode(39) + p5str(v_ref) + String.fromCharCode(39) + ')')])), p5want)], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3580._prototype_ = null;
			return tmp3580
		})());
		var Hash_safe_char = {};
		Hash_safe_char = p5a_to_h([' ', 1, '!', 1, '"', 1, '#', 1, '$', 1, '%', 1, '&', 1, '(', 1, ')', 1, '*', 1, '+', 1, ',', 1, '-', 1, '.', 1, '/', 1, ':', 1, ';', 1, '<', 1, '=', 1, '>', 1, '?', 1, '@', 1, '[', 1, ']', 1, '^', 1, '_', 1, '`', 1, '{', 1, '|', 1, '}', 1, '~', 1]);
		p5typeglob_set('Perlito5::Dumper', 'escape_string', (function () {
			var tmp3583;
			tmp3583 = function (List__, p5want) {
				try {
					var v_s;
					v_s = (List__.shift());
					var List_out = [];
					var v_tmp;
					v_tmp = ('');
					p5and((p5str(v_s) == ''), function () {
						throw(p5context([String.fromCharCode(39) + String.fromCharCode(39)], p5want))
					});
					p5and(p5and((p5str((0 + p5num(v_s))) == p5str(v_s)), function () {
						return p5m(v_s, '[0-9]', '', 0)
					}), function () {
						throw(p5context([(0 + p5num(v_s))], p5want))
					});
					(function () {
						var v_i;
						(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
								var v_c;
								v_c = (p5str(v_s).substr(p5num(v_i), 1));
								(function () {
									if ( (((p5str(v_c) >= 'a') && (p5str(v_c) <= 'z')) || (((p5str(v_c) >= 'A') && (p5str(v_c) <= 'Z')) || (((p5str(v_c) >= '0') && (p5str(v_c) <= '9')) || (Hash_safe_char).hasOwnProperty(v_c)))) ) {
									v_tmp = ((p5str(v_tmp) + p5str(v_c)));
								}
								else {
									p5and((p5str(v_tmp) != ''), function () {
										return List_out.p5push([(String.fromCharCode(39) + p5str(v_tmp) + String.fromCharCode(39))])
									});
									List_out.p5push([('chr(' + p5str(p5pkg['Perlito5::Dumper'].ord([v_c], 0)) + ')')]);
									v_tmp = ('');
								}
								})();
							}, p5list_to_a([p5range(0, (p5pkg['Perlito5::Dumper'].length([v_s], 0) - 1), 1, "tmp3584", 0)]), false, '') })()
					})();
					p5and((p5str(v_tmp) != ''), function () {
						return List_out.p5push([(String.fromCharCode(39) + p5str(v_tmp) + String.fromCharCode(39))])
					});
					return (p5context([p5pkg['Perlito5::Dumper'].join([' . '].concat(p5list_to_a([List_out])), p5want)], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3583._prototype_ = null;
			return tmp3583
		})());
		p5typeglob_set('Perlito5::Dumper', '_identity', (function () {
			var tmp3585;
			tmp3585 = function (List__, p5want) {
				return (p5context([(p5str(List__.p5aget(0)) == p5str(List__.p5aget(1)))], p5want));
			};
			tmp3585._prototype_ = null;
			return tmp3585
		})());
		1;
	})();
	// use Perlito5::Dumper
;
	(function () {
		p5make_package('Perlito5::JSON');
		p5typeglob_set('Perlito5::JSON', 'ast_dumper', (function () {
			var tmp3586;
			tmp3586 = function (List__, p5want) {
				var v_seen;
				v_seen = ((new p5HashRef({})));
				var v_level;
				v_level = ('');
				var v_pos;
				v_pos = ('[TODO - recursive structure in AST is not supported]');
				return (p5pkg['Perlito5::JSON']._dumper(p5list_to_a([List__.p5aget(0), v_level, v_seen, v_pos]), p5want));
			};
			tmp3586._prototype_ = null;
			return tmp3586
		})());
		p5typeglob_set('Perlito5::JSON', '_dumper', (function () {
			var tmp3587;
			tmp3587 = function (List__, p5want) {
				try {
					var local_idx = p5LOCAL.length;
					var regex_tmp = p5_regex_capture;
					p5LOCAL.push(function(){ p5_regex_capture = regex_tmp });
					var v_obj;
					var v_tab;
					var v_seen;
					var v_pos;
					var tmp3588 = p5list_to_a([List__]);
					v_obj = tmp3588.shift();
					v_tab = tmp3588.shift();
					v_seen = tmp3588.shift();
					v_pos = tmp3588.shift();
					p5and(!( (v_obj != null)), function () {
						throw(p5context(['null'], p5want))
					});
					var v_ref;
					v_ref = (p5pkg['Perlito5::JSON'].ref([v_obj], 0));
					p5and(!( p5bool(v_ref)), function () {
						throw(p5pkg['Perlito5::JSON'].escape_string([v_obj], p5want))
					});
					var v_as_string;
					v_as_string = (v_obj);
					p5and((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_as_string)), function () {
						throw((v_seen || (v_seen = new p5HashRef({})))._hash_.p5hget(p5str(v_as_string)))
					});
					(v_seen || (v_seen = new p5HashRef({})))._hash_.p5hset(p5str(v_as_string), (v_pos));
					var v_tab1;
					v_tab1 = ((p5str(v_tab) + '  '));
					(function () {
						if ( (p5str(v_ref) == 'ARRAY') ) {
						(function () {
							p5or(p5num(p5array_deref((v_obj || (v_obj = new p5ArrayRef([]))), 'Perlito5::JSON')), function () {
								throw(p5context(['[]'], p5want))
							});
							var List_out = [];
							(function () {
								var v_i;
								(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
										var v_here;
										v_here = ((p5str(v_pos) + '[' + p5str(v_i) + ']'));
										List_out.p5push([(p5str(v_tab1) + p5str(p5pkg['Perlito5::JSON']._dumper(p5list_to_a([(v_obj || (v_obj = new p5ArrayRef([])))._array_.p5aget(p5num(v_i)), v_tab1, v_seen, v_here]), 0)))]);
									}, p5list_to_a([p5range(0, (p5array_deref((v_obj || (v_obj = new p5ArrayRef([]))), 'Perlito5::JSON').length - 1), 1, "tmp3589", 0)]), false, '') })()
							})();
							throw(p5context([('[' + String.fromCharCode(10) + p5pkg['Perlito5::JSON'].join([',' + String.fromCharCode(10)].concat(p5list_to_a([List_out])), 0) + String.fromCharCode(10) + p5str(v_tab) + ']')], p5want));
						})();
					}
					else (function () {
						if ( (p5str(v_ref) == 'SCALAR') ) {
						throw(p5context([('{ "_type": "SCALAR", "value": ' + p5str(p5pkg['Perlito5::JSON']._dumper(p5list_to_a([p5scalar_deref(v_obj, 'Perlito5::JSON', ""), v_tab1, v_seen, v_pos]), 0)) + ' }')], p5want));
					}
					else (function () {
						if ( (p5str(v_ref) == 'CODE') ) {
						throw(p5context(['{ "_type": "CODE", "value": "DUMMY" }'], p5want));
					}
					})()
					})()
					})();
					(function () {
							var tmp = p5s(v_ref, '^Perlito5::AST::', function () {
								return ''
							}, '', 0);
							v_ref = tmp[0];
							return tmp[1];
						})();
					var List_out = [];
					p5and((p5str(v_ref) != 'HASH'), function () {
						return List_out.p5push([('"_type": "' + p5str(v_ref) + '"')])
					});
					(function () {
						var v_i;
						(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
								var v_here;
								v_here = ((p5str(v_pos) + '{' + p5str(v_i) + '}'));
								List_out.p5push([(p5str(v_tab1) + ('"' + p5str(v_i) + '": ') + p5str(p5pkg['Perlito5::JSON']._dumper(p5list_to_a([(v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget(p5str(v_i)), v_tab1, v_seen, v_here]), 0)))]);
							}, p5list_to_a([p5sort(p5pkg['Perlito5::JSON'], function (p5want) {
								return (p5cmp(p5str(p5make_package('Perlito5::JSON')['v_a']), p5str(p5make_package('Perlito5::JSON')['v_b'])));
							}, p5list_to_a([p5pkg['Perlito5::JSON'].keys([p5hash_deref((v_obj || (v_obj = new p5HashRef({}))), 'Perlito5::JSON')], 1)]))]), false, '') })()
					})();
					return p5cleanup_local(local_idx, (p5context([('{ ' + p5pkg['Perlito5::JSON'].join([',' + String.fromCharCode(10)].concat(p5list_to_a([List_out])), 0) + String.fromCharCode(10) + p5str(v_tab) + '}')], p5want)));
					p5cleanup_local(local_idx, null);
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return p5cleanup_local(local_idx, err);
					}
				}
			};
			tmp3587._prototype_ = null;
			return tmp3587
		})());
		p5typeglob_set('Perlito5::JSON', 'escape_string', (function () {
			var tmp3590;
			tmp3590 = function (List__, p5want) {
				try {
					var v_s;
					v_s = (List__.shift());
					var List_out = [];
					p5and((p5str(v_s) == ''), function () {
						throw(p5context(['""'], p5want))
					});
					p5and(p5and((p5str((0 + p5num(v_s))) == p5str(v_s)), function () {
						return p5m(v_s, '[0-9]', '', 0)
					}), function () {
						throw(p5context([(0 + p5num(v_s))], p5want))
					});
					(function () {
						var v_i;
						(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
								var v_c;
								v_c = (p5str(v_s).substr(p5num(v_i), 1));
								(function () {
									if ( ((p5str(v_c) == String.fromCharCode(92)) || (p5str(v_c) == '"')) ) {
									List_out.p5push([(String.fromCharCode(92) + p5str(v_c))]);
								}
								else (function () {
									if ( (p5str(v_c) == String.fromCharCode(10)) ) {
									List_out.p5push([String.fromCharCode(92) + 'n']);
								}
								else (function () {
									if ( (p5str(v_c) == String.fromCharCode(13)) ) {
									List_out.p5push([String.fromCharCode(92) + 'r']);
								}
								else (function () {
									if ( (p5str(v_c) == String.fromCharCode(9)) ) {
									List_out.p5push([String.fromCharCode(92) + 't']);
								}
								else (function () {
									if ( (p5str(v_c) == String.fromCharCode(8)) ) {
									List_out.p5push([String.fromCharCode(92) + 'b']);
								}
								else (function () {
									if ( (p5str(v_c) == String.fromCharCode(12)) ) {
									List_out.p5push([String.fromCharCode(92) + 'f']);
								}
								else (function () {
									if ( (p5str(v_c) <= p5pkg['Perlito5::JSON'].chr([31], 0)) ) {
									List_out.p5push(p5list_to_a([p5pkg['Perlito5::JSON'].sprintf([String.fromCharCode(92) + 'u%04x'].concat([p5pkg['Perlito5::JSON'].ord([v_c], 1)]), 1)]));
								}
								else {
									List_out.p5push([v_c]);
								}
								})()
								})()
								})()
								})()
								})()
								})()
								})();
							}, p5list_to_a([p5range(0, (p5pkg['Perlito5::JSON'].length([v_s], 0) - 1), 1, "tmp3591", 0)]), false, '') })()
					})();
					return (p5context([p5pkg['Perlito5::JSON'].join([''].concat(p5list_to_a(['"', List_out, '"'])), p5want)], p5want));
				}
				catch(err) {
					if ( err instanceof Error ) {
						throw(err);
					}
					else {
						return(err);
					}
				}
			};
			tmp3590._prototype_ = null;
			return tmp3590
		})());
		1;
	})();
	// use Perlito5::JSON
;
	(function () {
		null;
		// use Perlito5::AST
;
		// use Perlito5::Dumper
;
		// use strict
;
		p5make_package('Perlito5::Javascript2');
		p5block(function (v) {}, function () {
				var Hash_label = {};
				p5typeglob_set('Perlito5::Javascript2', 'pkg', (function () {
					var tmp3592;
					tmp3592 = function (List__, p5want) {
						return (p5context([('p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ']')], p5want));
					};
					tmp3592._prototype_ = null;
					return tmp3592
				})());
				p5typeglob_set('Perlito5::Javascript2', 'get_label', (function () {
					var tmp3593;
					tmp3593 = function (List__, p5want) {
						return (p5context([('tmp' + p5str((function () {
	var tmp3594 = p5make_package('Perlito5')['v_ID'];
	p5make_package('Perlito5')['v_ID'] = p5incr_(tmp3594);
	return tmp3594
})()))], p5want));
					};
					tmp3593._prototype_ = null;
					return tmp3593
				})());
				p5typeglob_set('Perlito5::Javascript2', 'tab', (function () {
					var tmp3595;
					tmp3595 = function (List__, p5want) {
						var v_level;
						v_level = (List__.shift());
						return (p5str_replicate(String.fromCharCode(9),p5num(v_level)));
					};
					tmp3595._prototype_ = null;
					return tmp3595
				})());
				if (typeof p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_prefix_js_str'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_prefix_js_str'] = {};}
				p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_prefix_js_str'] = {'prefix:<-A>' : 'p5atime', 'prefix:<-C>' : 'p5ctime', 'prefix:<-M>' : 'p5mtime', 'prefix:<-d>' : 'p5is_directory', 'prefix:<-e>' : 'p5file_exists', 'prefix:<-f>' : 'p5is_file', 'prefix:<-s>' : 'p5size'};
				if (typeof p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_str'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_str'] = {};}
				p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_str'] = {'infix:<eq>' : ' == ', 'infix:<ne>' : ' != ', 'infix:<le>' : ' <= ', 'infix:<ge>' : ' >= ', 'infix:<lt>' : ' < ', 'infix:<gt>' : ' > '};
				if (typeof p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_num'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_num'] = {};}
				p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_num'] = {'infix:<==>' : ' == ', 'infix:<!=>' : ' != ', 'infix:<+>' : ' + ', 'infix:<->' : ' - ', 'infix:<*>' : ' * ', 'infix:</>' : ' / ', 'infix:<>>' : ' > ', 'infix:<<>' : ' < ', 'infix:<>=>' : ' >= ', 'infix:<<=>' : ' <= ', 'infix:<&>' : ' & ', 'infix:<|>' : ' | ', 'infix:<^>' : ' ^ ', 'infix:<>>>' : ' >>> '};
				if (typeof p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] = {}), 'Perlito5::Javascript2']['Hash_op_to_bool'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] = {}), 'Perlito5::Javascript2']['Hash_op_to_bool'] = {};}
				p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] = {}), 'Perlito5::Javascript2']['Hash_op_to_bool'] = p5a_to_h(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
							return ((p5context([p5make_package('main')['v__'], 1], 1)));
						}, ['prefix:<!>', 'infix:<!=>', 'infix:<==>', 'infix:<<=>', 'infix:<>=>', 'infix:<>>', 'infix:<<>', 'infix:<eq>', 'infix:<ne>', 'infix:<ge>', 'infix:<le>', 'infix:<gt>', 'infix:<lt>', 'infix:<~~>', 'prefix:<not>', 'exists', 'defined'])]));
				if (typeof p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] = {}), 'Perlito5::Javascript2']['Hash_op_to_str'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] = {}), 'Perlito5::Javascript2']['Hash_op_to_str'] = {};}
				p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] = {}), 'Perlito5::Javascript2']['Hash_op_to_str'] = p5a_to_h(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
							return ((p5context([p5make_package('main')['v__'], 1], 1)));
						}, ['substr', 'join', 'list:<.>', 'chr', 'lc', 'uc', 'lcfirst', 'ucfirst', 'ref'])]));
				if (typeof p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] = {}), 'Perlito5::Javascript2']['Hash_op_to_num'] == "undefined" ) { p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] = {}), 'Perlito5::Javascript2']['Hash_op_to_num'] = {};}
				p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] = {}), 'Perlito5::Javascript2']['Hash_op_to_num'] = p5a_to_h(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
							return ((p5context([p5make_package('main')['v__'], 1], 1)));
						}, ['length', 'index', 'ord', 'oct', 'infix:<->', 'infix:<+>', 'infix:<*>', 'infix:</>', 'infix:<%>', 'infix:<**>'])]));
				var Hash_safe_char = {};
				Hash_safe_char = p5a_to_h([' ', 1, '!', 1, '"', 1, '#', 1, '$', 1, '%', 1, '&', 1, '(', 1, ')', 1, '*', 1, '+', 1, ',', 1, '-', 1, '.', 1, '/', 1, ':', 1, ';', 1, '<', 1, '=', 1, '>', 1, '?', 1, '@', 1, '[', 1, ']', 1, '^', 1, '_', 1, '`', 1, '{', 1, '|', 1, '}', 1, '~', 1]);
				p5typeglob_set('Perlito5::Javascript2', 'escape_string', (function () {
					var tmp3596;
					tmp3596 = function (List__, p5want) {
						try {
							var v_s;
							v_s = (List__.shift());
							var List_out = [];
							var v_tmp;
							v_tmp = ('');
							p5and((p5str(v_s) == ''), function () {
								throw(p5context([String.fromCharCode(39) + String.fromCharCode(39)], p5want))
							});
							(function () {
								var v_i;
								(function(){ var v_i; p5for_lex(function (v) { v_i = v }, function () {
										var v_c;
										v_c = (p5str(v_s).substr(p5num(v_i), 1));
										(function () {
											if ( (((p5str(v_c) >= 'a') && (p5str(v_c) <= 'z')) || (((p5str(v_c) >= 'A') && (p5str(v_c) <= 'Z')) || (((p5str(v_c) >= '0') && (p5str(v_c) <= '9')) || (Hash_safe_char).hasOwnProperty(v_c)))) ) {
											v_tmp = ((p5str(v_tmp) + p5str(v_c)));
										}
										else {
											p5and((p5str(v_tmp) != ''), function () {
												return List_out.p5push([(String.fromCharCode(39) + p5str(v_tmp) + String.fromCharCode(39))])
											});
											List_out.p5push([('String.fromCharCode(' + p5str(p5pkg['Perlito5::Javascript2'].ord([v_c], 0)) + ')')]);
											v_tmp = ('');
										}
										})();
									}, p5list_to_a([p5range(0, (p5pkg['Perlito5::Javascript2'].length([v_s], 0) - 1), 1, "tmp3597", 0)]), false, '') })()
							})();
							p5and((p5str(v_tmp) != ''), function () {
								return List_out.p5push([(String.fromCharCode(39) + p5str(v_tmp) + String.fromCharCode(39))])
							});
							return (p5context([p5pkg['Perlito5::Javascript2'].join([' + '].concat(p5list_to_a([List_out])), p5want)], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3596._prototype_ = null;
					return tmp3596
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_str', (function () {
					var tmp3598;
					tmp3598 = function (List__, p5want) {
						try {
							var v_cond;
							v_cond = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							var v_wantarray;
							v_wantarray = ('scalar');
							(function () {
								if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_cond, 'code', [], 0)) == 'circumfix:<( )>') && (p5bool((v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget('arguments')) && p5bool(p5num(p5array_deref((v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::Javascript2')))))) ) {
								throw(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), v_level]), p5want));
							}
							})();
							return (function () {
								if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Buf'], 0)) || (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] = {}), 'Perlito5::Javascript2']['Hash_op_to_str']).hasOwnProperty(p5call(v_cond, 'code', [], p5want)))) ) {
								(function () {
									throw(p5call(v_cond, 'emit_javascript2', [v_level, v_wantarray], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([('p5str(' + p5str(p5call(v_cond, 'emit_javascript2', [v_level, v_wantarray], 0)) + ')')], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3598._prototype_ = null;
					return tmp3598
				})());
				p5typeglob_set('Perlito5::Javascript2', 'is_num', (function () {
					var tmp3599;
					tmp3599 = function (List__, p5want) {
						try {
							var v_cond;
							v_cond = (List__.shift());
							p5and(p5or(p5call(v_cond, 'isa', ['Perlito5::AST::Int'], 0), function () {
								return p5or(p5call(v_cond, 'isa', ['Perlito5::AST::Num'], 0), function () {
									return p5context([p5and(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0), function () {
										return (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] = {}), 'Perlito5::Javascript2']['Hash_op_to_num']).hasOwnProperty(p5call(v_cond, 'code', [], p5want))
									})], 0)
								})
							}), function () {
								throw(p5context([1], p5want))
							});
							return (p5context([0], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3599._prototype_ = null;
					return tmp3599
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_num', (function () {
					var tmp3600;
					tmp3600 = function (List__, p5want) {
						try {
							var v_cond;
							v_cond = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							var v_wantarray;
							v_wantarray = ('scalar');
							return (function () {
								if ( p5bool(p5pkg['Perlito5::Javascript2'].is_num([v_cond], 0)) ) {
								(function () {
									throw(p5call(v_cond, 'emit_javascript2', [v_level, v_wantarray], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([('p5num(' + p5str(p5call(v_cond, 'emit_javascript2', [v_level, v_wantarray], 0)) + ')')], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3600._prototype_ = null;
					return tmp3600
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_bool', (function () {
					var tmp3601;
					tmp3601 = function (List__, p5want) {
						try {
							var v_cond;
							v_cond = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							var v_wantarray;
							v_wantarray = ('scalar');
							(function () {
								if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_cond, 'code', [], 0)) == 'circumfix:<( )>') && (p5bool((v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget('arguments')) && p5bool(p5num(p5array_deref((v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::Javascript2')))))) ) {
								throw(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), v_level]), p5want));
							}
							})();
							(function () {
								if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_cond, 'code', [], 0)) == 'infix:<&&>') || (p5str(p5call(v_cond, 'code', [], 0)) == 'infix:<and>'))) ) {
								throw(p5context([('(' + p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), v_level]), 0)) + ' && ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), v_level]), 0)) + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_cond, 'code', [], 0)) == 'infix:<||>') || (p5str(p5call(v_cond, 'code', [], 0)) == 'infix:<or>'))) ) {
								throw(p5context([('(' + p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), v_level]), 0)) + ' || ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_cond || (v_cond = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), v_level]), 0)) + ')')], p5want));
							}
							})();
							return (function () {
								if ( (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Int'], 0)) || (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Num'], 0)) || (p5bool(p5call(v_cond, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] = {}), 'Perlito5::Javascript2']['Hash_op_to_bool']).hasOwnProperty(p5call(v_cond, 'code', [], p5want))))) ) {
								(function () {
									throw(p5call(v_cond, 'emit_javascript2', [v_level, v_wantarray], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([('p5bool(' + p5str(p5call(v_cond, 'emit_javascript2', [v_level, v_wantarray], 0)) + ')')], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3601._prototype_ = null;
					return tmp3601
				})());
				p5typeglob_set('Perlito5::Javascript2', 'is_scalar', (function () {
					var tmp3602;
					tmp3602 = function (List__, p5want) {
						return (p5and(!( p5bool(p5call(List__.p5aget(0), 'isa', ['Perlito5::AST::Int'], 0))), function () {
									return p5and(!( p5bool(p5call(List__.p5aget(0), 'isa', ['Perlito5::AST::Num'], 0))), function () {
										return p5and(!( p5bool(p5call(List__.p5aget(0), 'isa', ['Perlito5::AST::Buf'], 0))), function () {
											return p5and(!( p5bool(p5call(List__.p5aget(0), 'isa', ['Perlito5::AST::Sub'], 0))), function () {
												return p5and(!( (p5bool(p5call(List__.p5aget(0), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(List__.p5aget_hash(0)._hash_.p5hget('sigil')) == '$'))), function () {
													return !( (p5bool(p5call(List__.p5aget(0), 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_str'] = {}), 'Perlito5::Javascript2']['Hash_op_to_str']).hasOwnProperty(List__.p5aget_hash(0)._hash_.p5hget('code')) || ((p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_num'] = {}), 'Perlito5::Javascript2']['Hash_op_to_num']).hasOwnProperty(List__.p5aget_hash(0)._hash_.p5hget('code')) || (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] || (p5make_package('Perlito5::Javascript2')['Hash_op_to_bool'] = {}), 'Perlito5::Javascript2']['Hash_op_to_bool']).hasOwnProperty(List__.p5aget_hash(0)._hash_.p5hget('code'))))))
												})
											})
										})
									})
								}));
					};
					tmp3602._prototype_ = null;
					return tmp3602
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_list', (function () {
					var tmp3603;
					tmp3603 = function (List__, p5want) {
						try {
							var v_items;
							v_items = (p5pkg['Perlito5::Javascript2'].to_list_preprocess(p5list_to_a([List__.p5aget(0)]), 0));
							var v_level;
							v_level = (List__.p5aget(1));
							var v_literal_type;
							v_literal_type = (p5or(List__.p5aget(2), function () {
										return 'array'
									}));
							var v_wantarray;
							v_wantarray = ('list');
							var v_interpolate;
							v_interpolate = (0);
							p5for(p5make_package('main'), "v__", function () {
									p5and(p5pkg['Perlito5::Javascript2'].is_scalar([p5make_package('main')['v__']], 0), function () {
										return v_interpolate = (1)
									});
								}, p5list_to_a([p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2')]), false, '');
							(function () {
								if ( (p5str(v_literal_type) == 'hash') ) {
								(function () {
									if ( !( p5bool(v_interpolate)) ) {
									(function () {
										var List_out = [];
										var v_printable;
										v_printable = (1);
										var List_in = [];
										List_in = p5list_to_a([p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2')]);
										(function () {
											p5while(function () {
												var v_k;
												v_k = (List_in.shift());
												var v_v;
												v_v = (List_in.shift());
												v_k = (p5call(v_k, 'emit_javascript2', [v_level, 0], 0));
												p5and(p5m(v_k, '[ ' + String.fromCharCode(92) + '[]', '', 0), function () {
													return v_printable = (0)
												});
												v_v = (( p5bool(v_v) ? p5call(v_v, 'emit_javascript2', [v_level, 0], 0) : 'null'));
												List_out.p5push([(p5str(v_k) + ' : ' + p5str(v_v))]);
											}, function () {
												return List_in.length
											}, false, '', 0)
										})();
										p5and(v_printable, function () {
											throw(p5context([('{' + p5pkg['Perlito5::Javascript2'].join([', '].concat(p5list_to_a([List_out])), 0) + '}')], p5want))
										});
									})();
								}
								})();
								throw(p5context([('p5a_to_h(' + p5str(p5pkg['Perlito5::Javascript2'].to_list([v_items, v_level, 'array'], 0)) + ')')], p5want));
							}
							})();
							return (( p5bool(v_interpolate) ? p5context([('p5list_to_a([' + p5pkg['Perlito5::Javascript2'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2')]))])), 0) + '])')], p5want) : p5context([('[' + p5pkg['Perlito5::Javascript2'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2')]))])), 0) + ']')], p5want)));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3603._prototype_ = null;
					return tmp3603
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_list_preprocess', (function () {
					var tmp3604;
					tmp3604 = function (List__, p5want) {
						var List_items = [];
						(function () {
								var v_item;
								(function(){ var v_item; p5for_lex(function (v) { v_item = v }, function () {
										(function () {
											if ( (p5bool(p5call(v_item, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_item, 'code', [], 0)) == 'circumfix:<( )>') || ((p5str(p5call(v_item, 'code', [], 0)) == 'list:<,>') || (p5str(p5call(v_item, 'code', [], 0)) == 'infix:<=>>')))) ) {
											(function () {
												if ( (p5bool(p5call(v_item, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call(v_item, 'code', [], 0)) == 'infix:<=>>')) ) {
												(v_item || (v_item = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aset(0, (p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_item || (v_item = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)));
											}
											})();
											(function () {
												var v_arg;
												(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
														List_items.p5push([v_arg]);
													}, p5list_to_a([p5array_deref(p5pkg['Perlito5::Javascript2'].to_list_preprocess(p5list_to_a([p5call(v_item, 'arguments', [], 1)]), p5want), 'Perlito5::Javascript2')]), false, '') })()
											})();
										}
										else {
											List_items.p5push([v_item]);
										}
										})();
									}, p5list_to_a([p5array_deref(List__.p5aget_array(0), 'Perlito5::Javascript2')]), false, '') })()
							})();
						return ((new p5ArrayRef(List_items)));
					};
					tmp3604._prototype_ = null;
					return tmp3604
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_scalar', (function () {
					var tmp3605;
					tmp3605 = function (List__, p5want) {
						var v_items;
						v_items = (p5pkg['Perlito5::Javascript2'].to_scalar_preprocess(p5list_to_a([List__.p5aget(0)]), 0));
						var v_level;
						v_level = (List__.p5aget(1));
						var v_wantarray;
						v_wantarray = ('scalar');
						return (( p5bool(p5num(p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2'))) ? ('(' + p5pkg['Perlito5::Javascript2'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2')]))])), 0) + ')') : 'null'));
					};
					tmp3605._prototype_ = null;
					return tmp3605
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_scalar_preprocess', (function () {
					var tmp3606;
					tmp3606 = function (List__, p5want) {
						var List_items = [];
						(function () {
								var v_item;
								(function(){ var v_item; p5for_lex(function (v) { v_item = v }, function () {
										(function () {
											if ( (p5bool(p5call(v_item, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_item, 'code', [], 0)) == 'list:<,>') || (p5str(p5call(v_item, 'code', [], 0)) == 'infix:<=>>'))) ) {
											(function () {
												if ( (p5bool(p5call(v_item, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call(v_item, 'code', [], 0)) == 'infix:<=>>')) ) {
												(v_item || (v_item = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aset(0, (p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_item || (v_item = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)));
											}
											})();
											(function () {
												var v_arg;
												(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
														List_items.p5push([v_arg]);
													}, p5list_to_a([p5array_deref(p5pkg['Perlito5::Javascript2'].to_scalar_preprocess(p5list_to_a([p5call(v_item, 'arguments', [], 1)]), p5want), 'Perlito5::Javascript2')]), false, '') })()
											})();
										}
										else {
											List_items.p5push([v_item]);
										}
										})();
									}, p5list_to_a([p5array_deref(List__.p5aget_array(0), 'Perlito5::Javascript2')]), false, '') })()
							})();
						return ((new p5ArrayRef(List_items)));
					};
					tmp3606._prototype_ = null;
					return tmp3606
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_runtime_context', (function () {
					var tmp3607;
					tmp3607 = function (List__, p5want) {
						try {
							var v_items;
							v_items = (p5pkg['Perlito5::Javascript2'].to_scalar_preprocess(p5list_to_a([List__.p5aget(0)]), 0));
							var v_level;
							v_level = (List__.p5aget(1));
							var v_wantarray;
							v_wantarray = ('runtime');
							p5and(p5and((p5num(p5num(p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2'))) == 1), function () {
								return p5pkg['Perlito5::Javascript2'].is_scalar(p5list_to_a([(v_items || (v_items = new p5ArrayRef([])))._array_.p5aget(0)]), 0)
							}), function () {
								throw(p5call((v_items || (v_items = new p5ArrayRef([])))._array_.p5aget(0), 'emit_javascript2', [v_level, v_wantarray], p5want))
							});
							return (p5context([('p5context(' + '[' + p5pkg['Perlito5::Javascript2'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_items || (v_items = new p5ArrayRef([]))), 'Perlito5::Javascript2')]))])), 0) + ']' + ', p5want)')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3607._prototype_ = null;
					return tmp3607
				})());
				p5typeglob_set('Perlito5::Javascript2', 'to_context', (function () {
					var tmp3608;
					tmp3608 = function (List__, p5want) {
						var v_wantarray;
						v_wantarray = (List__.shift());
						return (( (p5str(v_wantarray) == 'list') ? '1' : ( (p5str(v_wantarray) == 'scalar') ? '0' : ( (p5str(v_wantarray) == 'void') ? 'null' : 'p5want'))));
					};
					tmp3608._prototype_ = null;
					return tmp3608
				})());
				p5typeglob_set('Perlito5::Javascript2', 'autoquote', (function () {
					var tmp3609;
					tmp3609 = function (List__, p5want) {
						var v_index;
						v_index = (List__.shift());
						var v_level;
						v_level = (List__.shift());
						v_index = (p5call('Perlito5::AST::Lookup', 'autoquote', [v_index], 0));
						return (p5pkg['Perlito5::Javascript2'].to_str([v_index, v_level], p5want));
					};
					tmp3609._prototype_ = null;
					return tmp3609
				})());
				p5typeglob_set('Perlito5::Javascript2', 'emit_javascript2_autovivify', (function () {
					var tmp3610;
					tmp3610 = function (List__, p5want) {
						try {
							var v_obj;
							v_obj = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							var v_type;
							v_type = (List__.shift());
							(function () {
								if ( (p5bool(p5call(v_obj, 'isa', ['Perlito5::AST::Index'], 0)) || (p5bool(p5call(v_obj, 'isa', ['Perlito5::AST::Lookup'], 0)) || p5bool(p5call(v_obj, 'isa', ['Perlito5::AST::Call'], 0)))) ) {
								throw(p5call(v_obj, 'emit_javascript2', [v_level, 0, v_type], p5want));
							}
							})();
							(function () {
								if ( (p5bool(p5call(v_obj, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call(v_obj, 'code', [], 0)) == 'prefix:<$>')) ) {
								(function () {
									var v_arg;
									v_arg = ((v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									throw(p5context([('p5scalar_deref(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_type], 0)) + ')')], p5want));
								})();
							}
							})();
							(function () {
								if ( p5bool(p5call(v_obj, 'isa', ['Perlito5::AST::Apply'], 0)) ) {
								throw(p5call(v_obj, 'emit_javascript2', [v_level], p5want));
							}
							})();
							(function () {
								if ( p5bool(p5call(v_obj, 'isa', ['Perlito5::AST::Buf'], 0)) ) {
								throw(p5call(v_obj, 'emit_javascript2', [v_level], p5want));
							}
							})();
							return (p5context([('(' + p5str(p5call(v_obj, 'emit_javascript2', [v_level], 0)) + ' || (' + p5str(p5call(v_obj, 'emit_javascript2', [v_level], 0)) + ' = ' + p5str(( (p5str(v_type) == 'array') ? 'new p5ArrayRef([])' : ( (p5str(v_type) == 'hash') ? 'new p5HashRef({})' : 'new p5ScalarRef(null)'))) + ')' + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3610._prototype_ = null;
					return tmp3610
				})());
				p5typeglob_set('Perlito5::Javascript2', 'emit_javascript2_list_with_tabs', (function () {
					var tmp3611;
					tmp3611 = function (List__, p5want) {
						var v_level;
						var v_argument;
						var tmp3612 = p5list_to_a([List__]);
							v_level = tmp3612.shift();
							v_argument = tmp3612.shift();
						var v_tab;
						v_tab = (p5pkg['Perlito5::Javascript2'].tab([v_level], 0));
						return (p5map(p5pkg['Perlito5::Javascript2'], function (p5want) {
									return (( (p5pkg['Perlito5::Javascript2'].ref([p5make_package('main')['v__']], 0) == 'ARRAY') ? p5pkg['Perlito5::Javascript2'].emit_javascript2_list_with_tabs([(p5num(v_level) + 1), p5make_package('main')['v__']], p5want) : (p5str(v_tab) + p5str(p5make_package('main')['v__']))));
								}, p5list_to_a([p5array_deref((v_argument || (v_argument = new p5ArrayRef([]))), 'Perlito5::Javascript2')])));
					};
					tmp3611._prototype_ = null;
					return tmp3611
				})());
				p5typeglob_set('Perlito5::Javascript2', 'emit_func_javascript2', (function () {
					var tmp3613;
					tmp3613 = function (List__, p5want) {
						var v_level;
						var v_wantarray;
						var List_argument = [];
						var tmp3614 = p5list_to_a([List__]);
							v_level = tmp3614.shift();
							v_wantarray = tmp3614.shift();
							List_argument = tmp3614;
							tmp3614 = [];
						return (p5context([p5pkg['Perlito5::Javascript2'].join([String.fromCharCode(10)].concat(p5list_to_a(['function () {', p5pkg['Perlito5::Javascript2'].emit_javascript2_list_with_tabs(p5list_to_a([v_level, (new p5ArrayRef(p5list_to_a([(new p5ArrayRef(List_argument)), '}'])))]), 1)])), p5want)], p5want));
					};
					tmp3613._prototype_ = null;
					return tmp3613
				})());
				p5typeglob_set('Perlito5::Javascript2', 'emit_wrap_javascript2', (function () {
					var tmp3615;
					tmp3615 = function (List__, p5want) {
						var v_level;
						var v_wantarray;
						var List_argument = [];
						var tmp3616 = p5list_to_a([List__]);
							v_level = tmp3616.shift();
							v_wantarray = tmp3616.shift();
							List_argument = tmp3616;
							tmp3616 = [];
						return (p5context([p5pkg['Perlito5::Javascript2'].join([String.fromCharCode(10)].concat(p5list_to_a(['(function () {', p5pkg['Perlito5::Javascript2'].emit_javascript2_list_with_tabs(p5list_to_a([v_level, (new p5ArrayRef(p5list_to_a([(new p5ArrayRef(List_argument)), '})()'])))]), 1)])), p5want)], p5want));
					};
					tmp3615._prototype_ = null;
					return tmp3615
				})());
				p5typeglob_set('Perlito5::Javascript2', 'emit_function_javascript2', (function () {
					var tmp3617;
					tmp3617 = function (List__, p5want) {
						var v_level;
						var v_wantarray;
						var v_argument;
						var tmp3618 = p5list_to_a([List__]);
							v_level = tmp3618.shift();
							v_wantarray = tmp3618.shift();
							v_argument = tmp3618.shift();
						return (function () {
								if ( (p5bool(p5call(v_argument, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_argument, 'code', [], 0)) == 'return') || ((p5str(p5call(v_argument, 'code', [], 0)) == 'last') || ((p5str(p5call(v_argument, 'code', [], 0)) == 'next') || (p5str(p5call(v_argument, 'code', [], 0)) == 'redo'))))) ) {
								return (p5pkg['Perlito5::Javascript2'].emit_func_javascript2(p5list_to_a([v_level, v_wantarray, p5call(v_argument, 'emit_javascript2', [v_level, v_wantarray], 1)]), p5want));
							}
							else {
								return (p5pkg['Perlito5::Javascript2'].emit_func_javascript2([v_level, v_wantarray, ('return ' + p5str(p5call(v_argument, 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)))], p5want));
							}
							})()
					};
					tmp3617._prototype_ = null;
					return tmp3617
				})());
				p5typeglob_set('Perlito5::Javascript2', 'emit_wrap_statement_javascript2', (function () {
					var tmp3619;
					tmp3619 = function (List__, p5want) {
						try {
							var v_level;
							var v_wantarray;
							var v_argument;
							var tmp3620 = p5list_to_a([List__]);
							v_level = tmp3620.shift();
							v_wantarray = tmp3620.shift();
							v_argument = tmp3620.shift();
							(function () {
								if ( (p5str(v_wantarray) == 'void') ) {
								throw(p5context([v_argument], p5want));
							}
							})();
							return (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, v_wantarray, v_argument], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3619._prototype_ = null;
					return tmp3619
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::Javascript2::LexicalBlock');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::Javascript2::LexicalBlock', 'new', (function () {
					var tmp3621;
					tmp3621 = function (List__, p5want) {
						var v_class;
						v_class = (List__.shift());
						return (p5pkg['Perlito5::Javascript2::LexicalBlock'].bless([(new p5HashRef(p5a_to_h(p5list_to_a([List__])))), v_class], p5want));
					};
					tmp3621._prototype_ = null;
					return tmp3621
				})());
				p5typeglob_set('Perlito5::Javascript2::LexicalBlock', 'block', (function () {
					var tmp3622;
					tmp3622 = function (List__, p5want) {
						return (List__.p5aget_hash(0)._hash_.p5hget('block'));
					};
					tmp3622._prototype_ = null;
					return tmp3622
				})());
				p5typeglob_set('Perlito5::Javascript2::LexicalBlock', 'has_decl', (function () {
					var tmp3623;
					tmp3623 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.p5aget(0));
							var v_type;
							v_type = (List__.p5aget(1));
							(function () {
								var v_decl;
								(function(){ var v_decl; p5for_lex(function (v) { v_decl = v }, function () {
										p5and(p5grep(p5pkg['Perlito5::Javascript2::LexicalBlock'], function (p5want) {
											return (((p5str((p5make_package('main')['v__'] || (p5make_package('main')['v__'] = new p5HashRef({})))._hash_.p5hget('decl')) == p5str(v_type))));
										}, p5list_to_a([p5call(v_decl, 'emit_javascript2_get_decl', [], 1)])), function () {
											throw(p5context([1], p5want))
										});
									}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::Javascript2::LexicalBlock')]), false, '') })()
							})();
							return (p5context([0], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3623._prototype_ = null;
					return tmp3623
				})());
				p5typeglob_set('Perlito5::Javascript2::LexicalBlock', 'emit_javascript2_subroutine_body', (function () {
					var tmp3624;
					tmp3624 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3625 = p5list_to_a([List__]);
							v_self = tmp3625.shift();
							v_level = tmp3625.shift();
							v_wantarray = tmp3625.shift();
						(v_self || (v_self = new p5HashRef({})))._hash_.p5hset('top_level', (1));
						var v_outer_throw;
						v_outer_throw = (p5make_package('Perlito5')['v_THROW']);
						p5make_package('Perlito5')['v_THROW'] = (0);
						var v_s;
						v_s = (p5call(v_self, 'emit_javascript2', [v_level, v_wantarray], 0));
						p5make_package('Perlito5')['v_THROW'] = (v_outer_throw);
						return (p5context([v_s], p5want));
					};
					tmp3624._prototype_ = null;
					return tmp3624
				})());
				p5typeglob_set('Perlito5::Javascript2::LexicalBlock', 'emit_javascript2', (function () {
					var tmp3626;
					tmp3626 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp3627 = p5list_to_a([List__]);
							v_self = tmp3627.shift();
							v_level = tmp3627.shift();
							v_wantarray = tmp3627.shift();
							var v_original_level;
							v_original_level = (v_level);
							var List_block = [];
							(function () {
								var v_stmt;
								(function(){ var v_stmt; p5for_lex(function (v) { v_stmt = v }, function () {
										(function () {
											if ( (v_stmt != null) ) {
											List_block.p5push([v_stmt]);
										}
										})();
									}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::Javascript2::LexicalBlock')]), false, '') })()
							})();
							(function () {
								if ( !( p5bool(List_block.length)) ) {
								p5and((p5str(v_wantarray) == 'list'), function () {
									throw(p5context(['return []'], p5want))
								});
								p5and((p5str(v_wantarray) == 'scalar'), function () {
									throw(p5context(['return null'], p5want))
								});
								p5and((p5str(v_wantarray) == 'runtime'), function () {
									throw(p5context(['return p5want ? [] : null'], p5want))
								});
								throw(p5context(['null;'], p5want));
							}
							})();
							var List_str = [];
							var v_has_local;
							v_has_local = (p5call(v_self, 'has_decl', ['local'], 0));
							var v_has_regex;
							v_has_regex = (0);
							(function () {
								if ( p5bool(p5grep(p5pkg['Perlito5::Javascript2::LexicalBlock'], function (p5want) {
									return ((p5call(p5make_package('main')['v__'], 'emit_javascript2_has_regex', [], 0)));
								}, p5list_to_a([List_block]))) ) {
								v_has_local = (1);
								v_has_regex = (1);
							}
							})();
							var v_create_context;
							v_create_context = (p5and((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('create_context'), function () {
										return p5call(v_self, 'has_decl', ['my'], 0)
									}));
							var v_outer_pkg;
							v_outer_pkg = (p5make_package('Perlito5')['v_PKG_NAME']);
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('top_level')) || p5bool(v_create_context)) ) {
								(function () {
									var tmp3628 = v_level;
									v_level = p5incr_(tmp3628);
									return tmp3628
								})();
							}
							})();
							var v_last_statement;
							(function () {
								if ( (p5str(v_wantarray) != 'void') ) {
								v_last_statement = (List_block.pop());
							}
							})();
							(function () {
								var v_decl;
								(function(){ var v_decl; p5for_lex(function (v) { v_decl = v }, function () {
										(function () {
											if ( ((p5pkg['Perlito5::Javascript2::LexicalBlock'].ref([v_decl], 0) == 'Perlito5::AST::Apply') && (p5str(p5call(v_decl, 'code', [], 0)) == 'package')) ) {
											p5make_package('Perlito5')['v_PKG_NAME'] = ((v_decl || (v_decl = new p5HashRef({})))._hash_.p5hget('namespace'));
										}
										})();
										var List_var_decl = [];
										List_var_decl = p5list_to_a([p5call(v_decl, 'emit_javascript2_get_decl', [], 1)]);
										(function () {
											var v_arg;
											(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
													List_str.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2_init', [v_level, v_wantarray], 1)]));
												}, p5list_to_a([List_var_decl]), false, '') })()
										})();
										(function () {
											if ( !( (p5bool(p5call(v_decl, 'isa', ['Perlito5::AST::Decl'], 0)) && (p5str(p5call(v_decl, 'decl', [], 0)) == 'my'))) ) {
											List_str.p5push([(p5str(p5call(v_decl, 'emit_javascript2', [v_level, 'void'], 0)) + ';')]);
										}
										})();
									}, p5list_to_a([List_block]), false, '') })()
							})();
							(function () {
								if ( p5bool(v_last_statement) ) {
								(function () {
									var List_var_decl = [];
									List_var_decl = p5list_to_a([p5call(v_last_statement, 'emit_javascript2_get_decl', [], 1)]);
									(function () {
										var v_arg;
										(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
												List_str.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2_init', [v_level, v_wantarray], 1)]));
											}, p5list_to_a([List_var_decl]), false, '') })()
									})();
									(function () {
										if ( (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_last_statement, 'code', [], 0)) == 'return') && (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('top_level')) && p5bool(p5num(p5array_deref((v_last_statement || (v_last_statement = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::Javascript2::LexicalBlock')))))) ) {
										v_last_statement = ((v_last_statement || (v_last_statement = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::For'], 0)) || (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::While'], 0)) || (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::If'], 0)) || (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::Block'], 0)) || (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::Use'], 0)) || ((p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call(v_last_statement, 'code', [], 0)) == 'goto')) || (p5bool(p5call(v_last_statement, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call(v_last_statement, 'code', [], 0)) == 'return')))))))) ) {
										List_str.p5push(p5list_to_a([p5call(v_last_statement, 'emit_javascript2', [v_level, v_wantarray], 1)]));
									}
									else (function () {
										if ( p5bool(v_has_local) ) {
										List_str.p5push([('return p5cleanup_local(local_idx, (' + p5str(( (p5str(v_wantarray) == 'runtime') ? p5pkg['Perlito5::Javascript2'].to_runtime_context(p5list_to_a([(new p5ArrayRef([v_last_statement])), (p5num(v_level) + 1)]), 0) : ( (p5str(v_wantarray) == 'scalar') ? p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_last_statement])), (p5num(v_level) + 1)]), 0) : p5call(v_last_statement, 'emit_javascript2', [v_level, v_wantarray], 0)))) + '));')]);
									}
									else {
										List_str.p5push([('return (' + p5str(( (p5str(v_wantarray) == 'runtime') ? p5pkg['Perlito5::Javascript2'].to_runtime_context(p5list_to_a([(new p5ArrayRef([v_last_statement])), (p5num(v_level) + 1)]), 0) : ( (p5str(v_wantarray) == 'scalar') ? p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_last_statement])), (p5num(v_level) + 1)]), 0) : p5call(v_last_statement, 'emit_javascript2', [v_level, v_wantarray], 0)))) + ');')]);
									}
									})()
									})();
								})();
							}
							})();
							(function () {
								if ( p5bool(v_has_local) ) {
								List_str.p5unshift(p5list_to_a(['var local_idx = p5LOCAL.length;', ( p5bool(v_has_regex) ? p5context(['var regex_tmp = p5_regex_capture;', 'p5LOCAL.push(function(){ p5_regex_capture = regex_tmp });'], 1) : p5context([], 1))]));
								List_str.p5push(['p5cleanup_local(local_idx, null);']);
							}
							})();
							var v_out;
							(function () {
								if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('top_level')) && p5bool(p5make_package('Perlito5')['v_THROW'])) ) {
								(function () {
									v_level = (v_original_level);
									var v_tab;
									v_tab = ((String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0))));
									v_out = (('try {' + p5str(v_tab) + p5pkg['Perlito5::Javascript2::LexicalBlock'].join([v_tab].concat(p5list_to_a([List_str])), 0) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + 'catch(err) {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + 'if ( err instanceof Error ) {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + 'throw(err);' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + 'else {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + p5str(( p5bool(v_has_local) ? 'return p5cleanup_local(local_idx, err)' : 'return(err)')) + ';' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}'));
								})();
							}
							else (function () {
								if ( p5bool(v_create_context) ) {
								(function () {
									v_level = (v_original_level);
									var v_tab;
									v_tab = ((String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0))));
									v_out = (('(function () {' + p5str(v_tab) + p5pkg['Perlito5::Javascript2::LexicalBlock'].join([v_tab].concat(p5list_to_a([List_str])), 0) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '})();'));
								})();
							}
							else {
								(function () {
									v_level = (v_original_level);
									var v_tab;
									v_tab = ((String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0))));
									v_out = (p5pkg['Perlito5::Javascript2::LexicalBlock'].join([v_tab].concat(p5list_to_a([List_str])), 0));
								})();
							}
							})()
							})();
							p5make_package('Perlito5')['v_PKG_NAME'] = (v_outer_pkg);
							return (p5context([v_out], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3626._prototype_ = null;
					return tmp3626
				})());
				p5typeglob_set('Perlito5::Javascript2::LexicalBlock', 'emit_javascript2_has_regex', (function () {
					var tmp3629;
					tmp3629 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3629._prototype_ = null;
					return tmp3629
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::CompUnit');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::CompUnit', 'emit_javascript2', (function () {
					var tmp3630;
					tmp3630 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3631 = p5list_to_a([List__]);
							v_self = tmp3631.shift();
							v_level = tmp3631.shift();
							v_wantarray = tmp3631.shift();
						return (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, p5call(p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')]), 0), 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 1)]), p5want));
					};
					tmp3630._prototype_ = null;
					return tmp3630
				})());
				p5typeglob_set('Perlito5::AST::CompUnit', 'emit_javascript2_program', (function () {
					var tmp3632;
					tmp3632 = function (List__, p5want) {
						var v_comp_units;
						var Hash_options = {};
						var tmp3633 = p5list_to_a([List__]);
							v_comp_units = tmp3633.shift();
							Hash_options = p5a_to_h(tmp3633);
							tmp3633 = [];
						p5make_package('Perlito5')['v_PKG_NAME'] = ('main');
						var v_level;
						v_level = (0);
						var v_wantarray;
						v_wantarray = ('void');
						var v_str;
						(function () {
								if ( p5bool(Hash_options.p5hget('expand_use')) ) {
								(v_str = ((p5str(v_str) + p5str(p5call('Perlito5::Javascript2::Runtime', 'emit_javascript2', [], 0)))));
								(v_str = ((p5str(v_str) + p5str(p5call('Perlito5::Javascript2::Array', 'emit_javascript2', [], 0)))));
								(v_str = ((p5str(v_str) + p5str(p5call('Perlito5::Javascript2::CORE', 'emit_javascript2', [], 0)))));
								(v_str = ((p5str(v_str) + p5str(p5call('Perlito5::Javascript2::IO', 'emit_javascript2', [], 0)))));
								(v_str = ((p5str(v_str) + p5str(p5call('Perlito5::Javascript2::Sprintf', 'emit_javascript2', [], 0)))));
							}
							})();
						(v_str = ((p5str(v_str) + ('var p5want;' + String.fromCharCode(10) + 'var List__ = [];' + String.fromCharCode(10)))));
						(function () {
								var v_comp_unit;
								(function(){ var v_comp_unit; p5for_lex(function (v) { v_comp_unit = v }, function () {
										v_str = ((p5str(v_str) + p5str(p5call(v_comp_unit, 'emit_javascript2', [v_level, v_wantarray], 0)) + String.fromCharCode(10)));
									}, p5list_to_a([p5array_deref((v_comp_units || (v_comp_units = new p5ArrayRef([]))), 'Perlito5::AST::CompUnit')]), false, '') })()
							})();
						return (p5context([v_str], p5want));
					};
					tmp3632._prototype_ = null;
					return tmp3632
				})());
				p5typeglob_set('Perlito5::AST::CompUnit', 'emit_javascript2_get_decl', (function () {
					var tmp3634;
					tmp3634 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3634._prototype_ = null;
					return tmp3634
				})());
				p5typeglob_set('Perlito5::AST::CompUnit', 'emit_javascript2_has_regex', (function () {
					var tmp3635;
					tmp3635 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3635._prototype_ = null;
					return tmp3635
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Int');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Int', 'emit_javascript2', (function () {
					var tmp3636;
					tmp3636 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3637 = p5list_to_a([List__]);
							v_self = tmp3637.shift();
							v_level = tmp3637.shift();
							v_wantarray = tmp3637.shift();
						return ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('int'));
					};
					tmp3636._prototype_ = null;
					return tmp3636
				})());
				p5typeglob_set('Perlito5::AST::Int', 'emit_javascript2_get_decl', (function () {
					var tmp3638;
					tmp3638 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3638._prototype_ = null;
					return tmp3638
				})());
				p5typeglob_set('Perlito5::AST::Int', 'emit_javascript2_has_regex', (function () {
					var tmp3639;
					tmp3639 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3639._prototype_ = null;
					return tmp3639
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Num');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Num', 'emit_javascript2', (function () {
					var tmp3640;
					tmp3640 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3641 = p5list_to_a([List__]);
							v_self = tmp3641.shift();
							v_level = tmp3641.shift();
							v_wantarray = tmp3641.shift();
						return ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('num'));
					};
					tmp3640._prototype_ = null;
					return tmp3640
				})());
				p5typeglob_set('Perlito5::AST::Num', 'emit_javascript2_get_decl', (function () {
					var tmp3642;
					tmp3642 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3642._prototype_ = null;
					return tmp3642
				})());
				p5typeglob_set('Perlito5::AST::Num', 'emit_javascript2_has_regex', (function () {
					var tmp3643;
					tmp3643 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3643._prototype_ = null;
					return tmp3643
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Buf');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Buf', 'emit_javascript2', (function () {
					var tmp3644;
					tmp3644 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3645 = p5list_to_a([List__]);
							v_self = tmp3645.shift();
							v_level = tmp3645.shift();
							v_wantarray = tmp3645.shift();
						return (p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('buf')]), p5want));
					};
					tmp3644._prototype_ = null;
					return tmp3644
				})());
				p5typeglob_set('Perlito5::AST::Buf', 'emit_javascript2_get_decl', (function () {
					var tmp3646;
					tmp3646 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3646._prototype_ = null;
					return tmp3646
				})());
				p5typeglob_set('Perlito5::AST::Buf', 'emit_javascript2_has_regex', (function () {
					var tmp3647;
					tmp3647 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3647._prototype_ = null;
					return tmp3647
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Block');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Block', 'emit_javascript2', (function () {
					var tmp3648;
					tmp3648 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3649 = p5list_to_a([List__]);
							v_self = tmp3649.shift();
							v_level = tmp3649.shift();
							v_wantarray = tmp3649.shift();
						var v_body;
						(function () {
								if ( (p5str(v_wantarray) != 'void') ) {
								v_body = (p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('stmts')]), 0));
							}
							else {
								v_body = (p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('stmts')]), 0));
							}
							})();
						var v_init;
						v_init = ('');
						(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')) == 'INIT') ) {
								(function () {
									var v_tmp;
									v_tmp = (('p5pkg.main.' + p5str(p5pkg['Perlito5::Javascript2'].get_label([], 0))));
									v_init = ((p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + ('if (' + p5str(v_tmp) + ') { return }; ' + p5str(v_tmp) + ' = 1;' + String.fromCharCode(10))));
								})();
							}
							})();
						return (p5context([(p5str(( (p5str(v_wantarray) != 'void') ? 'return ' : '')) + 'p5block(' + 'function (v) {}, ' + 'function () {' + String.fromCharCode(10) + p5str(v_init) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + p5str(p5call(v_body, 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}, ' + '[0], ' + p5str(p5call(v_self, 'emit_javascript2_continue', [v_level, v_wantarray], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
	return ''
})]), 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + ')')], p5want));
					};
					tmp3648._prototype_ = null;
					return tmp3648
				})());
				p5typeglob_set('Perlito5::AST::Block', 'emit_javascript2_continue', (function () {
					var tmp3650;
					tmp3650 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							var v_wantarray;
							v_wantarray = (List__.shift());
							(function () {
								if ( (!( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('continue'))) || !( p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('continue')._hash_.p5hget_array('stmts'), 'Perlito5::AST::Block'))))) ) {
								throw(p5context(['false'], p5want));
							}
							})();
							return (p5context([('function () {' + String.fromCharCode(10) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('continue'), 'stmts', [], 1)]), 0)], 0), 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3650._prototype_ = null;
					return tmp3650
				})());
				p5typeglob_set('Perlito5::AST::Block', 'emit_javascript2_get_decl', (function () {
					var tmp3651;
					tmp3651 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3651._prototype_ = null;
					return tmp3651
				})());
				p5typeglob_set('Perlito5::AST::Block', 'emit_javascript2_has_regex', (function () {
					var tmp3652;
					tmp3652 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3652._prototype_ = null;
					return tmp3652
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Index');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Index', 'emit_javascript2', (function () {
					var tmp3653;
					tmp3653 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var v_autovivification_type;
							var tmp3654 = p5list_to_a([List__]);
							v_self = tmp3654.shift();
							v_level = tmp3654.shift();
							v_wantarray = tmp3654.shift();
							v_autovivification_type = tmp3654.shift();
							var v_method;
							v_method = (p5or(v_autovivification_type, function () {
										return 'p5aget'
									}));
							p5and((p5str(v_autovivification_type) == 'array'), function () {
								return v_method = ('p5aget_array')
							});
							p5and((p5str(v_autovivification_type) == 'hash'), function () {
								return v_method = ('p5aget_hash')
							});
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'code', [], 0)) == 'circumfix:<( )>')))) ) {
								throw(p5context([('p5list_slice(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_javascript2', [v_level, 'list'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
							}
							})();
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<%>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '%'))) ) {
								(function () {
									var v_obj;
									v_obj = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'));
									p5and((p5str((v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget('sigil')) == '%'), function () {
										return (v_obj || (v_obj = new p5HashRef({})))._hash_.p5hset('sigil', ('@'))
									});
									p5and((p5str((v_obj || (v_obj = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<%>'), function () {
										return (v_obj || (v_obj = new p5HashRef({})))._hash_.p5hset('code', ('prefix:<@>'))
									});
									throw(p5context([('p5hash_slice(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_javascript2', [v_level, 'list'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								})();
							}
							})();
							return (p5context([(p5str(p5call(v_self, 'emit_javascript2_container', [v_level], 0)) + '.' + p5str(v_method) + '(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), v_level]), 0)) + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3653._prototype_ = null;
					return tmp3653
				})());
				p5typeglob_set('Perlito5::AST::Index', 'emit_javascript2_set', (function () {
					var tmp3655;
					tmp3655 = function (List__, p5want) {
						try {
							var v_self;
							var v_arguments;
							var v_level;
							var v_wantarray;
							var tmp3656 = p5list_to_a([List__]);
							v_self = tmp3656.shift();
							v_arguments = tmp3656.shift();
							v_level = tmp3656.shift();
							v_wantarray = tmp3656.shift();
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@'))) ) {
								throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, 'var a = [];', ('var v = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ';'), ('var src=' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef([v_arguments])), v_level]), 0)) + ';'), ('var out=' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), v_level, 'array']), 0)) + ';'), ('var tmp' + ';'), 'for (var i=0, l=v.length; i<l; ++i) {', (new p5ArrayRef(['tmp = src.p5aget(i);', 'out.p5aset(v[i], tmp);', 'a.push(tmp)'])), '}', 'return a']), p5want));
							}
							})();
							return (p5context([(p5str(p5call(v_self, 'emit_javascript2_container', [v_level], 0)) + '.p5aset(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3655._prototype_ = null;
					return tmp3655
				})());
				p5typeglob_set('Perlito5::AST::Index', 'emit_javascript2_set_list', (function () {
					var tmp3657;
					tmp3657 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_list;
							var tmp3658 = p5list_to_a([List__]);
							v_self = tmp3658.shift();
							v_level = tmp3658.shift();
							v_list = tmp3658.shift();
							var v_wantarray;
							v_wantarray = ('list');
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@'))) ) {
								throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, 'var a = [];', ('var v = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ';'), ('var out=' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), v_level, 'array']), 0)) + ';'), ('var tmp' + ';'), 'for (var i=0, l=v.length; i<l; ++i) {', (new p5ArrayRef([('tmp = ' + p5str(v_list) + '.shift();'), 'out.p5aset(v[i], tmp);', 'a.push(tmp)'])), '}', 'return a']), p5want));
							}
							})();
							return (p5context([(p5str(p5call(v_self, 'emit_javascript2_container', [v_level], 0)) + '.p5aset(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(v_list) + '.shift()' + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3657._prototype_ = null;
					return tmp3657
				})());
				p5typeglob_set('Perlito5::AST::Index', 'emit_javascript2_container', (function () {
					var tmp3659;
					tmp3659 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							(function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<$>')) ) {
								(function () {
									var v_v;
									v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a([p5hash_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj'), 'Perlito5::AST::Index'), 'code', 'prefix:<@>']), 0));
									throw(p5call(v_v, 'emit_javascript2', [v_level], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'code', [], 0)) == 'circumfix:<( )>')) ) {
								throw(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj')]))), v_level]), p5want));
							}
							})();
							return (function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '$')) ) {
								(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hset('sigil', ('@'));
								(function () {
									throw(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'emit_javascript2', [v_level], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), v_level, 'array']), 0)) + '._array_')], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3659._prototype_ = null;
					return tmp3659
				})());
				p5typeglob_set('Perlito5::AST::Index', 'emit_javascript2_get_decl', (function () {
					var tmp3660;
					tmp3660 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3660._prototype_ = null;
					return tmp3660
				})());
				p5typeglob_set('Perlito5::AST::Index', 'emit_javascript2_has_regex', (function () {
					var tmp3661;
					tmp3661 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3661._prototype_ = null;
					return tmp3661
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Lookup');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_javascript2', (function () {
					var tmp3662;
					tmp3662 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var v_autovivification_type;
							var tmp3663 = p5list_to_a([List__]);
							v_self = tmp3663.shift();
							v_level = tmp3663.shift();
							v_wantarray = tmp3663.shift();
							v_autovivification_type = tmp3663.shift();
							var v_method;
							v_method = (p5or(v_autovivification_type, function () {
										return 'p5hget'
									}));
							p5and((p5str(v_autovivification_type) == 'array'), function () {
								return v_method = ('p5hget_array')
							});
							p5and((p5str(v_autovivification_type) == 'hash'), function () {
								return v_method = ('p5hget_hash')
							});
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@'))) ) {
								(function () {
									var v_v;
									(function () {
										if ( p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) ) {
										v_v = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'));
									}
									})();
									p5and(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0), function () {
										return v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'prefix:<%>', 'namespace', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'namespace', [], 1), 'arguments', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'arguments', [], 1)]), 0))
									});
									throw(p5context([('p5list_lookup_slice(' + p5str(p5call(v_v, 'emit_javascript2', [v_level, 'list'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								})();
							}
							})();
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<%>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '%'))) ) {
								(function () {
									var v_v;
									(function () {
										if ( p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) ) {
										v_v = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'));
									}
									})();
									p5and(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0), function () {
										return v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'prefix:<%>', 'namespace', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'namespace', [], 1), 'arguments', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'arguments', [], 1)]), 0))
									});
									throw(p5context([('p5hash_lookup_slice(' + p5str(p5call(v_v, 'emit_javascript2', [v_level, 'list'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								})();
							}
							})();
							return (p5context([(p5str(p5call(v_self, 'emit_javascript2_container', [v_level], 0)) + '.' + p5str(v_method) + '(' + p5str(p5pkg['Perlito5::Javascript2'].autoquote(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), v_level]), 0)) + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3662._prototype_ = null;
					return tmp3662
				})());
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_javascript2_set', (function () {
					var tmp3664;
					tmp3664 = function (List__, p5want) {
						try {
							var v_self;
							var v_arguments;
							var v_level;
							var v_wantarray;
							var tmp3665 = p5list_to_a([List__]);
							v_self = tmp3665.shift();
							v_arguments = tmp3665.shift();
							v_level = tmp3665.shift();
							v_wantarray = tmp3665.shift();
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@'))) ) {
								(function () {
									var v_v;
									p5and(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0), function () {
										return v_v = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'))
									});
									p5and(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0), function () {
										return v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'prefix:<%>', 'namespace', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'namespace', [], 1), 'arguments', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'arguments', [], 1)]), 0))
									});
									throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, 'var a = [];', ('var v = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ';'), ('var src=' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef([v_arguments])), v_level]), 0)) + ';'), ('var out=' + p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + ';'), ('var tmp' + ';'), ('for (var i=0, l=v.length; i<l; ++i)' + '{'), (new p5ArrayRef(['tmp = src.p5hget(i);', 'out.p5hset(v[i], tmp);', 'a.push(tmp)'])), '}', 'return a']), p5want));
								})();
							}
							})();
							return (p5context([(p5str(p5call(v_self, 'emit_javascript2_container', [v_level], 0)) + '.p5hset(' + p5str(p5pkg['Perlito5::Javascript2'].autoquote(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), v_level]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3664._prototype_ = null;
					return tmp3664
				})());
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_javascript2_set_list', (function () {
					var tmp3666;
					tmp3666 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_list;
							var tmp3667 = p5list_to_a([List__]);
							v_self = tmp3667.shift();
							v_level = tmp3667.shift();
							v_list = tmp3667.shift();
							var v_wantarray;
							v_wantarray = ('list');
							(function () {
								if ( ((p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<@>')) || (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '@'))) ) {
								(function () {
									var v_v;
									p5and(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0), function () {
										return v_v = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'))
									});
									p5and(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0), function () {
										return v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'prefix:<%>', 'namespace', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'namespace', [], 1), 'arguments', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'arguments', [], 1)]), 0))
									});
									throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, 'var a = [];', ('var v = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp')]))), v_level]), 0)) + ';'), ('var out=' + p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + ';'), ('var tmp' + ';'), ('for (var i=0, l=v.length; i<l; ++i)' + '{'), (new p5ArrayRef([('tmp = ' + p5str(v_list) + '.shift();'), 'out.p5hset(v[i], tmp);', 'a.push(tmp)'])), '}', 'return a']), p5want));
								})();
							}
							})();
							return (p5context([(p5str(p5call(v_self, 'emit_javascript2_container', [v_level], 0)) + '.p5hset(' + p5str(p5pkg['Perlito5::Javascript2'].autoquote(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('index_exp'), v_level]), 0)) + ', ' + p5str(v_list) + '.shift()' + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3666._prototype_ = null;
					return tmp3666
				})());
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_javascript2_container', (function () {
					var tmp3668;
					tmp3668 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							(function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj')._hash_.p5hget('code')) == 'prefix:<$>')) ) {
								(function () {
									var v_v;
									v_v = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a([p5hash_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj'), 'Perlito5::AST::Lookup'), 'code', 'prefix:<%>']), 0));
									throw(p5call(v_v, 'emit_javascript2', [v_level], p5want));
								})();
							}
							})();
							return (function () {
								if ( (p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), 'sigil', [], 0)) == '$')) ) {
								var v_v;
								v_v = (p5call('Perlito5::AST::Var', 'new', p5list_to_a([p5hash_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('obj'), 'Perlito5::AST::Lookup'), 'sigil', '%']), 0));
								(function () {
									throw(p5call(v_v, 'emit_javascript2', [v_level], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('obj'), v_level, 'hash']), 0)) + '._hash_')], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3668._prototype_ = null;
					return tmp3668
				})());
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_javascript2_get_decl', (function () {
					var tmp3669;
					tmp3669 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3669._prototype_ = null;
					return tmp3669
				})());
				p5typeglob_set('Perlito5::AST::Lookup', 'emit_javascript2_has_regex', (function () {
					var tmp3670;
					tmp3670 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3670._prototype_ = null;
					return tmp3670
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Var');
		p5block(function (v) {}, function () {
				var v_table;
				v_table = ((new p5HashRef({'$' : 'v_', '@' : 'List_', '%' : 'Hash_', '&' : ''})));
				p5typeglob_set('Perlito5::AST::Var', 'emit_javascript2_global', (function () {
					var tmp3671;
					tmp3671 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp3672 = p5list_to_a([List__]);
							v_self = tmp3672.shift();
							v_level = tmp3672.shift();
							v_wantarray = tmp3672.shift();
							var v_str_name;
							v_str_name = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name'));
							var v_sigil;
							v_sigil = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
										return (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')
									}));
							var v_namespace;
							v_namespace = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
										return (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_namespace')
									}));
							(function () {
								if ( ((p5str(v_sigil) == '@') && ((p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')) == '_') && (p5str(v_namespace) == 'main'))) ) {
								(function () {
									var v_s;
									v_s = ('List__');
									(function () {
										if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')) == '$#') ) {
										throw(p5context([('(' + p5str(v_s) + '.length - 1)')], p5want));
									}
									})();
									(function () {
										if ( (p5str(v_wantarray) == 'scalar') ) {
										throw(p5context([(p5str(v_s) + '.length')], p5want));
									}
									})();
									(function () {
										if ( (p5str(v_wantarray) == 'runtime') ) {
										throw(p5context([('(p5want' + ' ? ' + p5str(v_s) + ' : ' + p5str(v_s) + '.length' + ')')], p5want));
									}
									})();
									throw(p5context([v_s], p5want));
								})();
							}
							})();
							(function () {
								if ( ((p5str(v_sigil) == '$') && (p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')) > 0)) ) {
								throw(p5context([('p5_regex_capture[' + p5str((p5num((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')) - 1)) + ']')], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '::') ) {
								p5and((p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) == '__PACKAGE__'), function () {
									throw(p5pkg['Perlito5::Javascript2'].pkg([], p5want))
								});
								p5and((p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) == '__SUB__'), function () {
									throw(p5defined_or(p5make_package('Perlito5::AST::Sub')['v_SUB_REF'], function () {
										return '__SUB__'
									}))
								});
								throw(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], p5want));
							}
							})();
							var v_s;
							v_s = (('p5make_package(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + ')[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([(p5str((v_table || (v_table = new p5HashRef({})))._hash_.p5hget(p5str(v_sigil))) + p5str(v_str_name))], 0)) + ']'));
							(function () {
								if ( (p5str(v_sigil) == '*') ) {
								throw(p5context([v_s], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '&') ) {
								throw(p5context([(p5str(v_s) + '(List__, ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '@') ) {
								v_s = ((p5str(v_s) + ' || (' + p5str(v_s) + ' = [])'));
								v_s = (('p5pkg[' + p5str(v_s) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + '][' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([(p5str((v_table || (v_table = new p5HashRef({})))._hash_.p5hget(p5str(v_sigil))) + p5str(v_str_name))], 0)) + ']'));
								(function () {
									if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')) == '$#') ) {
									throw(p5context([('(' + p5str(v_s) + '.length - 1)')], p5want));
								}
								})();
								(function () {
									if ( (p5str(v_wantarray) == 'scalar') ) {
									throw(p5context([(p5str(v_s) + '.length')], p5want));
								}
								})();
							}
							else (function () {
								if ( (p5str(v_sigil) == '%') ) {
								v_s = ((p5str(v_s) + ' || (' + p5str(v_s) + ' = {})'));
								v_s = (('p5pkg[' + p5str(v_s) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + '][' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([(p5str((v_table || (v_table = new p5HashRef({})))._hash_.p5hget(p5str(v_sigil))) + p5str(v_str_name))], 0)) + ']'));
							}
							})()
							})();
							return (p5context([v_s], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3671._prototype_ = null;
					return tmp3671
				})());
				p5typeglob_set('Perlito5::AST::Var', 'emit_javascript2', (function () {
					var tmp3673;
					tmp3673 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp3674 = p5list_to_a([List__]);
							v_self = tmp3674.shift();
							v_level = tmp3674.shift();
							v_wantarray = tmp3674.shift();
							var v_sigil;
							v_sigil = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
										return (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')
									}));
							var v_str_name;
							v_str_name = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name'));
							var v_decl_type;
							v_decl_type = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_decl'), function () {
										return 'global'
									}));
							(function () {
								if ( (p5str(v_decl_type) != 'my') ) {
								throw(p5call(v_self, 'emit_javascript2_global', [v_level, v_wantarray], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '@') ) {
								(function () {
									if ( (p5str(v_wantarray) == 'scalar') ) {
									throw(p5context([(p5str(p5call(v_self, 'emit_javascript2', [v_level, 'list'], 0)) + '.length')], p5want));
								}
								})();
								(function () {
									if ( (p5str(v_wantarray) == 'runtime') ) {
									throw(p5context([('(p5want' + ' ? ' + p5str(p5call(v_self, 'emit_javascript2', [v_level, 'list'], 0)) + ' : ' + p5str(p5call(v_self, 'emit_javascript2', [v_level, 'list'], 0)) + '.length' + ')')], p5want));
								}
								})();
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')) == '$#') ) {
								throw(p5context([('(' + p5str((v_table || (v_table = new p5HashRef({})))._hash_.p5hget('@')) + p5str(v_str_name) + '.length - 1)')], p5want));
							}
							})();
							return (p5context([(p5str((v_table || (v_table = new p5HashRef({})))._hash_.p5hget(p5str(v_sigil))) + p5str(v_str_name))], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3673._prototype_ = null;
					return tmp3673
				})());
				p5typeglob_set('Perlito5::AST::Var', 'emit_javascript2_set', (function () {
					var tmp3675;
					tmp3675 = function (List__, p5want) {
						try {
							var v_self;
							var v_arguments;
							var v_level;
							var v_wantarray;
							var tmp3676 = p5list_to_a([List__]);
							v_self = tmp3676.shift();
							v_arguments = tmp3676.shift();
							v_level = tmp3676.shift();
							v_wantarray = tmp3676.shift();
							var v_open;
							v_open = (( (p5str(v_wantarray) == 'void') ? '' : '('));
							var v_close;
							v_close = (( (p5str(v_wantarray) == 'void') ? '' : ')'));
							var v_sigil;
							v_sigil = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
										return (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')
									}));
							(function () {
								if ( (p5str(v_sigil) == '$') ) {
								throw(p5context([(p5str(v_open) + p5str(p5call(v_self, 'emit_javascript2', [], 0)) + ' = ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + p5str(v_close))], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '@') ) {
								(function () {
									if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')) == '$#') ) {
									(v_self || (v_self = new p5HashRef({})))._hash_.p5hset('sigil', ('@'));
									throw(p5context([(p5str(v_open) + p5str(p5call(v_self, 'emit_javascript2', [], 0)) + '.length = 1 + ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + p5str(v_close))], p5want));
								}
								})();
								throw(p5context([(p5str(v_open) + p5str(p5call(v_self, 'emit_javascript2', [], 0)) + ' = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + p5str(v_close))], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '%') ) {
								throw(p5context([(p5str(v_open) + p5str(p5call(v_self, 'emit_javascript2', [], 0)) + ' = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1), 'hash']), 0)) + p5str(v_close))], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '*') ) {
								(function () {
									var v_namespace;
									v_namespace = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
												return (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_namespace')
											}));
									throw(p5context([('p5typeglob_set(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
								})();
							}
							})();
							return (p5pkg['Perlito5::AST::Var'].die([].concat(p5list_to_a(['don' + String.fromCharCode(39) + 't know how to assign to variable ', v_sigil, p5call(v_self, 'name', [], 1)])), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3675._prototype_ = null;
					return tmp3675
				})());
				p5typeglob_set('Perlito5::AST::Var', 'emit_javascript2_set_list', (function () {
					var tmp3677;
					tmp3677 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_list;
							var tmp3678 = p5list_to_a([List__]);
							v_self = tmp3678.shift();
							v_level = tmp3678.shift();
							v_list = tmp3678.shift();
							var v_sigil;
							v_sigil = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_real_sigil'), function () {
										return (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sigil')
									}));
							(function () {
								if ( (p5str(v_sigil) == '$') ) {
								throw(p5context([(p5str(p5call(v_self, 'emit_javascript2', [], 0)) + ' = ' + p5str(v_list) + '.shift()')], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '@') ) {
								throw(p5context([p5pkg['Perlito5::AST::Var'].join([(';' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat([(p5str(p5call(v_self, 'emit_javascript2', [], 0)) + ' = ' + p5str(v_list)), (p5str(v_list) + ' = []')]), p5want)], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_sigil) == '%') ) {
								throw(p5context([p5pkg['Perlito5::AST::Var'].join([(';' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat([(p5str(p5call(v_self, 'emit_javascript2', [], 0)) + ' = p5a_to_h(' + p5str(v_list) + ')'), (p5str(v_list) + ' = []')]), p5want)], p5want));
							}
							})();
							return (p5pkg['Perlito5::AST::Var'].die([].concat(p5list_to_a(['don' + String.fromCharCode(39) + 't know how to assign to variable ', v_sigil, p5call(v_self, 'name', [], 1)])), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3677._prototype_ = null;
					return tmp3677
				})());
				p5typeglob_set('Perlito5::AST::Var', 'emit_javascript2_get_decl', (function () {
					var tmp3679;
					tmp3679 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3679._prototype_ = null;
					return tmp3679
				})());
				p5typeglob_set('Perlito5::AST::Var', 'emit_javascript2_has_regex', (function () {
					var tmp3680;
					tmp3680 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3680._prototype_ = null;
					return tmp3680
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Decl');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Decl', 'emit_javascript2', (function () {
					var tmp3681;
					tmp3681 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_wantarray;
						var tmp3682 = p5list_to_a([List__]);
							v_self = tmp3682.shift();
							v_level = tmp3682.shift();
							v_wantarray = tmp3682.shift();
						return (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'emit_javascript2', [v_level], p5want));
					};
					tmp3681._prototype_ = null;
					return tmp3681
				})());
				p5typeglob_set('Perlito5::AST::Decl', 'emit_javascript2_init', (function () {
					var tmp3683;
					tmp3683 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp3684 = p5list_to_a([List__]);
							v_self = tmp3684.shift();
							v_level = tmp3684.shift();
							v_wantarray = tmp3684.shift();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('decl')) == 'local') ) {
								(function () {
									var v_var;
									v_var = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'));
									var v_var_set;
									var v_tmp_name;
									v_tmp_name = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
									(function () {
										if ( (p5pkg['Perlito5::AST::Decl'].ref([v_var], 0) == 'Perlito5::AST::Var') ) {
										v_var_set = ((p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ' = v_' + p5str(v_tmp_name)));
									}
									else {
										(function () {
											var v_tmp;
											v_tmp = (p5call('Perlito5::AST::Var', 'new', ['sigil', '$', 'name', v_tmp_name, '_decl', 'my'], 0));
											v_var_set = (p5call(v_var, 'emit_javascript2_set', [v_tmp], 0));
										})();
									}
									})();
									throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, v_wantarray, ('var v_' + p5str(v_tmp_name) + ' = ' + p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ';'), ('p5LOCAL.push(function(){ ' + p5str(v_var_set) + ' });'), ('return ' + p5str(p5call(v_var, 'emit_javascript2_set', p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'undef', 'arguments', (new p5ArrayRef([])), 'namespace', '']), 1), (p5num(v_level) + 1)]), 0)) + ';')], 0)) + ';')], p5want));
								})();
							}
							})();
							return (function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('decl')) == 'my') ) {
								var v_str;
								v_str = (('var ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'emit_javascript2', [], 0))));
								(function () {
									if ( (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'sigil', [], 0)) == '%') ) {
									v_str = ((p5str(v_str) + ' = {};'));
								}
								else (function () {
									if ( (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'sigil', [], 0)) == '@') ) {
									v_str = ((p5str(v_str) + ' = [];'));
								}
								else {
									v_str = ((p5str(v_str) + ';'));
								}
								})()
								})();
								(function () {
									throw(p5context([v_str], p5want))
								})()
							}
							else return (function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('decl')) == 'our') ) {
								var v_str;
								v_str = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'emit_javascript2', [], 0));
								(function () {
									if ( (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'sigil', [], 0)) == '%') ) {
									v_str = ((p5str(v_str) + ' = {};'));
								}
								else (function () {
									if ( (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'sigil', [], 0)) == '@') ) {
									v_str = ((p5str(v_str) + ' = [];'));
								}
								else {
									throw(p5context([('// our ' + p5str(v_str))], p5want));
								}
								})()
								})();
								(function () {
									throw(p5context([('if (typeof ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'emit_javascript2', [], 0)) + ' == "undefined" ) { ' + p5str(v_str) + '}')], p5want))
								})()
							}
							else return (function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('decl')) == 'state') ) {
								(function () {
									throw(p5context([('// state ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('var'), 'emit_javascript2', [], 0)))], p5want))
								})()
							}
							else {
								return (p5pkg['Perlito5::AST::Decl'].die([].concat([('not implemented: Perlito5::AST::Decl ' + String.fromCharCode(39) + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('decl')) + String.fromCharCode(39))]), p5want));
							}
							})()
							})()
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3683._prototype_ = null;
					return tmp3683
				})());
				p5typeglob_set('Perlito5::AST::Decl', 'emit_javascript2_set', (function () {
					var tmp3685;
					tmp3685 = function (List__, p5want) {
						var v_self;
						var v_arguments;
						var v_level;
						var v_wantarray;
						var tmp3686 = p5list_to_a([List__]);
							v_self = tmp3686.shift();
							v_arguments = tmp3686.shift();
							v_level = tmp3686.shift();
							v_wantarray = tmp3686.shift();
						return (p5call(p5call(v_self, 'var', [], 0), 'emit_javascript2_set', [v_arguments, v_level, v_wantarray], p5want));
					};
					tmp3685._prototype_ = null;
					return tmp3685
				})());
				p5typeglob_set('Perlito5::AST::Decl', 'emit_javascript2_set_list', (function () {
					var tmp3687;
					tmp3687 = function (List__, p5want) {
						var v_self;
						var v_level;
						var v_list;
						var tmp3688 = p5list_to_a([List__]);
							v_self = tmp3688.shift();
							v_level = tmp3688.shift();
							v_list = tmp3688.shift();
						return (p5call(p5call(v_self, 'var', [], 0), 'emit_javascript2_set_list', [v_level, v_list], p5want));
					};
					tmp3687._prototype_ = null;
					return tmp3687
				})());
				p5typeglob_set('Perlito5::AST::Decl', 'emit_javascript2_get_decl', (function () {
					var tmp3689;
					tmp3689 = function (List__, p5want) {
						var v_self;
						v_self = (List__.shift());
						return (p5context([v_self], p5want));
					};
					tmp3689._prototype_ = null;
					return tmp3689
				})());
				p5typeglob_set('Perlito5::AST::Decl', 'emit_javascript2_has_regex', (function () {
					var tmp3690;
					tmp3690 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3690._prototype_ = null;
					return tmp3690
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Call');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Call', 'emit_javascript2', (function () {
					var tmp3691;
					tmp3691 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var v_autovivification_type;
							var tmp3692 = p5list_to_a([List__]);
							v_self = tmp3692.shift();
							v_level = tmp3692.shift();
							v_wantarray = tmp3692.shift();
							v_autovivification_type = tmp3692.shift();
							var v_meth;
							v_meth = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method'));
							(function () {
								if ( (p5str(v_meth) == 'postcircumfix:<[ ]>') ) {
								(function () {
									var v_method;
									v_method = (p5or(v_autovivification_type, function () {
												return 'p5aget'
											}));
									p5and((p5str(v_autovivification_type) == 'array'), function () {
										return v_method = ('p5aget_array')
									});
									p5and((p5str(v_autovivification_type) == 'hash'), function () {
										return v_method = ('p5aget_hash')
									});
									throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), v_level, 'array']), 0)) + '._array_.' + p5str(v_method) + '(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5str(v_meth) == 'postcircumfix:<{ }>') ) {
								(function () {
									var v_method;
									v_method = (p5or(v_autovivification_type, function () {
												return 'p5hget'
											}));
									p5and((p5str(v_autovivification_type) == 'array'), function () {
										return v_method = ('p5hget_array')
									});
									p5and((p5str(v_autovivification_type) == 'hash'), function () {
										return v_method = ('p5hget_hash')
									});
									throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), v_level, 'hash']), 0)) + '._hash_.' + p5str(v_method) + '(' + p5str(p5pkg['Perlito5::Javascript2'].autoquote(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1), 'list']), 0)) + ')')], p5want));
								})();
							}
							})();
							(function () {
								if ( (p5str(v_meth) == 'postcircumfix:<( )>') ) {
								(function () {
									var v_invocant;
									(function () {
										if ( ((p5pkg['Perlito5::AST::Call'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant')], 0) == 'Perlito5::AST::Apply') && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget('code')) == 'prefix:<&>')) ) {
										(function () {
											var v_arg;
											v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget_array('arguments')._array_.p5aget(0));
											v_invocant = (('p5code_lookup_by_name(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ')'));
										})();
									}
									else (function () {
										if ( ((p5pkg['Perlito5::AST::Call'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant')], 0) == 'Perlito5::AST::Var') && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget('sigil')) == '&')) ) {
										v_invocant = (('p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget('namespace'), function () {
	return p5make_package('Perlito5')['v_PKG_NAME']
})]), 0)) + '][' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('invocant')._hash_.p5hget('name')]), 0)) + ']'));
									}
									else {
										v_invocant = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), 'emit_javascript2', [v_level, 'scalar'], 0));
									}
									})()
									})();
									throw(p5context([('(' + p5str(v_invocant) + ')(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								})();
							}
							})();
							var v_invocant;
							v_invocant = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), 'emit_javascript2', [v_level, 'scalar'], 0));
							(function () {
								if ( (p5pkg['Perlito5::AST::Call'].ref([v_meth], 0) == 'Perlito5::AST::Var') ) {
								v_meth = (p5call(v_meth, 'emit_javascript2', [v_level, 'scalar'], 0));
							}
							else {
								v_meth = (p5pkg['Perlito5::Javascript2'].escape_string([v_meth], 0));
							}
							})();
							return (p5context([('p5call(' + p5str(v_invocant) + ', ' + p5str(v_meth) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3691._prototype_ = null;
					return tmp3691
				})());
				p5typeglob_set('Perlito5::AST::Call', 'emit_javascript2_set', (function () {
					var tmp3693;
					tmp3693 = function (List__, p5want) {
						try {
							var v_self;
							var v_arguments;
							var v_level;
							var v_wantarray;
							var tmp3694 = p5list_to_a([List__]);
							v_self = tmp3694.shift();
							v_arguments = tmp3694.shift();
							v_level = tmp3694.shift();
							v_wantarray = tmp3694.shift();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')) == 'postcircumfix:<[ ]>') ) {
								throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), v_level, 'array']), 0)) + '._array_.p5aset(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')) == 'postcircumfix:<{ }>') ) {
								throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), v_level, 'hash']), 0)) + '._hash_.p5hset(' + p5str(p5pkg['Perlito5::Javascript2'].autoquote(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1), 'list']), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
							}
							})();
							return (p5pkg['Perlito5::AST::Call'].die([].concat(p5list_to_a(['don' + String.fromCharCode(39) + 't know how to assign to method ', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')])), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3693._prototype_ = null;
					return tmp3693
				})());
				p5typeglob_set('Perlito5::AST::Call', 'emit_javascript2_set_list', (function () {
					var tmp3695;
					tmp3695 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_list;
							var tmp3696 = p5list_to_a([List__]);
							v_self = tmp3696.shift();
							v_level = tmp3696.shift();
							v_list = tmp3696.shift();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')) == 'postcircumfix:<[ ]>') ) {
								throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), v_level, 'array']), 0)) + '._array_.p5aset(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(v_list) + '.shift()' + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')) == 'postcircumfix:<{ }>') ) {
								throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('invocant'), v_level, 'hash']), 0)) + '._hash_.p5hset(' + p5str(p5pkg['Perlito5::Javascript2'].autoquote(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1), 'list']), 0)) + ', ' + p5str(v_list) + '.shift()' + ')')], p5want));
							}
							})();
							return (p5pkg['Perlito5::AST::Call'].die([].concat(p5list_to_a(['don' + String.fromCharCode(39) + 't know how to assign to method ', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('method')])), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3695._prototype_ = null;
					return tmp3695
				})());
				p5typeglob_set('Perlito5::AST::Call', 'emit_javascript2_get_decl', (function () {
					var tmp3697;
					tmp3697 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3697._prototype_ = null;
					return tmp3697
				})());
				p5typeglob_set('Perlito5::AST::Call', 'emit_javascript2_has_regex', (function () {
					var tmp3698;
					tmp3698 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp3698._prototype_ = null;
					return tmp3698
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Apply');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Apply', 'emit_regex_javascript2', (function () {
					var tmp3699;
					tmp3699 = function (List__, p5want) {
						try {
							var v_op;
							v_op = (List__.shift());
							var v_var;
							v_var = (List__.shift());
							var v_regex;
							v_regex = (List__.shift());
							var v_level;
							v_level = (List__.shift());
							var v_wantarray;
							v_wantarray = (List__.shift());
							(function () {
								if ( p5bool(p5call(v_regex, 'isa', ['Perlito5::AST::Var'], 0)) ) {
								v_regex = ((new p5HashRef(p5a_to_h(p5list_to_a(['code', 'p5:m', 'arguments', (new p5ArrayRef([v_regex, '']))])))));
							}
							})();
							var v_str;
							var v_code;
							v_code = ((v_regex || (v_regex = new p5HashRef({})))._hash_.p5hget('code'));
							var v_regex_args;
							v_regex_args = ((v_regex || (v_regex = new p5HashRef({})))._hash_.p5hget('arguments'));
							(function () {
								if ( (p5str(v_code) == 'p5:s') ) {
								(function () {
									var v_replace;
									v_replace = ((v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget(1));
									var v_modifier;
									v_modifier = ((v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget_hash(2)._hash_.p5hget('buf'));
									var v_fun;
									(function () {
										if ( (p5pkg['Perlito5::AST::Apply'].ref([v_replace], 0) == 'Perlito5::AST::Block') ) {
										var local_idx = p5LOCAL.length;
										var regex_tmp = p5_regex_capture;
										p5LOCAL.push(function(){ p5_regex_capture = regex_tmp });
										v_replace = (p5call('Perlito5::AST::Sub', 'new', ['block', v_replace], 0));
										v_fun = (p5call(v_replace, 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0));
										(function () {
												var tmp = p5s(v_modifier, 'e', function () {
													return ''
												}, 'g', 0);
												v_modifier = tmp[0];
												return tmp[1];
											})();
										p5cleanup_local(local_idx, null);
									}
									else {
										v_fun = (p5pkg['Perlito5::Javascript2'].emit_function_javascript2([(p5num(v_level) + 2), v_wantarray, v_replace], 0));
									}
									})();
									v_str = (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([(p5num(v_level) + 1), v_wantarray, ('var tmp = p5s(' + p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ', ' + p5str(p5call((v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget(0), 'emit_javascript2', [], 0)) + ', ' + p5str(v_fun) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_modifier], 0)) + ', ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ');'), (p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ' = tmp[0];'), 'return tmp[1];'], 0));
								})();
							}
							else (function () {
								if ( (p5str(v_code) == 'p5:m') ) {
								v_str = (('p5m(' + p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ', ' + p5str(p5call((v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget(0), 'emit_javascript2', [], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget_hash(1)._hash_.p5hget('buf')]), 0)) + ', ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ')'));
							}
							else (function () {
								if ( (p5str(v_code) == 'p5:tr') ) {
								v_str = (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([(p5num(v_level) + 1), v_wantarray, ('var tmp = p5tr(' + p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ', ' + p5str(p5call((v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget(0), 'emit_javascript2', [], 0)) + ', ' + p5str(p5call((v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget(1), 'emit_javascript2', [], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_regex_args || (v_regex_args = new p5ArrayRef([])))._array_.p5aget_hash(2)._hash_.p5hget('buf')]), 0)) + ', ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ');'), (p5str(p5call(v_var, 'emit_javascript2', [], 0)) + ' = tmp[0];'), 'return tmp[1];'], 0));
							}
							else {
								p5pkg['Perlito5::AST::Apply'].die([].concat([('Error: regex emitter - unknown operator ' + p5str(v_code))]), null);
							}
							})()
							})()
							})();
							(function () {
								if ( (p5str(v_op) == '=~') ) {
								throw(p5context([v_str], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_op) == '!~') ) {
								throw(p5context([('!(' + p5str(v_str) + ')')], p5want));
							}
							})();
							return (p5pkg['Perlito5::AST::Apply'].die([].concat(['Error: regex emitter']), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3699._prototype_ = null;
					return tmp3699
				})());
				p5typeglob_set('Perlito5::AST::Apply', 'emit_javascript2_set', (function () {
					var tmp3700;
					tmp3700 = function (List__, p5want) {
						try {
							var v_self;
							var v_arguments;
							var v_level;
							var v_wantarray;
							var tmp3701 = p5list_to_a([List__]);
							v_self = tmp3701.shift();
							v_arguments = tmp3701.shift();
							v_level = tmp3701.shift();
							v_wantarray = tmp3701.shift();
							var v_code;
							v_code = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
							(function () {
								if ( (p5str(v_code) == 'prefix:<$>') ) {
								throw(p5context([('p5scalar_deref_set(' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), (p5num(v_level) + 1), 'scalar']), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5str(v_code) == 'prefix:<*>') ) {
								throw(p5context([('p5typeglob_deref_set(' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')')], p5want));
							}
							})();
							var v_open;
							v_open = (( (p5str(v_wantarray) == 'void') ? '' : '('));
							var v_close;
							v_close = (( (p5str(v_wantarray) == 'void') ? '' : ')'));
							return (p5context([(p5str(v_open) + p5str(p5call(v_self, 'emit_javascript2', [(p5num(v_level) + 1)], 0)) + ' = ' + p5str(p5call(v_arguments, 'emit_javascript2', [(p5num(v_level) + 1)], 0)) + p5str(v_close))], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp3700._prototype_ = null;
					return tmp3700
				})());
				var Hash_emit_js = {};
				Hash_emit_js = p5a_to_h(['infix:<=~>', (function () {
							var tmp3864;
							tmp3864 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3865 = p5list_to_a([List__]);
									v_self = tmp3865.shift();
									v_level = tmp3865.shift();
									v_wantarray = tmp3865.shift();
								return (p5pkg['Perlito5::AST::Apply'].emit_regex_javascript2(p5list_to_a(['=~', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), v_level, v_wantarray]), p5want));
							};
							tmp3864._prototype_ = null;
							return tmp3864
						})(), 'infix:<!~>', (function () {
							var tmp3866;
							tmp3866 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3867 = p5list_to_a([List__]);
									v_self = tmp3867.shift();
									v_level = tmp3867.shift();
									v_wantarray = tmp3867.shift();
								return (p5pkg['Perlito5::AST::Apply'].emit_regex_javascript2(p5list_to_a(['!~', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), v_level, v_wantarray]), p5want));
							};
							tmp3866._prototype_ = null;
							return tmp3866
						})(), 'p5:s', (function () {
							var tmp3868;
							tmp3868 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3869 = p5list_to_a([List__]);
									v_self = tmp3869.shift();
									v_level = tmp3869.shift();
									v_wantarray = tmp3869.shift();
								return (p5pkg['Perlito5::AST::Apply'].emit_regex_javascript2(p5list_to_a(['=~', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(3), v_self, v_level, v_wantarray]), p5want));
							};
							tmp3868._prototype_ = null;
							return tmp3868
						})(), 'p5:m', (function () {
							var tmp3870;
							tmp3870 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3871 = p5list_to_a([List__]);
									v_self = tmp3871.shift();
									v_level = tmp3871.shift();
									v_wantarray = tmp3871.shift();
								return (p5pkg['Perlito5::AST::Apply'].emit_regex_javascript2(p5list_to_a(['=~', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(2), v_self, v_level, v_wantarray]), p5want));
							};
							tmp3870._prototype_ = null;
							return tmp3870
						})(), 'p5:tr', (function () {
							var tmp3872;
							tmp3872 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3873 = p5list_to_a([List__]);
									v_self = tmp3873.shift();
									v_level = tmp3873.shift();
									v_wantarray = tmp3873.shift();
								return (p5pkg['Perlito5::AST::Apply'].emit_regex_javascript2(p5list_to_a(['=~', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(3), v_self, v_level, v_wantarray]), p5want));
							};
							tmp3872._prototype_ = null;
							return tmp3872
						})(), 'p5:qr', (function () {
							var tmp3874;
							tmp3874 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3875 = p5list_to_a([List__]);
									v_self = tmp3875.shift();
									v_level = tmp3875.shift();
									v_wantarray = tmp3875.shift();
								return (p5context([('p5qr(' + p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp3874._prototype_ = null;
							return tmp3874
						})(), '__PACKAGE__', (function () {
							var tmp3876;
							tmp3876 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], p5want));
							};
							tmp3876._prototype_ = null;
							return tmp3876
						})(), '__SUB__', (function () {
							var tmp3877;
							tmp3877 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5defined_or(p5make_package('Perlito5::AST::Sub')['v_SUB_REF'], function () {
											return '__SUB__'
										}));
							};
							tmp3877._prototype_ = null;
							return tmp3877
						})(), 'wantarray', (function () {
							var tmp3878;
							tmp3878 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context(['p5want'], p5want));
							};
							tmp3878._prototype_ = null;
							return tmp3878
						})(), 'package', (function () {
							var tmp3879;
							tmp3879 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('p5make_package(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')]), 0)) + ')')], p5want));
							};
							tmp3879._prototype_ = null;
							return tmp3879
						})(), 'infix:<~~>', (function () {
							var tmp3880;
							tmp3880 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3881 = p5list_to_a([List__]);
									v_self = tmp3881.shift();
									v_level = tmp3881.shift();
									v_wantarray = tmp3881.shift();
								var v_arg0;
								v_arg0 = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								var v_arg1;
								v_arg1 = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1));
								return (p5context([('p5smrt_scalar(' + p5str(p5call(v_arg0, 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5call(v_arg1, 'emit_javascript2', [v_level, 'scalar'], 0)) + ')')], p5want));
							};
							tmp3880._prototype_ = null;
							return tmp3880
						})(), 'infix:<&&>', (function () {
							var tmp3882;
							tmp3882 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3883 = p5list_to_a([List__]);
									v_self = tmp3883.shift();
									v_level = tmp3883.shift();
									v_wantarray = tmp3883.shift();
								return (p5context([('p5and(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2(p5list_to_a([v_level, v_wantarray, (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp3882._prototype_ = null;
							return tmp3882
						})(), 'infix:<and>', (function () {
							var tmp3884;
							tmp3884 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3885 = p5list_to_a([List__]);
									v_self = tmp3885.shift();
									v_level = tmp3885.shift();
									v_wantarray = tmp3885.shift();
								return (p5context([('p5and(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2(p5list_to_a([v_level, v_wantarray, (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp3884._prototype_ = null;
							return tmp3884
						})(), 'infix:<||>', (function () {
							var tmp3886;
							tmp3886 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3887 = p5list_to_a([List__]);
									v_self = tmp3887.shift();
									v_level = tmp3887.shift();
									v_wantarray = tmp3887.shift();
								return (p5context([('p5or(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2(p5list_to_a([v_level, v_wantarray, (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp3886._prototype_ = null;
							return tmp3886
						})(), 'infix:<or>', (function () {
							var tmp3888;
							tmp3888 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3889 = p5list_to_a([List__]);
									v_self = tmp3889.shift();
									v_level = tmp3889.shift();
									v_wantarray = tmp3889.shift();
								return (p5context([('p5or(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2(p5list_to_a([v_level, v_wantarray, (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp3888._prototype_ = null;
							return tmp3888
						})(), 'infix:<xor>', (function () {
							var tmp3890;
							tmp3890 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3891 = p5list_to_a([List__]);
									v_self = tmp3891.shift();
									v_level = tmp3891.shift();
									v_wantarray = tmp3891.shift();
								return (p5context([('p5xor(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2(p5list_to_a([v_level, v_wantarray, (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp3890._prototype_ = null;
							return tmp3890
						})(), 'infix:<=>>', (function () {
							var tmp3892;
							tmp3892 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3893 = p5list_to_a([List__]);
									v_self = tmp3893.shift();
									v_level = tmp3893.shift();
									v_wantarray = tmp3893.shift();
								return (p5context([(p5str(p5call(p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0), 'emit_javascript2', [v_level], 0)) + ', ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), 'emit_javascript2', [v_level], 0)))], p5want));
							};
							tmp3892._prototype_ = null;
							return tmp3892
						})(), 'infix:<cmp>', (function () {
							var tmp3894;
							tmp3894 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('p5cmp(' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_str([p5make_package('main')['v__']], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							};
							tmp3894._prototype_ = null;
							return tmp3894
						})(), 'infix:<<=>>', (function () {
							var tmp3895;
							tmp3895 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('p5cmp(' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_num([p5make_package('main')['v__']], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							};
							tmp3895._prototype_ = null;
							return tmp3895
						})(), 'infix:<**>', (function () {
							var tmp3896;
							tmp3896 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('Math.pow(' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_num([p5make_package('main')['v__']], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							};
							tmp3896._prototype_ = null;
							return tmp3896
						})(), 'infix:<<<>', (function () {
							var tmp3897;
							tmp3897 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('p5shift_left(' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_num([p5make_package('main')['v__']], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							};
							tmp3897._prototype_ = null;
							return tmp3897
						})(), 'infix:<%>', (function () {
							var tmp3898;
							tmp3898 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('p5modulo(' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_num([p5make_package('main')['v__']], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							};
							tmp3898._prototype_ = null;
							return tmp3898
						})(), 'prefix:<!>', (function () {
							var tmp3899;
							tmp3899 = function (List__, p5want) {
								var v_self;
								v_self = (List__.shift());
								var v_level;
								v_level = (List__.shift());
								return (p5context([('!( ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), v_level]), 0)) + ')')], p5want));
							};
							tmp3899._prototype_ = null;
							return tmp3899
						})(), 'prefix:<not>', (function () {
							var tmp3900;
							tmp3900 = function (List__, p5want) {
								try {
									var v_self;
									v_self = (List__.shift());
									var v_level;
									v_level = (List__.shift());
									var v_arg;
									v_arg = (p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply').pop());
									(function () {
										if ( !( p5bool(v_arg)) ) {
										throw(p5context(['true'], p5want));
									}
									})();
									return (p5context([('!( ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool([v_arg, v_level], 0)) + ')')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3900._prototype_ = null;
							return tmp3900
						})(), 'prefix:<~>', (function () {
							var tmp3901;
							tmp3901 = function (List__, p5want) {
								var v_self;
								v_self = (p5list_slice(List__, [0], 0));
								return (p5context([('p5complement( ' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + ')')], p5want));
							};
							tmp3901._prototype_ = null;
							return tmp3901
						})(), 'prefix:<->', (function () {
							var tmp3902;
							tmp3902 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3903 = p5list_to_a([List__]);
									v_self = tmp3903.shift();
									v_level = tmp3903.shift();
									v_wantarray = tmp3903.shift();
								return (p5context([('p5negative( ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ')')], p5want));
							};
							tmp3902._prototype_ = null;
							return tmp3902
						})(), 'prefix:<+>', (function () {
							var tmp3904;
							tmp3904 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3905 = p5list_to_a([List__]);
									v_self = tmp3905.shift();
									v_level = tmp3905.shift();
									v_wantarray = tmp3905.shift();
								return (p5context([('(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, v_wantarray], 0)) + ')')], p5want));
							};
							tmp3904._prototype_ = null;
							return tmp3904
						})(), 'require', (function () {
							var tmp3906;
							tmp3906 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3907 = p5list_to_a([List__]);
									v_self = tmp3907.shift();
									v_level = tmp3907.shift();
									v_wantarray = tmp3907.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( p5bool((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('is_version_string')) ) {
										throw(p5context([('p5pkg["Perlito5"]["test_perl_version"]([' + p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + '], ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
									}
									})();
									return (p5context([('p5pkg["Perlito5::Grammar::Use"]["require"]([' + p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + ', ' + p5str(( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('bareword')) ? 1 : 0)) + '], ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3906._prototype_ = null;
							return tmp3906
						})(), 'select', (function () {
							var tmp3908;
							tmp3908 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3909 = p5list_to_a([List__]);
									v_self = tmp3909.shift();
									v_level = tmp3909.shift();
									v_wantarray = tmp3909.shift();
								return (p5context([('p5pkg["CORE"]["select"]([' + p5str(( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('bareword')) ? p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0) : p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0))) + '])')], p5want));
							};
							tmp3908._prototype_ = null;
							return tmp3908
						})(), 'prefix:<$>', (function () {
							var tmp3910;
							tmp3910 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3911 = p5list_to_a([List__]);
									v_self = tmp3911.shift();
									v_level = tmp3911.shift();
									v_wantarray = tmp3911.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5context([('p5scalar_deref(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + '""' + ')')], p5want));
							};
							tmp3910._prototype_ = null;
							return tmp3910
						})(), 'prefix:<@>', (function () {
							var tmp3912;
							tmp3912 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3913 = p5list_to_a([List__]);
									v_self = tmp3913.shift();
									v_level = tmp3913.shift();
									v_wantarray = tmp3913.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								var v_s;
								v_s = (('p5array_deref(' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify([v_arg, v_level, 'array'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')'));
								return (( (p5str(v_wantarray) == 'scalar') ? ('p5num(' + p5str(v_s) + ')') : v_s));
							};
							tmp3912._prototype_ = null;
							return tmp3912
						})(), 'prefix:<$#>', (function () {
							var tmp3914;
							tmp3914 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3915 = p5list_to_a([List__]);
									v_self = tmp3915.shift();
									v_level = tmp3915.shift();
									v_wantarray = tmp3915.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5context([('(p5array_deref(' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify([v_arg, v_level, 'array'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ').length - 1)')], p5want));
							};
							tmp3914._prototype_ = null;
							return tmp3914
						})(), 'prefix:<%>', (function () {
							var tmp3916;
							tmp3916 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3917 = p5list_to_a([List__]);
									v_self = tmp3917.shift();
									v_level = tmp3917.shift();
									v_wantarray = tmp3917.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5context([('p5hash_deref(' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify([v_arg, v_level, 'hash'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')')], p5want));
							};
							tmp3916._prototype_ = null;
							return tmp3916
						})(), 'prefix:<&>', (function () {
							var tmp3918;
							tmp3918 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3919 = p5list_to_a([List__]);
									v_self = tmp3919.shift();
									v_level = tmp3919.shift();
									v_wantarray = tmp3919.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5context([('p5code_lookup_by_name(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ')([])')], p5want));
							};
							tmp3918._prototype_ = null;
							return tmp3918
						})(), 'circumfix:<[ ]>', (function () {
							var tmp3920;
							tmp3920 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3921 = p5list_to_a([List__]);
									v_self = tmp3921.shift();
									v_level = tmp3921.shift();
									v_wantarray = tmp3921.shift();
								return (p5context([('(new p5ArrayRef(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 0)) + '))')], p5want));
							};
							tmp3920._prototype_ = null;
							return tmp3920
						})(), 'circumfix:<{ }>', (function () {
							var tmp3922;
							tmp3922 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3923 = p5list_to_a([List__]);
									v_self = tmp3923.shift();
									v_level = tmp3923.shift();
									v_wantarray = tmp3923.shift();
								return (p5context([('(new p5HashRef(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), v_level, 'hash']), 0)) + '))')], p5want));
							};
							tmp3922._prototype_ = null;
							return tmp3922
						})(), 'prefix:<' + String.fromCharCode(92) + '>', (function () {
							var tmp3924;
							tmp3924 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3925 = p5list_to_a([List__]);
									v_self = tmp3925.shift();
									v_level = tmp3925.shift();
									v_wantarray = tmp3925.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Apply'], 0)) ) {
										(function () {
											if ( (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<@>') ) {
											throw(p5context([('(new p5ArrayRef(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + '))')], p5want));
										}
										})();
										(function () {
											if ( (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<%>') ) {
											throw(p5context([('(new p5HashRef(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + '))')], p5want));
										}
										})();
										(function () {
											if ( (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'circumfix:<( )>') ) {
											throw(p5context([('p5_list_of_refs(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('arguments')]), 0)) + ')')], p5want));
										}
										})();
										(function () {
											if ( (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<&>') ) {
											throw(p5context([('p5code_lookup_by_name(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
										}
										})();
									}
									})();
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) ) {
										(function () {
											if ( (p5str(p5call(v_arg, 'sigil', [], 0)) == '@') ) {
											throw(p5context([('(new p5ArrayRef(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + '))')], p5want));
										}
										})();
										(function () {
											if ( (p5str(p5call(v_arg, 'sigil', [], 0)) == '%') ) {
											throw(p5context([('(new p5HashRef(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + '))')], p5want));
										}
										})();
										(function () {
											if ( (p5str(p5call(v_arg, 'sigil', [], 0)) == '*') ) {
											throw(p5context([('(new p5GlobRef(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + '))')], p5want));
										}
										})();
										(function () {
											if ( (p5str(p5call(v_arg, 'sigil', [], 0)) == '&') ) {
											(function () {
												if ( p5bool((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('namespace')) ) {
												throw(p5context([('p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('namespace')]), 0)) + '].' + p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('name')))], p5want));
											}
											else {
												throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].pkg([], 0)) + '.' + p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('name')))], p5want));
											}
											})();
										}
										})();
									}
									})();
									return (p5context([('(new p5ScalarRef(' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + '))')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3924._prototype_ = null;
							return tmp3924
						})(), 'postfix:<++>', (function () {
							var tmp3926;
							tmp3926 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3927 = p5list_to_a([List__]);
									v_self = tmp3927.shift();
									v_level = tmp3927.shift();
									v_wantarray = tmp3927.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Index'], 0)) || (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Lookup'], 0)) || p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Call'], 0)))) ) {
										throw(p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1), 0, 'p5postincr'], p5want));
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('sigil')) == '$')) ) {
										(function () {
											var v_tmp;
											v_tmp = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, 'scalar', ('var ' + p5str(v_tmp) + ' = ' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ';'), (p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ' = p5incr_(' + p5str(v_tmp) + ');'), ('return ' + p5str(v_tmp))], p5want));
										})();
									}
									})();
									return (p5context([('(' + p5pkg['Perlito5::AST::Apply'].join([' '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')++')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3926._prototype_ = null;
							return tmp3926
						})(), 'postfix:<-->', (function () {
							var tmp3928;
							tmp3928 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3929 = p5list_to_a([List__]);
									v_self = tmp3929.shift();
									v_level = tmp3929.shift();
									v_wantarray = tmp3929.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Index'], 0)) || (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Lookup'], 0)) || p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Call'], 0)))) ) {
										throw(p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1), 0, 'p5postdecr'], p5want));
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('sigil')) == '$')) ) {
										(function () {
											var v_tmp;
											v_tmp = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, 'scalar', ('var ' + p5str(v_tmp) + ' = ' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ';'), (p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ' = p5decr_(' + p5str(v_tmp) + ');'), ('return ' + p5str(v_tmp))], p5want));
										})();
									}
									})();
									return (p5context([('(' + p5pkg['Perlito5::AST::Apply'].join([' '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')--')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3928._prototype_ = null;
							return tmp3928
						})(), 'prefix:<++>', (function () {
							var tmp3930;
							tmp3930 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3931 = p5list_to_a([List__]);
									v_self = tmp3931.shift();
									v_level = tmp3931.shift();
									v_wantarray = tmp3931.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Index'], 0)) || (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Lookup'], 0)) || p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Call'], 0)))) ) {
										throw(p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1), 0, 'p5incr'], p5want));
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('sigil')) == '$')) ) {
										(function () {
											var v_tmp;
											v_tmp = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, 'scalar', ('var ' + p5str(v_tmp) + ' = ' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ';'), (p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ' = p5incr_(' + p5str(v_tmp) + ');'), ('return ' + p5str(p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1)], 0)))], p5want));
										})();
									}
									})();
									return (p5context([('++(' + p5pkg['Perlito5::AST::Apply'].join([' '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3930._prototype_ = null;
							return tmp3930
						})(), 'prefix:<-->', (function () {
							var tmp3932;
							tmp3932 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3933 = p5list_to_a([List__]);
									v_self = tmp3933.shift();
									v_level = tmp3933.shift();
									v_wantarray = tmp3933.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Index'], 0)) || (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Lookup'], 0)) || p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Call'], 0)))) ) {
										throw(p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1), 0, 'p5decr'], p5want));
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('sigil')) == '$')) ) {
										(function () {
											var v_tmp;
											v_tmp = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, 'scalar', ('var ' + p5str(v_tmp) + ' = ' + p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ';'), (p5str(p5call(v_arg, 'emit_javascript2', [v_level], 0)) + ' = p5decr_(' + p5str(v_tmp) + ');'), ('return ' + p5str(p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1)], 0)))], p5want));
										})();
									}
									})();
									return (p5context([('--(' + p5pkg['Perlito5::AST::Apply'].join([' '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3932._prototype_ = null;
							return tmp3932
						})(), 'infix:<x>', (function () {
							var tmp3934;
							tmp3934 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3935 = p5list_to_a([List__]);
									v_self = tmp3935.shift();
									v_level = tmp3935.shift();
									v_wantarray = tmp3935.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( ((p5pkg['Perlito5::AST::Apply'].ref([v_arg], 0) == 'Perlito5::AST::Apply') && ((p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'circumfix:<( )>') || (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'list:<,>'))) ) {
										throw(p5context([('p5list_replicate(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'list'], 0)) + ',' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), v_level]), 0)) + ', ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ')')], p5want));
									}
									})();
									return (p5context([('p5str_replicate(' + p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), v_level]), 0)) + ',' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), v_level]), 0)) + ')')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3934._prototype_ = null;
							return tmp3934
						})(), 'list:<.>', (function () {
							var tmp3936;
							tmp3936 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3937 = p5list_to_a([List__]);
									v_self = tmp3937.shift();
									v_level = tmp3937.shift();
									v_wantarray = tmp3937.shift();
								return (p5context([('(' + p5pkg['Perlito5::AST::Apply'].join([' + '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_str([p5make_package('main')['v__']], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							};
							tmp3936._prototype_ = null;
							return tmp3936
						})(), 'list:<,>', (function () {
							var tmp3938;
							tmp3938 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3939 = p5list_to_a([List__]);
									v_self = tmp3939.shift();
									v_level = tmp3939.shift();
									v_wantarray = tmp3939.shift();
								return (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), p5want));
							};
							tmp3938._prototype_ = null;
							return tmp3938
						})(), 'infix:<..>', (function () {
							var tmp3940;
							tmp3940 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3941 = p5list_to_a([List__]);
									v_self = tmp3941.shift();
									v_level = tmp3941.shift();
									v_wantarray = tmp3941.shift();
								return (p5context([('p5range(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level], 0)) + ', ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), 'emit_javascript2', [v_level], 0)) + ', ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ', ' + '"' + p5str(p5pkg['Perlito5::Javascript2'].get_label([], 0)) + '"' + ', ' + '0' + ')')], p5want));
							};
							tmp3940._prototype_ = null;
							return tmp3940
						})(), 'infix:<...>', (function () {
							var tmp3942;
							tmp3942 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3943 = p5list_to_a([List__]);
									v_self = tmp3943.shift();
									v_level = tmp3943.shift();
									v_wantarray = tmp3943.shift();
								return (p5context([('p5range(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level], 0)) + ', ' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1), 'emit_javascript2', [v_level], 0)) + ', ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ', ' + '"' + p5str(p5pkg['Perlito5::Javascript2'].get_label([], 0)) + '"' + ', ' + '1' + ')')], p5want));
							};
							tmp3942._prototype_ = null;
							return tmp3942
						})(), 'delete', (function () {
							var tmp3944;
							tmp3944 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3945 = p5list_to_a([List__]);
									v_self = tmp3945.shift();
									v_level = tmp3945.shift();
									v_wantarray = tmp3945.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Lookup'], 0)) ) {
										(function () {
											var v_v;
											v_v = (p5call(v_arg, 'obj', [], 0));
											(function () {
												if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '$')) ) {
												throw(p5context([('(delete ' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + '[' + p5str(p5call(p5call(v_arg, 'autoquote', p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_javascript2', [v_level], 0)) + '])')], p5want));
											}
											})();
											throw(p5context([('(delete ' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + '._hash_[' + p5str(p5call(p5call(v_arg, 'autoquote', p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_javascript2', [v_level], 0)) + '])')], p5want));
										})();
									}
									})();
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Index'], 0)) ) {
										(function () {
											var v_v;
											v_v = (p5call(v_arg, 'obj', [], 0));
											(function () {
												if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '$')) ) {
												throw(p5context([('(delete ' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + '[' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_javascript2', [v_level], 0)) + '])')], p5want));
											}
											})();
											throw(p5context([('(delete ' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + '._array_[' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_javascript2', [v_level], 0)) + '])')], p5want));
										})();
									}
									})();
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Call'], 0)) ) {
										(function () {
											if ( (p5str(p5call(v_arg, 'method', [], 0)) == 'postcircumfix:<{ }>') ) {
											throw(p5context([('(delete ' + p5str(p5call(p5call(v_arg, 'invocant', [], 0), 'emit_javascript2', [], 0)) + '._hash_[' + p5str(p5call(p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('arguments')]), 0), 'emit_javascript2', [v_level], 0)) + '])')], p5want));
										}
										})();
										(function () {
											if ( (p5str(p5call(v_arg, 'method', [], 0)) == 'postcircumfix:<[ ]>') ) {
											throw(p5context([('(delete ' + p5str(p5call(p5call(v_arg, 'invocant', [], 0), 'emit_javascript2', [], 0)) + '._array_[' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('arguments'), 'emit_javascript2', [v_level], 0)) + '])')], p5want));
										}
										})();
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_arg, 'sigil', [], 0)) == '&')) ) {
										p5pkg['Perlito5::AST::Apply'].die([].concat(['TODO delete &code']), null);
									}
									})();
									return (function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<&>')) ) {
										return (p5pkg['Perlito5::AST::Apply'].die([].concat(['TODO delete &$code']), p5want));
									}
									})()
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3944._prototype_ = null;
							return tmp3944
						})(), 'scalar', (function () {
							var tmp3946;
							tmp3946 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3947 = p5list_to_a([List__]);
									v_self = tmp3947.shift();
									v_level = tmp3947.shift();
									v_wantarray = tmp3947.shift();
								return (p5pkg['Perlito5::Javascript2'].to_scalar(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1)]), p5want));
							};
							tmp3946._prototype_ = null;
							return tmp3946
						})(), 'ternary:<? :>', (function () {
							var tmp3948;
							tmp3948 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3949 = p5list_to_a([List__]);
									v_self = tmp3949.shift();
									v_level = tmp3949.shift();
									v_wantarray = tmp3949.shift();
								return (p5context([('( ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + ' ? ' + p5str(p5call(p5context([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)], 0), 'emit_javascript2', [v_level, v_wantarray], 0)) + ' : ' + p5str(p5call(p5context([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(2)], 0), 'emit_javascript2', [v_level, v_wantarray], 0)) + ')')], p5want));
							};
							tmp3948._prototype_ = null;
							return tmp3948
						})(), 'my', (function () {
							var tmp3950;
							tmp3950 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3951 = p5list_to_a([List__]);
									v_self = tmp3951.shift();
									v_level = tmp3951.shift();
									v_wantarray = tmp3951.shift();
								return (p5context([('p5context(' + '[' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + '], ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ')')], p5want));
							};
							tmp3950._prototype_ = null;
							return tmp3950
						})(), 'our', (function () {
							var tmp3952;
							tmp3952 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3953 = p5list_to_a([List__]);
									v_self = tmp3953.shift();
									v_level = tmp3953.shift();
									v_wantarray = tmp3953.shift();
								return (p5context([('p5context(' + '[' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + '], ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ')')], p5want));
							};
							tmp3952._prototype_ = null;
							return tmp3952
						})(), 'local', (function () {
							var tmp3954;
							tmp3954 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3955 = p5list_to_a([List__]);
									v_self = tmp3955.shift();
									v_level = tmp3955.shift();
									v_wantarray = tmp3955.shift();
								return (p5context([('p5context(' + '[' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + '], ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ')')], p5want));
							};
							tmp3954._prototype_ = null;
							return tmp3954
						})(), 'circumfix:<( )>', (function () {
							var tmp3956;
							tmp3956 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3957 = p5list_to_a([List__]);
									v_self = tmp3957.shift();
									v_level = tmp3957.shift();
									v_wantarray = tmp3957.shift();
								return (p5context([('p5context(' + '[' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level, v_wantarray], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + '], ' + p5str(( (p5str(v_wantarray) == 'runtime') ? 'p5want' : ( (p5str(v_wantarray) == 'list') ? 1 : 0))) + ')')], p5want));
							};
							tmp3956._prototype_ = null;
							return tmp3956
						})(), 'infix:<=>', (function () {
							var tmp3958;
							tmp3958 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3959 = p5list_to_a([List__]);
									v_self = tmp3959.shift();
									v_level = tmp3959.shift();
									v_wantarray = tmp3959.shift();
									var v_parameters;
									v_parameters = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									var v_arguments;
									v_arguments = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1));
									(function () {
										if ( (p5bool(p5call(v_parameters, 'isa', ['Perlito5::AST::Apply'], 0)) && ((p5str(p5call(v_parameters, 'code', [], 0)) == 'my') || ((p5str(p5call(v_parameters, 'code', [], 0)) == 'local') || (p5str(p5call(v_parameters, 'code', [], 0)) == 'circumfix:<( )>')))) ) {
										(function () {
											(function () {
												if ( (p5str(v_wantarray) == 'void') ) {
												(function () {
													var v_tmp;
													v_tmp = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
													throw(p5context([p5pkg['Perlito5::AST::Apply'].join([(';' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat(p5list_to_a([('var ' + p5str(v_tmp) + ' = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0))), p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
																return (p5call(p5make_package('main')['v__'], 'emit_javascript2_set_list', [v_level, v_tmp], 1));
															}, p5list_to_a([p5array_deref(p5call(v_parameters, 'arguments', [], p5want), 'Perlito5::AST::Apply')]))])), p5want)], p5want));
												})();
											}
											})();
											var v_tmp;
											v_tmp = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
											var v_tmp2;
											v_tmp2 = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, ('var ' + p5str(v_tmp) + ' = ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef([v_arguments])), (p5num(v_level) + 1)]), 0)) + ';'), ('var ' + p5str(v_tmp2) + ' = ' + p5str(v_tmp) + '.slice(0);'), p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
	return ((p5str(p5call(p5make_package('main')['v__'], 'emit_javascript2_set_list', [(p5num(v_level) + 1), v_tmp], 0)) + ';'));
}, p5list_to_a([p5array_deref(p5call(v_parameters, 'arguments', [], p5want), 'Perlito5::AST::Apply')])), ('return ' + p5str(v_tmp2))]), p5want));
										})();
									}
									})();
									return (p5call(v_parameters, 'emit_javascript2_set', [v_arguments, (p5num(v_level) + 1), v_wantarray], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3958._prototype_ = null;
							return tmp3958
						})(), 'break', (function () {
							var tmp3960;
							tmp3960 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3961 = p5list_to_a([List__]);
									v_self = tmp3961.shift();
									v_level = tmp3961.shift();
									v_wantarray = tmp3961.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_statement_javascript2([v_level, v_wantarray, 'throw(new p5_error("break", ""))'], p5want));
							};
							tmp3960._prototype_ = null;
							return tmp3960
						})(), 'next', (function () {
							var tmp3962;
							tmp3962 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3963 = p5list_to_a([List__]);
									v_self = tmp3963.shift();
									v_level = tmp3963.shift();
									v_wantarray = tmp3963.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								var v_label;
								v_label = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('code'), function () {
												return ''
											}));
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_statement_javascript2([v_level, v_wantarray, ('throw(new p5_error("next", ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_label], 0)) + '))')], p5want));
							};
							tmp3962._prototype_ = null;
							return tmp3962
						})(), 'last', (function () {
							var tmp3964;
							tmp3964 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3965 = p5list_to_a([List__]);
									v_self = tmp3965.shift();
									v_level = tmp3965.shift();
									v_wantarray = tmp3965.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								var v_label;
								v_label = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('code'), function () {
												return ''
											}));
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_statement_javascript2([v_level, v_wantarray, ('throw(new p5_error("last", ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_label], 0)) + '))')], p5want));
							};
							tmp3964._prototype_ = null;
							return tmp3964
						})(), 'redo', (function () {
							var tmp3966;
							tmp3966 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3967 = p5list_to_a([List__]);
									v_self = tmp3967.shift();
									v_level = tmp3967.shift();
									v_wantarray = tmp3967.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								var v_label;
								v_label = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('code'), function () {
												return ''
											}));
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_statement_javascript2([v_level, v_wantarray, ('throw(new p5_error("redo", ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_label], 0)) + '))')], p5want));
							};
							tmp3966._prototype_ = null;
							return tmp3966
						})(), 'return', (function () {
							var tmp3968;
							tmp3968 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3969 = p5list_to_a([List__]);
									v_self = tmp3969.shift();
									v_level = tmp3969.shift();
									v_wantarray = tmp3969.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_statement_javascript2([v_level, v_wantarray, ('throw(' + p5str(p5pkg['Perlito5::Javascript2'].to_runtime_context(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), (p5num(v_level) + 1)]), 0)) + ')')], p5want));
							};
							tmp3968._prototype_ = null;
							return tmp3968
						})(), 'goto', (function () {
							var tmp3970;
							tmp3970 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3971 = p5list_to_a([List__]);
									v_self = tmp3971.shift();
									v_level = tmp3971.shift();
									v_wantarray = tmp3971.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_statement_javascript2([v_level, v_wantarray, ('throw(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
							};
							tmp3970._prototype_ = null;
							return tmp3970
						})(), 'do', (function () {
							var tmp3972;
							tmp3972 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3973 = p5list_to_a([List__]);
									v_self = tmp3973.shift();
									v_level = tmp3973.shift();
									v_wantarray = tmp3973.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Block'], 0)) ) {
										(function () {
											var v_block;
											v_block = ((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('stmts'));
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_block], 0)], 0), 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 1)]), p5want));
										})();
									}
									})();
									var v_tmp_strict;
									v_tmp_strict = (p5make_package('Perlito5')['v_STRICT']);
									p5make_package('Perlito5')['v_STRICT'] = (0);
									var v_ast;
									v_ast = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'eval', 'namespace', '', 'arguments', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'do_file', 'namespace', 'Perlito5::Grammar::Use', 'arguments', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 1)]))), '_scope', p5call('Perlito5::Grammar::Scope', 'new_base_scope', [], 1)]), 0));
									var v_js;
									v_js = (p5call(v_ast, 'emit_javascript2', [v_level, v_wantarray], 0));
									p5make_package('Perlito5')['v_STRICT'] = (v_tmp_strict);
									return (p5context([v_js], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3972._prototype_ = null;
							return tmp3972
						})(), 'eval', (function () {
							var tmp3974;
							tmp3974 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3975 = p5list_to_a([List__]);
									v_self = tmp3975.shift();
									v_level = tmp3975.shift();
									v_wantarray = tmp3975.shift();
								p5make_package('Perlito5')['v_THROW'] = (1);
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								var v_eval;
								(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Block'], 0)) ) {
										v_eval = (p5call(p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'do', 'arguments', (new p5ArrayRef([v_arg]))]), 0), 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0));
									}
									else {
										(function () {
											var v_scope_perl5;
											v_scope_perl5 = (p5pkg['Perlito5::Dumper'].ast_dumper(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('_scope')])))]), 0));
											var v_m;
											v_m = (p5pkg['Perlito5::Grammar::Expression'].term_square([v_scope_perl5, 0], 0));
											(function () {
												if ( (!( p5bool(v_m)) || (p5num((v_m || (v_m = new p5HashRef({})))._hash_.p5hget('to')) < p5pkg['Perlito5::AST::Apply'].length([v_scope_perl5], 0))) ) {
												p5pkg['Perlito5::AST::Apply'].die([].concat(['invalid internal scope in eval' + String.fromCharCode(10)]), null);
											}
											})();
											v_m = (p5pkg['Perlito5::Grammar::Expression'].expand_list(p5list_to_a([p5pkg['Perlito5::Match'].flat([v_m], p5want)._array_.p5aget(2)]), 0));
											var v_scope_js;
											v_scope_js = (('(new p5ArrayRef(' + p5str(p5pkg['Perlito5::Javascript2'].to_list([v_m], 0)) + '))'));
											v_eval = (('eval(p5pkg["Perlito5::Javascript2::Runtime"].perl5_to_js([' + p5str(p5pkg['Perlito5::Javascript2'].to_str([v_arg], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_wantarray], 0)) + ', ' + p5str(v_scope_js) + ']))'));
										})();
									}
									})();
								var v_context;
								v_context = (p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0));
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, ( (p5str(v_context) == 'p5want') ? p5context([], 1) : ('var p5want = ' + p5str(v_context) + ';')), 'var r;', 'p5pkg["main"]["v_@"] = "";', 'var p5strict = p5pkg["Perlito5"]["v_STRICT"];', ('p5pkg["Perlito5"]["v_STRICT"] = ' + p5str(p5make_package('Perlito5')['v_STRICT']) + ';'), 'try {', (new p5ArrayRef([('r = ' + p5str(v_eval) + '')])), '}', 'catch(err) {', (new p5ArrayRef(p5list_to_a(['if (err instanceof p5_error && (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ' || err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ' || err.type == ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ')) {', (new p5ArrayRef(['throw(err)'])), '}', 'else if ( err instanceof p5_error || err instanceof Error ) {', (new p5ArrayRef(p5list_to_a(['p5pkg["main"]["v_@"] = err;', 'if (p5str(p5pkg["main"]["v_@"]).substr(-1, 1) != "' + String.fromCharCode(92) + 'n") {', (new p5ArrayRef(p5list_to_a([('try {' + ''), (new p5ArrayRef(['p5pkg["main"]["v_@"] = p5pkg["main"]["v_@"] + "' + String.fromCharCode(92) + 'n" + err.stack + "' + String.fromCharCode(92) + 'n";'])), '}', 'catch(err) { }']))), '}']))), '}', 'else {', (new p5ArrayRef(['return(err);'])), '}']))), '}', 'p5pkg["Perlito5"]["v_STRICT"] = p5strict;', 'return r;']), p5want));
							};
							tmp3974._prototype_ = null;
							return tmp3974
						})(), 'substr', (function () {
							var tmp3976;
							tmp3976 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3977 = p5list_to_a([List__]);
									v_self = tmp3977.shift();
									v_level = tmp3977.shift();
									v_wantarray = tmp3977.shift();
									var v_length;
									v_length = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(2));
									(function () {
										if ( (p5bool(v_length) && (p5bool(p5call(v_length, 'isa', ['Perlito5::AST::Int'], 0)) && (p5num((v_length || (v_length = new p5HashRef({})))._hash_.p5hget('int')) > 0))) ) {
										throw(p5context([(p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + '.substr(' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_num(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(2)]), 0)) + ')')], p5want));
									}
									})();
									var v_arg_list;
									v_arg_list = (p5pkg['Perlito5::Javascript2'].to_list_preprocess(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 0));
									var v_arg_code;
									v_arg_code = (p5pkg['Perlito5::Javascript2'].to_list([v_arg_list], 0));
									return (p5context([('CORE.substr(' + p5str(v_arg_code) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3976._prototype_ = null;
							return tmp3976
						})(), 'undef', (function () {
							var tmp3978;
							tmp3978 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3979 = p5list_to_a([List__]);
									v_self = tmp3979.shift();
									v_level = tmp3979.shift();
									v_wantarray = tmp3979.shift();
									(function () {
										if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')) && p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')))) ) {
										(function () {
											var v_arg;
											v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
											(function () {
												if ( ((p5pkg['Perlito5::AST::Apply'].ref([v_arg], 0) == 'Perlito5::AST::Var') && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('sigil')) == '&')) ) {
												throw(p5context([('(delete p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
	return p5make_package('Perlito5')['v_PKG_NAME']
})]), 0)) + '][' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('name')]), 0)) + '])')], p5want));
											}
											})();
											throw(p5context([('(' + p5str(p5call(v_arg, 'emit_javascript2', [], 0)) + ' = null)')], p5want));
										})();
									}
									})();
									return (p5context(['null'], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3978._prototype_ = null;
							return tmp3978
						})(), 'defined', (function () {
							var tmp3980;
							tmp3980 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3981 = p5list_to_a([List__]);
									v_self = tmp3981.shift();
									v_level = tmp3981.shift();
									v_wantarray = tmp3981.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								var v_invocant;
								(function () {
										if ( ((p5pkg['Perlito5::AST::Apply'].ref([v_arg], 0) == 'Perlito5::AST::Apply') && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<&>')) ) {
										(function () {
											var v_arg2;
											v_arg2 = ((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
											v_invocant = (('p5code_lookup_by_name(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ', ' + p5str(p5call(v_arg2, 'emit_javascript2', [v_level], 0)) + ')'));
										})();
									}
									else (function () {
										if ( ((p5pkg['Perlito5::AST::Apply'].ref([v_arg], 0) == 'Perlito5::AST::Var') && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('sigil')) == '&')) ) {
										v_invocant = (('p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
	return p5make_package('Perlito5')['v_PKG_NAME']
})]), 0)) + '][' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('name')]), 0)) + ']'));
									}
									else {
										v_invocant = (p5call(v_arg, 'emit_javascript2', [v_level, 'scalar'], 0));
									}
									})()
									})();
								return (p5context([('(' + p5str(v_invocant) + ' != null)')], p5want));
							};
							tmp3980._prototype_ = null;
							return tmp3980
						})(), 'shift', (function () {
							var tmp3982;
							tmp3982 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3983 = p5list_to_a([List__]);
									v_self = tmp3983.shift();
									v_level = tmp3983.shift();
									v_wantarray = tmp3983.shift();
									(function () {
										if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')) && p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')))) ) {
										throw(p5context([(p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level], 0)) + '.shift()')], p5want));
									}
									})();
									return (p5context(['List__.shift()'], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3982._prototype_ = null;
							return tmp3982
						})(), 'pop', (function () {
							var tmp3984;
							tmp3984 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp3985 = p5list_to_a([List__]);
									v_self = tmp3985.shift();
									v_level = tmp3985.shift();
									v_wantarray = tmp3985.shift();
									(function () {
										if ( (p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')) && p5bool(p5num(p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')))) ) {
										throw(p5context([(p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level], 0)) + '.pop()')], p5want));
									}
									})();
									return (p5context(['List__.pop()'], p5want));
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp3984._prototype_ = null;
							return tmp3984
						})(), 'unshift', (function () {
							var tmp3986;
							tmp3986 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3987 = p5list_to_a([List__]);
									v_self = tmp3987.shift();
									v_level = tmp3987.shift();
									v_wantarray = tmp3987.shift();
								var List_arguments = [];
								List_arguments = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_v;
								v_v = (List_arguments.shift());
								return (p5context([(p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + '.p5unshift(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_arguments))]), 0)) + ')')], p5want));
							};
							tmp3986._prototype_ = null;
							return tmp3986
						})(), 'push', (function () {
							var tmp3988;
							tmp3988 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3989 = p5list_to_a([List__]);
									v_self = tmp3989.shift();
									v_level = tmp3989.shift();
									v_wantarray = tmp3989.shift();
								var List_arguments = [];
								List_arguments = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_v;
								v_v = (List_arguments.shift());
								return (p5context([(p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + '.p5push(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_arguments))]), 0)) + ')')], p5want));
							};
							tmp3988._prototype_ = null;
							return tmp3988
						})(), 'tie', (function () {
							var tmp3990;
							tmp3990 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3991 = p5list_to_a([List__]);
									v_self = tmp3991.shift();
									v_level = tmp3991.shift();
									v_wantarray = tmp3991.shift();
								var List_arguments = [];
								List_arguments = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_v;
								v_v = (List_arguments.shift());
								var v_meth;
								(function () {
										if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '%')) ) {
										v_meth = ('hash');
									}
									else (function () {
										if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '@')) ) {
										v_meth = ('array');
									}
									else (function () {
										if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '$')) ) {
										v_meth = ('scalar');
									}
									else {
										p5pkg['Perlito5::AST::Apply'].die([].concat(['tie ' + String.fromCharCode(39), p5pkg['Perlito5::AST::Apply'].ref([v_v], 1), String.fromCharCode(39) + ' not implemented']), null);
									}
									})()
									})()
									})();
								return (p5context([('p5tie_' + p5str(v_meth) + '(' + p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_arguments))]), 0)) + ')')], p5want));
							};
							tmp3990._prototype_ = null;
							return tmp3990
						})(), 'untie', (function () {
							var tmp3992;
							tmp3992 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3993 = p5list_to_a([List__]);
									v_self = tmp3993.shift();
									v_level = tmp3993.shift();
									v_wantarray = tmp3993.shift();
								var List_arguments = [];
								List_arguments = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_v;
								v_v = (List_arguments.shift());
								var v_meth;
								(function () {
										if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '%')) ) {
										v_meth = ('hash');
									}
									else (function () {
										if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '@')) ) {
										v_meth = ('array');
									}
									else (function () {
										if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '$')) ) {
										v_meth = ('scalar');
									}
									else {
										p5pkg['Perlito5::AST::Apply'].die([].concat(['tie ' + String.fromCharCode(39), p5pkg['Perlito5::AST::Apply'].ref([v_v], 1), String.fromCharCode(39) + ' not implemented']), null);
									}
									})()
									})()
									})();
								return (p5context([('p5untie_' + p5str(v_meth) + '(' + p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + ')')], p5want));
							};
							tmp3992._prototype_ = null;
							return tmp3992
						})(), 'print', (function () {
							var tmp3994;
							tmp3994 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3995 = p5list_to_a([List__]);
									v_self = tmp3995.shift();
									v_level = tmp3995.shift();
									v_wantarray = tmp3995.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								(function () {
										if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
										v_fun = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg'), 'emit_javascript2', [v_level], 0));
									}
									else {
										v_fun = ('"STDOUT"');
									}
									})();
								var v_list;
								v_list = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in))]), 0));
								return (p5context([('p5pkg["Perlito5::IO"].print(' + p5str(v_fun) + ', ' + p5str(v_list) + ')')], p5want));
							};
							tmp3994._prototype_ = null;
							return tmp3994
						})(), 'say', (function () {
							var tmp3996;
							tmp3996 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3997 = p5list_to_a([List__]);
									v_self = tmp3997.shift();
									v_level = tmp3997.shift();
									v_wantarray = tmp3997.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								(function () {
										if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
										v_fun = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg'), 'emit_javascript2', [v_level], 0));
									}
									else {
										v_fun = ('"STDOUT"');
									}
									})();
								var v_list;
								v_list = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in))]), 0));
								return (p5context([('p5pkg["Perlito5::IO"].say(' + p5str(v_fun) + ', ' + p5str(v_list) + ')')], p5want));
							};
							tmp3996._prototype_ = null;
							return tmp3996
						})(), 'printf', (function () {
							var tmp3998;
							tmp3998 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp3999 = p5list_to_a([List__]);
									v_self = tmp3999.shift();
									v_level = tmp3999.shift();
									v_wantarray = tmp3999.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								(function () {
										if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
										v_fun = (p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg'), 'emit_javascript2', [v_level], 0));
									}
									else {
										v_fun = ('"STDOUT"');
									}
									})();
								var v_list;
								v_list = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in))]), 0));
								return (p5context([('p5pkg["Perlito5::IO"].printf(' + p5str(v_fun) + ', ' + p5str(v_list) + ')')], p5want));
							};
							tmp3998._prototype_ = null;
							return tmp3998
						})(), 'close', (function () {
							var tmp4000;
							tmp4000 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4001 = p5list_to_a([List__]);
									v_self = tmp4001.shift();
									v_level = tmp4001.shift();
									v_wantarray = tmp4001.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								v_fun = (List_in.shift());
								return (p5context([('p5pkg["Perlito5::IO"].close(' + p5str(p5call(v_fun, 'emit_javascript2', [v_level], 0)) + ', [])')], p5want));
							};
							tmp4000._prototype_ = null;
							return tmp4000
						})(), 'open', (function () {
							var tmp4002;
							tmp4002 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp4003 = p5list_to_a([List__]);
									v_self = tmp4003.shift();
									v_level = tmp4003.shift();
									v_wantarray = tmp4003.shift();
									var List_in = [];
									List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
									var v_fun;
									v_fun = (List_in.shift());
									return (function () {
										if ( (p5pkg['Perlito5::AST::Apply'].ref([v_fun], 0) != 'Perlito5::AST::Apply') ) {
										(function () {
											throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, v_wantarray, (p5str(p5call(v_fun, 'emit_javascript2', [v_level], 0)) + ' = CORE.bless([ {file_handle : {id : null}}, "GLOB" ]);'), ('return CORE.open(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), v_level]), 0)) + ')')], p5want))
										})()
									}
									else {
										p5make_package('Perlito5')['v_STRICT'] = (0);
										(function () {
											throw(p5context([('CORE.open(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), v_level]), 0)) + ')')], p5want))
										})()
									}
									})()
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp4002._prototype_ = null;
							return tmp4002
						})(), 'chomp', (function () {
							var tmp4004;
							tmp4004 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4005 = p5list_to_a([List__]);
									v_self = tmp4005.shift();
									v_level = tmp4005.shift();
									v_wantarray = tmp4005.shift();
								var v_v;
								v_v = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, v_wantarray, ('var r = p5chomp(' + p5str(p5pkg['Perlito5::Javascript2'].to_str([v_v, v_level], 0)) + ');'), (p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + ' = r[1];'), 'return r[0]'], p5want));
							};
							tmp4004._prototype_ = null;
							return tmp4004
						})(), 'chop', (function () {
							var tmp4006;
							tmp4006 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4007 = p5list_to_a([List__]);
									v_self = tmp4007.shift();
									v_level = tmp4007.shift();
									v_wantarray = tmp4007.shift();
								var v_v;
								v_v = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, v_wantarray, ('var r = p5chop(' + p5str(p5pkg['Perlito5::Javascript2'].to_str([v_v, v_level], 0)) + ');'), (p5str(p5call(v_v, 'emit_javascript2', [v_level], 0)) + ' = r[1];'), 'return r[0]'], p5want));
							};
							tmp4006._prototype_ = null;
							return tmp4006
						})(), 'read', (function () {
							var tmp4008;
							tmp4008 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4009 = p5list_to_a([List__]);
									v_self = tmp4009.shift();
									v_level = tmp4009.shift();
									v_wantarray = tmp4009.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								v_fun = (List_in.shift());
								var v_scalar;
								v_scalar = (List_in.shift());
								var v_length;
								v_length = (List_in.shift());
								return (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2([v_level, v_wantarray, ('var r = p5pkg["Perlito5::IO"].read(' + p5str(p5call(v_fun, 'emit_javascript2', [v_level], 0)) + ', [' + p5str(p5call(v_length, 'emit_javascript2', [v_level], 0)) + ']);'), (p5str(p5call(v_scalar, 'emit_javascript2', [v_level], 0)) + ' = r[1];'), 'return r[0]'], p5want));
							};
							tmp4008._prototype_ = null;
							return tmp4008
						})(), 'readline', (function () {
							var tmp4010;
							tmp4010 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4011 = p5list_to_a([List__]);
									v_self = tmp4011.shift();
									v_level = tmp4011.shift();
									v_wantarray = tmp4011.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								v_fun = (p5or(List_in.shift(), function () {
												return p5pkg['Perlito5::AST::Apply'].bless([(new p5HashRef(p5a_to_h(p5list_to_a(['arguments', (new p5ArrayRef([])), 'bareword', 1, 'code', 'ARGV', 'namespace', ''])))), 'Perlito5::AST::Apply'], 0)
											}));
								return (p5context([('CORE.readline([' + p5str(p5call(v_fun, 'emit_javascript2', [v_level], 0)) + '], ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
							};
							tmp4010._prototype_ = null;
							return tmp4010
						})(), 'map', (function () {
							var tmp4012;
							tmp4012 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4013 = p5list_to_a([List__]);
									v_self = tmp4013.shift();
									v_level = tmp4013.shift();
									v_wantarray = tmp4013.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								(function () {
										if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
										v_fun = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg'));
									}
									else {
										v_fun = (List_in.shift());
									}
									})();
								var v_list;
								v_list = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in))]), 0));
								(function () {
										if ( (p5pkg['Perlito5::AST::Apply'].ref([v_fun], 0) == 'Perlito5::AST::Block') ) {
										v_fun = ((v_fun || (v_fun = new p5HashRef({})))._hash_.p5hget('stmts'));
									}
									else {
										v_fun = ((new p5ArrayRef([v_fun])));
									}
									})();
								return (p5context([('p5map(' + p5str(p5pkg['Perlito5::Javascript2'].pkg([], 0)) + ', ' + 'function (p5want) {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_fun], 0)], 0), 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}, ' + p5str(v_list) + ')')], p5want));
							};
							tmp4012._prototype_ = null;
							return tmp4012
						})(), 'grep', (function () {
							var tmp4014;
							tmp4014 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4015 = p5list_to_a([List__]);
									v_self = tmp4015.shift();
									v_level = tmp4015.shift();
									v_wantarray = tmp4015.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								(function () {
										if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
										v_fun = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg'));
									}
									else {
										v_fun = (List_in.shift());
									}
									})();
								var v_list;
								v_list = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in))]), 0));
								(function () {
										if ( (p5pkg['Perlito5::AST::Apply'].ref([v_fun], 0) == 'Perlito5::AST::Block') ) {
										v_fun = ((v_fun || (v_fun = new p5HashRef({})))._hash_.p5hget('stmts'));
									}
									else {
										v_fun = ((new p5ArrayRef([v_fun])));
									}
									})();
								return (p5context([('p5grep(' + p5str(p5pkg['Perlito5::Javascript2'].pkg([], 0)) + ', ' + 'function (p5want) {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_fun], 0)], 0), 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}, ' + p5str(v_list) + ')')], p5want));
							};
							tmp4014._prototype_ = null;
							return tmp4014
						})(), 'sort', (function () {
							var tmp4016;
							tmp4016 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4017 = p5list_to_a([List__]);
									v_self = tmp4017.shift();
									v_level = tmp4017.shift();
									v_wantarray = tmp4017.shift();
								var List_in = [];
								List_in = p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]);
								var v_fun;
								var v_list;
								(function () {
										if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg')) ) {
										v_fun = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('special_arg'));
									}
									else (function () {
										if ( (p5pkg['Perlito5::AST::Apply'].ref([p5list_slice(List_in, [0], 0)], 0) == 'Perlito5::AST::Block') ) {
										v_fun = (List_in.shift());
									}
									})()
									})();
								(function () {
										if ( (p5pkg['Perlito5::AST::Apply'].ref([v_fun], 0) == 'Perlito5::AST::Block') ) {
										v_fun = (('function (p5want) {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', (v_fun || (v_fun = new p5HashRef({})))._hash_.p5hget('stmts')]), 0)], 0), 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}'));
									}
									else {
										v_fun = ('null');
									}
									})();
								v_list = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in))]), 0));
								return (p5context([('p5sort(' + p5str(p5pkg['Perlito5::Javascript2'].pkg([], 0)) + ', ' + p5str(v_fun) + ', ' + p5str(v_list) + ')')], p5want));
							};
							tmp4016._prototype_ = null;
							return tmp4016
						})(), 'infix:<//>', (function () {
							var tmp4018;
							tmp4018 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4019 = p5list_to_a([List__]);
									v_self = tmp4019.shift();
									v_level = tmp4019.shift();
									v_wantarray = tmp4019.shift();
								return (p5context([('p5defined_or' + '(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [v_level, 'scalar'], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2(p5list_to_a([v_level, v_wantarray, (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(1)]), 0)) + ')')], p5want));
							};
							tmp4018._prototype_ = null;
							return tmp4018
						})(), 'exists', (function () {
							var tmp4020;
							tmp4020 = function (List__, p5want) {
								try {
									var v_self;
									var v_level;
									var v_wantarray;
									var tmp4021 = p5list_to_a([List__]);
									v_self = tmp4021.shift();
									v_level = tmp4021.shift();
									v_wantarray = tmp4021.shift();
									var v_arg;
									v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Lookup'], 0)) ) {
										(function () {
											var v_v;
											v_v = (p5call(v_arg, 'obj', [], 0));
											(function () {
												if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '$')) ) {
												(v_v || (v_v = new p5HashRef({})))._hash_.p5hset('sigil', ('%'));
												throw(p5context([('(' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + ').hasOwnProperty(' + p5str(p5call(p5call(v_arg, 'autoquote', p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
											}
											})();
											throw(p5context([('(' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + ')._hash_.hasOwnProperty(' + p5str(p5call(p5call(v_arg, 'autoquote', p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp')]), 0), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
										})();
									}
									})();
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Index'], 0)) ) {
										(function () {
											var v_v;
											v_v = (p5call(v_arg, 'obj', [], 0));
											(function () {
												if ( (p5bool(p5call(v_v, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_v, 'sigil', [], 0)) == '$')) ) {
												throw(p5context([('(' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + ').hasOwnProperty(' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
											}
											})();
											throw(p5context([('(' + p5str(p5call(v_v, 'emit_javascript2', [], 0)) + ')._array_.hasOwnProperty(' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('index_exp'), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
										})();
									}
									})();
									(function () {
										if ( p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Call'], 0)) ) {
										(function () {
											if ( (p5str(p5call(v_arg, 'method', [], 0)) == 'postcircumfix:<{ }>') ) {
											throw(p5context([('(' + p5str(p5call(p5call(v_arg, 'invocant', [], 0), 'emit_javascript2', [], 0)) + ')._hash_.hasOwnProperty(' + p5str(p5call(p5call('Perlito5::AST::Lookup', 'autoquote', p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('arguments')]), 0), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
										}
										})();
										(function () {
											if ( (p5str(p5call(v_arg, 'method', [], 0)) == 'postcircumfix:<[ ]>') ) {
											throw(p5context([('(' + p5str(p5call(p5call(v_arg, 'invocant', [], 0), 'emit_javascript2', [], 0)) + ')._array_.hasOwnProperty(' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('arguments'), 'emit_javascript2', [v_level], 0)) + ')')], p5want));
										}
										})();
									}
									})();
									(function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_arg, 'sigil', [], 0)) == '&')) ) {
										(function () {
											var v_name;
											v_name = ((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('name'));
											var v_namespace;
											v_namespace = (p5or((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
														return p5make_package('Perlito5')['v_PKG_NAME']
													}));
											throw(p5context([('p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + '].hasOwnProperty(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_name], 0)) + ')')], p5want));
										})();
									}
									})();
									return (function () {
										if ( (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<&>')) ) {
										var v_arg2;
										v_arg2 = ((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
										(function () {
											throw(p5context([('p5sub_exists(' + p5str(p5pkg['Perlito5::Javascript2'].to_str([v_arg2], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')')], p5want))
										})()
									}
									})()
								}
								catch(err) {
									if ( err instanceof Error ) {
										throw(err);
									}
									else {
										return(err);
									}
								}
							};
							tmp4020._prototype_ = null;
							return tmp4020
						})(), 'prototype', (function () {
							var tmp4022;
							tmp4022 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4023 = p5list_to_a([List__]);
									v_self = tmp4023.shift();
									v_level = tmp4023.shift();
									v_wantarray = tmp4023.shift();
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								return (p5context([('p5sub_prototype(' + p5str(p5call(v_arg, 'emit_javascript2', [], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')')], p5want));
							};
							tmp4022._prototype_ = null;
							return tmp4022
						})(), 'split', (function () {
							var tmp4024;
							tmp4024 = function (List__, p5want) {
								var v_self;
								var v_level;
								var v_wantarray;
								var tmp4025 = p5list_to_a([List__]);
									v_self = tmp4025.shift();
									v_level = tmp4025.shift();
									v_wantarray = tmp4025.shift();
								var List_js = [];
								var v_arg;
								v_arg = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0));
								(function () {
										if ( (p5bool(v_arg) && (p5bool(p5call(v_arg, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')) == 'p5:m'))) ) {
										List_js.p5push([('new RegExp(' + p5str(p5call((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'emit_javascript2', [], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(1)._hash_.p5hget('buf')]), 0)) + ')')]);
										p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply').shift();
									}
									})();
								return (p5context([('CORE.split(' + '[' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([List_js, p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + '], ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
							};
							tmp4024._prototype_ = null;
							return tmp4024
						})()]);
				p5typeglob_set('Perlito5::AST::Apply', 'emit_javascript2', (function () {
					var tmp4026;
					tmp4026 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4027 = p5list_to_a([List__]);
							v_self = tmp4027.shift();
							v_level = tmp4027.shift();
							v_wantarray = tmp4027.shift();
							var v_apply;
							v_apply = (p5call(v_self, 'op_assign', [], 0));
							(function () {
								if ( p5bool(v_apply) ) {
								throw(p5call(v_apply, 'emit_javascript2', [v_level], p5want));
							}
							})();
							var v_apply;
							v_apply = (p5call(v_self, 'op_auto', [], 0));
							(function () {
								if ( p5bool(v_apply) ) {
								throw(p5call(v_apply, 'emit_javascript2', [v_level], p5want));
							}
							})();
							var v_code;
							v_code = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
							(function () {
								if ( (p5pkg['Perlito5::AST::Apply'].ref([v_code], 0) != '') ) {
								(function () {
									var List_args = [];
									List_args = [];
									p5for(p5make_package('main'), "v__", function () {
											List_args.p5push(p5list_to_a([p5call(p5make_package('main')['v__'], 'emit_javascript2', [], 1)]));
										}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]), false, '');
									throw(p5context([('(' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'), 'emit_javascript2', [v_level], 0)) + ')(' + p5pkg['Perlito5::AST::Apply'].join([','].concat(p5list_to_a([List_args])), 0) + ')')], p5want));
								})();
							}
							})();
							p5and((Hash_emit_js).hasOwnProperty(v_code), function () {
								throw((Hash_emit_js.p5hget(p5str(v_code)))([v_self, v_level, v_wantarray], p5want))
							});
							(function () {
								if ( (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_str']).hasOwnProperty(v_code) ) {
								throw(p5context([('(' + p5pkg['Perlito5::AST::Apply'].join([p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_str'].p5hget(p5str(v_code))].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_str([p5make_package('main')['v__'], v_level], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_num']).hasOwnProperty(v_code) ) {
								throw(p5context([('(' + p5pkg['Perlito5::AST::Apply'].join([p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] || (p5make_package('Perlito5::Javascript2')['Hash_op_infix_js_num'] = {}), 'Perlito5::Javascript2']['Hash_op_infix_js_num'].p5hget(p5str(v_code))].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5pkg['Perlito5::Javascript2'].to_num([p5make_package('main')['v__'], v_level], 1));
	}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))])), 0) + ')')], p5want));
							}
							})();
							(function () {
								if ( (p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_prefix_js_str']).hasOwnProperty(v_code) ) {
								throw(p5context([(p5str(p5pkg[p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] || (p5make_package('Perlito5::Javascript2')['Hash_op_prefix_js_str'] = {}), 'Perlito5::Javascript2']['Hash_op_prefix_js_str'].p5hget(p5str(v_code))) + '(' + p5str(p5pkg['Perlito5::Javascript2'].to_str(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0)]), 0)) + ')')], p5want));
							}
							})();
							(function () {
								if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) ) {
								(function () {
									if ( ((p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) == 'JS') && (p5str(v_code) == 'inline')) ) {
									(function () {
										if ( p5bool(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), 'isa', ['Perlito5::AST::Buf'], 0)) ) {
										throw((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget_hash(0)._hash_.p5hget('buf'));
									}
									else {
										p5pkg['Perlito5::AST::Apply'].die([].concat(['JS::inline needs a string constant']), null);
									}
									})();
								}
								})();
								v_code = (('p5pkg[' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')]), 0)) + '].' + p5str(v_code)));
							}
							else {
								v_code = ((p5str(p5pkg['Perlito5::Javascript2'].pkg([], 0)) + '.' + p5str(v_code)));
							}
							})();
							var v_sig;
							var v_may_need_autoload;
							p5block(function (v) {}, function () {
									var v_name;
									v_name = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
									var v_namespace;
									v_namespace = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
												return p5make_package('Perlito5')['v_PKG_NAME']
											}));
									var v_effective_name;
									v_effective_name = ((p5str(v_namespace) + '::' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'))));
									(function () {
										if ( (p5make_package('Perlito5')['v_PROTO'])._hash_.hasOwnProperty(v_effective_name) ) {
										v_sig = ((p5make_package('Perlito5')['v_PROTO'] || (p5make_package('Perlito5')['v_PROTO'] = new p5HashRef({})))._hash_.p5hget(p5str(v_effective_name)));
									}
									else (function () {
										if ( ((!( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace'))) || (p5str(v_namespace) == 'CORE')) && (p5make_package('Perlito5')['v_CORE_PROTO'])._hash_.hasOwnProperty(('CORE::' + p5str(v_name)))) ) {
										v_effective_name = (('CORE::' + p5str(v_name)));
										v_sig = ((p5make_package('Perlito5')['v_CORE_PROTO'] || (p5make_package('Perlito5')['v_CORE_PROTO'] = new p5HashRef({})))._hash_.p5hget(p5str(v_effective_name)));
									}
									else {
										(function () {
											if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('bareword')) ) {
											(function () {
												if ( p5bool(p5make_package('Perlito5')['v_STRICT']) ) {
												p5pkg['Perlito5::AST::Apply'].die([].concat([('Bareword ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_name], 0)) + ' not allowed while "strict subs" in use')]), null);
											}
											})();
											throw(p5pkg['Perlito5::Javascript2'].escape_string([(p5str(( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) ? (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')) + '::') : '')) + p5str(v_name))], p5want));
										}
										})();
										v_may_need_autoload = (1);
									}
									})()
									})();
									p5and(p5context([(v_self)._hash_.hasOwnProperty('proto')], 0), function () {
										return v_sig = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('proto'))
									});
								}, [0], false, ''
							);
							(function () {
								if ( p5bool(v_sig) ) {
								(function () {
									var List_out = [];
									List_out = [];
									var List_in = [];
									List_in = p5list_to_a([p5array_deref(p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), function () {
												return (new p5ArrayRef([]))
											}), 'Perlito5::AST::Apply')]);
									var v_close;
									v_close = (']');
									var v_optional;
									v_optional = (0);
									(function () {
										p5while(function () {
											var v_c;
											v_c = (p5str(v_sig).substr(0, 1));
											(function () {
												if ( (p5str(v_c) == ';') ) {
												v_optional = (1);
											}
											else (function () {
												if ( ((p5str(v_c) == '$') || (p5str(v_c) == '_')) ) {
												p5and(p5or(List_in.length, function () {
													return !( p5bool(v_optional))
												}), function () {
													return List_out.p5push(p5list_to_a([p5call(List_in.shift(), 'emit_javascript2', [(p5num(v_level) + 1), 'scalar'], 1)]))
												});
											}
											else (function () {
												if ( (p5str(v_c) == '+') ) {
												(function () {
													if ( (p5bool(List_in.length) || !( p5bool(v_optional))) ) {
													(function () {
														var v_in;
														v_in = (List_in.shift());
														(function () {
															if ( ((p5bool(p5call(v_in, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_in || (v_in = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<@>')) || ((p5bool(p5call(v_in, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_in, 'sigil', [], 0)) == '@')) || ((p5bool(p5call(v_in, 'isa', ['Perlito5::AST::Apply'], 0)) && (p5str((v_in || (v_in = new p5HashRef({})))._hash_.p5hget('code')) == 'prefix:<%>')) || (p5bool(p5call(v_in, 'isa', ['Perlito5::AST::Var'], 0)) && (p5str(p5call(v_in, 'sigil', [], 0)) == '%'))))) ) {
															List_out.p5push(p5list_to_a([p5call(v_in, 'emit_javascript2', [(p5num(v_level) + 1), 'list'], 1)]));
														}
														else {
															List_out.p5push(p5list_to_a([p5call(v_in, 'emit_javascript2', [(p5num(v_level) + 1), 'scalar'], 1)]));
														}
														})();
													})();
												}
												})();
											}
											else (function () {
												if ( (p5str(v_c) == '@') ) {
												p5and(p5or(List_in.length, function () {
													return !( p5bool(v_optional))
												}), function () {
													return v_close = (('].concat(' + p5str(p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(List_in)), (p5num(v_level) + 1)]), 0)) + ')'))
												});
												List_in = [];
											}
											else (function () {
												if ( (p5str(v_c) == '&') ) {
												List_out.p5push(p5list_to_a([p5call(List_in.shift(), 'emit_javascript2', [(p5num(v_level) + 1), 'scalar'], 1)]));
											}
											else (function () {
												if ( (p5str(v_c) == '*') ) {
												(function () {
													if ( (p5bool(List_in.length) || !( p5bool(v_optional))) ) {
													(function () {
														var v_arg;
														v_arg = (List_in.shift());
														(function () {
															if ( p5bool((v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('bareword')) ) {
															List_out.p5push(p5list_to_a([p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_arg || (v_arg = new p5HashRef({})))._hash_.p5hget('code')]), 1)]));
														}
														else {
															List_out.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2', [(p5num(v_level) + 1), 'scalar'], 1)]));
														}
														})();
													})();
												}
												})();
											}
											else (function () {
												if ( (p5str(v_c) == String.fromCharCode(92)) ) {
												(function () {
													if ( (p5str(v_sig).substr(0, 2) == String.fromCharCode(92) + '$') ) {
													v_sig = (CORE.substr([v_sig, 1], 0));
													p5and(p5or(List_in.length, function () {
														return !( p5bool(v_optional))
													}), function () {
														return List_out.p5push(p5list_to_a([p5call(List_in.shift(), 'emit_javascript2', [(p5num(v_level) + 1), 'scalar'], 1)]))
													});
												}
												else (function () {
													if ( ((p5str(v_sig).substr(0, 2) == String.fromCharCode(92) + '@') || (p5str(v_sig).substr(0, 2) == String.fromCharCode(92) + '%')) ) {
													v_sig = (CORE.substr([v_sig, 1], 0));
													p5and(p5or(List_in.length, function () {
														return !( p5bool(v_optional))
													}), function () {
														return List_out.p5push(p5list_to_a([p5call(List_in.shift(), 'emit_javascript2', [(p5num(v_level) + 1), 'list'], 1)]))
													});
												}
												else (function () {
													if ( (p5str(v_sig).substr(0, 5) == String.fromCharCode(92) + '[@%]') ) {
													v_sig = (CORE.substr([v_sig, 4], 0));
													p5and(p5or(List_in.length, function () {
														return !( p5bool(v_optional))
													}), function () {
														return List_out.p5push(p5list_to_a([p5call(List_in.shift(), 'emit_javascript2', [(p5num(v_level) + 1), 'list'], 1)]))
													});
												}
												else (function () {
													if ( (p5str(v_sig).substr(0, 6) == String.fromCharCode(92) + '[$@%]') ) {
													v_sig = (CORE.substr([v_sig, 5], 0));
													p5and(p5or(List_in.length, function () {
														return !( p5bool(v_optional))
													}), function () {
														return List_out.p5push(p5list_to_a([p5call(List_in.shift(), 'emit_javascript2', [(p5num(v_level) + 1), 'list'], 1)]))
													});
												}
												})()
												})()
												})()
												})();
											}
											})()
											})()
											})()
											})()
											})()
											})()
											})();
											v_sig = (CORE.substr([v_sig, 1], 0));
										}, function () {
											return p5pkg['Perlito5::AST::Apply'].length([v_sig], 0)
										}, false, '', 0)
									})();
									throw(p5context([(p5str(v_code) + '([' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([List_out])), 0) + p5str(v_close) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								})();
							}
							})();
							var v_arg_list;
							v_arg_list = (p5pkg['Perlito5::Javascript2'].to_list_preprocess(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments')]), 0));
							var v_arg_code;
							v_arg_code = (( (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) == 'scalar') ? ('[' + p5pkg['Perlito5::AST::Apply'].join([', '].concat(p5list_to_a([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
		return (p5call(p5make_package('main')['v__'], 'emit_javascript2', [v_level], 1));
	}, p5list_to_a([p5array_deref((v_arg_list || (v_arg_list = new p5ArrayRef([]))), 'Perlito5::AST::Apply')]))])), 0) + ']') : p5pkg['Perlito5::Javascript2'].to_list([v_arg_list], 0)));
							(function () {
								if ( p5bool(v_may_need_autoload) ) {
								(function () {
									var v_name;
									v_name = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
									var v_namespace;
									v_namespace = (p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
												return p5make_package('Perlito5')['v_PKG_NAME']
											}));
									throw(p5context([('p5call_sub(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_name], 0)) + ', ' + p5str(v_arg_code) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
								})();
							}
							})();
							return (p5context([(p5str(v_code) + '(' + p5str(v_arg_code) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].to_context([v_wantarray], 0)) + ')')], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4026._prototype_ = null;
					return tmp4026
				})());
				p5typeglob_set('Perlito5::AST::Apply', 'emit_javascript2_set_list', (function () {
					var tmp4028;
					tmp4028 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_list;
							var tmp4029 = p5list_to_a([List__]);
							v_self = tmp4029.shift();
							v_level = tmp4029.shift();
							v_list = tmp4029.shift();
							(function () {
								if ( (p5str(p5call(v_self, 'code', [], 0)) == 'undef') ) {
								throw(p5context([(p5str(v_list) + '.shift()')], p5want));
							}
							})();
							(function () {
								if ( (p5str(p5call(v_self, 'code', [], 0)) == 'prefix:<$>') ) {
								throw(p5context([('p5scalar_deref_set(' + p5str(p5pkg['Perlito5::Javascript2'].emit_javascript2_autovivify(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments')._array_.p5aget(0), (p5num(v_level) + 1), 'scalar']), 0)) + ', ' + p5str(v_list) + '.shift()' + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([p5make_package('Perlito5')['v_PKG_NAME']], 0)) + ')')], p5want));
							}
							})();
							return (p5pkg['Perlito5::AST::Apply'].die([].concat(p5list_to_a(['not implemented: assign to ', p5call(v_self, 'code', [], 1)])), p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4028._prototype_ = null;
					return tmp4028
				})());
				p5typeglob_set('Perlito5::AST::Apply', 'emit_javascript2_get_decl', (function () {
					var tmp4030;
					tmp4030 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.shift());
							var v_code;
							v_code = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
							(function () {
								if ( ((p5str(v_code) == 'my') || ((p5str(v_code) == 'our') || ((p5str(v_code) == 'state') || (p5str(v_code) == 'local')))) ) {
								throw(p5context([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
										return (( (p5pkg['Perlito5::AST::Apply'].ref([p5make_package('main')['v__']], 0) == 'Perlito5::AST::Var') ? p5call('Perlito5::AST::Decl', 'new', ['decl', v_code, 'type', '', 'var', p5make_package('main')['v__']], p5want) : p5context([], p5want)));
									}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))], p5want));
							}
							})();
							(function () {
								if ( ((p5str(v_code) != 'do') && (p5str(v_code) != 'eval')) ) {
								p5and((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('arguments'), function () {
									throw(p5context([p5map(p5pkg['Perlito5::AST::Apply'], function (p5want) {
										return ((p5context([p5call(p5make_package('main')['v__'], 'emit_javascript2_get_decl', [], p5want)], p5want)));
									}, p5list_to_a([p5array_deref((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('arguments'), 'Perlito5::AST::Apply')]))], p5want))
								});
							}
							})();
							return (p5context([], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4030._prototype_ = null;
					return tmp4030
				})());
				p5typeglob_set('Perlito5::AST::Apply', 'emit_javascript2_has_regex', (function () {
					var tmp4031;
					tmp4031 = function (List__, p5want) {
						try {
							var v_self;
							v_self = (List__.shift());
							var v_code;
							v_code = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code'));
							(function () {
								if ( ((p5str(v_code) == 'p5:m') || ((p5str(v_code) == 'p5:s') || ((p5str(v_code) == 'infix:<=~>') || (p5str(v_code) == 'infix:<!~>')))) ) {
								throw(p5context([1], p5want));
							}
							})();
							return (p5context([], p5want));
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4031._prototype_ = null;
					return tmp4031
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::If');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::If', 'emit_javascript2', (function () {
					var tmp4032;
					tmp4032 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4033 = p5list_to_a([List__]);
							v_self = tmp4033.shift();
							v_level = tmp4033.shift();
							v_wantarray = tmp4033.shift();
							var v_cond;
							v_cond = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'));
							var List_str = [];
							var v_old_level;
							v_old_level = (v_level);
							(function () {
								if ( p5bool(v_cond) ) {
								(function () {
									var List_var_decl = [];
									List_var_decl = p5list_to_a([p5call(v_cond, 'emit_javascript2_get_decl', [], 1)]);
									(function () {
										var v_arg;
										(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
												v_level = ((p5num(v_old_level) + 1));
												List_str.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2_init', [v_level, v_wantarray], 1)]));
											}, p5list_to_a([List_var_decl]), false, '') })()
									})();
								})();
							}
							})();
							var v_body;
							v_body = (( (p5pkg['Perlito5::AST::If'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block') ? (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body') : ( !( p5bool(p5num(p5array_deref(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], p5want), 'Perlito5::AST::If')))) ? null : ( (p5str(v_wantarray) != 'void') ? p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1)]), 0) : p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1), 'create_context', 1]), 0)))));
							var v_otherwise;
							v_otherwise = (( (p5pkg['Perlito5::AST::If'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise')], 0) != 'Perlito5::AST::Block') ? (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise') : ( !( p5bool(p5num(p5array_deref(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise'), 'stmts', [], p5want), 'Perlito5::AST::If')))) ? null : ( (p5str(v_wantarray) != 'void') ? p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise'), 'stmts', [], 1)]), 0) : p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('otherwise'), 'stmts', [], 1), 'create_context', 1]), 0)))));
							var v_s;
							v_s = (('if ( ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool([v_cond, (p5num(v_level) + 1)], 0)) + ' ) {'));
							(function () {
								if ( p5bool(v_body) ) {
								v_s = ((p5str(v_s) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + p5str(p5call(v_body, 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}'));
							}
							else {
								v_s = ((p5str(v_s) + '}'));
							}
							})();
							(function () {
								if ( p5bool(v_otherwise) ) {
								(function () {
									if ( ((p5num(p5num(p5array_deref((v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::AST::If'))) == 1) && (p5pkg['Perlito5::AST::If'].ref([(v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('block')._array_.p5aget(0)], 0) == 'Perlito5::AST::If')) ) {
									v_s = ((p5str(v_s) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + 'else ' + p5str(p5call((v_otherwise || (v_otherwise = new p5HashRef({})))._hash_.p5hget_array('block')._array_.p5aget(0), 'emit_javascript2', [v_level, v_wantarray], 0))));
								}
								else {
									v_s = ((p5str(v_s) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + 'else {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + p5str(p5call(v_otherwise, 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}'));
								}
								})();
							}
							})();
							List_str.p5push([v_s]);
							return (function () {
								if ( p5bool(List_str.length) ) {
								v_level = (v_old_level);
								(function () {
									throw(p5context([(p5str(( (p5str(v_wantarray) != 'void') ? 'return ' : '')) + p5str(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, List_str]), 0)))], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([p5pkg['Perlito5::AST::If'].join([(String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat(p5list_to_a([List_str])), p5want)], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4032._prototype_ = null;
					return tmp4032
				})());
				p5typeglob_set('Perlito5::AST::If', 'emit_javascript2_get_decl', (function () {
					var tmp4034;
					tmp4034 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4034._prototype_ = null;
					return tmp4034
				})());
				p5typeglob_set('Perlito5::AST::If', 'emit_javascript2_has_regex', (function () {
					var tmp4035;
					tmp4035 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4035._prototype_ = null;
					return tmp4035
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::When');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::When', 'emit_javascript2', (function () {
					var tmp4036;
					tmp4036 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4037 = p5list_to_a([List__]);
							v_self = tmp4037.shift();
							v_level = tmp4037.shift();
							v_wantarray = tmp4037.shift();
							var v_cond;
							v_cond = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'));
							var List_str = [];
							var v_old_level;
							v_old_level = (v_level);
							(function () {
								if ( p5bool(v_cond) ) {
								(function () {
									var List_var_decl = [];
									List_var_decl = p5list_to_a([p5call(v_cond, 'emit_javascript2_get_decl', [], 1)]);
									(function () {
										var v_arg;
										(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
												v_level = ((p5num(v_old_level) + 1));
												List_str.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2_init', [v_level, v_wantarray], 1)]));
											}, p5list_to_a([List_var_decl]), false, '') })()
									})();
								})();
							}
							})();
							v_cond = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['arguments', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Var', 'new', ['name', '_', 'namespace', 'main', 'sigil', '$'], 1), v_cond]))), 'code', 'infix:<~~>', 'namespace', '']), 0));
							var v_next;
							v_next = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['arguments', (new p5ArrayRef([])), 'bareword', 1, 'code', 'next', 'namespace', '']), 0));
							var v_body;
							v_body = (( (p5pkg['Perlito5::AST::When'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block') ? p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', (new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')])))]), 0) : ( !( p5bool(p5num(p5array_deref(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], p5want), 'Perlito5::AST::When')))) ? null : ( (p5str(v_wantarray) != 'void') ? p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1)]), 0) : p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'stmts', [], 1), 'create_context', 1]), 0)))));
							p5array_deref((v_body || (v_body = new p5HashRef({})))._hash_.p5hget_array('block'), 'Perlito5::AST::When').p5push([v_next]);
							var v_s;
							v_s = (('if ( ' + p5str(p5pkg['Perlito5::Javascript2'].to_bool([v_cond, (p5num(v_level) + 1)], 0)) + ' ) {'));
							(function () {
								if ( p5bool(v_body) ) {
								v_s = ((p5str(v_s) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + p5str(p5call(v_body, 'emit_javascript2', [(p5num(v_level) + 1), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)) + '}'));
							}
							else {
								v_s = ((p5str(v_s) + '}'));
							}
							})();
							List_str.p5push([v_s]);
							return (function () {
								if ( p5bool(List_str.length) ) {
								v_level = (v_old_level);
								(function () {
									throw(p5context([(p5str(( (p5str(v_wantarray) != 'void') ? 'return ' : '')) + p5str(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, List_str]), 0)))], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([p5pkg['Perlito5::AST::When'].join([(String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat(p5list_to_a([List_str])), p5want)], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4036._prototype_ = null;
					return tmp4036
				})());
				p5typeglob_set('Perlito5::AST::When', 'emit_javascript2_get_decl', (function () {
					var tmp4038;
					tmp4038 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4038._prototype_ = null;
					return tmp4038
				})());
				p5typeglob_set('Perlito5::AST::When', 'emit_javascript2_has_regex', (function () {
					var tmp4039;
					tmp4039 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4039._prototype_ = null;
					return tmp4039
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::While');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::While', 'emit_javascript2', (function () {
					var tmp4040;
					tmp4040 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4041 = p5list_to_a([List__]);
							v_self = tmp4041.shift();
							v_level = tmp4041.shift();
							v_wantarray = tmp4041.shift();
							var v_cond;
							v_cond = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond'));
							var List_str = [];
							var v_old_level;
							v_old_level = (v_level);
							(function () {
								if ( p5bool(v_cond) ) {
								(function () {
									var List_var_decl = [];
									List_var_decl = p5list_to_a([p5call(v_cond, 'emit_javascript2_get_decl', [], 1)]);
									(function () {
										var v_arg;
										(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
												v_level = ((p5num(v_old_level) + 1));
												List_str.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2_init', [v_level, v_wantarray], 1)]));
											}, p5list_to_a([List_var_decl]), false, '') })()
									})();
								})();
							}
							})();
							(function () {
								if ( ((p5pkg['Perlito5::AST::While'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) == 'Perlito5::AST::Apply') && (p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('body')._hash_.p5hget('code')) == 'do')) ) {
								List_str.p5push([('do {' + p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body'), 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '} while (' + p5str(p5pkg['Perlito5::Javascript2'].to_bool([v_cond, (p5num(v_level) + 2)], 0)) + ')')]);
							}
							else {
								(function () {
									var v_body;
									v_body = (( (p5pkg['Perlito5::AST::While'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block') ? (new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')]))) : (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('body')._hash_.p5hget('stmts')));
									List_str.p5push([('p5while(' + 'function () {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_body], 0)], 0), 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}, ' + p5str(p5pkg['Perlito5::Javascript2'].emit_function_javascript2([(p5num(v_level) + 1), 'scalar', v_cond], 0)) + ', ' + p5str(p5pkg['Perlito5::AST::Block'].emit_javascript2_continue([v_self, v_level, v_wantarray], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
	return ''
})]), 0)) + ', ' + '0' + ')')]);
								})();
							}
							})();
							return (function () {
								if ( p5bool(List_str.length) ) {
								v_level = (v_old_level);
								(function () {
									throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, List_str]), p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([p5pkg['Perlito5::AST::While'].join([(String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat(p5list_to_a([List_str])), p5want)], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4040._prototype_ = null;
					return tmp4040
				})());
				p5typeglob_set('Perlito5::AST::While', 'emit_javascript2_get_decl', (function () {
					var tmp4042;
					tmp4042 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4042._prototype_ = null;
					return tmp4042
				})());
				p5typeglob_set('Perlito5::AST::While', 'emit_javascript2_has_regex', (function () {
					var tmp4043;
					tmp4043 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4043._prototype_ = null;
					return tmp4043
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::For');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::For', 'emit_javascript2', (function () {
					var tmp4044;
					tmp4044 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4045 = p5list_to_a([List__]);
							v_self = tmp4045.shift();
							v_level = tmp4045.shift();
							v_wantarray = tmp4045.shift();
							var v_body;
							v_body = (( (p5pkg['Perlito5::AST::For'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')], 0) != 'Perlito5::AST::Block') ? (new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('body')]))) : (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('body')._hash_.p5hget('stmts')));
							var List_str = [];
							var v_old_level;
							v_old_level = (v_level);
							var v_cond;
							v_cond = (( (p5pkg['Perlito5::AST::For'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond')], 0) == 'ARRAY') ? (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond') : (new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond')])))));
							(function () {
								var v_expr;
								(function(){ var v_expr; p5for_lex(function (v) { v_expr = v }, function () {
										(function () {
											if ( p5bool(v_expr) ) {
											(function () {
												var List_var_decl = [];
												List_var_decl = p5list_to_a([p5call(v_expr, 'emit_javascript2_get_decl', [], 1)]);
												(function () {
													var v_arg;
													(function(){ var v_arg; p5for_lex(function (v) { v_arg = v }, function () {
															v_level = ((p5num(v_old_level) + 1));
															List_str.p5push(p5list_to_a([p5call(v_arg, 'emit_javascript2_init', [v_level, v_wantarray], 1)]));
														}, p5list_to_a([List_var_decl]), false, '') })()
												})();
											})();
										}
										})();
									}, p5list_to_a([p5array_deref((v_cond || (v_cond = new p5ArrayRef([]))), 'Perlito5::AST::For'), (v_self || (v_self = new p5HashRef({})))._hash_.p5hget('topic')]), false, '') })()
							})();
							(function () {
								if ( (p5pkg['Perlito5::AST::For'].ref([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond')], 0) == 'ARRAY') ) {
								List_str.p5push(p5list_to_a([p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, ('var label = ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
	return ''
})]), 0)) + ';'), ('for ( ' + p5str(( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(0)) ? (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(0), 'emit_javascript2', [(p5num(v_level) + 1)], 0)) + '; ') : '; ')) + p5str(( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(1)) ? (p5str(p5pkg['Perlito5::Javascript2'].to_bool(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(1), (p5num(v_level) + 1)]), 0)) + '; ') : '; ')) + p5str(( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(2)) ? (p5str(p5call((v_self || (v_self = new p5HashRef({})))._hash_.p5hget_array('cond')._array_.p5aget(2), 'emit_javascript2', [(p5num(v_level) + 1)], 0)) + ' ') : '')) + ') {'), (new p5ArrayRef(p5list_to_a(['var _redo;', 'do {', (new p5ArrayRef(p5list_to_a(['_redo = false;', 'try {', (new p5ArrayRef(p5list_to_a([p5call(p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_body], 0), 'emit_javascript2', [(p5num(v_level) + 4), v_wantarray], 1)]))), '}', 'catch(err) {', (new p5ArrayRef(p5list_to_a(['if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {', (new p5ArrayRef(['if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') { return }', 'else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }', 'else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }'])), '}', 'else {', (new p5ArrayRef(['throw(err)'])), '}']))), '}']))), '} while (_redo);']))), '}']), 1)]));
							}
							else {
								(function () {
									var v_cond;
									v_cond = (p5pkg['Perlito5::Javascript2'].to_list(p5list_to_a([(new p5ArrayRef(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('cond')]))), (p5num(v_level) + 1)]), 0));
									var v_topic;
									v_topic = ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('topic'));
									var v_decl;
									v_decl = ('');
									var v_v;
									v_v = (v_topic);
									(function () {
										if ( p5bool((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('decl')) ) {
										v_decl = ((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('decl'));
										v_v = ((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('var'));
									}
									else {
										v_decl = (p5or((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('_decl'), function () {
													return 'global'
												}));
									}
									})();
									var v_namespace;
									v_namespace = (p5or((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('namespace'), function () {
												return p5or((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('_namespace'), function () {
													return p5make_package('Perlito5')['v_PKG_NAME']
												})
											}));
									var v_s;
									(function () {
										if ( ((p5str(v_decl) == 'my') || (p5str(v_decl) == 'state')) ) {
										(function () {
											var v_sig;
											v_sig = (p5call(v_v, 'emit_javascript2', [(p5num(v_level) + 1)], 0));
											List_str.p5push([('(function(){ ' + ('var ' + p5str(v_sig) + '; ') + 'p5for_lex(' + ('function (v) { ' + p5str(v_sig) + ' = v }, ') + 'function () {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_body], 0)], 0), 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}, ' + p5str(v_cond) + ', ' + p5str(p5pkg['Perlito5::AST::Block'].emit_javascript2_continue([v_self, v_level, v_wantarray], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
	return ''
})]), 0)) + ') ' + '})()')]);
										})();
									}
									else {
										List_str.p5push([('p5for(' + 'p5make_package(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string([v_namespace], 0)) + '), ' + '"v_' + p5str((v_v || (v_v = new p5HashRef({})))._hash_.p5hget('name')) + '", ' + 'function () {' + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 2)], 0)) + p5str(p5call(p5context([p5call('Perlito5::Javascript2::LexicalBlock', 'new', ['block', v_body], 0)], 0), 'emit_javascript2', [(p5num(v_level) + 2), v_wantarray], 0)) + String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([(p5num(v_level) + 1)], 0)) + '}, ' + p5str(v_cond) + ', ' + p5str(p5pkg['Perlito5::AST::Block'].emit_javascript2_continue([v_self, v_level, v_wantarray], 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([p5or((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('label'), function () {
	return ''
})]), 0)) + ')')]);
									}
									})();
								})();
							}
							})();
							return (function () {
								if ( (p5num(List_str.length) > 1) ) {
								v_level = (v_old_level);
								(function () {
									throw(p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, v_wantarray, List_str]), p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([p5pkg['Perlito5::AST::For'].join([(String.fromCharCode(10) + p5str(p5pkg['Perlito5::Javascript2'].tab([v_level], 0)))].concat(p5list_to_a([List_str])), p5want)], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4044._prototype_ = null;
					return tmp4044
				})());
				p5typeglob_set('Perlito5::AST::For', 'emit_javascript2_get_decl', (function () {
					var tmp4046;
					tmp4046 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4046._prototype_ = null;
					return tmp4046
				})());
				p5typeglob_set('Perlito5::AST::For', 'emit_javascript2_has_regex', (function () {
					var tmp4047;
					tmp4047 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4047._prototype_ = null;
					return tmp4047
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Sub');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Sub', 'emit_javascript2', (function () {
					var tmp4048;
					tmp4048 = function (List__, p5want) {
						try {
							var local_idx = p5LOCAL.length;
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4049 = p5list_to_a([List__]);
							v_self = tmp4049.shift();
							v_level = tmp4049.shift();
							v_wantarray = tmp4049.shift();
							var v_prototype;
							v_prototype = (( ((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sig') != null) ? p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('sig')]), 0) : 'null'));
							var v_sub_ref;
							v_sub_ref = (p5pkg['Perlito5::Javascript2'].get_label([], 0));
							(function () {
								var v_tmp4050 = p5make_package('Perlito5::AST::Sub')['v_SUB_REF'];
								p5LOCAL.push(function(){ p5make_package('Perlito5::AST::Sub')['v_SUB_REF'] = v_tmp4050 });
								return (p5make_package('Perlito5::AST::Sub')['v_SUB_REF'] = (null));
							})();
							p5make_package('Perlito5::AST::Sub')['v_SUB_REF'] = (v_sub_ref);
							var v_js_block;
							v_js_block = (p5call(p5call('Perlito5::Javascript2::LexicalBlock', 'new', p5list_to_a(['block', (v_self || (v_self = new p5HashRef({})))._hash_.p5hget_hash('block')._hash_.p5hget('stmts')]), 0), 'emit_javascript2_subroutine_body', [(p5num(v_level) + 2), 'runtime'], 0));
							var v_s;
							v_s = (p5pkg['Perlito5::Javascript2'].emit_wrap_javascript2(p5list_to_a([v_level, 'scalar', ('var ' + p5str(v_sub_ref) + ';'), (p5str(v_sub_ref) + ' = function (List__, p5want) {'), (new p5ArrayRef([v_js_block])), '};', (p5str(v_sub_ref) + '._prototype_ = ' + p5str(v_prototype) + ';'), ('return ' + p5str(v_sub_ref))]), 0));
							return (function () {
								if ( p5bool((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')) ) {
								(function () {
									throw(p5context([('p5typeglob_set(' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('namespace')]), 0)) + ', ' + p5str(p5pkg['Perlito5::Javascript2'].escape_string(p5list_to_a([(v_self || (v_self = new p5HashRef({})))._hash_.p5hget('name')]), 0)) + ', ' + p5str(v_s) + ')')], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([v_s], p5want))
								})()
							}
							})()
							p5cleanup_local(local_idx, null);
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return p5cleanup_local(local_idx, err);
							}
						}
					};
					tmp4048._prototype_ = null;
					return tmp4048
				})());
				p5typeglob_set('Perlito5::AST::Sub', 'emit_javascript2_get_decl', (function () {
					var tmp4051;
					tmp4051 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4051._prototype_ = null;
					return tmp4051
				})());
				p5typeglob_set('Perlito5::AST::Sub', 'emit_javascript2_has_regex', (function () {
					var tmp4052;
					tmp4052 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4052._prototype_ = null;
					return tmp4052
				})());
			}, [0], false, ''
		);
		p5make_package('Perlito5::AST::Use');
		p5block(function (v) {}, function () {
				p5typeglob_set('Perlito5::AST::Use', 'emit_javascript2', (function () {
					var tmp4053;
					tmp4053 = function (List__, p5want) {
						try {
							var v_self;
							var v_level;
							var v_wantarray;
							var tmp4054 = p5list_to_a([List__]);
							v_self = tmp4054.shift();
							v_level = tmp4054.shift();
							v_wantarray = tmp4054.shift();
							p5call_sub('Perlito5::Grammar::Use', 'emit_time_eval', [v_self], null);
							return (function () {
								if ( (p5str(v_wantarray) != 'void') ) {
								(function () {
									throw(p5context(['p5context([], p5want)'], p5want))
								})()
							}
							else {
								(function () {
									throw(p5context([('// ' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('code')) + ' ' + p5str((v_self || (v_self = new p5HashRef({})))._hash_.p5hget('mod')) + String.fromCharCode(10))], p5want))
								})()
							}
							})()
						}
						catch(err) {
							if ( err instanceof Error ) {
								throw(err);
							}
							else {
								return(err);
							}
						}
					};
					tmp4053._prototype_ = null;
					return tmp4053
				})());
				p5typeglob_set('Perlito5::AST::Use', 'emit_javascript2_get_decl', (function () {
					var tmp4055;
					tmp4055 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4055._prototype_ = null;
					return tmp4055
				})());
				p5typeglob_set('Perlito5::AST::Use', 'emit_javascript2_has_regex', (function () {
					var tmp4056;
					tmp4056 = function (List__, p5want) {
						return (p5context([], p5want));
					};
					tmp4056._prototype_ = null;
					return tmp4056
				})());
			}, [0], false, ''
		);
		1;
	})();
	// use Perlito5::Javascript2::Emitter
;
	(function () {
		null;
		p5make_package('Perlito5::Javascript2::Runtime');
		p5typeglob_set('Perlito5::Javascript2::Runtime', 'perl5_to_js', (function () {
			var tmp4057;
			tmp4057 = function (List__, p5want) {
				var local_idx = p5LOCAL.length;
				var v_source;
				var v_namespace;
				var v_want;
				var v_scope_js;
				var tmp4058 = p5list_to_a([List__]);
					v_source = tmp4058.shift();
					v_namespace = tmp4058.shift();
					v_want = tmp4058.shift();
					v_scope_js = tmp4058.shift();
				var v_strict_old;
				v_strict_old = (p5make_package('Perlito5')['v_STRICT']);
				(function () {
						var v_tmp4059 = p5make_package('Perlito5')['v_BASE_SCOPE'];
						p5LOCAL.push(function(){ p5make_package('Perlito5')['v_BASE_SCOPE'] = v_tmp4059 });
						return (p5make_package('Perlito5')['v_BASE_SCOPE'] = (null));
					})();
				p5make_package('Perlito5')['v_BASE_SCOPE'] = ((v_scope_js || (v_scope_js = new p5ArrayRef([])))._array_.p5aget(0));
				(function () {
						var v_tmp4060 = p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'];
						p5LOCAL.push(function(){ p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = v_tmp4060 });
						return (p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'] = p5list_to_a([null]));
					})();
				p5pkg[p5make_package('Perlito5')['List_SCOPE_STMT'] || (p5make_package('Perlito5')['List_SCOPE_STMT'] = []), 'Perlito5']['List_SCOPE_STMT'];
				(function () {
						var v_tmp4061 = p5make_package('Perlito5')['v_SCOPE'];
						p5LOCAL.push(function(){ p5make_package('Perlito5')['v_SCOPE'] = v_tmp4061 });
						return (p5make_package('Perlito5')['v_SCOPE'] = (null));
					})();
				p5make_package('Perlito5')['v_SCOPE'] = (p5make_package('Perlito5')['v_BASE_SCOPE']);
				(function () {
						var v_tmp4062 = p5make_package('Perlito5')['v_SCOPE_DEPTH'];
						p5LOCAL.push(function(){ p5make_package('Perlito5')['v_SCOPE_DEPTH'] = v_tmp4062 });
						return (p5make_package('Perlito5')['v_SCOPE_DEPTH'] = (null));
					})();
				p5make_package('Perlito5')['v_SCOPE_DEPTH'] = (0);
				(function () {
						var v_tmp4063 = p5make_package('Perlito5')['v_PKG_NAME'];
						p5LOCAL.push(function(){ p5make_package('Perlito5')['v_PKG_NAME'] = v_tmp4063 });
						return (p5make_package('Perlito5')['v_PKG_NAME'] = (null));
					})();
				p5make_package('Perlito5')['v_PKG_NAME'] = (v_namespace);
				var v_match;
				v_match = (p5pkg['Perlito5::Grammar'].exp_stmts([v_source, 0], 0));
				(function () {
						if ( (!( p5bool(v_match)) || (p5num((v_match || (v_match = new p5HashRef({})))._hash_.p5hget('to')) != p5pkg['Perlito5::Javascript2::Runtime'].length([v_source], 0))) ) {
						p5pkg['Perlito5::Javascript2::Runtime'].die([].concat(p5list_to_a(['Syntax error in eval near pos ', (v_match || (v_match = new p5HashRef({})))._hash_.p5hget('to')])), null);
					}
					})();
				var v_ast;
				v_ast = (p5call('Perlito5::AST::Apply', 'new', p5list_to_a(['code', 'do', 'arguments', (new p5ArrayRef(p5list_to_a([p5call('Perlito5::AST::Block', 'new', p5list_to_a(['stmts', (v_match || (v_match = new p5HashRef({})))._hash_.p5hget('capture')]), 1)])))]), 0));
				var v_js_code;
				v_js_code = (p5call(v_ast, 'emit_javascript2', [0, v_want], 0));
				p5make_package('Perlito5')['v_STRICT'] = (v_strict_old);
				return p5cleanup_local(local_idx, (p5context([v_js_code], p5want)));
				p5cleanup_local(local_idx, null);
			};
			tmp4057._prototype_ = null;
			return tmp4057
		})());
		p5typeglob_set('Perlito5::Javascript2::Runtime', 'emit_javascript2', (function () {
			var tmp4064;
			tmp4064 = function (List__, p5want) {
				return (p5context([(('//' + String.fromCharCode(10) + '// lib/Perlito5/Javascript2/Runtime.js' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Runtime for "Perlito" Perl5-in-Javascript2' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// AUTHORS' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Flavio Soibelmann Glock  fglock@gmail.com' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// COPYRIGHT' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// This program is free software; you can redistribute it and/or modify it' + String.fromCharCode(10) + '// under the same terms as Perl itself.' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// See http://www.perl.com/perl/misc/Artistic.html' + String.fromCharCode(10) + String.fromCharCode(10) + '"use strict";' + String.fromCharCode(10) + 'var isNode = typeof require != "undefined";' + String.fromCharCode(10) + String.fromCharCode(10) + 'if (typeof p5pkg !== "object") {' + String.fromCharCode(10) + '    var p5pkg = {};' + String.fromCharCode(10) + '    var p5LOCAL = [];' + String.fromCharCode(10) + String.fromCharCode(10) + '    var universal = function () {};' + String.fromCharCode(10) + '    p5pkg.UNIVERSAL = new universal();' + String.fromCharCode(10) + '    p5pkg.UNIVERSAL._ref_ = "UNIVERSAL";' + String.fromCharCode(10) + '    p5pkg.UNIVERSAL.isa = function (List__) {' + String.fromCharCode(10) + '        // TODO - use @ISA' + String.fromCharCode(10) + '        return List__[0]._class_._ref_ == List__[1]' + String.fromCharCode(10) + '    };' + String.fromCharCode(10) + '    p5pkg.UNIVERSAL.can = function (List__) {' + String.fromCharCode(10) + '        var o = List__[0];' + String.fromCharCode(10) + '        var s = List__[1];' + String.fromCharCode(10) + '        if ( s.indexOf("::") == -1 ) {' + String.fromCharCode(10) + '            return p5method_lookup(s, o._class_._ref__, {})' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var c = s.split("::");' + String.fromCharCode(10) + '        s = c.pop(); ' + String.fromCharCode(10) + '        return p5method_lookup(s, c.join("::"), {});' + String.fromCharCode(10) + '    };' + String.fromCharCode(10) + '    p5pkg.UNIVERSAL.DOES = p5pkg.UNIVERSAL.can;' + String.fromCharCode(10) + String.fromCharCode(10) + '    var core = function () {};' + String.fromCharCode(10) + '    p5pkg["CORE"] = new core();' + String.fromCharCode(10) + '    p5pkg["CORE"]._ref_ = "CORE";' + String.fromCharCode(10) + String.fromCharCode(10) + '    var core_global = function () {};' + String.fromCharCode(10) + '    core_global.prototype = p5pkg.CORE;' + String.fromCharCode(10) + '    p5pkg["CORE::GLOBAL"] = new core_global();' + String.fromCharCode(10) + '    p5pkg["CORE::GLOBAL"]._ref_ = "CORE::GLOBAL";' + String.fromCharCode(10) + String.fromCharCode(10) + '    var p5_error = function (type, v) {' + String.fromCharCode(10) + '        this.type = type;' + String.fromCharCode(10) + '        this.v = this.message = v;' + String.fromCharCode(10) + '        this.toString = function(){' + String.fromCharCode(10) + '            if (this.type == ' + String.fromCharCode(39) + 'break' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                return ' + String.fromCharCode(39) + 'Can' + String.fromCharCode(92) + String.fromCharCode(39) + 't "break" outside a given block' + String.fromCharCode(39) + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            if (this.type == ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ' || this.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ' || this.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                if (this.v == "") { return ' + String.fromCharCode(39) + 'Can' + String.fromCharCode(92) + String.fromCharCode(39) + 't "' + String.fromCharCode(39) + ' + this.type + ' + String.fromCharCode(39) + '" outside a loop block' + String.fromCharCode(39) + ' }' + String.fromCharCode(10) + '                return ' + String.fromCharCode(39) + 'Label not found for "' + String.fromCharCode(39) + ' + this.type + ' + String.fromCharCode(39) + ' ' + String.fromCharCode(39) + ' + this.v + ' + String.fromCharCode(39) + '"' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            return this.v;' + String.fromCharCode(10) + '        };' + String.fromCharCode(10) + '    };' + String.fromCharCode(10) + '    p5_error.prototype = Error.prototype;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5make_package(pkg_name) {' + String.fromCharCode(10) + '    if (!p5pkg.hasOwnProperty(pkg_name)) {' + String.fromCharCode(10) + '        var tmp = function () {};' + String.fromCharCode(10) + '        tmp.prototype = p5pkg["CORE::GLOBAL"];' + String.fromCharCode(10) + '        p5pkg[pkg_name] = new tmp();' + String.fromCharCode(10) + '        p5pkg[pkg_name]._ref_ = pkg_name;' + String.fromCharCode(10) + '        p5pkg[pkg_name]._class_ = p5pkg[pkg_name];  // XXX memory leak' + String.fromCharCode(10) + '        p5pkg[pkg_name]._is_package_ = 1;' + String.fromCharCode(10) + String.fromCharCode(10) + '        // TODO - add the other package global variables' + String.fromCharCode(10) + '        p5pkg[pkg_name]["List_ISA"] = [];' + String.fromCharCode(10) + '        p5pkg[pkg_name]["v_a"] = null;' + String.fromCharCode(10) + '        p5pkg[pkg_name]["v_b"] = null;' + String.fromCharCode(10) + '        p5pkg[pkg_name]["v__"] = null;' + String.fromCharCode(10) + '        p5pkg[pkg_name]["v_AUTOLOAD"] = null;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5pkg[pkg_name];' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5code_lookup_by_name(package_name, sub_name) {' + String.fromCharCode(10) + '    // sub_name can be a function already' + String.fromCharCode(10) + '    if (typeof sub_name === "function") {' + String.fromCharCode(10) + '        return sub_name;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    // sub_name can have an optional namespace' + String.fromCharCode(10) + '    var parts = sub_name.split(/::/);' + String.fromCharCode(10) + '    if (parts.length > 1) {' + String.fromCharCode(10) + '        sub_name = parts.pop();' + String.fromCharCode(10) + '        package_name = parts.join("::");' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (p5pkg.hasOwnProperty(package_name)) {' + String.fromCharCode(10) + '        var c = p5pkg[package_name];' + String.fromCharCode(10) + '        if ( c.hasOwnProperty(sub_name) ) {' + String.fromCharCode(10) + '            return c[sub_name]' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return null;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5get_class_for_method(method, class_name, seen) {' + String.fromCharCode(10) + '    // default mro' + String.fromCharCode(10) + '    // TODO - cache the methods that were already looked up' + String.fromCharCode(10) + '    if ( p5pkg[class_name].hasOwnProperty(method) ) {' + String.fromCharCode(10) + '        return class_name' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var isa = p5pkg[class_name].List_ISA;' + String.fromCharCode(10) + '    if (isa) {' + String.fromCharCode(10) + '        for (var i = 0; i < isa.length; i++) {' + String.fromCharCode(10) + '            if (!seen[isa[i]]) {' + String.fromCharCode(10) + '                var m = p5get_class_for_method(method, isa[i], seen);' + String.fromCharCode(10) + '                if (m) {' + String.fromCharCode(10) + '                    return m ' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                seen[isa[i]]++;' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5method_lookup(method, class_name, seen) {' + String.fromCharCode(10) + '    var c = p5get_class_for_method(method, class_name, seen);' + String.fromCharCode(10) + '    if (c) {' + String.fromCharCode(10) + '        return p5pkg[c][method]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if ( p5pkg.UNIVERSAL.hasOwnProperty(method) ) {' + String.fromCharCode(10) + '        return p5pkg.UNIVERSAL[method]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5method_not_found(method, class_name) {' + String.fromCharCode(10) + '    return "Can' + String.fromCharCode(39) + 't locate object method ' + String.fromCharCode(92) + '""' + String.fromCharCode(10) + '        + method + "' + String.fromCharCode(92) + '" via package ' + String.fromCharCode(92) + '"" + class_name + "' + String.fromCharCode(92) + '" (perhaps you forgot to load ' + String.fromCharCode(92) + '""' + String.fromCharCode(10) + '        + class_name + "' + String.fromCharCode(92) + '"?)";' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5call(invocant, method, list, p5want) {' + String.fromCharCode(10) + '    var invocant_original = invocant;' + String.fromCharCode(10) + '    if (typeof invocant === "string") {' + String.fromCharCode(10) + '        list.unshift(invocant);' + String.fromCharCode(10) + '        invocant = p5make_package(invocant);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else if ( invocant.hasOwnProperty("_is_package_") ) {' + String.fromCharCode(10) + '        list.unshift(invocant._ref_);   // invocant is a "package" object' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        list.unshift(invocant);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + String.fromCharCode(10) + '    if ( invocant.hasOwnProperty("_class_") ) {' + String.fromCharCode(10) + String.fromCharCode(10) + '        if ( invocant._class_.hasOwnProperty(method) ) {' + String.fromCharCode(10) + '            return invocant._class_[method](list, p5want)' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var m = p5method_lookup(method, invocant._class_._ref_, {});' + String.fromCharCode(10) + '        if (m) {' + String.fromCharCode(10) + '            return m(list, p5want)' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + String.fromCharCode(10) + '        // method can have an optional namespace' + String.fromCharCode(10) + '        var pkg_name = method.split(/::/);' + String.fromCharCode(10) + '        if (pkg_name.length > 1) {' + String.fromCharCode(10) + '            var name = pkg_name.pop();' + String.fromCharCode(10) + '            pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '            m = p5method_lookup(name, pkg_name, {});' + String.fromCharCode(10) + '            if (m) {' + String.fromCharCode(10) + '                return m(list, p5want)' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            p5pkg.CORE.die([p5method_not_found(name, pkg_name)]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + String.fromCharCode(10) + '        if (method == "print" || method == "printf" || method == "say" || method == "close") {' + String.fromCharCode(10) + '            list.shift();' + String.fromCharCode(10) + '            return p5pkg[' + String.fromCharCode(39) + 'Perlito5::IO' + String.fromCharCode(39) + '][method]( invocant_original, list, p5want);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + String.fromCharCode(10) + '        pkg_name = p5get_class_for_method(' + String.fromCharCode(39) + 'AUTOLOAD' + String.fromCharCode(39) + ', invocant._class_._ref_, {}) || p5get_class_for_method(' + String.fromCharCode(39) + 'AUTOLOAD' + String.fromCharCode(39) + ', "UNIVERSAL", {});' + String.fromCharCode(10) + '        if (pkg_name) {' + String.fromCharCode(10) + '            p5pkg[pkg_name]["v_AUTOLOAD"] = invocant._class_._ref_ + "::" + method;' + String.fromCharCode(10) + '            return p5pkg[pkg_name]["AUTOLOAD"](list, p5want);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        p5pkg.CORE.die([p5method_not_found(method, invocant._class_._ref_)]);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5pkg.CORE.die(["Can' + String.fromCharCode(39) + 't call method ", method, " on unblessed reference"]);' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5call_sub(namespace, name, list, p5want) {' + String.fromCharCode(10) + '    if(p5pkg[namespace].hasOwnProperty(name)) {' + String.fromCharCode(10) + '        return p5pkg[namespace][name](list, p5want)' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if(p5pkg[namespace].hasOwnProperty("AUTOLOAD")) {' + String.fromCharCode(10) + '        p5pkg[namespace]["v_AUTOLOAD"] = namespace + "::" + name;' + String.fromCharCode(10) + '        return p5pkg[namespace]["AUTOLOAD"](list, p5want)' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5pkg.CORE.die(["Undefined subroutine &" + namespace + "::" + name]);' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5sub_exists(name, current_pkg_name) {' + String.fromCharCode(10) + '    var v = name;' + String.fromCharCode(10) + '    var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '    if (pkg_name.length > 1) {' + String.fromCharCode(10) + '        v = pkg_name.pop();' + String.fromCharCode(10) + '        pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        pkg_name = current_pkg_name;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var c = v.charCodeAt(0);' + String.fromCharCode(10) + '    if (c < 27) {' + String.fromCharCode(10) + '        v = String.fromCharCode(c + 64) + v.substr(1);' + String.fromCharCode(10) + '        pkg_name = ' + String.fromCharCode(39) + 'main' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5pkg.hasOwnProperty(pkg_name) && p5pkg[pkg_name].hasOwnProperty(v) ' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5sub_prototype(name, current_pkg_name) {' + String.fromCharCode(10) + '    if (!name) {' + String.fromCharCode(10) + '        return null;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof name === "function") {' + String.fromCharCode(10) + '        return name._prototype_;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var v = name;' + String.fromCharCode(10) + '    var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '    if (pkg_name.length > 1) {' + String.fromCharCode(10) + '        v = pkg_name.pop();' + String.fromCharCode(10) + '        pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        pkg_name = current_pkg_name;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var c = v.charCodeAt(0);' + String.fromCharCode(10) + '    if (c < 27) {' + String.fromCharCode(10) + '        v = String.fromCharCode(c + 64) + v.substr(1);' + String.fromCharCode(10) + '        pkg_name = ' + String.fromCharCode(39) + 'main' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (p5pkg.hasOwnProperty(pkg_name) && p5pkg[pkg_name].hasOwnProperty(v)) {' + String.fromCharCode(10) + '        return p5pkg[pkg_name][v]._prototype_' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5pkg["Perlito5"].v_PROTO._hash_[name] || p5pkg["Perlito5"].v_CORE_PROTO._hash_[name]' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5scalar_deref(v, current_pkg_name, autoviv_type) {' + String.fromCharCode(10) + '    if (typeof v === "string") {' + String.fromCharCode(10) + '        var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '        if (pkg_name.length > 1) {' + String.fromCharCode(10) + '            v = pkg_name.pop();' + String.fromCharCode(10) + '            pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            pkg_name = current_pkg_name;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var c = v.charCodeAt(0);' + String.fromCharCode(10) + '        if (c < 27) {' + String.fromCharCode(10) + '            v = String.fromCharCode(c + 64) + v.substr(1);' + String.fromCharCode(10) + '            pkg_name = ' + String.fromCharCode(39) + 'main' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var name = "v_"+v;' + String.fromCharCode(10) + '        if (!p5make_package(pkg_name)[name]) {' + String.fromCharCode(10) + '            if (autoviv_type == ' + String.fromCharCode(39) + 'array' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                p5pkg[pkg_name][name] = new p5ArrayRef([]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            else if (autoviv_type == ' + String.fromCharCode(39) + 'hash' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                p5pkg[pkg_name][name] = new p5HashRef([]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            else if (autoviv_type == ' + String.fromCharCode(39) + 'scalar' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                p5pkg[pkg_name][name] = new p5ScalarRef([]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return p5pkg[pkg_name][name];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (!v._scalar_) {' + String.fromCharCode(10) + '        if (autoviv_type == ' + String.fromCharCode(39) + 'array' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '            v._scalar_ = new p5ArrayRef([]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if (autoviv_type == ' + String.fromCharCode(39) + 'hash' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '            v._scalar_ = new p5HashRef([]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if (autoviv_type == ' + String.fromCharCode(39) + 'scalar' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '            v._scalar_ = new p5ScalarRef([]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return v._scalar_;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5scalar_deref_set(v, n, current_pkg_name) {' + String.fromCharCode(10) + '    if (typeof v === "string") {' + String.fromCharCode(10) + '        var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '        if (pkg_name.length > 1) {' + String.fromCharCode(10) + '            v = pkg_name.pop();' + String.fromCharCode(10) + '            pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            pkg_name = current_pkg_name;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var c = v.charCodeAt(0);' + String.fromCharCode(10) + '        if (c < 27) {' + String.fromCharCode(10) + '            v = String.fromCharCode(c + 64) + v.substr(1);' + String.fromCharCode(10) + '            pkg_name = ' + String.fromCharCode(39) + 'main' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var name = "v_"+v;' + String.fromCharCode(10) + '        p5make_package(pkg_name)[name] = n;' + String.fromCharCode(10) + '        return p5pkg[pkg_name][name];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    v._scalar_ = n;' + String.fromCharCode(10) + '    return v._scalar_;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5array_deref(v, current_pkg_name) {' + String.fromCharCode(10) + '    if (typeof v === "string") {' + String.fromCharCode(10) + '        var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '        if (pkg_name.length > 1) {' + String.fromCharCode(10) + '            v = pkg_name.pop();' + String.fromCharCode(10) + '            pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            pkg_name = current_pkg_name;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var c = v.charCodeAt(0);' + String.fromCharCode(10) + '        if (c < 27) {' + String.fromCharCode(10) + '            v = String.fromCharCode(c + 64) + v.substr(1);' + String.fromCharCode(10) + '            pkg_name = ' + String.fromCharCode(39) + 'main' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var name = "List_"+v;' + String.fromCharCode(10) + '        if (!p5make_package(pkg_name)[name]) {' + String.fromCharCode(10) + '                p5pkg[pkg_name][name] = [];' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return p5pkg[pkg_name][name];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return v._array_;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5hash_deref(v, current_pkg_name) {' + String.fromCharCode(10) + '    if (typeof v === "string") {' + String.fromCharCode(10) + '        var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '        if (pkg_name.length > 1) {' + String.fromCharCode(10) + '            v = pkg_name.pop();' + String.fromCharCode(10) + '            pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            pkg_name = current_pkg_name;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var c = v.charCodeAt(0);' + String.fromCharCode(10) + '        if (c < 27) {' + String.fromCharCode(10) + '            v = String.fromCharCode(c + 64) + v.substr(1);' + String.fromCharCode(10) + '            pkg_name = ' + String.fromCharCode(39) + 'main' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        var name = "Hash_"+v;' + String.fromCharCode(10) + '        if (!p5make_package(pkg_name)[name]) {' + String.fromCharCode(10) + '                p5pkg[pkg_name][name] = [];' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return p5pkg[pkg_name][name];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return v._hash_;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + '// regex globals' + String.fromCharCode(10) + 'p5make_package("Regex");' + String.fromCharCode(10) + 'var p5_last_regex = new RegExp("", "");' + String.fromCharCode(10) + 'var p5_regex_capture = [];' + String.fromCharCode(10) + String.fromCharCode(10) + 'p5make_package("main");' + String.fromCharCode(10) + 'p5make_package("Perlito5");' + String.fromCharCode(10) + 'p5pkg["Perlito5"].v_PKG_NAME = "main";' + String.fromCharCode(10) + 'p5make_package("main::STDIN").file_handle = { id : 0, readline_buffer : ' + String.fromCharCode(39) + String.fromCharCode(39) + ' };' + String.fromCharCode(10) + 'p5make_package("main::STDOUT").file_handle = { id : 1 };' + String.fromCharCode(10) + 'p5make_package("main::STDERR").file_handle = { id : 2 };' + String.fromCharCode(10) + 'p5make_package("ARGV").file_handle = { id : null };' + String.fromCharCode(10) + 'p5pkg["STDOUT"] = p5pkg["main::STDOUT"];' + String.fromCharCode(10) + 'p5pkg["STDERR"] = p5pkg["main::STDERR"];' + String.fromCharCode(10) + 'p5pkg["STDIN"] = p5pkg["main::STDIN"];' + String.fromCharCode(10) + 'p5pkg["Perlito5"].v_SELECT = "main::STDOUT";' + String.fromCharCode(10) + 'p5pkg["main"]["v_@"] = [];      // $@' + String.fromCharCode(10) + 'p5pkg["main"]["v_|"] = 0;       // $|' + String.fromCharCode(10) + 'p5pkg["main"]["v_/"] = "' + String.fromCharCode(92) + 'n";    // $/' + String.fromCharCode(10) + 'p5pkg["main"][' + String.fromCharCode(39) + 'v_"' + String.fromCharCode(39) + '] = " ";     // $"' + String.fromCharCode(10) + 'p5pkg["main"]["List_#"] = [];   // @#' + String.fromCharCode(10) + 'p5scalar_deref_set(String.fromCharCode(15), isNode ? "node.js" : "javascript2");  // $^O' + String.fromCharCode(10) + 'p5pkg["main"]["List_INC"] = [];' + String.fromCharCode(10) + 'p5pkg["main"]["Hash_INC"] = {};' + String.fromCharCode(10) + 'p5pkg["main"]["List_ARGV"] = [];' + String.fromCharCode(10) + 'p5pkg["main"]["Hash_ENV"] = {};' + String.fromCharCode(10) + 'p5pkg["main"]["Hash_SIG"] = {};' + String.fromCharCode(10) + 'if (isNode) {' + String.fromCharCode(10) + '    p5pkg["main"]["List_ARGV"] = process.argv.splice(2);' + String.fromCharCode(10) + String.fromCharCode(10) + '    p5pkg["main"]["Hash_ENV"] = {};' + String.fromCharCode(10) + '    for (var e in process.env) p5pkg["main"]["Hash_ENV"][e] = process.env[e];' + String.fromCharCode(10) + String.fromCharCode(10) + '    p5pkg["main"]["v_$"] = process.pid;   // $$' + String.fromCharCode(10) + '    p5scalar_deref_set(String.fromCharCode(24), process.argv[0]);  // $^X' + String.fromCharCode(10) + '} else if (typeof arguments === "object") {' + String.fromCharCode(10) + '    p5pkg["main"]["List_ARGV"] = arguments;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'p5make_package("Perlito5::IO");' + String.fromCharCode(10) + 'p5make_package("Perlito5::Runtime");' + String.fromCharCode(10) + 'p5make_package("Perlito5::Grammar");' + String.fromCharCode(10) + String.fromCharCode(10) + 'var sigils = { ' + String.fromCharCode(39) + '@' + String.fromCharCode(39) + ' : ' + String.fromCharCode(39) + 'List_' + String.fromCharCode(39) + ', ' + String.fromCharCode(39) + '%' + String.fromCharCode(39) + ' : ' + String.fromCharCode(39) + 'Hash_' + String.fromCharCode(39) + ', ' + String.fromCharCode(39) + '$' + String.fromCharCode(39) + ' : ' + String.fromCharCode(39) + 'v_' + String.fromCharCode(39) + ', ' + String.fromCharCode(39) + '&' + String.fromCharCode(39) + ' : ' + String.fromCharCode(39) + String.fromCharCode(39) + ' };' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5typeglob_set(namespace, name, obj) {' + String.fromCharCode(10) + '    p5make_package(namespace);' + String.fromCharCode(10) + '    if ( obj.hasOwnProperty("_ref_") ) {' + String.fromCharCode(10) + '        if ( obj._ref_ == "HASH" ) {' + String.fromCharCode(10) + '            p5pkg[namespace][sigils[' + String.fromCharCode(39) + '%' + String.fromCharCode(39) + '] + name] = obj._hash_;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if ( obj._ref_ == "ARRAY" ) {' + String.fromCharCode(10) + '            p5pkg[namespace][sigils[' + String.fromCharCode(39) + '@' + String.fromCharCode(39) + '] + name] = obj._array_;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if ( obj._ref_ == "SCALAR" ) {' + String.fromCharCode(10) + '            p5pkg[namespace][sigils[' + String.fromCharCode(39) + '$' + String.fromCharCode(39) + '] + name] = obj._scalar_;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if ( obj._ref_ == "CODE" ) {' + String.fromCharCode(10) + '            p5pkg[namespace][sigils[' + String.fromCharCode(39) + '&' + String.fromCharCode(39) + '] + name] = obj._code_;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if ( obj._ref_ == "GLOB" ) {' + String.fromCharCode(10) + '            // TODO' + String.fromCharCode(10) + '            p5pkg[namespace][name] = obj;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        p5pkg[namespace][name] = obj;   // native CODE' + String.fromCharCode(10) + '        // TODO - non-reference' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5pkg[namespace][name];  // TODO - return GLOB' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5typeglob_deref_set(v, obj, current_pkg_name) {' + String.fromCharCode(10) + '    if (typeof v === "string") {' + String.fromCharCode(10) + '        var pkg_name = v.split(/::/);' + String.fromCharCode(10) + '        if (pkg_name.length > 1) {' + String.fromCharCode(10) + '            v = pkg_name.pop();' + String.fromCharCode(10) + '            pkg_name = pkg_name.join("::");' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            pkg_name = current_pkg_name;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return p5typeglob_set(pkg_name, v, obj);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    CORE.die(["TODO: can' + String.fromCharCode(39) + 't p5typeglob_deref_set()"]);' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5cleanup_local(idx, value) {' + String.fromCharCode(10) + '    while (p5LOCAL.length > idx) {' + String.fromCharCode(10) + '        var l = p5LOCAL.pop();' + String.fromCharCode(10) + '        l();' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return value;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + '//-------- Reference' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5id = Math.floor(Math.random() * 1000000000) + 1000000000;' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5HashRef(o) {' + String.fromCharCode(10) + '    this._hash_ = o;' + String.fromCharCode(10) + '    this._ref_ = "HASH";' + String.fromCharCode(10) + '    this.bool = function() { return 1 };' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5ArrayRef(o) {' + String.fromCharCode(10) + '    this._array_ = o;' + String.fromCharCode(10) + '    this._ref_ = "ARRAY";' + String.fromCharCode(10) + '    this.bool = function() { return 1 };' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5ScalarRef(o) {' + String.fromCharCode(10) + '    this._scalar_ = o;' + String.fromCharCode(10) + '    this._ref_ = "SCALAR";' + String.fromCharCode(10) + '    this.bool = function() { return 1 };' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5GlobRef(o) {' + String.fromCharCode(10) + '    this._scalar_ = o;' + String.fromCharCode(10) + '    this._ref_ = "GLOB";' + String.fromCharCode(10) + '    this.bool = function() { return 1 };' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5CodeRef(o) {' + String.fromCharCode(10) + '    this._code_ = o;' + String.fromCharCode(10) + '    this._ref_ = "CODE";' + String.fromCharCode(10) + '    this.bool = function() { return 1 };' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + '//-------- Hash ' + String.fromCharCode(10) + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5hget", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) { return this[i] }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5hset", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i, v) { this[i] = v; return this[i] }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5incr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        this[i] = p5incr_(this[i]);' + String.fromCharCode(10) + '        return this[i];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5postincr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        var v = this[i];' + String.fromCharCode(10) + '        this[i] = p5incr_(this[i]);' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5decr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        this[i] = p5decr_(this[i]);' + String.fromCharCode(10) + '        return this[i];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5postdecr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        var v = this[i];' + String.fromCharCode(10) + '        this[i] = p5decr_(this[i]);' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5hget_array", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (this[i] == null) { this[i] = new p5ArrayRef([]) }' + String.fromCharCode(10) + '        return this[i]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Object.prototype, "p5hget_hash", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (this[i] == null) { this[i] = new p5HashRef({}) }' + String.fromCharCode(10) + '        return this[i]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + String.fromCharCode(10) + '//-------' + String.fromCharCode(10) + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5context = function(List__, p5want) {' + String.fromCharCode(10) + '    if (p5want) {' + String.fromCharCode(10) + '        return p5list_to_a(List__);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    // scalar: return the last value' + String.fromCharCode(10) + '    var o = List__;' + String.fromCharCode(10) + '    if (o instanceof Array) {' + String.fromCharCode(10) + '        o =   o.length' + String.fromCharCode(10) + '            ? o[o.length-1]' + String.fromCharCode(10) + '            : null;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (o instanceof Array) {' + String.fromCharCode(10) + '        o =   o.length' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return o;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5list_to_a = function(args) {' + String.fromCharCode(10) + '    var res = [];' + String.fromCharCode(10) + '    for (var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '        var o = args[i];' + String.fromCharCode(10) + '        if  (  o == null' + String.fromCharCode(10) + '            || o._class_    // perl5 blessed reference' + String.fromCharCode(10) + '            || o._ref_      // perl5 un-blessed reference' + String.fromCharCode(10) + '            )' + String.fromCharCode(10) + '        {' + String.fromCharCode(10) + '            res.push(o);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if (o instanceof Array) {' + String.fromCharCode(10) + '            // perl5 array' + String.fromCharCode(10) + '            for (var j = 0; j < o.length; j++) {' + String.fromCharCode(10) + '                res.push(o[j]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else if (typeof o === "object") {' + String.fromCharCode(10) + '            // perl5 hash' + String.fromCharCode(10) + '            for(var j in o) {' + String.fromCharCode(10) + '                if (o.hasOwnProperty(j)) {' + String.fromCharCode(10) + '                    res.push(j);' + String.fromCharCode(10) + '                    res.push(o[j]);' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            // non-ref' + String.fromCharCode(10) + '            res.push(o);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return res;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5_list_of_refs = function(a) {' + String.fromCharCode(10) + '    // implements ' + String.fromCharCode(92) + '( @a )' + String.fromCharCode(10) + '    var res = [];' + String.fromCharCode(10) + '    for (var i = 0; i < a.length; i++) {' + String.fromCharCode(10) + '        res.push(new p5ScalarRef(a[i]));' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return res;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5a_to_h = function(a) {' + String.fromCharCode(10) + '    var res = {};' + String.fromCharCode(10) + '    for (var i = 0; i < a.length; i+=2) {' + String.fromCharCode(10) + '        res[p5str(a[i])] = a[i+1];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return res;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5idx = function(a, i) {' + String.fromCharCode(10) + '    return i >= 0 ? i : a.length + i' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5smrt_scalar = function(a1, a2) {' + String.fromCharCode(10) + '    if (a2 == null) {' + String.fromCharCode(10) + '        return a1 == null;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof a2 == "string") {' + String.fromCharCode(10) + '        return p5str(a1) == a2;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof a2 == "number") {' + String.fromCharCode(10) + '        return p5num(a1) == a2;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    CORE.die("Not implemented: smartmatch operator with argument type ' + String.fromCharCode(39) + '", (typeof a2), "' + String.fromCharCode(39) + '");' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5str = function(o) {' + String.fromCharCode(10) + '    if (o == null) {' + String.fromCharCode(10) + '        return "";' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o === "object") {' + String.fromCharCode(10) + '        if (o instanceof Array) {' + String.fromCharCode(10) + '            return CORE.join([""].concat(o));' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if ( o.hasOwnProperty("_ref_") ) {' + String.fromCharCode(10) + '            var class_name = ' + String.fromCharCode(39) + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '            if (o._class_ && typeof o._class_._ref_ === "string") {' + String.fromCharCode(10) + '                // blessed reference' + String.fromCharCode(10) + '                // test for overload' + String.fromCharCode(10) + '                var meth = p5method_lookup(' + String.fromCharCode(39) + '(""' + String.fromCharCode(39) + ', o._class_._ref_, {});' + String.fromCharCode(10) + '                if (meth) {' + String.fromCharCode(10) + '                    return p5str(meth([o], 0));' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                // TODO - test the "fallback" flag' + String.fromCharCode(10) + '                meth = p5method_lookup(' + String.fromCharCode(39) + '(0+' + String.fromCharCode(39) + ', o._class_._ref_, {});' + String.fromCharCode(10) + '                if (meth) {' + String.fromCharCode(10) + '                    return p5str(meth([o], 0));' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                // no overload, strigify the reference instead' + String.fromCharCode(10) + '                class_name = o._class_._ref_ + ' + String.fromCharCode(39) + '=' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            if (!o._id_) { o._id_ = p5id++ }' + String.fromCharCode(10) + '            return [class_name, o._ref_, ' + String.fromCharCode(39) + '(0x' + String.fromCharCode(39) + ', o._id_.toString( 16 ), ' + String.fromCharCode(39) + ')' + String.fromCharCode(39) + '].join(' + String.fromCharCode(39) + String.fromCharCode(39) + ');' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o === "function") {' + String.fromCharCode(10) + '        var class_name = ' + String.fromCharCode(39) + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '        if (o._class_ && typeof o._class_._ref_ === "string") {' + String.fromCharCode(10) + '            // blessed reference' + String.fromCharCode(10) + '            class_name = o._class_._ref_ + ' + String.fromCharCode(39) + '=' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (!o._id_) { o._id_ = p5id++ }' + String.fromCharCode(10) + '        return [class_name, ' + String.fromCharCode(39) + 'CODE(0x' + String.fromCharCode(39) + ', o._id_.toString( 16 ), ' + String.fromCharCode(39) + ')' + String.fromCharCode(39) + '].join(' + String.fromCharCode(39) + String.fromCharCode(39) + ');' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o == "number" && Math.abs(o) < 0.0001 && o != 0) {' + String.fromCharCode(10) + '        return o.toExponential().replace(/e-(' + String.fromCharCode(92) + 'd)$/,"e-0$1");' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o === "boolean") {' + String.fromCharCode(10) + '        return o ? "1" : "";' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o !== "string") {' + String.fromCharCode(10) + '        return "" + o;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return o;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5num = function(o) {' + String.fromCharCode(10) + '    if (o == null) {' + String.fromCharCode(10) + '        return 0;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o === "object") {' + String.fromCharCode(10) + '        if (o instanceof Array) {' + String.fromCharCode(10) + '            return o.length;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if ( o.hasOwnProperty("_ref_") ) {' + String.fromCharCode(10) + '            if (o._class_ && typeof o._class_._ref_ === "string") {' + String.fromCharCode(10) + '                // blessed reference' + String.fromCharCode(10) + '                // test for overload' + String.fromCharCode(10) + '                var meth = p5method_lookup(' + String.fromCharCode(39) + '(0+' + String.fromCharCode(39) + ', o._class_._ref_, {});' + String.fromCharCode(10) + '                if (meth) {' + String.fromCharCode(10) + '                    return p5num(meth([o], 0));' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                // TODO - test the "fallback" flag' + String.fromCharCode(10) + '                meth = p5method_lookup(' + String.fromCharCode(39) + '(""' + String.fromCharCode(39) + ', o._class_._ref_, {});' + String.fromCharCode(10) + '                if (meth) {' + String.fromCharCode(10) + '                    return p5num(meth([o], 0));' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o !== "number") {' + String.fromCharCode(10) + '        var s = p5str(o).trim();' + String.fromCharCode(10) + '        var s1 = s.substr(0, 3).toUpperCase();' + String.fromCharCode(10) + '        if ( s1 == "NAN" ) { return NaN };' + String.fromCharCode(10) + '        if ( s1 == "INF" ) { return Infinity };' + String.fromCharCode(10) + '        s1 = s.substr(0, 4).toUpperCase();' + String.fromCharCode(10) + '        if ( s1 == "-NAN" ) { return NaN };' + String.fromCharCode(10) + '        if ( s1 == "-INF" ) { return -Infinity };' + String.fromCharCode(10) + '        s1 = parseFloat(s);' + String.fromCharCode(10) + '        if ( isNaN(s1) ) { return 0 };' + String.fromCharCode(10) + '        return s1;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return o;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5bool = function(o) {' + String.fromCharCode(10) + '    if (o) {' + String.fromCharCode(10) + '        if (typeof o === "boolean") {' + String.fromCharCode(10) + '            return o;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (typeof o === "number") {' + String.fromCharCode(10) + '            return o;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (typeof o === "string") {' + String.fromCharCode(10) + '            return o != "" && o != "0";' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (typeof o.length === "number") {' + String.fromCharCode(10) + '            return o.length;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (o instanceof Error) {' + String.fromCharCode(10) + '            return true;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        for (var i in o) {' + String.fromCharCode(10) + '            return true;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return false;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5incr_ = function(o) {' + String.fromCharCode(10) + '    if (typeof o === "number") {' + String.fromCharCode(10) + '        return o + 1;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5str_inc(p5str(o));' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5decr_ = function(o) {' + String.fromCharCode(10) + '    if (typeof o === "number") {' + String.fromCharCode(10) + '        return o - 1;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5num(o) - 1;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5modulo = function(o, k) {' + String.fromCharCode(10) + '    var m = o % k;' + String.fromCharCode(10) + '    if ( k < 0 && m > 0 ) {' + String.fromCharCode(10) + '        m = m + k;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else if ( k > 0 && m < 0 ) {' + String.fromCharCode(10) + '        m = m + k;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return m;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5shift_left = function(o, k) {' + String.fromCharCode(10) + '    return k < 31 ? o << k : o * Math.pow(2, k);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5and = function(a, fb) {' + String.fromCharCode(10) + '    if (p5bool(a)) {' + String.fromCharCode(10) + '        return fb();' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return a;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5or = function(a, fb) {' + String.fromCharCode(10) + '    if (p5bool(a)) {' + String.fromCharCode(10) + '        return a;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return fb();' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5defined_or = function(a, fb) {' + String.fromCharCode(10) + '    if (a == null) {' + String.fromCharCode(10) + '        return fb();' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return a;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5xor = function(a, fb) {' + String.fromCharCode(10) + '    return p5bool(a) ? !p5bool(fb()) : fb()' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5cmp = function(a, b) {' + String.fromCharCode(10) + '    return a > b ? 1 : a < b ? -1 : 0 ' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5complement = function(a) {' + String.fromCharCode(10) + '    return a < 0 ? ~a : 4294967295 - a' + String.fromCharCode(10) + '    // return a < 0 ? ~a : 18446744073709551615 - a' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5str_replicate = function(o, n) {' + String.fromCharCode(10) + '    n = Math.floor(n);' + String.fromCharCode(10) + '    return n > 0 ? Array(n + 1).join(o) : "";' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5list_replicate = function(o, n, want) {' + String.fromCharCode(10) + '    o = p5list_to_a([o]);' + String.fromCharCode(10) + '    n = p5num(n);' + String.fromCharCode(10) + String.fromCharCode(10) + '    if (!want) {' + String.fromCharCode(10) + '        return p5str_replicate(o.pop(), n);   // scalar context' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for(var i = 0; i < n; i++) {' + String.fromCharCode(10) + '        for(var j = 0; j < o.length; j++) {' + String.fromCharCode(10) + '            out.push(o[j]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return (want ? out : out.length)' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5list_slice = function(o, ix, want) {' + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for (var i=0, l=ix.length; i<l; ++i) {' + String.fromCharCode(10) + '        if (ix[i] < o.length) {' + String.fromCharCode(10) + '            out[i] = o[ix[i]];' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (want) { return out }' + String.fromCharCode(10) + '    return out.length ? out[out.length-1] : null;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5hash_slice = function(o, ix, want) {' + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for (var i=0, l=ix.length; i<l; ++i) {' + String.fromCharCode(10) + '        out.push(ix[i]);' + String.fromCharCode(10) + '        out.push(o[ix[i]]);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (want) { return out }' + String.fromCharCode(10) + '    return out.length ? out[out.length-1] : null;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5list_lookup_slice = function(o, ix, want) {' + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for (var i=0, l=ix.length; i<l; ++i) {' + String.fromCharCode(10) + '        out[i] = o[ix[i]];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (want) { return out }' + String.fromCharCode(10) + '    return out.length ? out[out.length-1] : null;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5hash_lookup_slice = function(o, ix, want) {' + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for (var i=0, l=ix.length; i<l; ++i) {' + String.fromCharCode(10) + '        out.push(ix[i]);' + String.fromCharCode(10) + '        out.push(o[ix[i]]);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (want) { return out }' + String.fromCharCode(10) + '    return out.length ? out[out.length-1] : null;' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5str_inc = function(s) {' + String.fromCharCode(10) + '    if (s.length < 2) {' + String.fromCharCode(10) + '        if ((s >= "0" && s <= "8") || (s >= "A" && s <= "Y") || (s >= "a" && s <= "y")) {' + String.fromCharCode(10) + '            return String.fromCharCode(s.charCodeAt(0) + 1);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (s == "9") {' + String.fromCharCode(10) + '            return "10";' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (s == "Z") {' + String.fromCharCode(10) + '            return "AA";' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (s == "z") {' + String.fromCharCode(10) + '            return "aa";' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return "1";' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var c0 = s.substr(0, 1);' + String.fromCharCode(10) + '    if (c0 >= "0" && c0 <= "9") {' + String.fromCharCode(10) + '        return p5str(p5num(s)+1);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var c = p5str_inc(s.substr(s.length-1, 1));' + String.fromCharCode(10) + '    if (c.length == 1) {' + String.fromCharCode(10) + '        return s.substr(0, s.length-1) + c;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return p5str_inc(s.substr(0, s.length-1)) + c.substr(c.length-1, 1);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5range_state = {};' + String.fromCharCode(10) + 'var p5range = function(a, b, p5want, id, three_dots) {' + String.fromCharCode(10) + '    if (p5want) {' + String.fromCharCode(10) + '        // list context' + String.fromCharCode(10) + '        var tmp = [];' + String.fromCharCode(10) + '        if (typeof a === "number" || typeof b === "number") {' + String.fromCharCode(10) + '            a = p5num(a);' + String.fromCharCode(10) + '            b = p5num(b);' + String.fromCharCode(10) + '            while (a <= b) {' + String.fromCharCode(10) + '                tmp.push(a);' + String.fromCharCode(10) + '                a++;' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            a = p5str(a);' + String.fromCharCode(10) + '            b = p5str(b);' + String.fromCharCode(10) + '            var c = a.substr(0, 1);' + String.fromCharCode(10) + '            if ( c == ' + String.fromCharCode(39) + '+' + String.fromCharCode(39) + ' ) {' + String.fromCharCode(10) + '                if (a == "+") {' + String.fromCharCode(10) + '                    return [a]' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                a = a.substr(1)' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            else if ( c == ' + String.fromCharCode(39) + '-' + String.fromCharCode(39) + ' ) {' + String.fromCharCode(10) + '                if (a == "-") {' + String.fromCharCode(10) + '                    return [a]' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                return p5range(p5num(a), b, p5want, id, three_dots)' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            c = b.substr(0, 1);' + String.fromCharCode(10) + '            if ( c == ' + String.fromCharCode(39) + '+' + String.fromCharCode(39) + ' ) {' + String.fromCharCode(10) + '                b = b.substr(1)' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            while (  (a.length < b.length)' + String.fromCharCode(10) + '                  || (a.length == b.length && a <= b) ) {' + String.fromCharCode(10) + '                tmp.push(a);' + String.fromCharCode(10) + '                a = p5incr_(a);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return tmp;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    // flip-flop operator' + String.fromCharCode(10) + '    var v;' + String.fromCharCode(10) + '    if (p5range_state[id]) {' + String.fromCharCode(10) + '        v = ++p5range_state[id];' + String.fromCharCode(10) + '        if (p5bool(b)) {' + String.fromCharCode(10) + '            p5range_state[id] = 0;' + String.fromCharCode(10) + '            v = v + "E0";' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        p5range_state[id] = 0;' + String.fromCharCode(10) + '        if (p5bool(a)) {' + String.fromCharCode(10) + '            p5range_state[id]++;' + String.fromCharCode(10) + '            v = p5range_state[id];' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (v && !three_dots && p5bool(b)) {' + String.fromCharCode(10) + '            p5range_state[id] = 0;' + String.fromCharCode(10) + '            v = v + "E0";' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5negative = function(o) {' + String.fromCharCode(10) + '    if (o == null) {' + String.fromCharCode(10) + '        return ' + String.fromCharCode(39) + '-0' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o === "object" && (o instanceof Array)) {' + String.fromCharCode(10) + '        return -(o.length);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (typeof o !== "number") {' + String.fromCharCode(10) + '        var s = p5str(o);' + String.fromCharCode(10) + '        var c = s.substr(0, 1);' + String.fromCharCode(10) + '        if ( c == ' + String.fromCharCode(39) + '+' + String.fromCharCode(39) + ' ) { s = s.substr(1); return ' + String.fromCharCode(39) + '-' + String.fromCharCode(39) + ' + s }' + String.fromCharCode(10) + '        if ( c == ' + String.fromCharCode(39) + '-' + String.fromCharCode(39) + ' ) { s = s.substr(1); return ' + String.fromCharCode(39) + '+' + String.fromCharCode(39) + ' + s }' + String.fromCharCode(10) + '        var s1 = parseFloat(s.trim());' + String.fromCharCode(10) + '        if ( isNaN(s1) ) {' + String.fromCharCode(10) + '            if ( c.length && !c.match(/[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz]/) ) {' + String.fromCharCode(10) + '                if ( s.trim().substr(0,1) == "-" ) { return 0 };' + String.fromCharCode(10) + '                return ' + String.fromCharCode(39) + '-0' + String.fromCharCode(39) + ';' + String.fromCharCode(10) + '            };' + String.fromCharCode(10) + '            return ' + String.fromCharCode(39) + '-' + String.fromCharCode(39) + ' + s' + String.fromCharCode(10) + '        };' + String.fromCharCode(10) + '        return -s1;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return -o;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5qr = function(search, modifier) {' + String.fromCharCode(10) + '    // TODO - "Regex" stringification' + String.fromCharCode(10) + '    var re = new RegExp(search, modifier);' + String.fromCharCode(10) + '    return CORE.bless([(new p5ScalarRef(re)), ' + String.fromCharCode(39) + 'Regex' + String.fromCharCode(39) + ']);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5m = function(s, search, modifier, want) {' + String.fromCharCode(10) + '    // TODO - captures' + String.fromCharCode(10) + '    var re;' + String.fromCharCode(10) + '    if (search.hasOwnProperty(' + String.fromCharCode(39) + '_scalar_' + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '        // search is a Regex object' + String.fromCharCode(10) + '        re = search._scalar_;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        re = new RegExp(search, modifier);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + String.fromCharCode(10) + '    p5_regex_capture = [];' + String.fromCharCode(10) + '    var res = [];' + String.fromCharCode(10) + '    var myArray;' + String.fromCharCode(10) + '    while ((myArray = re.exec(s)) !== null) {' + String.fromCharCode(10) + '        var m = myArray.shift();' + String.fromCharCode(10) + '        if (myArray.length) {' + String.fromCharCode(10) + '            res = res.concat(myArray);' + String.fromCharCode(10) + '            p5_regex_capture = p5_regex_capture.concat(myArray);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        else {' + String.fromCharCode(10) + '            res.push(m);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (re.lastIndex == 0) {' + String.fromCharCode(10) + '            return (want ? res : res.length)' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return (want ? res : res.length)' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5s = function(s, search, fun_replace, modifier, want) {' + String.fromCharCode(10) + '    // TODO - captures' + String.fromCharCode(10) + '    var count = null;' + String.fromCharCode(10) + '    var re;' + String.fromCharCode(10) + '    if (search.hasOwnProperty(' + String.fromCharCode(39) + '_scalar_' + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '        // search is a Regex object' + String.fromCharCode(10) + '        re = search._scalar_;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        re = new RegExp(search, modifier);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + String.fromCharCode(10) + '    p5_regex_capture = [];' + String.fromCharCode(10) + '    var res = [];' + String.fromCharCode(10) + '    var myArray;' + String.fromCharCode(10) + '    var last_index = 0;' + String.fromCharCode(10) + '    while ((myArray = re.exec(s)) !== null) {' + String.fromCharCode(10) + '        var m = myArray.shift();' + String.fromCharCode(10) + '        p5_regex_capture = [].concat(myArray);' + String.fromCharCode(10) + '        if (myArray.index > last_index) {' + String.fromCharCode(10) + '            res.push(s.substr(last_index, myArray.index - last_index));' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        res.push(fun_replace());' + String.fromCharCode(10) + '        last_index = re.lastIndex;' + String.fromCharCode(10) + '        if (last_index == 0) {' + String.fromCharCode(10) + '            count = 1;' + String.fromCharCode(10) + '            last_index = myArray.index + m.length;' + String.fromCharCode(10) + '            if (s.length > last_index) {' + String.fromCharCode(10) + '                res.push(s.substr(last_index, s.length - last_index));' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            return [res.join(' + String.fromCharCode(39) + String.fromCharCode(39) + '), count]' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        count++;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (s.length > last_index) {' + String.fromCharCode(10) + '        res.push(s.substr(last_index, s.length - last_index));' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return [res.join(' + String.fromCharCode(39) + String.fromCharCode(39) + '), count]' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5tr = function(s, search, replace, modifier, want) {' + String.fromCharCode(10) + '    var count = 0;' + String.fromCharCode(10) + '    // TODO - expand character lists in spec' + String.fromCharCode(10) + '    // TODO - modifiers' + String.fromCharCode(10) + '    search = search.split("");' + String.fromCharCode(10) + '    replace = replace.split("");' + String.fromCharCode(10) + '    while (search.length > replace.length) {' + String.fromCharCode(10) + '        replace.push(replace[replace.length-1]);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var tr = {};' + String.fromCharCode(10) + '    for(var i = 0; i < search.length; i++) {' + String.fromCharCode(10) + '        tr[search[i]] = replace[i];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    var res = s.split("");' + String.fromCharCode(10) + '    for(var i = 0; i < res.length; i++) {' + String.fromCharCode(10) + '        if (tr.hasOwnProperty(res[i])) {' + String.fromCharCode(10) + '            res[i] = tr[res[i]];' + String.fromCharCode(10) + '            count++;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return [res.join(' + String.fromCharCode(39) + String.fromCharCode(39) + '), count]' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5chop = function(s) {' + String.fromCharCode(10) + '    // TODO - array, hash' + String.fromCharCode(10) + '    return [s.substr(-1,1), s.substr(0,s.length-1)]' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5chomp = function(s) {' + String.fromCharCode(10) + '    // TODO - array, hash' + String.fromCharCode(10) + '    // TODO - special cases of $/ - empty string, reference' + String.fromCharCode(10) + '    var sep = p5pkg["main"]["v_/"];  // $/' + String.fromCharCode(10) + '    var c = s.substr(-sep.length);' + String.fromCharCode(10) + '    if (c == sep) {' + String.fromCharCode(10) + '        return [c.length, s.substr(0,s.length-sep.length)]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        return [0, s]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5for = function(namespace, var_name, func, args, cont, label) {' + String.fromCharCode(10) + '    var local_idx = p5LOCAL.length;' + String.fromCharCode(10) + '    var v_old = namespace[var_name];' + String.fromCharCode(10) + '    var _redo;' + String.fromCharCode(10) + '    p5LOCAL.push(function(){ namespace[var_name] = v_old });' + String.fromCharCode(10) + '    for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '        namespace[var_name] = args[i];' + String.fromCharCode(10) + '        do {' + String.fromCharCode(10) + '            _redo = false;' + String.fromCharCode(10) + '            try {' + String.fromCharCode(10) + '                func()' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            catch(err) {' + String.fromCharCode(10) + '                if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                    if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                        p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                        return' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                    else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }' + String.fromCharCode(10) + '                    else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                else {' + String.fromCharCode(10) + '                    throw(err)' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            if (cont) {' + String.fromCharCode(10) + '                try {' + String.fromCharCode(10) + '                    if (!_redo) { cont() }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                catch(err) {' + String.fromCharCode(10) + '                    if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                        if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                            p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                            return' + String.fromCharCode(10) + '                        }' + String.fromCharCode(10) + '                        else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }' + String.fromCharCode(10) + '                        else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                    }            ' + String.fromCharCode(10) + '                    else {' + String.fromCharCode(10) + '                        throw(err)' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        } while (_redo);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5for_lex = function(set_var, func, args, cont, label) {' + String.fromCharCode(10) + '    var local_idx = p5LOCAL.length;' + String.fromCharCode(10) + '    var _redo;' + String.fromCharCode(10) + '    for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '        set_var(args[i]);' + String.fromCharCode(10) + '        do {' + String.fromCharCode(10) + '            _redo = false;' + String.fromCharCode(10) + '            try {' + String.fromCharCode(10) + '                func()' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            catch(err) {' + String.fromCharCode(10) + '                if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                    if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                        p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                        return' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                    else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }' + String.fromCharCode(10) + '                    else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                }            ' + String.fromCharCode(10) + '                else {' + String.fromCharCode(10) + '                    throw(err)' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            if (cont) {' + String.fromCharCode(10) + '                try {' + String.fromCharCode(10) + '                    if (!_redo) { cont() }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                catch(err) {' + String.fromCharCode(10) + '                    if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                        if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                            p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                            return' + String.fromCharCode(10) + '                        }' + String.fromCharCode(10) + '                        else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }' + String.fromCharCode(10) + '                        else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                    }            ' + String.fromCharCode(10) + '                    else {' + String.fromCharCode(10) + '                        throw(err)' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        } while (_redo);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5block = function(set_var, func, args, cont, label) {' + String.fromCharCode(10) + '    var local_idx = p5LOCAL.length;' + String.fromCharCode(10) + '    var _redo;' + String.fromCharCode(10) + '    for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '        set_var(args[i]);' + String.fromCharCode(10) + '        do {' + String.fromCharCode(10) + '            _redo = false;' + String.fromCharCode(10) + '            try {' + String.fromCharCode(10) + '                return func()' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            catch(err) {' + String.fromCharCode(10) + '                if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                    if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                        p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                        return' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                    else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }' + String.fromCharCode(10) + '                    else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                }            ' + String.fromCharCode(10) + '                else {' + String.fromCharCode(10) + '                    throw(err)' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            if (cont) {' + String.fromCharCode(10) + '                try {' + String.fromCharCode(10) + '                    if (!_redo) { cont() }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                catch(err) {' + String.fromCharCode(10) + '                    if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                        if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                            p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                            return' + String.fromCharCode(10) + '                        }' + String.fromCharCode(10) + '                        else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { _redo = true }' + String.fromCharCode(10) + '                        else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                    }            ' + String.fromCharCode(10) + '                    else {' + String.fromCharCode(10) + '                        throw(err)' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        } while (_redo);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5while = function(func, cond, cont, label, redo) {' + String.fromCharCode(10) + '    var local_idx = p5LOCAL.length;' + String.fromCharCode(10) + '    while (redo || p5bool(cond())) {' + String.fromCharCode(10) + '        redo = false;' + String.fromCharCode(10) + '        try {' + String.fromCharCode(10) + '            func()' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        catch(err) {' + String.fromCharCode(10) + '            if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                    p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                    return' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '                else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { redo = true }' + String.fromCharCode(10) + '                else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '            }            ' + String.fromCharCode(10) + '            else {' + String.fromCharCode(10) + '                throw(err)' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        if (cont) {' + String.fromCharCode(10) + '            try {' + String.fromCharCode(10) + '                if (!redo) { cont() }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            catch(err) {' + String.fromCharCode(10) + '                if (err instanceof p5_error && (err.v == label || err.v == ' + String.fromCharCode(39) + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '                    if (err.type == ' + String.fromCharCode(39) + 'last' + String.fromCharCode(39) + ') {' + String.fromCharCode(10) + '                        p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '                        return' + String.fromCharCode(10) + '                    }' + String.fromCharCode(10) + '                    else if (err.type == ' + String.fromCharCode(39) + 'redo' + String.fromCharCode(39) + ') { redo = true }' + String.fromCharCode(10) + '                    else if (err.type != ' + String.fromCharCode(39) + 'next' + String.fromCharCode(39) + ') { throw(err) }' + String.fromCharCode(10) + '                }            ' + String.fromCharCode(10) + '                else {' + String.fromCharCode(10) + '                    throw(err)' + String.fromCharCode(10) + '                }' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5cleanup_local(local_idx, null);' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5map = function(namespace, func, args) {' + String.fromCharCode(10) + '    var v_old = p5pkg["main"]["v__"];' + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '        p5pkg["main"]["v__"] = args[i];' + String.fromCharCode(10) + '        var o = p5list_to_a([func(1)]);' + String.fromCharCode(10) + '        for(var j = 0; j < o.length; j++) {' + String.fromCharCode(10) + '            out.push(o[j]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5pkg["main"]["v__"] = v_old;' + String.fromCharCode(10) + '    return out;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5grep = function(namespace, func, args) {' + String.fromCharCode(10) + '    var v_old = p5pkg["main"]["v__"];' + String.fromCharCode(10) + '    var out = [];' + String.fromCharCode(10) + '    for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '        p5pkg["main"]["v__"] = args[i];' + String.fromCharCode(10) + '        if (p5bool(func(0))) {' + String.fromCharCode(10) + '            out.push(args[i])' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    p5pkg["main"]["v__"] = v_old;' + String.fromCharCode(10) + '    return out;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5sort = function(namespace, func, args) {' + String.fromCharCode(10) + '    var a_old = namespace["v_a"];' + String.fromCharCode(10) + '    var b_old = namespace["v_b"];' + String.fromCharCode(10) + '    var out = ' + String.fromCharCode(10) + '        func == null' + String.fromCharCode(10) + '        ? args.sort()' + String.fromCharCode(10) + '        : args.sort(' + String.fromCharCode(10) + '            function(a, b) {' + String.fromCharCode(10) + '                namespace["v_a"] = a;' + String.fromCharCode(10) + '                namespace["v_b"] = b;' + String.fromCharCode(10) + '                return func(0);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '        );' + String.fromCharCode(10) + '    namespace["v_a"] = a_old;' + String.fromCharCode(10) + '    namespace["v_b"] = b_old;' + String.fromCharCode(10) + '    return out;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10)))], p5want));
			};
			tmp4064._prototype_ = null;
			return tmp4064
		})());
		1;
	})();
	// use Perlito5::Javascript2::Runtime
;
	(function () {
		null;
		p5make_package('Perlito5::Javascript2::Array');
		p5typeglob_set('Perlito5::Javascript2::Array', 'emit_javascript2', (function () {
			var tmp4065;
			tmp4065 = function (List__, p5want) {
				return (p5context([(('//' + String.fromCharCode(10) + '// lib/Perlito5/Javascript2/Runtime.js' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Runtime for "Perlito" Perl5-in-Javascript2' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// AUTHORS' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Flavio Soibelmann Glock  fglock@gmail.com' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// COPYRIGHT' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// This program is free software; you can redistribute it and/or modify it' + String.fromCharCode(10) + '// under the same terms as Perl itself.' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// See http://www.perl.com/perl/misc/Artistic.html' + String.fromCharCode(10) + String.fromCharCode(10) + '//-------- Array ' + String.fromCharCode(10) + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5aget", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        return this[i] ' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5aset", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i, v) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        this[i] = v;' + String.fromCharCode(10) + '        return this[i]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5incr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        this[i] = p5incr_(this[i]);' + String.fromCharCode(10) + '        return this[i];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5postincr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        var v = this[i];' + String.fromCharCode(10) + '        this[i] = p5incr_(this[i]);' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5decr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        this[i] = p5decr_(this[i]);' + String.fromCharCode(10) + '        return this[i];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5postdecr", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        var v = this[i];' + String.fromCharCode(10) + '        this[i] = p5decr_(this[i]);' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5aget_array", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        if (this[i] == null) { this[i] = new p5ArrayRef([]) }' + String.fromCharCode(10) + '        return this[i]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5aget_hash", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    value : function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        if (this[i] == null) { this[i] = new p5HashRef({}) }' + String.fromCharCode(10) + '        return this[i]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5unshift", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    configurable : true,' + String.fromCharCode(10) + '    value : function (args) { ' + String.fromCharCode(10) + '        for(var i = args.length-1; i >= 0; i--) {' + String.fromCharCode(10) + '            this.unshift(args[i]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return this.length; ' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + 'Object.defineProperty( Array.prototype, "p5push", {' + String.fromCharCode(10) + '    enumerable : false,' + String.fromCharCode(10) + '    configurable : true,' + String.fromCharCode(10) + '    value : function (args) { ' + String.fromCharCode(10) + '        for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '            this.push(args[i]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return this.length; ' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '});' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5tie_array = function(v, List__) {' + String.fromCharCode(10) + '    var pkg_name = p5str(List__.shift());' + String.fromCharCode(10) + String.fromCharCode(10) + '    var res = p5call(pkg_name, ' + String.fromCharCode(39) + 'TIEARRAY' + String.fromCharCode(39) + ', List__, null);' + String.fromCharCode(10) + '    ' + String.fromCharCode(10) + '    // TODO' + String.fromCharCode(10) + '    ' + String.fromCharCode(10) + '    //  A class implementing an ordinary array should have the following methods:' + String.fromCharCode(10) + '    //      TIEARRAY pkg_name, LIST' + String.fromCharCode(10) + '    //      FETCH this, key' + String.fromCharCode(10) + '    //      STORE this, key, value' + String.fromCharCode(10) + '    //      FETCHSIZE this' + String.fromCharCode(10) + '    //      STORESIZE this, count' + String.fromCharCode(10) + '    //      CLEAR this' + String.fromCharCode(10) + '    //      PUSH this, LIST' + String.fromCharCode(10) + '    //      POP this' + String.fromCharCode(10) + '    //      SHIFT this' + String.fromCharCode(10) + '    //      UNSHIFT this, LIST' + String.fromCharCode(10) + '    //      SPLICE this, offset, length, LIST' + String.fromCharCode(10) + '    //      EXTEND this, count' + String.fromCharCode(10) + '    //      DESTROY this' + String.fromCharCode(10) + '    //      UNTIE this' + String.fromCharCode(10) + '    ' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5aget", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            return p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5aset", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i, value) {' + String.fromCharCode(10) + '            p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, value]);' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5incr", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            var value = p5incr_(p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]));' + String.fromCharCode(10) + '            p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, value]);' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5postincr", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            var value = p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]);' + String.fromCharCode(10) + '            p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, p5incr_(value)]);' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5decr", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            var value = p5decr_(p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]));' + String.fromCharCode(10) + '            p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, value]);' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5postdecr", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            var value = p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]);' + String.fromCharCode(10) + '            p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, p5decr_(value)]);' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    ' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5aget_array", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            var value = p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]);' + String.fromCharCode(10) + '            if (value == null) {' + String.fromCharCode(10) + '                value = new p5ArrayRef([]);' + String.fromCharCode(10) + '                p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, value]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5aget_hash", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) {' + String.fromCharCode(10) + '            var value = p5call(res, ' + String.fromCharCode(39) + 'FETCH' + String.fromCharCode(39) + ', [i]);' + String.fromCharCode(10) + '            if (value == null) {' + String.fromCharCode(10) + '                value = new p5HashRef({});' + String.fromCharCode(10) + '                p5call(res, ' + String.fromCharCode(39) + 'STORE' + String.fromCharCode(39) + ', [i, value]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            return value;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5untie", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (i) { return p5call(res, ' + String.fromCharCode(39) + 'UNTIE' + String.fromCharCode(39) + ', []) }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "shift", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function () { return p5call(res, ' + String.fromCharCode(39) + 'SHIFT' + String.fromCharCode(39) + ', []) }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "pop", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function () { return p5call(res, ' + String.fromCharCode(39) + 'POP' + String.fromCharCode(39) + ', []) }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5unshift", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (args) { ' + String.fromCharCode(10) + '            for(var i = args.length-1; i >= 0; i--) {' + String.fromCharCode(10) + '                p5call(res, ' + String.fromCharCode(39) + 'UNSHIFT' + String.fromCharCode(39) + ', [args[i]]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            return p5call(res, ' + String.fromCharCode(39) + 'FETCHSIZE' + String.fromCharCode(39) + ', []); ' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + '    Object.defineProperty( v, "p5push", {' + String.fromCharCode(10) + '        enumerable : false,' + String.fromCharCode(10) + '        configurable : true,' + String.fromCharCode(10) + '        value : function (args) { ' + String.fromCharCode(10) + '            for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '                p5call(res, ' + String.fromCharCode(39) + 'PUSH' + String.fromCharCode(39) + ', [args[i]]);' + String.fromCharCode(10) + '            }' + String.fromCharCode(10) + '            return p5call(res, ' + String.fromCharCode(39) + 'FETCHSIZE' + String.fromCharCode(39) + ', []); ' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    });' + String.fromCharCode(10) + String.fromCharCode(10) + '    return res;' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + 'var p5untie_array = function(v) {' + String.fromCharCode(10) + '    if (v.hasOwnProperty(' + String.fromCharCode(39) + 'p5untie' + String.fromCharCode(39) + ')) {' + String.fromCharCode(10) + '        var res = v.p5untie();  // call UNTIE' + String.fromCharCode(10) + '        delete v.p5aget;' + String.fromCharCode(10) + '        delete v.p5aset;' + String.fromCharCode(10) + '        delete v.p5incr;' + String.fromCharCode(10) + '        delete v.p5postincr;' + String.fromCharCode(10) + '        delete v.p5decr;' + String.fromCharCode(10) + '        delete v.p5postdecr;' + String.fromCharCode(10) + '        delete v.p5aget_array;' + String.fromCharCode(10) + '        delete v.p5aget_hash;' + String.fromCharCode(10) + '        delete v.p5untie;' + String.fromCharCode(10) + '        delete v.shift;' + String.fromCharCode(10) + '        delete v.pop;' + String.fromCharCode(10) + '        delete v.p5unshift;' + String.fromCharCode(10) + '        delete v.p5push;' + String.fromCharCode(10) + '        return res;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    else {' + String.fromCharCode(10) + '        return null;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '};' + String.fromCharCode(10) + String.fromCharCode(10) + String.fromCharCode(10) + 'function p5ArrayOfAlias(o) {' + String.fromCharCode(10) + String.fromCharCode(10) + '    // this is the structure that represents @_' + String.fromCharCode(10) + '    // _array = [ ref, index,' + String.fromCharCode(10) + '    //            ref, index,' + String.fromCharCode(10) + '    //            ...' + String.fromCharCode(10) + '    //          ]' + String.fromCharCode(10) + String.fromCharCode(10) + '    // TODO - autovivify array cells' + String.fromCharCode(10) + String.fromCharCode(10) + '    this._array_ = o;' + String.fromCharCode(10) + String.fromCharCode(10) + '    this.p5aget = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        return this._array_[i+i][this._array_[i+i+1]]; ' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5aset = function (i, v) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        this._array_[i+i][this._array_[i+i+1]] = v;' + String.fromCharCode(10) + '        return this._array_[i+i][this._array_[i+i+1]]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5incr = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        this._array_[i+i][this._array_[i+i+1]] = p5incr_(this._array_[i+i][this._array_[i+i+1]]);' + String.fromCharCode(10) + '        return this._array_[i+i][this._array_[i+i+1]];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5postincr = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        var v = this._array_[i+i][this._array_[i+i+1]];' + String.fromCharCode(10) + '        this._array_[i+i][this._array_[i+i+1]] = p5incr_(this._array_[i+i][this._array_[i+i+1]]);' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5decr = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        this._array_[i+i][this._array_[i+i+1]] = p5decr_(this._array_[i+i][this._array_[i+i+1]]);' + String.fromCharCode(10) + '        return this._array_[i+i][this._array_[i+i+1]];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5postdecr = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        var v = this._array_[i+i][this._array_[i+i+1]];' + String.fromCharCode(10) + '        this._array_[i+i][this._array_[i+i+1]] = p5decr_(this._array_[i+i][this._array_[i+i+1]]);' + String.fromCharCode(10) + '        return v;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5aget_array = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        if (this._array_[i+i][this._array_[i+i+1]] == null) {' + String.fromCharCode(10) + '            this._array_[i+i][this._array_[i+i+1]] = new p5ArrayRef([])' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return this._array_[i+i][this._array_[i+i+1]]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5aget_hash = function (i) {' + String.fromCharCode(10) + '        if (i < 0) { i =  this.length + i };' + String.fromCharCode(10) + '        if (this._array_[i+i][this._array_[i+i+1]] == null) {' + String.fromCharCode(10) + '            this._array_[i+i][this._array_[i+i+1]] = new p5HashRef({})' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return this._array_[i+i][this._array_[i+i+1]]' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5unshift = function (args) { ' + String.fromCharCode(10) + '        for(var i = args.length-1; i >= 0; i--) {' + String.fromCharCode(10) + '            this.unshift(0);' + String.fromCharCode(10) + '            this.unshift([args[i]]);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return this._array_.length / 2; ' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.p5push = function (args) { ' + String.fromCharCode(10) + '        for(var i = 0; i < args.length; i++) {' + String.fromCharCode(10) + '            this.push([args[i]]);' + String.fromCharCode(10) + '            this.push(0);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '        return this._array_.length / 2; ' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.shift = function () { ' + String.fromCharCode(10) + '        var v0 = this._array_.shift();' + String.fromCharCode(10) + '        return v0[this._array_.shift()];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    this.pop = function () { ' + String.fromCharCode(10) + '        var v1 = this._array_.pop();' + String.fromCharCode(10) + '        var v0 = this._array_.pop();' + String.fromCharCode(10) + '        return v0[v1];' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + String.fromCharCode(10)))], p5want));
			};
			tmp4065._prototype_ = null;
			return tmp4065
		})());
		1;
	})();
	// use Perlito5::Javascript2::Array
;
	(function () {
		null;
		p5make_package('Perlito5::Javascript2::CORE');
		p5typeglob_set('Perlito5::Javascript2::CORE', 'emit_javascript2', (function () {
			var tmp4066;
			tmp4066 = function (List__, p5want) {
				return (p5context([(('//' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// lib/Perlito5/Javascript2/CORE.js' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// CORE functions for "Perlito" Perl5-in-Javascript2' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// AUTHORS' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Flavio Soibelmann Glock  fglock@gmail.com' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// COPYRIGHT' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// Copyright 2009, 2010, 2011, 2012 by Flavio Soibelmann Glock and others.' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// This program is free software; you can redistribute it and/or modify it' + String.fromCharCode(10) + '// under the same terms as Perl itself.' + String.fromCharCode(10) + '//' + String.fromCharCode(10) + '// See http://www.perl.com/perl/misc/Artistic.html' + String.fromCharCode(10) + String.fromCharCode(10) + 'var CORE = p5pkg.CORE;' + String.fromCharCode(10) + String.fromCharCode(10) + 'var isNode = typeof require != "undefined";' + String.fromCharCode(10) + String.fromCharCode(10) + String.fromCharCode(10) + 'if (isNode) {' + String.fromCharCode(10) + '    try {' + String.fromCharCode(10) + '        var sleep = require("sleep");' + String.fromCharCode(10) + '        CORE.sleep = function(List__) {' + String.fromCharCode(10) + '            var n = p5num(List__[0]) || 1;' + String.fromCharCode(10) + '            sleep.usleep(n * 1000000);  // sleep for n seconds (1 second is 1000000 microseconds)' + String.fromCharCode(10) + '            return n;' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    catch (err) {' + String.fromCharCode(10) + '        CORE.sleep = function(List__) {' + String.fromCharCode(10) + '            CORE.die("sleep() function failed. Maybe you need ' + String.fromCharCode(39) + 'npm install sleep' + String.fromCharCode(39) + '?' + String.fromCharCode(92) + 'n" + err);' + String.fromCharCode(10) + '        }' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + 'if (!CORE.sleep) {' + String.fromCharCode(10) + '    CORE.sleep = function(List__) {' + String.fromCharCode(10) + '        CORE.die("sleep() not supported for this platform");' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'CORE.time = function(List__) {' + String.fromCharCode(10) + '    return CORE.int([Date.now() / 1000]);' + String.fromCharCode(10) + '}' + String.fromCharCode(10)) + (('var _fmt_date = function(date) {' + String.fromCharCode(10) + '    return [' + String.fromCharCode(39) + 'Sun' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Mon' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Tue' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Wed' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Thu' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Fri' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Sat' + String.fromCharCode(39) + '][date.getDay()] + ' + String.fromCharCode(39) + ' ' + String.fromCharCode(39) + ' +' + String.fromCharCode(10) + '        [' + String.fromCharCode(39) + 'Jan' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Feb' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Mar' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Apr' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'May' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Jun' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Jul' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Aug' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Sep' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Oct' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Nov' + String.fromCharCode(39) + ',' + String.fromCharCode(39) + 'Dec' + String.fromCharCode(39) + '][date.getMonth()] + ' + String.fromCharCode(39) + ' ' + String.fromCharCode(39) + ' +' + String.fromCharCode(10) + '        date.getDate() + ' + String.fromCharCode(39) + ' ' + String.fromCharCode(39) + ' + ' + String.fromCharCode(10) + '        CORE.sprintf([ "%02d:%02d:%02d ", date.getHours(), date.getMinutes(), date.getSeconds() ]) +' + String.fromCharCode(10) + '        date.getFullYear();' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + 'var _list_date = function(date) {' + String.fromCharCode(10) + '    var year_start = new Date(date);' + String.fromCharCode(10) + '    year_start.setMonth(0, 1);' + String.fromCharCode(10) + '    var year_day = Math.round((date-year_start)/8.64e7);' + String.fromCharCode(10) + String.fromCharCode(10) + '    var isdst = 0;  // not implemented' + String.fromCharCode(10) + String.fromCharCode(10) + '    return [date.getSeconds(),date.getMinutes(),date.getHours(),date.getDate(),' + String.fromCharCode(10) + '        date.getMonth(),date.getFullYear()-1900,date.getDay(),' + String.fromCharCode(10) + '        year_day,' + String.fromCharCode(10) + '        isdst' + String.fromCharCode(10) + '    ];' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + 'CORE.localtime = function(List__, want) {' + String.fromCharCode(10) + '    var n = List__.length ? p5num(List__[0]) : CORE.time() ;' + String.fromCharCode(10) + '    var date = new Date(n*1000);' + String.fromCharCode(10) + '    if (!want) {' + String.fromCharCode(10) + '        return _fmt_date(date);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return _list_date(date);' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + 'CORE.gmtime = function(List__, want) {' + String.fromCharCode(10) + '    var n = List__.length ? p5num(List__[0]) : CORE.time() ;' + String.fromCharCode(10) + '    var ofs = new Date().getTimezoneOffset() * 60;' + String.fromCharCode(10) + '    var date = new Date((n + ofs)*1000);' + String.fromCharCode(10) + '    if (!want) {' + String.fromCharCode(10) + '        return _fmt_date(date);' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    return _list_date(date);' + String.fromCharCode(10) + '}' + String.fromCharCode(10) + String.fromCharCode(10) + 'CORE.bless = function(List__) {' + String.fromCharCode(10) + '    var o        = List__[0];' + String.fromCharCode(10) + '    var pkg_name = List__[1];' + String.fromCharCode(10) + '    if (typeof pkg_name === "object") {' + String.fromCharCode(10) + '        // bless {}, Class' + String.fromCharCode(10) + '        o._class_ = pkg_name;' + String.fromCharCode(10) + '        return o;' + String.fromCharCode(10) + '    }' + String.fromCharCode(10) + '    if (!p5pkg.hasOwnProperty(pkg_name)) {' + String.fromCharCod