#!/usr/bin/perl -w
##

package Bundle::Modules::CPAN::Unstable;

use 5.005;

our $VERSION = 2006.0604; ## (YYYY.MMDD)

##
## Bundle::Modules::CPAN::Unstable
##

package main;

use strict;

use warnings;

require Shell;

require XML::Dumper;

require CPANPLUS::Backend;

require Bundle::Modules::Test::Reporter;

my $context = 'Bundle::Modules::CPAN::Unstable';

$context =~ m/::(\w)$/;

$context = lc( $1 );

$context = 'stable' if ( $context ne 'unstable' );

my $xml = XML::Dumper->new();

$xml->dtd();

my $sh = Shell->new();

my $plus = CPANPLUS::Backend->new( 'conf' => { 'no_update'  => 0,
                                                 'allow_build_interactivity' => 1,
                                                 'verbose' => 1,
                                               } );

my $conf = $plus->configure_object();

$conf->set_conf( 'force' => 0 );

my $osname = $^O;

my $prmt = "[__START__] May I report Security and Stability status via email, about the installations we perform on your $osname system?";

my $perm = ( $conf->get_conf( 'cpantest' ) )? 'Y' : 'N';

$conf->set_conf( 'cpantest' => 0 );

$conf->set_conf( 'prereqs' => 3 ); ## follow

$conf->set_conf( 'signature' => 1 );

$conf->set_conf( 'skiptest' => 0 );

$conf->set_conf( 'timeout' => 1 );

if ( defined( $ENV{'TEST_POD'} ) && ( $ENV{'TEST_POD'} == 1 ) )
{

}
else
{
   $plus->reload_indices( 'update_source' => 1, 'verbose' => 1 );

} ## end if

eval
{
   local $SIG{'ALRM'} = sub { die( "alarm\n" ) };

   alarm 30;

   $perm = ExtUtils::MakeMaker::prompt( $prmt, $perm );

   alarm 0;

}; ## end eval

if ( $@ )
{
   ##
   ## timeout
   ##
   die( $@ ) unless ( $@ eq "alarm\n" );

   print "\n";

} ## end if

if ( $perm =~ /^y/i )
{
   $perm = 1;

}
else
{
   $perm = 0;

} ## end if

my $reporter = Bundle::Modules::Test::Reporter->new(
   'grade' => 'unstable',
   'distribution' => 'TBD',
   'comments' => 'Generated by Bundle::Modules::CPAN::Unstable.',
   'via' => 'Bundle::Modules::CPAN::Unstable 2006.0604'

   );

my @module = ();



push( @module, 'Win32::Wildcard' );
push( @module, 'MacPerl::AppleScript' );
push( @module, 'SAS::Parser' );
push( @module, 'Bryar::DataSource::SVNRepos' );
push( @module, 'Win32::Printer' );
push( @module, 'Win32::PerfCounter' );
push( @module, 'Jifty' );
push( @module, 'Wx::Perl::CheckBoxWizardPage' );
push( @module, 'Win32::IPHelper' );
push( @module, 'Business::AU::ACN' );
push( @module, 'XML::XBEL' );
push( @module, 'Win32::GUI::HyperLink' );
push( @module, 'Date::Language::Hungarian' );
push( @module, 'WWW::Google::SiteMap' );
push( @module, 'Net::RawIP' );
push( @module, 'Win32::File::Ver' );
push( @module, 'Win32::MIDI' );
push( @module, 'Dialog' );
push( @module, 'Net::AIM' );
push( @module, 'Net::Z3950' );
push( @module, 'PDF::Xtract' );
push( @module, 'Oracle::Schema' );
push( @module, 'SVK' );
push( @module, 'Config::Objective' );
push( @module, 'Mail::Summary' );
push( @module, 'AxKit::XSP::MD5' );
push( @module, 'AI::NeuralNet::SOM' );
push( @module, 'Acme::Raise_my_kwalitee' );
push( @module, 'Net::Traceroute6' );
push( @module, 'Myco::Core::Person' );
push( @module, 'Win32::MMF' );
push( @module, 'AudioCD::Mac' );
push( @module, 'Win32::SAPI4' );
push( @module, 'Win32::Die' );
push( @module, 'Net::Subnet::Count' );
push( @module, 'SQL::Translator' );
push( @module, 'DateTime::Format::Mail' );
push( @module, 'Device::Serdisp' );
push( @module, 'X::Osd' );
push( @module, 'Win32::EventLog::Carp' );
push( @module, 'Number::WithError::LaTeX' );
push( @module, 'BTRIEVE::Native' );
push( @module, 'XML::OPML::SimpleGen' );
push( @module, 'VLGal::Directory' );
push( @module, 'App::ErrorCalculator' );
push( @module, 'Win32::ASP::DB' );
push( @module, 'Win32::UTCFileTime' );
push( @module, 'Gtk2::Spell' );
push( @module, 'Term::Interact' );
push( @module, 'Palm::DiabetesPilot' );
push( @module, 'Business::CSI' );
push( @module, 'Java::Swing' );
push( @module, 'DCOP::Amarok::Playlist' );
push( @module, 'Win32::AbsPath' );
push( @module, 'DBD::EmpressNet' );
push( @module, 'Win32::File::VersionInfo' );
push( @module, 'Perl6::Pugs' );
push( @module, 'Win32::AD::User' );
push( @module, 'Mac::Apps::PBar' );
push( @module, 'Gtk2::Ex::DBITableFilter' );
push( @module, 'Math::Calculus::NewtonRaphson' );
push( @module, 'Astro::SkyCat' );
push( @module, 'RRDTool::OO' );
push( @module, 'Solaris::Lgrp' );
push( @module, 'Inline::MzScheme' );
push( @module, 'Win32::ToolHelp' );
push( @module, 'MMM::OracleDump' );
push( @module, 'Catalyst::Model::Xapian' );
push( @module, 'SNMP::APCUPS' );
push( @module, 'Joystick' );
push( @module, 'Image::Shoehorn' );
push( @module, 'Class::DBI::DB2' );
push( @module, 'c_plus_plus' );
push( @module, 'XML::Handler::AxPoint' );
push( @module, 'MIME::Base64' );
push( @module, 'Catalog' );
push( @module, 'URIC' );
push( @module, 'Win32::Console::ANSI' );
push( @module, 'AxKit::Provider::HTML' );
push( @module, 'Win32API::File::Time' );
push( @module, 'DBIx::Class::Loader::ADO' );
push( @module, 'PowerBuilder::ORCA' );
push( @module, 'Wx::Metafile' );
push( @module, 'DBD::TSM' );
push( @module, 'Pilot' );
push( @module, 'Repository::Simple' );
push( @module, 'Language::Befunge' );
push( @module, 'Courier::Filter' );
push( @module, 'Win32::GUI::SplashScreen' );
push( @module, 'Lingua::EN::Keywords' );
push( @module, 'Catalyst::Model::DBIC' );
push( @module, 'Games::Go::SGF2misc' );
push( @module, 'Win32API::ToolHelp' );
push( @module, 'Scripting' );
push( @module, 'DBIx::MSSQLReporter' );
push( @module, 'SGML::SPGroveBuilder' );
push( @module, 'Video::Capture::V4l' );
push( @module, 'WWW::Scraper::ISBN::Yahoo_Driver' );
push( @module, 'File::HomeDir::Win32' );
push( @module, 'Image::Shoehorn::Gallery' );
push( @module, 'DBD::ADO' );
push( @module, 'XML::WBXML' );
push( @module, 'Win32::InternetExplorer::Window' );
push( @module, 'Algorithm::PageRank' );
push( @module, 'Catalyst::Plugin::Authentication::Credential::Hatena' );
push( @module, 'Win32::Excel::Refresh' );
push( @module, 'SVN::Pusher' );
push( @module, 'Pod::Tidy' );
push( @module, 'Log::Accounting::SVK' );
push( @module, 'CGI::Application::Plugin::HtmlTidy' );
push( @module, 'POE::Component::Client::Keepalive' );
push( @module, 'Win32::Palm::Install' );
push( @module, 'forks::BerkeleyDB' );
push( @module, 'Email::Store::Plucene' );
push( @module, 'Data::Dumper' );
push( @module, 'Net::Z3950::RadioMARC' );
push( @module, 'OpenGuides::Statistics' );
push( @module, 'Win32::RASE' );
push( @module, 'Class::DBI::Plugin::Backtickify' );
push( @module, 'Audio::Ecasound' );
push( @module, 'DB::Ent' );
push( @module, 'Mail::MsgStore' );
push( @module, 'DBD::Sybase' );
push( @module, 'Geo::Vector' );
push( @module, 'DateTime::Format::RSS' );
push( @module, 'R3' );
push( @module, 'Win32::Net::Session' );
push( @module, 'Net::OpenID::Consumer' );
push( @module, 'Astro::FITS::CFITSIO::Simple' );
push( @module, 'Curses::UI::DelimitedTextViewer' );
push( @module, 'POE::Component::Win32::EventLog' );
push( @module, 'NIS::DBM' );
push( @module, 'POE::Component::Cron' );
push( @module, 'Win32::StreamNames' );
push( @module, 'RT::Authen::OpenID' );
push( @module, 'PDL::Parallel::MPI' );
push( @module, 'Algorithm::SVMLight' );
push( @module, 'Perf::ARM' );
push( @module, 'POE::Component::Client::Dashboard' );
push( @module, 'DBIx::Procedure::Oracle' );
push( @module, 'MIME::Lite::TT::Japanese' );
push( @module, 'Math::Vector' );
push( @module, 'CAM::Template' );
push( @module, 'POE::Component::NomadJukebox' );
push( @module, 'Win32::GUI::Scintilla' );
push( @module, 'Acme::MJD' );
push( @module, 'Solaris::Kvm' );
push( @module, 'Env::Modulecmd' );
push( @module, 'Catalyst::Plugin::FormValidator::Simple::OwnCheck' );
push( @module, 'WWW::StreetMap' );
push( @module, 'Win32::ActAcc' );
push( @module, 'Win32::Process::Info' );
push( @module, 'CAD::Drawing::IO::PostScript' );
push( @module, 'JavaScript::MochiKit' );
push( @module, 'IO::KQueue' );
push( @module, 'CIAO::Lib::Param' );
push( @module, 'Mac::Carbon' );
push( @module, 'CGI::Untaint::hostname' );
push( @module, 'IMDB::Movie' );
push( @module, 'Win32::mIRC' );
push( @module, 'Win32::StrictFileNames' );
push( @module, 'Lab::Instrument' );
push( @module, 'ThreatNet::Topic' );
push( @module, 'HTTP::ProxyPAC' );
push( @module, 'FFmpeg' );
push( @module, 'Win32::CtrlGUI' );
push( @module, 'Win32::MCI::Basic' );
push( @module, 'CAD::Drawing::Template' );
push( @module, 'Hardware::Verilog::Parser' );
push( @module, 'Win32API::Registry' );
push( @module, 'CAD::Drawing::IO::PgDB' );
push( @module, 'Rudesind' );
push( @module, 'Pod::LaTeX::TPR' );
push( @module, 'Net::MSN' );
push( @module, 'WWW::Scraper::ISBN::TWKingstone_Driver' );
push( @module, 'Device::QuickCam' );
push( @module, 'IMAPGet' );
push( @module, 'WWW::Scraper::ISBN::TWYlib_Driver' );
push( @module, 'Statistics::Gap' );
push( @module, 'XML::Simple::Tree' );
push( @module, 'Image::Magick::Chart' );
push( @module, 'Locale::Framework::wxLocale' );
push( @module, 'Win32::GUI::XMLBuilder' );
push( @module, 'Net::Address::IPv4::Local' );
push( @module, 'Math::Units::PhysicalValue' );
push( @module, 'Filesys::CygwinPaths' );
push( @module, 'Text::EP3::Verilog' );
push( @module, 'DynaPage::Document::ext::include' );
push( @module, 'Test::Simple' );
push( @module, 'GnuPG' );
push( @module, 'Mac::Apps::Launch' );
push( @module, 'Win32::GUI::Grid' );
push( @module, 'Acme::Octarine' );
push( @module, 'Wx::Perl::BrowseButton' );
push( @module, 'Gtk2::MozEmbed' );
push( @module, 'PDF::FromHTML' );
push( @module, 'RCU' );
push( @module, 'Gtk2::GladeXML' );
push( @module, 'OS2::WinObject' );
push( @module, 'SML::Document' );
push( @module, 'MPEG::LibMPEG3' );
push( @module, 'Jabber::mod_perl' );
push( @module, 'Algorithm::HITS' );
push( @module, 'PerlIO::via::QuotedPrint' );
push( @module, 'Sun::Solaris::Ucred' );
push( @module, 'Win32::File::Summary' );
push( @module, 'Win32::TieRegistry::PMVersionInfo' );
push( @module, 'DataFax::StudyDB' );
push( @module, 'Video::Xine' );
push( @module, 'Win32::TieRegistry' );
push( @module, 'Samba::LDAP' );
push( @module, 'WWW::Shorten::0rz' );
push( @module, 'Verity::Collection' );
push( @module, 'DIME::Tools' );
push( @module, 'Term::Size::Win32' );
push( @module, 'CAD::Drawing::IO::OpenDWG' );
push( @module, 'WWW::Blog::Metadata::AccountAutoDiscovery' );
push( @module, 'Gnome2::Vte' );
push( @module, 'Win32::GUI::AxWindow' );
push( @module, 'Win32::MCI::CD' );
push( @module, 'Rosetta::Engine::Generic' );
push( @module, 'Net::Jabber::Loudmouth' );
push( @module, 'vpopmail' );
push( @module, 'Win32::IPConfig' );
push( @module, 'Win32::GuiTest' );
push( @module, 'Unicode::Decompose' );
push( @module, 'Querylet::Output::Excel::OLE' );
push( @module, 'SVN::Web' );
push( @module, 'Math::BigInt' );
push( @module, 'Net::Whois' );
push( @module, 'XML::GDOME::XSLT' );
push( @module, 'Gtk2::SourceView' );
push( @module, 'RT::Extension::BrandedQueues' );
push( @module, 'Mac::OSA::Simple' );
push( @module, 'Sun::Solaris::Privilege' );
push( @module, 'POE::Component::Daemon::Win32' );
push( @module, 'PBJ::JNI' );
push( @module, 'CGI::Session::DB2' );
push( @module, 'Oracle::DML' );
push( @module, 'Mail::SpamCannibal' );
push( @module, 'CGI::AppBuilder::Frame' );
push( @module, 'Win32::MSI::DB' );
push( @module, 'Win32::SqlServer' );
push( @module, 'Authen::Krb5::KDB' );
push( @module, 'Net::SMTP::Retryable' );
push( @module, 'Win32::MSAgent' );
push( @module, 'Movie::Info' );
push( @module, 'Win32API::Process' );
push( @module, 'XML::STX' );
push( @module, 'DBD::ASAny' );
push( @module, 'PerlMaple' );
push( @module, 'Pg::Simple' );
push( @module, 'WWW::ImageSpool' );
push( @module, 'JDBC' );
push( @module, 'Win32::MBCS' );
push( @module, 'Tk::Win32RotLabel' );
push( @module, 'MacOSX::File' );
push( @module, 'Plagger' );
push( @module, 'Net::DPAP::Server' );
push( @module, 'AxKit::XSP::Cookie' );
push( @module, 'POE::Component::Win32::Service' );
push( @module, 'Image::DS9' );
push( @module, 'AFS::Monitor' );
push( @module, 'Algorithm::Tree::NCA' );
push( @module, 'Win32::Resources' );
push( @module, 'Logfile::Radius' );
push( @module, 'Wx::Package::Win32' );
push( @module, 'POE::Component::CD::Detect' );
push( @module, 'POE::Session::GladeXML2' );
push( @module, 'Win32::Hardlink' );
push( @module, 'Lingua::MAF' );
push( @module, 'Task::SOSA' );
push( @module, 'Benchmark::Harness' );
push( @module, 'Win32::MachineInfo' );
push( @module, 'NetAddr::IP' );
push( @module, 'CPAN::YACSmoke::Plugin::WebList' );
push( @module, 'Compress::LZO' );
push( @module, 'SVK::Log::Filter::Babelfish' );
push( @module, 'Linux::Svgalib' );
push( @module, 'DBIx::glueHTML' );
push( @module, 'Sys::Syslog' );
push( @module, 'Net::Goofey' );
push( @module, 'Net::MDNS::Server' );
push( @module, 'IBM::LoadLeveler' );
push( @module, 'Tree::M' );
push( @module, 'Games::Chess::Coverage' );
push( @module, 'Multimedia::SDP::SinisterSdp' );
push( @module, 'Mhash' );
push( @module, 'Gtk2::TrayIcon' );
push( @module, 'Wx::Perl::FSHandler::UNC' );
push( @module, 'Catalyst::View::PHP' );
push( @module, 'Win32::API::OutputDebugString' );
push( @module, 'Krb5' );
push( @module, 'Authen::Bitcard' );
push( @module, 'VSS' );
push( @module, 'AxKit::XSP::WebUtils' );
push( @module, 'BerkDB' );
push( @module, 'Math::Symbolic::Custom::LaTeXDumper' );
push( @module, 'POE::Component::StackedProcessor' );
push( @module, 'WWW::Promotion' );
push( @module, 'Games::Go::SGF2misc::SVG' );
push( @module, 'Algorithm::RabinKarp' );
push( @module, 'Geo::Point' );
push( @module, 'Win32::FileTime' );
push( @module, 'Parallel::MPI' );
push( @module, 'Win32::IE::Mechanize' );
push( @module, 'Slash::OurNet' );
push( @module, 'Audio::CD' );
push( @module, 'Win32::ASP::Extras' );
push( @module, 'Win32::SerialPort' );
push( @module, 'Acme::PGPSign' );
push( @module, 'Ctype' );
push( @module, 'TM' );
push( @module, 'URI::Fetch::SimpleCache' );
push( @module, 'HOP::Parser' );
push( @module, 'CGI::Wiki::Plugin::RSS::Reader' );
push( @module, 'Slash::Gallery' );
push( @module, 'Net::SSH2' );
push( @module, 'Class::Delay' );
push( @module, 'SVN::Push' );
push( @module, 'PDF::FDF::Simple' );
push( @module, 'Term::Caca' );
push( @module, 'Proc::Fork' );
push( @module, 'DBIx::Recordset::Playground' );
push( @module, 'Net::DNS::Method' );
push( @module, 'Image::PNGwriter' );
push( @module, 'Win32::SearchPath' );
push( @module, 'HTML::Doctype' );
push( @module, 'HTML::HTMLDoc' );
push( @module, 'Kwiki::Search::Plucene' );
push( @module, 'DBD::Solid' );
push( @module, 'Win32::CaptureIE' );
push( @module, 'OurNet' );
push( @module, 'Date::Holidays' );
push( @module, 'Win32::Screenshot' );
push( @module, 'Gtk2::Ex::Simple::Menu' );
push( @module, 'Win32::FileOp' );
push( @module, 'Haver::Core' );
push( @module, 'PDL::IO::Grib' );
push( @module, 'Number::WithError' );
push( @module, 'HTTPD::ADS' );
push( @module, 'Devel::Graph' );
push( @module, 'Graphics::PLplot' );
push( @module, 'RT::Extension::ServiceUpdates' );
push( @module, 'Math::Symbolic::Custom::Transformation' );
push( @module, 'Win32::FetchCommand' );
push( @module, 'Net::Whois::RIPE::Syncupdates' );
push( @module, 'Postgres' );
push( @module, 'MVS::VBFile' );
push( @module, 'Tk::WinPrint' );
push( @module, 'Math::TrulyRandom' );
push( @module, 'HTTP::QuickBase' );
push( @module, 'Win32::PingICMP' );
push( @module, 'NPRG' );
push( @module, 'Gnome2::VFS' );
push( @module, 'Class::Null' );
push( @module, 'Maypole::Redirect' );
push( @module, 'WWW::Scraper::ISBN::TWCwbook_Driver' );
push( @module, 'Mobile::Wurfl' );
push( @module, 'RTx::AuthTool' );
push( @module, 'Win32API::File' );
push( @module, 'Image::ThousandWords' );
push( @module, 'Speech::Rsynth' );
push( @module, 'AIX::ODM' );
push( @module, 'Tk::DBI::DBGrid' );
push( @module, 'Bio::SCF' );
push( @module, 'Net::Arping' );
push( @module, 'Win32::Scanner::EZTWAIN' );
push( @module, 'Glib::Event' );
push( @module, 'SGML::Parser::OpenSP' );
push( @module, 'PDFREP' );
push( @module, 'Sys::Virt' );
push( @module, 'Win32::IIS::Admin' );
push( @module, 'Win32::Locale' );
push( @module, 'Net::FeedBurner' );
push( @module, 'Net::BGP::Router' );
push( @module, 'SNMP::Multi' );
push( @module, 'Geo::Proj4' );
push( @module, 'SGI::Syssgi' );
push( @module, 'File::Info' );
push( @module, 'XML::Feed::JavaScript' );
push( @module, 'XML::SAXDriver::Sablotron' );
push( @module, 'CGI::Application::Plugin::Output::XSV' );
push( @module, 'Dua' );
push( @module, 'File::Searcher' );
push( @module, 'PCX::Loader' );
push( @module, 'Gtk2' );
push( @module, 'XML::Handler::Machine2GraphViz' );
push( @module, 'Persistent::Sybase' );
push( @module, 'Aw' );
push( @module, 'Wx' );
push( @module, 'Win32::NetPacket' );
push( @module, 'SVN::Notify' );
push( @module, 'File::Headerinfo' );
push( @module, 'Tk::Calculator::RPN::HP' );
push( @module, 'Db::Documentum' );
push( @module, 'mod_perl' );
push( @module, 'Class::Visitor' );
push( @module, 'Wx::Perl::Throbber' );
push( @module, 'Image::Epeg' );
push( @module, 'Inline::WSC' );
push( @module, 'POE::Component::Spread' );
push( @module, 'Term::Sample' );
push( @module, 'Pogo' );
push( @module, 'Pipe' );
push( @module, 'Win32::GUI::DIBitmap' );
push( @module, 'Gnome2' );
push( @module, 'Math::BigRat' );
push( @module, 'Win32::Font::NameToFile' );
push( @module, 'MCrypt' );
push( @module, 'Win32::ShutDown' );
push( @module, 'Astro::WCS::LibWCS' );
push( @module, 'Jail' );
push( @module, 'RT::View::Tree' );
push( @module, 'OpenCA::DBI' );
push( @module, 'Graph::SocialMap' );
push( @module, 'AI::NeuralNet::Kohonen::Demo::RGB' );
push( @module, 'Dict::FSA' );
push( @module, 'Authen::Simple::NIS' );
push( @module, 'TeX::DVI' );
push( @module, 'RPM::Make::Simple' );
push( @module, 'UnixODBC' );
push( @module, 'Term::Screen::Win32' );
push( @module, 'SML::Block' );
push( @module, 'Win32::Registry::File' );
push( @module, 'Class::DBI::Loader::Sybase' );
push( @module, 'Tk::ToolBar' );
push( @module, 'SetDualVar' );
push( @module, 'Net::BitTorrent::PeerPacket' );
push( @module, 'Geo::Coordinates::Convert' );
push( @module, 'Wx::WidgetMaker' );
push( @module, 'Chart::PNGgraph' );
push( @module, 'JavaScript::Code' );
push( @module, 'Regexp' );
push( @module, 'WWW::WebStore::TinyURL' );
push( @module, 'Makefile::GraphViz' );
push( @module, 'Win32::SharedFileOpen' );
push( @module, 'AxKit::XSP::Wiki' );
push( @module, 'Audio::MPC' );
push( @module, 'Sun::Solaris::Task' );
push( @module, 'Dicop::Proxy' );
push( @module, 'DirDB::FTP' );
push( @module, 'Net::Hesiod' );
push( @module, 'Wiki::Gateway' );
push( @module, 'Tree::Suffix' );
push( @module, 'Net::Z3950::SimpleServer' );
push( @module, 'Term::ReadPassword::Win32' );
push( @module, 'Mail::Cclient' );
push( @module, 'Buscador' );
push( @module, 'Catalyst::Plugin::Authentication::OpenID' );
push( @module, 'Win32::NetName' );
push( @module, 'Catalyst::View::REST::YAML' );
push( @module, 'Lingua::LinkParser::MatchPath' );
push( @module, 'Wx::Perl::ListCtrl' );
push( @module, 'Win32::CryptData' );
push( @module, 'DBIx::Tree::NestedSet' );
push( @module, 'Net::SFTP::Recursive' );
push( @module, 'OS2::Proc' );
push( @module, 'Win32::Word::Writer' );
push( @module, 'WWW::Shorten' );
push( @module, 'Fax::Hylafax::Client' );
push( @module, 'File::BSDGlob' );
push( @module, 'MPE::IMAGE' );
push( @module, 'SNMP::Simple' );
push( @module, 'DBO' );
push( @module, 'Fax::DataFax::DateTime' );
push( @module, 'Win32::SoundRec' );
push( @module, 'GFL' );
push( @module, 'Business::UTV' );
push( @module, 'CNC::Cog' );
push( @module, 'CGI::Application::Framework' );
push( @module, 'Gnome2::GConf' );
push( @module, 'Palm::ThinkDB' );
push( @module, 'Win32::DriveInfo' );
push( @module, 'Win32::Autoglob' );
push( @module, 'Wais' );
push( @module, 'DBD::Illustra' );
push( @module, 'CyberSource' );
push( @module, 'XML::Feed' );
push( @module, 'Win32API::Const' );
push( @module, 'Win32::IEAutomation' );
push( @module, 'Win32::SAPI5' );
push( @module, 'Persistent::LDAP' );
push( @module, 'Win32::GUI' );
push( @module, 'Wx::GLCanvas' );
push( @module, 'Graph::Writer::GraphViz' );
push( @module, 'Math::Matlab::Engine' );
push( @module, 'XML::Xerces::BagOfTricks' );
push( @module, 'Geo::Coordinates::Parser' );
push( @module, 'Net::APP' );
push( @module, 'Win32::Process::List' );
push( @module, 'Passwd::Solaris' );
push( @module, 'Devel::Maypole' );
push( @module, 'Catalyst::Plugin::Authentication::Credential::TypeKey' );
push( @module, 'Win32::ShellExt' );
push( @module, 'Win32API::GUID' );
push( @module, 'CGI::Application::Plugin::ViewSource' );
push( @module, 'Mozilla::Mechanize' );
push( @module, 'Template::Plugin::Java' );
push( @module, 'Bot::BasicBot::Pluggable::Module::SimpleBlog' );
push( @module, 'Event::Lib' );
push( @module, 'Net::SXIP::Membersite' );
push( @module, 'WordNet::Similarity' );
push( @module, 'Sys::Gamin' );
push( @module, 'POE::Component::Player::Slideshow' );
push( @module, 'XML::Generator::RSS10::ipsv' );
push( @module, 'GraphViz' );
push( @module, 'AI::NNEasy' );
push( @module, 'Gtk2::TrayManager' );
push( @module, 'Net::SLP' );
push( @module, 'TableMap' );
push( @module, 'Tie::Cache::LRU::Expires' );
push( @module, 'Regexp::Fields' );
push( @module, 'DataFax' );
push( @module, 'GCT::XSP::ActionTaglib' );
push( @module, 'MKDoc::Authz' );
push( @module, 'Net::RRP' );
push( @module, 'WordNet::SenseRelate::WordToSet' );
push( @module, 'Win32::OLE::OPC' );
push( @module, 'Search::Z3950' );
push( @module, 'Log::Dispatch::Win32EventLog' );
push( @module, 'FrameNet::WordNet::Detour' );
push( @module, 'GraphViz::Zone' );
push( @module, 'Win32::Fmode' );
push( @module, 'Tie::Cache' );
push( @module, 'Gtk2::Ex::Simple::List' );
push( @module, 'Mac::Apps::Anarchie' );
push( @module, 'Convert::Recode' );
push( @module, 'Audio::RaveMP' );
push( @module, 'Data::Validate::URI' );
push( @module, 'Win32::Filenames' );
push( @module, 'Win32::Socketpair' );
push( @module, 'Dict::Lexed' );
push( @module, 'punctuation' );
push( @module, 'AIX::SysInfo' );
push( @module, 'X11::Fvwm' );
push( @module, 'CGI::XML' );
push( @module, 'OpenCA::DB' );
push( @module, 'VCS::Vss' );
push( @module, 'IPC::SysV' );
push( @module, 'IP::Unique' );
push( @module, 'Graph::Dependency' );
push( @module, 'Win32::Sound' );
push( @module, 'Parallel::Queue' );
push( @module, 'Wx::Mozilla' );
push( @module, 'Image::ButtonMaker' );
push( @module, 'bignum' );
push( @module, 'Sub::ParamLoader' );
push( @module, 'Class::DBI::Loader::Informix' );
push( @module, 'Data::XML::Variant' );
push( @module, 'Proc::Application' );
push( @module, 'Lingua::LinkParser::FindPath' );
push( @module, 'Win32::Process::Memory' );
push( @module, 'CPAN::Forum' );
push( @module, 'LWPx::ParanoidAgent' );
push( @module, 'Win32::Exe' );
push( @module, 'OpenGL::GLM' );
push( @module, 'Luka' );
push( @module, 'Tanker' );
push( @module, 'Spread::Session' );
push( @module, 'NetAddr::IP::Count' );
push( @module, 'Win32::MultiLanguage' );
push( @module, 'Net::NISplusTied' );
push( @module, 'Text::PORE' );
push( @module, 'Language::Homespring::Visualise::GraphViz' );
push( @module, 'Audio::Mad' );
push( @module, 'GraphViz::Data::Structure' );
push( @module, 'Speech::Recognizer::ViaVoice' );
push( @module, 'Chart::Plot::Annotated' );
push( @module, 'Lingua::FeatureMatrix' );
push( @module, 'Wx::SimplePlotter' );
push( @module, 'Image::RGBA' );
push( @module, 'Statistics::Lmoments' );
push( @module, 'DBD::PgSPI' );
push( @module, 'Tie::LDAP' );
push( @module, 'Win32::AD::Control::DirSync' );
push( @module, 'Template::Plugin::GnuPG' );
push( @module, 'Business::Travel::OTA' );
push( @module, 'Win32::DirSize' );
push( @module, 'Be::Attribute' );
push( @module, 'Graph::Usage' );
push( @module, 'HTML::ERuby' );
push( @module, 'XML::Generator::Win32OLETypeLib' );
push( @module, 'Devel::TraceLoad' );
push( @module, 'CORBA::ORBit' );
push( @module, 'P4::C4' );
push( @module, 'Tie::Hash::Create' );
push( @module, 'Mail::Classifier' );
push( @module, 'Geo::TigerLine::Abbreviations' );
push( @module, 'OurNet::Query' );
push( @module, 'Win32::ADO' );
push( @module, 'Sub::ParamFrame' );
push( @module, 'HTTP::MessageParser' );
push( @module, 'Finance::Bank::CreateCard' );
push( @module, 'Catalyst::Plugin::Unicode::Encoding' );
push( @module, 'ObjStore' );
push( @module, 'DBD::Informix' );
push( @module, 'Solaris::Disk::SVM::Graph' );
push( @module, 'Gtk2::Ex::GroupBy' );
push( @module, 'Data::TreeDumper::Renderer::GTK' );
push( @module, 'AudioFile::Info::MP3::ID3Lib' );
push( @module, 'Term::Menus' );
push( @module, 'WWW::Blog::Metadata::Yadis' );
push( @module, 'Finance::Bank::easybank' );
push( @module, 'Plucene::Plugin::Analyzer::PorterAnalyzer' );
push( @module, 'Mail::RBL' );
push( @module, 'App::Widget::ChartDirector' );
push( @module, 'OS2::UPM' );
push( @module, 'Sybase::RepAgent' );
push( @module, 'Gtk2::Sexy' );
push( @module, 'Unicode::Collate' );
push( @module, 'Gtk2::Ex::Geo' );
push( @module, 'DBD::DtfSQLmac' );
push( @module, 'Win32::FirewallParser' );
push( @module, 'Text::CHM' );
push( @module, 'Template::Plugin::AudioFile::Info' );
push( @module, 'Bot::BasicBot::Pluggable::Module::Search' );
push( @module, 'Win32::RemoteTOD' );
push( @module, 'Teradata::SQL' );
push( @module, 'Solaris::loadavg' );
push( @module, 'DBD::Adabas' );
push( @module, 'AudioFile::Info::Ogg::Vorbis::Header' );
push( @module, 'Java::Build' );
push( @module, 'Win32API::Resources' );
push( @module, 'Win32::TieRegistry::Dump' );
push( @module, 'Win32API::MIDI' );
push( @module, 'Inline::Befunge' );
push( @module, 'RTx::Shredder' );
push( @module, 'POE::Component::RRDTool' );
push( @module, 'Festival::Client' );
push( @module, 'Win32::Symlink' );
push( @module, 'DBD::Mimer' );
push( @module, 'Net::Z3950::AsyncZ' );
push( @module, 'Win32::API' );
push( @module, 'Win32::SystemInfo' );
push( @module, 'Win32::MprApi' );
push( @module, 'WWW::Scraper::ISBN::TWTenlong_Driver' );
push( @module, 'VMS::IndexedFile' );
push( @module, 'Win32API::ProcessStatus' );
push( @module, 'Gtk2::Ex::VolumeButton' );
push( @module, 'Mail::vpopmail' );
push( @module, 'DBIx::OracleSequence' );
push( @module, 'RT::Extension::ActivityReports' );
push( @module, 'Win32::Codepage' );
push( @module, 'Eesh' );
push( @module, 'Gtk2::Ex::MPlayerEmbed' );
push( @module, 'String::Thai::Segmentation' );
push( @module, 'Win32::ASP' );
push( @module, 'SNMP::Util' );
push( @module, 'Devel::CCov' );
push( @module, 'Audio::MPEG' );
push( @module, 'Math::Calculus::TaylorEquivalent' );
push( @module, 'CAD::Drawing::IO::Image' );
push( @module, 'Getopt::Long' );
push( @module, 'Net::FreeDB' );
push( @module, 'PPI::XS' );
push( @module, 'Data::Vitals' );
push( @module, 'Newt' );
push( @module, 'Data::Walk' );
push( @module, 'DBIx::DataLookup' );
push( @module, 'Win32::NetSend' );
push( @module, 'Tie::Hash::KeysMask' );
push( @module, 'Safe::Caller' );
push( @module, 'CAD::Drawing::IO::DWGI' );
push( @module, 'SDL::OpenGL::Cg' );
push( @module, 'RT::View::Directory' );
push( @module, 'Win32::Script' );
push( @module, 'Filter::CBC' );
push( @module, 'Feed::Find' );
push( @module, 'Encode::TECkit' );
push( @module, 'Mac::AppleEvents::Simple' );
push( @module, 'Catalyst::Plugin::AtomServer' );
push( @module, 'CPAN::YACSmoke::Plugin::NNTPWeb' );
push( @module, 'Font::TFM' );
push( @module, 'Getopt::Plus' );
push( @module, 'Bot::BasicBot::Pluggable' );
push( @module, 'Win32::Wallpaper' );
push( @module, 'AI::jNeural' );
push( @module, 'Authen::Simple::Passwd' );
push( @module, 'Language::XSB' );
push( @module, 'Log::Info' );
push( @module, 'Win32::Process::Perf' );
push( @module, 'MQSeries' );
push( @module, 'Games::Poker::HandEvaluator' );
push( @module, 'HTTP::CryptoCookie' );
push( @module, 'URI::Fetch' );
push( @module, 'Authen::ACE4' );
push( @module, 'Business::NoChex' );
push( @module, 'YAPE::Regex::Explain' );
push( @module, 'FrameMaker::MifTree' );
push( @module, 'CPAN::Test::Dummy::Perl5::Make::Failearly' );
push( @module, 'Gtk2::Ex::Simple::Tree' );
push( @module, 'POE::Component::Win32::ChangeNotify' );
push( @module, 'GraphViz::Makefile' );
push( @module, 'Image::TestJPG' );
push( @module, 'Devel::Peek' );
push( @module, 'PXP' );
push( @module, 'Astro::Corlate' );
push( @module, 'Cmenu' );
push( @module, 'FreePAN::SVKMirror' );
push( @module, 'Win32::Daemon::Simple' );

fisher_yates_shuffle( \@module );

for ( my $i = 0; $i <= $#module; $i++ )
{
   my $name = $module[$i];

   $name =~ s/[:][:]/-/g;

   my $mi = $plus->module_tree( $module[$i] );


   eval( '$mi->package_name()' );

   next if ( @$ );

   next if ( $name ne $mi->package_name() );

   my $xml_gz = undef;

   my $context_pl = undef;

   my $mid = $mi->package_name() . '-' . $mi->package_version();

   printf( "[BEGINNING] Distribution named %s is to be installed.\n", $mid );

   $conf->set_conf( 'force' => 0 );

   $mi->install();

   my $mist = $mi->status();

   $reporter->distribution( $mid );

   if ( -d '_dat' && $mist->installed && ! defined( $mist->extract() ) )
   {
      $conf->set_conf( 'force' => 1 );

      $mi->fetch();

      $mi->extract();

      $mist = $mi->status();

      $conf->set_conf( 'force' => 0 );

   } ## end if

   if ( defined( $mist->extract() ) )
   {
      if ( $perm && ! -f $mist->extract().'/SIGNATURE' )
      {
         printf( "[REPORTING] Distribution named %s missing SIGNATURE, sending insecurity message.\n", $mid );

         $reporter->grade( 'unsigned' );

         $reporter->send() || die $reporter->errstr();

      } ## end if

      if ( -d '_dat' )
      {
         if ( ! -f $mist->extract().'/SIGNATURE' )
         {
            printf( "[REPORTING] Distribution named %s missing SIGNATURE, saving insecurity data.\n", $mid );

            $xml_gz = '_dat/Bundle::Modules::CPAN::Unstable::unsigned.xml.gz';

            $xml_gz =~ s/[:][:]/__/g;

            $context_pl = undef;

            $context_pl = $xml->xml2pl( $xml_gz ) if ( -f $xml_gz );

            my $author = $mi->author();

            $context_pl->{$module[$i]} = { 'author' => $author->author(),
                                           'cpanid' => $author->cpanid(),
                                           'email' => $author->email(),
                                           ##'distributions' => [ $author->distributions() ],
                                         };

            $xml->pl2xml( $context_pl, $xml_gz );

         } ## end if

         $xml_gz = '_dat/Bundle::Modules::CPAN::Unstable::prereqs.xml.gz';

         $xml_gz =~ s/[:][:]/__/g;

         $context_pl = undef;

         $context_pl = $xml->xml2pl( $xml_gz ) if ( -f $xml_gz );

         if ( ! defined( $context_pl->{$module[$i]} ) )
         {
            printf( "[REPORTING] Distribution named %s, saving prereqs data.\n", $mid );

            $context_pl->{$module[$i]} = $mist->prereqs();

            $xml->pl2xml( $context_pl, $xml_gz );

            foreach my $x ( keys %{$context_pl->{$module[$i]}} )
            {
               printf( "\t'%s' => '%s'\n", $x, $context_pl->{$module[$i]}->{$x} );

            } ## end foreach

         } ## end if

      } ## end if

   } ## end if

   if ( ( $context eq 'stable' ) && ! $mist->installed() )
   {
      if ( $perm )
      {
         printf( "[REPORTING] Distribution named %s failed to install, sending instablity message.\n", $mid );

         $reporter->grade( 'unstable' );

         $reporter->send() || die $reporter->errstr();

      } ## end if

      if ( -d '_dat' )
      {
         printf( "[REPORTING] Distribution named %s failed to install, saving instablity data.\n", $mid );

         $xml_gz = '_dat/Bundle::Modules::CPAN::Unstable::Unstable.xml.gz';

         $xml_gz =~ s/[:][:]/__/g;

         $context_pl = undef;

         $context_pl = $xml->xml2pl( $xml_gz ) if ( -f $xml_gz );

         $context_pl->{$module[$i]} = 1;

         $xml->pl2xml( $context_pl, $xml_gz );

      } ## end if

      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   }
   elsif ( ( $context eq 'unstable' ) && $mist->installed() )
   {
      if ( ( $mist->signature() && $mist->checksum_ok() && -f $mist->extract().'/SIGNATURE' ) || ! $mist->created() )
      {
         if ( defined( $mist->extract() ) )
         {
            if ( $perm )
            {
               printf( "[REPORTING] Distribution named %s is installed with a trusted signature, sending stablity message.\n", $mid );

               $reporter->grade( 'stable' );

            } ## end if

            if ( -d '_dat' )
            {
               printf( "[REPORTING] Distribution named %s is installed with a trusted signature, saving stablity data.\n", $mid );

               $xml_gz = '_dat/Bundle::Modules::CPAN::Unstable.xml.gz';

               $xml_gz =~ s/[:][:]/__/g;

               $context_pl = undef;

               $context_pl = $xml->xml2pl( $xml_gz ) if ( -f $xml_gz );

               $context_pl->{$module[$i]} = 0;

               $xml->pl2xml( $context_pl, $xml_gz );

            } ## end if

         }
         else
         {
            if ( $perm )
            {
               printf( "[REPORTING] Distribution named %s is already installed, sending installed message.\n", $mid );

               $reporter->grade( 'installed' );

            } ## end if

         } ## end if

      }
      else
      {
         if ( $perm )
         {
            printf( "[REPORTING] Distribution named %s is installed without a trusted signature, sending insecurity message.\n", $mid );

         $reporter->grade( 'signature' );

         } ## end if

      } ## end if

      if ( $perm )
      {
         $reporter->send() || die $reporter->errstr();

      } ## end if

      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   elsif ( ( $context eq 'stable' ) && $mist->installed() )
   {
      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   elsif ( ( $context eq 'unstable' ) && ! $mist->installed() )
   {
      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   } ## end if

   if ( defined( $mist->extract() ) )
   {
      $sh->rm( '-Rf ' . $mist->extract() );

   } ## end if

   $mi->parent->flush('lib');

} ## end for

##
## fisher_yates_shuffle - Perl Cookbook's in-place array permutation
##
sub fisher_yates_shuffle
{
   my $a = shift;

   for ( my $i = @$a; $i--; )
   {
      my $j = int( rand( $i + 1 ) );

      next if ( $i == $j );

      @$a[$i,$j] = @$a[$j,$i];

   } ## end for

} ## end sub fisher_yates_shuffle

1;

__END__

=head1 NAME

Bundle::Modules::CPAN::Unstable - All current I<unstable> modules in CPAN

=head1 SYNOPSIS

perl -MCPAN -e B<'install Bundle::Modules::CPAN::Unstable'>

cpan B<-i Bundle::Modules::CPAN::Unstable>

perl -MBundle::Modules::CPAN::Unstable

=head1 CONTENTS
Bundle::CPAN
Bundle::CPANPLUS
Bundle::Expect
Bundle::Test
Shell
=head1 CHANGES

=over

=item 2006.0510 (YYYY.MMDD)

Initial version of: Bundle::Modules::CPAN::Unstable-2006.0510

This B<L<Bundle::Modules>> component package is in pre-alpha state with hash ordering.

The ordering of listed modules will eventually be prioritized for efficiency and completeness.

Modules commented out of this module list are either I<unstable> or I<stable> in the B<L<Bundle::Modules>> context.

Optimistically, if there are a lot of the modules commented out, then they are I<stable>, and we're listing I<unstable> context.

Optimistically, if there are a few of the modules commented out, then they are I<unstable>, and we're listing I<stable> context.

If you use the command C<B<man Bundle::Modules::CPAN::Unstable>>, type C<B</#>> to see the commented out modules as they're higlighted for you by B<man>.

=item 2006.0520

This contains a newly refined concept of: Bundle::Modules::CPAN::Unstable-2006.0520

This B<L<Bundle::Modules>> component package is in pre-alpha state with randomized hash ordering.

The ordering of listed modules is now shuffled randomly on each run for better efficiency and completeness.

Modules are no longer listed in CONTENTS, like other 'Bundle::' bundles out there.  I just list Bundle::CPANPLUS.

I support the idea of testing of installations in mass, and I use the information provided by CPANPLUS test reports.

The B<L<Bundle::Modules>> suite has I<stable> and I<unstable> listings that will be updated using the information provided by the testers.db

The B<L<Bundle::Modules>> suite uses Module::Build in its Build.PL, and generates a compatible Makefile.PL.

The B<L<Bundle::Modules>> suite uses the CPANPLUS::Backend to create its own random-ordered installations.

=back

=head1 DESCRIPTION

This Bundle package will install all of the modules listed, if they're not commented out of the B<L<Bundle::Modules>> context.

=head1 SEE ALSO

I<L<Bundle::Modules>>, I<L<Bundle::Modules::Unstable>>, I<L<Bundle::Modules::CPAN>>, I<L<Bundle::Modules::Apache>>, I<L<Bundle::Modules::Apache::Unstable>>

=head1 AUTHORS

Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>

=head1 LICENSE for http://www.cpan.org/authors/id/E/ER/ERMEYERS/Bundle-Modules-2006.0604

perl

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 COPYRIGHT

Copyright (C) 2006 by Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>


