use 5.006;
use ExtUtils::MakeMaker;


print "Net::CUPS Configuration\n";

## We will need a hash to store our configuration options.
my %config;

print "Running cups-config ... ";
my $version = `cups-config --version`;

$version =~ s/^\s+//g;
$version =~ s/\s+$//g;

## Check to see if we have found the cups-config script
if( !defined( $version ) )
{
	print "failed.\n\n";
	print "Net::CUPS requires the Common Unix Printing System. Check\n";
	print "your system configuration and then attempt the configure\n";
	print "process again.\n";
	exit( 1 );
}
else
{
	print "$version\n";
}

my @version_parts = split( /\./, $version );

if( ( $version_parts[1] < 2 ) ||
	( ( $version_parts[1] == 2 ) && ( $version_parts[2] < 2 ) ) )
{
	print "The version of the Common Unix Printing System installed\n";
	print "on your system is too old for this module to work properly.\n";
	print "Please upgrade the version of CUPS on your system to version \n";
	print "1.2.2 or higher and re-run Makefile.PL to install this module.\n\n";
	exit( 1 );
}

## Grab the CFLAGS ...
$config{INC} = `cups-config --cflags`;

## Grab the LIBS ...
$config{LIBS} = `cups-config --libs`;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Net::CUPS',
    VERSION_FROM      => 'lib/Net/CUPS.pm', # finds $VERSION
    PREREQ_PM         => {'Test::More'  =>  0, }, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Net/CUPS.pm', # retrieve abstract from module
       AUTHOR         => 'D. Hageman <dhageman@dracken.com>') : ()),
    LIBS              => [''], # e.g., '-lm'
    DEFINE            => '', # e.g., '-DHAVE_SOMETHING'
	%config
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.

  my @names = ( 
		{ name => "AF_LOCAL", macro => "1" },
		{ name => "CUPS_ACCEPT_JOBS", macro => "1" },
		{ name => "CUPS_ADD_CLASS", macro => "1" },
		{ name => "CUPS_ADD_MODIFY_CLASS", macro => "1" },
		{ name => "CUPS_ADD_MODIFY_PRINTER", macro => "1" },
		{ name => "CUPS_ADD_PRINTER", macro => "1" },
		{ name => "CUPS_AUTHENTICATE_JOB", macro => "1" },
		{ name => "CUPS_AUTO_ENCODING", macro => "1" },
		#{ name => "CUPS_BACKEND_AUTH_REQUIRED", macro => "1" },
		#{ name => "CUPS_BACKEND_CANCEL", macro => "1" },
		#{ name => "CUPS_BACKEND_FAILED", macro => "1" },
		#{ name => "CUPS_BACKEND_HOLD", macro => "1" },
		#{ name => "CUPS_BACKEND_OK", macro => "1" },
		#{ name => "CUPS_BACKEND_STOP", macro => "1" },
		{ name => "CUPS_DATE_ANY", macro => "1" },
		{ name => "CUPS_DELETE_CLASS", macro => "1" },
		{ name => "CUPS_DELETE_PRINTER", macro => "1" },
		{ name => "CUPS_ENCODING_DBCS_END", macro => "1" },
		{ name => "CUPS_ENCODING_SBCS_END", macro => "1" },
		{ name => "CUPS_ENCODING_VBCS_END", macro => "1" },
		{ name => "CUPS_EUC_CN", macro => "1" },
		{ name => "CUPS_EUC_JP", macro => "1" },
		{ name => "CUPS_EUC_KR", macro => "1" },
		{ name => "CUPS_EUC_TW", macro => "1" },
		{ name => "CUPS_FILE_GZIP", macro => "1" },
		{ name => "CUPS_FILE_NONE", macro => "1" },
		{ name => "CUPS_GET_CLASSES", macro => "1" },
		{ name => "CUPS_GET_DEFAULT", macro => "1" },
		{ name => "CUPS_GET_DEVICES", macro => "1" },
		{ name => "CUPS_GET_PPDS", macro => "1" },
		{ name => "CUPS_GET_PRINTERS", macro => "1" },
		{ name => "CUPS_IMAGE_BLACK", macro => "1" },
		{ name => "CUPS_IMAGE_CMY", macro => "1" },
		{ name => "CUPS_IMAGE_CMYK", macro => "1" },
		{ name => "CUPS_IMAGE_RGB", macro => "1" },
		{ name => "CUPS_IMAGE_RGB_CMYK", macro => "1" },
		{ name => "CUPS_IMAGE_WHITE", macro => "1" },
		{ name => "CUPS_ISO8859_1", macro => "1" },
		{ name => "CUPS_ISO8859_10", macro => "1" },
		{ name => "CUPS_ISO8859_11", macro => "1" },
		{ name => "CUPS_ISO8859_13", macro => "1" },
		{ name => "CUPS_ISO8859_14", macro => "1" },
		{ name => "CUPS_ISO8859_15", macro => "1" },
		{ name => "CUPS_ISO8859_16", macro => "1" },
		{ name => "CUPS_ISO8859_2", macro => "1" },
		{ name => "CUPS_ISO8859_3", macro => "1" },
		{ name => "CUPS_ISO8859_4", macro => "1" },
		{ name => "CUPS_ISO8859_5", macro => "1" },
		{ name => "CUPS_ISO8859_6", macro => "1" },
		{ name => "CUPS_ISO8859_7", macro => "1" },
		{ name => "CUPS_ISO8859_8", macro => "1" },
		{ name => "CUPS_ISO8859_9", macro => "1" },
		{ name => "CUPS_KOI8_R", macro => "1" },
		{ name => "CUPS_KOI8_U", macro => "1" },
		{ name => "CUPS_MAC_ROMAN", macro => "1" },
		{ name => "CUPS_MAX_USTRING", macro => "1" },
		{ name => "CUPS_MOVE_JOB", macro => "1" },
		{ name => "CUPS_PRINTER_AUTHENTICATED", macro => "1" },
		{ name => "CUPS_PRINTER_BIND", macro => "1" },
		{ name => "CUPS_PRINTER_BW", macro => "1" },
		{ name => "CUPS_PRINTER_CLASS", macro => "1" },
		{ name => "CUPS_PRINTER_COLLATE", macro => "1" },
		{ name => "CUPS_PRINTER_COLOR", macro => "1" },
		{ name => "CUPS_PRINTER_COMMANDS", macro => "1" },
		{ name => "CUPS_PRINTER_COPIES", macro => "1" },
		{ name => "CUPS_PRINTER_COVER", macro => "1" },
		{ name => "CUPS_PRINTER_DEFAULT", macro => "1" },
		{ name => "CUPS_PRINTER_DELETE", macro => "1" },
		{ name => "CUPS_PRINTER_DUPLEX", macro => "1" },
		{ name => "CUPS_PRINTER_FAX", macro => "1" },
		{ name => "CUPS_PRINTER_IMPLICIT", macro => "1" },
		{ name => "CUPS_PRINTER_LARGE", macro => "1" },
		{ name => "CUPS_PRINTER_LOCAL", macro => "1" },
		{ name => "CUPS_PRINTER_MEDIUM", macro => "1" },
		{ name => "CUPS_PRINTER_NOT_SHARED", macro => "1" },
		{ name => "CUPS_PRINTER_OPTIONS", macro => "1" },
		{ name => "CUPS_PRINTER_PUNCH", macro => "1" },
		{ name => "CUPS_PRINTER_REJECTING", macro => "1" },
		{ name => "CUPS_PRINTER_REMOTE", macro => "1" },
		{ name => "CUPS_PRINTER_SMALL", macro => "1" },
		{ name => "CUPS_PRINTER_SORT", macro => "1" },
		{ name => "CUPS_PRINTER_STAPLE", macro => "1" },
		{ name => "CUPS_PRINTER_VARIABLE", macro => "1" },
		{ name => "CUPS_REJECT_JOBS", macro => "1" },
		{ name => "CUPS_SET_DEFAULT", macro => "1" },
		{ name => "CUPS_US_ASCII", macro => "1" },
		{ name => "CUPS_UTF8", macro => "1" },
		{ name => "CUPS_VERSION", macro => "1" },
		{ name => "CUPS_VERSION_MAJOR", macro => "1" },
		{ name => "CUPS_VERSION_MINOR", macro => "1" },
		{ name => "CUPS_VERSION_PATCH", macro => "1" },
		{ name => "CUPS_WINDOWS_1250", macro => "1" },
		{ name => "CUPS_WINDOWS_1251", macro => "1" },
		{ name => "CUPS_WINDOWS_1252", macro => "1" },
		{ name => "CUPS_WINDOWS_1253", macro => "1" },
		{ name => "CUPS_WINDOWS_1254", macro => "1" },
		{ name => "CUPS_WINDOWS_1255", macro => "1" },
		{ name => "CUPS_WINDOWS_1256", macro => "1" },
		{ name => "CUPS_WINDOWS_1257", macro => "1" },
		{ name => "CUPS_WINDOWS_1258", macro => "1" },
		{ name => "CUPS_WINDOWS_1361", macro => "1" },
		{ name => "CUPS_WINDOWS_874", macro => "1" },
		{ name => "CUPS_WINDOWS_932", macro => "1" },
		{ name => "CUPS_WINDOWS_936", macro => "1" },
		{ name => "CUPS_WINDOWS_949", macro => "1" },
		{ name => "CUPS_WINDOWS_950", macro => "1" },
		{ name => "HTTP_0_9", macro => "1" },
		{ name => "HTTP_1_0", macro => "1" },
		{ name => "HTTP_1_1", macro => "1" },
		{ name => "HTTP_ACCEPTED", macro => "1" },
		{ name => "HTTP_AUTH_BASIC", macro => "1" },
		{ name => "HTTP_AUTH_MD5", macro => "1" },
		{ name => "HTTP_AUTH_MD5_INT", macro => "1" },
		{ name => "HTTP_AUTH_MD5_SESS", macro => "1" },
		{ name => "HTTP_AUTH_MD5_SESS_INT", macro => "1" },
		{ name => "HTTP_AUTH_NONE", macro => "1" },
		{ name => "HTTP_BAD_GATEWAY", macro => "1" },
		{ name => "HTTP_BAD_REQUEST", macro => "1" },
		{ name => "HTTP_CLOSE", macro => "1" },
		{ name => "HTTP_CONFLICT", macro => "1" },
		{ name => "HTTP_CONTINUE", macro => "1" },
		{ name => "HTTP_CREATED", macro => "1" },
		{ name => "HTTP_DELETE", macro => "1" },
		{ name => "HTTP_ENCODE_CHUNKED", macro => "1" },
		#{ name => "HTTP_ENCODE_FIELDS", macro => "1" },
		{ name => "HTTP_ENCODE_LENGTH", macro => "1" },
		{ name => "HTTP_ENCRYPT_ALWAYS", macro => "1" },
		{ name => "HTTP_ENCRYPT_IF_REQUESTED", macro => "1" },
		{ name => "HTTP_ENCRYPT_NEVER", macro => "1" },
		{ name => "HTTP_ENCRYPT_REQUIRED", macro => "1" },
		{ name => "HTTP_ERROR", macro => "1" },
		{ name => "HTTP_EXPECTATION_FAILED", macro => "1" },
		{ name => "HTTP_FIELD_ACCEPT_LANGUAGE", macro => "1" },
		{ name => "HTTP_FIELD_ACCEPT_RANGES", macro => "1" },
		{ name => "HTTP_FIELD_AUTHORIZATION", macro => "1" },
		{ name => "HTTP_FIELD_CONNECTION", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_ENCODING", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_LANGUAGE", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_LENGTH", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_LOCATION", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_MD5", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_RANGE", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_TYPE", macro => "1" },
		{ name => "HTTP_FIELD_CONTENT_VERSION", macro => "1" },
		{ name => "HTTP_FIELD_DATE", macro => "1" },
		{ name => "HTTP_FIELD_HOST", macro => "1" },
		{ name => "HTTP_FIELD_IF_MODIFIED_SINCE", macro => "1" },
		{ name => "HTTP_FIELD_IF_UNMODIFIED_SINCE", macro => "1" },
		{ name => "HTTP_FIELD_KEEP_ALIVE", macro => "1" },
		{ name => "HTTP_FIELD_LAST_MODIFIED", macro => "1" },
		{ name => "HTTP_FIELD_LINK", macro => "1" },
		{ name => "HTTP_FIELD_LOCATION", macro => "1" },
		{ name => "HTTP_FIELD_MAX", macro => "1" },
		{ name => "HTTP_FIELD_RANGE", macro => "1" },
		{ name => "HTTP_FIELD_REFERER", macro => "1" },
		{ name => "HTTP_FIELD_RETRY_AFTER", macro => "1" },
		{ name => "HTTP_FIELD_TRANSFER_ENCODING", macro => "1" },
		{ name => "HTTP_FIELD_UNKNOWN", macro => "1" },
		{ name => "HTTP_FIELD_UPGRADE", macro => "1" },
		{ name => "HTTP_FIELD_USER_AGENT", macro => "1" },
		{ name => "HTTP_FIELD_WWW_AUTHENTICATE", macro => "1" },
		{ name => "HTTP_FORBIDDEN", macro => "1" },
		{ name => "HTTP_GATEWAY_TIMEOUT", macro => "1" },
		{ name => "HTTP_GET", macro => "1" },
		{ name => "HTTP_GET_SEND", macro => "1" },
		{ name => "HTTP_GONE", macro => "1" },
		{ name => "HTTP_HEAD", macro => "1" },
		{ name => "HTTP_KEEPALIVE_OFF", macro => "1" },
		{ name => "HTTP_KEEPALIVE_ON", macro => "1" },
		{ name => "HTTP_LENGTH_REQUIRED", macro => "1" },
		{ name => "HTTP_MAX_BUFFER", macro => "1" },
		{ name => "HTTP_MAX_HOST", macro => "1" },
		{ name => "HTTP_MAX_URI", macro => "1" },
		{ name => "HTTP_MAX_VALUE", macro => "1" },
		{ name => "HTTP_METHOD_NOT_ALLOWED", macro => "1" },
		{ name => "HTTP_MOVED_PERMANENTLY", macro => "1" },
		{ name => "HTTP_MOVED_TEMPORARILY", macro => "1" },
		{ name => "HTTP_MULTIPLE_CHOICES", macro => "1" },
		{ name => "HTTP_NOT_ACCEPTABLE", macro => "1" },
		{ name => "HTTP_NOT_AUTHORITATIVE", macro => "1" },
		{ name => "HTTP_NOT_FOUND", macro => "1" },
		{ name => "HTTP_NOT_IMPLEMENTED", macro => "1" },
		{ name => "HTTP_NOT_MODIFIED", macro => "1" },
		{ name => "HTTP_NOT_SUPPORTED", macro => "1" },
		{ name => "HTTP_NO_CONTENT", macro => "1" },
		{ name => "HTTP_OK", macro => "1" },
		{ name => "HTTP_OPTIONS", macro => "1" },
		{ name => "HTTP_PARTIAL_CONTENT", macro => "1" },
		{ name => "HTTP_PAYMENT_REQUIRED", macro => "1" },
		{ name => "HTTP_POST", macro => "1" },
		{ name => "HTTP_POST_RECV", macro => "1" },
		{ name => "HTTP_POST_SEND", macro => "1" },
		{ name => "HTTP_PRECONDITION", macro => "1" },
		{ name => "HTTP_PROXY_AUTHENTICATION", macro => "1" },
		{ name => "HTTP_PUT", macro => "1" },
		{ name => "HTTP_PUT_RECV", macro => "1" },
		{ name => "HTTP_REQUESTED_RANGE", macro => "1" },
		{ name => "HTTP_REQUEST_TIMEOUT", macro => "1" },
		{ name => "HTTP_REQUEST_TOO_LARGE", macro => "1" },
		{ name => "HTTP_RESET_CONTENT", macro => "1" },
		{ name => "HTTP_SEE_OTHER", macro => "1" },
		{ name => "HTTP_SERVER_ERROR", macro => "1" },
		{ name => "HTTP_SERVICE_UNAVAILABLE", macro => "1" },
		{ name => "HTTP_STATUS", macro => "1" },
		{ name => "HTTP_SWITCHING_PROTOCOLS", macro => "1" },
		{ name => "HTTP_TRACE", macro => "1" },
		{ name => "HTTP_UNAUTHORIZED", macro => "1" },
		{ name => "HTTP_UNSUPPORTED_MEDIATYPE", macro => "1" },
		{ name => "HTTP_UPGRADE_REQUIRED", macro => "1" },
		{ name => "HTTP_URI_BAD_ARGUMENTS", macro => "1" },
		{ name => "HTTP_URI_BAD_HOSTNAME", macro => "1" },
		{ name => "HTTP_URI_BAD_PORT", macro => "1" },
		{ name => "HTTP_URI_BAD_RESOURCE", macro => "1" },
		{ name => "HTTP_URI_BAD_SCHEME", macro => "1" },
		{ name => "HTTP_URI_BAD_URI", macro => "1" },
		{ name => "HTTP_URI_BAD_USERNAME", macro => "1" },
		{ name => "HTTP_URI_CODING_ALL", macro => "1" },
		{ name => "HTTP_URI_CODING_HOSTNAME", macro => "1" },
		{ name => "HTTP_URI_CODING_MOST", macro => "1" },
		{ name => "HTTP_URI_CODING_NONE", macro => "1" },
		{ name => "HTTP_URI_CODING_QUERY", macro => "1" },
		{ name => "HTTP_URI_CODING_RESOURCE", macro => "1" },
		{ name => "HTTP_URI_CODING_USERNAME", macro => "1" },
		{ name => "HTTP_URI_MISSING_RESOURCE", macro => "1" },
		{ name => "HTTP_URI_MISSING_SCHEME", macro => "1" },
		{ name => "HTTP_URI_OK", macro => "1" },
		{ name => "HTTP_URI_OVERFLOW", macro => "1" },
		{ name => "HTTP_URI_TOO_LONG", macro => "1" },
		{ name => "HTTP_URI_UNKNOWN_SCHEME", macro => "1" },
		{ name => "HTTP_USE_PROXY", macro => "1" },
		{ name => "HTTP_WAITING", macro => "1" },
		qw( INET6 ),
		{ name => "IPP_ACTIVATE_PRINTER", macro => "1" },
		{ name => "IPP_ATTRIBUTE", macro => "1" },
		{ name => "IPP_ATTRIBUTES", macro => "1" },
		{ name => "IPP_ATTRIBUTES_NOT_SETTABLE", macro => "1" },
		{ name => "IPP_BAD_REQUEST", macro => "1" },
		{ name => "IPP_CANCEL_CURRENT_JOB", macro => "1" },
		{ name => "IPP_CANCEL_JOB", macro => "1" },
		{ name => "IPP_CANCEL_SUBSCRIPTION", macro => "1" },
		{ name => "IPP_CHARSET", macro => "1" },
		{ name => "IPP_COMPRESSION_ERROR", macro => "1" },
		{ name => "IPP_COMPRESSION_NOT_SUPPORTED", macro => "1" },
		{ name => "IPP_CONFLICT", macro => "1" },
		{ name => "IPP_CREATE_JOB", macro => "1" },
		{ name => "IPP_CREATE_JOB_SUBSCRIPTION", macro => "1" },
		{ name => "IPP_CREATE_PRINTER_SUBSCRIPTION", macro => "1" },
		{ name => "IPP_DATA", macro => "1" },
		{ name => "IPP_DEACTIVATE_PRINTER", macro => "1" },
		{ name => "IPP_DEVICE_ERROR", macro => "1" },
		{ name => "IPP_DISABLE_PRINTER", macro => "1" },
		{ name => "IPP_DOCUMENT_ACCESS_ERROR", macro => "1" },
		{ name => "IPP_DOCUMENT_FORMAT", macro => "1" },
		{ name => "IPP_DOCUMENT_FORMAT_ERROR", macro => "1" },
		{ name => "IPP_ENABLE_PRINTER", macro => "1" },
		{ name => "IPP_ERROR", macro => "1" },
		#{ name => "IPP_ERROR_JOB_CANCELED", macro => "1" },
		{ name => "IPP_ERROR_JOB_CANCELLED", macro => "1" },
		{ name => "IPP_FINISHINGS_BALE", macro => "1" },
		{ name => "IPP_FINISHINGS_BIND", macro => "1" },
		{ name => "IPP_FINISHINGS_BIND_BOTTOM", macro => "1" },
		{ name => "IPP_FINISHINGS_BIND_LEFT", macro => "1" },
		{ name => "IPP_FINISHINGS_BIND_RIGHT", macro => "1" },
		{ name => "IPP_FINISHINGS_BIND_TOP", macro => "1" },
		{ name => "IPP_FINISHINGS_BOOKLET_MAKER", macro => "1" },
		{ name => "IPP_FINISHINGS_COVER", macro => "1" },
		{ name => "IPP_FINISHINGS_EDGE_STITCH", macro => "1" },
		{ name => "IPP_FINISHINGS_EDGE_STITCH_BOTTOM", macro => "1" },
		{ name => "IPP_FINISHINGS_EDGE_STITCH_LEFT", macro => "1" },
		{ name => "IPP_FINISHINGS_EDGE_STITCH_RIGHT", macro => "1" },
		{ name => "IPP_FINISHINGS_EDGE_STITCH_TOP", macro => "1" },
		{ name => "IPP_FINISHINGS_FOLD", macro => "1" },
		{ name => "IPP_FINISHINGS_JOB_OFFSET", macro => "1" },
		{ name => "IPP_FINISHINGS_NONE", macro => "1" },
		{ name => "IPP_FINISHINGS_PUNCH", macro => "1" },
		{ name => "IPP_FINISHINGS_SADDLE_STITCH", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_BOTTOM_LEFT", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_BOTTOM_RIGHT", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_DUAL_BOTTOM", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_DUAL_LEFT", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_DUAL_RIGHT", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_DUAL_TOP", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_TOP_LEFT", macro => "1" },
		{ name => "IPP_FINISHINGS_STAPLE_TOP_RIGHT", macro => "1" },
		{ name => "IPP_FINISHINGS_TRIM", macro => "1" },
		{ name => "IPP_FORBIDDEN", macro => "1" },
		{ name => "IPP_GET_JOBS", macro => "1" },
		{ name => "IPP_GET_JOB_ATTRIBUTES", macro => "1" },
		{ name => "IPP_GET_NOTIFICATIONS", macro => "1" },
		{ name => "IPP_GET_PRINTER_ATTRIBUTES", macro => "1" },
		{ name => "IPP_GET_PRINTER_SUPPORTED_VALUES", macro => "1" },
		{ name => "IPP_GET_PRINT_SUPPORT_FILES", macro => "1" },
		{ name => "IPP_GET_SUBSCRIPTIONS", macro => "1" },
		{ name => "IPP_GET_SUBSCRIPTION_ATTRIBUTES", macro => "1" },
		{ name => "IPP_GONE", macro => "1" },
		{ name => "IPP_HEADER", macro => "1" },
		{ name => "IPP_HOLD_JOB", macro => "1" },
		{ name => "IPP_HOLD_NEW_JOBS", macro => "1" },
		{ name => "IPP_IDLE", macro => "1" },
		{ name => "IPP_IGNORED_ALL_NOTIFICATIONS", macro => "1" },
		{ name => "IPP_IGNORED_ALL_SUBSCRIPTIONS", macro => "1" },
		{ name => "IPP_INTERNAL_ERROR", macro => "1" },
		{ name => "IPP_JOB_ABORTED", macro => "1" },
		#{ name => "IPP_JOB_CANCELED", macro => "1" },
		{ name => "IPP_JOB_CANCELLED", macro => "1" },
		{ name => "IPP_JOB_COMPLETED", macro => "1" },
		{ name => "IPP_JOB_HELD", macro => "1" },
		{ name => "IPP_JOB_PENDING", macro => "1" },
		{ name => "IPP_JOB_PROCESSING", macro => "1" },
		{ name => "IPP_JOB_STOPPED", macro => "1" },
		{ name => "IPP_LANDSCAPE", macro => "1" },
		{ name => "IPP_MAX_NAME", macro => "1" },
		{ name => "IPP_MAX_VALUES", macro => "1" },
		{ name => "IPP_MULTIPLE_JOBS_NOT_SUPPORTED", macro => "1" },
		{ name => "IPP_NOT_ACCEPTING", macro => "1" },
		{ name => "IPP_NOT_AUTHENTICATED", macro => "1" },
		{ name => "IPP_NOT_AUTHORIZED", macro => "1" },
		{ name => "IPP_NOT_FOUND", macro => "1" },
		{ name => "IPP_NOT_POSSIBLE", macro => "1" },
		{ name => "IPP_OK", macro => "1" },
		{ name => "IPP_OK_BUT_CANCEL_SUBSCRIPTION", macro => "1" },
		{ name => "IPP_OK_CONFLICT", macro => "1" },
		{ name => "IPP_OK_EVENTS_COMPLETE", macro => "1" },
		{ name => "IPP_OK_IGNORED_NOTIFICATIONS", macro => "1" },
		{ name => "IPP_OK_IGNORED_SUBSCRIPTIONS", macro => "1" },
		{ name => "IPP_OK_SUBST", macro => "1" },
		{ name => "IPP_OK_TOO_MANY_EVENTS", macro => "1" },
		{ name => "IPP_OPERATION_NOT_SUPPORTED", macro => "1" },
		{ name => "IPP_PAUSE_PRINTER", macro => "1" },
		{ name => "IPP_PAUSE_PRINTER_AFTER_CURRENT_JOB", macro => "1" },
		{ name => "IPP_PORT", macro => "1" },
		{ name => "IPP_PORTRAIT", macro => "1" },
		{ name => "IPP_PRINTER_BUSY", macro => "1" },
		{ name => "IPP_PRINTER_IDLE", macro => "1" },
		{ name => "IPP_PRINTER_IS_DEACTIVATED", macro => "1" },
		{ name => "IPP_PRINTER_PROCESSING", macro => "1" },
		{ name => "IPP_PRINTER_STOPPED", macro => "1" },
		{ name => "IPP_PRINT_JOB", macro => "1" },
		{ name => "IPP_PRINT_SUPPORT_FILE_NOT_FOUND", macro => "1" },
		{ name => "IPP_PRINT_URI", macro => "1" },
		{ name => "IPP_PRIVATE", macro => "1" },
		{ name => "IPP_PROMOTE_JOB", macro => "1" },
		{ name => "IPP_PURGE_JOBS", macro => "1" },
		{ name => "IPP_QUALITY_DRAFT", macro => "1" },
		{ name => "IPP_QUALITY_HIGH", macro => "1" },
		{ name => "IPP_QUALITY_NORMAL", macro => "1" },
		{ name => "IPP_REDIRECTION_OTHER_SITE", macro => "1" },
		{ name => "IPP_RELEASE_HELD_NEW_JOBS", macro => "1" },
		{ name => "IPP_RELEASE_JOB", macro => "1" },
		{ name => "IPP_RENEW_SUBSCRIPTION", macro => "1" },
		{ name => "IPP_REPROCESS_JOB", macro => "1" },
		{ name => "IPP_REQUEST_ENTITY", macro => "1" },
		{ name => "IPP_REQUEST_VALUE", macro => "1" },
		{ name => "IPP_RESTART_JOB", macro => "1" },
		{ name => "IPP_RESTART_PRINTER", macro => "1" },
		{ name => "IPP_RESUME_JOB", macro => "1" },
		{ name => "IPP_RESUME_PRINTER", macro => "1" },
		{ name => "IPP_RES_PER_CM", macro => "1" },
		{ name => "IPP_RES_PER_INCH", macro => "1" },
		{ name => "IPP_REVERSE_LANDSCAPE", macro => "1" },
		{ name => "IPP_REVERSE_PORTRAIT", macro => "1" },
		{ name => "IPP_SCHEDULE_JOB_AFTER", macro => "1" },
		{ name => "IPP_SEND_DOCUMENT", macro => "1" },
		{ name => "IPP_SEND_NOTIFICATIONS", macro => "1" },
		{ name => "IPP_SEND_URI", macro => "1" },
		{ name => "IPP_SERVICE_UNAVAILABLE", macro => "1" },
		{ name => "IPP_SET_JOB_ATTRIBUTES", macro => "1" },
		{ name => "IPP_SET_PRINTER_ATTRIBUTES", macro => "1" },
		{ name => "IPP_SHUTDOWN_PRINTER", macro => "1" },
		{ name => "IPP_STARTUP_PRINTER", macro => "1" },
		{ name => "IPP_SUSPEND_CURRENT_JOB", macro => "1" },
		{ name => "IPP_TAG_ADMINDEFINE", macro => "1" },
		{ name => "IPP_TAG_BEGIN_COLLECTION", macro => "1" },
		{ name => "IPP_TAG_BOOLEAN", macro => "1" },
		{ name => "IPP_TAG_CHARSET", macro => "1" },
		{ name => "IPP_TAG_COPY", macro => "1" },
		{ name => "IPP_TAG_DATE", macro => "1" },
		{ name => "IPP_TAG_DEFAULT", macro => "1" },
		{ name => "IPP_TAG_DELETEATTR", macro => "1" },
		{ name => "IPP_TAG_END", macro => "1" },
		{ name => "IPP_TAG_END_COLLECTION", macro => "1" },
		{ name => "IPP_TAG_ENUM", macro => "1" },
		{ name => "IPP_TAG_EVENT_NOTIFICATION", macro => "1" },
		{ name => "IPP_TAG_INTEGER", macro => "1" },
		{ name => "IPP_TAG_JOB", macro => "1" },
		{ name => "IPP_TAG_KEYWORD", macro => "1" },
		{ name => "IPP_TAG_LANGUAGE", macro => "1" },
		{ name => "IPP_TAG_MASK", macro => "1" },
		{ name => "IPP_TAG_MEMBERNAME", macro => "1" },
		{ name => "IPP_TAG_MIMETYPE", macro => "1" },
		{ name => "IPP_TAG_NAME", macro => "1" },
		{ name => "IPP_TAG_NAMELANG", macro => "1" },
		{ name => "IPP_TAG_NOTSETTABLE", macro => "1" },
		{ name => "IPP_TAG_NOVALUE", macro => "1" },
		{ name => "IPP_TAG_OPERATION", macro => "1" },
		{ name => "IPP_TAG_PRINTER", macro => "1" },
		{ name => "IPP_TAG_RANGE", macro => "1" },
		{ name => "IPP_TAG_RESOLUTION", macro => "1" },
		{ name => "IPP_TAG_STRING", macro => "1" },
		{ name => "IPP_TAG_SUBSCRIPTION", macro => "1" },
		{ name => "IPP_TAG_TEXT", macro => "1" },
		{ name => "IPP_TAG_TEXTLANG", macro => "1" },
		{ name => "IPP_TAG_UNKNOWN", macro => "1" },
		{ name => "IPP_TAG_UNSUPPORTED_GROUP", macro => "1" },
		{ name => "IPP_TAG_UNSUPPORTED_VALUE", macro => "1" },
		{ name => "IPP_TAG_URI", macro => "1" },
		{ name => "IPP_TAG_URISCHEME", macro => "1" },
		{ name => "IPP_TAG_ZERO", macro => "1" },
		{ name => "IPP_TEMPORARY_ERROR", macro => "1" },
		{ name => "IPP_TIMEOUT", macro => "1" },
		{ name => "IPP_TOO_MANY_SUBSCRIPTIONS", macro => "1" },
		{ name => "IPP_URI_SCHEME", macro => "1" },
		{ name => "IPP_VALIDATE_JOB", macro => "1" },
		{ name => "IPP_VERSION_NOT_SUPPORTED", macro => "1" },
		{ name => "PPD_ALLOC_ERROR", macro => "1" },
		{ name => "PPD_BAD_CUSTOM_PARAM", macro => "1" },
		{ name => "PPD_BAD_OPEN_GROUP", macro => "1" },
		{ name => "PPD_BAD_OPEN_UI", macro => "1" },
		{ name => "PPD_BAD_ORDER_DEPENDENCY", macro => "1" },
		{ name => "PPD_BAD_UI_CONSTRAINTS", macro => "1" },
		{ name => "PPD_CONFORM_RELAXED", macro => "1" },
		{ name => "PPD_CONFORM_STRICT", macro => "1" },
		{ name => "PPD_CS_CMY", macro => "1" },
		{ name => "PPD_CS_CMYK", macro => "1" },
		{ name => "PPD_CS_GRAY", macro => "1" },
		{ name => "PPD_CS_N", macro => "1" },
		{ name => "PPD_CS_RGB", macro => "1" },
		{ name => "PPD_CS_RGBK", macro => "1" },
		{ name => "PPD_CUSTOM_CURVE", macro => "1" },
		{ name => "PPD_CUSTOM_INT", macro => "1" },
		{ name => "PPD_CUSTOM_INVCURVE", macro => "1" },
		{ name => "PPD_CUSTOM_PASSCODE", macro => "1" },
		{ name => "PPD_CUSTOM_PASSWORD", macro => "1" },
		{ name => "PPD_CUSTOM_POINTS", macro => "1" },
		{ name => "PPD_CUSTOM_REAL", macro => "1" },
		{ name => "PPD_CUSTOM_STRING", macro => "1" },
		{ name => "PPD_FILE_OPEN_ERROR", macro => "1" },
		{ name => "PPD_ILLEGAL_CHARACTER", macro => "1" },
		{ name => "PPD_ILLEGAL_MAIN_KEYWORD", macro => "1" },
		{ name => "PPD_ILLEGAL_OPTION_KEYWORD", macro => "1" },
		{ name => "PPD_ILLEGAL_TRANSLATION", macro => "1" },
		{ name => "PPD_ILLEGAL_WHITESPACE", macro => "1" },
		{ name => "PPD_INTERNAL_ERROR", macro => "1" },
		{ name => "PPD_LINE_TOO_LONG", macro => "1" },
		{ name => "PPD_MAX_LINE", macro => "1" },
		{ name => "PPD_MAX_NAME", macro => "1" },
		{ name => "PPD_MAX_TEXT", macro => "1" },
		{ name => "PPD_MISSING_ASTERISK", macro => "1" },
		{ name => "PPD_MISSING_PPDADOBE4", macro => "1" },
		{ name => "PPD_MISSING_VALUE", macro => "1" },
		{ name => "PPD_NESTED_OPEN_GROUP", macro => "1" },
		{ name => "PPD_NESTED_OPEN_UI", macro => "1" },
		{ name => "PPD_NULL_FILE", macro => "1" },
		{ name => "PPD_OK", macro => "1" },
		{ name => "PPD_ORDER_ANY", macro => "1" },
		{ name => "PPD_ORDER_DOCUMENT", macro => "1" },
		{ name => "PPD_ORDER_EXIT", macro => "1" },
		{ name => "PPD_ORDER_JCL", macro => "1" },
		{ name => "PPD_ORDER_PAGE", macro => "1" },
		{ name => "PPD_ORDER_PROLOG", macro => "1" },
		{ name => "PPD_UI_BOOLEAN", macro => "1" },
		{ name => "PPD_UI_PICKMANY", macro => "1" },
		{ name => "PPD_UI_PICKONE", macro => "1" },
		{ name => "PPD_VERSION", macro => "1" } );

  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Net::CUPS',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}

