# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20201204215956;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '007',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20[1-9]\\d{7}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00(?:
            (?:
              37|
              66
            )\\d{6,13}|
            (?:
              777(?:
                [01]|
                (?:
                  5|
                  8\\d
                )\\d
              )|
              882[1245]\\d\\d
            )\\d\\d
          )|
          (?:
            120|
            800\\d
          )\\d{6}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"812938", "Mito\,\ Ibaraki",
"812788", "Maebashi\,\ Gunma",
"817713", "Kameoka\,\ Kyoto",
"8198296", "Hyuga\,\ Miyazaki",
"817996", "Tsuna\,\ Hyogo",
"81992", "Kagoshima\,\ Kagoshima",
"817457", "Yamatotakada\,\ Nara",
"811938", "Miyako\,\ Iwate",
"817945", "Kakogawa\,\ Hyogo",
"811943", "Iwaizumi\,\ Iwate",
"8153970", "Hamamatsu\,\ Shizuoka",
"8125484", "Murakami\,\ Niigata",
"811526", "Abashiri\,\ Hokkaido",
"8144", "Kawasaki\,\ Kanagawa",
"81586", "Ichinomiya\,\ Aichi",
"81532", "Toyohashi\,\ Aichi",
"817485", "Yokaichi\,\ Shiga",
"814775", "Funabashi\,\ Chiba",
"811562", "Honbetsu\,\ Hokkaido",
"81493", "Higashimatsuyama\,\ Saitama",
"811866", "Takanosu\,\ Akita",
"814281", "Sagamihara\,\ Kanagawa",
"81478", "Sawara\,\ Chiba",
"818542", "Yasugi\,\ Shimane",
"81729", "Yao\,\ Osaka",
"812877", "Kuroiso\,\ Tochigi",
"815398", "Hamamatsu\,\ Shizuoka",
"819726", "Usuki\,\ Oita",
"81552", "Kofu\,\ Yamanashi",
"81779", "Ono\,\ Gifu",
"811362", "Kutchan\,\ Hokkaido",
"818696", "Bizen\,\ Okayama",
"812562", "Sanjo\,\ Niigata",
"815743", "Minokamo\,\ Gifu",
"818895", "Susaki\,\ Kochi",
"812483", "Shirakawa\,\ Fukushima",
"815738", "Nakatsugawa\,\ Gifu",
"819952", "Okuchi\,\ Kagoshima",
"818294", "Hatsukaichi\,\ Hiroshima",
"818474", "Fuchu\,\ Hiroshima",
"811877", "Omagari\,\ Akita",
"817704", "Tsuruga\,\ Fukui",
"819557", "Karatsu\,\ Saga",
"811541", "Teshikaga\,\ Hokkaido",
"815735", "Ena\,\ Gifu",
"81134", "Otaru\,\ Hokkaido",
"811757", "Noheji\,\ Aomori",
"812967", "Kasama\,\ Ibaraki",
"815985", "Matsusaka\,\ Mie",
"811976", "Kitakami\,\ Iwate",
"81471", "Kashiwa\,\ Chiba",
"81924", "Fukuoka\,\ Fukuoka",
"817725", "Miyazu\,\ Kyoto",
"818947", "Uwajima\,\ Ehime",
"814754", "Mobara\,\ Chiba",
"817488", "Minakuchi\,\ Shiga",
"815395", "Hamamatsu\,\ Shizuoka",
"812413", "Kitakata\,\ Fukushima",
"817959", "Sanda\,\ Hyogo",
"81234", "Sakata\,\ Yamagata",
"812550", "Yasuzuka\,\ Niigata",
"811935", "Kamaishi\,\ Iwate",
"817948", "Miki\,\ Hyogo",
"819946", "Kanoya\,\ Kagoshima",
"81466", "Fujisawa\,\ Kanagawa",
"81937", "Kitakyushu\,\ Fukuoka",
"819682", "Yamaga\,\ Kumamoto",
"81177", "Aomori\,\ Aomori",
"814793", "Choshi\,\ Chiba",
"818873", "Aki\,\ Kochi",
"812785", "Numata\,\ Gunma",
"815767", "Gero\,\ Gifu",
"812935", "Mito\,\ Ibaraki",
"818807", "Sukumo\,\ Kochi",
"81277", "Kiryu\,\ Gunma",
"81249", "Koriyama\,\ Fukushima",
"81227", "Sendai\,\ Miyagi",
"818556", "Gotsu\,\ Shimane",
"811462", "Urakawa\,\ Hokkaido",
"8186999", "Seto\,\ Okayama",
"817682", "Wajima\,\ Ishikawa",
"8112392", "Yubari\,\ Hokkaido",
"81737", "Yuasa\,\ Wakayama",
"819933", "Ibusuki\,\ Kagoshima",
"8145", "Yokohama\,\ Kanagawa",
"815754", "Sekigahara\,\ Gifu",
"812993", "Ishioka\,\ Ibaraki",
"817946", "Miki\,\ Hyogo",
"819783", "Bungotakada\,\ Oita",
"811583", "Monbetsu\,\ Hokkaido",
"819948", "Shibushi\,\ Kagoshima",
"81542", "Shizuoka\,\ Shizuoka",
"812614", "Omachi\,\ Nagano",
"818374", "Nagato\,\ Yamaguchi",
"81743", "Nara\,\ Nara",
"812837", "Sano\,\ Tochigi",
"812383", "Yonezawa\,\ Yamagata",
"817995", "Sumoto\,\ Hyogo",
"812583", "Nagaoka\,\ Niigata",
"818558", "Kawamoto\,\ Shimane",
"81774", "Uji\,\ Kyoto",
"8198291", "Nobeoka\,\ Miyazaki",
"818695", "Seto\,\ Okayama",
"819808", "Yaeyama\ District\,\ Okinawa",
"817357", "Kushimoto\,\ Wakayama",
"812640", "Nagano\,\ Nagano",
"818592", "Yonago\,\ Tottori",
"812911", "Hokota\,\ Ibaraki",
"811978", "Kitakami\,\ Iwate",
"818896", "Susaki\,\ Kochi",
"811954", "Ninohe\,\ Iwate",
"818244", "Miyoshi\,\ Hiroshima",
"811525", "Abashiri\,\ Hokkaido",
"812677", "Saku\,\ Nagano",
"817486", "Minakuchi\,\ Shiga",
"814776", "Funabashi\,\ Chiba",
"81191", "Ichinoseki\,\ Iwate",
"812890", "Utsunomiya\,\ Tochigi",
"8198298", "Hyuga\,\ Miyazaki",
"811865", "Odate\,\ Akita",
"818660", "Seto\,\ Okayama",
"819824", "Nobeoka\,\ Miyazaki",
"81566", "Kariya\,\ Aichi",
"819725", "Saiki\,\ Oita",
"81979", "Nakatsu\,\ Oita",
"8153973", "Hamamatsu\,\ Shizuoka",
"81298", "Tsuchiura\,\ Ibaraki",
"811528", "Bihoro\,\ Hokkaido",
"81273", "Takasaki\,\ Gunma",
"819663", "Hitoyoshi\,\ Kumamoto",
"818587", "Koge\,\ Tottori",
"81929", "Fukuoka\,\ Fukuoka",
"81947", "Tagawa\,\ Fukuoka",
"811868", "Takanosu\,\ Akita",
"818833", "Kamojima\,\ Tokushima",
"818387", "Tamagawa\,\ Yamaguchi",
"819728", "Usuki\,\ Oita",
"81933", "Kitakyushu\,\ Fukuoka",
"819805", "Nago\,\ Okinawa",
"818698", "Bizen\,\ Okayama",
"817952", "Nishiwaki\,\ Hyogo",
"811975", "Mizusawa\,\ Iwate",
"815986", "Matsusaka\,\ Mie",
"8126174", "Omachi\,\ Nagano",
"81259", "Sado\,\ Niigata",
"815736", "Nakatsugawa\,\ Gifu",
"81862", "Okayama\,\ Okayama",
"8198297", "Hyuga\,\ Miyazaki",
"817612", "Komatsu\,\ Ishikawa",
"812936", "Mito\,\ Ibaraki",
"81792", "Himeji\,\ Hyogo",
"812786", "Numata\,\ Gunma",
"81144", "Tomakomai\,\ Hokkaido",
"817998", "Tsuna\,\ Hyogo",
"818652", "Kurashiki\,\ Okayama",
"818555", "Gotsu\,\ Shimane",
"8153975", "Hamamatsu\,\ Shizuoka",
"81486", "Urawa\,\ Saitama",
"811936", "Miyako\,\ Iwate",
"81432", "Chiba\,\ Chiba",
"81244", "Hobara\,\ Fukushima",
"8147957", "Yokaichiba\,\ Chiba",
"814700", "Kamogawa\,\ Chiba",
"819945", "Kanoya\,\ Kagoshima",
"81593", "Yokkaichi\,\ Mie",
"81578", "Kamioka\,\ Akita",
"817464", "Yoshino\,\ Nara",
"819809", "Yaeyama\ District\,\ Okinawa",
"815392", "Hamamatsu\,\ Shizuoka",
"8112394", "Yubari\,\ Hokkaido",
"817722", "Miyazu\,\ Kyoto",
"812484", "Shirakawa\,\ Fukushima",
"8124197", "Yanaizu\,\ Fukushima",
"817703", "Tsuruga\,\ Fukui",
"819974", "Yakushima\,\ Kagoshima",
"815732", "Ena\,\ Gifu",
"818293", "Hatsukaichi\,\ Hiroshima",
"815982", "Matsusaka\,\ Mie",
"81983", "Takanabe\,\ Miyazaki",
"817497", "Nagahama\,\ Shiga",
"817956", "Sanda\,\ Hyogo",
"8188095", "Tosashimizu\,\ Kochi",
"815744", "Minokamo\,\ Gifu",
"817714", "Kameoka\,\ Kyoto",
"818656", "Kasaoka\,\ Okayama",
"812782", "Numata\,\ Gunma",
"812932", "Takahagi\,\ Ibaraki",
"817616", "Komatsu\,\ Ishikawa",
"811944", "Iwaizumi\,\ Iwate",
"819685", "Tamana\,\ Kumamoto",
"81436", "Ichihara\,\ Chiba",
"8153969", "Hamamatsu\,\ Shizuoka",
"81482", "Kawaguchi\,\ Saitama",
"81775", "Otsu\,\ Shiga",
"818559", "Kawamoto\,\ Shimane",
"811932", "Kamaishi\,\ Iwate",
"81725", "Izumi\,\ Osaka",
"81546", "Shizuoka\,\ Shizuoka",
"819688", "Tamana\,\ Kumamoto",
"811537", "Nakashibetsu\,\ Hokkaido",
"814794", "Choshi\,\ Chiba",
"817942", "Kakogawa\,\ Hyogo",
"812797", "Shibukawa\,\ Gunma",
"819737", "Kusu\,\ Oita",
"817686", "Noto\,\ Ishikawa",
"812477", "Miharu\,\ Fukushima",
"811337", "Ishikari\,\ Hokkaido",
"811466", "Erimo\,\ Hokkaido",
"814701", "Kamogawa\,\ Chiba",
"81420", "Tokorozawa\,\ Saitama",
"819597", "Fukue\,\ Nagasaki",
"81828", "Hiroshima\,\ Hiroshima",
"81893", "Ozu\,\ Ehime",
"81878", "Takamatsu\,\ Kagawa",
"818874", "Aki\,\ Kochi",
"8126172", "Omachi\,\ Nagano",
"819955", "Kajiki\,\ Kagoshima",
"818892", "Sakawa\,\ Kochi",
"8183766", "Shimonoseki\,\ Yamaguchi",
"81245", "Fukushima\,\ Fukushima",
"811869", "Odate\,\ Akita",
"812230", "Sendai\,\ Miyagi",
"818596", "Yonago\,\ Tottori",
"81763", "Fukuno\,\ Toyama",
"812565", "Sanjo\,\ Niigata",
"812414", "Yanaizu\,\ Fukushima",
"811365", "Kutchan\,\ Hokkaido",
"815997", "Ago\,\ Mie",
"818545", "Kisuki\,\ Shimane",
"814753", "Mobara\,\ Chiba",
"814772", "Ichikawa\,\ Chiba",
"817482", "Yokaichi\,\ Shiga",
"81184", "Yurihonjo\,\ Akita",
"814280", "Tachikawa\,\ Tokyo",
"81963", "Kumamoto\,\ Kumamoto",
"818398", "Ogori\,\ Yamaguchi",
"811972", "Mizusawa\,\ Iwate",
"81852", "Matsue\,\ Shimane",
"811953", "Ninohe\,\ Iwate",
"8169", "Osaka\,\ Osaka",
"81886", "Tokushima\,\ Tokushima",
"81832", "Shimonoseki\,\ Yamaguchi",
"819802", "Minamidaito\,\ Okinawa",
"817955", "Sanda\,\ Hyogo",
"81284", "Ashikaga\,\ Tochigi",
"819823", "Nobeoka\,\ Miyazaki",
"818243", "Higashi\-ku\,\ Hiroshima",
"818687", "Mimasaka\,\ Okayama",
"81987", "Nichinan\,\ Miyazaki",
"811584", "Engaru\,\ Hokkaido",
"81462", "Atsugi\,\ Kanagawa",
"8125482", "Murakami\,\ Niigata",
"819686", "Tamana\,\ Kumamoto",
"812939", "Mito\,\ Ibaraki",
"812613", "Omachi\,\ Nagano",
"817737", "Maizuru\,\ Kyoto",
"812789", "Maebashi\,\ Gunma",
"817688", "Noto\,\ Ishikawa",
"819784", "Bungotakada\,\ Oita",
"812994", "Ishioka\,\ Ibaraki",
"815753", "Sekigahara\,\ Gifu",
"819934", "Ibusuki\,\ Kagoshima",
"818552", "Hamada\,\ Shimane",
"811939", "Miyako\,\ Iwate",
"8183767", "Shimonoseki\,\ Yamaguchi",
"818655", "Kamogata\,\ Okayama",
"812584", "Nagaoka\,\ Niigata",
"817615", "Komatsu\,\ Ishikawa",
"818373", "Nagato\,\ Yamaguchi",
"812384", "Yonezawa\,\ Yamagata",
"818674", "Kuse\,\ Okayama",
"812247", "Ogawara\,\ Miyagi",
"8124196", "Yanaizu\,\ Fukushima",
"812747", "Tomioka\,\ Gunma",
"81235", "Tsuruoka\,\ Yamagata",
"817992", "Sumoto\,\ Hyogo",
"817949", "Kakogawa\,\ Hyogo",
"812551", "Joetsu\,\ Niigata",
"818957", "Misho\,\ Ehime",
"817618", "Kaga\,\ Ishikawa",
"81925", "Fukuoka\,\ Fukuoka",
"8183768", "Shimonoseki\,\ Yamaguchi",
"81975", "Oita\,\ Oita",
"817463", "Yoshino\,\ Nara",
"817685", "Wajima\,\ Ishikawa",
"811465", "Shizunai\,\ Hokkaido",
"819547", "Kashima\,\ Saga",
"811366", "Suttsu\,\ Hokkaido",
"819722", "Saiki\,\ Oita",
"818834", "Kamojima\,\ Tokushima",
"812377", "Sagae\,\ Yamagata",
"818546", "Kakeya\,\ Shimane",
"811862", "Kazuno\,\ Akita",
"818360", "Ogori\,\ Yamaguchi",
"812577", "Muika\,\ Niigata",
"818842", "Anan\,\ Tokushima",
"811522", "Shari\,\ Hokkaido",
"81582", "Gifu\,\ Gifu",
"819664", "Hitoyoshi\,\ Kumamoto",
"819956", "Kajiki\,\ Kagoshima",
"811377", "Yakumo\,\ Hokkaido",
"818595", "Yonago\,\ Tottori",
"812566", "Sanjo\,\ Niigata",
"818692", "Oku\,\ Okayama",
"818376", "Mine\,\ Yamaguchi",
"81561", "Seto\,\ Aichi",
"818872", "Muroto\,\ Kochi",
"812547", "Murakami\,\ Niigata",
"81225", "Ishinomaki\,\ Miyagi",
"81196", "Morioka\,\ Iwate",
"811547", "Shiranuka\,\ Hokkaido",
"818679", "Niimi\,\ Okayama",
"8186996", "Seto\,\ Okayama",
"817944", "Kakogawa\,\ Hyogo",
"818367", "Ube\,\ Yamaguchi",
"815977", "Kumano\,\ Mie",
"8126173", "Omachi\,\ Nagano",
"814792", "Choshi\,\ Chiba",
"812616", "Omachi\,\ Nagano",
"81125", "Takikawa\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"819683", "Yamaga\,\ Kumamoto",
"819747", "Taketa\,\ Oita",
"8199347", "Kagoshima\,\ Kagoshima",
"81935", "Kitakyushu\,\ Fukuoka",
"814758", "Togane\,\ Chiba",
"817368", "Iwade\,\ Wakayama",
"818246", "Miyoshi\,\ Hiroshima",
"817484", "Yokaichi\,\ Shiga",
"81488", "Urawa\,\ Saitama",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"812412", "Kitakata\,\ Fukushima",
"819826", "Hyuga\,\ Miyazaki",
"819437", "Tanushimaru\,\ Fukuoka",
"8125480", "Murakami\,\ Niigata",
"81848", "Onomichi\,\ Hiroshima",
"819577", "Shimabara\,\ Nagasaki",
"8126175", "Omachi\,\ Nagano",
"818894", "Susaki\,\ Kochi",
"81764", "Toyama\,\ Toyama",
"818475", "Fuchu\,\ Hiroshima",
"817705", "Obama\,\ Fukui",
"818295", "Hatsukaichi\,\ Hiroshima",
"811956", "Iwate\,\ Iwate",
"815742", "Minokamo\,\ Gifu",
"81550", "Gotenba\,\ Shizuoka",
"81822", "Hiroshima\,\ Hiroshima",
"812563", "Sanjo\,\ Niigata",
"818798", "Tonosho\,\ Kagawa",
"815734", "Ena\,\ Gifu",
"819953", "Okuchi\,\ Kagoshima",
"811857", "Noshiro\,\ Akita",
"815984", "Matsusaka\,\ Mie",
"81984", "Kobayashi\,\ Miyazaki",
"818298", "Hatsukaichi\,\ Hiroshima",
"812482", "Shirakawa\,\ Fukushima",
"818478", "Tojo\,\ Hiroshima",
"817724", "Miyazu\,\ Kyoto",
"811563", "Honbetsu\,\ Hokkaido",
"814755", "Togane\,\ Chiba",
"815394", "Hamamatsu\,\ Shizuoka",
"811363", "Kutchan\,\ Hokkaido",
"81263", "Matsumoto\,\ Nagano",
"81969", "Amakusa\,\ Kumamoto",
"818543", "Yasugi\,\ Shimane",
"812857", "Mooka\,\ Tochigi",
"817230", "Neyagawa\,\ Osaka",
"811934", "Kamaishi\,\ Iwate",
"818680", "Okayama\,\ Okayama",
"81568", "Kasugai\,\ Aichi",
"812589", "Nagaoka\,\ Niigata",
"811942", "Iwaizumi\,\ Iwate",
"817466", "Totsukawa\,\ Nara",
"812389", "Yonezawa\,\ Yamagata",
"811589", "Okoppe\,\ Hokkaido",
"812784", "Numata\,\ Gunma",
"818493", "Onomichi\,\ Hiroshima",
"812934", "Takahagi\,\ Ibaraki",
"819789", "Kitsuki\,\ Oita",
"817712", "Kameoka\,\ Kyoto",
"812999", "Itako\,\ Ibaraki",
"814287", "Ome\,\ Tokyo",
"811237", "Kuriyama\,\ Hokkaido",
"811987", "Tono\,\ Iwate",
"815755", "Sekigahara\,\ Gifu",
"818879", "Muroto\,\ Kochi",
"817468", "Kamikitayama\,\ Nara",
"812615", "Omachi\,\ Nagano",
"81899", "Matsuyama\,\ Ehime",
"818375", "Mine\,\ Yamaguchi",
"817613", "Komatsu\,\ Ishikawa",
"814220", "Kokubunji\,\ Tokyo",
"812237", "Sendai\,\ Miyagi",
"811397", "Okushiri\,\ Hokkaido",
"817994", "Sumoto\,\ Hyogo",
"8198299", "Hyuga\,\ Miyazaki",
"818694", "Okayama\,\ Okayama",
"812419", "Tajima\,\ Fukushima",
"8186998", "Seto\,\ Okayama",
"817953", "Nishiwaki\,\ Hyogo",
"818796", "Tonosho\,\ Kagawa",
"811955", "Ninohe\,\ Iwate",
"818296", "Hiroshima\,\ Hiroshima",
"818476", "Fuchu\,\ Hiroshima",
"817706", "Obama\,\ Fukui",
"811524", "Abashiri\,\ Hokkaido",
"818245", "Miyoshi\,\ Hiroshima",
"81468", "Yokosuka\,\ Kanagawa",
"819662", "Hitoyoshi\,\ Kumamoto",
"818844", "Anan\,\ Tokushima",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"818467", "Mima\,\ Tokushima",
"811864", "Odate\,\ Akita",
"819825", "Hyuga\,\ Miyazaki",
"818832", "Kamojima\,\ Tokushima",
"819724", "Saiki\,\ Oita",
"814756", "Togane\,\ Chiba",
"8125485", "Tsugawa\,\ Niigata",
"812489", "Sukagawa\,\ Fukushima",
"817366", "Iwade\,\ Wakayama",
"81989", "Naha\,\ Okinawa",
"8186997", "Seto\,\ Okayama",
"818248", "Shobara\,\ Hiroshima",
"819979", "Tokunoshima\,\ Kagoshima",
"812657", "Ina\,\ Nagano",
"8126170", "Omachi\,\ Nagano",
"819828", "Takachiho\,\ Miyazaki",
"818593", "Yonago\,\ Tottori",
"819804", "Nago\,\ Okinawa",
"81183", "Yuzawa\,\ Akita",
"811974", "Mizusawa\,\ Iwate",
"811958", "Iwate\,\ Iwate",
"818378", "Shimonoseki\,\ Yamaguchi",
"812382", "Yonezawa\,\ Yamagata",
"81495", "Honjo\,\ Saitama",
"812582", "Nagaoka\,\ Niigata",
"818554", "Hamada\,\ Shimane",
"8125483", "Murakami\,\ Niigata",
"812992", "Ishioka\,\ Ibaraki",
"812917", "Mito\,\ Ibaraki",
"819782", "Bungotakada\,\ Oita",
"817683", "Wajima\,\ Ishikawa",
"819932", "Ibusuki\,\ Kagoshima",
"81476", "Narita\,\ Chiba",
"811463", "Urakawa\,\ Hokkaido",
"81167", "Furano\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"819944", "Kanoya\,\ Kagoshima",
"812618", "Omachi\,\ Nagano",
"811582", "Monbetsu\,\ Hokkaido",
"817465", "Yoshino\,\ Nara",
"81253", "Niigata\,\ Niigata",
"81233", "Shinjo\,\ Yamagata",
"81939", "Kitakyushu\,\ Fukuoka",
"81179", "Sannohe\,\ Aomori",
"817483", "Yokaichi\,\ Shiga",
"814752", "Mobara\,\ Chiba",
"812485", "Shirakawa\,\ Fukushima",
"818893", "Sakawa\,\ Kochi",
"819975", "Naze\,\ Kagoshima",
"8112390", "Yubari\,\ Hokkaido",
"81998", "Kagoshima\,\ Kagoshima",
"815745", "Minokamo\,\ Gifu",
"8153968", "Hamamatsu\,\ Shizuoka",
"81923", "Fukuoka\,\ Fukuoka",
"817715", "Kameoka\,\ Kyoto",
"812586", "Nagaoka\,\ Niigata",
"81944", "Setaka\,\ Fukuoka",
"812386", "Nagai\,\ Yamagata",
"814298", "Hanno\,\ Saitama",
"811586", "Nakayubetsu\,\ Hokkaido",
"814798", "Yokaichiba\,\ Chiba",
"81538", "Iwata\,\ Shizuoka",
"819684", "Yamaga\,\ Kumamoto",
"811945", "Kuji\,\ Iwate",
"819936", "Kaseda\,\ Kagoshima",
"819786", "Kitsuki\,\ Oita",
"817943", "Kakogawa\,\ Hyogo",
"812996", "Itako\,\ Ibaraki",
"818667", "Ibara\,\ Okayama",
"814795", "Choshi\,\ Chiba",
"811647", "Haboro\,\ Hokkaido",
"811933", "Kamaishi\,\ Iwate",
"81727", "Ikeda\,\ Osaka",
"812897", "Kanuma\,\ Tochigi",
"8199331", "Kagoshima\,\ Kagoshima",
"81965", "Yatsushiro\,\ Kumamoto",
"817718", "Sonobe\,\ Kyoto",
"818676", "Kuse\,\ Okayama",
"81888", "Kochi\,\ Kochi",
"81531", "Tahara\,\ Aichi",
"81480", "Kuki\,\ Saitama",
"812619", "Omachi\,\ Nagano",
"812647", "Nagano\,\ Nagano",
"812933", "Takahagi\,\ Ibaraki",
"81551", "Nirasaki\,\ Yamanashi",
"812783", "Numata\,\ Gunma",
"815983", "Matsusaka\,\ Mie",
"819954", "Kajiki\,\ Kagoshima",
"817702", "Tsuruga\,\ Fukui",
"812488", "Sukagawa\,\ Fukushima",
"815733", "Ena\,\ Gifu",
"818292", "Hiroshima\,\ Hiroshima",
"818249", "Higashi\-ku\,\ Hiroshima",
"819978", "Tokunoshima\,\ Kagoshima",
"81734", "Wakayama\,\ Wakayama",
"812564", "Sanjo\,\ Niigata",
"812830", "Utsunomiya\,\ Tochigi",
"818836", "Mima\,\ Tokushima",
"812415", "Yanaizu\,\ Fukushima",
"811364", "Kutchan\,\ Hokkaido",
"815393", "Hamamatsu\,\ Shizuoka",
"818544", "Kisuki\,\ Shimane",
"8153967", "Hamamatsu\,\ Shizuoka",
"811564", "Kamishihoro\,\ Hokkaido",
"817723", "Miyazu\,\ Kyoto",
"81494", "Chichibu\,\ Saitama",
"819666", "Minamata\,\ Kumamoto",
"811357", "Iwanai\,\ Hokkaido",
"812486", "Sukagawa\,\ Fukushima",
"81174", "Kanita\,\ Aomori",
"81934", "Kitakyushu\,\ Fukuoka",
"817677", "Nanao\,\ Ishikawa",
"819976", "Naze\,\ Kagoshima",
"81124", "Ashibetsu\,\ Hokkaido",
"818693", "Oku\,\ Okayama",
"8153972", "Hamamatsu\,\ Shizuoka",
"817954", "Nishiwaki\,\ Hyogo",
"815746", "Minokamo\,\ Gifu",
"811863", "Kazuno\,\ Akita",
"819967", "Izumi\,\ Kagoshima",
"819723", "Saiki\,\ Oita",
"8152", "Nagoya\,\ Aichi",
"81548", "Haibara\,\ Shizuoka",
"811523", "Shari\,\ Hokkaido",
"818843", "Anan\,\ Tokushima",
"819668", "Minamata\,\ Kumamoto",
"81765", "Uozu\,\ Toyama",
"81977", "Beppu\,\ Oita",
"811585", "Engaru\,\ Hokkaido",
"811946", "Kuji\,\ Iwate",
"81949", "Nogata\,\ Fukuoka",
"81927", "Fukuoka\,\ Fukuoka",
"81243", "Nihonmatsu\,\ Fukushima",
"81594", "Kuwana\,\ Mie",
"812995", "Ishioka\,\ Ibaraki",
"8153966", "Hamamatsu\,\ Shizuoka",
"819785", "Bungotakada\,\ Oita",
"81157", "Kitami\,\ Hokkaido",
"819935", "Kaseda\,\ Kagoshima",
"817716", "Sonobe\,\ Kyoto",
"817993", "Sumoto\,\ Hyogo",
"818678", "Niimi\,\ Okayama",
"81143", "Muroran\,\ Hokkaido",
"818654", "Kamogata\,\ Okayama",
"812585", "Nagaoka\,\ Niigata",
"817614", "Komatsu\,\ Ishikawa",
"815367", "Shitara\,\ Aichi",
"812571", "Muika\,\ Niigata",
"812385", "Yonezawa\,\ Yamagata",
"818977", "Hakata\,\ Ehime",
"818675", "Kuse\,\ Okayama",
"81744", "Yamatotakada\,\ Nara",
"812588", "Nagaoka\,\ Niigata",
"81192", "Ofunato\,\ Iwate",
"818553", "Hamada\,\ Shimane",
"8112393", "Yubari\,\ Hokkaido",
"81460", "Odawara\,\ Kanagawa",
"818372", "Nagato\,\ Yamaguchi",
"812388", "Nagai\,\ Yamagata",
"811588", "Okoppe\,\ Hokkaido",
"819943", "Kanoya\,\ Kagoshima",
"81292", "Mito\,\ Ibaraki",
"812612", "Omachi\,\ Nagano",
"812697", "Iiyama\,\ Nagano",
"814796", "Yokaichiba\,\ Chiba",
"81985", "Miyazaki\,\ Miyazaki",
"817684", "Wajima\,\ Ishikawa",
"815752", "Sekigahara\,\ Gifu",
"819938", "Kaseda\,\ Kagoshima",
"811464", "Shizunai\,\ Hokkaido",
"819788", "Kunisaki\,\ Oita",
"812998", "Itako\,\ Ibaraki",
"81438", "Kisarazu\,\ Chiba",
"819822", "Nobeoka\,\ Miyazaki",
"812416", "Tajima\,\ Fukushima",
"818835", "Mima\,\ Tokushima",
"81739", "Tanabe\,\ Wakayama",
"8112395", "Kuriyama\,\ Hokkaido",
"818299", "Hiroshima\,\ Hiroshima",
"818242", "Higashi\-ku\,\ Hiroshima",
"818479", "Tojo\,\ Hiroshima",
"81572", "Tajimi\,\ Gifu",
"819665", "Hitoyoshi\,\ Kumamoto",
"8182941", "Hiroshima\,\ Hiroshima",
"811952", "Ninohe\,\ Iwate",
"81723", "Sakai\,\ Osaka",
"811973", "Mizusawa\,\ Iwate",
"81798", "Nishinomiya\,\ Hyogo",
"819803", "Nago\,\ Okinawa",
"818594", "Yonago\,\ Tottori",
"812555", "Itoigawa\,\ Niigata",
"818684", "Tsuyama\,\ Okayama",
"81484", "Kawaguchi\,\ Saitama",
"812652", "Iida\,\ Nagano",
"812673", "Komoro\,\ Nagano",
"81246", "Iwaki\,\ Fukushima",
"8153971", "Hamamatsu\,\ Shizuoka",
"819965", "Satsumasendai\,\ Kagoshima",
"8153978", "Hamamatsu\,\ Shizuoka",
"811652", "Shibetsu\,\ Hokkaido",
"812859", "Oyama\,\ Tochigi",
"812780", "Maebashi\,\ Gunma",
"811555", "Obihiro\,\ Hokkaido",
"817353", "Shingu\,\ Fukuoka",
"812930", "Mito\,\ Ibaraki",
"8125489", "Tsugawa\,\ Niigata",
"817675", "Nanao\,\ Ishikawa",
"812387", "Nagai\,\ Yamagata",
"818975", "Niihama\,\ Ehime",
"812833", "Utsunomiya\,\ Tochigi",
"81162", "Wakkanai\,\ Hokkaido",
"812587", "Nagaoka\,\ Niigata",
"81823", "Kure\,\ Hiroshima",
"81545", "Fuji\,\ Shizuoka",
"81898", "Imabari\,\ Ehime",
"819937", "Kaseda\,\ Kagoshima",
"812997", "Itako\,\ Ibaraki",
"814289", "Ome\,\ Tokyo",
"819787", "Kunisaki\,\ Oita",
"81262", "Nagano\,\ Nagano",
"818391", "Ogori\,\ Yamaguchi",
"817734", "Fukuchiyama\,\ Kyoto",
"811587", "Nakayubetsu\,\ Hokkaido",
"812698", "Iiyama\,\ Nagano",
"81839", "Yamaguchi\,\ Yamaguchi",
"811232", "Chitose\,\ Hokkaido",
"819544", "Takeo\,\ Saga",
"811732", "Goshogawara\,\ Aomori",
"811646", "Haboro\,\ Hokkaido",
"811982", "Hanamaki\,\ Iwate",
"8198295", "Hyuga\,\ Miyazaki",
"812896", "Kanuma\,\ Tochigi",
"814770", "Ichikawa\,\ Chiba",
"812549", "Tsugawa\,\ Niigata",
"81564", "Okazaki\,\ Aichi",
"818666", "Ibara\,\ Okayama",
"812695", "Nakano\,\ Nagano",
"815368", "Shitara\,\ Aichi",
"81726", "Ibaraki\,\ Osaka",
"812646", "Nagano\,\ Nagano",
"818978", "Hakata\,\ Ehime",
"81776", "Fukui\,\ Fukui",
"812232", "Iwanuma\,\ Miyagi",
"811392", "Kikonai\,\ Hokkaido",
"818954", "Uwajima\,\ Ehime",
"818369", "Ube\,\ Yamaguchi",
"817914", "Aioi\,\ Hyogo",
"812744", "Fujioka\,\ Gunma",
"815979", "Kumano\,\ Mie",
"811549", "Kushiro\,\ Hokkaido",
"812244", "Shiroishi\,\ Miyagi",
"818677", "Niimi\,\ Okayama",
"81988", "Naha\,\ Okinawa",
"811558", "Hiroo\,\ Hokkaido",
"819676", "Takamori\,\ Kumamoto",
"8198293", "Nobeoka\,\ Miyazaki",
"817678", "Nanao\,\ Ishikawa",
"811374", "Mori\,\ Hokkaido",
"8147955", "Yokaichiba\,\ Chiba",
"817903", "Fukusaki\,\ Hyogo",
"819667", "Minamata\,\ Kumamoto",
"818583", "Kurayoshi\,\ Tottori",
"812574", "Kashiwazaki\,\ Niigata",
"8182942", "Hiroshima\,\ Hiroshima",
"817940", "Kakogawa\,\ Hyogo",
"818383", "Hagi\,\ Yamaguchi",
"818462", "Takehara\,\ Hiroshima",
"81940", "Munakata\,\ Fukuoka",
"812374", "Murayama\,\ Yamagata",
"819968", "Izumi\,\ Kagoshima",
"81535", "Hamamatsu\,\ Shizuoka",
"817494", "Hikone\,\ Shiga",
"811556", "Obihiro\,\ Hokkaido",
"817676", "Nanao\,\ Ishikawa",
"811852", "Oga\,\ Akita",
"812659", "Ina\,\ Nagano",
"811873", "Kakunodate\,\ Akita",
"819977", "Setouchi\,\ Kagoshima",
"81489", "Soka\,\ Saitama",
"81555", "Fujiyoshida\,\ Yamanashi",
"811356", "Iwanai\,\ Hokkaido",
"812487", "Sukagawa\,\ Fukushima",
"81849", "Fukuyama\,\ Hiroshima",
"81827", "Iwakuni\,\ Yamaguchi",
"817968", "Hamasaka\,\ Hyogo",
"812556", "Itoigawa\,\ Niigata",
"81877", "Marugame\,\ Kagawa",
"81740", "Imazu\,\ Shiga",
"814705", "Tateyama\,\ Chiba",
"819940", "Shibushi\,\ Kagoshima",
"819966", "Izumi\,\ Kagoshima",
"812852", "Oyama\,\ Tochigi",
"81464", "Atsugi\,\ Kanagawa",
"812873", "Otawara\,\ Tochigi",
"8147950", "Yokaichiba\,\ Chiba",
"8153976", "Hamamatsu\,\ Shizuoka",
"812898", "Kanuma\,\ Tochigi",
"81236", "Yamagata\,\ Yamagata",
"811947", "Kuji\,\ Iwate",
"818668", "Ibara\,\ Okayama",
"81282", "Tochigi\,\ Tochigi",
"815366", "Shitara\,\ Aichi",
"81834", "Tokuyama\,\ Yamaguchi",
"812648", "Nagano\,\ Nagano",
"818976", "Niihama\,\ Ehime",
"811455", "Mukawa\,\ Hokkaido",
"8198290", "Nobeoka\,\ Miyazaki",
"815566", "Minobu\,\ Yamanashi",
"817453", "Yamatotakada\,\ Nara",
"8186994", "Seto\,\ Okayama",
"8182920", "Hatsukaichi\,\ Hiroshima",
"817717", "Sonobe\,\ Kyoto",
"818202", "Yanai\,\ Yamaguchi",
"814282", "Ome\,\ Tokyo",
"81182", "Yokote\,\ Akita",
"81926", "Fukuoka\,\ Fukuoka",
"818690", "Okayama\,\ Okayama",
"815763", "Gero\,\ Gifu",
"8161", "Osaka\,\ Osaka",
"81270", "Isesaki\,\ Gunma",
"81569", "Handa\,\ Aichi",
"812542", "Shibata\,\ Niigata",
"81584", "Ogaki\,\ Gifu",
"812474", "Ishikawa\,\ Fukushima",
"811542", "Kushiro\,\ Hokkaido",
"812895", "Utsunomiya\,\ Tochigi",
"81930", "Yukuhashi\,\ Fukuoka",
"819734", "Hita\,\ Oita",
"815972", "Owase\,\ Mie",
"811645", "Rumoi\,\ Hokkaido",
"812794", "Shibukawa\,\ Gunma",
"818362", "Ube\,\ Yamaguchi",
"814797", "Yokaichiba\,\ Chiba",
"818665", "Takahashi\,\ Okayama",
"811534", "Nakashibetsu\,\ Hokkaido",
"812239", "Sendai\,\ Miyagi",
"819742", "Mie\,\ Oita",
"81950", "Hirado\,\ Nagasaki",
"814297", "Hanno\,\ Saitama",
"812696", "Iiyama\,\ Nagano",
"818562", "Masuda\,\ Shimane",
"817965", "Toyooka\,\ Hyogo",
"8126179", "Omachi\,\ Nagano",
"81885", "Komatsushima\,\ Tokushima",
"818943", "Yawatahama\,\ Ehime",
"815994", "Ago\,\ Mie",
"819432", "Yame\,\ Fukuoka",
"819572", "Isahaya\,\ Nagasaki",
"819553", "Imari\,\ Saga",
"815584", "Shimoda\,\ Shizuoka",
"8162", "Osaka\,\ Osaka",
"8167", "Osaka\,\ Osaka",
"812963", "Shimodate\,\ Ibaraki",
"811753", "Mutsu\,\ Aomori",
"8153964", "Hamamatsu\,\ Shizuoka",
"81948", "Iizuka\,\ Fukuoka",
"81465", "Odawara\,\ Kanagawa",
"812899", "Kanuma\,\ Tochigi",
"812235", "Sendai\,\ Miyagi",
"811395", "Esashi\,\ Hokkaido",
"812546", "Murakami\,\ Niigata",
"818669", "Soja\,\ Okayama",
"812560", "Itoigawa\,\ Niigata",
"812834", "Utsunomiya\,\ Tochigi",
"818377", "Shimonoseki\,\ Yamaguchi",
"81554", "Otsuki\,\ Yamanashi",
"817733", "Fukuchiyama\,\ Kyoto",
"812649", "Nagano\,\ Nagano",
"812692", "Nakano\,\ Nagano",
"819746", "Taketa\,\ Oita",
"818366", "Ube\,\ Yamaguchi",
"81534", "Hamamatsu\,\ Shizuoka",
"811735", "Goshogawara\,\ Aomori",
"811546", "Kushiro\,\ Hokkaido",
"811235", "Yubari\,\ Hokkaido",
"819827", "Takachiho\,\ Miyazaki",
"812957", "Daigo\,\ Ibaraki",
"819679", "Takamori\,\ Kumamoto",
"818683", "Tsuyama\,\ Okayama",
"812658", "Ina\,\ Nagano",
"81835", "Hofu\,\ Yamaguchi",
"812674", "Komoro\,\ Nagano",
"818247", "Shobara\,\ Hiroshima",
"811957", "Iwate\,\ Iwate",
"817969", "Hamasaka\,\ Hyogo",
"81549", "Shizuoka\,\ Shizuoka",
"8186992", "Bizen\,\ Okayama",
"818514", "Ama\,\ Shimane",
"8112399", "Kuriyama\,\ Hokkaido",
"81577", "Takayama\,\ Gifu",
"819576", "Shimabara\,\ Nagasaki",
"818490", "Onomichi\,\ Hiroshima",
"811658", "Kamikawa\,\ Hokkaido",
"817354", "Shingu\,\ Fukuoka",
"811352", "Yoichi\,\ Hokkaido",
"81439", "Kisarazu\,\ Chiba",
"817904", "Fukusaki\,\ Hyogo",
"81738", "Gobo\,\ Wakayama",
"811856", "Noshiro\,\ Akita",
"817672", "Hakui\,\ Ishikawa",
"811552", "Obihiro\,\ Hokkaido",
"814709", "Kamogawa\,\ Chiba",
"81585", "Ibigawa\,\ Gifu",
"811655", "Nayoro\,\ Hokkaido",
"819962", "Satsumasendai\,\ Kagoshima",
"8188096", "Tosashimizu\,\ Kochi",
"818384", "Hagi\,\ Yamaguchi",
"812856", "Mooka\,\ Tochigi",
"81473", "Ichikawa\,\ Chiba",
"812373", "Murayama\,\ Yamagata",
"81423", "Kokubunji\,\ Tokyo",
"812655", "Iida\,\ Nagano",
"818584", "Kurayoshi\,\ Tottori",
"812552", "Joetsu\,\ Niigata",
"812573", "Kashiwazaki\,\ Niigata",
"81286", "Utsunomiya\,\ Tochigi",
"819543", "Takeo\,\ Saga",
"81252", "Niigata\,\ Niigata",
"818263", "Kake\,\ Hiroshima",
"811238", "Kuriyama\,\ Hokkaido",
"814286", "Sagamihara\,\ Kanagawa",
"818206", "Yanai\,\ Yamaguchi",
"812743", "Fujioka\,\ Gunma",
"81922", "Fukuoka\,\ Fukuoka",
"812243", "Shiroishi\,\ Miyagi",
"817476", "Shimonoseki\,\ Yamaguchi",
"811398", "Kumaishi\,\ Hokkaido",
"812238", "Sendai\,\ Miyagi",
"818972", "Niihama\,\ Ehime",
"818953", "Uwajima\,\ Ehime",
"815362", "Shinshiro\,\ Aichi",
"818565", "Masuda\,\ Shimane",
"811634", "Hamatonbetsu\,\ Hokkaido",
"8188097", "Tosashimizu\,\ Kochi",
"81845", "Innoshima\,\ Hiroshima",
"818662", "Takahashi\,\ Okayama",
"812892", "Utsunomiya\,\ Tochigi",
"811986", "Tono\,\ Iwate",
"811736", "Goshogawara\,\ Aomori",
"818365", "Ube\,\ Yamaguchi",
"811545", "Kushiro\,\ Hokkaido",
"811236", "Chitose\,\ Hokkaido",
"817454", "Yamatotakada\,\ Nara",
"814288", "Ome\,\ Tokyo",
"81722", "Sakai\,\ Osaka",
"811396", "Esashi\,\ Hokkaido",
"812545", "Murakami\,\ Niigata",
"812236", "Sendai\,\ Miyagi",
"81485", "Kumagaya\,\ Saitama",
"81559", "Numazu\,\ Shizuoka",
"818477", "Tojo\,\ Hiroshima",
"817707", "Obama\,\ Fukui",
"811874", "Kakunodate\,\ Akita",
"81958", "Nagasaki\,\ Nagasaki",
"818297", "Hatsukaichi\,\ Hiroshima",
"818797", "Tonosho\,\ Kagawa",
"811858", "Noshiro\,\ Akita",
"81938", "Kitakyushu\,\ Fukuoka",
"819575", "Isahaya\,\ Nagasaki",
"817493", "Hikone\,\ Shiga",
"81178", "Hachinohe\,\ Aomori",
"8128798", "Otawara\,\ Tochigi",
"819435", "Yame\,\ Fukuoka",
"812858", "Mooka\,\ Tochigi",
"812874", "Otawara\,\ Tochigi",
"81544", "Fujinomiya\,\ Shizuoka",
"818466", "Mima\,\ Tokushima",
"817962", "Toyooka\,\ Hyogo",
"812855", "Oyama\,\ Tochigi",
"815993", "Toba\,\ Mie",
"819438", "Tanushimaru\,\ Fukuoka",
"814702", "Tateyama\,\ Chiba",
"811559", "Obihiro\,\ Hokkaido",
"812656", "Ina\,\ Nagano",
"81434", "Chiba\,\ Chiba",
"81242", "Aizuwakamatsu\,\ Fukushima",
"814757", "Togane\,\ Chiba",
"817367", "Iwade\,\ Wakayama",
"818944", "Yawatahama\,\ Ehime",
"81565", "Toyota\,\ Aichi",
"812559", "Yasuzuka\,\ Niigata",
"811855", "Noshiro\,\ Akita",
"812964", "Shimodate\,\ Ibaraki",
"811754", "Mutsu\,\ Aomori",
"815583", "Shimoda\,\ Shizuoka",
"819554", "Imari\,\ Saga",
"81142", "Date\,\ Hokkaido",
"811656", "Bifuka\,\ Hokkaido",
"819578", "Shimabara\,\ Nagasaki",
"818205", "Yanai\,\ Yamaguchi",
"81864", "Kurashiki\,\ Okayama",
"814285", "Sagamihara\,\ Kanagawa",
"8188098", "Tosashimizu\,\ Kochi",
"817475", "Shimonoseki\,\ Yamaguchi",
"81591", "Tsu\,\ Mie",
"819593", "Oseto\,\ Nagasaki",
"815764", "Gero\,\ Gifu",
"81166", "Asahikawa\,\ Hokkaido",
"81427", "Sagamihara\,\ Kanagawa",
"817950", "Sanda\,\ Hyogo",
"814771", "Ichikawa\,\ Chiba",
"811452", "Hayakita\,\ Hokkaido",
"818568", "Tsuwano\,\ Shimane",
"811533", "Nemuro\,\ Hokkaido",
"812473", "Ishikawa\,\ Fukushima",
"818368", "Ube\,\ Yamaguchi",
"811333", "Tobetsu\,\ Hokkaido",
"81266", "Suwa\,\ Nagano",
"815978", "Kumano\,\ Mie",
"819233", "Maebaru\,\ Fukuoka",
"811548", "Teshikaga\,\ Hokkaido",
"812793", "Shibukawa\,\ Gunma",
"819733", "Hita\,\ Oita",
"8186552", "Kurashiki\,\ Okayama",
"812554", "Joetsu\,\ Niigata",
"818685", "Tsuyama\,\ Okayama",
"812578", "Muika\,\ Niigata",
"818582", "Kurayoshi\,\ Tottori",
"81474", "Funabashi\,\ Chiba",
"819964", "Satsumasendai\,\ Kagoshima",
"818463", "Takehara\,\ Hiroshima",
"818382", "Hagi\,\ Yamaguchi",
"812378", "Sagae\,\ Yamagata",
"81942", "Kurume\,\ Fukuoka",
"811554", "Obihiro\,\ Hokkaido",
"817496", "Nagahama\,\ Shiga",
"817902", "Fukusaki\,\ Hyogo",
"817674", "Hakui\,\ Ishikawa",
"811378", "Imakane\,\ Hokkaido",
"818949", "Uwajima\,\ Ehime",
"811354", "Yoichi\,\ Hokkaido",
"818974", "Niihama\,\ Ehime",
"811393", "Matsumae\,\ Hokkaido",
"8175", "Kyoto\,\ Kyoto",
"812233", "Iwanuma\,\ Miyagi",
"817617", "Kaga\,\ Ishikawa",
"8125481", "Murakami\,\ Niigata",
"818958", "Misho\,\ Ehime",
"818657", "Kasaoka\,\ Okayama",
"812748", "Tomioka\,\ Gunma",
"815959", "Kameyama\,\ Mie",
"812248", "Ogawara\,\ Miyagi",
"811983", "Hanamaki\,\ Iwate",
"811733", "Goshogawara\,\ Aomori",
"8153979", "Hamamatsu\,\ Shizuoka",
"81797", "Nishinomiya\,\ Hyogo",
"811233", "Chitose\,\ Hokkaido",
"815769", "Shokawa\,\ Gifu",
"817735", "Fukuchiyama\,\ Kyoto",
"8125488", "Tsugawa\,\ Niigata",
"811336", "Ishikari\,\ Hokkaido",
"812476", "Miharu\,\ Fukushima",
"81492", "Kawagoe\,\ Saitama",
"812796", "Shibukawa\,\ Gunma",
"81553", "Yamanashi\,\ Yamanashi",
"812913", "Hokota\,\ Ibaraki",
"817687", "Noto\,\ Ishikawa",
"811536", "Akkeshi\,\ Hokkaido",
"817738", "Maizuru\,\ Kyoto",
"812694", "Nakano\,\ Nagano",
"817238", "Neyagawa\,\ Osaka",
"81533", "Toyohashi\,\ Aichi",
"814998", "Ogasawara\,\ Tokyo",
"812832", "Sano\,\ Tochigi",
"818955", "Uwajima\,\ Ehime",
"812745", "Fujioka\,\ Gunma",
"81547", "Shimada\,\ Shizuoka",
"817915", "Aioi\,\ Hyogo",
"8125487", "Tsugawa\,\ Niigata",
"8186995", "Seto\,\ Okayama",
"812245", "Ogawara\,\ Miyagi",
"81260", "Anan\,\ Nagano",
"818290", "Hiroshima\,\ Hiroshima",
"819596", "Fukue\,\ Nagasaki",
"815586", "Shimoda\,\ Shizuoka",
"817352", "Shingu\,\ Fukuoka",
"81138", "Hakodate\,\ Hokkaido",
"818512", "Nishigo\,\ Fukushima",
"81928", "Fukuoka\,\ Fukuoka",
"812879", "Nasukarasuyama\,\ Tochigi",
"811653", "Shibetsu\,\ Hokkaido",
"8166", "Osaka\,\ Osaka",
"811375", "Yakumo\,\ Hokkaido",
"818397", "Ogori\,\ Yamaguchi",
"818688", "Mimasaka\,\ Okayama",
"812672", "Komoro\,\ Nagano",
"812653", "Iida\,\ Nagano",
"8186993", "Bizen\,\ Okayama",
"812575", "Tokamachi\,\ Niigata",
"8126176", "Omachi\,\ Nagano",
"81199", "Morioka\,\ Iwate",
"815996", "Ago\,\ Mie",
"812375", "Murayama\,\ Yamagata",
"817495", "Nagahama\,\ Shiga",
"819552", "Imari\,\ Saga",
"819573", "Isahaya\,\ Nagasaki",
"8199345", "Kagoshima\,\ Kagoshima",
"81728", "Neyagawa\,\ Osaka",
"812962", "Shimodate\,\ Ibaraki",
"814291", "Hanno\,\ Saitama",
"811752", "Mutsu\,\ Aomori",
"81429", "Tokorozawa\,\ Saitama",
"81778", "Takefu\,\ Fukui",
"8125486", "Tsugawa\,\ Niigata",
"81793", "Himeji\,\ Hyogo",
"818686", "Tsuyama\,\ Okayama",
"818942", "Yawatahama\,\ Ehime",
"81592", "Tsu\,\ Mie",
"81433", "Chiba\,\ Chiba",
"814704", "Tateyama\,\ Chiba",
"819433", "Yame\,\ Fukuoka",
"815998", "Ago\,\ Mie",
"812478", "Miharu\,\ Fukushima",
"818363", "Ube\,\ Yamaguchi",
"815973", "Owase\,\ Mie",
"812798", "Naganohara\,\ Gunma",
"811543", "Kushiro\,\ Hokkaido",
"8198294", "Nobeoka\,\ Miyazaki",
"819738", "Kusu\,\ Oita",
"817736", "Maizuru\,\ Kyoto",
"8199343", "Kagoshima\,\ Kagoshima",
"818563", "Masuda\,\ Shimane",
"819687", "Tamana\,\ Kumamoto",
"81272", "Maebashi\,\ Gunma",
"819743", "Mie\,\ Oita",
"81222", "Sendai\,\ Miyagi",
"812543", "Shibata\,\ Niigata",
"811454", "Mukawa\,\ Hokkaido",
"81952", "Saga\,\ Saga",
"8186553", "Kurashiki\,\ Okayama",
"815762", "Gero\,\ Gifu",
"81863", "Tamano\,\ Okayama",
"8186697", "Kurashiki\,\ Okayama",
"81986", "Miyakonojo\,\ Miyazaki",
"81932", "Kitakyushu\,\ Fukuoka",
"813", "Tokyo",
"81172", "Hirosaki\,\ Aomori",
"819598", "Fukue\,\ Nagasaki",
"81280", "Koga\,\ Ibaraki",
"818956", "Uwajima\,\ Ehime",
"8186691", "Kurashiki\,\ Okayama",
"8126178", "Omachi\,\ Nagano",
"818203", "Yanai\,\ Yamaguchi",
"812746", "Tomioka\,\ Gunma",
"814283", "Ome\,\ Tokyo",
"817452", "Yamatotakada\,\ Nara",
"81766", "Takaoka\,\ Toyama",
"812246", "Ogawara\,\ Miyagi",
"819546", "Kashima\,\ Saga",
"818240", "Higashi\-ku\,\ Hiroshima",
"812475", "Ishikawa\,\ Fukushima",
"819735", "Hita\,\ Oita",
"812894", "Utsunomiya\,\ Tochigi",
"812795", "Shibukawa\,\ Gunma",
"811644", "Rumoi\,\ Hokkaido",
"811535", "Akkeshi\,\ Hokkaido",
"818664", "Takahashi\,\ Okayama",
"812839", "Sano\,\ Tochigi",
"811632", "Teshio\,\ Hokkaido",
"8186698", "Kurashiki\,\ Okayama",
"8126171", "Omachi\,\ Nagano",
"81875", "Kan\'onji\,\ Kagawa",
"817964", "Toyooka\,\ Hyogo",
"81543", "Shizuoka\,\ Shizuoka",
"81825", "Hiroshima\,\ Hiroshima",
"812576", "Tokamachi\,\ Niigata",
"815995", "Ago\,\ Mie",
"81721", "Tondabayashi\,\ Osaka",
"818547", "Kakeya\,\ Shimane",
"812872", "Otawara\,\ Tochigi",
"812853", "Oyama\,\ Tochigi",
"81294", "Hitachiota\,\ Ibaraki",
"811367", "Suttsu\,\ Hokkaido",
"812376", "Sagae\,\ Yamagata",
"815585", "Shimoda\,\ Shizuoka",
"81896", "Iyomishima\,\ Ehime",
"81537", "Kakegawa\,\ Shizuoka",
"817498", "Nagahama\,\ Shiga",
"811376", "Yakumo\,\ Hokkaido",
"81742", "Nara\,\ Nara",
"8111", "Sapporo\,\ Hokkaido",
"819957", "Kajiki\,\ Kagoshima",
"8168", "Osaka\,\ Osaka",
"81557", "Ito\,\ Shizuoka",
"811853", "Oga\,\ Akita",
"812679", "Saku\,\ Nagano",
"812242", "Shiroishi\,\ Miyagi",
"8112391", "Yubari\,\ Hokkaido",
"817456", "Yamatotakada\,\ Nara",
"812742", "Fujioka\,\ Gunma",
"81762", "Kanazawa\,\ Ishikawa",
"812799", "Naganohara\,\ Gunma",
"817997", "Tsuna\,\ Hyogo",
"81250", "Niitsu\,\ Niigata",
"817912", "Aioi\,\ Hyogo",
"818952", "Uwajima\,\ Ehime",
"811394", "Matsumae\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"815363", "Shinshiro\,\ Aichi",
"818973", "Niihama\,\ Ehime",
"812835", "Sano\,\ Tochigi",
"818262", "Kake\,\ Hiroshima",
"8112398", "Kuriyama\,\ Hokkaido",
"811734", "Goshogawara\,\ Aomori",
"811984", "Hanamaki\,\ Iwate",
"81563", "Nishio\,\ Aichi",
"811234", "Chitose\,\ Hokkaido",
"819542", "Takeo\,\ Saga",
"819599", "Oseto\,\ Nagasaki",
"819727", "Usuki\,\ Oita",
"81268", "Ueda\,\ Nagano",
"812372", "Murayama\,\ Yamagata",
"818388", "Tamagawa\,\ Yamaguchi",
"819963", "Satsumasendai\,\ Kagoshima",
"818464", "Takehara\,\ Hiroshima",
"8198292", "Nobeoka\,\ Miyazaki",
"811867", "Takanosu\,\ Akita",
"812876", "Kuroiso\,\ Tochigi",
"818588", "Koge\,\ Tottori",
"812572", "Kashiwazaki\,\ Niigata",
"812553", "Joetsu\,\ Niigata",
"812675", "Saku\,\ Nagano",
"811527", "Bihoro\,\ Hokkaido",
"817673", "Hakui\,\ Ishikawa",
"811876", "Omagari\,\ Akita",
"811372", "Shikabe\,\ Hokkaido",
"8163", "Osaka\,\ Osaka",
"811353", "Yoichi\,\ Hokkaido",
"8182943", "Hiroshima\,\ Hiroshima",
"815999", "Tsu\,\ Mie",
"81892", "Kumakogen\,\ Ehime",
"81587", "Ichinomiya\,\ Aichi",
"811553", "Obihiro\,\ Hokkaido",
"8165", "Osaka\,\ Osaka",
"817355", "Shingu\,\ Fukuoka",
"818697", "Bizen\,\ Okayama",
"811756", "Noheji\,\ Aomori",
"817905", "Fukusaki\,\ Hyogo",
"811977", "Kitakami\,\ Iwate",
"819556", "Karatsu\,\ Saga",
"811654", "Nayoro\,\ Hokkaido",
"818385", "Hagi\,\ Yamaguchi",
"81857", "Tottori\,\ Tottori",
"812654", "Iida\,\ Nagano",
"818585", "Kurayoshi\,\ Tottori",
"818946", "Uwajima\,\ Ehime",
"81596", "Ise\,\ Mie",
"818682", "Tsuyama\,\ Okayama",
"812678", "Saku\,\ Nagano",
"81276", "Ota\,\ Gunma",
"819947", "Shibushi\,\ Kagoshima",
"817732", "Fukuchiyama\,\ Kyoto",
"812693", "Nakano\,\ Nagano",
"81226", "Kesennuma\,\ Miyagi",
"812914", "Hokota\,\ Ibaraki",
"81936", "Kitakyushu\,\ Fukuoka",
"818557", "Kawamoto\,\ Shimane",
"81126", "Iwamizawa\,\ Hokkaido",
"81467", "Fujisawa\,\ Kanagawa",
"818806", "Sukumo\,\ Kochi",
"81176", "Towada\,\ Aomori",
"81956", "Sasebo\,\ Nagasaki",
"815766", "Gero\,\ Gifu",
"812838", "Sano\,\ Tochigi",
"8112397", "Kuriyama\,\ Hokkaido",
"819744", "Mie\,\ Oita",
"811635", "Hamatonbetsu\,\ Hokkaido",
"818564", "Masuda\,\ Shimane",
"81583", "Gifu\,\ Gifu",
"811532", "Nemuro\,\ Hokkaido",
"819732", "Hita\,\ Oita",
"815974", "Owase\,\ Mie",
"817947", "Miki\,\ Hyogo",
"818364", "Ube\,\ Yamaguchi",
"812792", "Shibukawa\,\ Gunma",
"819232", "Maebaru\,\ Fukuoka",
"812472", "Ishikawa\,\ Fukushima",
"811544", "Kushiro\,\ Hokkaido",
"815958", "Kameyama\,\ Mie",
"811332", "Tobetsu\,\ Hokkaido",
"819592", "Oseto\,\ Nagasaki",
"817455", "Yamatotakada\,\ Nara",
"818808", "Tosashimizu\,\ Kochi",
"81425", "Tachikawa\,\ Tokyo",
"8164", "Osaka\,\ Osaka",
"811453", "Hayakita\,\ Hokkaido",
"812544", "Shibata\,\ Niigata",
"815768", "Gero\,\ Gifu",
"812836", "Sano\,\ Tochigi",
"811875", "Kakunodate\,\ Akita",
"812968", "Kasama\,\ Ibaraki",
"81567", "Tsushima\,\ Aichi",
"8112396", "Kuriyama\,\ Hokkaido",
"819558", "Karatsu\,\ Saga",
"819574", "Isahaya\,\ Nagasaki",
"817356", "Kushimoto\,\ Wakayama",
"814240", "Kokubunji\,\ Tokyo",
"81188", "Akita\,\ Akita",
"815582", "Shimoda\,\ Shizuoka",
"819434", "Yame\,\ Fukuoka",
"814703", "Tateyama\,\ Chiba",
"815992", "Toba\,\ Mie",
"812875", "Otawara\,\ Tochigi",
"817487", "Minakuchi\,\ Shiga",
"814777", "Funabashi\,\ Chiba",
"81288", "Imabari\,\ Ehime",
"818948", "Uwajima\,\ Ehime",
"812676", "Saku\,\ Nagano",
"812854", "Oyama\,\ Tochigi",
"812878", "Nasukarasuyama\,\ Tochigi",
"8188099", "Tosashimizu\,\ Kochi",
"818586", "Kurayoshi\,\ Tottori",
"81463", "Hiratsuka\,\ Kanagawa",
"817963", "Toyooka\,\ Hyogo",
"818945", "Yawatahama\,\ Ehime",
"818689", "Okayama\,\ Okayama",
"811878", "Omagari\,\ Akita",
"811854", "Oga\,\ Akita",
"815737", "Nakatsugawa\,\ Gifu",
"812965", "Shimodate\,\ Ibaraki",
"812580", "Tokamachi\,\ Niigata",
"817492", "Hikone\,\ Shiga",
"819555", "Karatsu\,\ Saga",
"81281", "Utsunomiya\,\ Tochigi",
"81946", "Amagi\,\ Fukuoka",
"818204", "Yanai\,\ Yamaguchi",
"814284", "Tachikawa\,\ Tokyo",
"8178", "Kobe\,\ Hyogo",
"8153965", "Hamamatsu\,\ Shizuoka",
"81833", "Kudamatsu\,\ Yamaguchi",
"815765", "Gero\,\ Gifu",
"812937", "Mito\,\ Ibaraki",
"81487", "Urawa\,\ Saitama",
"81962", "Kumamoto\,\ Kumamoto",
"812787", "Numata\,\ Gunma",
"817239", "Neyagawa\,\ Osaka",
"81853", "Izumo\,\ Shimane",
"818663", "Soja\,\ Okayama",
"811937", "Miyako\,\ Iwate",
"812893", "Utsunomiya\,\ Tochigi",};
$areanames{ja} = {"814776", "船橋",
"812890", "宇都宮",
"818845", "丹生谷",
"811525", "網走",
"81566", "刈谷",
"819824", "延岡",
"812569", "巻",
"819725", "佐伯",
"8198298", "日向",
"818660", "岡山瀬戸",
"811865", "大館",
"81724", "岸和田貝塚",
"818592", "米子",
"818549", "石見大田",
"812911", "鉾田",
"818695", "岡山瀬戸",
"819808", "八重山",
"8198291", "延岡",
"812640", "長野",
"818896", "須崎",
"812837", "佐野",
"812583", "長岡",
"818558", "川本",
"817995", "洲本",
"8145", "横浜",
"81737", "湯浅",
"817682", "輪島",
"8112392", "夕張",
"819783", "豊後高田",
"817946", "三木",
"815754", "関",
"812993", "石岡",
"817960", "八鹿",
"812614", "大町",
"811583", "紋別",
"811936", "宮古",
"81486", "浦和",
"81593", "四日市",
"817464", "吉野",
"814700", "鴨川",
"81792", "姫路",
"812936", "水戸",
"818555", "江津",
"818652", "倉敷",
"817998", "津名",
"81933", "北九州",
"817952", "西脇",
"819805", "名護",
"818698", "備前",
"81862", "岡山",
"815986", "松阪",
"81259", "佐渡",
"818848", "牟岐",
"818587", "郡家",
"81298", "土浦",
"81979", "中津",
"811528", "美幌",
"819728", "臼杵",
"818833", "鴨島",
"811868", "鷹巣",
"812562", "三条",
"818696", "備前",
"819973", "種子島",
"815988", "三瀬谷",
"818895", "須崎",
"818794", "三本松",
"81586", "一宮",
"818846", "丹生谷",
"811562", "本別",
"814775", "船橋",
"811526", "網走",
"819726", "臼杵",
"81552", "甲府",
"81493", "東松山",
"811866", "鷹巣",
"818542", "安来",
"81729", "八尾",
"817945", "加古川",
"811938", "宮古",
"811943", "岩泉",
"811637", "北見枝幸",
"812938", "水戸",
"817996", "津名",
"817713", "亀岡",
"812935", "水戸",
"818556", "江津",
"81277", "桐生",
"817948", "三木",
"812550", "安塚",
"811935", "釜石",
"815957", "上野",
"81177", "青森",
"81466", "藤沢",
"818947", "宇和",
"817364", "和歌山橋本",
"814754", "茂原",
"817959", "三田",
"812413", "喜多方",
"819806", "沖縄宮古",
"812967", "笠間",
"815985", "松阪",
"81471", "柏",
"818655", "鴨方",
"811939", "宮古",
"818552", "浜田",
"8183767", "下関",
"812384", "米沢",
"818373", "長門",
"812939", "水戸",
"81462", "厚木",
"8125482", "村上",
"81987", "日南",
"819934", "指宿",
"817688", "能都",
"81284", "足利",
"818687", "美作",
"818243", "東広島",
"81852", "松江",
"811953", "二戸",
"8169", "大阪",
"81184", "本荘",
"814280", "立川",
"81886", "徳島",
"817955", "三田",
"819802", "南大東",
"818598", "根雨",
"811377", "八雲",
"818692", "邑久",
"817958", "丹波柏原",
"812566", "三条",
"818595", "米子",
"818546", "掛合",
"811862", "鹿角",
"812377", "寒河江",
"819722", "佐伯",
"811522", "斜里",
"8188090", "窪川",
"819664", "人吉",
"81582", "岐阜",
"811566", "十勝清水",
"818842", "阿南",
"81975", "大分",
"817685", "輪島",
"818267", "千代田",
"8124196", "柳津",
"817992", "洲本",
"817949", "加古川",
"818674", "久世",
"812247", "大河原",
"818957", "御荘",
"8188093", "窪川",
"81725", "和泉",
"818559", "川本",
"811932", "釜石",
"81482", "川口",
"818656", "笠岡",
"812932", "高萩",
"818293", "廿日市",
"818473", "甲山",
"817703", "敦賀",
"815982", "松阪",
"812484", "白河",
"8124197", "柳津",
"815744", "美濃加茂",
"817956", "三田",
"812568", "巻",
"818548", "石見大田",
"819809", "八重山",
"81562", "尾張横須賀",
"818545", "木次",
"815997", "阿児",
"814772", "市川",
"8183766", "下関",
"818892", "佐川",
"815587", "修善寺大仁",
"814227", "武蔵野三鷹",
"812565", "三条",
"81763", "福野",
"812230", "仙台",
"811869", "大館",
"818596", "米子",
"81893", "大洲",
"81828", "広島",
"818874", "安芸",
"811537", "中標津",
"814794", "銚子",
"812477", "三春",
"817942", "加古川",
"817686", "能都",
"819737", "玖珠",
"818245", "三次",
"81468", "横須賀",
"818832", "鴨島",
"812955", "常陸大宮",
"817953", "西脇",
"819208", "対馬佐賀",
"812419", "田島",
"817706", "小浜",
"818476", "府中",
"811955", "二戸",
"818296", "広島",
"812237", "仙台",
"818375", "美祢",
"814220", "国分寺",
"8198299", "日向",
"811987", "遠野",
"811237", "栗山",
"81899", "松山",
"81426", "八王子",
"819782", "豊後高田",
"812992", "石岡",
"817683", "輪島",
"811582", "紋別",
"819944", "鹿屋",
"81495", "本庄",
"818378", "下関",
"812582", "長岡",
"819205", "厳原",
"81183", "湯沢",
"818593", "米子",
"811958", "岩手",
"811974", "水沢",
"812657", "伊那",
"819979", "徳之島",
"8125485", "津川",
"8186997", "岡山瀬戸",
"818248", "庄原",
"812974", "水海道",
"819577", "島原",
"818295", "廿日市",
"811956", "岩手",
"818475", "府中",
"817705", "小浜",
"81764", "富山",
"817484", "八日市",
"818246", "三次",
"812412", "喜多方",
"819437", "田主丸",
"81488", "浦和",
"812956", "常陸大宮",
"8186996", "岡山瀬戸",
"811547", "白糠",
"818567", "津和野",
"81125", "滝川",
"8199347", "鹿児島",
"81935", "北九州",
"819747", "竹田",
"812547", "村上",
"818376", "美祢",
"81196", "盛岡",
"8153974", "天竜",
"81225", "石巻",
"812784", "沼田",
"811589", "興部",
"812999", "潮来",
"814287", "青梅",
"819789", "杵築",
"817712", "亀岡",
"812589", "長岡",
"81568", "春日井",
"818680", "岡山",
"811942", "岩泉",
"811563", "本別",
"817724", "宮津",
"818543", "安来",
"817230", "寝屋川",
"812857", "真岡",
"81263", "松本",
"815394", "浜松",
"812563", "三条",
"81822", "広島",
"818478", "東城",
"818298", "廿日市",
"819972", "種子島",
"815734", "恵那",
"811857", "能代",
"812585", "長岡",
"817716", "園部",
"817993", "洲本",
"812571", "六日町",
"817614", "小松",
"81927", "福岡",
"811946", "久慈",
"81949", "直方",
"81765", "魚津",
"811585", "遠軽",
"819785", "豊後高田",
"812995", "石岡",
"81594", "桑名",
"819723", "佐伯",
"8152", "名古屋",
"811863", "鹿角",
"818838", "阿波池田",
"818843", "阿南",
"812557", "新井",
"811523", "斜里",
"81934", "北九州",
"81124", "芦別",
"819976", "名瀬",
"818693", "邑久",
"811557", "十勝池田",
"81798", "西宮",
"8182941", "広島",
"811952", "二戸",
"81723", "堺",
"8188094", "窪川",
"819803", "名護",
"8112395", "栗山",
"818835", "脇町",
"812416", "田島",
"818479", "東城",
"818299", "広島",
"818242", "東広島",
"811588", "興部",
"812697", "飯山",
"81292", "水戸",
"811464", "静内",
"812998", "潮来",
"819788", "国東",
"812588", "長岡",
"818553", "浜田",
"81192", "大船渡",
"818372", "長門",
"811945", "久慈",
"819684", "山鹿",
"811586", "中湧別",
"814298", "飯能",
"812996", "潮来",
"819786", "杵築",
"817943", "加古川",
"812586", "長岡",
"817715", "亀岡",
"81944", "瀬高",
"819975", "名瀬",
"818893", "佐川",
"81229", "古川",
"8153961", "天竜",
"814707", "大原",
"81253", "新潟",
"812418", "会津山口",
"81939", "北九州",
"812415", "柳津",
"818836", "脇町",
"811364", "倶知安",
"81494", "秩父",
"817967", "八鹿",
"819978", "徳之島",
"819954", "加治木",
"815983", "松阪",
"818249", "東広島",
"818292", "広島",
"818472", "甲山",
"817702", "敦賀",
"812830", "宇都宮",
"819677", "矢部",
"81888", "高知",
"81531", "田原",
"817718", "園部",
"812933", "高萩",
"812647", "長野",
"818667", "井原",
"811933", "釜石",
"811647", "羽幌",
"8199331", "鹿児島",
"812897", "鹿沼",
"81834", "徳山",
"815366", "設楽",
"811455", "鵡川",
"818976", "新居浜",
"818202", "柳井",
"81926", "福岡",
"8182920", "廿日市",
"817453", "大和高田",
"8186994", "岡山瀬戸",
"81236", "山形",
"81827", "岩国",
"81849", "福山",
"819966", "出水",
"812873", "大田原",
"819940", "志布志",
"8153962", "天竜",
"81535", "浜松",
"815747", "美濃白川",
"812487", "須賀川",
"811356", "岩内",
"817676", "七尾",
"811873", "角館",
"814224", "武蔵野三鷹",
"815584", "下田",
"819553", "伊万里",
"8167", "大阪",
"811753", "むつ",
"815994", "阿児",
"81930", "行橋",
"819734", "日田",
"815972", "尾鷲",
"818362", "宇部",
"812474", "石川",
"814797", "八日市場",
"811534", "中標津",
"818877", "嶺北",
"815763", "下呂",
"81220", "迫",
"818803", "土佐中村",
"819937", "加世田",
"814994", "三宅",
"81839", "山口",
"818975", "新居浜",
"812387", "長井",
"811456", "門別富川",
"81545", "富士",
"817353", "新宮",
"812780", "前橋",
"8125489", "津川",
"817675", "七尾",
"81246", "いわき",
"812673", "小諸",
"818684", "津山",
"819965", "川内",
"8182942", "広島",
"8153977", "天竜",
"819667", "水俣",
"819968", "出水",
"812374", "村山",
"818462", "竹原",
"818383", "萩",
"81940", "宗像",
"81988", "那覇",
"817903", "福崎",
"8147955", "八日市場",
"817678", "七尾",
"811374", "森",
"818954", "宇和島",
"81776", "福井",
"811392", "木古内",
"815368", "設楽",
"818978", "伯方",
"812244", "白石",
"818677", "新見",
"818369", "宇部",
"815979", "熊野",
"818264", "安芸吉田",
"811732", "五所川原",
"8198295", "日向",
"81544", "富士宮",
"818466", "木江",
"818797", "土庄",
"81958", "長崎",
"817493", "彦根",
"81178", "八戸",
"818208", "久賀",
"811396", "江差",
"8188097", "土佐清水",
"81845", "因島",
"811634", "浜頓別",
"811736", "五所川原",
"818365", "宇部",
"812793", "渋川",
"815954", "上野",
"811333", "当別",
"818368", "宇部",
"815978", "熊野",
"819233", "前原",
"81591", "津",
"819593", "大瀬戸",
"818205", "柳井",
"81427", "相模原",
"811452", "早来",
"814771", "市川",
"812964", "下館",
"819969", "中甑",
"81142", "伊達",
"814757", "東金",
"81242", "会津若松",
"81434", "千葉",
"817367", "岩出",
"818944", "八幡浜",
"8112399", "栗山",
"818490", "尾道",
"81549", "静岡",
"819827", "高千穂",
"81835", "防府",
"817733", "福知山",
"812617", "大町",
"815757", "郡上八幡",
"811735", "五所川原",
"818366", "宇部",
"81534", "浜松",
"812834", "宇都宮",
"811395", "江差",
"81922", "福岡",
"818206", "柳井",
"812743", "藤岡",
"818972", "新居浜",
"815362", "新城",
"811398", "熊石",
"819543", "武雄",
"811738", "鰺ケ沢",
"819962", "川内",
"8188096", "土佐清水",
"81473", "市川",
"812573", "柏崎",
"818584", "倉吉",
"817672", "羽咋",
"81738", "御坊",
"811352", "余市",
"81439", "木更津",
"815762", "下呂",
"8186553", "倉敷",
"81952", "佐賀",
"81172", "弘前",
"819598", "福江",
"81986", "都城",
"813", "東京",
"818802", "窪川",
"812798", "長野原",
"818363", "宇部",
"8126177", "長野",
"815973", "尾鷲",
"819687", "玉名",
"81272", "前橋",
"817736", "舞鶴",
"8199343", "鹿児島",
"81433", "千葉",
"814704", "館山",
"819552", "伊万里",
"817495", "長浜",
"81778", "武生",
"811752", "むつ",
"814291", "飯能",
"819674", "熊本一の宮",
"817498", "長浜",
"812679", "佐久",
"819957", "加治木",
"81557", "伊東",
"81742", "奈良",
"812576", "十日町",
"817964", "豊岡",
"81875", "観音寺",
"81543", "静岡",
"811367", "寿都",
"812872", "大田原",
"81721", "富田林",
"812894", "宇都宮",
"811644", "留萌",
"812795", "渋川",
"819546", "鹿島",
"8186698", "倉敷",
"818664", "高梁",
"81280", "古河",
"8186691", "倉敷",
"812644", "木曾福島",
"817452", "大和高田",
"819595", "有川",
"818203", "柳井",
"812746", "富岡",
"817916", "竜野",
"81797", "西宮",
"811733", "五所川原",
"8125488", "津川",
"815769", "荘川",
"817735", "福知山",
"8125481", "村上",
"817617", "加賀",
"811393", "松前",
"812748", "富岡",
"815564", "鰍沢青柳",
"811554", "帯広",
"817496", "長浜",
"817902", "福崎",
"81474", "船橋",
"812578", "六日町",
"812554", "上越",
"818463", "竹原",
"818382", "萩",
"812575", "十日町",
"8186993", "備前",
"812672", "小諸",
"81138", "函館",
"81928", "福岡",
"818512", "西郷",
"812879", "烏山",
"817352", "新宮",
"818397", "小郡",
"81260", "阿南町",
"819596", "福江",
"817915", "相生",
"812745", "藤岡",
"812796", "渋川",
"812913", "鉾田",
"811336", "石狩",
"817459", "大和榛原",
"812694", "中野",
"81533", "豊橋",
"817738", "舞鶴",
"812875", "大田原",
"819434", "八女",
"812676", "佐久",
"817487", "水口",
"81567", "津島",
"812579", "小出",
"811875", "角館",
"819574", "諫早",
"817356", "串本",
"819558", "唐津",
"818808", "土佐清水",
"819592", "大瀬戸",
"817455", "大和高田",
"811453", "早来",
"8164", "大阪",
"815768", "下呂",
"812544", "新発田",
"819744", "三重",
"818564", "益田",
"819232", "前原",
"811332", "当別",
"811544", "釧路",
"812792", "渋川",
"81833", "下松",
"817474", "五条",
"818805", "土佐中村",
"814284", "立川",
"817458", "大和榛原",
"815765", "下呂",
"812787", "沼田",
"81962", "熊本",
"81487", "浦和",
"811854", "男鹿",
"815737", "中津川",
"817906", "播磨山崎",
"811878", "大曲",
"81281", "宇都宮",
"817492", "彦根",
"819555", "唐津",
"812878", "烏山",
"815397", "浜松",
"812854", "小山",
"817727", "峰山",
"817908", "播磨山崎",
"811353", "余市",
"8163", "大阪",
"817673", "羽咋",
"811876", "大曲",
"817355", "新宮",
"81587", "一宮",
"8198292", "延岡",
"819963", "川内",
"812876", "黒磯",
"818388", "田万川",
"812675", "佐久",
"812572", "柏崎",
"811234", "千歳",
"819599", "大瀬戸",
"819542", "武雄",
"8112398", "栗山",
"811984", "花巻",
"817912", "相生",
"81250", "新津",
"812799", "長野原",
"812742", "藤岡",
"8112391", "夕張",
"817456", "大和高田",
"815363", "新城",
"812234", "仙台",
"818973", "新居浜",
"818806", "宿毛",
"81176", "十和田",
"81467", "藤沢",
"81956", "佐世保",
"815766", "下呂",
"819947", "志布志",
"817732", "福知山",
"81276", "太田",
"81857", "鳥取",
"812977", "竜ケ崎",
"818385", "萩",
"812678", "佐久",
"812654", "飯田",
"817905", "福崎",
"811756", "野辺地",
"811977", "北上",
"811654", "名寄",
"819556", "唐津",
"817486", "水口",
"81191", "一関",
"818244", "三次",
"812677", "佐久",
"812978", "竜ケ崎",
"817357", "串本",
"81774", "宇治",
"811954", "二戸",
"811978", "北上",
"812383", "米沢",
"81743", "奈良",
"818374", "長門",
"819933", "指宿",
"8186999", "岡山瀬戸",
"811462", "浦河",
"81542", "静岡",
"819948", "志布志",
"8147957", "八日市場",
"81244", "原町",
"81432", "千葉",
"81578", "神岡",
"819945", "鹿屋",
"817612", "小松",
"81144", "苫小牧",
"812786", "沼田",
"818673", "福渡",
"819204", "郷ノ浦",
"8198297", "日向",
"811975", "水沢",
"815736", "中津川",
"817907", "播磨山崎",
"81947", "田川",
"81929", "福岡",
"819663", "人吉",
"81273", "高崎",
"817726", "峰山",
"812975", "水海道",
"818387", "田万川",
"815396", "浜松",
"815743", "美濃加茂",
"819952", "大口",
"811877", "大曲",
"818474", "府中",
"817704", "敦賀",
"818294", "廿日市",
"812483", "白河",
"815738", "中津川",
"81532", "豊橋",
"817485", "八日市",
"8125484", "村上",
"8144", "川崎",
"817728", "峰山",
"81779", "大野",
"811362", "倶知安",
"814281", "相模原",
"812877", "黒磯",
"815398", "浜松",
"81478", "佐原",
"812788", "前橋",
"817457", "大和高田",
"8198296", "日向",
"81992", "鹿児島",
"812785", "沼田",
"815767", "下呂",
"818873", "安芸",
"81227", "仙台",
"81249", "郡山",
"818807", "宿毛",
"814793", "銚子",
"819946", "鹿屋",
"819682", "山鹿",
"81937", "北九州",
"817488", "水口",
"817725", "宮津",
"81234", "酒田",
"812976", "竜ケ崎",
"815395", "浜松",
"811541", "弟子屈",
"819557", "唐津",
"811757", "野辺地",
"81134", "小樽",
"815735", "恵那",
"81924", "福岡",
"811976", "北上",
"812584", "長岡",
"817615", "小松",
"812613", "大町",
"817737", "舞鶴",
"819686", "玉名",
"819942", "大根占",
"812789", "前橋",
"811584", "遠軽",
"815753", "関",
"812994", "石岡",
"819784", "豊後高田",
"819823", "延岡",
"812972", "水海道",
"811972", "水沢",
"81963", "熊本",
"818398", "小郡",
"81832", "下関",
"815399", "天竜",
"819956", "加治木",
"811366", "寿都",
"818834", "鴨島",
"812577", "六日町",
"818360", "小郡",
"817463", "吉野",
"8183768", "下関",
"81925", "福岡",
"819547", "鹿島",
"811465", "静内",
"811551", "十勝池田",
"81235", "鶴岡",
"817917", "竜野",
"812747", "富岡",
"812551", "上越",
"817618", "加賀",
"819685", "玉名",
"811944", "岩泉",
"81436", "市原",
"81775", "大津",
"817714", "亀岡",
"812782", "沼田",
"819949", "大根占",
"817616", "小松",
"815732", "恵那",
"819974", "屋久島",
"818793", "三本松",
"8188095", "土佐清水",
"812979", "竜ケ崎",
"81983", "高鍋",
"817497", "長浜",
"815392", "浜松",
"8112394", "夕張",
"817722", "宮津",
"812414", "柳津",
"811365", "倶知安",
"814753", "茂原",
"817482", "八日市",
"817363", "和歌山橋本",
"819955", "加治木",
"81245", "福島",
"81878", "高松",
"814701", "鴨川",
"81420", "所沢",
"819597", "福江",
"819688", "玉名",
"81546", "静岡",
"811337", "石狩",
"811466", "えりも",
"812797", "渋川",
"818844", "阿南",
"811524", "網走",
"819662", "人吉",
"819825", "日向",
"819724", "佐伯",
"818467", "木江",
"811864", "大館",
"8186998", "岡山瀬戸",
"818694", "岡山",
"818796", "土庄",
"811397", "奥尻",
"817613", "小松",
"81581", "高富",
"818672", "福渡",
"817994", "洲本",
"815755", "関",
"811737", "鰺ケ沢",
"817468", "上北山",
"812615", "大町",
"818879", "室戸",
"815758", "郡上八幡",
"81167", "富良野",
"811463", "浦河",
"812917", "水戸",
"81476", "成田",
"819932", "指宿",
"812618", "大町",
"817465", "吉野",
"812382", "米沢",
"818554", "浜田",
"8125483", "村上",
"81964", "松橋",
"819804", "名護",
"814756", "東金",
"81989", "那覇",
"817366", "岩出",
"812489", "須賀川",
"819828", "高千穂",
"8125480", "村上",
"81848", "尾道",
"818894", "須崎",
"818795", "三本松",
"814758", "東金",
"817368", "岩出",
"819826", "日向",
"818367", "宇部",
"817944", "加古川",
"812570", "小出",
"815756", "郡上八幡",
"815977", "熊野",
"818679", "新見",
"819683", "山鹿",
"812616", "大町",
"814792", "銚子",
"818872", "室戸",
"81561", "瀬戸",
"818493", "尾道",
"812934", "高萩",
"818207", "久賀",
"8188092", "窪川",
"811934", "釜石",
"812389", "米沢",
"817466", "十津川",
"817365", "和歌山橋本",
"814755", "東金",
"811363", "倶知安",
"81969", "天草",
"81550", "御殿場",
"815742", "美濃加茂",
"812482", "白河",
"81984", "小林",
"818798", "土庄",
"815984", "松阪",
"819953", "大口",
"818654", "鴨方",
"81143", "室蘭",
"818678", "新見",
"815367", "設楽",
"818977", "伯方",
"812385", "米沢",
"81243", "二本松",
"81977", "別府",
"819935", "加世田",
"81157", "北見",
"819967", "出水",
"819668", "水俣",
"81548", "榛原",
"817677", "七尾",
"81174", "蟹田",
"811357", "岩内",
"812486", "須賀川",
"815746", "美濃加茂",
"817954", "西脇",
"811973", "水沢",
"818594", "米子",
"81739", "田辺",
"812973", "水海道",
"819822", "延岡",
"81438", "木更津",
"81572", "多治見",
"819665", "人吉",
"814796", "八日市場",
"81985", "宮崎",
"819943", "鹿屋",
"812612", "大町",
"819938", "加世田",
"817684", "輪島",
"815752", "関",
"81744", "大和高田",
"818675", "久世",
"812388", "長井",
"81460", "小田原",
"8112393", "夕張",
"818876", "土佐山田",
"81538", "磐田",
"814798", "八日市場",
"819936", "加世田",
"811457", "門別富川",
"812386", "長井",
"818878", "嶺北",
"8112390", "夕張",
"812485", "白河",
"815745", "美濃加茂",
"81923", "福岡",
"81998", "鹿児島",
"817483", "八日市",
"81179", "三戸",
"817362", "和歌山橋本",
"814752", "茂原",
"81233", "新庄",
"818544", "木次",
"815393", "浜松",
"819666", "水俣",
"817723", "宮津",
"811564", "上士幌",
"818792", "三本松",
"815733", "恵那",
"812488", "須賀川",
"815748", "美濃白川",
"812564", "三条",
"81734", "和歌山",
"81480", "久喜",
"818676", "久世",
"81551", "韮崎",
"812619", "大町",
"812783", "沼田",
"818875", "土佐山田",
"814795", "銚子",
"81965", "八代",
"81727", "池田",
"8198290", "延岡",
"812648", "長野",
"814282", "青梅",
"817717", "園部",
"81182", "横手",
"817472", "五条",
"815566", "身延",
"811648", "焼尻",
"812898", "鹿沼",
"811947", "久慈",
"818668", "井原",
"81282", "栃木",
"81740", "今津",
"81877", "丸亀",
"817968", "浜坂",
"812556", "糸魚川",
"81464", "厚木",
"812852", "小山",
"8147950", "八日市場",
"814705", "館山",
"817494", "彦根",
"819678", "矢部",
"811556", "帯広",
"811852", "男鹿",
"819977", "瀬戸内",
"81555", "吉田",
"81489", "草加",
"812659", "伊那",
"819675", "熊本一の宮",
"819572", "諫早",
"812963", "下館",
"8162", "大阪",
"818943", "八幡浜",
"817965", "豊岡",
"81885", "小松島",
"819432", "八女",
"812417", "会津山口",
"814708", "大原",
"812895", "宇都宮",
"815953", "上野",
"811645", "留萌",
"812794", "渋川",
"81584", "大垣",
"811542", "釧路",
"814297", "飯能",
"81950", "平戸",
"819742", "三重",
"818562", "益田",
"812696", "飯山",
"812239", "仙台",
"818665", "高梁",
"8161", "大阪",
"812542", "新発田",
"81569", "半田",
"81270", "伊勢崎",
"818690", "岡山",
"812645", "木曾福島",
"819594", "有川",
"81262", "長野",
"819787", "国東",
"814289", "青梅",
"812997", "潮来",
"811587", "中湧別",
"812698", "飯山",
"818391", "小郡",
"817734", "福知山",
"812833", "宇都宮",
"81162", "稚内",
"81898", "今治",
"812587", "長岡",
"81823", "呉",
"815565", "鰍沢青柳",
"811555", "帯広",
"812930", "水戸",
"811652", "士別",
"812859", "小山",
"812652", "飯田",
"81484", "川口",
"812555", "糸魚川",
"814706", "大原",
"817940", "加古川",
"812574", "柏崎",
"818583", "倉吉",
"812558", "新井",
"817966", "八鹿",
"818837", "阿波池田",
"819676", "高森",
"811558", "広尾",
"8198293", "延岡",
"812232", "岩沼",
"812646", "長野",
"81726", "茨木",
"811549", "釧路",
"812744", "藤岡",
"817914", "相生",
"811646", "羽幌",
"812896", "鹿沼",
"814770", "市川",
"811982", "花巻",
"811232", "千歳",
"819544", "武雄",
"812695", "中野",
"818666", "井原",
"81564", "岡崎",
"812549", "津川",
"812874", "大田原",
"8128798", "大田原",
"819435", "八女",
"812858", "真岡",
"817962", "豊岡",
"81228", "築館",
"811858", "能代",
"818297", "廿日市",
"811874", "角館",
"817707", "小浜",
"818477", "東城",
"819575", "諫早",
"81938", "北九州",
"819672", "熊本一の宮",
"817454", "大和高田",
"814288", "青梅",
"819913", "硫黄島",
"81559", "沼津",
"81485", "熊谷",
"812642", "木曾福島",
"812545", "村上",
"812236", "仙台",
"81722", "堺",
"818662", "高梁",
"818565", "益田",
"811236", "千歳",
"811545", "釧路",
"811986", "遠野",
"812892", "宇都宮",
"811642", "石狩深川",
"811533", "根室",
"818568", "津和野",
"811548", "弟子屈",
"8186552", "倉敷",
"819733", "日田",
"81266", "諏訪",
"812473", "石川",
"8188091", "窪川",
"817475", "下市",
"818804", "土佐中村",
"814285", "相模原",
"81864", "倉敷",
"8188098", "土佐清水",
"81166", "旭川",
"817950", "三田",
"815764", "下呂",
"811855", "能代",
"811754", "むつ",
"812559", "安塚",
"81565", "豊田",
"819578", "島原",
"811656", "美深",
"819554", "伊万里",
"814223", "武蔵野三鷹",
"815583", "下田",
"814702", "館山",
"811559", "帯広",
"812855", "小山",
"819438", "田主丸",
"815993", "鳥羽",
"812656", "伊那",
"817969", "浜坂",
"811957", "岩手",
"81577", "高山",
"819576", "島原",
"811658", "上川",
"817354", "新宮",
"8186992", "備前",
"818514", "海士",
"819679", "高森",
"812957", "大子",
"812674", "小諸",
"818247", "庄原",
"818683", "津山",
"812658", "伊那",
"812649", "長野",
"812692", "中野",
"81554", "大月",
"819746", "竹田",
"811546", "釧路",
"811235", "夕張",
"812899", "鹿沼",
"81948", "飯塚",
"81465", "小田原",
"818377", "下関",
"812560", "糸魚川",
"818669", "総社",
"812235", "仙台",
"812546", "村上",
"815562", "鰍沢青柳",
"817476", "下市",
"812243", "白石",
"814286", "相模原",
"818953", "宇和島",
"812238", "仙台",
"81286", "宇都宮",
"811238", "栗山",
"818263", "加計",
"81252", "新潟",
"81423", "国分寺",
"812373", "村山",
"812856", "真岡",
"818384", "萩",
"812552", "上越",
"812655", "飯田",
"817904", "福崎",
"811856", "能代",
"811655", "名寄",
"811552", "帯広",
"81585", "揖斐川",
"814709", "鴨川",
"81863", "玉野",
"812543", "新発田",
"811454", "鵡川",
"8186697", "倉敷",
"81932", "北九州",
"811543", "釧路",
"819738", "玖珠",
"8198294", "延岡",
"812478", "三春",
"815952", "上野",
"81222", "仙台",
"814996", "八丈島",
"818563", "益田",
"811538", "根室標津",
"819743", "三重",
"81592", "津",
"818686", "津山",
"818942", "八幡浜",
"815998", "阿児",
"819433", "八女",
"8199345", "鹿児島",
"819573", "諫早",
"814228", "武蔵野三鷹",
"815588", "修善寺大仁",
"81429", "所沢",
"81793", "姫路",
"8125486", "津川",
"81728", "寝屋川",
"812962", "下館",
"81896", "伊予三島",
"81537", "掛川",
"812567", "巻",
"815585", "下田",
"814225", "武蔵野三鷹",
"8168", "大阪",
"811853", "男鹿",
"8111", "札幌",
"811376", "八雲",
"811567", "十勝清水",
"81825", "広島",
"81294", "常陸太田",
"812376", "寒河江",
"818547", "掛合",
"815995", "阿児",
"812853", "小山",
"819735", "日田",
"818266", "千代田",
"818240", "東広島",
"812475", "石川",
"812839", "佐野",
"811632", "天塩",
"811535", "厚岸",
"818956", "宇和島",
"812246", "大河原",
"817473", "五条",
"81766", "高岡",
"814283", "青梅",
"818268", "千代田",
"811233", "千歳",
"811983", "花巻",
"818958", "御荘",
"818974", "新居浜",
"812233", "岩沼",
"8175", "京都",
"812248", "大河原",
"815959", "亀山",
"818657", "笠岡",
"81942", "久留米",
"817957", "丹波柏原",
"811354", "余市",
"818949", "宇和",
"811378", "今金",
"817674", "羽咋",
"818582", "倉吉",
"81424", "武蔵野三鷹",
"818685", "津山",
"812378", "寒河江",
"819964", "川内",
"81199", "盛岡",
"818688", "美作",
"812653", "飯田",
"812375", "村山",
"815996", "阿児",
"811653", "士別",
"8166", "大阪",
"818597", "根雨",
"815586", "下田",
"814226", "武蔵野三鷹",
"811375", "八雲",
"818955", "宇和島",
"811639", "利尻礼文",
"812832", "佐野",
"812245", "大河原",
"818290", "広島",
"8125487", "津川",
"81547", "島田",
"8186995", "岡山瀬戸",
"81553", "山梨",
"818265", "安芸吉田",
"817687", "能都",
"812476", "三春",
"81492", "川越",
"817238", "寝屋川",
"814998", "小笠原",
"811536", "厚岸",
"815992", "鳥羽",
"814703", "館山",
"818948", "宇和",
"81288", "今市",
"814777", "船橋",
"812968", "笠間",
"81240", "磐城富岡",
"81188", "秋田",
"814240", "国分寺",
"815582", "下田",
"814222", "武蔵野三鷹",
"8112396", "栗山",
"812836", "佐野",
"81425", "立川",
"81583", "岐阜",
"811532", "根室",
"811635", "浜頓別",
"815958", "亀山",
"812472", "石川",
"819732", "日田",
"815974", "尾鷲",
"817947", "三木",
"818364", "宇部",
"811638", "利尻礼文",
"818663", "総社",
"811937", "宮古",
"811643", "石狩深川",
"815955", "上野",
"812893", "宇都宮",
"818204", "柳井",
"8178", "神戸",
"817239", "寝屋川",
"81853", "出雲",
"812937", "水戸",
"812643", "木曾福島",
"819912", "中之島",
"815987", "三瀬谷",
"812965", "下館",
"812580", "十日町",
"818689", "岡山",
"81946", "甘木",
"819673", "熊本一の宮",
"8188099", "土佐清水",
"8153963", "天竜",
"818945", "八幡浜",
"818586", "倉吉",
"81463", "平塚",
"817963", "豊岡",
"811372", "鹿部",
"818697", "備前",
"811553", "帯広",
"81892", "久万",
"8165", "大阪",
"8182943", "広島",
"815999", "津",
"818464", "竹原",
"811867", "鷹巣",
"812372", "村山",
"814229", "武蔵野三鷹",
"815589", "修善寺大仁",
"81268", "上田",
"819727", "臼杵",
"811527", "美幌",
"818588", "郡家",
"818847", "牟岐",
"812553", "上越",
"811636", "北見枝幸",
"8153960", "天竜",
"81563", "西尾",
"811734", "五所川原",
"818262", "加計",
"817997", "津名",
"81762", "金沢",
"815563", "鰍沢青柳",
"812242", "白石",
"812835", "佐野",
"811394", "松前",
"811539", "根室標津",
"818952", "宇和島",
"81936", "北九州",
"81126", "岩見沢",
"818557", "川本",
"812838", "佐野",
"8112397", "栗山",
"812693", "中野",
"81226", "気仙沼",
"814992", "伊豆大島",
"812914", "鉾田",
"815956", "上野",
"818946", "宇和",
"81596", "伊勢",
"818682", "津山",
"818585", "倉吉",
"819807", "沖縄宮古",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;