#---------------------------------------------------------------------
package Dist::Zilla::Plugin::VersionFromModule;
#
# Copyright 2009 Christopher J. Madsen
#
# Author: Christopher J. Madsen <perl@cjmweb.net>
# Created: 23 Sep 2009
#
# This program is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either the
# GNU General Public License or the Artistic License for more details.
#
# ABSTRACT: Get distribution version from its main_module
#---------------------------------------------------------------------

our $VERSION = '0.05';
# This file is part of Dist-Zilla-PluginBundle-CJM 0.07 (April 1, 2010)

use Moose;
with 'Dist::Zilla::Role::VersionProvider';
with 'Dist::Zilla::Role::ModuleInfo';


sub provide_version {
  my ($self) = @_;

  my $main_module = $self->zilla->main_module;
  my $module = $main_module->name;

  my $pm_info = $self->get_module_info($main_module);
  my $ver     = $pm_info->version;

  die "Unable to get version from $module" unless defined $ver;

  $self->log("dist version $ver (from $module)");

  "$ver";                       # Need to stringify version object
} # end provide_version

#=====================================================================
# Package Return Value:

no Moose;
__PACKAGE__->meta->make_immutable;
1;

__END__

=head1 NAME

Dist::Zilla::Plugin::VersionFromModule - Get distribution version from its main_module

=head1 VERSION

This document describes version 0.05 of
Dist::Zilla::Plugin::VersionFromModule, released April 1, 2010
as part of Dist-Zilla-PluginBundle-CJM version 0.07.

=head1 SYNOPSIS

In your F<dist.ini>:

  [VersionFromModule]

=head1 DESCRIPTION

If included, this plugin will set the distribution's version from the
C<main_module>'s version.  (You should not specify a version in your
F<dist.ini>.)

=head1 INCOMPATIBILITIES

Since it will always return a version, VersionFromModule should not be
used with any other VersionProvider plugins.


=for Pod::Coverage
provide_version

=head1 BUGS AND LIMITATIONS

No bugs have been reported.

=head1 AUTHOR

Christopher J. Madsen  C<< <perlATcjmweb.net> >>

Please report any bugs or feature requests to
C<< <bug-Dist-Zilla-PluginBundle-CJMATrt.cpan.org> >>,
or through the web interface at
L<http://rt.cpan.org/Public/Bug/Report.html?Queue=Dist-Zilla-PluginBundle-CJM>

You can follow or contribute to Dist-Zilla-PluginBundle-CJM's development at
L<< http://github.com/madsen/dist-zilla-pluginbundle-cjm >>.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Christopher J. Madsen.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENSE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

=cut
