use 5.008;
use strict;
use warnings;

package Task::MasteringPerl;

our $AUTHORITY = 'cpan:BDFOY';
our $VERSION   = '1.004';

1;

__END__

=encoding utf-8

=head1 NAME

Task::MasteringPerl - Modules used in Mastering Perl, 2nd Edition

=head1 DESCRIPTION

Task::MasteringPerl installs the modules mentioned in Mastering Perl.
Some of them might not install everywhere.

=over

=item * AnyDBM_File

=item * Apache::PerlRun

=item * Apache::Perldoc

=item * Apache::Pod

=item * App::Smbxfer

=item * AutoLoader

=item * AutoSplit

=item * B::Deobfuscate

=item * B::Deparse

=item * Benchmark

=item * Benchmark::Forking

=item * BerkeleyDB

=item * BioPerl

=item * Bit::Vector

=item * Business::ISBN

=item * CGI

=item * CPAN

=item * Carp

=item * Carp::Always

=item * Clone::Any

=item * Code::Splice

=item * Config

=item * Config::ApacheFile

=item * Config::IniFiles

=item * Config::JSON

=item * Config::Scoped

=item * ConfigReader::Simple

=item * Const::Fast

=item * DBD::CSV

=item * DBI

=item * DBI::Profile

=item * DBI::ProfileDumper

=item * DBI::ProfileDumper::Apache

=item * DBM::Deep

=item * Data::Constraint

=item * Data::Dump

=item * Data::Dump::Steamer

=item * Data::Dump::Streamer

=item * Data::Dumper

=item * Data::MessagePack

=item * Data::Printer

=item * Devel::Cover

=item * Devel::DProf

=item * Devel::Declare

=item * Devel::MyDebugger

=item * Devel::NYTProf

=item * Devel::Peek

=item * Devel::Size

=item * Devel::SmallProf

=item * Devel::Trace

=item * Devel::ebug

=item * Devel::ebug::Console

=item * Devel::hdb

=item * Devel::ptkdb

=item * Dumbbench

=item * Email::Send::SMTP

=item * Email::Stuff

=item * Errno

=item * Error

=item * Exporter

=item * ExtUtils::MM_Any

=item * ExtUtils::MM_Unix

=item * ExtUtils::MM_Win32

=item * ExtUtils::MakeMaker

=item * Fcntl

=item * File::Find

=item * File::Find::Closures

=item * File::Spec

=item * Getopt::Attribute

=item * Getopt::Declare

=item * Getopt::Easy

=item * Getopt::Long

=item * Getopt::Lucid

=item * Getopt::Std

=item * Git::CPAN::Patch

=item * Git::Github::Creator

=item * HTML::Parser

=item * HTTP::Date

=item * HTTP::Size

=item * Hash::AsObject

=item * Hook::Lex::Wrap

=item * Hook::LexWrap

=item * IO::Handle

=item * IO::Interactive

=item * IO::Socket::INET

=item * Image::Info

=item * JSON

=item * JSON::PP

=item * JSON::Rabbit

=item * JSON::Syck

=item * List::Util

=item * Log::Log4perl

=item * Log::Log4perl::Appender::DBI

=item * Log::Log4perl::Appender::File

=item * Log::Log4perl::Layout::PatternLayout

=item * Mac::PropertyList

=item * Memoize

=item * ModPerl::PerlRun

=item * Module::Build

=item * Module::NotThere

=item * Module::Release

=item * Modulino::Demo

=item * Net::FTP

=item * Net::MAC::Vendor

=item * Net::SMTP

=item * Netscape::Bookmarks

=item * Netscape::Bookmarks::Category

=item * Object::Iterate

=item * Opcode

=item * POSIX

=item * PPI

=item * Package::Stash

=item * Package:Stash

=item * Perl::Critic

=item * Perl::Critic::DEVELOPER

=item * Perl::Critic::Lax

=item * Perl::Critic::Policy

=item * Perl::Critic::Policy::Lax::ProhibitStringyEval::ExceptForRequire

=item * Perl::Tidy

=item * Pod::Checker

=item * Pod::Coverage

=item * Pod::Parser

=item * Pod::Perldoc

=item * Pod::Perldoc::BaseTo

=item * Pod::Perldoc::ToRtf

=item * Pod::Perldoc::ToText

=item * Pod::Perldoc::ToToc

=item * Pod::PseudoPod

=item * Pod::Simple

=item * Pod::Simple::Subclassing

=item * Pod::TOC

=item * Pod::Webserver

=item * Regexp::Debugger

=item * ReturnValue

=item * Safe

=item * Scalar::Util

=item * Sereal

=item * Sereal::Decoder

=item * Some::Module

=item * Storable

=item * Surveyor::App

=item * Surveyor::Benchmark::GetDirectoryListing

=item * Sys::Syslog

=item * Taint::Util

=item * Template

=item * Template::Base

=item * Template::Exception

=item * Test::Harness

=item * Test::Inline

=item * Test::Manifest

=item * Test::More

=item * Test::Output

=item * Test::Perl::Critic

=item * Test::Pod

=item * Test::Pod::Coverage

=item * Test::Taint

=item * Text::Template::Simple::IO

=item * Tie::

=item * Tie::Array

=item * Tie::Array::PackedC

=item * Tie::BoundedInteger

=item * Tie::Cycle

=item * Tie::Cycle::Sinewave

=item * Tie::File::Timestamp

=item * Tie::Scalar

=item * Tie::Timely

=item * Tk

=item * Try::Tiny

=item * TryCatch

=item * Vim::Debug

=item * Win32

=item * Win32::Registry

=item * YAML

=item * YAML::LibYAML

=item * YAML::Syck

=item * YAML::Tiny

=item * YAML::XS

=item * autodie

=item * bignum

=item * constant

=item * criticism

=item * diagnostics

=item * die

=item * feature

=item * locale

=item * overload

=item * parent

=item * perlbench

=item * ptkdb

=item * re

=item * require

=item * strict

=item * warnings

=back

=head1 BUGS

Please report any bugs to
L<http://rt.cpan.org/Dist/Display.html?Queue=Task-MasteringPerl>.

=head1 SEE ALSO

L<Task>

=head1 AUTHOR

brian d foy, <bdfoy@gmail.com>

=head1 COPYRIGHT AND LICENCE

Copyright © 2014-2018, brian d foy <bdfoy@cpan.org>. All rights reserved.

This is free software; you can redistribute it and/or modify it under
the terms of the Artistic License 2.0.

=cut
