package Promises6::Builder;
use Evo::Base -base;

has promise_class => sub { require Promises6::Promise; 'Promises6::Promise'; };

has listener_class =>
  sub { require Promises6::Listener; 'Promises6::Listener'; };

has deferred_class =>
  sub { require Promises6::Deferred; 'Promises6::Deferred'; };


has resolver => sub {
  my $self = _instance(shift);
  require Promises6::Resolver;
  Promises6::Resolver->new(@_, builder => $self);
};

# commented 08.02.2015
#don't know if someone will use it other way
#has resolver_class =>
#  sub { require Promises6::Resolver; 'Promises6::Resolver'; };
#
#sub resolver {
#  my $self = _instance(shift);
#  $self->resolver_class->new(@_, builder => $self);
#}

sub promise {
  my $self = _instance(shift);
  $self->promise_class->new(@_, builder => $self);
}

sub listener {
  my $self = _instance(shift);
  $self->listener_class->new(@_, builder => $self);
}

sub deferred {
  my $self = _instance(shift);
  $self->deferred_class->new(@_, builder => $self);
}


sub singleton($class,@args) {
  state $single = (ref $class || $class)->new(@args);
}

sub _instance { ref $_[0] ? $_[0] : $_[0]->singleton }

1;

# ABSTRACT: A builder for promises

__END__

=pod

=encoding UTF-8

=head1 NAME

Promises6::Builder - A builder for promises

=head1 VERSION

version 0.006

=head1 SYNOPSIS

  use Promises6::Builder;
  use Evo::Base -strict;

  my $bldr = Promises6::Builder->new;
  my $d    = $bldr->deferred;
  my $p    = $bldr->promise;

=head1 DESCRIPTION

  This module is for internal usage only and should be used directly

=head1 ATTRIBUTES

=head2 listener_class
=attr promise_class
=attr deferred_class
=attr resolver_class

  Classes for instances that will be builded

=head2 listener

  Build and caches a listener

=head1 METHODS

=head2 promise

  Builds a promise

=head2 deferred

  Builds a deferred instance

=head2 listener

  Builds a listener

=head2 resolver

  Builds a resolver

=head2 singleton

  Build a singleton - the same instance will be returned between invocations

=head1 AUTHOR

alexbyk <alexbyk.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
