/*
 Copyright (C) 2015-2017 Alexander Borisov
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 
 Author: lex.borisov@gmail.com (Alexander Borisov)
*/

#ifndef MyENCODING_DETECT_RESOURCE_H
#define MyENCODING_DETECT_RESOURCE_H
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#define MyENCODING_DETECT_NAME_STATIC_SIZE 419

#include "myencoding/encoding.h"

static const myencoding_detect_name_entry_t myencoding_detect_name_entry_static_list_index[] =
{
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1257", 12, "x-cp1257", 8, MyENCODING_WINDOWS_1257, 0, 7},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-874", 11, "tis-620", 7, MyENCODING_WINDOWS_874, 0, 10},
    {"iso-8859-3", 10, "iso8859-3", 9, MyENCODING_ISO_8859_3, 420, 11},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"shift_jis", 9, "ms932", 5, MyENCODING_SHIFT_JIS, 0, 16},
    {"gbk", 3, "gb_2312", 7, MyENCODING_GBK, 421, 17},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-7", 10, "iso8859-7", 9, MyENCODING_ISO_8859_7, 422, 20},
    {"windows-1250", 12, "cp1250", 6, MyENCODING_WINDOWS_1250, 423, 21},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"shift_jis", 9, "shift-jis", 9, MyENCODING_SHIFT_JIS, 424, 30},
    {"ibm866", 6, "csibm866", 8, MyENCODING_IBM866, 425, 31},
    {"euc-kr", 6, "windows-949", 11, MyENCODING_EUC_KR, 0, 32},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-2022-jp", 11, "csiso2022jp", 11, MyENCODING_ISO_2022_JP, 0, 40},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-15", 11, "iso-8859-15", 11, MyENCODING_ISO_8859_15, 426, 42},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-kr", 6, "ksc_5601", 8, MyENCODING_EUC_KR, 0, 45},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"gbk", 3, "csiso58gb231280", 15, MyENCODING_GBK, 0, 51},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-5", 10, "cyrillic", 8, MyENCODING_ISO_8859_5, 0, 56},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1255", 12, "cp1255", 6, MyENCODING_WINDOWS_1255, 427, 58},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1254", 12, "x-cp1254", 8, MyENCODING_WINDOWS_1254, 0, 60},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-15", 11, "csisolatin9", 11, MyENCODING_ISO_8859_15, 0, 62},
    {"koi8-u", 6, "koi8-ru", 7, MyENCODING_KOI8_U, 0, 63},
    {"iso-8859-4", 10, "csisolatin4", 11, MyENCODING_ISO_8859_4, 0, 64},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"shift_jis", 9, "windows-31j", 11, MyENCODING_SHIFT_JIS, 0, 66},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"utf-8", 5, "utf-8", 5, MyENCODING_UTF_8, 0, 79},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"ibm866", 6, "ibm866", 6, MyENCODING_IBM866, 0, 82},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"koi8-r", 6, "koi8", 4, MyENCODING_KOI8_R, 0, 86},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"gbk", 3, "x-gbk", 5, MyENCODING_GBK, 428, 94},
    {"iso-8859-7", 10, "csisolatingreek", 15, MyENCODING_ISO_8859_7, 0, 95},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "iso88591", 8, MyENCODING_WINDOWS_1252, 0, 99},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "iso88592", 8, MyENCODING_ISO_8859_2, 0, 101},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-3", 10, "iso88593", 8, MyENCODING_ISO_8859_3, 0, 103},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-4", 10, "iso88594", 8, MyENCODING_ISO_8859_4, 0, 105},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"shift_jis", 9, "sjis", 4, MyENCODING_SHIFT_JIS, 430, 107},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-6", 10, "iso88596", 8, MyENCODING_ISO_8859_6, 431, 109},
    {"windows-1252", 12, "l1", 2, MyENCODING_WINDOWS_1252, 432, 110},
    {"macintosh", 9, "mac", 3, MyENCODING_MACINTOSH, 433, 111},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-8", 10, "iso88598", 8, MyENCODING_ISO_8859_8, 435, 113},
    {"koi8-u", 6, "koi8-u", 6, MyENCODING_KOI8_U, 0, 114},
    {"windows-1254", 12, "iso88599", 8, MyENCODING_WINDOWS_1254, 0, 115},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-6", 10, "ecma-114", 8, MyENCODING_ISO_8859_6, 0, 117},
    {"iso-8859-4", 10, "iso8859-4", 9, MyENCODING_ISO_8859_4, 436, 118},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-4", 10, "iso-ir-110", 10, MyENCODING_ISO_8859_4, 437, 121},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-3", 10, "l3", 2, MyENCODING_ISO_8859_3, 0, 123},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "iso-8859-2", 10, MyENCODING_ISO_8859_2, 439, 126},
    {"windows-1253", 12, "cp1253", 6, MyENCODING_WINDOWS_1253, 440, 127},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1258", 12, "x-cp1258", 8, MyENCODING_WINDOWS_1258, 0, 129},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-4", 10, "iso-8859-4", 10, MyENCODING_ISO_8859_4, 443, 131},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-10", 11, "iso-8859-10", 11, MyENCODING_ISO_8859_10, 0, 133},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1254", 12, "l5", 2, MyENCODING_WINDOWS_1254, 446, 136},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "latin2", 6, MyENCODING_ISO_8859_2, 0, 138},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-8", 10, "iso-8859-8", 10, MyENCODING_ISO_8859_8, 449, 141},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "cp819", 5, MyENCODING_WINDOWS_1252, 0, 143},
    {"iso-8859-14", 11, "iso-8859-14", 11, MyENCODING_ISO_8859_14, 0, 144},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-10", 11, "csisolatin6", 11, MyENCODING_ISO_8859_10, 0, 147},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "csisolatin1", 11, MyENCODING_WINDOWS_1252, 0, 149},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-15", 11, "l9", 2, MyENCODING_ISO_8859_15, 0, 162},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1258", 12, "cp1258", 6, MyENCODING_WINDOWS_1258, 0, 164},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "windows-1252", 12, MyENCODING_WINDOWS_1252, 0, 171},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-7", 10, "sun_eu_greek", 12, MyENCODING_ISO_8859_7, 0, 173},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-jp", 6, "cseucpkdfmtjapanese", 19, MyENCODING_EUC_JP, 0, 175},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-4", 10, "latin4", 6, MyENCODING_ISO_8859_4, 0, 177},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1255", 12, "x-cp1255", 8, MyENCODING_WINDOWS_1255, 452, 182},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"koi8-r", 6, "koi", 3, MyENCODING_KOI8_R, 0, 186},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1257", 12, "windows-1257", 12, MyENCODING_WINDOWS_1257, 0, 188},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-874", 11, "windows-874", 11, MyENCODING_WINDOWS_874, 0, 191},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1251", 12, "cp1251", 6, MyENCODING_WINDOWS_1251, 0, 196},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"utf-16le", 8, "utf-16", 6, MyENCODING_UTF_16LE, 0, 199},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-8", 10, "visual", 6, MyENCODING_ISO_8859_8, 0, 207},
    {"macintosh", 9, "macintosh", 9, MyENCODING_MACINTOSH, 0, 208},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "ansi_x3.4-1968", 14, MyENCODING_WINDOWS_1252, 0, 210},
    {"iso-8859-3", 10, "iso_8859-3:1988", 15, MyENCODING_ISO_8859_3, 453, 211},
    {"iso-8859-6", 10, "csiso88596e", 11, MyENCODING_ISO_8859_6, 456, 212},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"gbk", 3, "csgb2312", 8, MyENCODING_GBK, 0, 215},
    {"iso-8859-6", 10, "arabic", 6, MyENCODING_ISO_8859_6, 457, 216},
    {"iso-8859-7", 10, "greek", 5, MyENCODING_ISO_8859_7, 0, 217},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"shift_jis", 9, "ms_kanji", 8, MyENCODING_SHIFT_JIS, 0, 219},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-5", 10, "iso8859-5", 9, MyENCODING_ISO_8859_5, 460, 225},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "ascii", 5, MyENCODING_WINDOWS_1252, 461, 227},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-kr", 6, "korean", 6, MyENCODING_EUC_KR, 0, 229},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"utf-8", 5, "utf8", 4, MyENCODING_UTF_8, 462, 231},
    {"iso-8859-3", 10, "csisolatin3", 11, MyENCODING_ISO_8859_3, 0, 232},
    {"windows-1256", 12, "cp1256", 6, MyENCODING_WINDOWS_1256, 464, 233},
    {"windows-1254", 12, "iso8859-9", 9, MyENCODING_WINDOWS_1254, 0, 234},
    {"windows-1252", 12, "us-ascii", 8, MyENCODING_WINDOWS_1252, 465, 235},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"big5", 4, "big5", 4, MyENCODING_BIG5, 466, 246},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1250", 12, "windows-1250", 12, MyENCODING_WINDOWS_1250, 0, 248},
    {"euc-kr", 6, "ksc5601", 7, MyENCODING_EUC_KR, 0, 249},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-7", 10, "greek8", 6, MyENCODING_ISO_8859_7, 467, 251},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-jp", 6, "x-euc-jp", 8, MyENCODING_EUC_JP, 0, 257},
    {"shift_jis", 9, "x-sjis", 6, MyENCODING_SHIFT_JIS, 0, 258},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"utf-16be", 8, "utf-16be", 8, MyENCODING_UTF_16BE, 468, 262},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1255", 12, "windows-1255", 12, MyENCODING_WINDOWS_1255, 0, 265},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-kr", 6, "ks_c_5601-1987", 14, MyENCODING_EUC_KR, 0, 267},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"ibm866", 6, "866", 3, MyENCODING_IBM866, 0, 274},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"big5", 4, "cn-big5", 7, MyENCODING_BIG5, 0, 277},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"koi8-r", 6, "koi8-r", 6, MyENCODING_KOI8_R, 469, 283},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "ibm819", 6, MyENCODING_WINDOWS_1252, 0, 296},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-6", 10, "asmo-708", 8, MyENCODING_ISO_8859_6, 0, 300},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1254", 12, "cp1254", 6, MyENCODING_WINDOWS_1254, 470, 302},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1256", 12, "x-cp1256", 8, MyENCODING_WINDOWS_1256, 471, 304},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-2022-jp", 11, "iso-2022-jp", 11, MyENCODING_ISO_2022_JP, 0, 309},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "iso_8859-2:1987", 15, MyENCODING_ISO_8859_2, 473, 312},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"gbk", 3, "gb2312", 6, MyENCODING_GBK, 0, 314},
    {"windows-1254", 12, "csisolatin5", 11, MyENCODING_WINDOWS_1254, 0, 315},
    {"iso-8859-6", 10, "iso-8859-6-i", 12, MyENCODING_ISO_8859_6, 476, 316},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "iso8859-2", 9, MyENCODING_ISO_8859_2, 0, 323},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "l2", 2, MyENCODING_ISO_8859_2, 0, 326},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "latin1", 6, MyENCODING_WINDOWS_1252, 0, 328},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-kr", 6, "ks_c_5601-1989", 14, MyENCODING_EUC_KR, 0, 330},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-6", 10, "iso8859-6", 9, MyENCODING_ISO_8859_6, 0, 332},
    {"iso-8859-2", 10, "iso-ir-101", 10, MyENCODING_ISO_8859_2, 477, 333},
    {"ibm866", 6, "cp866", 5, MyENCODING_IBM866, 0, 334},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-3", 10, "iso-8859-3", 10, MyENCODING_ISO_8859_3, 480, 338},
    {"iso-8859-4", 10, "l4", 2, MyENCODING_ISO_8859_4, 0, 339},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1253", 12, "windows-1253", 12, MyENCODING_WINDOWS_1253, 0, 342},
    {"iso-8859-5", 10, "iso-8859-5", 10, MyENCODING_ISO_8859_5, 482, 343},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-6", 10, "iso-ir-127", 10, MyENCODING_ISO_8859_6, 484, 348},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"utf-8", 5, "unicode-1-1-utf-8", 17, MyENCODING_UTF_8, 0, 350},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-10", 11, "l6", 2, MyENCODING_ISO_8859_10, 0, 352},
    {"iso-8859-3", 10, "iso-ir-109", 10, MyENCODING_ISO_8859_3, 487, 353},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1253", 12, "x-cp1253", 8, MyENCODING_WINDOWS_1253, 0, 357},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-16", 11, "iso-8859-16", 11, MyENCODING_ISO_8859_16, 490, 359},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-8-i", 12, "logical", 7, MyENCODING_ISO_8859_8_I, 0, 363},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-8", 10, "csisolatinhebrew", 16, MyENCODING_ISO_8859_8, 0, 366},
    {"iso-8859-3", 10, "latin3", 6, MyENCODING_ISO_8859_3, 491, 367},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-kr", 6, "euc-kr", 6, MyENCODING_EUC_KR, 0, 369},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1252", 12, "cp1252", 6, MyENCODING_WINDOWS_1252, 0, 371},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-6", 10, "csiso88596i", 11, MyENCODING_ISO_8859_6, 492, 378},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"gbk", 3, "gbk", 3, MyENCODING_GBK, 0, 382},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-kr", 6, "csksc56011987", 13, MyENCODING_EUC_KR, 0, 394},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"x-mac-cyrillic", 14, "x-mac-cyrillic", 14, MyENCODING_X_MAC_CYRILLIC, 0, 397},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-2", 10, "csisolatin2", 11, MyENCODING_ISO_8859_2, 0, 400},
    {"x-user-defined", 14, "x-user-defined", 14, MyENCODING_X_USER_DEFINED, 0, 401},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1254", 12, "latin5", 6, MyENCODING_WINDOWS_1254, 0, 406},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"windows-1257", 12, "cp1257", 6, MyENCODING_WINDOWS_1257, 0, 408},
    {"big5", 4, "big5-hkscs", 10, MyENCODING_BIG5, 0, 409},
    {"windows-1250", 12, "x-cp1250", 8, MyENCODING_WINDOWS_1250, 0, 410},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"euc-jp", 6, "euc-jp", 6, MyENCODING_EUC_JP, 0, 414},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"iso-8859-7", 10, "ecma-118", 8, MyENCODING_ISO_8859_7, 493, 416},
    {NULL, 0, NULL, 0, 0, 0, 0},
    {"gbk", 3, "gb_2312-80", 10, MyENCODING_GBK, 0, 418},
    {"windows-1251", 12, "windows-1251", 12, MyENCODING_WINDOWS_1251, 0, 419},
    {"iso-8859-13", 11, "iso885913", 9, MyENCODING_ISO_8859_13, 0, 420},
    {"windows-1256", 12, "windows-1256", 12, MyENCODING_WINDOWS_1256, 0, 421},
    {"iso-8859-5", 10, "csisolatincyrillic", 18, MyENCODING_ISO_8859_5, 0, 422},
    {"gbk", 3, "chinese", 7, MyENCODING_GBK, 0, 423},
    {"shift_jis", 9, "shift_jis", 9, MyENCODING_SHIFT_JIS, 0, 424},
    {"windows-874", 11, "iso-8859-11", 11, MyENCODING_WINDOWS_874, 0, 425},
    {"iso-8859-15", 11, "iso_8859-15", 11, MyENCODING_ISO_8859_15, 0, 426},
    {"big5", 4, "csbig5", 6, MyENCODING_BIG5, 0, 427},
    {"iso-8859-8", 10, "hebrew", 6, MyENCODING_ISO_8859_8, 429, 428},
    {"windows-1254", 12, "windows-1254", 12, MyENCODING_WINDOWS_1254, 0, 429},
    {"iso-8859-5", 10, "iso88595", 8, MyENCODING_ISO_8859_5, 0, 430},
    {"iso-8859-10", 11, "iso885910", 9, MyENCODING_ISO_8859_10, 0, 431},
    {"windows-1254", 12, "iso_8859-9:1989", 15, MyENCODING_WINDOWS_1254, 0, 432},
    {"iso-8859-7", 10, "iso88597", 8, MyENCODING_ISO_8859_7, 434, 433},
    {"iso-8859-6", 10, "csisolatinarabic", 16, MyENCODING_ISO_8859_6, 0, 434},
    {"windows-1251", 12, "x-cp1251", 8, MyENCODING_WINDOWS_1251, 0, 435},
    {"iso-8859-14", 11, "iso885914", 9, MyENCODING_ISO_8859_14, 0, 436},
    {"iso-8859-10", 11, "iso8859-10", 10, MyENCODING_ISO_8859_10, 438, 437},
    {"windows-1252", 12, "iso-ir-100", 10, MyENCODING_WINDOWS_1252, 0, 438},
    {"iso-8859-2", 10, "iso_8859-2", 10, MyENCODING_ISO_8859_2, 0, 439},
    {"iso-8859-8", 10, "iso8859-8", 9, MyENCODING_ISO_8859_8, 441, 440},
    {"gbk", 3, "iso-ir-58", 9, MyENCODING_GBK, 442, 441},
    {"macintosh", 9, "csmacintosh", 11, MyENCODING_MACINTOSH, 0, 442},
    {"iso-8859-4", 10, "iso_8859-4", 10, MyENCODING_ISO_8859_4, 444, 443},
    {"iso-8859-5", 10, "iso-ir-144", 10, MyENCODING_ISO_8859_5, 445, 444},
    {"iso-8859-14", 11, "iso8859-14", 10, MyENCODING_ISO_8859_14, 0, 445},
    {"iso-8859-6", 10, "iso-8859-6", 10, MyENCODING_ISO_8859_6, 447, 446},
    {"iso-8859-6", 10, "iso_8859-6", 10, MyENCODING_ISO_8859_6, 448, 447},
    {"iso-8859-7", 10, "iso-ir-126", 10, MyENCODING_ISO_8859_7, 0, 448},
    {"iso-8859-8", 10, "iso-ir-138", 10, MyENCODING_ISO_8859_8, 450, 449},
    {"iso-8859-8", 10, "iso_8859-8", 10, MyENCODING_ISO_8859_8, 451, 450},
    {"windows-1254", 12, "iso-ir-148", 10, MyENCODING_WINDOWS_1254, 0, 451},
    {"big5", 4, "x-x-big5", 8, MyENCODING_BIG5, 0, 452},
    {"iso-8859-4", 10, "iso_8859-4:1988", 15, MyENCODING_ISO_8859_4, 454, 453},
    {"iso-8859-5", 10, "iso_8859-5:1988", 15, MyENCODING_ISO_8859_5, 455, 454},
    {"iso-8859-8", 10, "iso_8859-8:1988", 15, MyENCODING_ISO_8859_8, 0, 455},
    {"iso-8859-8", 10, "csiso88598e", 11, MyENCODING_ISO_8859_8, 0, 456},
    {"iso-8859-10", 11, "latin6", 6, MyENCODING_ISO_8859_10, 458, 457},
    {"windows-874", 11, "iso885911", 9, MyENCODING_WINDOWS_874, 459, 458},
    {"windows-1252", 12, "iso8859-1", 9, MyENCODING_WINDOWS_1252, 0, 459},
    {"iso-8859-15", 11, "iso885915", 9, MyENCODING_ISO_8859_15, 0, 460},
    {"macintosh", 9, "x-mac-roman", 11, MyENCODING_MACINTOSH, 0, 461},
    {"koi8-r", 6, "cskoi8r", 7, MyENCODING_KOI8_R, 463, 462},
    {"euc-kr", 6, "cseuckr", 7, MyENCODING_EUC_KR, 0, 463},
    {"x-mac-cyrillic", 14, "x-mac-ukrainian", 15, MyENCODING_X_MAC_CYRILLIC, 0, 464},
    {"windows-1252", 12, "x-cp1252", 8, MyENCODING_WINDOWS_1252, 0, 465},
    {"iso-8859-13", 11, "iso-8859-13", 11, MyENCODING_ISO_8859_13, 0, 466},
    {"gb18030", 7, "gb18030", 7, MyENCODING_GB18030, 0, 467},
    {"utf-16le", 8, "utf-16le", 8, MyENCODING_UTF_16LE, 0, 468},
    {"koi8-r", 6, "koi8_r", 6, MyENCODING_KOI8_R, 0, 469},
    {"shift_jis", 9, "csshiftjis", 10, MyENCODING_SHIFT_JIS, 0, 470},
    {"iso-8859-6", 10, "iso-8859-6-e", 12, MyENCODING_ISO_8859_6, 472, 471},
    {"iso-8859-8", 10, "iso-8859-8-e", 12, MyENCODING_ISO_8859_8, 0, 472},
    {"iso-8859-6", 10, "iso_8859-6:1987", 15, MyENCODING_ISO_8859_6, 474, 473},
    {"iso-8859-7", 10, "iso_8859-7:1987", 15, MyENCODING_ISO_8859_7, 475, 474},
    {"windows-1252", 12, "iso_8859-1:1987", 15, MyENCODING_WINDOWS_1252, 0, 475},
    {"iso-8859-8-i", 12, "iso-8859-8-i", 12, MyENCODING_ISO_8859_8_I, 0, 476},
    {"windows-874", 11, "iso8859-11", 10, MyENCODING_WINDOWS_874, 478, 477},
    {"windows-1252", 12, "iso-8859-1", 10, MyENCODING_WINDOWS_1252, 479, 478},
    {"windows-1252", 12, "iso_8859-1", 10, MyENCODING_WINDOWS_1252, 0, 479},
    {"iso-8859-3", 10, "iso_8859-3", 10, MyENCODING_ISO_8859_3, 481, 480},
    {"iso-8859-13", 11, "iso8859-13", 10, MyENCODING_ISO_8859_13, 0, 481},
    {"iso-8859-5", 10, "iso_8859-5", 10, MyENCODING_ISO_8859_5, 483, 482},
    {"iso-8859-15", 11, "iso8859-15", 10, MyENCODING_ISO_8859_15, 0, 483},
    {"iso-8859-7", 10, "iso-8859-7", 10, MyENCODING_ISO_8859_7, 485, 484},
    {"iso-8859-7", 10, "iso_8859-7", 10, MyENCODING_ISO_8859_7, 486, 485},
    {"iso-8859-10", 11, "iso-ir-157", 10, MyENCODING_ISO_8859_10, 0, 486},
    {"windows-1254", 12, "iso-8859-9", 10, MyENCODING_WINDOWS_1254, 488, 487},
    {"windows-1254", 12, "iso_8859-9", 10, MyENCODING_WINDOWS_1254, 489, 488},
    {"euc-kr", 6, "iso-ir-149", 10, MyENCODING_EUC_KR, 0, 489},
    {"windows-1258", 12, "windows-1258", 12, MyENCODING_WINDOWS_1258, 0, 490},
    {"windows-874", 11, "dos-874", 7, MyENCODING_WINDOWS_874, 0, 491},
    {"iso-8859-8-i", 12, "csiso88598i", 11, MyENCODING_ISO_8859_8_I, 0, 492},
    {"iso-8859-7", 10, "elot_928", 8, MyENCODING_ISO_8859_7, 0, 493},
};

static const myencoding_entry_name_index_t myencoding_entry_name_index_static_list_index[(MyENCODING_LAST_ENTRY + 1)] =
{
    {"UTF-8", 5},
    {"AUTO", 4},
    {"NOT-DETERMINED", 14},
    {"NOT-DETERMINED", 14},
    {"UTF-16LE", 8},
    {"UTF-16BE", 8},
    {"X-USER-DEFINED", 14},
    {"BIG5", 4},
    {"EUC-JP", 6},
    {"EUC-KR", 6},
    {"GB18030", 7},
    {"GBK", 3},
    {"IBM866", 6},
    {"ISO-2022-JP", 11},
    {"ISO-8859-10", 11},
    {"ISO-8859-13", 11},
    {"ISO-8859-14", 11},
    {"ISO-8859-15", 11},
    {"ISO-8859-16", 11},
    {"ISO-8859-2", 10},
    {"ISO-8859-3", 10},
    {"ISO-8859-4", 10},
    {"ISO-8859-5", 10},
    {"ISO-8859-6", 10},
    {"ISO-8859-7", 10},
    {"ISO-8859-8", 10},
    {"ISO-8859-8-I", 12},
    {"KOI8-R", 6},
    {"KOI8-U", 6},
    {"MACINTOSH", 9},
    {"SHIFT_JIS", 9},
    {"WINDOWS-1250", 12},
    {"WINDOWS-1251", 12},
    {"WINDOWS-1252", 12},
    {"WINDOWS-1253", 12},
    {"WINDOWS-1254", 12},
    {"WINDOWS-1255", 12},
    {"WINDOWS-1256", 12},
    {"WINDOWS-1257", 12},
    {"WINDOWS-1258", 12},
    {"WINDOWS-874", 11},
    {"X-MAC-CYRILLIC", 14},
    {"", 0},
};

static const myencoding_trigram_t myencoding_detect_trigrams_index_ibm866[] = {
    {{0xA5, 0xAD, 0xA8}, 991}, /* ени */
    {{0xAE, 0xA3, 0xAE}, 806}, /* ого */
    {{0xE1, 0xE2, 0xA2}, 659}, /* ств */
    {{0xAD, 0xA8, 0xEF}, 629}, /* ния */
    {{0xAE, 0xA2, 0xA0}, 566}, /* ова */
    {{0xE2, 0xA5, 0xAB}, 555}, /* тел */
    {{0xE0, 0xA5, 0xA4}, 507}, /* ред */
    {{0xA5, 0xAD, 0xAD}, 499}, /* енн */
    {{0xAE, 0xA2, 0xAE}, 443}, /* ово */
    {{0xA0, 0xAD, 0xA8}, 443}, /* ани */
    {{0xE2, 0xE0, 0xA0}, 429}, /* тра */
    {{0xAE, 0xE1, 0xE2}, 428}, /* ост */
    {{0xAD, 0xA8, 0xA5}, 419}, /* ние */
    {{0xAD, 0xAD, 0xAE}, 412}, /* нно */
    {{0xA0, 0xE5, 0xAE}, 396}, /* ахо */
    {{0xE1, 0xE2, 0xE0}, 392}, /* стр */
    {{0xE0, 0xA0, 0xE5}, 386}, /* рах */
    {{0xE5, 0xAE, 0xA2}, 379}, /* хов */
    {{0xA5, 0xAB, 0xEC}, 365}, /* ель */
    {{0xA3, 0xAE, 0xA2}, 360}, /* гов */
    {{0xA2, 0xAE, 0xE0}, 356}, /* вор */
    {{0xA5, 0xE1, 0xE2}, 349}, /* ест */
    {{0xA0, 0xE2, 0xEC}, 345}, /* ать */
    {{0xE0, 0xA0, 0xA2}, 337}, /* рав */
    {{0xAF, 0xE0, 0xA8}, 330}, /* при */
    {{0xAF, 0xE0, 0xA5}, 323}, /* пре */
    {{0xA4, 0xAE, 0xA3}, 318}, /* дог */
    {{0xAD, 0xA5, 0xAD}, 310}, /* нен */
    {{0xAF, 0xE0, 0xA0}, 309}, /* пра */
    {{0xA2, 0xA0, 0xAD}, 304}, /* ван */
    {{0xA8, 0xE2, 0xA5}, 295}, /* ите */
    {{0xE2, 0xA2, 0xA5}, 281}, /* тве */
    {{0xAB, 0xA5, 0xAD}, 266}, /* лен */
    {{0xE1, 0xE2, 0xAE}, 261}, /* сто */
    {{0xE2, 0xA0, 0xE2}, 260}, /* тат */
    {{0xAD, 0xAD, 0xEB}, 260}, /* нны */
    {{0xAB, 0xEC, 0xAD}, 256}, /* льн */
    {{0xA2, 0xAE, 0xA7}, 255}, /* воз */
    {{0xA8, 0xAB, 0xA8}, 254}, /* или */
    {{0xA0, 0xE2, 0xA5}, 252}, /* ате */
    {{0xA5, 0xA3, 0xAE}, 241}, /* его */
    {{0xA5, 0xE2, 0xE1}, 238}, /* етс */
    {{0xAD, 0xAE, 0xE1}, 236}, /* нос */
    {{0xE9, 0xA5, 0xE1}, 235}, /* щес */
    {{0xAF, 0xAE, 0xAB}, 232}, /* пол */
    {{0xE0, 0xA0, 0xAD}, 231}, /* ран */
    {{0xAD, 0xAE, 0xA3}, 230}, /* ног */
    {{0xE1, 0xE2, 0xA0}, 229}, /* ста */
    {{0xE7, 0xA5, 0xAD}, 226}, /* чен */
    {{0xE2, 0xE0, 0xA5}, 224}, /* тре */
    {{0xA7, 0xAC, 0xA5}, 214}, /* зме */
    {{0xE3, 0xE9, 0xA5}, 212}, /* уще */
    {{0xE1, 0xE2, 0xA8}, 210}, /* сти */
    {{0xAA, 0xAE, 0xAC}, 207}, /* ком */
    {{0xAE, 0xE0, 0xAE}, 206}, /* оро */
    {{0xA2, 0xAB, 0xA5}, 195}, /* вле */
    {{0xA7, 0xA0, 0xAD}, 194}, /* зан */
    {{0xA0, 0xE1, 0xE2}, 193}, /* аст */
    {{0xE2, 0xE1, 0xEF}, 191}, /* тся */
    {{0xE5, 0xE0, 0xA0}, 187}, /* хра */
    {{0xA0, 0xAD, 0xAD}, 182}, /* анн */
    {{0xA5, 0xE0, 0xA5}, 182}, /* ере */
    {{0xA2, 0xE0, 0xA5}, 178}, /* вре */
    {{0xAE, 0xA2, 0xA5}, 173}, /* ове */
    {{0xEC, 0xAD, 0xAE}, 173}, /* ьно */
    {{0xA2, 0xA5, 0xE0}, 172}, /* вер */
    {{0xAC, 0xA5, 0xAD}, 170}, /* мен */
    {{0xAB, 0xA8, 0xE6}, 168}, /* лиц */
    {{0xE2, 0xAE, 0xE0}, 167}, /* тор */
    {{0xE0, 0xA5, 0xAD}, 167}, /* рен */
    {{0xE9, 0xA5, 0xAD}, 165}, /* щен */
    {{0xAE, 0xA7, 0xAC}, 164}, /* озм */
    {{0xA5, 0xA4, 0xA0}, 163}, /* еда */
    {{0xE2, 0xA2, 0xA8}, 159}, /* тви */
    {{0xEF, 0xA7, 0xA0}, 159}, /* яза */
    {{0xA1, 0xEF, 0xA7}, 158}, /* бяз */
    {{0xAD, 0xA8, 0xA8}, 153}, /* нии */
    {{0xAD, 0xEB, 0xE5}, 153}, /* ных */
    {{0xE2, 0xEC, 0xEF}, 153}, /* тья */
    {{0xAC, 0xA5, 0xE0}, 153}, /* мер */
    {{0xE1, 0xAB, 0xA8}, 150}, /* сли */
    {{0xE2, 0xAE, 0xA2}, 148}, /* тов */
    {{0xE2, 0xA2, 0xA0}, 147}, /* тва */
    {{0xAE, 0xE0, 0xA0}, 146}, /* ора */
    {{0xAD, 0xAE, 0xAC}, 144}, /* ном */
    {{0xA4, 0xA5, 0xAD}, 144}, /* ден */
    {{0xA0, 0xAD, 0xA5}, 142}, /* ане */
    {{0xAA, 0xAE, 0xAD}, 141}, /* кон */
    {{0xAB, 0xE3, 0xE7}, 141}, /* луч */
    {{0xAC, 0xE3, 0xE9}, 140}, /* мущ */
    {{0xAE, 0xA1, 0xEF}, 140}, /* обя */
    {{0xA2, 0xA0, 0xE2}, 138}, /* ват */
    {{0xA2, 0xA0, 0xE0}, 137}, /* вар */
    {{0xA5, 0xE9, 0xA5}, 137}, /* еще */
    {{0xAE, 0xE2, 0xE0}, 137}, /* отр */
    {{0xA4, 0xA5, 0xAB}, 137}, /* дел */
    {{0xAD, 0xEB, 0xAC}, 136}, /* ным */
    {{0xA8, 0xAC, 0xE3}, 136}, /* иму */
    {{0x91, 0xE2, 0xA0}, 134}, /* Ста */
    {{0xE3, 0xE7, 0xA0}, 133}, /* уча */
    {{0xE2, 0xE1, 0xE2}, 131}, /* тст */
    {{0xA5, 0xAB, 0xEF}, 130}, /* еля */
    {{0xE1, 0xAB, 0xE3}, 130}, /* слу */
    {{0xA7, 0xA0, 0xAA}, 130}, /* зак */
    {{0xE2, 0xAE, 0xEF}, 129}, /* тоя */
    {{0xAE, 0xAC, 0xA8}, 128}, /* оми */
    {{0xAC, 0xA5, 0xE9}, 128}, /* мещ */
    {{0xA5, 0xA4, 0xE3}, 127}, /* еду */
    {{0xA2, 0xA5, 0xAD}, 127}, /* вен */
    {{0xAD, 0xAE, 0xA2}, 127}, /* нов */
    {{0xAD, 0xAE, 0xA5}, 126}, /* ное */
    {{0xAE, 0xE2, 0xA2}, 125}, /* отв */
    {{0xAA, 0xA0, 0xA7}, 125}, /* каз */
    {{0xA0, 0xA5, 0xE2}, 125}, /* ает */
    {{0xE1, 0xAA, 0xAE}, 125}, /* ско */
    {{0xA5, 0xAD, 0xE2}, 124}, /* ент */
    {{0xAC, 0xAE, 0xE2}, 123}, /* мот */
    {{0xA0, 0xA2, 0xAB}, 122}, /* авл */
    {{0xE1, 0xAC, 0xAE}, 122}, /* смо */
    {{0xA8, 0xE7, 0xA8}, 121}, /* ичи */
    {{0xA1, 0xEB, 0xE2}, 120}, /* быт */
    {{0xE3, 0xE1, 0xAC}, 118}, /* усм */
    {{0xE1, 0xE1, 0xA8}, 117}, /* сси */
    {{0xA4, 0xE3, 0xE1}, 117}, /* дус */
    {{0xE5, 0xAE, 0xA4}, 117}, /* ход */
    {{0xE0, 0xA8, 0xE7}, 117}, /* рич */
    {{0xE7, 0xA5, 0xE1}, 115}, /* чес */
    {{0xA3, 0xE0, 0xA0}, 114}, /* гра */
    {{0xAF, 0xE0, 0xAE}, 114}, /* про */
    {{0xA4, 0xAE, 0xA2}, 113}, /* дов */
    {{0xA2, 0xA5, 0xE2}, 112}, /* вет */
    {{0xA5, 0xA4, 0xA5}, 112}, /* еде */
    {{0xE8, 0xA5, 0xAD}, 111}, /* шен */
    {{0xE7, 0xA8, 0xAD}, 110}, /* чин */
    {{0xAD, 0xA0, 0xE1}, 109}, /* нас */
    {{0xA8, 0xE2, 0xEC}, 105}, /* ить */
    {{0xE2, 0xA2, 0xAE}, 105}, /* тво */
    {{0xAA, 0xAB, 0xEE}, 104}, /* клю */
    {{0xE0, 0xA8, 0xE2}, 104}, /* рит */
    {{0xE1, 0xE2, 0xEC}, 104}, /* сть */
    {{0xAB, 0xEE, 0xE7}, 104}, /* люч */
    {{0xE2, 0xAE, 0xAC}, 104}, /* том */
    {{0xE1, 0xAB, 0xA5}, 103}, /* сле */
    {{0xE1, 0xAF, 0xAE}, 102}, /* спо */
    {{0xAE, 0xAB, 0xAD}, 102}, /* олн */
    {{0xA5, 0xE1, 0xAB}, 102}, /* есл */
    {{0xA5, 0xE0, 0xA8}, 101}, /* ери */
    {{0xAD, 0xAE, 0xA9}, 101}, /* ной */
    {{0xE0, 0xAE, 0xAC}, 101}, /* ром */
    {{0xAE, 0xE2, 0xAE}, 99}, /* ото */
    {{0xAD, 0xEB, 0xA5}, 99}, /* ные */
    {{0xA7, 0xAD, 0xA0}, 99}, /* зна */
    {{0xA2, 0xAB, 0xEF}, 99}, /* вля */
    {{0xE2, 0xA5, 0xE0}, 98}, /* тер */
    {{0xE3, 0xAF, 0xE0}, 97}, /* упр */
    {{0xA0, 0xAA, 0xAE}, 96}, /* ако */
    {{0xAA, 0xAE, 0xA3}, 96}, /* ког */
    {{0xAD, 0xEB, 0xA9}, 96}, /* ный */
    {{0xAE, 0xE0, 0xE3}, 96}, /* ору */
    {{0xA5, 0xAB, 0xA5}, 95}, /* еле */
    {{0xA5, 0xE1, 0xAA}, 95}, /* еск */
    {{0xA0, 0xA7, 0xA0}, 95}, /* аза */
    {{0xA9, 0xE1, 0xE2}, 93}, /* йст */
    {{0xAF, 0xAE, 0xE0}, 93}, /* пор */
    {{0xAE, 0xA6, 0xA5}, 92}, /* оже */
    {{0xA8, 0xAD, 0xA5}, 91}, /* ине */
    {{0xE9, 0xA5, 0xA9}, 90}, /* щей */
    {{0xA6, 0xA4, 0xA5}, 90}, /* жде */
    {{0xAF, 0xA5, 0xE0}, 89}, /* пер */
    {{0xAD, 0xA8, 0xE2}, 89}, /* нит */
    {{0xAE, 0xAB, 0xEC}, 89}, /* оль */
    {{0xA0, 0xA6, 0xA4}, 88}, /* ажд */
    {{0xA6, 0xA5, 0xAD}, 87}, /* жен */
    {{0xAB, 0xA0, 0xA4}, 87}, /* лад */
    {{0xA0, 0xAC, 0xA8}, 87}, /* ами */
    {{0xAA, 0xAE, 0xE2}, 86}, /* кот */
    {{0xE7, 0xA0, 0xA5}, 85}, /* чае */
    {{0xA2, 0xA5, 0xE9}, 85}, /* вещ */
    {{0xA2, 0xA8, 0xEF}, 85}, /* вия */
    {{0xEF, 0xE9, 0xA5}, 85}, /* яще */
    {{0xA8, 0xA5, 0xAC}, 85}, /* ием */
    {{0xAA, 0xAB, 0xA0}, 85}, /* кла */
    {{0xA5, 0xA9, 0xE1}, 84}, /* ейс */
    {{0xEB, 0xE2, 0xEC}, 84}, /* ыть */
    {{0xA0, 0xA2, 0xAE}, 84}, /* аво */
    {{0xE0, 0xA0, 0xA6}, 83}, /* раж */
    {{0xAB, 0xEC, 0xE1}, 83}, /* льс */
    {{0xAE, 0xEF, 0xE9}, 82}, /* оящ */
    {{0xA5, 0xAD, 0xAE}, 81}, /* ено */
    {{0xA4, 0xE1, 0xE2}, 81}, /* дст */
    {{0xA4, 0xA5, 0xA9}, 80}, /* дей */
    {{0xE0, 0xA5, 0xA1}, 80}, /* реб */
    {{0xEC, 0xE1, 0xE2}, 79}, /* ьст */
    {{0xA5, 0xA4, 0xE1}, 79}, /* едс */
    {{0xA0, 0xE0, 0xA8}, 79}, /* ари */
    {{0xA4, 0xA0, 0xAD}, 79}, /* дан */
    {{0xAC, 0xAE, 0xA6}, 78}, /* мож */
    {{0xA8, 0xAC, 0xA5}, 78}, /* име */
    {{0xA8, 0xAD, 0xAE}, 78}, /* ино */
    {{0xE0, 0xA8, 0xAD}, 77}, /* рин */
    {{0xA4, 0xAE, 0xE1}, 77}, /* дос */
    {{0xAF, 0xAE, 0xE1}, 77}, /* пос */
    {{0xE2, 0xA0, 0xAA}, 77}, /* так */
    {{0xE9, 0xA5, 0xA3}, 77}, /* щег */
    {{0xA4, 0xA0, 0xE2}, 77}, /* дат */
    {{0xAF, 0xAB, 0xA0}, 76}, /* пла */
    {{0xE3, 0xE1, 0xAB}, 76}, /* усл */
    {{0xA8, 0xE6, 0xA0}, 76}, /* ица */
    {{0xE0, 0xAE, 0xA2}, 75}, /* ров */
    {{0xED, 0xE2, 0xAE}, 75}, /* это */
    {{0xE3, 0xE7, 0xA5}, 74}, /* уче */
    {{0xA4, 0xAE, 0xAB}, 73}, /* дол */
    {{0xEC, 0xAD, 0xEB}, 73}, /* ьны */
    {{0xE0, 0xA0, 0xA7}, 73}, /* раз */
    {{0xAC, 0xA8, 0xE1}, 73}, /* мис */
    {{0xA0, 0xAD, 0xAE}, 72}, /* ано */
    {{0xE1, 0xE0, 0xAE}, 72}, /* сро */
    {{0xA0, 0xA2, 0xA8}, 72}, /* ави */
    {{0xE2, 0xEC, 0xA8}, 71}, /* тьи */
    {{0xEE, 0xE7, 0xA5}, 70}, /* юче */
    {{0xE1, 0xAA, 0xAB}, 70}, /* скл */
    {{0xA8, 0xE1, 0xE1}, 70}, /* исс */
    {{0xA6, 0xA5, 0xE2}, 69}, /* жет */
    {{0xA5, 0xA4, 0xAE}, 69}, /* едо */
    {{0xAB, 0xA5, 0xA4}, 69}, /* лед */
    {{0xAB, 0xAE, 0xA2}, 69}, /* лов */
    {{0xEE, 0xE9, 0xA8}, 68}, /* ющи */
    {{0xA8, 0xA1, 0xAE}, 68}, /* ибо */
    {{0xAB, 0xA0, 0xE2}, 67}, /* лат */
    {{0xE0, 0xAE, 0xAA}, 67}, /* рок */
    {{0xA0, 0xAA, 0xAB}, 67}, /* акл */
    {{0xE0, 0xA8, 0xE9}, 67}, /* рищ */
    {{0xA1, 0xAE, 0xA2}, 67}, /* бов */
    {{0xA8, 0xE1, 0xAA}, 67}, /* иск */
    {{0xA5, 0xA1, 0xAE}, 67}, /* ебо */
    {{0xAB, 0xEC, 0xA7}, 67}, /* льз */
    {{0xE3, 0xAA, 0xA0}, 67}, /* ука */
    {{0xAB, 0xA8, 0xA1}, 66}, /* либ */
    {{0xAE, 0xAC, 0xE3}, 66}, /* ому */
    {{0xAE, 0xA2, 0xAB}, 66}, /* овл */
    {{0xE2, 0xAD, 0xAE}, 65}, /* тно */
    {{0xA2, 0xAE, 0xA9}, 64}, /* вой */
    {{0xE2, 0xAE, 0xA3}, 64}, /* тог */
    {{0xE1, 0xAB, 0xAE}, 64}, /* сло */
    {{0xAE, 0xA7, 0xAD}, 64}, /* озн */
    {{0xE1, 0xAE, 0xAE}, 64}, /* соо */
    {{0xA7, 0xA0, 0xE2}, 63}, /* зат */
    {{0xA8, 0xE1, 0xAF}, 63}, /* исп */
    {{0xA0, 0xE7, 0xA5}, 63}, /* аче */
    {{0xAD, 0xA8, 0xEE}, 63}, /* нию */
    {{0xAE, 0xAD, 0xA5}, 63}, /* оне */
    {{0xAE, 0xAB, 0xA6}, 62}, /* олж */
    {{0xAE, 0xA2, 0xE9}, 61}, /* овщ */
    {{0xE0, 0xA0, 0xE1}, 61}, /* рас */
    {{0xA2, 0xA8, 0xA4}, 61}, /* вид */
    {{0xA2, 0xE9, 0xA8}, 61}, /* вщи */
    {{0xE1, 0xAD, 0xAE}, 61}, /* сно */
    {{0xA8, 0xE6, 0xAE}, 61}, /* ицо */
    {{0xA8, 0xE7, 0xA5}, 61}, /* иче */
    {{0xA0, 0xA2, 0xA5}, 61}, /* аве */
    {{0xA3, 0xAB, 0xA0}, 61}, /* гла */
    {{0xE7, 0xA5, 0xE2}, 61}, /* чет */
    {{0xE9, 0xA8, 0xAA}, 61}, /* щик */
    {{0xE0, 0xE3, 0xA3}, 60}, /* руг */
    {{0xE2, 0xA0, 0xAD}, 60}, /* тан */
    {{0xA8, 0xAC, 0xAE}, 60}, /* имо */
    {{0xA0, 0xAB, 0xEC}, 60}, /* аль */
    {{0xAE, 0xA2, 0xA8}, 60}, /* ови */
    {{0xA6, 0xA4, 0xA0}, 60}, /* жда */
    {{0xAF, 0xAE, 0xA2}, 60}, /* пов */
    {{0xA5, 0xAC, 0xE3}, 60}, /* ему */
    {{0xEF, 0xE2, 0xA5}, 60}, /* яте */
    {{0xE1, 0xA8, 0xA8}, 59}, /* сии */
    {{0xA1, 0xAE, 0xE2}, 59}, /* бот */
    {{0xA2, 0xEB, 0xAF}, 59}, /* вып */
    {{0xA0, 0xA1, 0xAE}, 59}, /* або */
    {{0xAB, 0xEF, 0xEE}, 59}, /* ляю */
    {{0xE1, 0xE3, 0xE9}, 58}, /* сущ */
    {{0xAE, 0xA4, 0xA5}, 58}, /* оде */
    {{0xA8, 0xAD, 0xA8}, 58}, /* ини */
    {{0xE0, 0xA0, 0xE2}, 58}, /* рат */
    {{0xEF, 0xA2, 0xAB}, 58}, /* явл */
    {{0xAD, 0xA0, 0xA3}, 57}, /* наг */
    {{0xA4, 0xE0, 0xE3}, 57}, /* дру */
    {{0xE0, 0xA0, 0xA1}, 57}, /* раб */
    {{0xA0, 0xA3, 0xE0}, 57}, /* агр */
    {{0xA8, 0xAE, 0xAD}, 57}, /* ион */
    {{0xAC, 0xA5, 0xE1}, 57}, /* мес */
    {{0xA0, 0xE6, 0xA8}, 56}, /* аци */
    {{0xAE, 0xE1, 0xE3}, 56}, /* осу */
    {{0xAA, 0xAE, 0xA9}, 55}, /* кой */
    {{0xE1, 0xA2, 0xAE}, 55}, /* сво */
    {{0xA7, 0xAE, 0xA2}, 55}, /* зов */
    {{0xAE, 0xAF, 0xE0}, 54}, /* опр */
    {{0xE1, 0xAE, 0xA1}, 54}, /* соб */
    {{0xA2, 0xAF, 0xE0}, 54}, /* впр */
    {{0xAB, 0xAD, 0xA5}, 54}, /* лне */
    {{0xAE, 0xAC, 0xAC}, 54}, /* омм */
    {{0xA5, 0xE0, 0xA0}, 54}, /* ера */
    {{0xE7, 0xA8, 0xE2}, 54}, /* чит */
    {{0xA5, 0xE0, 0xE7}, 54}, /* ерч */
    {{0xE0, 0xE7, 0xA5}, 54}, /* рче */
    {{0xA0, 0xE2, 0xA8}, 54}, /* ати */
    {{0xAD, 0xA8, 0xAA}, 54}, /* ник */
    {{0xAC, 0xAC, 0xA5}, 54}, /* мме */
    {{0xE3, 0xE1, 0xE2}, 53}, /* уст */
    {{0xE2, 0xA5, 0xAD}, 53}, /* тен */
    {{0xA2, 0xA5, 0xA4}, 53}, /* вед */
    {{0xE1, 0xAE, 0xA2}, 52}, /* сов */
    {{0xA0, 0xA6, 0xA5}, 52}, /* аже */
    {{0xAE, 0xAA, 0xA0}, 52}, /* ока */
    {{0xEB, 0xAC, 0xA8}, 52}, /* ыми */
    {{0xEE, 0xE2, 0xE1}, 52}, /* ютс */
    {{0xAE, 0xAE, 0xE2}, 52}, /* оот */
    {{0xAC, 0xA8, 0xE2}, 52}, /* мит */
    {{0xEF, 0xEE, 0xE9}, 51}, /* яющ */
    {{0xA2, 0xE8, 0xA5}, 51}, /* вше */
    {{0xE1, 0xA8, 0xAE}, 51}, /* сио */
    {{0xAE, 0xAD, 0xAE}, 51}, /* оно */
    {{0xA0, 0xA2, 0xA0}, 51}, /* ава */
    {{0xA0, 0xE9, 0xA5}, 51}, /* аще */
    {{0xAB, 0xEF, 0xA5}, 50}, /* ляе */
    {{0xA5, 0xAD, 0xA5}, 50}, /* ене */
    {{0xAE, 0xA4, 0xA8}, 50}, /* оди */
    {{0xAF, 0xE3, 0xAD}, 49}, /* пун */
    {{0xAB, 0xA8, 0xE7}, 49}, /* лич */
    {{0xA2, 0xAE, 0xAC}, 49}, /* вом */
    {{0xAD, 0xAA, 0xE2}, 49}, /* нкт */
    {{0xAD, 0xA5, 0xE1}, 49}, /* нес */
    {{0xA2, 0xA8, 0xAB}, 49}, /* вил */
    {{0xA5, 0xA6, 0xA4}, 49}, /* ежд */
    {{0xE0, 0xA5, 0xE1}, 49}, /* рес */
    {{0xEE, 0xE9, 0xA5}, 49}, /* юще */
    {{0xEC, 0xA7, 0xAE}, 49}, /* ьзо */
    {{0xAF, 0xAE, 0xE2}, 49}, /* пот */
    {{0xE3, 0xAD, 0xAA}, 49}, /* унк */
    {{0xE1, 0xE2, 0xA5}, 49}, /* сте */
    {{0xAA, 0xAE, 0xA2}, 49}, /* ков */
    {{0xAE, 0xE1, 0xAB}, 48}, /* осл */
    {{0xEF, 0xA5, 0xE2}, 48}, /* яет */
    {{0x85, 0xE1, 0xAB}, 48}, /* Есл */
    {{0x8F, 0xE0, 0xA8}, 48}, /* При */
    {{0xE2, 0xA0, 0xA2}, 48}, /* тав */
    {{0xAD, 0xA5, 0xE0}, 48}, /* нер */
    {{0xE7, 0xAD, 0xAE}, 47}, /* чно */
    {{0xAF, 0xAE, 0xA4}, 47}, /* под */
    {{0xAD, 0xE2, 0xA0}, 47}, /* нта */
    {{0xA8, 0xE9, 0xA5}, 47}, /* ище */
    {{0xAE, 0xA1, 0xE9}, 47}, /* общ */
    {{0xA0, 0xA7, 0xAC}, 47}, /* азм */
    {{0xA6, 0xAD, 0xAE}, 47}, /* жно */
    {{0xA2, 0xA8, 0xA8}, 46}, /* вии */
    {{0xE0, 0xA0, 0xE9}, 46}, /* ращ */
    {{0xAE, 0xE0, 0xA5}, 46}, /* оре */
    {{0xA2, 0xE8, 0xA8}, 46}, /* вши */
    {{0xA5, 0xAA, 0xE1}, 46}, /* екс */
    {{0xA2, 0xAE, 0xA3}, 46}, /* вог */
    {{0xE7, 0xE2, 0xAE}, 46}, /* что */
    {{0xA8, 0xE7, 0xAD}, 45}, /* ичн */
    {{0xAB, 0xA5, 0xAC}, 45}, /* лем */
    {{0xAC, 0xAE, 0xA3}, 45}, /* мог */
    {{0xE2, 0xA2, 0xAB}, 45}, /* твл */
    {{0xA4, 0xAB, 0xA5}, 45}, /* дле */
    {{0xA4, 0xAB, 0xEF}, 45}, /* для */
    {{0xE0, 0xA5, 0xE2}, 45}, /* рет */
    {{0xA0, 0xE0, 0xA0}, 45}, /* ара */
    {{0xAD, 0xEF, 0xE2}, 44}, /* нят */
    {{0xA5, 0xE7, 0xA5}, 44}, /* ече */
    {{0xAE, 0xE2, 0xA5}, 44}, /* оте */
    {{0xAE, 0xE0, 0xEB}, 44}, /* оры */
    {{0xAE, 0xE1, 0xAD}, 43}, /* осн */
    {{0xAE, 0xA1, 0xAE}, 43}, /* обо */
    {{0xAE, 0xA3, 0xAB}, 43}, /* огл */
    {{0xA8, 0xAD, 0xEB}, 43}, /* ины */
    {{0xA5, 0xE1, 0xE1}, 43}, /* есс */
    {{0xAE, 0xA1, 0xE0}, 43}, /* обр */
    {{0xAA, 0xE0, 0xA0}, 43}, /* кра */
    {{0xA8, 0xEF, 0xAC}, 43}, /* иям */
    {{0xA0, 0xAB, 0xAE}, 43}, /* ало */
    {{0xE0, 0xE3, 0xE7}, 43}, /* руч */
    {{0xAE, 0xE0, 0xA3}, 43}, /* орг */
    {{0xE7, 0xA0, 0xEF}, 42}, /* чая */
    {{0xAD, 0xA8, 0xAC}, 42}, /* ним */
    {{0xA8, 0xA7, 0xAD}, 42}, /* изн */
    {{0xAF, 0xAE, 0xAA}, 42}, /* пок */
    {{0xE1, 0xE2, 0xE3}, 42}, /* сту */
    {{0xA5, 0xAB, 0xEE}, 42}, /* елю */
    {{0xE2, 0xA8, 0xE2}, 42}, /* тит */
    {{0xE6, 0xA5, 0xAD}, 42}, /* цен */
    {{0xE7, 0xA0, 0xE1}, 42}, /* час */
    {{0xA3, 0xA0, 0xAD}, 42}, /* ган */
    {{0xE0, 0xA3, 0xA0}, 42}, /* рга */
    {{0xE1, 0xE2, 0xAD}, 42}, /* стн */
    {{0xE0, 0xA5, 0xA6}, 42}, /* реж */
    {{0xE3, 0xAC, 0xAC}, 42}, /* умм */
    {{0xE2, 0xA2, 0xE3}, 41}, /* тву */
    {{0xE2, 0xE3, 0xAF}, 41}, /* туп */
    {{0xE1, 0xAA, 0xA8}, 40}, /* ски */
    {{0xA4, 0xA5, 0xAA}, 40}, /* дек */
    {{0xAB, 0xA5, 0xA6}, 40}, /* леж */
    {{0xA5, 0xE1, 0xA5}, 40}, /* есе */
    {{0xA2, 0xA8, 0xA5}, 40}, /* вие */
    {{0xE2, 0xAA, 0xA0}, 40}, /* тка */
    {{0xA5, 0xAA, 0xE0}, 40}, /* екр */
    {{0xAE, 0xA4, 0xAE}, 40}, /* одо */
    {{0xAA, 0xE1, 0xA0}, 40}, /* кса */
    {{0xE0, 0xA5, 0xAA}, 40}, /* рек */
    {{0xAD, 0xE2, 0xA5}, 40}, /* нте */
    {{0xE3, 0xA3, 0xA8}, 40}, /* уги */
    {{0xA1, 0xEB, 0xAB}, 40}, /* был */
    {{0xA8, 0xAD, 0xEF}, 40}, /* иня */
    {{0xA5, 0xE9, 0xA8}, 39}, /* ещи */
    {{0xA3, 0xA5, 0xAD}, 39}, /* ген */
    {{0x8A, 0xAE, 0xA4}, 39}, /* Код */
    {{0xA4, 0xA8, 0xE2}, 39}, /* дит */
    {{0xE1, 0xE5, 0xAE}, 39}, /* схо */
    {{0xA8, 0xAD, 0xE2}, 39}, /* инт */
    {{0xE1, 0xE3, 0xAC}, 39}, /* сум */
    {{0xE0, 0xAE, 0xAD}, 39}, /* рон */
    {{0xAE, 0xE2, 0xAA}, 39}, /* отк */
    {{0xA4, 0xAE, 0xAA}, 39}, /* док */
    {{0xA8, 0xAB, 0xA0}, 38}, /* ила */
    {{0xE6, 0xA5, 0xE1}, 38}, /* цес */
    {{0xA8, 0xAA, 0xA0}, 38}, /* ика */
    {{0xA7, 0xAD, 0xA8}, 38}, /* зни */
    {{0xAE, 0xA2, 0xEB}, 38}, /* овы */
    {{0xAB, 0xA6, 0xAD}, 38}, /* лжн */
    {{0xE3, 0xAF, 0xAB}, 38}, /* упл */
    {{0xA3, 0xA4, 0xA0}, 37}, /* гда */
    {{0xAB, 0xA0, 0xA6}, 37}, /* лаж */
    {{0xA6, 0xA5, 0xA4}, 37}, /* жед */
    {{0xA1, 0xA5, 0xA7}, 37}, /* без */
    {{0xA4, 0xA5, 0xE2}, 37}, /* дет */
    {{0xAE, 0xE0, 0xEF}, 37}, /* оря */
    {{0xE0, 0xAE, 0xE1}, 37}, /* рос */
    {{0xAE, 0xA1, 0xAB}, 37}, /* обл */
    {{0xE6, 0xA8, 0xA8}, 37}, /* ции */
    {{0xA4, 0xAE, 0xAC}, 37}, /* дом */
    {{0xAD, 0xE6, 0xA5}, 37}, /* нце */
    {{0xE8, 0xA5, 0xA3}, 37}, /* шег */
    {{0xAB, 0xAE, 0xA6}, 37}, /* лож */
    {{0xAE, 0xAD, 0xA0}, 37}, /* она */
    {{0xAE, 0xAA, 0xAB}, 37}, /* окл */
    {{0xAE, 0xA3, 0xA4}, 37}, /* огд */
    {{0xE0, 0xAE, 0xA4}, 37}, /* род */
    {{0xA5, 0xAD, 0xA0}, 37}, /* ена */
    {{0xAE, 0xAD, 0xE6}, 37}, /* онц */
    {{0xAE, 0xE2, 0xAD}, 37}, /* отн */
    {{0xE1, 0xAE, 0xA3}, 37}, /* сог */
    {{0xA5, 0xA2, 0xE8}, 37}, /* евш */
    {{0xA2, 0xA8, 0xE2}, 36}, /* вит */
    {{0xA5, 0xE0, 0xAF}, 36}, /* ерп */
    {{0xAE, 0xA4, 0xA0}, 36}, /* ода */
    {{0xA5, 0xE2, 0xA5}, 36}, /* ете */
    {{0xAD, 0xA5, 0xAE}, 36}, /* нео */
    {{0xE0, 0xAF, 0xA5}, 36}, /* рпе */
    {{0xA5, 0xE0, 0xE8}, 36}, /* ерш */
    {{0xA8, 0xAC, 0xA8}, 36}, /* ими */
    {{0xA8, 0xA2, 0xE8}, 36}, /* ивш */
    {{0xEB, 0xAF, 0xAB}, 36}, /* ыпл */
    {{0xAF, 0xA5, 0xA2}, 36}, /* пев */
    {{0xA0, 0xA4, 0xA0}, 36}, /* ада */
    {{0xAC, 0xAE, 0xE1}, 35}, /* мос */
    {{0xAE, 0xA1, 0xE1}, 35}, /* обс */
    {{0xAD, 0xA5, 0xA4}, 34}, /* нед */
    {{0xA8, 0xAA, 0xAE}, 34}, /* ико */
    {{0xE9, 0xA8, 0xAC}, 34}, /* щим */
    {{0xA4, 0xA5, 0xE0}, 34}, /* дер */
    {{0xE1, 0xAA, 0xA0}, 34}, /* ска */
    {{0xAE, 0xE0, 0xAC}, 34}, /* орм */
    {{0xE3, 0xAC, 0xA5}, 34}, /* уме */
    {{0xAE, 0xAE, 0xA1}, 34}, /* ооб */
    {{0xE0, 0xA8, 0xE1}, 34}, /* рис */
    {{0xAE, 0xA1, 0xEA}, 33}, /* объ */
    {{0xAE, 0xAB, 0xE3}, 33}, /* олу */
    {{0xEA, 0xEF, 0xA2}, 33}, /* ъяв */
    {{0xE0, 0xA5, 0xAC}, 33}, /* рем */
    {{0xE9, 0xA8, 0xE5}, 33}, /* щих */
    {{0xE3, 0xEE, 0xE9}, 33}, /* ующ */
    {{0xAA, 0xA6, 0xA5}, 33}, /* кже */
    {{0xA8, 0xA4, 0xA5}, 33}, /* иде */
    {{0xA1, 0xE1, 0xE2}, 33}, /* бст */
    {{0xA0, 0xAA, 0xA6}, 33}, /* акж */
    {{0xA2, 0xE3, 0xEE}, 33}, /* вую */
    {{0xA0, 0xE1, 0xE5}, 33}, /* асх */
    {{0xA0, 0xAD, 0xA0}, 32}, /* ана */
    {{0xAD, 0xA0, 0xA4}, 32}, /* над */
    {{0xAE, 0xA1, 0xA5}, 32}, /* обе */
    {{0xEB, 0xE2, 0xAA}, 32}, /* ытк */
    {{0xED, 0xE2, 0xA8}, 32}, /* эти */
    {{0xAE, 0xA6, 0xAD}, 32}, /* ожн */
    {{0xA0, 0xE2, 0xEB}, 31}, /* аты */
    {{0xE1, 0xA4, 0xA5}, 31}, /* сде */
    {{0xA0, 0xEE, 0xE2}, 31}, /* ают */
    {{0xEF, 0xE2, 0xEC}, 31}, /* ять */
    {{0xAE, 0xEF, 0xE2}, 31}, /* оят */
    {{0xA5, 0xE2, 0xEC}, 31}, /* еть */
    {{0xA0, 0xA3, 0xA5}, 31}, /* аге */
    {{0xE7, 0xE0, 0xA5}, 31}, /* чре */
    {{0xA5, 0xAD, 0xEB}, 31}, /* ены */
    {{0xE3, 0xA1, 0xEB}, 31}, /* убы */
    {{0xA8, 0xE1, 0xE2}, 30}, /* ист */
    {{0xEF, 0xEE, 0xE2}, 30}, /* яют */
    {{0xE0, 0xEF, 0xA4}, 30}, /* ряд */
    {{0xA3, 0xAE, 0xE1}, 30}, /* гос */
    {{0xA8, 0xAC, 0xA0}, 30}, /* има */
    {{0xA7, 0xA0, 0xE1}, 30}, /* зас */
    {{0xA0, 0xEE, 0xE9}, 30}, /* ающ */
    {{0xAE, 0xA7, 0xA2}, 30}, /* озв */
    {{0xA5, 0xA4, 0xA8}, 30}, /* еди */
    {{0xAE, 0xAC, 0xA5}, 30}, /* оме */
    {{0xAD, 0xA8, 0xA9}, 30}, /* ний */
    {{0xE1, 0xE3, 0xA4}, 30}, /* суд */
    {{0xA7, 0xA4, 0xAE}, 29}, /* здо */
    {{0xE1, 0xA2, 0xA8}, 29}, /* сви */
    {{0xAE, 0xAB, 0xA8}, 29}, /* оли */
    {{0xAE, 0xA2, 0xEC}, 29}, /* овь */
    {{0xA2, 0xA8, 0xA9}, 29}, /* вий */
    {{0xA4, 0xAE, 0xE0}, 29}, /* дор */
    {{0xA4, 0xA5, 0xEF}, 29}, /* дея */
    {{0xA5, 0xEF, 0xE2}, 29}, /* еят */
    {{0xE6, 0xAE, 0xAC}, 29}, /* цом */
    {{0xA8, 0xA7, 0xA0}, 28}, /* иза */
    {{0xE1, 0xE7, 0xA5}, 28}, /* сче */
    {{0xAA, 0xE2, 0xA0}, 28}, /* кта */
    {{0xAE, 0xA4, 0xAD}, 28}, /* одн */
    {{0xA1, 0xAB, 0xA0}, 28}, /* бла */
    {{0xAE, 0xA4, 0xAB}, 28}, /* одл */
    {{0xA8, 0xE2, 0xA0}, 28}, /* ита */
    {{0x84, 0xAE, 0xA3}, 28}, /* Дог */
    {{0xAE, 0xE1, 0xAE}, 28}, /* осо */
    {{0xAD, 0xAE, 0xE8}, 28}, /* нош */
    {{0xAA, 0xE3, 0xE0}, 28}, /* кур */
    {{0xA8, 0xAD, 0xA0}, 28}, /* ина */
    {{0xAE, 0xE8, 0xA5}, 28}, /* оше */
    {{0xAD, 0xA0, 0xAB}, 28}, /* нал */
    {{0xAD, 0xA8, 0xA7}, 27}, /* низ */
    {{0xA7, 0xA2, 0xE0}, 27}, /* звр */
    {{0xA2, 0xE0, 0xA0}, 27}, /* вра */
    {{0xAB, 0xA5, 0xE2}, 27}, /* лет */
    {{0xA5, 0xE9, 0xEC}, 27}, /* ещь */
    {{0xE0, 0xA8, 0xA4}, 27}, /* рид */
    {{0xA4, 0xAD, 0xAE}, 27}, /* дно */
    {{0xE0, 0xA8, 0xAE}, 27}, /* рио */
    {{0xAE, 0xA8, 0xAC}, 27}, /* оим */
    {{0xA5, 0xE0, 0xA6}, 27}, /* ерж */
    {{0xE3, 0xA2, 0xA5}, 26}, /* уве */
    {{0xAE, 0xAD, 0xAA}, 26}, /* онк */
    {{0xA5, 0xAB, 0xAA}, 26}, /* елк */
    {{0xAB, 0xA0, 0xA2}, 26}, /* лав */
    {{0xA0, 0xE2, 0xAE}, 26}, /* ато */
    {{0xEF, 0xAC, 0xA8}, 26}, /* ями */
    {{0xAC, 0xAC, 0xEB}, 26}, /* ммы */
    {{0xA5, 0xE1, 0xAF}, 26}, /* есп */
    {{0xAD, 0xAA, 0xE3}, 26}, /* нку */
    {{0xA8, 0xE6, 0xE3}, 25}, /* ицу */
    {{0xA4, 0xE1, 0xAA}, 25}, /* дск */
    {{0xAD, 0xA8, 0xAD}, 25}, /* нин */
    {{0xAF, 0xAB, 0xA5}, 25}, /* пле */
    {{0xE4, 0xAE, 0xE0}, 25}, /* фор */
    {{0xAB, 0xA0, 0xE1}, 25}, /* лас */
    {{0xA4, 0xA8, 0xAC}, 25}, /* дим */
    {{0xA5, 0xE1, 0xEF}, 25}, /* еся */
    {{0xAD, 0xA8, 0xE7}, 25}, /* нич */
    {{0xAE, 0xA2, 0xE0}, 25}, /* овр */
    {{0xA2, 0xE1, 0xAB}, 25}, /* всл */
    {{0xE0, 0xE8, 0xA5}, 25}, /* рше */
    {{0xA5, 0xE9, 0xA0}, 25}, /* еща */
    {{0xA6, 0xAD, 0xEB}, 25}, /* жны */
    {{0xE0, 0xA8, 0xAC}, 25}, /* рим */
    {{0xA7, 0xA0, 0xE6}, 25}, /* зац */
    {{0xA1, 0xE9, 0xA5}, 25}, /* бще */
    {{0xA0, 0xAA, 0xE2}, 25}, /* акт */
    {{0xA0, 0xA4, 0xE1}, 25}, /* адс */
    {{0xE3, 0xE7, 0xE0}, 25}, /* учр */
    {{0xE9, 0xA8, 0xA5}, 25}, /* щие */
    {{0xA6, 0xA8, 0xE2}, 24}, /* жит */
    {{0xA1, 0xE0, 0xA5}, 24}, /* бре */
    {{0xE3, 0xA3, 0xAE}, 24}, /* уго */
    {{0xA8, 0xEF, 0xE5}, 24}, /* иях */
    {{0xE2, 0xEC, 0xEE}, 24}, /* тью */
    {{0xEC, 0xE1, 0xEF}, 24}, /* ься */
    {{0xA2, 0xAE, 0xA2}, 24}, /* вов */
    {{0xAE, 0xE7, 0xAD}, 24}, /* очн */
    {{0xA2, 0xAE, 0xAE}, 24}, /* воо */
    {{0xAE, 0xA4, 0xEB}, 24}, /* оды */
    {{0xAB, 0xAE, 0xA3}, 24}, /* лог */
    {{0xA2, 0xA0, 0xA5}, 24}, /* вае */
    {{0xA0, 0xEF, 0xE5}, 24}, /* аях */
    {{0xE2, 0xEC, 0xE1}, 24}, /* тьс */
    {{0xA4, 0xA8, 0xE7}, 24}, /* дич */
    {{0xAA, 0xA8, 0xE5}, 24}, /* ких */
    {{0xE6, 0xA0, 0xAC}, 24}, /* цам */
    {{0xA8, 0xA7, 0xA2}, 24}, /* изв */
    {{0xE2, 0xA8, 0xA2}, 24}, /* тив */
    {{0xA5, 0xAE, 0xA1}, 24}, /* еоб */
    {{0xE1, 0xAE, 0xE1}, 24}, /* сос */
    {{0xE8, 0xA8, 0xAC}, 24}, /* шим */
    {{0xEB, 0xAF, 0xAE}, 24}, /* ыпо */
    {{0xA5, 0xA6, 0xA0}, 24}, /* ежа */
    {{0xE2, 0xAE, 0xA8}, 24}, /* тои */
    {{0xAA, 0xE2, 0xAE}, 24}, /* кто */
    {{0xA5, 0xE7, 0xA0}, 24}, /* еча */
    {{0xA8, 0xA4, 0xA8}, 24}, /* иди */
    {{0xA1, 0xE9, 0xA8}, 23}, /* бщи */
    {{0xE2, 0xEC, 0xA5}, 23}, /* тье */
    {{0xA1, 0xEA, 0xEF}, 23}, /* бъя */
    {{0xAD, 0xA0, 0xE7}, 23}, /* нач */
    {{0xE2, 0xA5, 0xE7}, 23}, /* теч */
    {{0xE3, 0xE0, 0xE1}, 23}, /* урс */
    {{0xA2, 0xA5, 0xE7}, 23}, /* веч */
    {{0xA5, 0xAC, 0xA5}, 23}, /* еме */
    {{0xAE, 0xA1, 0xE5}, 23}, /* обх */
    {{0xA1, 0xE5, 0xAE}, 23}, /* бхо */
    {{0xA4, 0xA0, 0xA5}, 23}, /* дае */
    {{0xE0, 0xA5, 0xA7}, 23}, /* рез */
    {{0xAA, 0xA0, 0xA6}, 22}, /* каж */
    {{0xAE, 0xAA, 0xE3}, 22}, /* оку */
    {{0xA0, 0xAC, 0xA5}, 22}, /* аме */
    {{0xAD, 0xA5, 0xA7}, 22}, /* нез */
    {{0xEB, 0xA2, 0xA0}, 22}, /* ыва */
    {{0xE1, 0xA2, 0xEF}, 22}, /* свя */
    {{0xE0, 0xA0, 0xA4}, 22}, /* рад */
    {{0xA5, 0xA7, 0xA0}, 22}, /* еза */
    {{0xA8, 0xA2, 0xA0}, 22}, /* ива */
    {{0xAA, 0xA0, 0xAC}, 22}, /* кам */
    {{0xAD, 0xA5, 0xAC}, 22}, /* нем */
    {{0xE2, 0xAA, 0xAE}, 22}, /* тко */
    {{0xA7, 0xA2, 0xA5}, 22}, /* зве */
    {{0xA2, 0xEF, 0xA7}, 22}, /* вяз */
    {{0xEF, 0xE2, 0xA8}, 22}, /* яти */
    {{0xAE, 0xE5, 0xE0}, 22}, /* охр */
    {{0xE0, 0xAE, 0xE2}, 22}, /* рот */
    {{0xAE, 0xAB, 0xA5}, 22}, /* оле */
    {{0xA1, 0xE0, 0xA0}, 22}, /* бра */
    {{0xA0, 0xA5, 0xAC}, 22}, /* аем */
    {{0xAB, 0xA0, 0xE8}, 21}, /* лаш */
    {{0xA8, 0xA7, 0xAC}, 21}, /* изм */
    {{0xA3, 0xE3, 0xE2}, 21}, /* гут */
    {{0xAE, 0xA6, 0xA4}, 21}, /* ожд */
    {{0xAA, 0xA0, 0xAA}, 21}, /* как */
    {{0xAA, 0xA0, 0xE7}, 21}, /* кач */
    {{0xAD, 0xA0, 0xAC}, 21}, /* нам */
    {{0xA4, 0xAE, 0xE5}, 21}, /* дох */
    {{0xAE, 0xE5, 0xAE}, 21}, /* охо */
    {{0xEE, 0xE0, 0xA8}, 21}, /* юри */
    {{0xA2, 0xA0, 0xAC}, 21}, /* вам */
    {{0xA7, 0xAC, 0xAE}, 21}, /* змо */
    {{0xA4, 0xAA, 0xA5}, 21}, /* дке */
    {{0xA1, 0xA0, 0xAD}, 21}, /* бан */
    {{0xA5, 0xAB, 0xA8}, 21}, /* ели */
    {{0xE0, 0xA8, 0xA7}, 21}, /* риз */
    {{0xAB, 0xAD, 0xAE}, 21}, /* лно */
    {{0xA2, 0xEB, 0xE8}, 21}, /* выш */
    {{0xA4, 0xE6, 0xA0}, 21}, /* дца */
    {{0xEF, 0xA4, 0xAA}, 21}, /* ядк */
    {{0xAE, 0xE2, 0xE1}, 21}, /* отс */
    {{0xE2, 0xA5, 0xA9}, 21}, /* тей */
    {{0xA0, 0xAD, 0xAA}, 21}, /* анк */
    {{0xAD, 0xA5, 0xA3}, 21}, /* нег */
    {{0xE6, 0xA0, 0xE2}, 21}, /* цат */
    {{0xA5, 0xAC, 0xEB}, 21}, /* емы */
    {{0xA2, 0xAE, 0xA5}, 21}, /* вое */
    {{0xA4, 0xA0, 0xE7}, 21}, /* дач */
    {{0xAE, 0xA3, 0xE3}, 21}, /* огу */
    {{0xAB, 0xA6, 0xA5}, 21}, /* лже */
    {{0xE2, 0xAD, 0xA8}, 21}, /* тни */
    {{0xA7, 0xA0, 0xA2}, 21}, /* зав */
    {{0xA2, 0xA5, 0xE1}, 21}, /* вес */
    {{0xE1, 0xA0, 0xAC}, 20}, /* сам */
    {{0xA0, 0xE0, 0xAD}, 20}, /* арн */
    {{0xE7, 0xAD, 0xEB}, 20}, /* чны */
    {{0xE1, 0xE0, 0xA5}, 20}, /* сре */
    {{0xE2, 0xA8, 0xEF}, 20}, /* тия */
    {{0xA8, 0xE1, 0xAB}, 20}, /* исл */
    {{0x91, 0xE2, 0xE0}, 20}, /* Стр */
    {{0xAD, 0xE2, 0xAE}, 20}, /* нто */
    {{0xE3, 0xE2, 0xE0}, 20}, /* утр */
    {{0xA0, 0xE8, 0xA5}, 20}, /* аше */
    {{0xA5, 0xAB, 0xA0}, 20}, /* ела */
    {{0xE3, 0xA4, 0xAE}, 20}, /* удо */
    {{0xA6, 0xA8, 0xA7}, 19}, /* жиз */
    {{0xAF, 0xA8, 0xE1}, 19}, /* пис */
    {{0xA0, 0xA8, 0xAC}, 19}, /* аим */
    {{0xE7, 0xA8, 0xE1}, 19}, /* чис */
    {{0xA5, 0xA6, 0xA8}, 19}, /* ежи */
    {{0xA2, 0xE1, 0xA5}, 19}, /* все */
    {{0xAB, 0xEC, 0xAA}, 19}, /* льк */
    {{0xA0, 0xE2, 0xE3}, 19}, /* ату */
    {{0xE3, 0xA4, 0xA0}, 19}, /* уда */
    {{0xE8, 0xA8, 0xA9}, 19}, /* ший */
    {{0xA7, 0xA0, 0xE0}, 19}, /* зар */
    {{0xA5, 0xA4, 0xAD}, 19}, /* едн */
    {{0xA0, 0xA2, 0xE8}, 19}, /* авш */
    {{0xE0, 0xAE, 0xA8}, 19}, /* рои */
    {{0xA8, 0xA4, 0xA0}, 19}, /* ида */
    {{0xA0, 0xE0, 0xAE}, 19}, /* аро */
    {{0xE2, 0xAE, 0xA9}, 19}, /* той */
    {{0xA6, 0xA0, 0xE9}, 19}, /* жащ */
    {{0xA5, 0xE1, 0xAE}, 19}, /* есо */
    {{0xAF, 0xA0, 0xAB}, 19}, /* пал */
    {{0xE9, 0xA0, 0xA5}, 19}, /* щае */
    {{0xE0, 0xEB, 0xA5}, 19}, /* рые */
    {{0xA5, 0xAD, 0xEF}, 19}, /* еня */
    {{0xE9, 0xA8, 0xA9}, 19}, /* щий */
    {{0xAB, 0xE3, 0xA3}, 19}, /* луг */
    {{0xEE, 0xE7, 0xA8}, 18}, /* ючи */
    {{0xE3, 0xAB, 0xEC}, 18}, /* уль */
    {{0xAC, 0xEB, 0xE5}, 18}, /* мых */
    {{0xE0, 0xAE, 0xA3}, 18}, /* рог */
    {{0xE1, 0xAE, 0xE5}, 18}, /* сох */
    {{0xAA, 0xAE, 0xA5}, 18}, /* кое */
    {{0xAD, 0xE2, 0xE1}, 18}, /* нтс */
    {{0xA0, 0xA7, 0xAD}, 18}, /* азн */
    {{0xE2, 0xAD, 0xEB}, 18}, /* тны */
    {{0xAE, 0xA4, 0xEF}, 18}, /* одя */
    {{0xAE, 0xA1, 0xAD}, 18}, /* обн */
    {{0xA2, 0xEB, 0xA4}, 18}, /* выд */
    {{0xAE, 0xE1, 0xEF}, 18}, /* ося */
    {{0xEC, 0xE2, 0xA0}, 18}, /* ьта */
    {{0xAD, 0xEF, 0xEE}, 18}, /* няю */
    {{0xAD, 0xA0, 0xE0}, 18}, /* нар */
    {{0xA5, 0xA7, 0xE3}, 18}, /* езу */
    {{0xA0, 0xE1, 0xAD}, 18}, /* асн */
    {{0xA7, 0xE3, 0xAB}, 18}, /* зул */
    {{0xE6, 0xA8, 0xAF}, 18}, /* цип */
    {{0xAA, 0xE2, 0xA5}, 18}, /* кте */
    {{0xA4, 0xAE, 0xAF}, 18}, /* доп */
    {{0xAD, 0xE6, 0xA8}, 18}, /* нци */
    {{0xE1, 0xAF, 0xA5}, 18}, /* спе */
    {{0xA8, 0xAC, 0xEB}, 18}, /* имы */
    {{0xAC, 0xAE, 0xAC}, 18}, /* мом */
    {{0xAF, 0xA5, 0xE7}, 18}, /* печ */
    {{0x8E, 0xA1, 0xEF}, 18}, /* Обя */
    {{0x8F, 0xE0, 0xA0}, 18}, /* Пра */
    {{0xAE, 0xAB, 0xAE}, 18}, /* оло */
    {{0xE2, 0xE1, 0xAA}, 18}, /* тск */
    {{0xAB, 0xAD, 0xA8}, 18}, /* лни */
    {{0xA5, 0xE0, 0xE2}, 18}, /* ерт */
    {{0xA8, 0xE1, 0xEC}, 18}, /* ись */
    {{0xAB, 0xEC, 0xE2}, 18}, /* льт */
    {{0xE1, 0xE3, 0xE2}, 18}, /* сут */
    {{0xA2, 0xAE, 0xA1}, 17}, /* воб */
    {{0xE0, 0xAD, 0xEB}, 17}, /* рны */
    {{0xA1, 0xAD, 0xEB}, 17}, /* бны */
    {{0xEB, 0xA4, 0xA0}, 17}, /* ыда */
    {{0xEC, 0xA7, 0xE3}, 17}, /* ьзу */
    {{0xA5, 0xA4, 0xAF}, 17}, /* едп */
    {{0xA0, 0xA4, 0xA5}, 17}, /* аде */
    {{0xA8, 0xAF, 0xA0}, 17}, /* ипа */
    {{0xE1, 0xA5, 0xA9}, 17}, /* сей */
    {{0xA5, 0xA5, 0xE1}, 17}, /* еес */
    {{0xAE, 0xA8, 0xA7}, 17}, /* оиз */
    {{0xAE, 0xE1, 0xA2}, 17}, /* осв */
    {{0xA4, 0xA8, 0xA2}, 17}, /* див */
    {{0xAD, 0xA0, 0xAD}, 17}, /* нан */
    {{0xA5, 0xE2, 0xA0}, 17}, /* ета */
    {{0xA4, 0xAD, 0xA5}, 17}, /* дне */
    {{0xA8, 0xAE, 0xA1}, 17}, /* иоб */
    {{0xE3, 0xA5, 0xE2}, 17}, /* ует */
    {{0xAD, 0xA0, 0xE5}, 17}, /* нах */
    {{0xE1, 0xAC, 0xA5}, 17}, /* сме */
    {{0xA0, 0xAB, 0xA8}, 17}, /* али */
    {{0xA1, 0xEA, 0xA5}, 17}, /* бъе */
    {{0xAF, 0xA0, 0xE1}, 17}, /* пас */
    {{0xA7, 0xA0, 0xAB}, 17}, /* зал */
    {{0xE0, 0xA6, 0xA0}, 16}, /* ржа */
    {{0xEF, 0xA2, 0xA8}, 16}, /* яви */
    {{0xA6, 0xA0, 0xE2}, 16}, /* жат */
    {{0xA1, 0xAE, 0xA6}, 16}, /* бож */
    {{0xE1, 0xA8, 0xAB}, 16}, /* сил */
    {{0xAD, 0xE3, 0xEE}, 16}, /* ную */
    {{0xAF, 0xA5, 0xAD}, 16}, /* пен */
    {{0xAC, 0xA0, 0xE2}, 16}, /* мат */
    {{0xAE, 0xAD, 0xAD}, 16}, /* онн */
    {{0xA2, 0xA8, 0xAD}, 16}, /* вин */
    {{0xE2, 0xAA, 0xA8}, 16}, /* тки */
    {{0xE2, 0xAE, 0xE7}, 16}, /* точ */
    {{0xE1, 0xE7, 0xA8}, 16}, /* счи */
    {{0xAD, 0xA8, 0xE6}, 16}, /* ниц */
    {{0xE9, 0xA5, 0xA5}, 16}, /* щее */
    {{0xA1, 0xA5, 0xE1}, 16}, /* бес */
    {{0xA0, 0xA4, 0xE6}, 16}, /* адц */
    {{0x8A, 0xAE, 0xAC}, 16}, /* Ком */
    {{0xEC, 0xA8, 0xAC}, 16}, /* ьим */
    {{0xE3, 0xE2, 0xE1}, 16}, /* утс */
    {{0xA0, 0xE7, 0xA8}, 16}, /* ачи */
    {{0xAF, 0xAE, 0xAD}, 16}, /* пон */
    {{0xAA, 0xA0, 0xA5}, 16}, /* кае */
    {{0xA8, 0xA3, 0xE0}, 16}, /* игр */
    {{0xA0, 0xAA, 0xA8}, 16}, /* аки */
    {{0xA0, 0xE9, 0xA8}, 16}, /* ащи */
    {{0xAB, 0xEC, 0xE6}, 16}, /* льц */
    {{0xA2, 0xAD, 0xAE}, 16}, /* вно */
    {{0xEB, 0xE8, 0xA5}, 15}, /* ыше */
    {{0x8B, 0xA8, 0xE6}, 15}, /* Лиц */
    {{0xEC, 0xA5, 0xA9}, 15}, /* ьей */
    {{0xE8, 0xA5, 0xAC}, 15}, /* шем */
    {{0xE3, 0xA1, 0xAB}, 15}, /* убл */
    {{0xE0, 0xA0, 0xE6}, 15}, /* рац */
    {{0xAA, 0xE3, 0xAC}, 15}, /* кум */
    {{0xE0, 0xA5, 0xA3}, 15}, /* рег */
    {{0xAE, 0xAF, 0xA0}, 15}, /* опа */
    {{0x82, 0xAE, 0xA7}, 15}, /* Воз */
    {{0xE2, 0xA0, 0xA5}, 15}, /* тае */
    {{0xAE, 0xA1, 0xEB}, 15}, /* обы */
    {{0xA1, 0xAB, 0xA8}, 15}, /* бли */
    {{0xE0, 0xAC, 0xA5}, 15}, /* рме */
    {{0xA2, 0xAE, 0xE1}, 15}, /* вос */
    {{0xA0, 0xE1, 0xA8}, 15}, /* аси */
    {{0xE2, 0xA0, 0xAC}, 15}, /* там */
    {{0xEC, 0xAC, 0xA5}, 15}, /* ьме */
    {{0xAE, 0xA3, 0xA0}, 15}, /* ога */
    {{0xA8, 0xAB, 0xAE}, 15}, /* ило */
    {{0xE1, 0xEC, 0xAC}, 15}, /* сьм */
    {{0xE0, 0xE2, 0xA8}, 15}, /* рти */
    {{0xE2, 0xE1, 0xE3}, 15}, /* тсу */
    {{0xE1, 0xA5, 0xAD}, 15}, /* сен */
    {{0xE2, 0xA0, 0xAB}, 15}, /* тал */
    {{0xA4, 0xA0, 0xE0}, 15}, /* дар */
    {{0xA0, 0xAC, 0xAE}, 15}, /* амо */
    {{0xA5, 0xA4, 0xAB}, 15}, /* едл */
    {{0xE1, 0xE3, 0xA1}, 15}, /* суб */
    {{0xA5, 0xA9, 0xE4}, 15}, /* ейф */
    {{0x95, 0xE0, 0xA0}, 15}, /* Хра */
    {{0xAB, 0xA0, 0xAC}, 14}, /* лам */
    {{0xA0, 0xE0, 0xE3}, 14}, /* ару */
    {{0xA3, 0xA8, 0xE5}, 14}, /* гих */
    {{0xE6, 0xA8, 0xEF}, 14}, /* ция */
    {{0xA4, 0xA0, 0xA2}, 14}, /* дав */
    {{0xAB, 0xA8, 0xE8}, 14}, /* лиш */
    {{0xEE, 0xE7, 0xA0}, 14}, /* юча */
    {{0xA0, 0xAD, 0xE1}, 14}, /* анс */
    {{0xAE, 0xA3, 0xE0}, 14}, /* огр */
    {{0xA8, 0xE9, 0xA0}, 14}, /* ища */
    {{0xA5, 0xAD, 0xEC}, 14}, /* ень */
    {{0xAE, 0xE2, 0xA8}, 14}, /* оти */
    {{0xA0, 0xA4, 0xEB}, 13}, /* ады */
    {{0xA0, 0xE9, 0xA0}, 13}, /* аща */
    {{0xA2, 0xAE, 0xA8}, 13}, /* вои */
    {{0xA2, 0xEB, 0xAC}, 13}, /* вым */
    {{0xA2, 0xEC, 0xEF}, 13}, /* вья */
    {{0xAA, 0xA8, 0xA5}, 13}, /* кие */
    {{0xAB, 0xA8, 0xE1}, 13}, /* лис */
    {{0xAC, 0xA5, 0xA4}, 13}, /* мед */
    {{0xE2, 0xA8, 0xE5}, 13}, /* тих */
    {{0xA5, 0xE2, 0xAE}, 13}, /* ето */
    {{0xA7, 0xAB, 0xAE}, 13}, /* зло */
    {{0xAE, 0xAF, 0xA5}, 13}, /* опе */
    {{0xE1, 0xA8, 0xAC}, 13}, /* сим */
    {{0xEF, 0xA7, 0xA8}, 13}, /* язи */
    {{0xA8, 0xAD, 0xA4}, 13}, /* инд */
    {{0xE7, 0xE3, 0xA6}, 13}, /* чуж */
    {{0xAB, 0xAA, 0xA8}, 13}, /* лки */
    {{0xA4, 0xAF, 0xE0}, 13}, /* дпр */
    {{0xAD, 0xA4, 0xA8}, 13}, /* нди */
    {{0xAE, 0xE2, 0xA0}, 13}, /* ота */
    {{0xAE, 0xE2, 0xEB}, 13}, /* оты */
    {{0xAB, 0xA0, 0xE7}, 13}, /* лач */
    {{0xAA, 0xA8, 0xAC}, 13}, /* ким */
    {{0xA8, 0xE1, 0xA8}, 13}, /* иси */
    {{0xA2, 0xA0, 0xAB}, 13}, /* вал */
    {{0xA5, 0xAC, 0xAE}, 13}, /* емо */
    {{0xAF, 0xE3, 0xA1}, 13}, /* пуб */
    {{0xEF, 0xA5, 0xAC}, 13}, /* яем */
    {{0xA1, 0xAE, 0xAB}, 13}, /* бол */
    {{0xAD, 0xE2, 0xE3}, 13}, /* нту */
    {{0xAD, 0xA5, 0xA9}, 13}, /* ней */
    {{0xAD, 0xA0, 0xEF}, 13}, /* ная */
    {{0xA5, 0xE1, 0xA0}, 13}, /* еса */
    {{0xE0, 0xAD, 0xAE}, 13}, /* рно */
    {{0xE9, 0xA5, 0xAC}, 13}, /* щем */
    {{0xA0, 0xAD, 0xEB}, 13}, /* аны */
    {{0x84, 0xAE, 0xA2}, 13}, /* Дов */
    {{0xE7, 0xA8, 0xA2}, 13}, /* чив */
    {{0xA2, 0xA8, 0xE1}, 13}, /* вис */
    {{0xAE, 0xAF, 0xAE}, 13}, /* опо */
    {{0xA2, 0xEC, 0xEE}, 13}, /* вью */
    {{0xA0, 0xAB, 0xA0}, 13}, /* ала */
    {{0xAB, 0xA5, 0xA9}, 12}, /* лей */
    {{0xA0, 0xE7, 0xA0}, 12}, /* ача */
    {{0xA5, 0xA7, 0xA2}, 12}, /* езв */
    {{0xA2, 0xA0, 0xEF}, 12}, /* вая */
    {{0xA5, 0xAE, 0xE1}, 12}, /* еос */
    {{0xEF, 0xE9, 0xA8}, 12}, /* ящи */
    {{0xA8, 0xA2, 0xA8}, 12}, /* иви */
    {{0xAD, 0xA5, 0xA5}, 12}, /* нее */
    {{0xE2, 0xE0, 0xE3}, 12}, /* тру */
    {{0xE8, 0xA5, 0xA5}, 12}, /* шее */
    {{0xE1, 0xA0, 0xE5}, 12}, /* сах */
    {{0xA8, 0xAD, 0xE6}, 12}, /* инц */
    {{0xAE, 0xAC, 0xAF}, 12}, /* омп */
    {{0xE3, 0xA6, 0xAE}, 12}, /* ужо */
    {{0xE3, 0xA0, 0xAB}, 12}, /* уал */
    {{0xAD, 0xA0, 0xE2}, 12}, /* нат */
    {{0xA8, 0xA4, 0xE3}, 12}, /* иду */
    {{0xA2, 0xAB, 0xA0}, 12}, /* вла */
    {{0xA7, 0xA2, 0xA0}, 12}, /* зва */
    {{0xAB, 0xA5, 0xA5}, 12}, /* лее */
    {{0xE0, 0xA5, 0xE5}, 12}, /* рех */
    {{0xA6, 0xA4, 0xE3}, 12}, /* жду */
    {{0xAC, 0xA0, 0xAB}, 12}, /* мал */
    {{0xA5, 0xAD, 0xE1}, 12}, /* енс */
    {{0xA8, 0xA9, 0xE1}, 12}, /* ийс */
    {{0xAA, 0xAE, 0xAB}, 12}, /* кол */
    {{0xAD, 0xA0, 0xA7}, 12}, /* наз */
    {{0xA4, 0xE3, 0xA0}, 12}, /* дуа */
    {{0xAE, 0xAD, 0xA8}, 12}, /* они */
    {{0xE1, 0xA5, 0xAC}, 12}, /* сем */
    {{0xA3, 0xAE, 0xA4}, 12}, /* год */
    {{0xAC, 0xA5, 0xA6}, 12}, /* меж */
    {{0xAE, 0xA7, 0xAB}, 12}, /* озл */
    {{0xA2, 0xAC, 0xA5}, 12}, /* вме */
    {{0xE3, 0xA4, 0xA5}, 12}, /* уде */
    {{0xEC, 0xAA, 0xAE}, 12}, /* ько */
    {{0xA5, 0xA2, 0xEB}, 12}, /* евы */
    {{0xA7, 0xA0, 0xAC}, 12}, /* зам */
    {{0xE1, 0xAE, 0xA4}, 12}, /* сод */
    {{0xE0, 0xAE, 0xA5}, 11}, /* рое */
    {{0xAE, 0xE2, 0xA4}, 11}, /* отд */
    {{0xE1, 0xA8, 0xEF}, 11}, /* сия */
    {{0xA8, 0xAA, 0xE3}, 11}, /* ику */
    {{0xEB, 0xAB, 0xA8}, 11}, /* ыли */
    {{0xA3, 0xA8, 0xAC}, 11}, /* гим */
    {{0xAD, 0xEC, 0xE8}, 11}, /* ньш */
    {{0xE2, 0xA8, 0xE7}, 11}, /* тич */
    {{0xE0, 0xA0, 0xAB}, 11}, /* рал */
    {{0xE3, 0xE7, 0xA8}, 11}, /* учи */
    {{0xAC, 0xA5, 0xEE}, 11}, /* мею */
    {{0xE2, 0xA5, 0xAA}, 11}, /* тек */
    {{0xAE, 0xA1, 0xE3}, 11}, /* обу */
    {{0xAD, 0xAD, 0xE3}, 11}, /* нну */
    {{0xAD, 0xA5, 0xAF}, 11}, /* неп */
    {{0xA2, 0xA5, 0xAB}, 11}, /* вел */
    {{0xE2, 0xAC, 0xA5}, 11}, /* тме */
    {{0xA1, 0xAE, 0xA3}, 11}, /* бог */
    {{0xAE, 0xE0, 0xA8}, 11}, /* ори */
    {{0xA0, 0xA2, 0xAD}, 11}, /* авн */
    {{0xA4, 0xA5, 0xA5}, 11}, /* дее */
    {{0xA6, 0xAE, 0xAC}, 11}, /* жом */
    {{0x82, 0xE0, 0xA5}, 11}, /* Вре */
    {{0xAC, 0xEB, 0xA5}, 11}, /* мые */
    {{0xEC, 0xE6, 0xA0}, 11}, /* ьца */
    {{0xAE, 0xE6, 0xA5}, 11}, /* оце */
    {{0xA8, 0xE2, 0xEB}, 10}, /* иты */
    {{0xA7, 0xE0, 0xA0}, 10}, /* зра */
    {{0xAE, 0xAD, 0xEB}, 10}, /* оны */
    {{0xE0, 0xA5, 0xE8}, 10}, /* реш */
    {{0xE3, 0xE8, 0xA5}, 10}, /* уше */
    {{0xE0, 0xA5, 0xA2}, 10}, /* рев */
    {{0xAE, 0xAF, 0xE3}, 10}, /* опу */
    {{0xEF, 0xE2, 0xEB}, 10}, /* яты */
    {{0xE2, 0xA0, 0xE7}, 10}, /* тач */
    {{0xA5, 0xE0, 0xAE}, 10}, /* еро */
    {{0xA2, 0xAA, 0xAB}, 10}, /* вкл */
    {{0xA7, 0xEB, 0xA2}, 10}, /* зыв */
    {{0xA0, 0xAF, 0xE0}, 10}, /* апр */
    {{0xE0, 0xE3, 0xE8}, 10}, /* руш */
    {{0x8E, 0xE2, 0xA2}, 10}, /* Отв */
    {{0xE0, 0xE1, 0xA0}, 10}, /* рса */
    {{0xA5, 0xAA, 0xE2}, 10}, /* ект */
    {{0xAB, 0xA5, 0xAA}, 10}, /* лек */
    {{0xA5, 0xA5, 0xE2}, 10}, /* еет */
    {{0xAE, 0xAF, 0xAB}, 10}, /* опл */
    {{0xE2, 0xE7, 0xA5}, 10}, /* тче */
    {{0xA3, 0xAE, 0xAC}, 10}, /* гом */
    {{0xE2, 0xAE, 0xA6}, 10}, /* тож */
    {{0xAB, 0xA5, 0xE7}, 10}, /* леч */
    {{0xA5, 0xE2, 0xEB}, 10}, /* еты */
    {{0xAE, 0xA6, 0xA8}, 10}, /* ожи */
    {{0xAC, 0xAD, 0xAE}, 10}, /* мно */
    {{0xAC, 0xAE, 0xA9}, 10}, /* мой */
    {{0xE6, 0xA5, 0xAB}, 10}, /* цел */
    {{0xE3, 0xAF, 0xA8}, 10}, /* упи */
    {{0xA0, 0xA5, 0xA2}, 10}, /* аев */
    {{0xAF, 0xAE, 0xAC}, 10}, /* пом */
    {{0xA4, 0xEF, 0xE9}, 10}, /* дящ */
    {{0xE2, 0xE0, 0xA8}, 10}, /* три */
    {{0xE8, 0xA8, 0xA5}, 10}, /* шие */
    {{0xA5, 0xAA, 0xA0}, 10}, /* ека */
    {{0xA5, 0xE8, 0xA5}, 10}, /* еше */
    {{0xA7, 0xA0, 0xA8}, 10}, /* заи */
    {{0xA8, 0xE2, 0xAE}, 10}, /* ито */
    {{0xA7, 0xAD, 0xEB}, 10}, /* зны */
    {{0xAE, 0xEF, 0xAD}, 10}, /* оян */
    {{0xA8, 0xA6, 0xA5}, 10}, /* иже */
    {{0xA2, 0xAD, 0xA5}, 10}, /* вне */
    {{0xE0, 0xE1, 0xE2}, 10}, /* рст */
    {{0xA5, 0xAC, 0xEF}, 10}, /* емя */
    {{0xAD, 0xA0, 0xA8}, 10}, /* наи */
    {{0xE2, 0xAE, 0xAB}, 10}, /* тол */
    {{0xAB, 0xA8, 0xE2}, 10}, /* лит */
    {{0xAE, 0xE1, 0xE0}, 10}, /* оср */
    {{0xE2, 0xA4, 0xA5}, 10}, /* тде */
    {{0xA5, 0xAC, 0xA8}, 10}, /* еми */
    {{0xAC, 0xA5, 0xA5}, 10}, /* мее */
    {{0xE0, 0xEB, 0xE5}, 10}, /* рых */
    {{0xAD, 0xA8, 0xA2}, 10}, /* нив */
    {{0xA5, 0xE0, 0xE3}, 10}, /* еру */
    {{0xE7, 0xA5, 0xAC}, 10}, /* чем */
    {{0xA4, 0xAE, 0xA1}, 10}, /* доб */
    {{0xA5, 0xAB, 0xAE}, 10}, /* ело */
    {{0xA8, 0xAB, 0xE3}, 10}, /* илу */
    {{0xA0, 0xA4, 0xAB}, 10}, /* адл */
    {{0xA8, 0xE7, 0xE2}, 10}, /* ичт */
    {{0xAC, 0xAB, 0xA5}, 10}, /* мле */
};

static const myencoding_trigram_t myencoding_detect_trigrams_index_iso_8859_5[] = {
    {{0xD5, 0xDD, 0xD8}, 991}, /* ени */
    {{0xDE, 0xD3, 0xDE}, 806}, /* ого */
    {{0xE1, 0xE2, 0xD2}, 659}, /* ств */
    {{0xDD, 0xD8, 0xEF}, 629}, /* ния */
    {{0xDE, 0xD2, 0xD0}, 566}, /* ова */
    {{0xE2, 0xD5, 0xDB}, 555}, /* тел */
    {{0xE0, 0xD5, 0xD4}, 507}, /* ред */
    {{0xD5, 0xDD, 0xDD}, 499}, /* енн */
    {{0xDE, 0xD2, 0xDE}, 443}, /* ово */
    {{0xD0, 0xDD, 0xD8}, 443}, /* ани */
    {{0xE2, 0xE0, 0xD0}, 429}, /* тра */
    {{0xDE, 0xE1, 0xE2}, 428}, /* ост */
    {{0xDD, 0xD8, 0xD5}, 419}, /* ние */
    {{0xDD, 0xDD, 0xDE}, 412}, /* нно */
    {{0xD0, 0xE5, 0xDE}, 396}, /* ахо */
    {{0xE1, 0xE2, 0xE0}, 392}, /* стр */
    {{0xE0, 0xD0, 0xE5}, 386}, /* рах */
    {{0xE5, 0xDE, 0xD2}, 379}, /* хов */
    {{0xD5, 0xDB, 0xEC}, 365}, /* ель */
    {{0xD3, 0xDE, 0xD2}, 360}, /* гов */
    {{0xD2, 0xDE, 0xE0}, 356}, /* вор */
    {{0xD5, 0xE1, 0xE2}, 349}, /* ест */
    {{0xD0, 0xE2, 0xEC}, 345}, /* ать */
    {{0xE0, 0xD0, 0xD2}, 337}, /* рав */
    {{0xDF, 0xE0, 0xD8}, 330}, /* при */
    {{0xDF, 0xE0, 0xD5}, 323}, /* пре */
    {{0xD4, 0xDE, 0xD3}, 318}, /* дог */
    {{0xDD, 0xD5, 0xDD}, 310}, /* нен */
    {{0xDF, 0xE0, 0xD0}, 309}, /* пра */
    {{0xD2, 0xD0, 0xDD}, 304}, /* ван */
    {{0xD8, 0xE2, 0xD5}, 295}, /* ите */
    {{0xE2, 0xD2, 0xD5}, 281}, /* тве */
    {{0xDB, 0xD5, 0xDD}, 266}, /* лен */
    {{0xE1, 0xE2, 0xDE}, 261}, /* сто */
    {{0xE2, 0xD0, 0xE2}, 260}, /* тат */
    {{0xDD, 0xDD, 0xEB}, 260}, /* нны */
    {{0xDB, 0xEC, 0xDD}, 256}, /* льн */
    {{0xD2, 0xDE, 0xD7}, 255}, /* воз */
    {{0xD8, 0xDB, 0xD8}, 254}, /* или */
    {{0xD0, 0xE2, 0xD5}, 252}, /* ате */
    {{0xD5, 0xD3, 0xDE}, 241}, /* его */
    {{0xD5, 0xE2, 0xE1}, 238}, /* етс */
    {{0xDD, 0xDE, 0xE1}, 236}, /* нос */
    {{0xE9, 0xD5, 0xE1}, 235}, /* щес */
    {{0xDF, 0xDE, 0xDB}, 232}, /* пол */
    {{0xE0, 0xD0, 0xDD}, 231}, /* ран */
    {{0xDD, 0xDE, 0xD3}, 230}, /* ног */
    {{0xE1, 0xE2, 0xD0}, 229}, /* ста */
    {{0xE7, 0xD5, 0xDD}, 226}, /* чен */
    {{0xE2, 0xE0, 0xD5}, 224}, /* тре */
    {{0xD7, 0xDC, 0xD5}, 214}, /* зме */
    {{0xE3, 0xE9, 0xD5}, 212}, /* уще */
    {{0xE1, 0xE2, 0xD8}, 210}, /* сти */
    {{0xDA, 0xDE, 0xDC}, 207}, /* ком */
    {{0xDE, 0xE0, 0xDE}, 206}, /* оро */
    {{0xD2, 0xDB, 0xD5}, 195}, /* вле */
    {{0xD7, 0xD0, 0xDD}, 194}, /* зан */
    {{0xD0, 0xE1, 0xE2}, 193}, /* аст */
    {{0xE2, 0xE1, 0xEF}, 191}, /* тся */
    {{0xE5, 0xE0, 0xD0}, 187}, /* хра */
    {{0xD0, 0xDD, 0xDD}, 182}, /* анн */
    {{0xD5, 0xE0, 0xD5}, 182}, /* ере */
    {{0xD2, 0xE0, 0xD5}, 178}, /* вре */
    {{0xDE, 0xD2, 0xD5}, 173}, /* ове */
    {{0xEC, 0xDD, 0xDE}, 173}, /* ьно */
    {{0xD2, 0xD5, 0xE0}, 172}, /* вер */
    {{0xDC, 0xD5, 0xDD}, 170}, /* мен */
    {{0xDB, 0xD8, 0xE6}, 168}, /* лиц */
    {{0xE2, 0xDE, 0xE0}, 167}, /* тор */
    {{0xE0, 0xD5, 0xDD}, 167}, /* рен */
    {{0xE9, 0xD5, 0xDD}, 165}, /* щен */
    {{0xDE, 0xD7, 0xDC}, 164}, /* озм */
    {{0xD5, 0xD4, 0xD0}, 163}, /* еда */
    {{0xE2, 0xD2, 0xD8}, 159}, /* тви */
    {{0xEF, 0xD7, 0xD0}, 159}, /* яза */
    {{0xD1, 0xEF, 0xD7}, 158}, /* бяз */
    {{0xDD, 0xD8, 0xD8}, 153}, /* нии */
    {{0xDD, 0xEB, 0xE5}, 153}, /* ных */
    {{0xE2, 0xEC, 0xEF}, 153}, /* тья */
    {{0xDC, 0xD5, 0xE0}, 153}, /* мер */
    {{0xE1, 0xDB, 0xD8}, 150}, /* сли */
    {{0xE2, 0xDE, 0xD2}, 148}, /* тов */
    {{0xE2, 0xD2, 0xD0}, 147}, /* тва */
    {{0xDE, 0xE0, 0xD0}, 146}, /* ора */
    {{0xDD, 0xDE, 0xDC}, 144}, /* ном */
    {{0xD4, 0xD5, 0xDD}, 144}, /* ден */
    {{0xD0, 0xDD, 0xD5}, 142}, /* ане */
    {{0xDA, 0xDE, 0xDD}, 141}, /* кон */
    {{0xDB, 0xE3, 0xE7}, 141}, /* луч */
    {{0xDC, 0xE3, 0xE9}, 140}, /* мущ */
    {{0xDE, 0xD1, 0xEF}, 140}, /* обя */
    {{0xD2, 0xD0, 0xE2}, 138}, /* ват */
    {{0xD2, 0xD0, 0xE0}, 137}, /* вар */
    {{0xD5, 0xE9, 0xD5}, 137}, /* еще */
    {{0xDE, 0xE2, 0xE0}, 137}, /* отр */
    {{0xD4, 0xD5, 0xDB}, 137}, /* дел */
    {{0xDD, 0xEB, 0xDC}, 136}, /* ным */
    {{0xD8, 0xDC, 0xE3}, 136}, /* иму */
    {{0xC1, 0xE2, 0xD0}, 134}, /* Ста */
    {{0xE3, 0xE7, 0xD0}, 133}, /* уча */
    {{0xE2, 0xE1, 0xE2}, 131}, /* тст */
    {{0xD5, 0xDB, 0xEF}, 130}, /* еля */
    {{0xE1, 0xDB, 0xE3}, 130}, /* слу */
    {{0xD7, 0xD0, 0xDA}, 130}, /* зак */
    {{0xE2, 0xDE, 0xEF}, 129}, /* тоя */
    {{0xDE, 0xDC, 0xD8}, 128}, /* оми */
    {{0xDC, 0xD5, 0xE9}, 128}, /* мещ */
    {{0xD5, 0xD4, 0xE3}, 127}, /* еду */
    {{0xD2, 0xD5, 0xDD}, 127}, /* вен */
    {{0xDD, 0xDE, 0xD2}, 127}, /* нов */
    {{0xDD, 0xDE, 0xD5}, 126}, /* ное */
    {{0xDE, 0xE2, 0xD2}, 125}, /* отв */
    {{0xDA, 0xD0, 0xD7}, 125}, /* каз */
    {{0xD0, 0xD5, 0xE2}, 125}, /* ает */
    {{0xE1, 0xDA, 0xDE}, 125}, /* ско */
    {{0xD5, 0xDD, 0xE2}, 124}, /* ент */
    {{0xDC, 0xDE, 0xE2}, 123}, /* мот */
    {{0xD0, 0xD2, 0xDB}, 122}, /* авл */
    {{0xE1, 0xDC, 0xDE}, 122}, /* смо */
    {{0xD8, 0xE7, 0xD8}, 121}, /* ичи */
    {{0xD1, 0xEB, 0xE2}, 120}, /* быт */
    {{0xE3, 0xE1, 0xDC}, 118}, /* усм */
    {{0xE1, 0xE1, 0xD8}, 117}, /* сси */
    {{0xD4, 0xE3, 0xE1}, 117}, /* дус */
    {{0xE5, 0xDE, 0xD4}, 117}, /* ход */
    {{0xE0, 0xD8, 0xE7}, 117}, /* рич */
    {{0xE7, 0xD5, 0xE1}, 115}, /* чес */
    {{0xD3, 0xE0, 0xD0}, 114}, /* гра */
    {{0xDF, 0xE0, 0xDE}, 114}, /* про */
    {{0xD4, 0xDE, 0xD2}, 113}, /* дов */
    {{0xD2, 0xD5, 0xE2}, 112}, /* вет */
    {{0xD5, 0xD4, 0xD5}, 112}, /* еде */
    {{0xE8, 0xD5, 0xDD}, 111}, /* шен */
    {{0xE7, 0xD8, 0xDD}, 110}, /* чин */
    {{0xDD, 0xD0, 0xE1}, 109}, /* нас */
    {{0xD8, 0xE2, 0xEC}, 105}, /* ить */
    {{0xE2, 0xD2, 0xDE}, 105}, /* тво */
    {{0xDA, 0xDB, 0xEE}, 104}, /* клю */
    {{0xE0, 0xD8, 0xE2}, 104}, /* рит */
    {{0xE1, 0xE2, 0xEC}, 104}, /* сть */
    {{0xDB, 0xEE, 0xE7}, 104}, /* люч */
    {{0xE2, 0xDE, 0xDC}, 104}, /* том */
    {{0xE1, 0xDB, 0xD5}, 103}, /* сле */
    {{0xE1, 0xDF, 0xDE}, 102}, /* спо */
    {{0xDE, 0xDB, 0xDD}, 102}, /* олн */
    {{0xD5, 0xE1, 0xDB}, 102}, /* есл */
    {{0xD5, 0xE0, 0xD8}, 101}, /* ери */
    {{0xDD, 0xDE, 0xD9}, 101}, /* ной */
    {{0xE0, 0xDE, 0xDC}, 101}, /* ром */
    {{0xDE, 0xE2, 0xDE}, 99}, /* ото */
    {{0xDD, 0xEB, 0xD5}, 99}, /* ные */
    {{0xD7, 0xDD, 0xD0}, 99}, /* зна */
    {{0xD2, 0xDB, 0xEF}, 99}, /* вля */
    {{0xE2, 0xD5, 0xE0}, 98}, /* тер */
    {{0xE3, 0xDF, 0xE0}, 97}, /* упр */
    {{0xD0, 0xDA, 0xDE}, 96}, /* ако */
    {{0xDA, 0xDE, 0xD3}, 96}, /* ког */
    {{0xDD, 0xEB, 0xD9}, 96}, /* ный */
    {{0xDE, 0xE0, 0xE3}, 96}, /* ору */
    {{0xD5, 0xDB, 0xD5}, 95}, /* еле */
    {{0xD5, 0xE1, 0xDA}, 95}, /* еск */
    {{0xD0, 0xD7, 0xD0}, 95}, /* аза */
    {{0xD9, 0xE1, 0xE2}, 93}, /* йст */
    {{0xDF, 0xDE, 0xE0}, 93}, /* пор */
    {{0xDE, 0xD6, 0xD5}, 92}, /* оже */
    {{0xD8, 0xDD, 0xD5}, 91}, /* ине */
    {{0xE9, 0xD5, 0xD9}, 90}, /* щей */
    {{0xD6, 0xD4, 0xD5}, 90}, /* жде */
    {{0xDF, 0xD5, 0xE0}, 89}, /* пер */
    {{0xDD, 0xD8, 0xE2}, 89}, /* нит */
    {{0xDE, 0xDB, 0xEC}, 89}, /* оль */
    {{0xD0, 0xD6, 0xD4}, 88}, /* ажд */
    {{0xD6, 0xD5, 0xDD}, 87}, /* жен */
    {{0xDB, 0xD0, 0xD4}, 87}, /* лад */
    {{0xD0, 0xDC, 0xD8}, 87}, /* ами */
    {{0xDA, 0xDE, 0xE2}, 86}, /* кот */
    {{0xE7, 0xD0, 0xD5}, 85}, /* чае */
    {{0xD2, 0xD5, 0xE9}, 85}, /* вещ */
    {{0xD2, 0xD8, 0xEF}, 85}, /* вия */
    {{0xEF, 0xE9, 0xD5}, 85}, /* яще */
    {{0xD8, 0xD5, 0xDC}, 85}, /* ием */
    {{0xDA, 0xDB, 0xD0}, 85}, /* кла */
    {{0xD5, 0xD9, 0xE1}, 84}, /* ейс */
    {{0xEB, 0xE2, 0xEC}, 84}, /* ыть */
    {{0xD0, 0xD2, 0xDE}, 84}, /* аво */
    {{0xE0, 0xD0, 0xD6}, 83}, /* раж */
    {{0xDB, 0xEC, 0xE1}, 83}, /* льс */
    {{0xDE, 0xEF, 0xE9}, 82}, /* оящ */
    {{0xD5, 0xDD, 0xDE}, 81}, /* ено */
    {{0xD4, 0xE1, 0xE2}, 81}, /* дст */
    {{0xD4, 0xD5, 0xD9}, 80}, /* дей */
    {{0xE0, 0xD5, 0xD1}, 80}, /* реб */
    {{0xEC, 0xE1, 0xE2}, 79}, /* ьст */
    {{0xD5, 0xD4, 0xE1}, 79}, /* едс */
    {{0xD0, 0xE0, 0xD8}, 79}, /* ари */
    {{0xD4, 0xD0, 0xDD}, 79}, /* дан */
    {{0xDC, 0xDE, 0xD6}, 78}, /* мож */
    {{0xD8, 0xDC, 0xD5}, 78}, /* име */
    {{0xD8, 0xDD, 0xDE}, 78}, /* ино */
    {{0xE0, 0xD8, 0xDD}, 77}, /* рин */
    {{0xD4, 0xDE, 0xE1}, 77}, /* дос */
    {{0xDF, 0xDE, 0xE1}, 77}, /* пос */
    {{0xE2, 0xD0, 0xDA}, 77}, /* так */
    {{0xE9, 0xD5, 0xD3}, 77}, /* щег */
    {{0xD4, 0xD0, 0xE2}, 77}, /* дат */
    {{0xDF, 0xDB, 0xD0}, 76}, /* пла */
    {{0xE3, 0xE1, 0xDB}, 76}, /* усл */
    {{0xD8, 0xE6, 0xD0}, 76}, /* ица */
    {{0xE0, 0xDE, 0xD2}, 75}, /* ров */
    {{0xED, 0xE2, 0xDE}, 75}, /* это */
    {{0xE3, 0xE7, 0xD5}, 74}, /* уче */
    {{0xD4, 0xDE, 0xDB}, 73}, /* дол */
    {{0xEC, 0xDD, 0xEB}, 73}, /* ьны */
    {{0xE0, 0xD0, 0xD7}, 73}, /* раз */
    {{0xDC, 0xD8, 0xE1}, 73}, /* мис */
    {{0xD0, 0xDD, 0xDE}, 72}, /* ано */
    {{0xE1, 0xE0, 0xDE}, 72}, /* сро */
    {{0xD0, 0xD2, 0xD8}, 72}, /* ави */
    {{0xE2, 0xEC, 0xD8}, 71}, /* тьи */
    {{0xEE, 0xE7, 0xD5}, 70}, /* юче */
    {{0xE1, 0xDA, 0xDB}, 70}, /* скл */
    {{0xD8, 0xE1, 0xE1}, 70}, /* исс */
    {{0xD6, 0xD5, 0xE2}, 69}, /* жет */
    {{0xD5, 0xD4, 0xDE}, 69}, /* едо */
    {{0xDB, 0xD5, 0xD4}, 69}, /* лед */
    {{0xDB, 0xDE, 0xD2}, 69}, /* лов */
    {{0xEE, 0xE9, 0xD8}, 68}, /* ющи */
    {{0xD8, 0xD1, 0xDE}, 68}, /* ибо */
    {{0xDB, 0xD0, 0xE2}, 67}, /* лат */
    {{0xE0, 0xDE, 0xDA}, 67}, /* рок */
    {{0xD0, 0xDA, 0xDB}, 67}, /* акл */
    {{0xE0, 0xD8, 0xE9}, 67}, /* рищ */
    {{0xD1, 0xDE, 0xD2}, 67}, /* бов */
    {{0xD8, 0xE1, 0xDA}, 67}, /* иск */
    {{0xD5, 0xD1, 0xDE}, 67}, /* ебо */
    {{0xDB, 0xEC, 0xD7}, 67}, /* льз */
    {{0xE3, 0xDA, 0xD0}, 67}, /* ука */
    {{0xDB, 0xD8, 0xD1}, 66}, /* либ */
    {{0xDE, 0xDC, 0xE3}, 66}, /* ому */
    {{0xDE, 0xD2, 0xDB}, 66}, /* овл */
    {{0xE2, 0xDD, 0xDE}, 65}, /* тно */
    {{0xD2, 0xDE, 0xD9}, 64}, /* вой */
    {{0xE2, 0xDE, 0xD3}, 64}, /* тог */
    {{0xE1, 0xDB, 0xDE}, 64}, /* сло */
    {{0xDE, 0xD7, 0xDD}, 64}, /* озн */
    {{0xE1, 0xDE, 0xDE}, 64}, /* соо */
    {{0xD7, 0xD0, 0xE2}, 63}, /* зат */
    {{0xD8, 0xE1, 0xDF}, 63}, /* исп */
    {{0xD0, 0xE7, 0xD5}, 63}, /* аче */
    {{0xDD, 0xD8, 0xEE}, 63}, /* нию */
    {{0xDE, 0xDD, 0xD5}, 63}, /* оне */
    {{0xDE, 0xDB, 0xD6}, 62}, /* олж */
    {{0xDE, 0xD2, 0xE9}, 61}, /* овщ */
    {{0xE0, 0xD0, 0xE1}, 61}, /* рас */
    {{0xD2, 0xD8, 0xD4}, 61}, /* вид */
    {{0xD2, 0xE9, 0xD8}, 61}, /* вщи */
    {{0xE1, 0xDD, 0xDE}, 61}, /* сно */
    {{0xD8, 0xE6, 0xDE}, 61}, /* ицо */
    {{0xD8, 0xE7, 0xD5}, 61}, /* иче */
    {{0xD0, 0xD2, 0xD5}, 61}, /* аве */
    {{0xD3, 0xDB, 0xD0}, 61}, /* гла */
    {{0xE7, 0xD5, 0xE2}, 61}, /* чет */
    {{0xE9, 0xD8, 0xDA}, 61}, /* щик */
    {{0xE0, 0xE3, 0xD3}, 60}, /* руг */
    {{0xE2, 0xD0, 0xDD}, 60}, /* тан */
    {{0xD8, 0xDC, 0xDE}, 60}, /* имо */
    {{0xD0, 0xDB, 0xEC}, 60}, /* аль */
    {{0xDE, 0xD2, 0xD8}, 60}, /* ови */
    {{0xD6, 0xD4, 0xD0}, 60}, /* жда */
    {{0xDF, 0xDE, 0xD2}, 60}, /* пов */
    {{0xD5, 0xDC, 0xE3}, 60}, /* ему */
    {{0xEF, 0xE2, 0xD5}, 60}, /* яте */
    {{0xE1, 0xD8, 0xD8}, 59}, /* сии */
    {{0xD1, 0xDE, 0xE2}, 59}, /* бот */
    {{0xD2, 0xEB, 0xDF}, 59}, /* вып */
    {{0xD0, 0xD1, 0xDE}, 59}, /* або */
    {{0xDB, 0xEF, 0xEE}, 59}, /* ляю */
    {{0xE1, 0xE3, 0xE9}, 58}, /* сущ */
    {{0xDE, 0xD4, 0xD5}, 58}, /* оде */
    {{0xD8, 0xDD, 0xD8}, 58}, /* ини */
    {{0xE0, 0xD0, 0xE2}, 58}, /* рат */
    {{0xEF, 0xD2, 0xDB}, 58}, /* явл */
    {{0xDD, 0xD0, 0xD3}, 57}, /* наг */
    {{0xD4, 0xE0, 0xE3}, 57}, /* дру */
    {{0xE0, 0xD0, 0xD1}, 57}, /* раб */
    {{0xD0, 0xD3, 0xE0}, 57}, /* агр */
    {{0xD8, 0xDE, 0xDD}, 57}, /* ион */
    {{0xDC, 0xD5, 0xE1}, 57}, /* мес */
    {{0xD0, 0xE6, 0xD8}, 56}, /* аци */
    {{0xDE, 0xE1, 0xE3}, 56}, /* осу */
    {{0xDA, 0xDE, 0xD9}, 55}, /* кой */
    {{0xE1, 0xD2, 0xDE}, 55}, /* сво */
    {{0xD7, 0xDE, 0xD2}, 55}, /* зов */
    {{0xDE, 0xDF, 0xE0}, 54}, /* опр */
    {{0xE1, 0xDE, 0xD1}, 54}, /* соб */
    {{0xD2, 0xDF, 0xE0}, 54}, /* впр */
    {{0xDB, 0xDD, 0xD5}, 54}, /* лне */
    {{0xDE, 0xDC, 0xDC}, 54}, /* омм */
    {{0xD5, 0xE0, 0xD0}, 54}, /* ера */
    {{0xE7, 0xD8, 0xE2}, 54}, /* чит */
    {{0xD5, 0xE0, 0xE7}, 54}, /* ерч */
    {{0xE0, 0xE7, 0xD5}, 54}, /* рче */
    {{0xD0, 0xE2, 0xD8}, 54}, /* ати */
    {{0xDD, 0xD8, 0xDA}, 54}, /* ник */
    {{0xDC, 0xDC, 0xD5}, 54}, /* мме */
    {{0xE3, 0xE1, 0xE2}, 53}, /* уст */
    {{0xE2, 0xD5, 0xDD}, 53}, /* тен */
    {{0xD2, 0xD5, 0xD4}, 53}, /* вед */
    {{0xE1, 0xDE, 0xD2}, 52}, /* сов */
    {{0xD0, 0xD6, 0xD5}, 52}, /* аже */
    {{0xDE, 0xDA, 0xD0}, 52}, /* ока */
    {{0xEB, 0xDC, 0xD8}, 52}, /* ыми */
    {{0xEE, 0xE2, 0xE1}, 52}, /* ютс */
    {{0xDE, 0xDE, 0xE2}, 52}, /* оот */
    {{0xDC, 0xD8, 0xE2}, 52}, /* мит */
    {{0xEF, 0xEE, 0xE9}, 51}, /* яющ */
    {{0xD2, 0xE8, 0xD5}, 51}, /* вше */
    {{0xE1, 0xD8, 0xDE}, 51}, /* сио */
    {{0xDE, 0xDD, 0xDE}, 51}, /* оно */
    {{0xD0, 0xD2, 0xD0}, 51}, /* ава */
    {{0xD0, 0xE9, 0xD5}, 51}, /* аще */
    {{0xDB, 0xEF, 0xD5}, 50}, /* ляе */
    {{0xD5, 0xDD, 0xD5}, 50}, /* ене */
    {{0xDE, 0xD4, 0xD8}, 50}, /* оди */
    {{0xDF, 0xE3, 0xDD}, 49}, /* пун */
    {{0xDB, 0xD8, 0xE7}, 49}, /* лич */
    {{0xD2, 0xDE, 0xDC}, 49}, /* вом */
    {{0xDD, 0xDA, 0xE2}, 49}, /* нкт */
    {{0xDD, 0xD5, 0xE1}, 49}, /* нес */
    {{0xD2, 0xD8, 0xDB}, 49}, /* вил */
    {{0xD5, 0xD6, 0xD4}, 49}, /* ежд */
    {{0xE0, 0xD5, 0xE1}, 49}, /* рес */
    {{0xEE, 0xE9, 0xD5}, 49}, /* юще */
    {{0xEC, 0xD7, 0xDE}, 49}, /* ьзо */
    {{0xDF, 0xDE, 0xE2}, 49}, /* пот */
    {{0xE3, 0xDD, 0xDA}, 49}, /* унк */
    {{0xE1, 0xE2, 0xD5}, 49}, /* сте */
    {{0xDA, 0xDE, 0xD2}, 49}, /* ков */
    {{0xDE, 0xE1, 0xDB}, 48}, /* осл */
    {{0xEF, 0xD5, 0xE2}, 48}, /* яет */
    {{0xB5, 0xE1, 0xDB}, 48}, /* Есл */
    {{0xBF, 0xE0, 0xD8}, 48}, /* При */
    {{0xE2, 0xD0, 0xD2}, 48}, /* тав */
    {{0xDD, 0xD5, 0xE0}, 48}, /* нер */
    {{0xE7, 0xDD, 0xDE}, 47}, /* чно */
    {{0xDF, 0xDE, 0xD4}, 47}, /* под */
    {{0xDD, 0xE2, 0xD0}, 47}, /* нта */
    {{0xD8, 0xE9, 0xD5}, 47}, /* ище */
    {{0xDE, 0xD1, 0xE9}, 47}, /* общ */
    {{0xD0, 0xD7, 0xDC}, 47}, /* азм */
    {{0xD6, 0xDD, 0xDE}, 47}, /* жно */
    {{0xD2, 0xD8, 0xD8}, 46}, /* вии */
    {{0xE0, 0xD0, 0xE9}, 46}, /* ращ */
    {{0xDE, 0xE0, 0xD5}, 46}, /* оре */
    {{0xD2, 0xE8, 0xD8}, 46}, /* вши */
    {{0xD5, 0xDA, 0xE1}, 46}, /* екс */
    {{0xD2, 0xDE, 0xD3}, 46}, /* вог */
    {{0xE7, 0xE2, 0xDE}, 46}, /* что */
    {{0xD8, 0xE7, 0xDD}, 45}, /* ичн */
    {{0xDB, 0xD5, 0xDC}, 45}, /* лем */
    {{0xDC, 0xDE, 0xD3}, 45}, /* мог */
    {{0xE2, 0xD2, 0xDB}, 45}, /* твл */
    {{0xD4, 0xDB, 0xD5}, 45}, /* дле */
    {{0xD4, 0xDB, 0xEF}, 45}, /* для */
    {{0xE0, 0xD5, 0xE2}, 45}, /* рет */
    {{0xD0, 0xE0, 0xD0}, 45}, /* ара */
    {{0xDD, 0xEF, 0xE2}, 44}, /* нят */
    {{0xD5, 0xE7, 0xD5}, 44}, /* ече */
    {{0xDE, 0xE2, 0xD5}, 44}, /* оте */
    {{0xDE, 0xE0, 0xEB}, 44}, /* оры */
    {{0xDE, 0xE1, 0xDD}, 43}, /* осн */
    {{0xDE, 0xD1, 0xDE}, 43}, /* обо */
    {{0xDE, 0xD3, 0xDB}, 43}, /* огл */
    {{0xD8, 0xDD, 0xEB}, 43}, /* ины */
    {{0xD5, 0xE1, 0xE1}, 43}, /* есс */
    {{0xDE, 0xD1, 0xE0}, 43}, /* обр */
    {{0xDA, 0xE0, 0xD0}, 43}, /* кра */
    {{0xD8, 0xEF, 0xDC}, 43}, /* иям */
    {{0xD0, 0xDB, 0xDE}, 43}, /* ало */
    {{0xE0, 0xE3, 0xE7}, 43}, /* руч */
    {{0xDE, 0xE0, 0xD3}, 43}, /* орг */
    {{0xE7, 0xD0, 0xEF}, 42}, /* чая */
    {{0xDD, 0xD8, 0xDC}, 42}, /* ним */
    {{0xD8, 0xD7, 0xDD}, 42}, /* изн */
    {{0xDF, 0xDE, 0xDA}, 42}, /* пок */
    {{0xE1, 0xE2, 0xE3}, 42}, /* сту */
    {{0xD5, 0xDB, 0xEE}, 42}, /* елю */
    {{0xE2, 0xD8, 0xE2}, 42}, /* тит */
    {{0xE6, 0xD5, 0xDD}, 42}, /* цен */
    {{0xE7, 0xD0, 0xE1}, 42}, /* час */
    {{0xD3, 0xD0, 0xDD}, 42}, /* ган */
    {{0xE0, 0xD3, 0xD0}, 42}, /* рга */
    {{0xE1, 0xE2, 0xDD}, 42}, /* стн */
    {{0xE0, 0xD5, 0xD6}, 42}, /* реж */
    {{0xE3, 0xDC, 0xDC}, 42}, /* умм */
    {{0xE2, 0xD2, 0xE3}, 41}, /* тву */
    {{0xE2, 0xE3, 0xDF}, 41}, /* туп */
    {{0xE1, 0xDA, 0xD8}, 40}, /* ски */
    {{0xD4, 0xD5, 0xDA}, 40}, /* дек */
    {{0xDB, 0xD5, 0xD6}, 40}, /* леж */
    {{0xD5, 0xE1, 0xD5}, 40}, /* есе */
    {{0xD2, 0xD8, 0xD5}, 40}, /* вие */
    {{0xE2, 0xDA, 0xD0}, 40}, /* тка */
    {{0xD5, 0xDA, 0xE0}, 40}, /* екр */
    {{0xDE, 0xD4, 0xDE}, 40}, /* одо */
    {{0xDA, 0xE1, 0xD0}, 40}, /* кса */
    {{0xE0, 0xD5, 0xDA}, 40}, /* рек */
    {{0xDD, 0xE2, 0xD5}, 40}, /* нте */
    {{0xE3, 0xD3, 0xD8}, 40}, /* уги */
    {{0xD1, 0xEB, 0xDB}, 40}, /* был */
    {{0xD8, 0xDD, 0xEF}, 40}, /* иня */
    {{0xD5, 0xE9, 0xD8}, 39}, /* ещи */
    {{0xD3, 0xD5, 0xDD}, 39}, /* ген */
    {{0xBA, 0xDE, 0xD4}, 39}, /* Код */
    {{0xD4, 0xD8, 0xE2}, 39}, /* дит */
    {{0xE1, 0xE5, 0xDE}, 39}, /* схо */
    {{0xD8, 0xDD, 0xE2}, 39}, /* инт */
    {{0xE1, 0xE3, 0xDC}, 39}, /* сум */
    {{0xE0, 0xDE, 0xDD}, 39}, /* рон */
    {{0xDE, 0xE2, 0xDA}, 39}, /* отк */
    {{0xD4, 0xDE, 0xDA}, 39}, /* док */
    {{0xD8, 0xDB, 0xD0}, 38}, /* ила */
    {{0xE6, 0xD5, 0xE1}, 38}, /* цес */
    {{0xD8, 0xDA, 0xD0}, 38}, /* ика */
    {{0xD7, 0xDD, 0xD8}, 38}, /* зни */
    {{0xDE, 0xD2, 0xEB}, 38}, /* овы */
    {{0xDB, 0xD6, 0xDD}, 38}, /* лжн */
    {{0xE3, 0xDF, 0xDB}, 38}, /* упл */
    {{0xD3, 0xD4, 0xD0}, 37}, /* гда */
    {{0xDB, 0xD0, 0xD6}, 37}, /* лаж */
    {{0xD6, 0xD5, 0xD4}, 37}, /* жед */
    {{0xD1, 0xD5, 0xD7}, 37}, /* без */
    {{0xD4, 0xD5, 0xE2}, 37}, /* дет */
    {{0xDE, 0xE0, 0xEF}, 37}, /* оря */
    {{0xE0, 0xDE, 0xE1}, 37}, /* рос */
    {{0xDE, 0xD1, 0xDB}, 37}, /* обл */
    {{0xE6, 0xD8, 0xD8}, 37}, /* ции */
    {{0xD4, 0xDE, 0xDC}, 37}, /* дом */
    {{0xDD, 0xE6, 0xD5}, 37}, /* нце */
    {{0xE8, 0xD5, 0xD3}, 37}, /* шег */
    {{0xDB, 0xDE, 0xD6}, 37}, /* лож */
    {{0xDE, 0xDD, 0xD0}, 37}, /* она */
    {{0xDE, 0xDA, 0xDB}, 37}, /* окл */
    {{0xDE, 0xD3, 0xD4}, 37}, /* огд */
    {{0xE0, 0xDE, 0xD4}, 37}, /* род */
    {{0xD5, 0xDD, 0xD0}, 37}, /* ена */
    {{0xDE, 0xDD, 0xE6}, 37}, /* онц */
    {{0xDE, 0xE2, 0xDD}, 37}, /* отн */
    {{0xE1, 0xDE, 0xD3}, 37}, /* сог */
    {{0xD5, 0xD2, 0xE8}, 37}, /* евш */
    {{0xD2, 0xD8, 0xE2}, 36}, /* вит */
    {{0xD5, 0xE0, 0xDF}, 36}, /* ерп */
    {{0xDE, 0xD4, 0xD0}, 36}, /* ода */
    {{0xD5, 0xE2, 0xD5}, 36}, /* ете */
    {{0xDD, 0xD5, 0xDE}, 36}, /* нео */
    {{0xE0, 0xDF, 0xD5}, 36}, /* рпе */
    {{0xD5, 0xE0, 0xE8}, 36}, /* ерш */
    {{0xD8, 0xDC, 0xD8}, 36}, /* ими */
    {{0xD8, 0xD2, 0xE8}, 36}, /* ивш */
    {{0xEB, 0xDF, 0xDB}, 36}, /* ыпл */
    {{0xDF, 0xD5, 0xD2}, 36}, /* пев */
    {{0xD0, 0xD4, 0xD0}, 36}, /* ада */
    {{0xDC, 0xDE, 0xE1}, 35}, /* мос */
    {{0xDE, 0xD1, 0xE1}, 35}, /* обс */
    {{0xDD, 0xD5, 0xD4}, 34}, /* нед */
    {{0xD8, 0xDA, 0xDE}, 34}, /* ико */
    {{0xE9, 0xD8, 0xDC}, 34}, /* щим */
    {{0xD4, 0xD5, 0xE0}, 34}, /* дер */
    {{0xE1, 0xDA, 0xD0}, 34}, /* ска */
    {{0xDE, 0xE0, 0xDC}, 34}, /* орм */
    {{0xE3, 0xDC, 0xD5}, 34}, /* уме */
    {{0xDE, 0xDE, 0xD1}, 34}, /* ооб */
    {{0xE0, 0xD8, 0xE1}, 34}, /* рис */
    {{0xDE, 0xD1, 0xEA}, 33}, /* объ */
    {{0xDE, 0xDB, 0xE3}, 33}, /* олу */
    {{0xEA, 0xEF, 0xD2}, 33}, /* ъяв */
    {{0xE0, 0xD5, 0xDC}, 33}, /* рем */
    {{0xE9, 0xD8, 0xE5}, 33}, /* щих */
    {{0xE3, 0xEE, 0xE9}, 33}, /* ующ */
    {{0xDA, 0xD6, 0xD5}, 33}, /* кже */
    {{0xD8, 0xD4, 0xD5}, 33}, /* иде */
    {{0xD1, 0xE1, 0xE2}, 33}, /* бст */
    {{0xD0, 0xDA, 0xD6}, 33}, /* акж */
    {{0xD2, 0xE3, 0xEE}, 33}, /* вую */
    {{0xD0, 0xE1, 0xE5}, 33}, /* асх */
    {{0xD0, 0xDD, 0xD0}, 32}, /* ана */
    {{0xDD, 0xD0, 0xD4}, 32}, /* над */
    {{0xDE, 0xD1, 0xD5}, 32}, /* обе */
    {{0xEB, 0xE2, 0xDA}, 32}, /* ытк */
    {{0xED, 0xE2, 0xD8}, 32}, /* эти */
    {{0xDE, 0xD6, 0xDD}, 32}, /* ожн */
    {{0xD0, 0xE2, 0xEB}, 31}, /* аты */
    {{0xE1, 0xD4, 0xD5}, 31}, /* сде */
    {{0xD0, 0xEE, 0xE2}, 31}, /* ают */
    {{0xEF, 0xE2, 0xEC}, 31}, /* ять */
    {{0xDE, 0xEF, 0xE2}, 31}, /* оят */
    {{0xD5, 0xE2, 0xEC}, 31}, /* еть */
    {{0xD0, 0xD3, 0xD5}, 31}, /* аге */
    {{0xE7, 0xE0, 0xD5}, 31}, /* чре */
    {{0xD5, 0xDD, 0xEB}, 31}, /* ены */
    {{0xE3, 0xD1, 0xEB}, 31}, /* убы */
    {{0xD8, 0xE1, 0xE2}, 30}, /* ист */
    {{0xEF, 0xEE, 0xE2}, 30}, /* яют */
    {{0xE0, 0xEF, 0xD4}, 30}, /* ряд */
    {{0xD3, 0xDE, 0xE1}, 30}, /* гос */
    {{0xD8, 0xDC, 0xD0}, 30}, /* има */
    {{0xD7, 0xD0, 0xE1}, 30}, /* зас */
    {{0xD0, 0xEE, 0xE9}, 30}, /* ающ */
    {{0xDE, 0xD7, 0xD2}, 30}, /* озв */
    {{0xD5, 0xD4, 0xD8}, 30}, /* еди */
    {{0xDE, 0xDC, 0xD5}, 30}, /* оме */
    {{0xDD, 0xD8, 0xD9}, 30}, /* ний */
    {{0xE1, 0xE3, 0xD4}, 30}, /* суд */
    {{0xD7, 0xD4, 0xDE}, 29}, /* здо */
    {{0xE1, 0xD2, 0xD8}, 29}, /* сви */
    {{0xDE, 0xDB, 0xD8}, 29}, /* оли */
    {{0xDE, 0xD2, 0xEC}, 29}, /* овь */
    {{0xD2, 0xD8, 0xD9}, 29}, /* вий */
    {{0xD4, 0xDE, 0xE0}, 29}, /* дор */
    {{0xD4, 0xD5, 0xEF}, 29}, /* дея */
    {{0xD5, 0xEF, 0xE2}, 29}, /* еят */
    {{0xE6, 0xDE, 0xDC}, 29}, /* цом */
    {{0xD8, 0xD7, 0xD0}, 28}, /* иза */
    {{0xE1, 0xE7, 0xD5}, 28}, /* сче */
    {{0xDA, 0xE2, 0xD0}, 28}, /* кта */
    {{0xDE, 0xD4, 0xDD}, 28}, /* одн */
    {{0xD1, 0xDB, 0xD0}, 28}, /* бла */
    {{0xDE, 0xD4, 0xDB}, 28}, /* одл */
    {{0xD8, 0xE2, 0xD0}, 28}, /* ита */
    {{0xB4, 0xDE, 0xD3}, 28}, /* Дог */
    {{0xDE, 0xE1, 0xDE}, 28}, /* осо */
    {{0xDD, 0xDE, 0xE8}, 28}, /* нош */
    {{0xDA, 0xE3, 0xE0}, 28}, /* кур */
    {{0xD8, 0xDD, 0xD0}, 28}, /* ина */
    {{0xDE, 0xE8, 0xD5}, 28}, /* оше */
    {{0xDD, 0xD0, 0xDB}, 28}, /* нал */
    {{0xDD, 0xD8, 0xD7}, 27}, /* низ */
    {{0xD7, 0xD2, 0xE0}, 27}, /* звр */
    {{0xD2, 0xE0, 0xD0}, 27}, /* вра */
    {{0xDB, 0xD5, 0xE2}, 27}, /* лет */
    {{0xD5, 0xE9, 0xEC}, 27}, /* ещь */
    {{0xE0, 0xD8, 0xD4}, 27}, /* рид */
    {{0xD4, 0xDD, 0xDE}, 27}, /* дно */
    {{0xE0, 0xD8, 0xDE}, 27}, /* рио */
    {{0xDE, 0xD8, 0xDC}, 27}, /* оим */
    {{0xD5, 0xE0, 0xD6}, 27}, /* ерж */
    {{0xE3, 0xD2, 0xD5}, 26}, /* уве */
    {{0xDE, 0xDD, 0xDA}, 26}, /* онк */
    {{0xD5, 0xDB, 0xDA}, 26}, /* елк */
    {{0xDB, 0xD0, 0xD2}, 26}, /* лав */
    {{0xD0, 0xE2, 0xDE}, 26}, /* ато */
    {{0xEF, 0xDC, 0xD8}, 26}, /* ями */
    {{0xDC, 0xDC, 0xEB}, 26}, /* ммы */
    {{0xD5, 0xE1, 0xDF}, 26}, /* есп */
    {{0xDD, 0xDA, 0xE3}, 26}, /* нку */
    {{0xD8, 0xE6, 0xE3}, 25}, /* ицу */
    {{0xD4, 0xE1, 0xDA}, 25}, /* дск */
    {{0xDD, 0xD8, 0xDD}, 25}, /* нин */
    {{0xDF, 0xDB, 0xD5}, 25}, /* пле */
    {{0xE4, 0xDE, 0xE0}, 25}, /* фор */
    {{0xDB, 0xD0, 0xE1}, 25}, /* лас */
    {{0xD4, 0xD8, 0xDC}, 25}, /* дим */
    {{0xD5, 0xE1, 0xEF}, 25}, /* еся */
    {{0xDD, 0xD8, 0xE7}, 25}, /* нич */
    {{0xDE, 0xD2, 0xE0}, 25}, /* овр */
    {{0xD2, 0xE1, 0xDB}, 25}, /* всл */
    {{0xE0, 0xE8, 0xD5}, 25}, /* рше */
    {{0xD5, 0xE9, 0xD0}, 25}, /* еща */
    {{0xD6, 0xDD, 0xEB}, 25}, /* жны */
    {{0xE0, 0xD8, 0xDC}, 25}, /* рим */
    {{0xD7, 0xD0, 0xE6}, 25}, /* зац */
    {{0xD1, 0xE9, 0xD5}, 25}, /* бще */
    {{0xD0, 0xDA, 0xE2}, 25}, /* акт */
    {{0xD0, 0xD4, 0xE1}, 25}, /* адс */
    {{0xE3, 0xE7, 0xE0}, 25}, /* учр */
    {{0xE9, 0xD8, 0xD5}, 25}, /* щие */
    {{0xD6, 0xD8, 0xE2}, 24}, /* жит */
    {{0xD1, 0xE0, 0xD5}, 24}, /* бре */
    {{0xE3, 0xD3, 0xDE}, 24}, /* уго */
    {{0xD8, 0xEF, 0xE5}, 24}, /* иях */
    {{0xE2, 0xEC, 0xEE}, 24}, /* тью */
    {{0xEC, 0xE1, 0xEF}, 24}, /* ься */
    {{0xD2, 0xDE, 0xD2}, 24}, /* вов */
    {{0xDE, 0xE7, 0xDD}, 24}, /* очн */
    {{0xD2, 0xDE, 0xDE}, 24}, /* воо */
    {{0xDE, 0xD4, 0xEB}, 24}, /* оды */
    {{0xDB, 0xDE, 0xD3}, 24}, /* лог */
    {{0xD2, 0xD0, 0xD5}, 24}, /* вае */
    {{0xD0, 0xEF, 0xE5}, 24}, /* аях */
    {{0xE2, 0xEC, 0xE1}, 24}, /* тьс */
    {{0xD4, 0xD8, 0xE7}, 24}, /* дич */
    {{0xDA, 0xD8, 0xE5}, 24}, /* ких */
    {{0xE6, 0xD0, 0xDC}, 24}, /* цам */
    {{0xD8, 0xD7, 0xD2}, 24}, /* изв */
    {{0xE2, 0xD8, 0xD2}, 24}, /* тив */
    {{0xD5, 0xDE, 0xD1}, 24}, /* еоб */
    {{0xE1, 0xDE, 0xE1}, 24}, /* сос */
    {{0xE8, 0xD8, 0xDC}, 24}, /* шим */
    {{0xEB, 0xDF, 0xDE}, 24}, /* ыпо */
    {{0xD5, 0xD6, 0xD0}, 24}, /* ежа */
    {{0xE2, 0xDE, 0xD8}, 24}, /* тои */
    {{0xDA, 0xE2, 0xDE}, 24}, /* кто */
    {{0xD5, 0xE7, 0xD0}, 24}, /* еча */
    {{0xD8, 0xD4, 0xD8}, 24}, /* иди */
    {{0xD1, 0xE9, 0xD8}, 23}, /* бщи */
    {{0xE2, 0xEC, 0xD5}, 23}, /* тье */
    {{0xD1, 0xEA, 0xEF}, 23}, /* бъя */
    {{0xDD, 0xD0, 0xE7}, 23}, /* нач */
    {{0xE2, 0xD5, 0xE7}, 23}, /* теч */
    {{0xE3, 0xE0, 0xE1}, 23}, /* урс */
    {{0xD2, 0xD5, 0xE7}, 23}, /* веч */
    {{0xD5, 0xDC, 0xD5}, 23}, /* еме */
    {{0xDE, 0xD1, 0xE5}, 23}, /* обх */
    {{0xD1, 0xE5, 0xDE}, 23}, /* бхо */
    {{0xD4, 0xD0, 0xD5}, 23}, /* дае */
    {{0xE0, 0xD5, 0xD7}, 23}, /* рез */
    {{0xDA, 0xD0, 0xD6}, 22}, /* каж */
    {{0xDE, 0xDA, 0xE3}, 22}, /* оку */
    {{0xD0, 0xDC, 0xD5}, 22}, /* аме */
    {{0xDD, 0xD5, 0xD7}, 22}, /* нез */
    {{0xEB, 0xD2, 0xD0}, 22}, /* ыва */
    {{0xE1, 0xD2, 0xEF}, 22}, /* свя */
    {{0xE0, 0xD0, 0xD4}, 22}, /* рад */
    {{0xD5, 0xD7, 0xD0}, 22}, /* еза */
    {{0xD8, 0xD2, 0xD0}, 22}, /* ива */
    {{0xDA, 0xD0, 0xDC}, 22}, /* кам */
    {{0xDD, 0xD5, 0xDC}, 22}, /* нем */
    {{0xE2, 0xDA, 0xDE}, 22}, /* тко */
    {{0xD7, 0xD2, 0xD5}, 22}, /* зве */
    {{0xD2, 0xEF, 0xD7}, 22}, /* вяз */
    {{0xEF, 0xE2, 0xD8}, 22}, /* яти */
    {{0xDE, 0xE5, 0xE0}, 22}, /* охр */
    {{0xE0, 0xDE, 0xE2}, 22}, /* рот */
    {{0xDE, 0xDB, 0xD5}, 22}, /* оле */
    {{0xD1, 0xE0, 0xD0}, 22}, /* бра */
    {{0xD0, 0xD5, 0xDC}, 22}, /* аем */
    {{0xDB, 0xD0, 0xE8}, 21}, /* лаш */
    {{0xD8, 0xD7, 0xDC}, 21}, /* изм */
    {{0xD3, 0xE3, 0xE2}, 21}, /* гут */
    {{0xDE, 0xD6, 0xD4}, 21}, /* ожд */
    {{0xDA, 0xD0, 0xDA}, 21}, /* как */
    {{0xDA, 0xD0, 0xE7}, 21}, /* кач */
    {{0xDD, 0xD0, 0xDC}, 21}, /* нам */
    {{0xD4, 0xDE, 0xE5}, 21}, /* дох */
    {{0xDE, 0xE5, 0xDE}, 21}, /* охо */
    {{0xEE, 0xE0, 0xD8}, 21}, /* юри */
    {{0xD2, 0xD0, 0xDC}, 21}, /* вам */
    {{0xD7, 0xDC, 0xDE}, 21}, /* змо */
    {{0xD4, 0xDA, 0xD5}, 21}, /* дке */
    {{0xD1, 0xD0, 0xDD}, 21}, /* бан */
    {{0xD5, 0xDB, 0xD8}, 21}, /* ели */
    {{0xE0, 0xD8, 0xD7}, 21}, /* риз */
    {{0xDB, 0xDD, 0xDE}, 21}, /* лно */
    {{0xD2, 0xEB, 0xE8}, 21}, /* выш */
    {{0xD4, 0xE6, 0xD0}, 21}, /* дца */
    {{0xEF, 0xD4, 0xDA}, 21}, /* ядк */
    {{0xDE, 0xE2, 0xE1}, 21}, /* отс */
    {{0xE2, 0xD5, 0xD9}, 21}, /* тей */
    {{0xD0, 0xDD, 0xDA}, 21}, /* анк */
    {{0xDD, 0xD5, 0xD3}, 21}, /* нег */
    {{0xE6, 0xD0, 0xE2}, 21}, /* цат */
    {{0xD5, 0xDC, 0xEB}, 21}, /* емы */
    {{0xD2, 0xDE, 0xD5}, 21}, /* вое */
    {{0xD4, 0xD0, 0xE7}, 21}, /* дач */
    {{0xDE, 0xD3, 0xE3}, 21}, /* огу */
    {{0xDB, 0xD6, 0xD5}, 21}, /* лже */
    {{0xE2, 0xDD, 0xD8}, 21}, /* тни */
    {{0xD7, 0xD0, 0xD2}, 21}, /* зав */
    {{0xD2, 0xD5, 0xE1}, 21}, /* вес */
    {{0xE1, 0xD0, 0xDC}, 20}, /* сам */
    {{0xD0, 0xE0, 0xDD}, 20}, /* арн */
    {{0xE7, 0xDD, 0xEB}, 20}, /* чны */
    {{0xE1, 0xE0, 0xD5}, 20}, /* сре */
    {{0xE2, 0xD8, 0xEF}, 20}, /* тия */
    {{0xD8, 0xE1, 0xDB}, 20}, /* исл */
    {{0xC1, 0xE2, 0xE0}, 20}, /* Стр */
    {{0xDD, 0xE2, 0xDE}, 20}, /* нто */
    {{0xE3, 0xE2, 0xE0}, 20}, /* утр */
    {{0xD0, 0xE8, 0xD5}, 20}, /* аше */
    {{0xD5, 0xDB, 0xD0}, 20}, /* ела */
    {{0xE3, 0xD4, 0xDE}, 20}, /* удо */
    {{0xD6, 0xD8, 0xD7}, 19}, /* жиз */
    {{0xDF, 0xD8, 0xE1}, 19}, /* пис */
    {{0xD0, 0xD8, 0xDC}, 19}, /* аим */
    {{0xE7, 0xD8, 0xE1}, 19}, /* чис */
    {{0xD5, 0xD6, 0xD8}, 19}, /* ежи */
    {{0xD2, 0xE1, 0xD5}, 19}, /* все */
    {{0xDB, 0xEC, 0xDA}, 19}, /* льк */
    {{0xD0, 0xE2, 0xE3}, 19}, /* ату */
    {{0xE3, 0xD4, 0xD0}, 19}, /* уда */
    {{0xE8, 0xD8, 0xD9}, 19}, /* ший */
    {{0xD7, 0xD0, 0xE0}, 19}, /* зар */
    {{0xD5, 0xD4, 0xDD}, 19}, /* едн */
    {{0xD0, 0xD2, 0xE8}, 19}, /* авш */
    {{0xE0, 0xDE, 0xD8}, 19}, /* рои */
    {{0xD8, 0xD4, 0xD0}, 19}, /* ида */
    {{0xD0, 0xE0, 0xDE}, 19}, /* аро */
    {{0xE2, 0xDE, 0xD9}, 19}, /* той */
    {{0xD6, 0xD0, 0xE9}, 19}, /* жащ */
    {{0xD5, 0xE1, 0xDE}, 19}, /* есо */
    {{0xDF, 0xD0, 0xDB}, 19}, /* пал */
    {{0xE9, 0xD0, 0xD5}, 19}, /* щае */
    {{0xE0, 0xEB, 0xD5}, 19}, /* рые */
    {{0xD5, 0xDD, 0xEF}, 19}, /* еня */
    {{0xE9, 0xD8, 0xD9}, 19}, /* щий */
    {{0xDB, 0xE3, 0xD3}, 19}, /* луг */
    {{0xEE, 0xE7, 0xD8}, 18}, /* ючи */
    {{0xE3, 0xDB, 0xEC}, 18}, /* уль */
    {{0xDC, 0xEB, 0xE5}, 18}, /* мых */
    {{0xE0, 0xDE, 0xD3}, 18}, /* рог */
    {{0xE1, 0xDE, 0xE5}, 18}, /* сох */
    {{0xDA, 0xDE, 0xD5}, 18}, /* кое */
    {{0xDD, 0xE2, 0xE1}, 18}, /* нтс */
    {{0xD0, 0xD7, 0xDD}, 18}, /* азн */
    {{0xE2, 0xDD, 0xEB}, 18}, /* тны */
    {{0xDE, 0xD4, 0xEF}, 18}, /* одя */
    {{0xDE, 0xD1, 0xDD}, 18}, /* обн */
    {{0xD2, 0xEB, 0xD4}, 18}, /* выд */
    {{0xDE, 0xE1, 0xEF}, 18}, /* ося */
    {{0xEC, 0xE2, 0xD0}, 18}, /* ьта */
    {{0xDD, 0xEF, 0xEE}, 18}, /* няю */
    {{0xDD, 0xD0, 0xE0}, 18}, /* нар */
    {{0xD5, 0xD7, 0xE3}, 18}, /* езу */
    {{0xD0, 0xE1, 0xDD}, 18}, /* асн */
    {{0xD7, 0xE3, 0xDB}, 18}, /* зул */
    {{0xE6, 0xD8, 0xDF}, 18}, /* цип */
    {{0xDA, 0xE2, 0xD5}, 18}, /* кте */
    {{0xD4, 0xDE, 0xDF}, 18}, /* доп */
    {{0xDD, 0xE6, 0xD8}, 18}, /* нци */
    {{0xE1, 0xDF, 0xD5}, 18}, /* спе */
    {{0xD8, 0xDC, 0xEB}, 18}, /* имы */
    {{0xDC, 0xDE, 0xDC}, 18}, /* мом */
    {{0xDF, 0xD5, 0xE7}, 18}, /* печ */
    {{0xBE, 0xD1, 0xEF}, 18}, /* Обя */
    {{0xBF, 0xE0, 0xD0}, 18}, /* Пра */
    {{0xDE, 0xDB, 0xDE}, 18}, /* оло */
    {{0xE2, 0xE1, 0xDA}, 18}, /* тск */
    {{0xDB, 0xDD, 0xD8}, 18}, /* лни */
    {{0xD5, 0xE0, 0xE2}, 18}, /* ерт */
    {{0xD8, 0xE1, 0xEC}, 18}, /* ись */
    {{0xDB, 0xEC, 0xE2}, 18}, /* льт */
    {{0xE1, 0xE3, 0xE2}, 18}, /* сут */
    {{0xD2, 0xDE, 0xD1}, 17}, /* воб */
    {{0xE0, 0xDD, 0xEB}, 17}, /* рны */
    {{0xD1, 0xDD, 0xEB}, 17}, /* бны */
    {{0xEB, 0xD4, 0xD0}, 17}, /* ыда */
    {{0xEC, 0xD7, 0xE3}, 17}, /* ьзу */
    {{0xD5, 0xD4, 0xDF}, 17}, /* едп */
    {{0xD0, 0xD4, 0xD5}, 17}, /* аде */
    {{0xD8, 0xDF, 0xD0}, 17}, /* ипа */
    {{0xE1, 0xD5, 0xD9}, 17}, /* сей */
    {{0xD5, 0xD5, 0xE1}, 17}, /* еес */
    {{0xDE, 0xD8, 0xD7}, 17}, /* оиз */
    {{0xDE, 0xE1, 0xD2}, 17}, /* осв */
    {{0xD4, 0xD8, 0xD2}, 17}, /* див */
    {{0xDD, 0xD0, 0xDD}, 17}, /* нан */
    {{0xD5, 0xE2, 0xD0}, 17}, /* ета */
    {{0xD4, 0xDD, 0xD5}, 17}, /* дне */
    {{0xD8, 0xDE, 0xD1}, 17}, /* иоб */
    {{0xE3, 0xD5, 0xE2}, 17}, /* ует */
    {{0xDD, 0xD0, 0xE5}, 17}, /* нах */
    {{0xE1, 0xDC, 0xD5}, 17}, /* сме */
    {{0xD0, 0xDB, 0xD8}, 17}, /* али */
    {{0xD1, 0xEA, 0xD5}, 17}, /* бъе */
    {{0xDF, 0xD0, 0xE1}, 17}, /* пас */
    {{0xD7, 0xD0, 0xDB}, 17}, /* зал */
    {{0xE0, 0xD6, 0xD0}, 16}, /* ржа */
    {{0xEF, 0xD2, 0xD8}, 16}, /* яви */
    {{0xD6, 0xD0, 0xE2}, 16}, /* жат */
    {{0xD1, 0xDE, 0xD6}, 16}, /* бож */
    {{0xE1, 0xD8, 0xDB}, 16}, /* сил */
    {{0xDD, 0xE3, 0xEE}, 16}, /* ную */
    {{0xDF, 0xD5, 0xDD}, 16}, /* пен */
    {{0xDC, 0xD0, 0xE2}, 16}, /* мат */
    {{0xDE, 0xDD, 0xDD}, 16}, /* онн */
    {{0xD2, 0xD8, 0xDD}, 16}, /* вин */
    {{0xE2, 0xDA, 0xD8}, 16}, /* тки */
    {{0xE2, 0xDE, 0xE7}, 16}, /* точ */
    {{0xE1, 0xE7, 0xD8}, 16}, /* счи */
    {{0xDD, 0xD8, 0xE6}, 16}, /* ниц */
    {{0xE9, 0xD5, 0xD5}, 16}, /* щее */
    {{0xD1, 0xD5, 0xE1}, 16}, /* бес */
    {{0xD0, 0xD4, 0xE6}, 16}, /* адц */
    {{0xBA, 0xDE, 0xDC}, 16}, /* Ком */
    {{0xEC, 0xD8, 0xDC}, 16}, /* ьим */
    {{0xE3, 0xE2, 0xE1}, 16}, /* утс */
    {{0xD0, 0xE7, 0xD8}, 16}, /* ачи */
    {{0xDF, 0xDE, 0xDD}, 16}, /* пон */
    {{0xDA, 0xD0, 0xD5}, 16}, /* кае */
    {{0xD8, 0xD3, 0xE0}, 16}, /* игр */
    {{0xD0, 0xDA, 0xD8}, 16}, /* аки */
    {{0xD0, 0xE9, 0xD8}, 16}, /* ащи */
    {{0xDB, 0xEC, 0xE6}, 16}, /* льц */
    {{0xD2, 0xDD, 0xDE}, 16}, /* вно */
    {{0xEB, 0xE8, 0xD5}, 15}, /* ыше */
    {{0xBB, 0xD8, 0xE6}, 15}, /* Лиц */
    {{0xEC, 0xD5, 0xD9}, 15}, /* ьей */
    {{0xE8, 0xD5, 0xDC}, 15}, /* шем */
    {{0xE3, 0xD1, 0xDB}, 15}, /* убл */
    {{0xE0, 0xD0, 0xE6}, 15}, /* рац */
    {{0xDA, 0xE3, 0xDC}, 15}, /* кум */
    {{0xE0, 0xD5, 0xD3}, 15}, /* рег */
    {{0xDE, 0xDF, 0xD0}, 15}, /* опа */
    {{0xB2, 0xDE, 0xD7}, 15}, /* Воз */
    {{0xE2, 0xD0, 0xD5}, 15}, /* тае */
    {{0xDE, 0xD1, 0xEB}, 15}, /* обы */
    {{0xD1, 0xDB, 0xD8}, 15}, /* бли */
    {{0xE0, 0xDC, 0xD5}, 15}, /* рме */
    {{0xD2, 0xDE, 0xE1}, 15}, /* вос */
    {{0xD0, 0xE1, 0xD8}, 15}, /* аси */
    {{0xE2, 0xD0, 0xDC}, 15}, /* там */
    {{0xEC, 0xDC, 0xD5}, 15}, /* ьме */
    {{0xDE, 0xD3, 0xD0}, 15}, /* ога */
    {{0xD8, 0xDB, 0xDE}, 15}, /* ило */
    {{0xE1, 0xEC, 0xDC}, 15}, /* сьм */
    {{0xE0, 0xE2, 0xD8}, 15}, /* рти */
    {{0xE2, 0xE1, 0xE3}, 15}, /* тсу */
    {{0xE1, 0xD5, 0xDD}, 15}, /* сен */
    {{0xE2, 0xD0, 0xDB}, 15}, /* тал */
    {{0xD4, 0xD0, 0xE0}, 15}, /* дар */
    {{0xD0, 0xDC, 0xDE}, 15}, /* амо */
    {{0xD5, 0xD4, 0xDB}, 15}, /* едл */
    {{0xE1, 0xE3, 0xD1}, 15}, /* суб */
    {{0xD5, 0xD9, 0xE4}, 15}, /* ейф */
    {{0xC5, 0xE0, 0xD0}, 15}, /* Хра */
    {{0xDB, 0xD0, 0xDC}, 14}, /* лам */
    {{0xD0, 0xE0, 0xE3}, 14}, /* ару */
    {{0xD3, 0xD8, 0xE5}, 14}, /* гих */
    {{0xE6, 0xD8, 0xEF}, 14}, /* ция */
    {{0xD4, 0xD0, 0xD2}, 14}, /* дав */
    {{0xDB, 0xD8, 0xE8}, 14}, /* лиш */
    {{0xEE, 0xE7, 0xD0}, 14}, /* юча */
    {{0xD0, 0xDD, 0xE1}, 14}, /* анс */
    {{0xDE, 0xD3, 0xE0}, 14}, /* огр */
    {{0xD8, 0xE9, 0xD0}, 14}, /* ища */
    {{0xD5, 0xDD, 0xEC}, 14}, /* ень */
    {{0xDE, 0xE2, 0xD8}, 14}, /* оти */
    {{0xD0, 0xD4, 0xEB}, 13}, /* ады */
    {{0xD0, 0xE9, 0xD0}, 13}, /* аща */
    {{0xD2, 0xDE, 0xD8}, 13}, /* вои */
    {{0xD2, 0xEB, 0xDC}, 13}, /* вым */
    {{0xD2, 0xEC, 0xEF}, 13}, /* вья */
    {{0xDA, 0xD8, 0xD5}, 13}, /* кие */
    {{0xDB, 0xD8, 0xE1}, 13}, /* лис */
    {{0xDC, 0xD5, 0xD4}, 13}, /* мед */
    {{0xE2, 0xD8, 0xE5}, 13}, /* тих */
    {{0xD5, 0xE2, 0xDE}, 13}, /* ето */
    {{0xD7, 0xDB, 0xDE}, 13}, /* зло */
    {{0xDE, 0xDF, 0xD5}, 13}, /* опе */
    {{0xE1, 0xD8, 0xDC}, 13}, /* сим */
    {{0xEF, 0xD7, 0xD8}, 13}, /* язи */
    {{0xD8, 0xDD, 0xD4}, 13}, /* инд */
    {{0xE7, 0xE3, 0xD6}, 13}, /* чуж */
    {{0xDB, 0xDA, 0xD8}, 13}, /* лки */
    {{0xD4, 0xDF, 0xE0}, 13}, /* дпр */
    {{0xDD, 0xD4, 0xD8}, 13}, /* нди */
    {{0xDE, 0xE2, 0xD0}, 13}, /* ота */
    {{0xDE, 0xE2, 0xEB}, 13}, /* оты */
    {{0xDB, 0xD0, 0xE7}, 13}, /* лач */
    {{0xDA, 0xD8, 0xDC}, 13}, /* ким */
    {{0xD8, 0xE1, 0xD8}, 13}, /* иси */
    {{0xD2, 0xD0, 0xDB}, 13}, /* вал */
    {{0xD5, 0xDC, 0xDE}, 13}, /* емо */
    {{0xDF, 0xE3, 0xD1}, 13}, /* пуб */
    {{0xEF, 0xD5, 0xDC}, 13}, /* яем */
    {{0xD1, 0xDE, 0xDB}, 13}, /* бол */
    {{0xDD, 0xE2, 0xE3}, 13}, /* нту */
    {{0xDD, 0xD5, 0xD9}, 13}, /* ней */
    {{0xDD, 0xD0, 0xEF}, 13}, /* ная */
    {{0xD5, 0xE1, 0xD0}, 13}, /* еса */
    {{0xE0, 0xDD, 0xDE}, 13}, /* рно */
    {{0xE9, 0xD5, 0xDC}, 13}, /* щем */
    {{0xD0, 0xDD, 0xEB}, 13}, /* аны */
    {{0xB4, 0xDE, 0xD2}, 13}, /* Дов */
    {{0xE7, 0xD8, 0xD2}, 13}, /* чив */
    {{0xD2, 0xD8, 0xE1}, 13}, /* вис */
    {{0xDE, 0xDF, 0xDE}, 13}, /* опо */
    {{0xD2, 0xEC, 0xEE}, 13}, /* вью */
    {{0xD0, 0xDB, 0xD0}, 13}, /* ала */
    {{0xDB, 0xD5, 0xD9}, 12}, /* лей */
    {{0xD0, 0xE7, 0xD0}, 12}, /* ача */
    {{0xD5, 0xD7, 0xD2}, 12}, /* езв */
    {{0xD2, 0xD0, 0xEF}, 12}, /* вая */
    {{0xD5, 0xDE, 0xE1}, 12}, /* еос */
    {{0xEF, 0xE9, 0xD8}, 12}, /* ящи */
    {{0xD8, 0xD2, 0xD8}, 12}, /* иви */
    {{0xDD, 0xD5, 0xD5}, 12}, /* нее */
    {{0xE2, 0xE0, 0xE3}, 12}, /* тру */
    {{0xE8, 0xD5, 0xD5}, 12}, /* шее */
    {{0xE1, 0xD0, 0xE5}, 12}, /* сах */
    {{0xD8, 0xDD, 0xE6}, 12}, /* инц */
    {{0xDE, 0xDC, 0xDF}, 12}, /* омп */
    {{0xE3, 0xD6, 0xDE}, 12}, /* ужо */
    {{0xE3, 0xD0, 0xDB}, 12}, /* уал */
    {{0xDD, 0xD0, 0xE2}, 12}, /* нат */
    {{0xD8, 0xD4, 0xE3}, 12}, /* иду */
    {{0xD2, 0xDB, 0xD0}, 12}, /* вла */
    {{0xD7, 0xD2, 0xD0}, 12}, /* зва */
    {{0xDB, 0xD5, 0xD5}, 12}, /* лее */
    {{0xE0, 0xD5, 0xE5}, 12}, /* рех */
    {{0xD6, 0xD4, 0xE3}, 12}, /* жду */
    {{0xDC, 0xD0, 0xDB}, 12}, /* мал */
    {{0xD5, 0xDD, 0xE1}, 12}, /* енс */
    {{0xD8, 0xD9, 0xE1}, 12}, /* ийс */
    {{0xDA, 0xDE, 0xDB}, 12}, /* кол */
    {{0xDD, 0xD0, 0xD7}, 12}, /* наз */
    {{0xD4, 0xE3, 0xD0}, 12}, /* дуа */
    {{0xDE, 0xDD, 0xD8}, 12}, /* они */
    {{0xE1, 0xD5, 0xDC}, 12}, /* сем */
    {{0xD3, 0xDE, 0xD4}, 12}, /* год */
    {{0xDC, 0xD5, 0xD6}, 12}, /* меж */
    {{0xDE, 0xD7, 0xDB}, 12}, /* озл */
    {{0xD2, 0xDC, 0xD5}, 12}, /* вме */
    {{0xE3, 0xD4, 0xD5}, 12}, /* уде */
    {{0xEC, 0xDA, 0xDE}, 12}, /* ько */
    {{0xD5, 0xD2, 0xEB}, 12}, /* евы */
    {{0xD7, 0xD0, 0xDC}, 12}, /* зам */
    {{0xE1, 0xDE, 0xD4}, 12}, /* сод */
    {{0xE0, 0xDE, 0xD5}, 11}, /* рое */
    {{0xDE, 0xE2, 0xD4}, 11}, /* отд */
    {{0xE1, 0xD8, 0xEF}, 11}, /* сия */
    {{0xD8, 0xDA, 0xE3}, 11}, /* ику */
    {{0xEB, 0xDB, 0xD8}, 11}, /* ыли */
    {{0xD3, 0xD8, 0xDC}, 11}, /* гим */
    {{0xDD, 0xEC, 0xE8}, 11}, /* ньш */
    {{0xE2, 0xD8, 0xE7}, 11}, /* тич */
    {{0xE0, 0xD0, 0xDB}, 11}, /* рал */
    {{0xE3, 0xE7, 0xD8}, 11}, /* учи */
    {{0xDC, 0xD5, 0xEE}, 11}, /* мею */
    {{0xE2, 0xD5, 0xDA}, 11}, /* тек */
    {{0xDE, 0xD1, 0xE3}, 11}, /* обу */
    {{0xDD, 0xDD, 0xE3}, 11}, /* нну */
    {{0xDD, 0xD5, 0xDF}, 11}, /* неп */
    {{0xD2, 0xD5, 0xDB}, 11}, /* вел */
    {{0xE2, 0xDC, 0xD5}, 11}, /* тме */
    {{0xD1, 0xDE, 0xD3}, 11}, /* бог */
    {{0xDE, 0xE0, 0xD8}, 11}, /* ори */
    {{0xD0, 0xD2, 0xDD}, 11}, /* авн */
    {{0xD4, 0xD5, 0xD5}, 11}, /* дее */
    {{0xD6, 0xDE, 0xDC}, 11}, /* жом */
    {{0xB2, 0xE0, 0xD5}, 11}, /* Вре */
    {{0xDC, 0xEB, 0xD5}, 11}, /* мые */
    {{0xEC, 0xE6, 0xD0}, 11}, /* ьца */
    {{0xDE, 0xE6, 0xD5}, 11}, /* оце */
    {{0xD8, 0xE2, 0xEB}, 10}, /* иты */
    {{0xD7, 0xE0, 0xD0}, 10}, /* зра */
    {{0xDE, 0xDD, 0xEB}, 10}, /* оны */
    {{0xE0, 0xD5, 0xE8}, 10}, /* реш */
    {{0xE3, 0xE8, 0xD5}, 10}, /* уше */
    {{0xE0, 0xD5, 0xD2}, 10}, /* рев */
    {{0xDE, 0xDF, 0xE3}, 10}, /* опу */
    {{0xEF, 0xE2, 0xEB}, 10}, /* яты */
    {{0xE2, 0xD0, 0xE7}, 10}, /* тач */
    {{0xD5, 0xE0, 0xDE}, 10}, /* еро */
    {{0xD2, 0xDA, 0xDB}, 10}, /* вкл */
    {{0xD7, 0xEB, 0xD2}, 10}, /* зыв */
    {{0xD0, 0xDF, 0xE0}, 10}, /* апр */
    {{0xE0, 0xE3, 0xE8}, 10}, /* руш */
    {{0xBE, 0xE2, 0xD2}, 10}, /* Отв */
    {{0xE0, 0xE1, 0xD0}, 10}, /* рса */
    {{0xD5, 0xDA, 0xE2}, 10}, /* ект */
    {{0xDB, 0xD5, 0xDA}, 10}, /* лек */
    {{0xD5, 0xD5, 0xE2}, 10}, /* еет */
    {{0xDE, 0xDF, 0xDB}, 10}, /* опл */
    {{0xE2, 0xE7, 0xD5}, 10}, /* тче */
    {{0xD3, 0xDE, 0xDC}, 10}, /* гом */
    {{0xE2, 0xDE, 0xD6}, 10}, /* тож */
    {{0xDB, 0xD5, 0xE7}, 10}, /* леч */
    {{0xD5, 0xE2, 0xEB}, 10}, /* еты */
    {{0xDE, 0xD6, 0xD8}, 10}, /* ожи */
    {{0xDC, 0xDD, 0xDE}, 10}, /* мно */
    {{0xDC, 0xDE, 0xD9}, 10}, /* мой */
    {{0xE6, 0xD5, 0xDB}, 10}, /* цел */
    {{0xE3, 0xDF, 0xD8}, 10}, /* упи */
    {{0xD0, 0xD5, 0xD2}, 10}, /* аев */
    {{0xDF, 0xDE, 0xDC}, 10}, /* пом */
    {{0xD4, 0xEF, 0xE9}, 10}, /* дящ */
    {{0xE2, 0xE0, 0xD8}, 10}, /* три */
    {{0xE8, 0xD8, 0xD5}, 10}, /* шие */
    {{0xD5, 0xDA, 0xD0}, 10}, /* ека */
    {{0xD5, 0xE8, 0xD5}, 10}, /* еше */
    {{0xD7, 0xD0, 0xD8}, 10}, /* заи */
    {{0xD8, 0xE2, 0xDE}, 10}, /* ито */
    {{0xD7, 0xDD, 0xEB}, 10}, /* зны */
    {{0xDE, 0xEF, 0xDD}, 10}, /* оян */
    {{0xD8, 0xD6, 0xD5}, 10}, /* иже */
    {{0xD2, 0xDD, 0xD5}, 10}, /* вне */
    {{0xE0, 0xE1, 0xE2}, 10}, /* рст */
    {{0xD5, 0xDC, 0xEF}, 10}, /* емя */
    {{0xDD, 0xD0, 0xD8}, 10}, /* наи */
    {{0xE2, 0xDE, 0xDB}, 10}, /* тол */
    {{0xDB, 0xD8, 0xE2}, 10}, /* лит */
    {{0xDE, 0xE1, 0xE0}, 10}, /* оср */
    {{0xE2, 0xD4, 0xD5}, 10}, /* тде */
    {{0xD5, 0xDC, 0xD8}, 10}, /* еми */
    {{0xDC, 0xD5, 0xD5}, 10}, /* мее */
    {{0xE0, 0xEB, 0xE5}, 10}, /* рых */
    {{0xDD, 0xD8, 0xD2}, 10}, /* нив */
    {{0xD5, 0xE0, 0xE3}, 10}, /* еру */
    {{0xE7, 0xD5, 0xDC}, 10}, /* чем */
    {{0xD4, 0xDE, 0xD1}, 10}, /* доб */
    {{0xD5, 0xDB, 0xDE}, 10}, /* ело */
    {{0xD8, 0xDB, 0xE3}, 10}, /* илу */
    {{0xD0, 0xD4, 0xDB}, 10}, /* адл */
    {{0xD8, 0xE7, 0xE2}, 10}, /* ичт */
    {{0xDC, 0xDB, 0xD5}, 10}, /* мле */
};

static const myencoding_trigram_t myencoding_detect_trigrams_index_koi8_r[] = {
    {{0xC5, 0xCE, 0xC9}, 991}, /* ени */
    {{0xCF, 0xC7, 0xCF}, 806}, /* ого */
    {{0xD3, 0xD4, 0xD7}, 659}, /* ств */
    {{0xCE, 0xC9, 0xD1}, 629}, /* ния */
    {{0xCF, 0xD7, 0xC1}, 566}, /* ова */
    {{0xD4, 0xC5, 0xCC}, 555}, /* тел */
    {{0xD2, 0xC5, 0xC4}, 507}, /* ред */
    {{0xC5, 0xCE, 0xCE}, 499}, /* енн */
    {{0xCF, 0xD7, 0xCF}, 443}, /* ово */
    {{0xC1, 0xCE, 0xC9}, 443}, /* ани */
    {{0xD4, 0xD2, 0xC1}, 429}, /* тра */
    {{0xCF, 0xD3, 0xD4}, 428}, /* ост */
    {{0xCE, 0xC9, 0xC5}, 419}, /* ние */
    {{0xCE, 0xCE, 0xCF}, 412}, /* нно */
    {{0xC1, 0xC8, 0xCF}, 396}, /* ахо */
    {{0xD3, 0xD4, 0xD2}, 392}, /* стр */
    {{0xD2, 0xC1, 0xC8}, 386}, /* рах */
    {{0xC8, 0xCF, 0xD7}, 379}, /* хов */
    {{0xC5, 0xCC, 0xD8}, 365}, /* ель */
    {{0xC7, 0xCF, 0xD7}, 360}, /* гов */
    {{0xD7, 0xCF, 0xD2}, 356}, /* вор */
    {{0xC5, 0xD3, 0xD4}, 349}, /* ест */
    {{0xC1, 0xD4, 0xD8}, 345}, /* ать */
    {{0xD2, 0xC1, 0xD7}, 337}, /* рав */
    {{0xD0, 0xD2, 0xC9}, 330}, /* при */
    {{0xD0, 0xD2, 0xC5}, 323}, /* пре */
    {{0xC4, 0xCF, 0xC7}, 318}, /* дог */
    {{0xCE, 0xC5, 0xCE}, 310}, /* нен */
    {{0xD0, 0xD2, 0xC1}, 309}, /* пра */
    {{0xD7, 0xC1, 0xCE}, 304}, /* ван */
    {{0xC9, 0xD4, 0xC5}, 295}, /* ите */
    {{0xD4, 0xD7, 0xC5}, 281}, /* тве */
    {{0xCC, 0xC5, 0xCE}, 266}, /* лен */
    {{0xD3, 0xD4, 0xCF}, 261}, /* сто */
    {{0xD4, 0xC1, 0xD4}, 260}, /* тат */
    {{0xCE, 0xCE, 0xD9}, 260}, /* нны */
    {{0xCC, 0xD8, 0xCE}, 256}, /* льн */
    {{0xD7, 0xCF, 0xDA}, 255}, /* воз */
    {{0xC9, 0xCC, 0xC9}, 254}, /* или */
    {{0xC1, 0xD4, 0xC5}, 252}, /* ате */
    {{0xC5, 0xC7, 0xCF}, 241}, /* его */
    {{0xC5, 0xD4, 0xD3}, 238}, /* етс */
    {{0xCE, 0xCF, 0xD3}, 236}, /* нос */
    {{0xDD, 0xC5, 0xD3}, 235}, /* щес */
    {{0xD0, 0xCF, 0xCC}, 232}, /* пол */
    {{0xD2, 0xC1, 0xCE}, 231}, /* ран */
    {{0xCE, 0xCF, 0xC7}, 230}, /* ног */
    {{0xD3, 0xD4, 0xC1}, 229}, /* ста */
    {{0xDE, 0xC5, 0xCE}, 226}, /* чен */
    {{0xD4, 0xD2, 0xC5}, 224}, /* тре */
    {{0xDA, 0xCD, 0xC5}, 214}, /* зме */
    {{0xD5, 0xDD, 0xC5}, 212}, /* уще */
    {{0xD3, 0xD4, 0xC9}, 210}, /* сти */
    {{0xCB, 0xCF, 0xCD}, 207}, /* ком */
    {{0xCF, 0xD2, 0xCF}, 206}, /* оро */
    {{0xD7, 0xCC, 0xC5}, 195}, /* вле */
    {{0xDA, 0xC1, 0xCE}, 194}, /* зан */
    {{0xC1, 0xD3, 0xD4}, 193}, /* аст */
    {{0xD4, 0xD3, 0xD1}, 191}, /* тся */
    {{0xC8, 0xD2, 0xC1}, 187}, /* хра */
    {{0xC1, 0xCE, 0xCE}, 182}, /* анн */
    {{0xC5, 0xD2, 0xC5}, 182}, /* ере */
    {{0xD7, 0xD2, 0xC5}, 178}, /* вре */
    {{0xCF, 0xD7, 0xC5}, 173}, /* ове */
    {{0xD8, 0xCE, 0xCF}, 173}, /* ьно */
    {{0xD7, 0xC5, 0xD2}, 172}, /* вер */
    {{0xCD, 0xC5, 0xCE}, 170}, /* мен */
    {{0xCC, 0xC9, 0xC3}, 168}, /* лиц */
    {{0xD4, 0xCF, 0xD2}, 167}, /* тор */
    {{0xD2, 0xC5, 0xCE}, 167}, /* рен */
    {{0xDD, 0xC5, 0xCE}, 165}, /* щен */
    {{0xCF, 0xDA, 0xCD}, 164}, /* озм */
    {{0xC5, 0xC4, 0xC1}, 163}, /* еда */
    {{0xD4, 0xD7, 0xC9}, 159}, /* тви */
    {{0xD1, 0xDA, 0xC1}, 159}, /* яза */
    {{0xC2, 0xD1, 0xDA}, 158}, /* бяз */
    {{0xCE, 0xC9, 0xC9}, 153}, /* нии */
    {{0xCE, 0xD9, 0xC8}, 153}, /* ных */
    {{0xD4, 0xD8, 0xD1}, 153}, /* тья */
    {{0xCD, 0xC5, 0xD2}, 153}, /* мер */
    {{0xD3, 0xCC, 0xC9}, 150}, /* сли */
    {{0xD4, 0xCF, 0xD7}, 148}, /* тов */
    {{0xD4, 0xD7, 0xC1}, 147}, /* тва */
    {{0xCF, 0xD2, 0xC1}, 146}, /* ора */
    {{0xCE, 0xCF, 0xCD}, 144}, /* ном */
    {{0xC4, 0xC5, 0xCE}, 144}, /* ден */
    {{0xC1, 0xCE, 0xC5}, 142}, /* ане */
    {{0xCB, 0xCF, 0xCE}, 141}, /* кон */
    {{0xCC, 0xD5, 0xDE}, 141}, /* луч */
    {{0xCD, 0xD5, 0xDD}, 140}, /* мущ */
    {{0xCF, 0xC2, 0xD1}, 140}, /* обя */
    {{0xD7, 0xC1, 0xD4}, 138}, /* ват */
    {{0xD7, 0xC1, 0xD2}, 137}, /* вар */
    {{0xC5, 0xDD, 0xC5}, 137}, /* еще */
    {{0xCF, 0xD4, 0xD2}, 137}, /* отр */
    {{0xC4, 0xC5, 0xCC}, 137}, /* дел */
    {{0xCE, 0xD9, 0xCD}, 136}, /* ным */
    {{0xC9, 0xCD, 0xD5}, 136}, /* иму */
    {{0xF3, 0xD4, 0xC1}, 134}, /* Ста */
    {{0xD5, 0xDE, 0xC1}, 133}, /* уча */
    {{0xD4, 0xD3, 0xD4}, 131}, /* тст */
    {{0xC5, 0xCC, 0xD1}, 130}, /* еля */
    {{0xD3, 0xCC, 0xD5}, 130}, /* слу */
    {{0xDA, 0xC1, 0xCB}, 130}, /* зак */
    {{0xD4, 0xCF, 0xD1}, 129}, /* тоя */
    {{0xCF, 0xCD, 0xC9}, 128}, /* оми */
    {{0xCD, 0xC5, 0xDD}, 128}, /* мещ */
    {{0xC5, 0xC4, 0xD5}, 127}, /* еду */
    {{0xD7, 0xC5, 0xCE}, 127}, /* вен */
    {{0xCE, 0xCF, 0xD7}, 127}, /* нов */
    {{0xCE, 0xCF, 0xC5}, 126}, /* ное */
    {{0xCF, 0xD4, 0xD7}, 125}, /* отв */
    {{0xCB, 0xC1, 0xDA}, 125}, /* каз */
    {{0xC1, 0xC5, 0xD4}, 125}, /* ает */
    {{0xD3, 0xCB, 0xCF}, 125}, /* ско */
    {{0xC5, 0xCE, 0xD4}, 124}, /* ент */
    {{0xCD, 0xCF, 0xD4}, 123}, /* мот */
    {{0xC1, 0xD7, 0xCC}, 122}, /* авл */
    {{0xD3, 0xCD, 0xCF}, 122}, /* смо */
    {{0xC9, 0xDE, 0xC9}, 121}, /* ичи */
    {{0xC2, 0xD9, 0xD4}, 120}, /* быт */
    {{0xD5, 0xD3, 0xCD}, 118}, /* усм */
    {{0xD3, 0xD3, 0xC9}, 117}, /* сси */
    {{0xC4, 0xD5, 0xD3}, 117}, /* дус */
    {{0xC8, 0xCF, 0xC4}, 117}, /* ход */
    {{0xD2, 0xC9, 0xDE}, 117}, /* рич */
    {{0xDE, 0xC5, 0xD3}, 115}, /* чес */
    {{0xC7, 0xD2, 0xC1}, 114}, /* гра */
    {{0xD0, 0xD2, 0xCF}, 114}, /* про */
    {{0xC4, 0xCF, 0xD7}, 113}, /* дов */
    {{0xD7, 0xC5, 0xD4}, 112}, /* вет */
    {{0xC5, 0xC4, 0xC5}, 112}, /* еде */
    {{0xDB, 0xC5, 0xCE}, 111}, /* шен */
    {{0xDE, 0xC9, 0xCE}, 110}, /* чин */
    {{0xCE, 0xC1, 0xD3}, 109}, /* нас */
    {{0xC9, 0xD4, 0xD8}, 105}, /* ить */
    {{0xD4, 0xD7, 0xCF}, 105}, /* тво */
    {{0xCB, 0xCC, 0xC0}, 104}, /* клю */
    {{0xD2, 0xC9, 0xD4}, 104}, /* рит */
    {{0xD3, 0xD4, 0xD8}, 104}, /* сть */
    {{0xCC, 0xC0, 0xDE}, 104}, /* люч */
    {{0xD4, 0xCF, 0xCD}, 104}, /* том */
    {{0xD3, 0xCC, 0xC5}, 103}, /* сле */
    {{0xD3, 0xD0, 0xCF}, 102}, /* спо */
    {{0xCF, 0xCC, 0xCE}, 102}, /* олн */
    {{0xC5, 0xD3, 0xCC}, 102}, /* есл */
    {{0xC5, 0xD2, 0xC9}, 101}, /* ери */
    {{0xCE, 0xCF, 0xCA}, 101}, /* ной */
    {{0xD2, 0xCF, 0xCD}, 101}, /* ром */
    {{0xCF, 0xD4, 0xCF}, 99}, /* ото */
    {{0xCE, 0xD9, 0xC5}, 99}, /* ные */
    {{0xDA, 0xCE, 0xC1}, 99}, /* зна */
    {{0xD7, 0xCC, 0xD1}, 99}, /* вля */
    {{0xD4, 0xC5, 0xD2}, 98}, /* тер */
    {{0xD5, 0xD0, 0xD2}, 97}, /* упр */
    {{0xC1, 0xCB, 0xCF}, 96}, /* ако */
    {{0xCB, 0xCF, 0xC7}, 96}, /* ког */
    {{0xCE, 0xD9, 0xCA}, 96}, /* ный */
    {{0xCF, 0xD2, 0xD5}, 96}, /* ору */
    {{0xC5, 0xCC, 0xC5}, 95}, /* еле */
    {{0xC5, 0xD3, 0xCB}, 95}, /* еск */
    {{0xC1, 0xDA, 0xC1}, 95}, /* аза */
    {{0xCA, 0xD3, 0xD4}, 93}, /* йст */
    {{0xD0, 0xCF, 0xD2}, 93}, /* пор */
    {{0xCF, 0xD6, 0xC5}, 92}, /* оже */
    {{0xC9, 0xCE, 0xC5}, 91}, /* ине */
    {{0xDD, 0xC5, 0xCA}, 90}, /* щей */
    {{0xD6, 0xC4, 0xC5}, 90}, /* жде */
    {{0xD0, 0xC5, 0xD2}, 89}, /* пер */
    {{0xCE, 0xC9, 0xD4}, 89}, /* нит */
    {{0xCF, 0xCC, 0xD8}, 89}, /* оль */
    {{0xC1, 0xD6, 0xC4}, 88}, /* ажд */
    {{0xD6, 0xC5, 0xCE}, 87}, /* жен */
    {{0xCC, 0xC1, 0xC4}, 87}, /* лад */
    {{0xC1, 0xCD, 0xC9}, 87}, /* ами */
    {{0xCB, 0xCF, 0xD4}, 86}, /* кот */
    {{0xDE, 0xC1, 0xC5}, 85}, /* чае */
    {{0xD7, 0xC5, 0xDD}, 85}, /* вещ */
    {{0xD7, 0xC9, 0xD1}, 85}, /* вия */
    {{0xD1, 0xDD, 0xC5}, 85}, /* яще */
    {{0xC9, 0xC5, 0xCD}, 85}, /* ием */
    {{0xCB, 0xCC, 0xC1}, 85}, /* кла */
    {{0xC5, 0xCA, 0xD3}, 84}, /* ейс */
    {{0xD9, 0xD4, 0xD8}, 84}, /* ыть */
    {{0xC1, 0xD7, 0xCF}, 84}, /* аво */
    {{0xD2, 0xC1, 0xD6}, 83}, /* раж */
    {{0xCC, 0xD8, 0xD3}, 83}, /* льс */
    {{0xCF, 0xD1, 0xDD}, 82}, /* оящ */
    {{0xC5, 0xCE, 0xCF}, 81}, /* ено */
    {{0xC4, 0xD3, 0xD4}, 81}, /* дст */
    {{0xC4, 0xC5, 0xCA}, 80}, /* дей */
    {{0xD2, 0xC5, 0xC2}, 80}, /* реб */
    {{0xD8, 0xD3, 0xD4}, 79}, /* ьст */
    {{0xC5, 0xC4, 0xD3}, 79}, /* едс */
    {{0xC1, 0xD2, 0xC9}, 79}, /* ари */
    {{0xC4, 0xC1, 0xCE}, 79}, /* дан */
    {{0xCD, 0xCF, 0xD6}, 78}, /* мож */
    {{0xC9, 0xCD, 0xC5}, 78}, /* име */
    {{0xC9, 0xCE, 0xCF}, 78}, /* ино */
    {{0xD2, 0xC9, 0xCE}, 77}, /* рин */
    {{0xC4, 0xCF, 0xD3}, 77}, /* дос */
    {{0xD0, 0xCF, 0xD3}, 77}, /* пос */
    {{0xD4, 0xC1, 0xCB}, 77}, /* так */
    {{0xDD, 0xC5, 0xC7}, 77}, /* щег */
    {{0xC4, 0xC1, 0xD4}, 77}, /* дат */
    {{0xD0, 0xCC, 0xC1}, 76}, /* пла */
    {{0xD5, 0xD3, 0xCC}, 76}, /* усл */
    {{0xC9, 0xC3, 0xC1}, 76}, /* ица */
    {{0xD2, 0xCF, 0xD7}, 75}, /* ров */
    {{0xDC, 0xD4, 0xCF}, 75}, /* это */
    {{0xD5, 0xDE, 0xC5}, 74}, /* уче */
    {{0xC4, 0xCF, 0xCC}, 73}, /* дол */
    {{0xD8, 0xCE, 0xD9}, 73}, /* ьны */
    {{0xD2, 0xC1, 0xDA}, 73}, /* раз */
    {{0xCD, 0xC9, 0xD3}, 73}, /* мис */
    {{0xC1, 0xCE, 0xCF}, 72}, /* ано */
    {{0xD3, 0xD2, 0xCF}, 72}, /* сро */
    {{0xC1, 0xD7, 0xC9}, 72}, /* ави */
    {{0xD4, 0xD8, 0xC9}, 71}, /* тьи */
    {{0xC0, 0xDE, 0xC5}, 70}, /* юче */
    {{0xD3, 0xCB, 0xCC}, 70}, /* скл */
    {{0xC9, 0xD3, 0xD3}, 70}, /* исс */
    {{0xD6, 0xC5, 0xD4}, 69}, /* жет */
    {{0xC5, 0xC4, 0xCF}, 69}, /* едо */
    {{0xCC, 0xC5, 0xC4}, 69}, /* лед */
    {{0xCC, 0xCF, 0xD7}, 69}, /* лов */
    {{0xC0, 0xDD, 0xC9}, 68}, /* ющи */
    {{0xC9, 0xC2, 0xCF}, 68}, /* ибо */
    {{0xCC, 0xC1, 0xD4}, 67}, /* лат */
    {{0xD2, 0xCF, 0xCB}, 67}, /* рок */
    {{0xC1, 0xCB, 0xCC}, 67}, /* акл */
    {{0xD2, 0xC9, 0xDD}, 67}, /* рищ */
    {{0xC2, 0xCF, 0xD7}, 67}, /* бов */
    {{0xC9, 0xD3, 0xCB}, 67}, /* иск */
    {{0xC5, 0xC2, 0xCF}, 67}, /* ебо */
    {{0xCC, 0xD8, 0xDA}, 67}, /* льз */
    {{0xD5, 0xCB, 0xC1}, 67}, /* ука */
    {{0xCC, 0xC9, 0xC2}, 66}, /* либ */
    {{0xCF, 0xCD, 0xD5}, 66}, /* ому */
    {{0xCF, 0xD7, 0xCC}, 66}, /* овл */
    {{0xD4, 0xCE, 0xCF}, 65}, /* тно */
    {{0xD7, 0xCF, 0xCA}, 64}, /* вой */
    {{0xD4, 0xCF, 0xC7}, 64}, /* тог */
    {{0xD3, 0xCC, 0xCF}, 64}, /* сло */
    {{0xCF, 0xDA, 0xCE}, 64}, /* озн */
    {{0xD3, 0xCF, 0xCF}, 64}, /* соо */
    {{0xDA, 0xC1, 0xD4}, 63}, /* зат */
    {{0xC9, 0xD3, 0xD0}, 63}, /* исп */
    {{0xC1, 0xDE, 0xC5}, 63}, /* аче */
    {{0xCE, 0xC9, 0xC0}, 63}, /* нию */
    {{0xCF, 0xCE, 0xC5}, 63}, /* оне */
    {{0xCF, 0xCC, 0xD6}, 62}, /* олж */
    {{0xCF, 0xD7, 0xDD}, 61}, /* овщ */
    {{0xD2, 0xC1, 0xD3}, 61}, /* рас */
    {{0xD7, 0xC9, 0xC4}, 61}, /* вид */
    {{0xD7, 0xDD, 0xC9}, 61}, /* вщи */
    {{0xD3, 0xCE, 0xCF}, 61}, /* сно */
    {{0xC9, 0xC3, 0xCF}, 61}, /* ицо */
    {{0xC9, 0xDE, 0xC5}, 61}, /* иче */
    {{0xC1, 0xD7, 0xC5}, 61}, /* аве */
    {{0xC7, 0xCC, 0xC1}, 61}, /* гла */
    {{0xDE, 0xC5, 0xD4}, 61}, /* чет */
    {{0xDD, 0xC9, 0xCB}, 61}, /* щик */
    {{0xD2, 0xD5, 0xC7}, 60}, /* руг */
    {{0xD4, 0xC1, 0xCE}, 60}, /* тан */
    {{0xC9, 0xCD, 0xCF}, 60}, /* имо */
    {{0xC1, 0xCC, 0xD8}, 60}, /* аль */
    {{0xCF, 0xD7, 0xC9}, 60}, /* ови */
    {{0xD6, 0xC4, 0xC1}, 60}, /* жда */
    {{0xD0, 0xCF, 0xD7}, 60}, /* пов */
    {{0xC5, 0xCD, 0xD5}, 60}, /* ему */
    {{0xD1, 0xD4, 0xC5}, 60}, /* яте */
    {{0xD3, 0xC9, 0xC9}, 59}, /* сии */
    {{0xC2, 0xCF, 0xD4}, 59}, /* бот */
    {{0xD7, 0xD9, 0xD0}, 59}, /* вып */
    {{0xC1, 0xC2, 0xCF}, 59}, /* або */
    {{0xCC, 0xD1, 0xC0}, 59}, /* ляю */
    {{0xD3, 0xD5, 0xDD}, 58}, /* сущ */
    {{0xCF, 0xC4, 0xC5}, 58}, /* оде */
    {{0xC9, 0xCE, 0xC9}, 58}, /* ини */
    {{0xD2, 0xC1, 0xD4}, 58}, /* рат */
    {{0xD1, 0xD7, 0xCC}, 58}, /* явл */
    {{0xCE, 0xC1, 0xC7}, 57}, /* наг */
    {{0xC4, 0xD2, 0xD5}, 57}, /* дру */
    {{0xD2, 0xC1, 0xC2}, 57}, /* раб */
    {{0xC1, 0xC7, 0xD2}, 57}, /* агр */
    {{0xC9, 0xCF, 0xCE}, 57}, /* ион */
    {{0xCD, 0xC5, 0xD3}, 57}, /* мес */
    {{0xC1, 0xC3, 0xC9}, 56}, /* аци */
    {{0xCF, 0xD3, 0xD5}, 56}, /* осу */
    {{0xCB, 0xCF, 0xCA}, 55}, /* кой */
    {{0xD3, 0xD7, 0xCF}, 55}, /* сво */
    {{0xDA, 0xCF, 0xD7}, 55}, /* зов */
    {{0xCF, 0xD0, 0xD2}, 54}, /* опр */
    {{0xD3, 0xCF, 0xC2}, 54}, /* соб */
    {{0xD7, 0xD0, 0xD2}, 54}, /* впр */
    {{0xCC, 0xCE, 0xC5}, 54}, /* лне */
    {{0xCF, 0xCD, 0xCD}, 54}, /* омм */
    {{0xC5, 0xD2, 0xC1}, 54}, /* ера */
    {{0xDE, 0xC9, 0xD4}, 54}, /* чит */
    {{0xC5, 0xD2, 0xDE}, 54}, /* ерч */
    {{0xD2, 0xDE, 0xC5}, 54}, /* рче */
    {{0xC1, 0xD4, 0xC9}, 54}, /* ати */
    {{0xCE, 0xC9, 0xCB}, 54}, /* ник */
    {{0xCD, 0xCD, 0xC5}, 54}, /* мме */
    {{0xD5, 0xD3, 0xD4}, 53}, /* уст */
    {{0xD4, 0xC5, 0xCE}, 53}, /* тен */
    {{0xD7, 0xC5, 0xC4}, 53}, /* вед */
    {{0xD3, 0xCF, 0xD7}, 52}, /* сов */
    {{0xC1, 0xD6, 0xC5}, 52}, /* аже */
    {{0xCF, 0xCB, 0xC1}, 52}, /* ока */
    {{0xD9, 0xCD, 0xC9}, 52}, /* ыми */
    {{0xC0, 0xD4, 0xD3}, 52}, /* ютс */
    {{0xCF, 0xCF, 0xD4}, 52}, /* оот */
    {{0xCD, 0xC9, 0xD4}, 52}, /* мит */
    {{0xD1, 0xC0, 0xDD}, 51}, /* яющ */
    {{0xD7, 0xDB, 0xC5}, 51}, /* вше */
    {{0xD3, 0xC9, 0xCF}, 51}, /* сио */
    {{0xCF, 0xCE, 0xCF}, 51}, /* оно */
    {{0xC1, 0xD7, 0xC1}, 51}, /* ава */
    {{0xC1, 0xDD, 0xC5}, 51}, /* аще */
    {{0xCC, 0xD1, 0xC5}, 50}, /* ляе */
    {{0xC5, 0xCE, 0xC5}, 50}, /* ене */
    {{0xCF, 0xC4, 0xC9}, 50}, /* оди */
    {{0xD0, 0xD5, 0xCE}, 49}, /* пун */
    {{0xCC, 0xC9, 0xDE}, 49}, /* лич */
    {{0xD7, 0xCF, 0xCD}, 49}, /* вом */
    {{0xCE, 0xCB, 0xD4}, 49}, /* нкт */
    {{0xCE, 0xC5, 0xD3}, 49}, /* нес */
    {{0xD7, 0xC9, 0xCC}, 49}, /* вил */
    {{0xC5, 0xD6, 0xC4}, 49}, /* ежд */
    {{0xD2, 0xC5, 0xD3}, 49}, /* рес */
    {{0xC0, 0xDD, 0xC5}, 49}, /* юще */
    {{0xD8, 0xDA, 0xCF}, 49}, /* ьзо */
    {{0xD0, 0xCF, 0xD4}, 49}, /* пот */
    {{0xD5, 0xCE, 0xCB}, 49}, /* унк */
    {{0xD3, 0xD4, 0xC5}, 49}, /* сте */
    {{0xCB, 0xCF, 0xD7}, 49}, /* ков */
    {{0xCF, 0xD3, 0xCC}, 48}, /* осл */
    {{0xD1, 0xC5, 0xD4}, 48}, /* яет */
    {{0xE5, 0xD3, 0xCC}, 48}, /* Есл */
    {{0xF0, 0xD2, 0xC9}, 48}, /* При */
    {{0xD4, 0xC1, 0xD7}, 48}, /* тав */
    {{0xCE, 0xC5, 0xD2}, 48}, /* нер */
    {{0xDE, 0xCE, 0xCF}, 47}, /* чно */
    {{0xD0, 0xCF, 0xC4}, 47}, /* под */
    {{0xCE, 0xD4, 0xC1}, 47}, /* нта */
    {{0xC9, 0xDD, 0xC5}, 47}, /* ище */
    {{0xCF, 0xC2, 0xDD}, 47}, /* общ */
    {{0xC1, 0xDA, 0xCD}, 47}, /* азм */
    {{0xD6, 0xCE, 0xCF}, 47}, /* жно */
    {{0xD7, 0xC9, 0xC9}, 46}, /* вии */
    {{0xD2, 0xC1, 0xDD}, 46}, /* ращ */
    {{0xCF, 0xD2, 0xC5}, 46}, /* оре */
    {{0xD7, 0xDB, 0xC9}, 46}, /* вши */
    {{0xC5, 0xCB, 0xD3}, 46}, /* екс */
    {{0xD7, 0xCF, 0xC7}, 46}, /* вог */
    {{0xDE, 0xD4, 0xCF}, 46}, /* что */
    {{0xC9, 0xDE, 0xCE}, 45}, /* ичн */
    {{0xCC, 0xC5, 0xCD}, 45}, /* лем */
    {{0xCD, 0xCF, 0xC7}, 45}, /* мог */
    {{0xD4, 0xD7, 0xCC}, 45}, /* твл */
    {{0xC4, 0xCC, 0xC5}, 45}, /* дле */
    {{0xC4, 0xCC, 0xD1}, 45}, /* для */
    {{0xD2, 0xC5, 0xD4}, 45}, /* рет */
    {{0xC1, 0xD2, 0xC1}, 45}, /* ара */
    {{0xCE, 0xD1, 0xD4}, 44}, /* нят */
    {{0xC5, 0xDE, 0xC5}, 44}, /* ече */
    {{0xCF, 0xD4, 0xC5}, 44}, /* оте */
    {{0xCF, 0xD2, 0xD9}, 44}, /* оры */
    {{0xCF, 0xD3, 0xCE}, 43}, /* осн */
    {{0xCF, 0xC2, 0xCF}, 43}, /* обо */
    {{0xCF, 0xC7, 0xCC}, 43}, /* огл */
    {{0xC9, 0xCE, 0xD9}, 43}, /* ины */
    {{0xC5, 0xD3, 0xD3}, 43}, /* есс */
    {{0xCF, 0xC2, 0xD2}, 43}, /* обр */
    {{0xCB, 0xD2, 0xC1}, 43}, /* кра */
    {{0xC9, 0xD1, 0xCD}, 43}, /* иям */
    {{0xC1, 0xCC, 0xCF}, 43}, /* ало */
    {{0xD2, 0xD5, 0xDE}, 43}, /* руч */
    {{0xCF, 0xD2, 0xC7}, 43}, /* орг */
    {{0xDE, 0xC1, 0xD1}, 42}, /* чая */
    {{0xCE, 0xC9, 0xCD}, 42}, /* ним */
    {{0xC9, 0xDA, 0xCE}, 42}, /* изн */
    {{0xD0, 0xCF, 0xCB}, 42}, /* пок */
    {{0xD3, 0xD4, 0xD5}, 42}, /* сту */
    {{0xC5, 0xCC, 0xC0}, 42}, /* елю */
    {{0xD4, 0xC9, 0xD4}, 42}, /* тит */
    {{0xC3, 0xC5, 0xCE}, 42}, /* цен */
    {{0xDE, 0xC1, 0xD3}, 42}, /* час */
    {{0xC7, 0xC1, 0xCE}, 42}, /* ган */
    {{0xD2, 0xC7, 0xC1}, 42}, /* рга */
    {{0xD3, 0xD4, 0xCE}, 42}, /* стн */
    {{0xD2, 0xC5, 0xD6}, 42}, /* реж */
    {{0xD5, 0xCD, 0xCD}, 42}, /* умм */
    {{0xD4, 0xD7, 0xD5}, 41}, /* тву */
    {{0xD4, 0xD5, 0xD0}, 41}, /* туп */
    {{0xD3, 0xCB, 0xC9}, 40}, /* ски */
    {{0xC4, 0xC5, 0xCB}, 40}, /* дек */
    {{0xCC, 0xC5, 0xD6}, 40}, /* леж */
    {{0xC5, 0xD3, 0xC5}, 40}, /* есе */
    {{0xD7, 0xC9, 0xC5}, 40}, /* вие */
    {{0xD4, 0xCB, 0xC1}, 40}, /* тка */
    {{0xC5, 0xCB, 0xD2}, 40}, /* екр */
    {{0xCF, 0xC4, 0xCF}, 40}, /* одо */
    {{0xCB, 0xD3, 0xC1}, 40}, /* кса */
    {{0xD2, 0xC5, 0xCB}, 40}, /* рек */
    {{0xCE, 0xD4, 0xC5}, 40}, /* нте */
    {{0xD5, 0xC7, 0xC9}, 40}, /* уги */
    {{0xC2, 0xD9, 0xCC}, 40}, /* был */
    {{0xC9, 0xCE, 0xD1}, 40}, /* иня */
    {{0xC5, 0xDD, 0xC9}, 39}, /* ещи */
    {{0xC7, 0xC5, 0xCE}, 39}, /* ген */
    {{0xEB, 0xCF, 0xC4}, 39}, /* Код */
    {{0xC4, 0xC9, 0xD4}, 39}, /* дит */
    {{0xD3, 0xC8, 0xCF}, 39}, /* схо */
    {{0xC9, 0xCE, 0xD4}, 39}, /* инт */
    {{0xD3, 0xD5, 0xCD}, 39}, /* сум */
    {{0xD2, 0xCF, 0xCE}, 39}, /* рон */
    {{0xCF, 0xD4, 0xCB}, 39}, /* отк */
    {{0xC4, 0xCF, 0xCB}, 39}, /* док */
    {{0xC9, 0xCC, 0xC1}, 38}, /* ила */
    {{0xC3, 0xC5, 0xD3}, 38}, /* цес */
    {{0xC9, 0xCB, 0xC1}, 38}, /* ика */
    {{0xDA, 0xCE, 0xC9}, 38}, /* зни */
    {{0xCF, 0xD7, 0xD9}, 38}, /* овы */
    {{0xCC, 0xD6, 0xCE}, 38}, /* лжн */
    {{0xD5, 0xD0, 0xCC}, 38}, /* упл */
    {{0xC7, 0xC4, 0xC1}, 37}, /* гда */
    {{0xCC, 0xC1, 0xD6}, 37}, /* лаж */
    {{0xD6, 0xC5, 0xC4}, 37}, /* жед */
    {{0xC2, 0xC5, 0xDA}, 37}, /* без */
    {{0xC4, 0xC5, 0xD4}, 37}, /* дет */
    {{0xCF, 0xD2, 0xD1}, 37}, /* оря */
    {{0xD2, 0xCF, 0xD3}, 37}, /* рос */
    {{0xCF, 0xC2, 0xCC}, 37}, /* обл */
    {{0xC3, 0xC9, 0xC9}, 37}, /* ции */
    {{0xC4, 0xCF, 0xCD}, 37}, /* дом */
    {{0xCE, 0xC3, 0xC5}, 37}, /* нце */
    {{0xDB, 0xC5, 0xC7}, 37}, /* шег */
    {{0xCC, 0xCF, 0xD6}, 37}, /* лож */
    {{0xCF, 0xCE, 0xC1}, 37}, /* она */
    {{0xCF, 0xCB, 0xCC}, 37}, /* окл */
    {{0xCF, 0xC7, 0xC4}, 37}, /* огд */
    {{0xD2, 0xCF, 0xC4}, 37}, /* род */
    {{0xC5, 0xCE, 0xC1}, 37}, /* ена */
    {{0xCF, 0xCE, 0xC3}, 37}, /* онц */
    {{0xCF, 0xD4, 0xCE}, 37}, /* отн */
    {{0xD3, 0xCF, 0xC7}, 37}, /* сог */
    {{0xC5, 0xD7, 0xDB}, 37}, /* евш */
    {{0xD7, 0xC9, 0xD4}, 36}, /* вит */
    {{0xC5, 0xD2, 0xD0}, 36}, /* ерп */
    {{0xCF, 0xC4, 0xC1}, 36}, /* ода */
    {{0xC5, 0xD4, 0xC5}, 36}, /* ете */
    {{0xCE, 0xC5, 0xCF}, 36}, /* нео */
    {{0xD2, 0xD0, 0xC5}, 36}, /* рпе */
    {{0xC5, 0xD2, 0xDB}, 36}, /* ерш */
    {{0xC9, 0xCD, 0xC9}, 36}, /* ими */
    {{0xC9, 0xD7, 0xDB}, 36}, /* ивш */
    {{0xD9, 0xD0, 0xCC}, 36}, /* ыпл */
    {{0xD0, 0xC5, 0xD7}, 36}, /* пев */
    {{0xC1, 0xC4, 0xC1}, 36}, /* ада */
    {{0xCD, 0xCF, 0xD3}, 35}, /* мос */
    {{0xCF, 0xC2, 0xD3}, 35}, /* обс */
    {{0xCE, 0xC5, 0xC4}, 34}, /* нед */
    {{0xC9, 0xCB, 0xCF}, 34}, /* ико */
    {{0xDD, 0xC9, 0xCD}, 34}, /* щим */
    {{0xC4, 0xC5, 0xD2}, 34}, /* дер */
    {{0xD3, 0xCB, 0xC1}, 34}, /* ска */
    {{0xCF, 0xD2, 0xCD}, 34}, /* орм */
    {{0xD5, 0xCD, 0xC5}, 34}, /* уме */
    {{0xCF, 0xCF, 0xC2}, 34}, /* ооб */
    {{0xD2, 0xC9, 0xD3}, 34}, /* рис */
    {{0xCF, 0xC2, 0xDF}, 33}, /* объ */
    {{0xCF, 0xCC, 0xD5}, 33}, /* олу */
    {{0xDF, 0xD1, 0xD7}, 33}, /* ъяв */
    {{0xD2, 0xC5, 0xCD}, 33}, /* рем */
    {{0xDD, 0xC9, 0xC8}, 33}, /* щих */
    {{0xD5, 0xC0, 0xDD}, 33}, /* ующ */
    {{0xCB, 0xD6, 0xC5}, 33}, /* кже */
    {{0xC9, 0xC4, 0xC5}, 33}, /* иде */
    {{0xC2, 0xD3, 0xD4}, 33}, /* бст */
    {{0xC1, 0xCB, 0xD6}, 33}, /* акж */
    {{0xD7, 0xD5, 0xC0}, 33}, /* вую */
    {{0xC1, 0xD3, 0xC8}, 33}, /* асх */
    {{0xC1, 0xCE, 0xC1}, 32}, /* ана */
    {{0xCE, 0xC1, 0xC4}, 32}, /* над */
    {{0xCF, 0xC2, 0xC5}, 32}, /* обе */
    {{0xD9, 0xD4, 0xCB}, 32}, /* ытк */
    {{0xDC, 0xD4, 0xC9}, 32}, /* эти */
    {{0xCF, 0xD6, 0xCE}, 32}, /* ожн */
    {{0xC1, 0xD4, 0xD9}, 31}, /* аты */
    {{0xD3, 0xC4, 0xC5}, 31}, /* сде */
    {{0xC1, 0xC0, 0xD4}, 31}, /* ают */
    {{0xD1, 0xD4, 0xD8}, 31}, /* ять */
    {{0xCF, 0xD1, 0xD4}, 31}, /* оят */
    {{0xC5, 0xD4, 0xD8}, 31}, /* еть */
    {{0xC1, 0xC7, 0xC5}, 31}, /* аге */
    {{0xDE, 0xD2, 0xC5}, 31}, /* чре */
    {{0xC5, 0xCE, 0xD9}, 31}, /* ены */
    {{0xD5, 0xC2, 0xD9}, 31}, /* убы */
    {{0xC9, 0xD3, 0xD4}, 30}, /* ист */
    {{0xD1, 0xC0, 0xD4}, 30}, /* яют */
    {{0xD2, 0xD1, 0xC4}, 30}, /* ряд */
    {{0xC7, 0xCF, 0xD3}, 30}, /* гос */
    {{0xC9, 0xCD, 0xC1}, 30}, /* има */
    {{0xDA, 0xC1, 0xD3}, 30}, /* зас */
    {{0xC1, 0xC0, 0xDD}, 30}, /* ающ */
    {{0xCF, 0xDA, 0xD7}, 30}, /* озв */
    {{0xC5, 0xC4, 0xC9}, 30}, /* еди */
    {{0xCF, 0xCD, 0xC5}, 30}, /* оме */
    {{0xCE, 0xC9, 0xCA}, 30}, /* ний */
    {{0xD3, 0xD5, 0xC4}, 30}, /* суд */
    {{0xDA, 0xC4, 0xCF}, 29}, /* здо */
    {{0xD3, 0xD7, 0xC9}, 29}, /* сви */
    {{0xCF, 0xCC, 0xC9}, 29}, /* оли */
    {{0xCF, 0xD7, 0xD8}, 29}, /* овь */
    {{0xD7, 0xC9, 0xCA}, 29}, /* вий */
    {{0xC4, 0xCF, 0xD2}, 29}, /* дор */
    {{0xC4, 0xC5, 0xD1}, 29}, /* дея */
    {{0xC5, 0xD1, 0xD4}, 29}, /* еят */
    {{0xC3, 0xCF, 0xCD}, 29}, /* цом */
    {{0xC9, 0xDA, 0xC1}, 28}, /* иза */
    {{0xD3, 0xDE, 0xC5}, 28}, /* сче */
    {{0xCB, 0xD4, 0xC1}, 28}, /* кта */
    {{0xCF, 0xC4, 0xCE}, 28}, /* одн */
    {{0xC2, 0xCC, 0xC1}, 28}, /* бла */
    {{0xCF, 0xC4, 0xCC}, 28}, /* одл */
    {{0xC9, 0xD4, 0xC1}, 28}, /* ита */
    {{0xE4, 0xCF, 0xC7}, 28}, /* Дог */
    {{0xCF, 0xD3, 0xCF}, 28}, /* осо */
    {{0xCE, 0xCF, 0xDB}, 28}, /* нош */
    {{0xCB, 0xD5, 0xD2}, 28}, /* кур */
    {{0xC9, 0xCE, 0xC1}, 28}, /* ина */
    {{0xCF, 0xDB, 0xC5}, 28}, /* оше */
    {{0xCE, 0xC1, 0xCC}, 28}, /* нал */
    {{0xCE, 0xC9, 0xDA}, 27}, /* низ */
    {{0xDA, 0xD7, 0xD2}, 27}, /* звр */
    {{0xD7, 0xD2, 0xC1}, 27}, /* вра */
    {{0xCC, 0xC5, 0xD4}, 27}, /* лет */
    {{0xC5, 0xDD, 0xD8}, 27}, /* ещь */
    {{0xD2, 0xC9, 0xC4}, 27}, /* рид */
    {{0xC4, 0xCE, 0xCF}, 27}, /* дно */
    {{0xD2, 0xC9, 0xCF}, 27}, /* рио */
    {{0xCF, 0xC9, 0xCD}, 27}, /* оим */
    {{0xC5, 0xD2, 0xD6}, 27}, /* ерж */
    {{0xD5, 0xD7, 0xC5}, 26}, /* уве */
    {{0xCF, 0xCE, 0xCB}, 26}, /* онк */
    {{0xC5, 0xCC, 0xCB}, 26}, /* елк */
    {{0xCC, 0xC1, 0xD7}, 26}, /* лав */
    {{0xC1, 0xD4, 0xCF}, 26}, /* ато */
    {{0xD1, 0xCD, 0xC9}, 26}, /* ями */
    {{0xCD, 0xCD, 0xD9}, 26}, /* ммы */
    {{0xC5, 0xD3, 0xD0}, 26}, /* есп */
    {{0xCE, 0xCB, 0xD5}, 26}, /* нку */
    {{0xC9, 0xC3, 0xD5}, 25}, /* ицу */
    {{0xC4, 0xD3, 0xCB}, 25}, /* дск */
    {{0xCE, 0xC9, 0xCE}, 25}, /* нин */
    {{0xD0, 0xCC, 0xC5}, 25}, /* пле */
    {{0xC6, 0xCF, 0xD2}, 25}, /* фор */
    {{0xCC, 0xC1, 0xD3}, 25}, /* лас */
    {{0xC4, 0xC9, 0xCD}, 25}, /* дим */
    {{0xC5, 0xD3, 0xD1}, 25}, /* еся */
    {{0xCE, 0xC9, 0xDE}, 25}, /* нич */
    {{0xCF, 0xD7, 0xD2}, 25}, /* овр */
    {{0xD7, 0xD3, 0xCC}, 25}, /* всл */
    {{0xD2, 0xDB, 0xC5}, 25}, /* рше */
    {{0xC5, 0xDD, 0xC1}, 25}, /* еща */
    {{0xD6, 0xCE, 0xD9}, 25}, /* жны */
    {{0xD2, 0xC9, 0xCD}, 25}, /* рим */
    {{0xDA, 0xC1, 0xC3}, 25}, /* зац */
    {{0xC2, 0xDD, 0xC5}, 25}, /* бще */
    {{0xC1, 0xCB, 0xD4}, 25}, /* акт */
    {{0xC1, 0xC4, 0xD3}, 25}, /* адс */
    {{0xD5, 0xDE, 0xD2}, 25}, /* учр */
    {{0xDD, 0xC9, 0xC5}, 25}, /* щие */
    {{0xD6, 0xC9, 0xD4}, 24}, /* жит */
    {{0xC2, 0xD2, 0xC5}, 24}, /* бре */
    {{0xD5, 0xC7, 0xCF}, 24}, /* уго */
    {{0xC9, 0xD1, 0xC8}, 24}, /* иях */
    {{0xD4, 0xD8, 0xC0}, 24}, /* тью */
    {{0xD8, 0xD3, 0xD1}, 24}, /* ься */
    {{0xD7, 0xCF, 0xD7}, 24}, /* вов */
    {{0xCF, 0xDE, 0xCE}, 24}, /* очн */
    {{0xD7, 0xCF, 0xCF}, 24}, /* воо */
    {{0xCF, 0xC4, 0xD9}, 24}, /* оды */
    {{0xCC, 0xCF, 0xC7}, 24}, /* лог */
    {{0xD7, 0xC1, 0xC5}, 24}, /* вае */
    {{0xC1, 0xD1, 0xC8}, 24}, /* аях */
    {{0xD4, 0xD8, 0xD3}, 24}, /* тьс */
    {{0xC4, 0xC9, 0xDE}, 24}, /* дич */
    {{0xCB, 0xC9, 0xC8}, 24}, /* ких */
    {{0xC3, 0xC1, 0xCD}, 24}, /* цам */
    {{0xC9, 0xDA, 0xD7}, 24}, /* изв */
    {{0xD4, 0xC9, 0xD7}, 24}, /* тив */
    {{0xC5, 0xCF, 0xC2}, 24}, /* еоб */
    {{0xD3, 0xCF, 0xD3}, 24}, /* сос */
    {{0xDB, 0xC9, 0xCD}, 24}, /* шим */
    {{0xD9, 0xD0, 0xCF}, 24}, /* ыпо */
    {{0xC5, 0xD6, 0xC1}, 24}, /* ежа */
    {{0xD4, 0xCF, 0xC9}, 24}, /* тои */
    {{0xCB, 0xD4, 0xCF}, 24}, /* кто */
    {{0xC5, 0xDE, 0xC1}, 24}, /* еча */
    {{0xC9, 0xC4, 0xC9}, 24}, /* иди */
    {{0xC2, 0xDD, 0xC9}, 23}, /* бщи */
    {{0xD4, 0xD8, 0xC5}, 23}, /* тье */
    {{0xC2, 0xDF, 0xD1}, 23}, /* бъя */
    {{0xCE, 0xC1, 0xDE}, 23}, /* нач */
    {{0xD4, 0xC5, 0xDE}, 23}, /* теч */
    {{0xD5, 0xD2, 0xD3}, 23}, /* урс */
    {{0xD7, 0xC5, 0xDE}, 23}, /* веч */
    {{0xC5, 0xCD, 0xC5}, 23}, /* еме */
    {{0xCF, 0xC2, 0xC8}, 23}, /* обх */
    {{0xC2, 0xC8, 0xCF}, 23}, /* бхо */
    {{0xC4, 0xC1, 0xC5}, 23}, /* дае */
    {{0xD2, 0xC5, 0xDA}, 23}, /* рез */
    {{0xCB, 0xC1, 0xD6}, 22}, /* каж */
    {{0xCF, 0xCB, 0xD5}, 22}, /* оку */
    {{0xC1, 0xCD, 0xC5}, 22}, /* аме */
    {{0xCE, 0xC5, 0xDA}, 22}, /* нез */
    {{0xD9, 0xD7, 0xC1}, 22}, /* ыва */
    {{0xD3, 0xD7, 0xD1}, 22}, /* свя */
    {{0xD2, 0xC1, 0xC4}, 22}, /* рад */
    {{0xC5, 0xDA, 0xC1}, 22}, /* еза */
    {{0xC9, 0xD7, 0xC1}, 22}, /* ива */
    {{0xCB, 0xC1, 0xCD}, 22}, /* кам */
    {{0xCE, 0xC5, 0xCD}, 22}, /* нем */
    {{0xD4, 0xCB, 0xCF}, 22}, /* тко */
    {{0xDA, 0xD7, 0xC5}, 22}, /* зве */
    {{0xD7, 0xD1, 0xDA}, 22}, /* вяз */
    {{0xD1, 0xD4, 0xC9}, 22}, /* яти */
    {{0xCF, 0xC8, 0xD2}, 22}, /* охр */
    {{0xD2, 0xCF, 0xD4}, 22}, /* рот */
    {{0xCF, 0xCC, 0xC5}, 22}, /* оле */
    {{0xC2, 0xD2, 0xC1}, 22}, /* бра */
    {{0xC1, 0xC5, 0xCD}, 22}, /* аем */
    {{0xCC, 0xC1, 0xDB}, 21}, /* лаш */
    {{0xC9, 0xDA, 0xCD}, 21}, /* изм */
    {{0xC7, 0xD5, 0xD4}, 21}, /* гут */
    {{0xCF, 0xD6, 0xC4}, 21}, /* ожд */
    {{0xCB, 0xC1, 0xCB}, 21}, /* как */
    {{0xCB, 0xC1, 0xDE}, 21}, /* кач */
    {{0xCE, 0xC1, 0xCD}, 21}, /* нам */
    {{0xC4, 0xCF, 0xC8}, 21}, /* дох */
    {{0xCF, 0xC8, 0xCF}, 21}, /* охо */
    {{0xC0, 0xD2, 0xC9}, 21}, /* юри */
    {{0xD7, 0xC1, 0xCD}, 21}, /* вам */
    {{0xDA, 0xCD, 0xCF}, 21}, /* змо */
    {{0xC4, 0xCB, 0xC5}, 21}, /* дке */
    {{0xC2, 0xC1, 0xCE}, 21}, /* бан */
    {{0xC5, 0xCC, 0xC9}, 21}, /* ели */
    {{0xD2, 0xC9, 0xDA}, 21}, /* риз */
    {{0xCC, 0xCE, 0xCF}, 21}, /* лно */
    {{0xD7, 0xD9, 0xDB}, 21}, /* выш */
    {{0xC4, 0xC3, 0xC1}, 21}, /* дца */
    {{0xD1, 0xC4, 0xCB}, 21}, /* ядк */
    {{0xCF, 0xD4, 0xD3}, 21}, /* отс */
    {{0xD4, 0xC5, 0xCA}, 21}, /* тей */
    {{0xC1, 0xCE, 0xCB}, 21}, /* анк */
    {{0xCE, 0xC5, 0xC7}, 21}, /* нег */
    {{0xC3, 0xC1, 0xD4}, 21}, /* цат */
    {{0xC5, 0xCD, 0xD9}, 21}, /* емы */
    {{0xD7, 0xCF, 0xC5}, 21}, /* вое */
    {{0xC4, 0xC1, 0xDE}, 21}, /* дач */
    {{0xCF, 0xC7, 0xD5}, 21}, /* огу */
    {{0xCC, 0xD6, 0xC5}, 21}, /* лже */
    {{0xD4, 0xCE, 0xC9}, 21}, /* тни */
    {{0xDA, 0xC1, 0xD7}, 21}, /* зав */
    {{0xD7, 0xC5, 0xD3}, 21}, /* вес */
    {{0xD3, 0xC1, 0xCD}, 20}, /* сам */
    {{0xC1, 0xD2, 0xCE}, 20}, /* арн */
    {{0xDE, 0xCE, 0xD9}, 20}, /* чны */
    {{0xD3, 0xD2, 0xC5}, 20}, /* сре */
    {{0xD4, 0xC9, 0xD1}, 20}, /* тия */
    {{0xC9, 0xD3, 0xCC}, 20}, /* исл */
    {{0xF3, 0xD4, 0xD2}, 20}, /* Стр */
    {{0xCE, 0xD4, 0xCF}, 20}, /* нто */
    {{0xD5, 0xD4, 0xD2}, 20}, /* утр */
    {{0xC1, 0xDB, 0xC5}, 20}, /* аше */
    {{0xC5, 0xCC, 0xC1}, 20}, /* ела */
    {{0xD5, 0xC4, 0xCF}, 20}, /* удо */
    {{0xD6, 0xC9, 0xDA}, 19}, /* жиз */
    {{0xD0, 0xC9, 0xD3}, 19}, /* пис */
    {{0xC1, 0xC9, 0xCD}, 19}, /* аим */
    {{0xDE, 0xC9, 0xD3}, 19}, /* чис */
    {{0xC5, 0xD6, 0xC9}, 19}, /* ежи */
    {{0xD7, 0xD3, 0xC5}, 19}, /* все */
    {{0xCC, 0xD8, 0xCB}, 19}, /* льк */
    {{0xC1, 0xD4, 0xD5}, 19}, /* ату */
    {{0xD5, 0xC4, 0xC1}, 19}, /* уда */
    {{0xDB, 0xC9, 0xCA}, 19}, /* ший */
    {{0xDA, 0xC1, 0xD2}, 19}, /* зар */
    {{0xC5, 0xC4, 0xCE}, 19}, /* едн */
    {{0xC1, 0xD7, 0xDB}, 19}, /* авш */
    {{0xD2, 0xCF, 0xC9}, 19}, /* рои */
    {{0xC9, 0xC4, 0xC1}, 19}, /* ида */
    {{0xC1, 0xD2, 0xCF}, 19}, /* аро */
    {{0xD4, 0xCF, 0xCA}, 19}, /* той */
    {{0xD6, 0xC1, 0xDD}, 19}, /* жащ */
    {{0xC5, 0xD3, 0xCF}, 19}, /* есо */
    {{0xD0, 0xC1, 0xCC}, 19}, /* пал */
    {{0xDD, 0xC1, 0xC5}, 19}, /* щае */
    {{0xD2, 0xD9, 0xC5}, 19}, /* рые */
    {{0xC5, 0xCE, 0xD1}, 19}, /* еня */
    {{0xDD, 0xC9, 0xCA}, 19}, /* щий */
    {{0xCC, 0xD5, 0xC7}, 19}, /* луг */
    {{0xC0, 0xDE, 0xC9}, 18}, /* ючи */
    {{0xD5, 0xCC, 0xD8}, 18}, /* уль */
    {{0xCD, 0xD9, 0xC8}, 18}, /* мых */
    {{0xD2, 0xCF, 0xC7}, 18}, /* рог */
    {{0xD3, 0xCF, 0xC8}, 18}, /* сох */
    {{0xCB, 0xCF, 0xC5}, 18}, /* кое */
    {{0xCE, 0xD4, 0xD3}, 18}, /* нтс */
    {{0xC1, 0xDA, 0xCE}, 18}, /* азн */
    {{0xD4, 0xCE, 0xD9}, 18}, /* тны */
    {{0xCF, 0xC4, 0xD1}, 18}, /* одя */
    {{0xCF, 0xC2, 0xCE}, 18}, /* обн */
    {{0xD7, 0xD9, 0xC4}, 18}, /* выд */
    {{0xCF, 0xD3, 0xD1}, 18}, /* ося */
    {{0xD8, 0xD4, 0xC1}, 18}, /* ьта */
    {{0xCE, 0xD1, 0xC0}, 18}, /* няю */
    {{0xCE, 0xC1, 0xD2}, 18}, /* нар */
    {{0xC5, 0xDA, 0xD5}, 18}, /* езу */
    {{0xC1, 0xD3, 0xCE}, 18}, /* асн */
    {{0xDA, 0xD5, 0xCC}, 18}, /* зул */
    {{0xC3, 0xC9, 0xD0}, 18}, /* цип */
    {{0xCB, 0xD4, 0xC5}, 18}, /* кте */
    {{0xC4, 0xCF, 0xD0}, 18}, /* доп */
    {{0xCE, 0xC3, 0xC9}, 18}, /* нци */
    {{0xD3, 0xD0, 0xC5}, 18}, /* спе */
    {{0xC9, 0xCD, 0xD9}, 18}, /* имы */
    {{0xCD, 0xCF, 0xCD}, 18}, /* мом */
    {{0xD0, 0xC5, 0xDE}, 18}, /* печ */
    {{0xEF, 0xC2, 0xD1}, 18}, /* Обя */
    {{0xF0, 0xD2, 0xC1}, 18}, /* Пра */
    {{0xCF, 0xCC, 0xCF}, 18}, /* оло */
    {{0xD4, 0xD3, 0xCB}, 18}, /* тск */
    {{0xCC, 0xCE, 0xC9}, 18}, /* лни */
    {{0xC5, 0xD2, 0xD4}, 18}, /* ерт */
    {{0xC9, 0xD3, 0xD8}, 18}, /* ись */
    {{0xCC, 0xD8, 0xD4}, 18}, /* льт */
    {{0xD3, 0xD5, 0xD4}, 18}, /* сут */
    {{0xD7, 0xCF, 0xC2}, 17}, /* воб */
    {{0xD2, 0xCE, 0xD9}, 17}, /* рны */
    {{0xC2, 0xCE, 0xD9}, 17}, /* бны */
    {{0xD9, 0xC4, 0xC1}, 17}, /* ыда */
    {{0xD8, 0xDA, 0xD5}, 17}, /* ьзу */
    {{0xC5, 0xC4, 0xD0}, 17}, /* едп */
    {{0xC1, 0xC4, 0xC5}, 17}, /* аде */
    {{0xC9, 0xD0, 0xC1}, 17}, /* ипа */
    {{0xD3, 0xC5, 0xCA}, 17}, /* сей */
    {{0xC5, 0xC5, 0xD3}, 17}, /* еес */
    {{0xCF, 0xC9, 0xDA}, 17}, /* оиз */
    {{0xCF, 0xD3, 0xD7}, 17}, /* осв */
    {{0xC4, 0xC9, 0xD7}, 17}, /* див */
    {{0xCE, 0xC1, 0xCE}, 17}, /* нан */
    {{0xC5, 0xD4, 0xC1}, 17}, /* ета */
    {{0xC4, 0xCE, 0xC5}, 17}, /* дне */
    {{0xC9, 0xCF, 0xC2}, 17}, /* иоб */
    {{0xD5, 0xC5, 0xD4}, 17}, /* ует */
    {{0xCE, 0xC1, 0xC8}, 17}, /* нах */
    {{0xD3, 0xCD, 0xC5}, 17}, /* сме */
    {{0xC1, 0xCC, 0xC9}, 17}, /* али */
    {{0xC2, 0xDF, 0xC5}, 17}, /* бъе */
    {{0xD0, 0xC1, 0xD3}, 17}, /* пас */
    {{0xDA, 0xC1, 0xCC}, 17}, /* зал */
    {{0xD2, 0xD6, 0xC1}, 16}, /* ржа */
    {{0xD1, 0xD7, 0xC9}, 16}, /* яви */
    {{0xD6, 0xC1, 0xD4}, 16}, /* жат */
    {{0xC2, 0xCF, 0xD6}, 16}, /* бож */
    {{0xD3, 0xC9, 0xCC}, 16}, /* сил */
    {{0xCE, 0xD5, 0xC0}, 16}, /* ную */
    {{0xD0, 0xC5, 0xCE}, 16}, /* пен */
    {{0xCD, 0xC1, 0xD4}, 16}, /* мат */
    {{0xCF, 0xCE, 0xCE}, 16}, /* онн */
    {{0xD7, 0xC9, 0xCE}, 16}, /* вин */
    {{0xD4, 0xCB, 0xC9}, 16}, /* тки */
    {{0xD4, 0xCF, 0xDE}, 16}, /* точ */
    {{0xD3, 0xDE, 0xC9}, 16}, /* счи */
    {{0xCE, 0xC9, 0xC3}, 16}, /* ниц */
    {{0xDD, 0xC5, 0xC5}, 16}, /* щее */
    {{0xC2, 0xC5, 0xD3}, 16}, /* бес */
    {{0xC1, 0xC4, 0xC3}, 16}, /* адц */
    {{0xEB, 0xCF, 0xCD}, 16}, /* Ком */
    {{0xD8, 0xC9, 0xCD}, 16}, /* ьим */
    {{0xD5, 0xD4, 0xD3}, 16}, /* утс */
    {{0xC1, 0xDE, 0xC9}, 16}, /* ачи */
    {{0xD0, 0xCF, 0xCE}, 16}, /* пон */
    {{0xCB, 0xC1, 0xC5}, 16}, /* кае */
    {{0xC9, 0xC7, 0xD2}, 16}, /* игр */
    {{0xC1, 0xCB, 0xC9}, 16}, /* аки */
    {{0xC1, 0xDD, 0xC9}, 16}, /* ащи */
    {{0xCC, 0xD8, 0xC3}, 16}, /* льц */
    {{0xD7, 0xCE, 0xCF}, 16}, /* вно */
    {{0xD9, 0xDB, 0xC5}, 15}, /* ыше */
    {{0xEC, 0xC9, 0xC3}, 15}, /* Лиц */
    {{0xD8, 0xC5, 0xCA}, 15}, /* ьей */
    {{0xDB, 0xC5, 0xCD}, 15}, /* шем */
    {{0xD5, 0xC2, 0xCC}, 15}, /* убл */
    {{0xD2, 0xC1, 0xC3}, 15}, /* рац */
    {{0xCB, 0xD5, 0xCD}, 15}, /* кум */
    {{0xD2, 0xC5, 0xC7}, 15}, /* рег */
    {{0xCF, 0xD0, 0xC1}, 15}, /* опа */
    {{0xF7, 0xCF, 0xDA}, 15}, /* Воз */
    {{0xD4, 0xC1, 0xC5}, 15}, /* тае */
    {{0xCF, 0xC2, 0xD9}, 15}, /* обы */
    {{0xC2, 0xCC, 0xC9}, 15}, /* бли */
    {{0xD2, 0xCD, 0xC5}, 15}, /* рме */
    {{0xD7, 0xCF, 0xD3}, 15}, /* вос */
    {{0xC1, 0xD3, 0xC9}, 15}, /* аси */
    {{0xD4, 0xC1, 0xCD}, 15}, /* там */
    {{0xD8, 0xCD, 0xC5}, 15}, /* ьме */
    {{0xCF, 0xC7, 0xC1}, 15}, /* ога */
    {{0xC9, 0xCC, 0xCF}, 15}, /* ило */
    {{0xD3, 0xD8, 0xCD}, 15}, /* сьм */
    {{0xD2, 0xD4, 0xC9}, 15}, /* рти */
    {{0xD4, 0xD3, 0xD5}, 15}, /* тсу */
    {{0xD3, 0xC5, 0xCE}, 15}, /* сен */
    {{0xD4, 0xC1, 0xCC}, 15}, /* тал */
    {{0xC4, 0xC1, 0xD2}, 15}, /* дар */
    {{0xC1, 0xCD, 0xCF}, 15}, /* амо */
    {{0xC5, 0xC4, 0xCC}, 15}, /* едл */
    {{0xD3, 0xD5, 0xC2}, 15}, /* суб */
    {{0xC5, 0xCA, 0xC6}, 15}, /* ейф */
    {{0xE8, 0xD2, 0xC1}, 15}, /* Хра */
    {{0xCC, 0xC1, 0xCD}, 14}, /* лам */
    {{0xC1, 0xD2, 0xD5}, 14}, /* ару */
    {{0xC7, 0xC9, 0xC8}, 14}, /* гих */
    {{0xC3, 0xC9, 0xD1}, 14}, /* ция */
    {{0xC4, 0xC1, 0xD7}, 14}, /* дав */
    {{0xCC, 0xC9, 0xDB}, 14}, /* лиш */
    {{0xC0, 0xDE, 0xC1}, 14}, /* юча */
    {{0xC1, 0xCE, 0xD3}, 14}, /* анс */
    {{0xCF, 0xC7, 0xD2}, 14}, /* огр */
    {{0xC9, 0xDD, 0xC1}, 14}, /* ища */
    {{0xC5, 0xCE, 0xD8}, 14}, /* ень */
    {{0xCF, 0xD4, 0xC9}, 14}, /* оти */
    {{0xC1, 0xC4, 0xD9}, 13}, /* ады */
    {{0xC1, 0xDD, 0xC1}, 13}, /* аща */
    {{0xD7, 0xCF, 0xC9}, 13}, /* вои */
    {{0xD7, 0xD9, 0xCD}, 13}, /* вым */
    {{0xD7, 0xD8, 0xD1}, 13}, /* вья */
    {{0xCB, 0xC9, 0xC5}, 13}, /* кие */
    {{0xCC, 0xC9, 0xD3}, 13}, /* лис */
    {{0xCD, 0xC5, 0xC4}, 13}, /* мед */
    {{0xD4, 0xC9, 0xC8}, 13}, /* тих */
    {{0xC5, 0xD4, 0xCF}, 13}, /* ето */
    {{0xDA, 0xCC, 0xCF}, 13}, /* зло */
    {{0xCF, 0xD0, 0xC5}, 13}, /* опе */
    {{0xD3, 0xC9, 0xCD}, 13}, /* сим */
    {{0xD1, 0xDA, 0xC9}, 13}, /* язи */
    {{0xC9, 0xCE, 0xC4}, 13}, /* инд */
    {{0xDE, 0xD5, 0xD6}, 13}, /* чуж */
    {{0xCC, 0xCB, 0xC9}, 13}, /* лки */
    {{0xC4, 0xD0, 0xD2}, 13}, /* дпр */
    {{0xCE, 0xC4, 0xC9}, 13}, /* нди */
    {{0xCF, 0xD4, 0xC1}, 13}, /* ота */
    {{0xCF, 0xD4, 0xD9}, 13}, /* оты */
    {{0xCC, 0xC1, 0xDE}, 13}, /* лач */
    {{0xCB, 0xC9, 0xCD}, 13}, /* ким */
    {{0xC9, 0xD3, 0xC9}, 13}, /* иси */
    {{0xD7, 0xC1, 0xCC}, 13}, /* вал */
    {{0xC5, 0xCD, 0xCF}, 13}, /* емо */
    {{0xD0, 0xD5, 0xC2}, 13}, /* пуб */
    {{0xD1, 0xC5, 0xCD}, 13}, /* яем */
    {{0xC2, 0xCF, 0xCC}, 13}, /* бол */
    {{0xCE, 0xD4, 0xD5}, 13}, /* нту */
    {{0xCE, 0xC5, 0xCA}, 13}, /* ней */
    {{0xCE, 0xC1, 0xD1}, 13}, /* ная */
    {{0xC5, 0xD3, 0xC1}, 13}, /* еса */
    {{0xD2, 0xCE, 0xCF}, 13}, /* рно */
    {{0xDD, 0xC5, 0xCD}, 13}, /* щем */
    {{0xC1, 0xCE, 0xD9}, 13}, /* аны */
    {{0xE4, 0xCF, 0xD7}, 13}, /* Дов */
    {{0xDE, 0xC9, 0xD7}, 13}, /* чив */
    {{0xD7, 0xC9, 0xD3}, 13}, /* вис */
    {{0xCF, 0xD0, 0xCF}, 13}, /* опо */
    {{0xD7, 0xD8, 0xC0}, 13}, /* вью */
    {{0xC1, 0xCC, 0xC1}, 13}, /* ала */
    {{0xCC, 0xC5, 0xCA}, 12}, /* лей */
    {{0xC1, 0xDE, 0xC1}, 12}, /* ача */
    {{0xC5, 0xDA, 0xD7}, 12}, /* езв */
    {{0xD7, 0xC1, 0xD1}, 12}, /* вая */
    {{0xC5, 0xCF, 0xD3}, 12}, /* еос */
    {{0xD1, 0xDD, 0xC9}, 12}, /* ящи */
    {{0xC9, 0xD7, 0xC9}, 12}, /* иви */
    {{0xCE, 0xC5, 0xC5}, 12}, /* нее */
    {{0xD4, 0xD2, 0xD5}, 12}, /* тру */
    {{0xDB, 0xC5, 0xC5}, 12}, /* шее */
    {{0xD3, 0xC1, 0xC8}, 12}, /* сах */
    {{0xC9, 0xCE, 0xC3}, 12}, /* инц */
    {{0xCF, 0xCD, 0xD0}, 12}, /* омп */
    {{0xD5, 0xD6, 0xCF}, 12}, /* ужо */
    {{0xD5, 0xC1, 0xCC}, 12}, /* уал */
    {{0xCE, 0xC1, 0xD4}, 12}, /* нат */
    {{0xC9, 0xC4, 0xD5}, 12}, /* иду */
    {{0xD7, 0xCC, 0xC1}, 12}, /* вла */
    {{0xDA, 0xD7, 0xC1}, 12}, /* зва */
    {{0xCC, 0xC5, 0xC5}, 12}, /* лее */
    {{0xD2, 0xC5, 0xC8}, 12}, /* рех */
    {{0xD6, 0xC4, 0xD5}, 12}, /* жду */
    {{0xCD, 0xC1, 0xCC}, 12}, /* мал */
    {{0xC5, 0xCE, 0xD3}, 12}, /* енс */
    {{0xC9, 0xCA, 0xD3}, 12}, /* ийс */
    {{0xCB, 0xCF, 0xCC}, 12}, /* кол */
    {{0xCE, 0xC1, 0xDA}, 12}, /* наз */
    {{0xC4, 0xD5, 0xC1}, 12}, /* дуа */
    {{0xCF, 0xCE, 0xC9}, 12}, /* они */
    {{0xD3, 0xC5, 0xCD}, 12}, /* сем */
    {{0xC7, 0xCF, 0xC4}, 12}, /* год */
    {{0xCD, 0xC5, 0xD6}, 12}, /* меж */
    {{0xCF, 0xDA, 0xCC}, 12}, /* озл */
    {{0xD7, 0xCD, 0xC5}, 12}, /* вме */
    {{0xD5, 0xC4, 0xC5}, 12}, /* уде */
    {{0xD8, 0xCB, 0xCF}, 12}, /* ько */
    {{0xC5, 0xD7, 0xD9}, 12}, /* евы */
    {{0xDA, 0xC1, 0xCD}, 12}, /* зам */
    {{0xD3, 0xCF, 0xC4}, 12}, /* сод */
    {{0xD2, 0xCF, 0xC5}, 11}, /* рое */
    {{0xCF, 0xD4, 0xC4}, 11}, /* отд */
    {{0xD3, 0xC9, 0xD1}, 11}, /* сия */
    {{0xC9, 0xCB, 0xD5}, 11}, /* ику */
    {{0xD9, 0xCC, 0xC9}, 11}, /* ыли */
    {{0xC7, 0xC9, 0xCD}, 11}, /* гим */
    {{0xCE, 0xD8, 0xDB}, 11}, /* ньш */
    {{0xD4, 0xC9, 0xDE}, 11}, /* тич */
    {{0xD2, 0xC1, 0xCC}, 11}, /* рал */
    {{0xD5, 0xDE, 0xC9}, 11}, /* учи */
    {{0xCD, 0xC5, 0xC0}, 11}, /* мею */
    {{0xD4, 0xC5, 0xCB}, 11}, /* тек */
    {{0xCF, 0xC2, 0xD5}, 11}, /* обу */
    {{0xCE, 0xCE, 0xD5}, 11}, /* нну */
    {{0xCE, 0xC5, 0xD0}, 11}, /* неп */
    {{0xD7, 0xC5, 0xCC}, 11}, /* вел */
    {{0xD4, 0xCD, 0xC5}, 11}, /* тме */
    {{0xC2, 0xCF, 0xC7}, 11}, /* бог */
    {{0xCF, 0xD2, 0xC9}, 11}, /* ори */
    {{0xC1, 0xD7, 0xCE}, 11}, /* авн */
    {{0xC4, 0xC5, 0xC5}, 11}, /* дее */
    {{0xD6, 0xCF, 0xCD}, 11}, /* жом */
    {{0xF7, 0xD2, 0xC5}, 11}, /* Вре */
    {{0xCD, 0xD9, 0xC5}, 11}, /* мые */
    {{0xD8, 0xC3, 0xC1}, 11}, /* ьца */
    {{0xCF, 0xC3, 0xC5}, 11}, /* оце */
    {{0xC9, 0xD4, 0xD9}, 10}, /* иты */
    {{0xDA, 0xD2, 0xC1}, 10}, /* зра */
    {{0xCF, 0xCE, 0xD9}, 10}, /* оны */
    {{0xD2, 0xC5, 0xDB}, 10}, /* реш */
    {{0xD5, 0xDB, 0xC5}, 10}, /* уше */
    {{0xD2, 0xC5, 0xD7}, 10}, /* рев */
    {{0xCF, 0xD0, 0xD5}, 10}, /* опу */
    {{0xD1, 0xD4, 0xD9}, 10}, /* яты */
    {{0xD4, 0xC1, 0xDE}, 10}, /* тач */
    {{0xC5, 0xD2, 0xCF}, 10}, /* еро */
    {{0xD7, 0xCB, 0xCC}, 10}, /* вкл */
    {{0xDA, 0xD9, 0xD7}, 10}, /* зыв */
    {{0xC1, 0xD0, 0xD2}, 10}, /* апр */
    {{0xD2, 0xD5, 0xDB}, 10}, /* руш */
    {{0xEF, 0xD4, 0xD7}, 10}, /* Отв */
    {{0xD2, 0xD3, 0xC1}, 10}, /* рса */
    {{0xC5, 0xCB, 0xD4}, 10}, /* ект */
    {{0xCC, 0xC5, 0xCB}, 10}, /* лек */
    {{0xC5, 0xC5, 0xD4}, 10}, /* еет */
    {{0xCF, 0xD0, 0xCC}, 10}, /* опл */
    {{0xD4, 0xDE, 0xC5}, 10}, /* тче */
    {{0xC7, 0xCF, 0xCD}, 10}, /* гом */
    {{0xD4, 0xCF, 0xD6}, 10}, /* тож */
    {{0xCC, 0xC5, 0xDE}, 10}, /* леч */
    {{0xC5, 0xD4, 0xD9}, 10}, /* еты */
    {{0xCF, 0xD6, 0xC9}, 10}, /* ожи */
    {{0xCD, 0xCE, 0xCF}, 10}, /* мно */
    {{0xCD, 0xCF, 0xCA}, 10}, /* мой */
    {{0xC3, 0xC5, 0xCC}, 10}, /* цел */
    {{0xD5, 0xD0, 0xC9}, 10}, /* упи */
    {{0xC1, 0xC5, 0xD7}, 10}, /* аев */
    {{0xD0, 0xCF, 0xCD}, 10}, /* пом */
    {{0xC4, 0xD1, 0xDD}, 10}, /* дящ */
    {{0xD4, 0xD2, 0xC9}, 10}, /* три */
    {{0xDB, 0xC9, 0xC5}, 10}, /* шие */
    {{0xC5, 0xCB, 0xC1}, 10}, /* ека */
    {{0xC5, 0xDB, 0xC5}, 10}, /* еше */
    {{0xDA, 0xC1, 0xC9}, 10}, /* заи */
    {{0xC9, 0xD4, 0xCF}, 10}, /* ито */
    {{0xDA, 0xCE, 0xD9}, 10}, /* зны */
    {{0xCF, 0xD1, 0xCE}, 10}, /* оян */
    {{0xC9, 0xD6, 0xC5}, 10}, /* иже */
    {{0xD7, 0xCE, 0xC5}, 10}, /* вне */
    {{0xD2, 0xD3, 0xD4}, 10}, /* рст */
    {{0xC5, 0xCD, 0xD1}, 10}, /* емя */
    {{0xCE, 0xC1, 0xC9}, 10}, /* наи */
    {{0xD4, 0xCF, 0xCC}, 10}, /* тол */
    {{0xCC, 0xC9, 0xD4}, 10}, /* лит */
    {{0xCF, 0xD3, 0xD2}, 10}, /* оср */
    {{0xD4, 0xC4, 0xC5}, 10}, /* тде */
    {{0xC5, 0xCD, 0xC9}, 10}, /* еми */
    {{0xCD, 0xC5, 0xC5}, 10}, /* мее */
    {{0xD2, 0xD9, 0xC8}, 10}, /* рых */
    {{0xCE, 0xC9, 0xD7}, 10}, /* нив */
    {{0xC5, 0xD2, 0xD5}, 10}, /* еру */
    {{0xDE, 0xC5, 0xCD}, 10}, /* чем */
    {{0xC4, 0xCF, 0xC2}, 10}, /* доб */
    {{0xC5, 0xCC, 0xCF}, 10}, /* ело */
    {{0xC9, 0xCC, 0xD5}, 10}, /* илу */
    {{0xC1, 0xC4, 0xCC}, 10}, /* адл */
    {{0xC9, 0xDE, 0xD4}, 10}, /* ичт */
    {{0xCD, 0xCC, 0xC5}, 10}, /* мле */
};

static const myencoding_trigram_t myencoding_detect_trigrams_index_windows_1251[] = {
    {{0xE5, 0xED, 0xE8}, 991}, /* ени */
    {{0xEE, 0xE3, 0xEE}, 806}, /* ого */
    {{0xF1, 0xF2, 0xE2}, 659}, /* ств */
    {{0xED, 0xE8, 0xFF}, 629}, /* ния */
    {{0xEE, 0xE2, 0xE0}, 566}, /* ова */
    {{0xF2, 0xE5, 0xEB}, 555}, /* тел */
    {{0xF0, 0xE5, 0xE4}, 507}, /* ред */
    {{0xE5, 0xED, 0xED}, 499}, /* енн */
    {{0xEE, 0xE2, 0xEE}, 443}, /* ово */
    {{0xE0, 0xED, 0xE8}, 443}, /* ани */
    {{0xF2, 0xF0, 0xE0}, 429}, /* тра */
    {{0xEE, 0xF1, 0xF2}, 428}, /* ост */
    {{0xED, 0xE8, 0xE5}, 419}, /* ние */
    {{0xED, 0xED, 0xEE}, 412}, /* нно */
    {{0xE0, 0xF5, 0xEE}, 396}, /* ахо */
    {{0xF1, 0xF2, 0xF0}, 392}, /* стр */
    {{0xF0, 0xE0, 0xF5}, 386}, /* рах */
    {{0xF5, 0xEE, 0xE2}, 379}, /* хов */
    {{0xE5, 0xEB, 0xFC}, 365}, /* ель */
    {{0xE3, 0xEE, 0xE2}, 360}, /* гов */
    {{0xE2, 0xEE, 0xF0}, 356}, /* вор */
    {{0xE5, 0xF1, 0xF2}, 349}, /* ест */
    {{0xE0, 0xF2, 0xFC}, 345}, /* ать */
    {{0xF0, 0xE0, 0xE2}, 337}, /* рав */
    {{0xEF, 0xF0, 0xE8}, 330}, /* при */
    {{0xEF, 0xF0, 0xE5}, 323}, /* пре */
    {{0xE4, 0xEE, 0xE3}, 318}, /* дог */
    {{0xED, 0xE5, 0xED}, 310}, /* нен */
    {{0xEF, 0xF0, 0xE0}, 309}, /* пра */
    {{0xE2, 0xE0, 0xED}, 304}, /* ван */
    {{0xE8, 0xF2, 0xE5}, 295}, /* ите */
    {{0xF2, 0xE2, 0xE5}, 281}, /* тве */
    {{0xEB, 0xE5, 0xED}, 266}, /* лен */
    {{0xF1, 0xF2, 0xEE}, 261}, /* сто */
    {{0xF2, 0xE0, 0xF2}, 260}, /* тат */
    {{0xED, 0xED, 0xFB}, 260}, /* нны */
    {{0xEB, 0xFC, 0xED}, 256}, /* льн */
    {{0xE2, 0xEE, 0xE7}, 255}, /* воз */
    {{0xE8, 0xEB, 0xE8}, 254}, /* или */
    {{0xE0, 0xF2, 0xE5}, 252}, /* ате */
    {{0xE5, 0xE3, 0xEE}, 241}, /* его */
    {{0xE5, 0xF2, 0xF1}, 238}, /* етс */
    {{0xED, 0xEE, 0xF1}, 236}, /* нос */
    {{0xF9, 0xE5, 0xF1}, 235}, /* щес */
    {{0xEF, 0xEE, 0xEB}, 232}, /* пол */
    {{0xF0, 0xE0, 0xED}, 231}, /* ран */
    {{0xED, 0xEE, 0xE3}, 230}, /* ног */
    {{0xF1, 0xF2, 0xE0}, 229}, /* ста */
    {{0xF7, 0xE5, 0xED}, 226}, /* чен */
    {{0xF2, 0xF0, 0xE5}, 224}, /* тре */
    {{0xE7, 0xEC, 0xE5}, 214}, /* зме */
    {{0xF3, 0xF9, 0xE5}, 212}, /* уще */
    {{0xF1, 0xF2, 0xE8}, 210}, /* сти */
    {{0xEA, 0xEE, 0xEC}, 207}, /* ком */
    {{0xEE, 0xF0, 0xEE}, 206}, /* оро */
    {{0xE2, 0xEB, 0xE5}, 195}, /* вле */
    {{0xE7, 0xE0, 0xED}, 194}, /* зан */
    {{0xE0, 0xF1, 0xF2}, 193}, /* аст */
    {{0xF2, 0xF1, 0xFF}, 191}, /* тся */
    {{0xF5, 0xF0, 0xE0}, 187}, /* хра */
    {{0xE0, 0xED, 0xED}, 182}, /* анн */
    {{0xE5, 0xF0, 0xE5}, 182}, /* ере */
    {{0xE2, 0xF0, 0xE5}, 178}, /* вре */
    {{0xEE, 0xE2, 0xE5}, 173}, /* ове */
    {{0xFC, 0xED, 0xEE}, 173}, /* ьно */
    {{0xE2, 0xE5, 0xF0}, 172}, /* вер */
    {{0xEC, 0xE5, 0xED}, 170}, /* мен */
    {{0xEB, 0xE8, 0xF6}, 168}, /* лиц */
    {{0xF2, 0xEE, 0xF0}, 167}, /* тор */
    {{0xF0, 0xE5, 0xED}, 167}, /* рен */
    {{0xF9, 0xE5, 0xED}, 165}, /* щен */
    {{0xEE, 0xE7, 0xEC}, 164}, /* озм */
    {{0xE5, 0xE4, 0xE0}, 163}, /* еда */
    {{0xF2, 0xE2, 0xE8}, 159}, /* тви */
    {{0xFF, 0xE7, 0xE0}, 159}, /* яза */
    {{0xE1, 0xFF, 0xE7}, 158}, /* бяз */
    {{0xED, 0xE8, 0xE8}, 153}, /* нии */
    {{0xED, 0xFB, 0xF5}, 153}, /* ных */
    {{0xF2, 0xFC, 0xFF}, 153}, /* тья */
    {{0xEC, 0xE5, 0xF0}, 153}, /* мер */
    {{0xF1, 0xEB, 0xE8}, 150}, /* сли */
    {{0xF2, 0xEE, 0xE2}, 148}, /* тов */
    {{0xF2, 0xE2, 0xE0}, 147}, /* тва */
    {{0xEE, 0xF0, 0xE0}, 146}, /* ора */
    {{0xED, 0xEE, 0xEC}, 144}, /* ном */
    {{0xE4, 0xE5, 0xED}, 144}, /* ден */
    {{0xE0, 0xED, 0xE5}, 142}, /* ане */
    {{0xEA, 0xEE, 0xED}, 141}, /* кон */
    {{0xEB, 0xF3, 0xF7}, 141}, /* луч */
    {{0xEC, 0xF3, 0xF9}, 140}, /* мущ */
    {{0xEE, 0xE1, 0xFF}, 140}, /* обя */
    {{0xE2, 0xE0, 0xF2}, 138}, /* ват */
    {{0xE2, 0xE0, 0xF0}, 137}, /* вар */
    {{0xE5, 0xF9, 0xE5}, 137}, /* еще */
    {{0xEE, 0xF2, 0xF0}, 137}, /* отр */
    {{0xE4, 0xE5, 0xEB}, 137}, /* дел */
    {{0xED, 0xFB, 0xEC}, 136}, /* ным */
    {{0xE8, 0xEC, 0xF3}, 136}, /* иму */
    {{0xD1, 0xF2, 0xE0}, 134}, /* Ста */
    {{0xF3, 0xF7, 0xE0}, 133}, /* уча */
    {{0xF2, 0xF1, 0xF2}, 131}, /* тст */
    {{0xE5, 0xEB, 0xFF}, 130}, /* еля */
    {{0xF1, 0xEB, 0xF3}, 130}, /* слу */
    {{0xE7, 0xE0, 0xEA}, 130}, /* зак */
    {{0xF2, 0xEE, 0xFF}, 129}, /* тоя */
    {{0xEE, 0xEC, 0xE8}, 128}, /* оми */
    {{0xEC, 0xE5, 0xF9}, 128}, /* мещ */
    {{0xE5, 0xE4, 0xF3}, 127}, /* еду */
    {{0xE2, 0xE5, 0xED}, 127}, /* вен */
    {{0xED, 0xEE, 0xE2}, 127}, /* нов */
    {{0xED, 0xEE, 0xE5}, 126}, /* ное */
    {{0xEE, 0xF2, 0xE2}, 125}, /* отв */
    {{0xEA, 0xE0, 0xE7}, 125}, /* каз */
    {{0xE0, 0xE5, 0xF2}, 125}, /* ает */
    {{0xF1, 0xEA, 0xEE}, 125}, /* ско */
    {{0xE5, 0xED, 0xF2}, 124}, /* ент */
    {{0xEC, 0xEE, 0xF2}, 123}, /* мот */
    {{0xE0, 0xE2, 0xEB}, 122}, /* авл */
    {{0xF1, 0xEC, 0xEE}, 122}, /* смо */
    {{0xE8, 0xF7, 0xE8}, 121}, /* ичи */
    {{0xE1, 0xFB, 0xF2}, 120}, /* быт */
    {{0xF3, 0xF1, 0xEC}, 118}, /* усм */
    {{0xF1, 0xF1, 0xE8}, 117}, /* сси */
    {{0xE4, 0xF3, 0xF1}, 117}, /* дус */
    {{0xF5, 0xEE, 0xE4}, 117}, /* ход */
    {{0xF0, 0xE8, 0xF7}, 117}, /* рич */
    {{0xF7, 0xE5, 0xF1}, 115}, /* чес */
    {{0xE3, 0xF0, 0xE0}, 114}, /* гра */
    {{0xEF, 0xF0, 0xEE}, 114}, /* про */
    {{0xE4, 0xEE, 0xE2}, 113}, /* дов */
    {{0xE2, 0xE5, 0xF2}, 112}, /* вет */
    {{0xE5, 0xE4, 0xE5}, 112}, /* еде */
    {{0xF8, 0xE5, 0xED}, 111}, /* шен */
    {{0xF7, 0xE8, 0xED}, 110}, /* чин */
    {{0xED, 0xE0, 0xF1}, 109}, /* нас */
    {{0xE8, 0xF2, 0xFC}, 105}, /* ить */
    {{0xF2, 0xE2, 0xEE}, 105}, /* тво */
    {{0xEA, 0xEB, 0xFE}, 104}, /* клю */
    {{0xF0, 0xE8, 0xF2}, 104}, /* рит */
    {{0xF1, 0xF2, 0xFC}, 104}, /* сть */
    {{0xEB, 0xFE, 0xF7}, 104}, /* люч */
    {{0xF2, 0xEE, 0xEC}, 104}, /* том */
    {{0xF1, 0xEB, 0xE5}, 103}, /* сле */
    {{0xF1, 0xEF, 0xEE}, 102}, /* спо */
    {{0xEE, 0xEB, 0xED}, 102}, /* олн */
    {{0xE5, 0xF1, 0xEB}, 102}, /* есл */
    {{0xE5, 0xF0, 0xE8}, 101}, /* ери */
    {{0xED, 0xEE, 0xE9}, 101}, /* ной */
    {{0xF0, 0xEE, 0xEC}, 101}, /* ром */
    {{0xEE, 0xF2, 0xEE}, 99}, /* ото */
    {{0xED, 0xFB, 0xE5}, 99}, /* ные */
    {{0xE7, 0xED, 0xE0}, 99}, /* зна */
    {{0xE2, 0xEB, 0xFF}, 99}, /* вля */
    {{0xF2, 0xE5, 0xF0}, 98}, /* тер */
    {{0xF3, 0xEF, 0xF0}, 97}, /* упр */
    {{0xE0, 0xEA, 0xEE}, 96}, /* ако */
    {{0xEA, 0xEE, 0xE3}, 96}, /* ког */
    {{0xED, 0xFB, 0xE9}, 96}, /* ный */
    {{0xEE, 0xF0, 0xF3}, 96}, /* ору */
    {{0xE5, 0xEB, 0xE5}, 95}, /* еле */
    {{0xE5, 0xF1, 0xEA}, 95}, /* еск */
    {{0xE0, 0xE7, 0xE0}, 95}, /* аза */
    {{0xE9, 0xF1, 0xF2}, 93}, /* йст */
    {{0xEF, 0xEE, 0xF0}, 93}, /* пор */
    {{0xEE, 0xE6, 0xE5}, 92}, /* оже */
    {{0xE8, 0xED, 0xE5}, 91}, /* ине */
    {{0xF9, 0xE5, 0xE9}, 90}, /* щей */
    {{0xE6, 0xE4, 0xE5}, 90}, /* жде */
    {{0xEF, 0xE5, 0xF0}, 89}, /* пер */
    {{0xED, 0xE8, 0xF2}, 89}, /* нит */
    {{0xEE, 0xEB, 0xFC}, 89}, /* оль */
    {{0xE0, 0xE6, 0xE4}, 88}, /* ажд */
    {{0xE6, 0xE5, 0xED}, 87}, /* жен */
    {{0xEB, 0xE0, 0xE4}, 87}, /* лад */
    {{0xE0, 0xEC, 0xE8}, 87}, /* ами */
    {{0xEA, 0xEE, 0xF2}, 86}, /* кот */
    {{0xF7, 0xE0, 0xE5}, 85}, /* чае */
    {{0xE2, 0xE5, 0xF9}, 85}, /* вещ */
    {{0xE2, 0xE8, 0xFF}, 85}, /* вия */
    {{0xFF, 0xF9, 0xE5}, 85}, /* яще */
    {{0xE8, 0xE5, 0xEC}, 85}, /* ием */
    {{0xEA, 0xEB, 0xE0}, 85}, /* кла */
    {{0xE5, 0xE9, 0xF1}, 84}, /* ейс */
    {{0xFB, 0xF2, 0xFC}, 84}, /* ыть */
    {{0xE0, 0xE2, 0xEE}, 84}, /* аво */
    {{0xF0, 0xE0, 0xE6}, 83}, /* раж */
    {{0xEB, 0xFC, 0xF1}, 83}, /* льс */
    {{0xEE, 0xFF, 0xF9}, 82}, /* оящ */
    {{0xE5, 0xED, 0xEE}, 81}, /* ено */
    {{0xE4, 0xF1, 0xF2}, 81}, /* дст */
    {{0xE4, 0xE5, 0xE9}, 80}, /* дей */
    {{0xF0, 0xE5, 0xE1}, 80}, /* реб */
    {{0xFC, 0xF1, 0xF2}, 79}, /* ьст */
    {{0xE5, 0xE4, 0xF1}, 79}, /* едс */
    {{0xE0, 0xF0, 0xE8}, 79}, /* ари */
    {{0xE4, 0xE0, 0xED}, 79}, /* дан */
    {{0xEC, 0xEE, 0xE6}, 78}, /* мож */
    {{0xE8, 0xEC, 0xE5}, 78}, /* име */
    {{0xE8, 0xED, 0xEE}, 78}, /* ино */
    {{0xF0, 0xE8, 0xED}, 77}, /* рин */
    {{0xE4, 0xEE, 0xF1}, 77}, /* дос */
    {{0xEF, 0xEE, 0xF1}, 77}, /* пос */
    {{0xF2, 0xE0, 0xEA}, 77}, /* так */
    {{0xF9, 0xE5, 0xE3}, 77}, /* щег */
    {{0xE4, 0xE0, 0xF2}, 77}, /* дат */
    {{0xEF, 0xEB, 0xE0}, 76}, /* пла */
    {{0xF3, 0xF1, 0xEB}, 76}, /* усл */
    {{0xE8, 0xF6, 0xE0}, 76}, /* ица */
    {{0xF0, 0xEE, 0xE2}, 75}, /* ров */
    {{0xFD, 0xF2, 0xEE}, 75}, /* это */
    {{0xF3, 0xF7, 0xE5}, 74}, /* уче */
    {{0xE4, 0xEE, 0xEB}, 73}, /* дол */
    {{0xFC, 0xED, 0xFB}, 73}, /* ьны */
    {{0xF0, 0xE0, 0xE7}, 73}, /* раз */
    {{0xEC, 0xE8, 0xF1}, 73}, /* мис */
    {{0xE0, 0xED, 0xEE}, 72}, /* ано */
    {{0xF1, 0xF0, 0xEE}, 72}, /* сро */
    {{0xE0, 0xE2, 0xE8}, 72}, /* ави */
    {{0xF2, 0xFC, 0xE8}, 71}, /* тьи */
    {{0xFE, 0xF7, 0xE5}, 70}, /* юче */
    {{0xF1, 0xEA, 0xEB}, 70}, /* скл */
    {{0xE8, 0xF1, 0xF1}, 70}, /* исс */
    {{0xE6, 0xE5, 0xF2}, 69}, /* жет */
    {{0xE5, 0xE4, 0xEE}, 69}, /* едо */
    {{0xEB, 0xE5, 0xE4}, 69}, /* лед */
    {{0xEB, 0xEE, 0xE2}, 69}, /* лов */
    {{0xFE, 0xF9, 0xE8}, 68}, /* ющи */
    {{0xE8, 0xE1, 0xEE}, 68}, /* ибо */
    {{0xEB, 0xE0, 0xF2}, 67}, /* лат */
    {{0xF0, 0xEE, 0xEA}, 67}, /* рок */
    {{0xE0, 0xEA, 0xEB}, 67}, /* акл */
    {{0xF0, 0xE8, 0xF9}, 67}, /* рищ */
    {{0xE1, 0xEE, 0xE2}, 67}, /* бов */
    {{0xE8, 0xF1, 0xEA}, 67}, /* иск */
    {{0xE5, 0xE1, 0xEE}, 67}, /* ебо */
    {{0xEB, 0xFC, 0xE7}, 67}, /* льз */
    {{0xF3, 0xEA, 0xE0}, 67}, /* ука */
    {{0xEB, 0xE8, 0xE1}, 66}, /* либ */
    {{0xEE, 0xEC, 0xF3}, 66}, /* ому */
    {{0xEE, 0xE2, 0xEB}, 66}, /* овл */
    {{0xF2, 0xED, 0xEE}, 65}, /* тно */
    {{0xE2, 0xEE, 0xE9}, 64}, /* вой */
    {{0xF2, 0xEE, 0xE3}, 64}, /* тог */
    {{0xF1, 0xEB, 0xEE}, 64}, /* сло */
    {{0xEE, 0xE7, 0xED}, 64}, /* озн */
    {{0xF1, 0xEE, 0xEE}, 64}, /* соо */
    {{0xE7, 0xE0, 0xF2}, 63}, /* зат */
    {{0xE8, 0xF1, 0xEF}, 63}, /* исп */
    {{0xE0, 0xF7, 0xE5}, 63}, /* аче */
    {{0xED, 0xE8, 0xFE}, 63}, /* нию */
    {{0xEE, 0xED, 0xE5}, 63}, /* оне */
    {{0xEE, 0xEB, 0xE6}, 62}, /* олж */
    {{0xEE, 0xE2, 0xF9}, 61}, /* овщ */
    {{0xF0, 0xE0, 0xF1}, 61}, /* рас */
    {{0xE2, 0xE8, 0xE4}, 61}, /* вид */
    {{0xE2, 0xF9, 0xE8}, 61}, /* вщи */
    {{0xF1, 0xED, 0xEE}, 61}, /* сно */
    {{0xE8, 0xF6, 0xEE}, 61}, /* ицо */
    {{0xE8, 0xF7, 0xE5}, 61}, /* иче */
    {{0xE0, 0xE2, 0xE5}, 61}, /* аве */
    {{0xE3, 0xEB, 0xE0}, 61}, /* гла */
    {{0xF7, 0xE5, 0xF2}, 61}, /* чет */
    {{0xF9, 0xE8, 0xEA}, 61}, /* щик */
    {{0xF0, 0xF3, 0xE3}, 60}, /* руг */
    {{0xF2, 0xE0, 0xED}, 60}, /* тан */
    {{0xE8, 0xEC, 0xEE}, 60}, /* имо */
    {{0xE0, 0xEB, 0xFC}, 60}, /* аль */
    {{0xEE, 0xE2, 0xE8}, 60}, /* ови */
    {{0xE6, 0xE4, 0xE0}, 60}, /* жда */
    {{0xEF, 0xEE, 0xE2}, 60}, /* пов */
    {{0xE5, 0xEC, 0xF3}, 60}, /* ему */
    {{0xFF, 0xF2, 0xE5}, 60}, /* яте */
    {{0xF1, 0xE8, 0xE8}, 59}, /* сии */
    {{0xE1, 0xEE, 0xF2}, 59}, /* бот */
    {{0xE2, 0xFB, 0xEF}, 59}, /* вып */
    {{0xE0, 0xE1, 0xEE}, 59}, /* або */
    {{0xEB, 0xFF, 0xFE}, 59}, /* ляю */
    {{0xF1, 0xF3, 0xF9}, 58}, /* сущ */
    {{0xEE, 0xE4, 0xE5}, 58}, /* оде */
    {{0xE8, 0xED, 0xE8}, 58}, /* ини */
    {{0xF0, 0xE0, 0xF2}, 58}, /* рат */
    {{0xFF, 0xE2, 0xEB}, 58}, /* явл */
    {{0xED, 0xE0, 0xE3}, 57}, /* наг */
    {{0xE4, 0xF0, 0xF3}, 57}, /* дру */
    {{0xF0, 0xE0, 0xE1}, 57}, /* раб */
    {{0xE0, 0xE3, 0xF0}, 57}, /* агр */
    {{0xE8, 0xEE, 0xED}, 57}, /* ион */
    {{0xEC, 0xE5, 0xF1}, 57}, /* мес */
    {{0xE0, 0xF6, 0xE8}, 56}, /* аци */
    {{0xEE, 0xF1, 0xF3}, 56}, /* осу */
    {{0xEA, 0xEE, 0xE9}, 55}, /* кой */
    {{0xF1, 0xE2, 0xEE}, 55}, /* сво */
    {{0xE7, 0xEE, 0xE2}, 55}, /* зов */
    {{0xEE, 0xEF, 0xF0}, 54}, /* опр */
    {{0xF1, 0xEE, 0xE1}, 54}, /* соб */
    {{0xE2, 0xEF, 0xF0}, 54}, /* впр */
    {{0xEB, 0xED, 0xE5}, 54}, /* лне */
    {{0xEE, 0xEC, 0xEC}, 54}, /* омм */
    {{0xE5, 0xF0, 0xE0}, 54}, /* ера */
    {{0xF7, 0xE8, 0xF2}, 54}, /* чит */
    {{0xE5, 0xF0, 0xF7}, 54}, /* ерч */
    {{0xF0, 0xF7, 0xE5}, 54}, /* рче */
    {{0xE0, 0xF2, 0xE8}, 54}, /* ати */
    {{0xED, 0xE8, 0xEA}, 54}, /* ник */
    {{0xEC, 0xEC, 0xE5}, 54}, /* мме */
    {{0xF3, 0xF1, 0xF2}, 53}, /* уст */
    {{0xF2, 0xE5, 0xED}, 53}, /* тен */
    {{0xE2, 0xE5, 0xE4}, 53}, /* вед */
    {{0xF1, 0xEE, 0xE2}, 52}, /* сов */
    {{0xE0, 0xE6, 0xE5}, 52}, /* аже */
    {{0xEE, 0xEA, 0xE0}, 52}, /* ока */
    {{0xFB, 0xEC, 0xE8}, 52}, /* ыми */
    {{0xFE, 0xF2, 0xF1}, 52}, /* ютс */
    {{0xEE, 0xEE, 0xF2}, 52}, /* оот */
    {{0xEC, 0xE8, 0xF2}, 52}, /* мит */
    {{0xFF, 0xFE, 0xF9}, 51}, /* яющ */
    {{0xE2, 0xF8, 0xE5}, 51}, /* вше */
    {{0xF1, 0xE8, 0xEE}, 51}, /* сио */
    {{0xEE, 0xED, 0xEE}, 51}, /* оно */
    {{0xE0, 0xE2, 0xE0}, 51}, /* ава */
    {{0xE0, 0xF9, 0xE5}, 51}, /* аще */
    {{0xEB, 0xFF, 0xE5}, 50}, /* ляе */
    {{0xE5, 0xED, 0xE5}, 50}, /* ене */
    {{0xEE, 0xE4, 0xE8}, 50}, /* оди */
    {{0xEF, 0xF3, 0xED}, 49}, /* пун */
    {{0xEB, 0xE8, 0xF7}, 49}, /* лич */
    {{0xE2, 0xEE, 0xEC}, 49}, /* вом */
    {{0xED, 0xEA, 0xF2}, 49}, /* нкт */
    {{0xED, 0xE5, 0xF1}, 49}, /* нес */
    {{0xE2, 0xE8, 0xEB}, 49}, /* вил */
    {{0xE5, 0xE6, 0xE4}, 49}, /* ежд */
    {{0xF0, 0xE5, 0xF1}, 49}, /* рес */
    {{0xFE, 0xF9, 0xE5}, 49}, /* юще */
    {{0xFC, 0xE7, 0xEE}, 49}, /* ьзо */
    {{0xEF, 0xEE, 0xF2}, 49}, /* пот */
    {{0xF3, 0xED, 0xEA}, 49}, /* унк */
    {{0xF1, 0xF2, 0xE5}, 49}, /* сте */
    {{0xEA, 0xEE, 0xE2}, 49}, /* ков */
    {{0xEE, 0xF1, 0xEB}, 48}, /* осл */
    {{0xFF, 0xE5, 0xF2}, 48}, /* яет */
    {{0xC5, 0xF1, 0xEB}, 48}, /* Есл */
    {{0xCF, 0xF0, 0xE8}, 48}, /* При */
    {{0xF2, 0xE0, 0xE2}, 48}, /* тав */
    {{0xED, 0xE5, 0xF0}, 48}, /* нер */
    {{0xF7, 0xED, 0xEE}, 47}, /* чно */
    {{0xEF, 0xEE, 0xE4}, 47}, /* под */
    {{0xED, 0xF2, 0xE0}, 47}, /* нта */
    {{0xE8, 0xF9, 0xE5}, 47}, /* ище */
    {{0xEE, 0xE1, 0xF9}, 47}, /* общ */
    {{0xE0, 0xE7, 0xEC}, 47}, /* азм */
    {{0xE6, 0xED, 0xEE}, 47}, /* жно */
    {{0xE2, 0xE8, 0xE8}, 46}, /* вии */
    {{0xF0, 0xE0, 0xF9}, 46}, /* ращ */
    {{0xEE, 0xF0, 0xE5}, 46}, /* оре */
    {{0xE2, 0xF8, 0xE8}, 46}, /* вши */
    {{0xE5, 0xEA, 0xF1}, 46}, /* екс */
    {{0xE2, 0xEE, 0xE3}, 46}, /* вог */
    {{0xF7, 0xF2, 0xEE}, 46}, /* что */
    {{0xE8, 0xF7, 0xED}, 45}, /* ичн */
    {{0xEB, 0xE5, 0xEC}, 45}, /* лем */
    {{0xEC, 0xEE, 0xE3}, 45}, /* мог */
    {{0xF2, 0xE2, 0xEB}, 45}, /* твл */
    {{0xE4, 0xEB, 0xE5}, 45}, /* дле */
    {{0xE4, 0xEB, 0xFF}, 45}, /* для */
    {{0xF0, 0xE5, 0xF2}, 45}, /* рет */
    {{0xE0, 0xF0, 0xE0}, 45}, /* ара */
    {{0xED, 0xFF, 0xF2}, 44}, /* нят */
    {{0xE5, 0xF7, 0xE5}, 44}, /* ече */
    {{0xEE, 0xF2, 0xE5}, 44}, /* оте */
    {{0xEE, 0xF0, 0xFB}, 44}, /* оры */
    {{0xEE, 0xF1, 0xED}, 43}, /* осн */
    {{0xEE, 0xE1, 0xEE}, 43}, /* обо */
    {{0xEE, 0xE3, 0xEB}, 43}, /* огл */
    {{0xE8, 0xED, 0xFB}, 43}, /* ины */
    {{0xE5, 0xF1, 0xF1}, 43}, /* есс */
    {{0xEE, 0xE1, 0xF0}, 43}, /* обр */
    {{0xEA, 0xF0, 0xE0}, 43}, /* кра */
    {{0xE8, 0xFF, 0xEC}, 43}, /* иям */
    {{0xE0, 0xEB, 0xEE}, 43}, /* ало */
    {{0xF0, 0xF3, 0xF7}, 43}, /* руч */
    {{0xEE, 0xF0, 0xE3}, 43}, /* орг */
    {{0xF7, 0xE0, 0xFF}, 42}, /* чая */
    {{0xED, 0xE8, 0xEC}, 42}, /* ним */
    {{0xE8, 0xE7, 0xED}, 42}, /* изн */
    {{0xEF, 0xEE, 0xEA}, 42}, /* пок */
    {{0xF1, 0xF2, 0xF3}, 42}, /* сту */
    {{0xE5, 0xEB, 0xFE}, 42}, /* елю */
    {{0xF2, 0xE8, 0xF2}, 42}, /* тит */
    {{0xF6, 0xE5, 0xED}, 42}, /* цен */
    {{0xF7, 0xE0, 0xF1}, 42}, /* час */
    {{0xE3, 0xE0, 0xED}, 42}, /* ган */
    {{0xF0, 0xE3, 0xE0}, 42}, /* рга */
    {{0xF1, 0xF2, 0xED}, 42}, /* стн */
    {{0xF0, 0xE5, 0xE6}, 42}, /* реж */
    {{0xF3, 0xEC, 0xEC}, 42}, /* умм */
    {{0xF2, 0xE2, 0xF3}, 41}, /* тву */
    {{0xF2, 0xF3, 0xEF}, 41}, /* туп */
    {{0xF1, 0xEA, 0xE8}, 40}, /* ски */
    {{0xE4, 0xE5, 0xEA}, 40}, /* дек */
    {{0xEB, 0xE5, 0xE6}, 40}, /* леж */
    {{0xE5, 0xF1, 0xE5}, 40}, /* есе */
    {{0xE2, 0xE8, 0xE5}, 40}, /* вие */
    {{0xF2, 0xEA, 0xE0}, 40}, /* тка */
    {{0xE5, 0xEA, 0xF0}, 40}, /* екр */
    {{0xEE, 0xE4, 0xEE}, 40}, /* одо */
    {{0xEA, 0xF1, 0xE0}, 40}, /* кса */
    {{0xF0, 0xE5, 0xEA}, 40}, /* рек */
    {{0xED, 0xF2, 0xE5}, 40}, /* нте */
    {{0xF3, 0xE3, 0xE8}, 40}, /* уги */
    {{0xE1, 0xFB, 0xEB}, 40}, /* был */
    {{0xE8, 0xED, 0xFF}, 40}, /* иня */
    {{0xE5, 0xF9, 0xE8}, 39}, /* ещи */
    {{0xE3, 0xE5, 0xED}, 39}, /* ген */
    {{0xCA, 0xEE, 0xE4}, 39}, /* Код */
    {{0xE4, 0xE8, 0xF2}, 39}, /* дит */
    {{0xF1, 0xF5, 0xEE}, 39}, /* схо */
    {{0xE8, 0xED, 0xF2}, 39}, /* инт */
    {{0xF1, 0xF3, 0xEC}, 39}, /* сум */
    {{0xF0, 0xEE, 0xED}, 39}, /* рон */
    {{0xEE, 0xF2, 0xEA}, 39}, /* отк */
    {{0xE4, 0xEE, 0xEA}, 39}, /* док */
    {{0xE8, 0xEB, 0xE0}, 38}, /* ила */
    {{0xF6, 0xE5, 0xF1}, 38}, /* цес */
    {{0xE8, 0xEA, 0xE0}, 38}, /* ика */
    {{0xE7, 0xED, 0xE8}, 38}, /* зни */
    {{0xEE, 0xE2, 0xFB}, 38}, /* овы */
    {{0xEB, 0xE6, 0xED}, 38}, /* лжн */
    {{0xF3, 0xEF, 0xEB}, 38}, /* упл */
    {{0xE3, 0xE4, 0xE0}, 37}, /* гда */
    {{0xEB, 0xE0, 0xE6}, 37}, /* лаж */
    {{0xE6, 0xE5, 0xE4}, 37}, /* жед */
    {{0xE1, 0xE5, 0xE7}, 37}, /* без */
    {{0xE4, 0xE5, 0xF2}, 37}, /* дет */
    {{0xEE, 0xF0, 0xFF}, 37}, /* оря */
    {{0xF0, 0xEE, 0xF1}, 37}, /* рос */
    {{0xEE, 0xE1, 0xEB}, 37}, /* обл */
    {{0xF6, 0xE8, 0xE8}, 37}, /* ции */
    {{0xE4, 0xEE, 0xEC}, 37}, /* дом */
    {{0xED, 0xF6, 0xE5}, 37}, /* нце */
    {{0xF8, 0xE5, 0xE3}, 37}, /* шег */
    {{0xEB, 0xEE, 0xE6}, 37}, /* лож */
    {{0xEE, 0xED, 0xE0}, 37}, /* она */
    {{0xEE, 0xEA, 0xEB}, 37}, /* окл */
    {{0xEE, 0xE3, 0xE4}, 37}, /* огд */
    {{0xF0, 0xEE, 0xE4}, 37}, /* род */
    {{0xE5, 0xED, 0xE0}, 37}, /* ена */
    {{0xEE, 0xED, 0xF6}, 37}, /* онц */
    {{0xEE, 0xF2, 0xED}, 37}, /* отн */
    {{0xF1, 0xEE, 0xE3}, 37}, /* сог */
    {{0xE5, 0xE2, 0xF8}, 37}, /* евш */
    {{0xE2, 0xE8, 0xF2}, 36}, /* вит */
    {{0xE5, 0xF0, 0xEF}, 36}, /* ерп */
    {{0xEE, 0xE4, 0xE0}, 36}, /* ода */
    {{0xE5, 0xF2, 0xE5}, 36}, /* ете */
    {{0xED, 0xE5, 0xEE}, 36}, /* нео */
    {{0xF0, 0xEF, 0xE5}, 36}, /* рпе */
    {{0xE5, 0xF0, 0xF8}, 36}, /* ерш */
    {{0xE8, 0xEC, 0xE8}, 36}, /* ими */
    {{0xE8, 0xE2, 0xF8}, 36}, /* ивш */
    {{0xFB, 0xEF, 0xEB}, 36}, /* ыпл */
    {{0xEF, 0xE5, 0xE2}, 36}, /* пев */
    {{0xE0, 0xE4, 0xE0}, 36}, /* ада */
    {{0xEC, 0xEE, 0xF1}, 35}, /* мос */
    {{0xEE, 0xE1, 0xF1}, 35}, /* обс */
    {{0xED, 0xE5, 0xE4}, 34}, /* нед */
    {{0xE8, 0xEA, 0xEE}, 34}, /* ико */
    {{0xF9, 0xE8, 0xEC}, 34}, /* щим */
    {{0xE4, 0xE5, 0xF0}, 34}, /* дер */
    {{0xF1, 0xEA, 0xE0}, 34}, /* ска */
    {{0xEE, 0xF0, 0xEC}, 34}, /* орм */
    {{0xF3, 0xEC, 0xE5}, 34}, /* уме */
    {{0xEE, 0xEE, 0xE1}, 34}, /* ооб */
    {{0xF0, 0xE8, 0xF1}, 34}, /* рис */
    {{0xEE, 0xE1, 0xFA}, 33}, /* объ */
    {{0xEE, 0xEB, 0xF3}, 33}, /* олу */
    {{0xFA, 0xFF, 0xE2}, 33}, /* ъяв */
    {{0xF0, 0xE5, 0xEC}, 33}, /* рем */
    {{0xF9, 0xE8, 0xF5}, 33}, /* щих */
    {{0xF3, 0xFE, 0xF9}, 33}, /* ующ */
    {{0xEA, 0xE6, 0xE5}, 33}, /* кже */
    {{0xE8, 0xE4, 0xE5}, 33}, /* иде */
    {{0xE1, 0xF1, 0xF2}, 33}, /* бст */
    {{0xE0, 0xEA, 0xE6}, 33}, /* акж */
    {{0xE2, 0xF3, 0xFE}, 33}, /* вую */
    {{0xE0, 0xF1, 0xF5}, 33}, /* асх */
    {{0xE0, 0xED, 0xE0}, 32}, /* ана */
    {{0xED, 0xE0, 0xE4}, 32}, /* над */
    {{0xEE, 0xE1, 0xE5}, 32}, /* обе */
    {{0xFB, 0xF2, 0xEA}, 32}, /* ытк */
    {{0xFD, 0xF2, 0xE8}, 32}, /* эти */
    {{0xEE, 0xE6, 0xED}, 32}, /* ожн */
    {{0xE0, 0xF2, 0xFB}, 31}, /* аты */
    {{0xF1, 0xE4, 0xE5}, 31}, /* сде */
    {{0xE0, 0xFE, 0xF2}, 31}, /* ают */
    {{0xFF, 0xF2, 0xFC}, 31}, /* ять */
    {{0xEE, 0xFF, 0xF2}, 31}, /* оят */
    {{0xE5, 0xF2, 0xFC}, 31}, /* еть */
    {{0xE0, 0xE3, 0xE5}, 31}, /* аге */
    {{0xF7, 0xF0, 0xE5}, 31}, /* чре */
    {{0xE5, 0xED, 0xFB}, 31}, /* ены */
    {{0xF3, 0xE1, 0xFB}, 31}, /* убы */
    {{0xE8, 0xF1, 0xF2}, 30}, /* ист */
    {{0xFF, 0xFE, 0xF2}, 30}, /* яют */
    {{0xF0, 0xFF, 0xE4}, 30}, /* ряд */
    {{0xE3, 0xEE, 0xF1}, 30}, /* гос */
    {{0xE8, 0xEC, 0xE0}, 30}, /* има */
    {{0xE7, 0xE0, 0xF1}, 30}, /* зас */
    {{0xE0, 0xFE, 0xF9}, 30}, /* ающ */
    {{0xEE, 0xE7, 0xE2}, 30}, /* озв */
    {{0xE5, 0xE4, 0xE8}, 30}, /* еди */
    {{0xEE, 0xEC, 0xE5}, 30}, /* оме */
    {{0xED, 0xE8, 0xE9}, 30}, /* ний */
    {{0xF1, 0xF3, 0xE4}, 30}, /* суд */
    {{0xE7, 0xE4, 0xEE}, 29}, /* здо */
    {{0xF1, 0xE2, 0xE8}, 29}, /* сви */
    {{0xEE, 0xEB, 0xE8}, 29}, /* оли */
    {{0xEE, 0xE2, 0xFC}, 29}, /* овь */
    {{0xE2, 0xE8, 0xE9}, 29}, /* вий */
    {{0xE4, 0xEE, 0xF0}, 29}, /* дор */
    {{0xE4, 0xE5, 0xFF}, 29}, /* дея */
    {{0xE5, 0xFF, 0xF2}, 29}, /* еят */
    {{0xF6, 0xEE, 0xEC}, 29}, /* цом */
    {{0xE8, 0xE7, 0xE0}, 28}, /* иза */
    {{0xF1, 0xF7, 0xE5}, 28}, /* сче */
    {{0xEA, 0xF2, 0xE0}, 28}, /* кта */
    {{0xEE, 0xE4, 0xED}, 28}, /* одн */
    {{0xE1, 0xEB, 0xE0}, 28}, /* бла */
    {{0xEE, 0xE4, 0xEB}, 28}, /* одл */
    {{0xE8, 0xF2, 0xE0}, 28}, /* ита */
    {{0xC4, 0xEE, 0xE3}, 28}, /* Дог */
    {{0xEE, 0xF1, 0xEE}, 28}, /* осо */
    {{0xED, 0xEE, 0xF8}, 28}, /* нош */
    {{0xEA, 0xF3, 0xF0}, 28}, /* кур */
    {{0xE8, 0xED, 0xE0}, 28}, /* ина */
    {{0xEE, 0xF8, 0xE5}, 28}, /* оше */
    {{0xED, 0xE0, 0xEB}, 28}, /* нал */
    {{0xED, 0xE8, 0xE7}, 27}, /* низ */
    {{0xE7, 0xE2, 0xF0}, 27}, /* звр */
    {{0xE2, 0xF0, 0xE0}, 27}, /* вра */
    {{0xEB, 0xE5, 0xF2}, 27}, /* лет */
    {{0xE5, 0xF9, 0xFC}, 27}, /* ещь */
    {{0xF0, 0xE8, 0xE4}, 27}, /* рид */
    {{0xE4, 0xED, 0xEE}, 27}, /* дно */
    {{0xF0, 0xE8, 0xEE}, 27}, /* рио */
    {{0xEE, 0xE8, 0xEC}, 27}, /* оим */
    {{0xE5, 0xF0, 0xE6}, 27}, /* ерж */
    {{0xF3, 0xE2, 0xE5}, 26}, /* уве */
    {{0xEE, 0xED, 0xEA}, 26}, /* онк */
    {{0xE5, 0xEB, 0xEA}, 26}, /* елк */
    {{0xEB, 0xE0, 0xE2}, 26}, /* лав */
    {{0xE0, 0xF2, 0xEE}, 26}, /* ато */
    {{0xFF, 0xEC, 0xE8}, 26}, /* ями */
    {{0xEC, 0xEC, 0xFB}, 26}, /* ммы */
    {{0xE5, 0xF1, 0xEF}, 26}, /* есп */
    {{0xED, 0xEA, 0xF3}, 26}, /* нку */
    {{0xE8, 0xF6, 0xF3}, 25}, /* ицу */
    {{0xE4, 0xF1, 0xEA}, 25}, /* дск */
    {{0xED, 0xE8, 0xED}, 25}, /* нин */
    {{0xEF, 0xEB, 0xE5}, 25}, /* пле */
    {{0xF4, 0xEE, 0xF0}, 25}, /* фор */
    {{0xEB, 0xE0, 0xF1}, 25}, /* лас */
    {{0xE4, 0xE8, 0xEC}, 25}, /* дим */
    {{0xE5, 0xF1, 0xFF}, 25}, /* еся */
    {{0xED, 0xE8, 0xF7}, 25}, /* нич */
    {{0xEE, 0xE2, 0xF0}, 25}, /* овр */
    {{0xE2, 0xF1, 0xEB}, 25}, /* всл */
    {{0xF0, 0xF8, 0xE5}, 25}, /* рше */
    {{0xE5, 0xF9, 0xE0}, 25}, /* еща */
    {{0xE6, 0xED, 0xFB}, 25}, /* жны */
    {{0xF0, 0xE8, 0xEC}, 25}, /* рим */
    {{0xE7, 0xE0, 0xF6}, 25}, /* зац */
    {{0xE1, 0xF9, 0xE5}, 25}, /* бще */
    {{0xE0, 0xEA, 0xF2}, 25}, /* акт */
    {{0xE0, 0xE4, 0xF1}, 25}, /* адс */
    {{0xF3, 0xF7, 0xF0}, 25}, /* учр */
    {{0xF9, 0xE8, 0xE5}, 25}, /* щие */
    {{0xE6, 0xE8, 0xF2}, 24}, /* жит */
    {{0xE1, 0xF0, 0xE5}, 24}, /* бре */
    {{0xF3, 0xE3, 0xEE}, 24}, /* уго */
    {{0xE8, 0xFF, 0xF5}, 24}, /* иях */
    {{0xF2, 0xFC, 0xFE}, 24}, /* тью */
    {{0xFC, 0xF1, 0xFF}, 24}, /* ься */
    {{0xE2, 0xEE, 0xE2}, 24}, /* вов */
    {{0xEE, 0xF7, 0xED}, 24}, /* очн */
    {{0xE2, 0xEE, 0xEE}, 24}, /* воо */
    {{0xEE, 0xE4, 0xFB}, 24}, /* оды */
    {{0xEB, 0xEE, 0xE3}, 24}, /* лог */
    {{0xE2, 0xE0, 0xE5}, 24}, /* вае */
    {{0xE0, 0xFF, 0xF5}, 24}, /* аях */
    {{0xF2, 0xFC, 0xF1}, 24}, /* тьс */
    {{0xE4, 0xE8, 0xF7}, 24}, /* дич */
    {{0xEA, 0xE8, 0xF5}, 24}, /* ких */
    {{0xF6, 0xE0, 0xEC}, 24}, /* цам */
    {{0xE8, 0xE7, 0xE2}, 24}, /* изв */
    {{0xF2, 0xE8, 0xE2}, 24}, /* тив */
    {{0xE5, 0xEE, 0xE1}, 24}, /* еоб */
    {{0xF1, 0xEE, 0xF1}, 24}, /* сос */
    {{0xF8, 0xE8, 0xEC}, 24}, /* шим */
    {{0xFB, 0xEF, 0xEE}, 24}, /* ыпо */
    {{0xE5, 0xE6, 0xE0}, 24}, /* ежа */
    {{0xF2, 0xEE, 0xE8}, 24}, /* тои */
    {{0xEA, 0xF2, 0xEE}, 24}, /* кто */
    {{0xE5, 0xF7, 0xE0}, 24}, /* еча */
    {{0xE8, 0xE4, 0xE8}, 24}, /* иди */
    {{0xE1, 0xF9, 0xE8}, 23}, /* бщи */
    {{0xF2, 0xFC, 0xE5}, 23}, /* тье */
    {{0xE1, 0xFA, 0xFF}, 23}, /* бъя */
    {{0xED, 0xE0, 0xF7}, 23}, /* нач */
    {{0xF2, 0xE5, 0xF7}, 23}, /* теч */
    {{0xF3, 0xF0, 0xF1}, 23}, /* урс */
    {{0xE2, 0xE5, 0xF7}, 23}, /* веч */
    {{0xE5, 0xEC, 0xE5}, 23}, /* еме */
    {{0xEE, 0xE1, 0xF5}, 23}, /* обх */
    {{0xE1, 0xF5, 0xEE}, 23}, /* бхо */
    {{0xE4, 0xE0, 0xE5}, 23}, /* дае */
    {{0xF0, 0xE5, 0xE7}, 23}, /* рез */
    {{0xEA, 0xE0, 0xE6}, 22}, /* каж */
    {{0xEE, 0xEA, 0xF3}, 22}, /* оку */
    {{0xE0, 0xEC, 0xE5}, 22}, /* аме */
    {{0xED, 0xE5, 0xE7}, 22}, /* нез */
    {{0xFB, 0xE2, 0xE0}, 22}, /* ыва */
    {{0xF1, 0xE2, 0xFF}, 22}, /* свя */
    {{0xF0, 0xE0, 0xE4}, 22}, /* рад */
    {{0xE5, 0xE7, 0xE0}, 22}, /* еза */
    {{0xE8, 0xE2, 0xE0}, 22}, /* ива */
    {{0xEA, 0xE0, 0xEC}, 22}, /* кам */
    {{0xED, 0xE5, 0xEC}, 22}, /* нем */
    {{0xF2, 0xEA, 0xEE}, 22}, /* тко */
    {{0xE7, 0xE2, 0xE5}, 22}, /* зве */
    {{0xE2, 0xFF, 0xE7}, 22}, /* вяз */
    {{0xFF, 0xF2, 0xE8}, 22}, /* яти */
    {{0xEE, 0xF5, 0xF0}, 22}, /* охр */
    {{0xF0, 0xEE, 0xF2}, 22}, /* рот */
    {{0xEE, 0xEB, 0xE5}, 22}, /* оле */
    {{0xE1, 0xF0, 0xE0}, 22}, /* бра */
    {{0xE0, 0xE5, 0xEC}, 22}, /* аем */
    {{0xEB, 0xE0, 0xF8}, 21}, /* лаш */
    {{0xE8, 0xE7, 0xEC}, 21}, /* изм */
    {{0xE3, 0xF3, 0xF2}, 21}, /* гут */
    {{0xEE, 0xE6, 0xE4}, 21}, /* ожд */
    {{0xEA, 0xE0, 0xEA}, 21}, /* как */
    {{0xEA, 0xE0, 0xF7}, 21}, /* кач */
    {{0xED, 0xE0, 0xEC}, 21}, /* нам */
    {{0xE4, 0xEE, 0xF5}, 21}, /* дох */
    {{0xEE, 0xF5, 0xEE}, 21}, /* охо */
    {{0xFE, 0xF0, 0xE8}, 21}, /* юри */
    {{0xE2, 0xE0, 0xEC}, 21}, /* вам */
    {{0xE7, 0xEC, 0xEE}, 21}, /* змо */
    {{0xE4, 0xEA, 0xE5}, 21}, /* дке */
    {{0xE1, 0xE0, 0xED}, 21}, /* бан */
    {{0xE5, 0xEB, 0xE8}, 21}, /* ели */
    {{0xF0, 0xE8, 0xE7}, 21}, /* риз */
    {{0xEB, 0xED, 0xEE}, 21}, /* лно */
    {{0xE2, 0xFB, 0xF8}, 21}, /* выш */
    {{0xE4, 0xF6, 0xE0}, 21}, /* дца */
    {{0xFF, 0xE4, 0xEA}, 21}, /* ядк */
    {{0xEE, 0xF2, 0xF1}, 21}, /* отс */
    {{0xF2, 0xE5, 0xE9}, 21}, /* тей */
    {{0xE0, 0xED, 0xEA}, 21}, /* анк */
    {{0xED, 0xE5, 0xE3}, 21}, /* нег */
    {{0xF6, 0xE0, 0xF2}, 21}, /* цат */
    {{0xE5, 0xEC, 0xFB}, 21}, /* емы */
    {{0xE2, 0xEE, 0xE5}, 21}, /* вое */
    {{0xE4, 0xE0, 0xF7}, 21}, /* дач */
    {{0xEE, 0xE3, 0xF3}, 21}, /* огу */
    {{0xEB, 0xE6, 0xE5}, 21}, /* лже */
    {{0xF2, 0xED, 0xE8}, 21}, /* тни */
    {{0xE7, 0xE0, 0xE2}, 21}, /* зав */
    {{0xE2, 0xE5, 0xF1}, 21}, /* вес */
    {{0xF1, 0xE0, 0xEC}, 20}, /* сам */
    {{0xE0, 0xF0, 0xED}, 20}, /* арн */
    {{0xF7, 0xED, 0xFB}, 20}, /* чны */
    {{0xF1, 0xF0, 0xE5}, 20}, /* сре */
    {{0xF2, 0xE8, 0xFF}, 20}, /* тия */
    {{0xE8, 0xF1, 0xEB}, 20}, /* исл */
    {{0xD1, 0xF2, 0xF0}, 20}, /* Стр */
    {{0xED, 0xF2, 0xEE}, 20}, /* нто */
    {{0xF3, 0xF2, 0xF0}, 20}, /* утр */
    {{0xE0, 0xF8, 0xE5}, 20}, /* аше */
    {{0xE5, 0xEB, 0xE0}, 20}, /* ела */
    {{0xF3, 0xE4, 0xEE}, 20}, /* удо */
    {{0xE6, 0xE8, 0xE7}, 19}, /* жиз */
    {{0xEF, 0xE8, 0xF1}, 19}, /* пис */
    {{0xE0, 0xE8, 0xEC}, 19}, /* аим */
    {{0xF7, 0xE8, 0xF1}, 19}, /* чис */
    {{0xE5, 0xE6, 0xE8}, 19}, /* ежи */
    {{0xE2, 0xF1, 0xE5}, 19}, /* все */
    {{0xEB, 0xFC, 0xEA}, 19}, /* льк */
    {{0xE0, 0xF2, 0xF3}, 19}, /* ату */
    {{0xF3, 0xE4, 0xE0}, 19}, /* уда */
    {{0xF8, 0xE8, 0xE9}, 19}, /* ший */
    {{0xE7, 0xE0, 0xF0}, 19}, /* зар */
    {{0xE5, 0xE4, 0xED}, 19}, /* едн */
    {{0xE0, 0xE2, 0xF8}, 19}, /* авш */
    {{0xF0, 0xEE, 0xE8}, 19}, /* рои */
    {{0xE8, 0xE4, 0xE0}, 19}, /* ида */
    {{0xE0, 0xF0, 0xEE}, 19}, /* аро */
    {{0xF2, 0xEE, 0xE9}, 19}, /* той */
    {{0xE6, 0xE0, 0xF9}, 19}, /* жащ */
    {{0xE5, 0xF1, 0xEE}, 19}, /* есо */
    {{0xEF, 0xE0, 0xEB}, 19}, /* пал */
    {{0xF9, 0xE0, 0xE5}, 19}, /* щае */
    {{0xF0, 0xFB, 0xE5}, 19}, /* рые */
    {{0xE5, 0xED, 0xFF}, 19}, /* еня */
    {{0xF9, 0xE8, 0xE9}, 19}, /* щий */
    {{0xEB, 0xF3, 0xE3}, 19}, /* луг */
    {{0xFE, 0xF7, 0xE8}, 18}, /* ючи */
    {{0xF3, 0xEB, 0xFC}, 18}, /* уль */
    {{0xEC, 0xFB, 0xF5}, 18}, /* мых */
    {{0xF0, 0xEE, 0xE3}, 18}, /* рог */
    {{0xF1, 0xEE, 0xF5}, 18}, /* сох */
    {{0xEA, 0xEE, 0xE5}, 18}, /* кое */
    {{0xED, 0xF2, 0xF1}, 18}, /* нтс */
    {{0xE0, 0xE7, 0xED}, 18}, /* азн */
    {{0xF2, 0xED, 0xFB}, 18}, /* тны */
    {{0xEE, 0xE4, 0xFF}, 18}, /* одя */
    {{0xEE, 0xE1, 0xED}, 18}, /* обн */
    {{0xE2, 0xFB, 0xE4}, 18}, /* выд */
    {{0xEE, 0xF1, 0xFF}, 18}, /* ося */
    {{0xFC, 0xF2, 0xE0}, 18}, /* ьта */
    {{0xED, 0xFF, 0xFE}, 18}, /* няю */
    {{0xED, 0xE0, 0xF0}, 18}, /* нар */
    {{0xE5, 0xE7, 0xF3}, 18}, /* езу */
    {{0xE0, 0xF1, 0xED}, 18}, /* асн */
    {{0xE7, 0xF3, 0xEB}, 18}, /* зул */
    {{0xF6, 0xE8, 0xEF}, 18}, /* цип */
    {{0xEA, 0xF2, 0xE5}, 18}, /* кте */
    {{0xE4, 0xEE, 0xEF}, 18}, /* доп */
    {{0xED, 0xF6, 0xE8}, 18}, /* нци */
    {{0xF1, 0xEF, 0xE5}, 18}, /* спе */
    {{0xE8, 0xEC, 0xFB}, 18}, /* имы */
    {{0xEC, 0xEE, 0xEC}, 18}, /* мом */
    {{0xEF, 0xE5, 0xF7}, 18}, /* печ */
    {{0xCE, 0xE1, 0xFF}, 18}, /* Обя */
    {{0xCF, 0xF0, 0xE0}, 18}, /* Пра */
    {{0xEE, 0xEB, 0xEE}, 18}, /* оло */
    {{0xF2, 0xF1, 0xEA}, 18}, /* тск */
    {{0xEB, 0xED, 0xE8}, 18}, /* лни */
    {{0xE5, 0xF0, 0xF2}, 18}, /* ерт */
    {{0xE8, 0xF1, 0xFC}, 18}, /* ись */
    {{0xEB, 0xFC, 0xF2}, 18}, /* льт */
    {{0xF1, 0xF3, 0xF2}, 18}, /* сут */
    {{0xE2, 0xEE, 0xE1}, 17}, /* воб */
    {{0xF0, 0xED, 0xFB}, 17}, /* рны */
    {{0xE1, 0xED, 0xFB}, 17}, /* бны */
    {{0xFB, 0xE4, 0xE0}, 17}, /* ыда */
    {{0xFC, 0xE7, 0xF3}, 17}, /* ьзу */
    {{0xE5, 0xE4, 0xEF}, 17}, /* едп */
    {{0xE0, 0xE4, 0xE5}, 17}, /* аде */
    {{0xE8, 0xEF, 0xE0}, 17}, /* ипа */
    {{0xF1, 0xE5, 0xE9}, 17}, /* сей */
    {{0xE5, 0xE5, 0xF1}, 17}, /* еес */
    {{0xEE, 0xE8, 0xE7}, 17}, /* оиз */
    {{0xEE, 0xF1, 0xE2}, 17}, /* осв */
    {{0xE4, 0xE8, 0xE2}, 17}, /* див */
    {{0xED, 0xE0, 0xED}, 17}, /* нан */
    {{0xE5, 0xF2, 0xE0}, 17}, /* ета */
    {{0xE4, 0xED, 0xE5}, 17}, /* дне */
    {{0xE8, 0xEE, 0xE1}, 17}, /* иоб */
    {{0xF3, 0xE5, 0xF2}, 17}, /* ует */
    {{0xED, 0xE0, 0xF5}, 17}, /* нах */
    {{0xF1, 0xEC, 0xE5}, 17}, /* сме */
    {{0xE0, 0xEB, 0xE8}, 17}, /* али */
    {{0xE1, 0xFA, 0xE5}, 17}, /* бъе */
    {{0xEF, 0xE0, 0xF1}, 17}, /* пас */
    {{0xE7, 0xE0, 0xEB}, 17}, /* зал */
    {{0xF0, 0xE6, 0xE0}, 16}, /* ржа */
    {{0xFF, 0xE2, 0xE8}, 16}, /* яви */
    {{0xE6, 0xE0, 0xF2}, 16}, /* жат */
    {{0xE1, 0xEE, 0xE6}, 16}, /* бож */
    {{0xF1, 0xE8, 0xEB}, 16}, /* сил */
    {{0xED, 0xF3, 0xFE}, 16}, /* ную */
    {{0xEF, 0xE5, 0xED}, 16}, /* пен */
    {{0xEC, 0xE0, 0xF2}, 16}, /* мат */
    {{0xEE, 0xED, 0xED}, 16}, /* онн */
    {{0xE2, 0xE8, 0xED}, 16}, /* вин */
    {{0xF2, 0xEA, 0xE8}, 16}, /* тки */
    {{0xF2, 0xEE, 0xF7}, 16}, /* точ */
    {{0xF1, 0xF7, 0xE8}, 16}, /* счи */
    {{0xED, 0xE8, 0xF6}, 16}, /* ниц */
    {{0xF9, 0xE5, 0xE5}, 16}, /* щее */
    {{0xE1, 0xE5, 0xF1}, 16}, /* бес */
    {{0xE0, 0xE4, 0xF6}, 16}, /* адц */
    {{0xCA, 0xEE, 0xEC}, 16}, /* Ком */
    {{0xFC, 0xE8, 0xEC}, 16}, /* ьим */
    {{0xF3, 0xF2, 0xF1}, 16}, /* утс */
    {{0xE0, 0xF7, 0xE8}, 16}, /* ачи */
    {{0xEF, 0xEE, 0xED}, 16}, /* пон */
    {{0xEA, 0xE0, 0xE5}, 16}, /* кае */
    {{0xE8, 0xE3, 0xF0}, 16}, /* игр */
    {{0xE0, 0xEA, 0xE8}, 16}, /* аки */
    {{0xE0, 0xF9, 0xE8}, 16}, /* ащи */
    {{0xEB, 0xFC, 0xF6}, 16}, /* льц */
    {{0xE2, 0xED, 0xEE}, 16}, /* вно */
    {{0xFB, 0xF8, 0xE5}, 15}, /* ыше */
    {{0xCB, 0xE8, 0xF6}, 15}, /* Лиц */
    {{0xFC, 0xE5, 0xE9}, 15}, /* ьей */
    {{0xF8, 0xE5, 0xEC}, 15}, /* шем */
    {{0xF3, 0xE1, 0xEB}, 15}, /* убл */
    {{0xF0, 0xE0, 0xF6}, 15}, /* рац */
    {{0xEA, 0xF3, 0xEC}, 15}, /* кум */
    {{0xF0, 0xE5, 0xE3}, 15}, /* рег */
    {{0xEE, 0xEF, 0xE0}, 15}, /* опа */
    {{0xC2, 0xEE, 0xE7}, 15}, /* Воз */
    {{0xF2, 0xE0, 0xE5}, 15}, /* тае */
    {{0xEE, 0xE1, 0xFB}, 15}, /* обы */
    {{0xE1, 0xEB, 0xE8}, 15}, /* бли */
    {{0xF0, 0xEC, 0xE5}, 15}, /* рме */
    {{0xE2, 0xEE, 0xF1}, 15}, /* вос */
    {{0xE0, 0xF1, 0xE8}, 15}, /* аси */
    {{0xF2, 0xE0, 0xEC}, 15}, /* там */
    {{0xFC, 0xEC, 0xE5}, 15}, /* ьме */
    {{0xEE, 0xE3, 0xE0}, 15}, /* ога */
    {{0xE8, 0xEB, 0xEE}, 15}, /* ило */
    {{0xF1, 0xFC, 0xEC}, 15}, /* сьм */
    {{0xF0, 0xF2, 0xE8}, 15}, /* рти */
    {{0xF2, 0xF1, 0xF3}, 15}, /* тсу */
    {{0xF1, 0xE5, 0xED}, 15}, /* сен */
    {{0xF2, 0xE0, 0xEB}, 15}, /* тал */
    {{0xE4, 0xE0, 0xF0}, 15}, /* дар */
    {{0xE0, 0xEC, 0xEE}, 15}, /* амо */
    {{0xE5, 0xE4, 0xEB}, 15}, /* едл */
    {{0xF1, 0xF3, 0xE1}, 15}, /* суб */
    {{0xE5, 0xE9, 0xF4}, 15}, /* ейф */
    {{0xD5, 0xF0, 0xE0}, 15}, /* Хра */
    {{0xEB, 0xE0, 0xEC}, 14}, /* лам */
    {{0xE0, 0xF0, 0xF3}, 14}, /* ару */
    {{0xE3, 0xE8, 0xF5}, 14}, /* гих */
    {{0xF6, 0xE8, 0xFF}, 14}, /* ция */
    {{0xE4, 0xE0, 0xE2}, 14}, /* дав */
    {{0xEB, 0xE8, 0xF8}, 14}, /* лиш */
    {{0xFE, 0xF7, 0xE0}, 14}, /* юча */
    {{0xE0, 0xED, 0xF1}, 14}, /* анс */
    {{0xEE, 0xE3, 0xF0}, 14}, /* огр */
    {{0xE8, 0xF9, 0xE0}, 14}, /* ища */
    {{0xE5, 0xED, 0xFC}, 14}, /* ень */
    {{0xEE, 0xF2, 0xE8}, 14}, /* оти */
    {{0xE0, 0xE4, 0xFB}, 13}, /* ады */
    {{0xE0, 0xF9, 0xE0}, 13}, /* аща */
    {{0xE2, 0xEE, 0xE8}, 13}, /* вои */
    {{0xE2, 0xFB, 0xEC}, 13}, /* вым */
    {{0xE2, 0xFC, 0xFF}, 13}, /* вья */
    {{0xEA, 0xE8, 0xE5}, 13}, /* кие */
    {{0xEB, 0xE8, 0xF1}, 13}, /* лис */
    {{0xEC, 0xE5, 0xE4}, 13}, /* мед */
    {{0xF2, 0xE8, 0xF5}, 13}, /* тих */
    {{0xE5, 0xF2, 0xEE}, 13}, /* ето */
    {{0xE7, 0xEB, 0xEE}, 13}, /* зло */
    {{0xEE, 0xEF, 0xE5}, 13}, /* опе */
    {{0xF1, 0xE8, 0xEC}, 13}, /* сим */
    {{0xFF, 0xE7, 0xE8}, 13}, /* язи */
    {{0xE8, 0xED, 0xE4}, 13}, /* инд */
    {{0xF7, 0xF3, 0xE6}, 13}, /* чуж */
    {{0xEB, 0xEA, 0xE8}, 13}, /* лки */
    {{0xE4, 0xEF, 0xF0}, 13}, /* дпр */
    {{0xED, 0xE4, 0xE8}, 13}, /* нди */
    {{0xEE, 0xF2, 0xE0}, 13}, /* ота */
    {{0xEE, 0xF2, 0xFB}, 13}, /* оты */
    {{0xEB, 0xE0, 0xF7}, 13}, /* лач */
    {{0xEA, 0xE8, 0xEC}, 13}, /* ким */
    {{0xE8, 0xF1, 0xE8}, 13}, /* иси */
    {{0xE2, 0xE0, 0xEB}, 13}, /* вал */
    {{0xE5, 0xEC, 0xEE}, 13}, /* емо */
    {{0xEF, 0xF3, 0xE1}, 13}, /* пуб */
    {{0xFF, 0xE5, 0xEC}, 13}, /* яем */
    {{0xE1, 0xEE, 0xEB}, 13}, /* бол */
    {{0xED, 0xF2, 0xF3}, 13}, /* нту */
    {{0xED, 0xE5, 0xE9}, 13}, /* ней */
    {{0xED, 0xE0, 0xFF}, 13}, /* ная */
    {{0xE5, 0xF1, 0xE0}, 13}, /* еса */
    {{0xF0, 0xED, 0xEE}, 13}, /* рно */
    {{0xF9, 0xE5, 0xEC}, 13}, /* щем */
    {{0xE0, 0xED, 0xFB}, 13}, /* аны */
    {{0xC4, 0xEE, 0xE2}, 13}, /* Дов */
    {{0xF7, 0xE8, 0xE2}, 13}, /* чив */
    {{0xE2, 0xE8, 0xF1}, 13}, /* вис */
    {{0xEE, 0xEF, 0xEE}, 13}, /* опо */
    {{0xE2, 0xFC, 0xFE}, 13}, /* вью */
    {{0xE0, 0xEB, 0xE0}, 13}, /* ала */
    {{0xEB, 0xE5, 0xE9}, 12}, /* лей */
    {{0xE0, 0xF7, 0xE0}, 12}, /* ача */
    {{0xE5, 0xE7, 0xE2}, 12}, /* езв */
    {{0xE2, 0xE0, 0xFF}, 12}, /* вая */
    {{0xE5, 0xEE, 0xF1}, 12}, /* еос */
    {{0xFF, 0xF9, 0xE8}, 12}, /* ящи */
    {{0xE8, 0xE2, 0xE8}, 12}, /* иви */
    {{0xED, 0xE5, 0xE5}, 12}, /* нее */
    {{0xF2, 0xF0, 0xF3}, 12}, /* тру */
    {{0xF8, 0xE5, 0xE5}, 12}, /* шее */
    {{0xF1, 0xE0, 0xF5}, 12}, /* сах */
    {{0xE8, 0xED, 0xF6}, 12}, /* инц */
    {{0xEE, 0xEC, 0xEF}, 12}, /* омп */
    {{0xF3, 0xE6, 0xEE}, 12}, /* ужо */
    {{0xF3, 0xE0, 0xEB}, 12}, /* уал */
    {{0xED, 0xE0, 0xF2}, 12}, /* нат */
    {{0xE8, 0xE4, 0xF3}, 12}, /* иду */
    {{0xE2, 0xEB, 0xE0}, 12}, /* вла */
    {{0xE7, 0xE2, 0xE0}, 12}, /* зва */
    {{0xEB, 0xE5, 0xE5}, 12}, /* лее */
    {{0xF0, 0xE5, 0xF5}, 12}, /* рех */
    {{0xE6, 0xE4, 0xF3}, 12}, /* жду */
    {{0xEC, 0xE0, 0xEB}, 12}, /* мал */
    {{0xE5, 0xED, 0xF1}, 12}, /* енс */
    {{0xE8, 0xE9, 0xF1}, 12}, /* ийс */
    {{0xEA, 0xEE, 0xEB}, 12}, /* кол */
    {{0xED, 0xE0, 0xE7}, 12}, /* наз */
    {{0xE4, 0xF3, 0xE0}, 12}, /* дуа */
    {{0xEE, 0xED, 0xE8}, 12}, /* они */
    {{0xF1, 0xE5, 0xEC}, 12}, /* сем */
    {{0xE3, 0xEE, 0xE4}, 12}, /* год */
    {{0xEC, 0xE5, 0xE6}, 12}, /* меж */
    {{0xEE, 0xE7, 0xEB}, 12}, /* озл */
    {{0xE2, 0xEC, 0xE5}, 12}, /* вме */
    {{0xF3, 0xE4, 0xE5}, 12}, /* уде */
    {{0xFC, 0xEA, 0xEE}, 12}, /* ько */
    {{0xE5, 0xE2, 0xFB}, 12}, /* евы */
    {{0xE7, 0xE0, 0xEC}, 12}, /* зам */
    {{0xF1, 0xEE, 0xE4}, 12}, /* сод */
    {{0xF0, 0xEE, 0xE5}, 11}, /* рое */
    {{0xEE, 0xF2, 0xE4}, 11}, /* отд */
    {{0xF1, 0xE8, 0xFF}, 11}, /* сия */
    {{0xE8, 0xEA, 0xF3}, 11}, /* ику */
    {{0xFB, 0xEB, 0xE8}, 11}, /* ыли */
    {{0xE3, 0xE8, 0xEC}, 11}, /* гим */
    {{0xED, 0xFC, 0xF8}, 11}, /* ньш */
    {{0xF2, 0xE8, 0xF7}, 11}, /* тич */
    {{0xF0, 0xE0, 0xEB}, 11}, /* рал */
    {{0xF3, 0xF7, 0xE8}, 11}, /* учи */
    {{0xEC, 0xE5, 0xFE}, 11}, /* мею */
    {{0xF2, 0xE5, 0xEA}, 11}, /* тек */
    {{0xEE, 0xE1, 0xF3}, 11}, /* обу */
    {{0xED, 0xED, 0xF3}, 11}, /* нну */
    {{0xED, 0xE5, 0xEF}, 11}, /* неп */
    {{0xE2, 0xE5, 0xEB}, 11}, /* вел */
    {{0xF2, 0xEC, 0xE5}, 11}, /* тме */
    {{0xE1, 0xEE, 0xE3}, 11}, /* бог */
    {{0xEE, 0xF0, 0xE8}, 11}, /* ори */
    {{0xE0, 0xE2, 0xED}, 11}, /* авн */
    {{0xE4, 0xE5, 0xE5}, 11}, /* дее */
    {{0xE6, 0xEE, 0xEC}, 11}, /* жом */
    {{0xC2, 0xF0, 0xE5}, 11}, /* Вре */
    {{0xEC, 0xFB, 0xE5}, 11}, /* мые */
    {{0xFC, 0xF6, 0xE0}, 11}, /* ьца */
    {{0xEE, 0xF6, 0xE5}, 11}, /* оце */
    {{0xE8, 0xF2, 0xFB}, 10}, /* иты */
    {{0xE7, 0xF0, 0xE0}, 10}, /* зра */
    {{0xEE, 0xED, 0xFB}, 10}, /* оны */
    {{0xF0, 0xE5, 0xF8}, 10}, /* реш */
    {{0xF3, 0xF8, 0xE5}, 10}, /* уше */
    {{0xF0, 0xE5, 0xE2}, 10}, /* рев */
    {{0xEE, 0xEF, 0xF3}, 10}, /* опу */
    {{0xFF, 0xF2, 0xFB}, 10}, /* яты */
    {{0xF2, 0xE0, 0xF7}, 10}, /* тач */
    {{0xE5, 0xF0, 0xEE}, 10}, /* еро */
    {{0xE2, 0xEA, 0xEB}, 10}, /* вкл */
    {{0xE7, 0xFB, 0xE2}, 10}, /* зыв */
    {{0xE0, 0xEF, 0xF0}, 10}, /* апр */
    {{0xF0, 0xF3, 0xF8}, 10}, /* руш */
    {{0xCE, 0xF2, 0xE2}, 10}, /* Отв */
    {{0xF0, 0xF1, 0xE0}, 10}, /* рса */
    {{0xE5, 0xEA, 0xF2}, 10}, /* ект */
    {{0xEB, 0xE5, 0xEA}, 10}, /* лек */
    {{0xE5, 0xE5, 0xF2}, 10}, /* еет */
    {{0xEE, 0xEF, 0xEB}, 10}, /* опл */
    {{0xF2, 0xF7, 0xE5}, 10}, /* тче */
    {{0xE3, 0xEE, 0xEC}, 10}, /* гом */
    {{0xF2, 0xEE, 0xE6}, 10}, /* тож */
    {{0xEB, 0xE5, 0xF7}, 10}, /* леч */
    {{0xE5, 0xF2, 0xFB}, 10}, /* еты */
    {{0xEE, 0xE6, 0xE8}, 10}, /* ожи */
    {{0xEC, 0xED, 0xEE}, 10}, /* мно */
    {{0xEC, 0xEE, 0xE9}, 10}, /* мой */
    {{0xF6, 0xE5, 0xEB}, 10}, /* цел */
    {{0xF3, 0xEF, 0xE8}, 10}, /* упи */
    {{0xE0, 0xE5, 0xE2}, 10}, /* аев */
    {{0xEF, 0xEE, 0xEC}, 10}, /* пом */
    {{0xE4, 0xFF, 0xF9}, 10}, /* дящ */
    {{0xF2, 0xF0, 0xE8}, 10}, /* три */
    {{0xF8, 0xE8, 0xE5}, 10}, /* шие */
    {{0xE5, 0xEA, 0xE0}, 10}, /* ека */
    {{0xE5, 0xF8, 0xE5}, 10}, /* еше */
    {{0xE7, 0xE0, 0xE8}, 10}, /* заи */
    {{0xE8, 0xF2, 0xEE}, 10}, /* ито */
    {{0xE7, 0xED, 0xFB}, 10}, /* зны */
    {{0xEE, 0xFF, 0xED}, 10}, /* оян */
    {{0xE8, 0xE6, 0xE5}, 10}, /* иже */
    {{0xE2, 0xED, 0xE5}, 10}, /* вне */
    {{0xF0, 0xF1, 0xF2}, 10}, /* рст */
    {{0xE5, 0xEC, 0xFF}, 10}, /* емя */
    {{0xED, 0xE0, 0xE8}, 10}, /* наи */
    {{0xF2, 0xEE, 0xEB}, 10}, /* тол */
    {{0xEB, 0xE8, 0xF2}, 10}, /* лит */
    {{0xEE, 0xF1, 0xF0}, 10}, /* оср */
    {{0xF2, 0xE4, 0xE5}, 10}, /* тде */
    {{0xE5, 0xEC, 0xE8}, 10}, /* еми */
    {{0xEC, 0xE5, 0xE5}, 10}, /* мее */
    {{0xF0, 0xFB, 0xF5}, 10}, /* рых */
    {{0xED, 0xE8, 0xE2}, 10}, /* нив */
    {{0xE5, 0xF0, 0xF3}, 10}, /* еру */
    {{0xF7, 0xE5, 0xEC}, 10}, /* чем */
    {{0xE4, 0xEE, 0xE1}, 10}, /* доб */
    {{0xE5, 0xEB, 0xEE}, 10}, /* ело */
    {{0xE8, 0xEB, 0xF3}, 10}, /* илу */
    {{0xE0, 0xE4, 0xEB}, 10}, /* адл */
    {{0xE8, 0xF7, 0xF2}, 10}, /* ичт */
    {{0xEC, 0xEB, 0xE5}, 10}, /* мле */
};

static const myencoding_trigram_t myencoding_detect_trigrams_index_x_mac_cyrillic[] = {
    {{0xE5, 0xED, 0xE8}, 991}, /* ени */
    {{0xEE, 0xE3, 0xEE}, 806}, /* ого */
    {{0xF1, 0xF2, 0xE2}, 659}, /* ств */
    {{0xED, 0xE8, 0xDF}, 629}, /* ния */
    {{0xEE, 0xE2, 0xE0}, 566}, /* ова */
    {{0xF2, 0xE5, 0xEB}, 555}, /* тел */
    {{0xF0, 0xE5, 0xE4}, 507}, /* ред */
    {{0xE5, 0xED, 0xED}, 499}, /* енн */
    {{0xEE, 0xE2, 0xEE}, 443}, /* ово */
    {{0xE0, 0xED, 0xE8}, 443}, /* ани */
    {{0xF2, 0xF0, 0xE0}, 429}, /* тра */
    {{0xEE, 0xF1, 0xF2}, 428}, /* ост */
    {{0xED, 0xE8, 0xE5}, 419}, /* ние */
    {{0xED, 0xED, 0xEE}, 412}, /* нно */
    {{0xE0, 0xF5, 0xEE}, 396}, /* ахо */
    {{0xF1, 0xF2, 0xF0}, 392}, /* стр */
    {{0xF0, 0xE0, 0xF5}, 386}, /* рах */
    {{0xF5, 0xEE, 0xE2}, 379}, /* хов */
    {{0xE5, 0xEB, 0xFC}, 365}, /* ель */
    {{0xE3, 0xEE, 0xE2}, 360}, /* гов */
    {{0xE2, 0xEE, 0xF0}, 356}, /* вор */
    {{0xE5, 0xF1, 0xF2}, 349}, /* ест */
    {{0xE0, 0xF2, 0xFC}, 345}, /* ать */
    {{0xF0, 0xE0, 0xE2}, 337}, /* рав */
    {{0xEF, 0xF0, 0xE8}, 330}, /* при */
    {{0xEF, 0xF0, 0xE5}, 323}, /* пре */
    {{0xE4, 0xEE, 0xE3}, 318}, /* дог */
    {{0xED, 0xE5, 0xED}, 310}, /* нен */
    {{0xEF, 0xF0, 0xE0}, 309}, /* пра */
    {{0xE2, 0xE0, 0xED}, 304}, /* ван */
    {{0xE8, 0xF2, 0xE5}, 295}, /* ите */
    {{0xF2, 0xE2, 0xE5}, 281}, /* тве */
    {{0xEB, 0xE5, 0xED}, 266}, /* лен */
    {{0xF1, 0xF2, 0xEE}, 261}, /* сто */
    {{0xF2, 0xE0, 0xF2}, 260}, /* тат */
    {{0xED, 0xED, 0xFB}, 260}, /* нны */
    {{0xEB, 0xFC, 0xED}, 256}, /* льн */
    {{0xE2, 0xEE, 0xE7}, 255}, /* воз */
    {{0xE8, 0xEB, 0xE8}, 254}, /* или */
    {{0xE0, 0xF2, 0xE5}, 252}, /* ате */
    {{0xE5, 0xE3, 0xEE}, 241}, /* его */
    {{0xE5, 0xF2, 0xF1}, 238}, /* етс */
    {{0xED, 0xEE, 0xF1}, 236}, /* нос */
    {{0xF9, 0xE5, 0xF1}, 235}, /* щес */
    {{0xEF, 0xEE, 0xEB}, 232}, /* пол */
    {{0xF0, 0xE0, 0xED}, 231}, /* ран */
    {{0xED, 0xEE, 0xE3}, 230}, /* ног */
    {{0xF1, 0xF2, 0xE0}, 229}, /* ста */
    {{0xF7, 0xE5, 0xED}, 226}, /* чен */
    {{0xF2, 0xF0, 0xE5}, 224}, /* тре */
    {{0xE7, 0xEC, 0xE5}, 214}, /* зме */
    {{0xF3, 0xF9, 0xE5}, 212}, /* уще */
    {{0xF1, 0xF2, 0xE8}, 210}, /* сти */
    {{0xEA, 0xEE, 0xEC}, 207}, /* ком */
    {{0xEE, 0xF0, 0xEE}, 206}, /* оро */
    {{0xE2, 0xEB, 0xE5}, 195}, /* вле */
    {{0xE7, 0xE0, 0xED}, 194}, /* зан */
    {{0xE0, 0xF1, 0xF2}, 193}, /* аст */
    {{0xF2, 0xF1, 0xDF}, 191}, /* тся */
    {{0xF5, 0xF0, 0xE0}, 187}, /* хра */
    {{0xE0, 0xED, 0xED}, 182}, /* анн */
    {{0xE5, 0xF0, 0xE5}, 182}, /* ере */
    {{0xE2, 0xF0, 0xE5}, 178}, /* вре */
    {{0xEE, 0xE2, 0xE5}, 173}, /* ове */
    {{0xFC, 0xED, 0xEE}, 173}, /* ьно */
    {{0xE2, 0xE5, 0xF0}, 172}, /* вер */
    {{0xEC, 0xE5, 0xED}, 170}, /* мен */
    {{0xEB, 0xE8, 0xF6}, 168}, /* лиц */
    {{0xF2, 0xEE, 0xF0}, 167}, /* тор */
    {{0xF0, 0xE5, 0xED}, 167}, /* рен */
    {{0xF9, 0xE5, 0xED}, 165}, /* щен */
    {{0xEE, 0xE7, 0xEC}, 164}, /* озм */
    {{0xE5, 0xE4, 0xE0}, 163}, /* еда */
    {{0xF2, 0xE2, 0xE8}, 159}, /* тви */
    {{0xDF, 0xE7, 0xE0}, 159}, /* яза */
    {{0xE1, 0xDF, 0xE7}, 158}, /* бяз */
    {{0xED, 0xE8, 0xE8}, 153}, /* нии */
    {{0xED, 0xFB, 0xF5}, 153}, /* ных */
    {{0xF2, 0xFC, 0xDF}, 153}, /* тья */
    {{0xEC, 0xE5, 0xF0}, 153}, /* мер */
    {{0xF1, 0xEB, 0xE8}, 150}, /* сли */
    {{0xF2, 0xEE, 0xE2}, 148}, /* тов */
    {{0xF2, 0xE2, 0xE0}, 147}, /* тва */
    {{0xEE, 0xF0, 0xE0}, 146}, /* ора */
    {{0xED, 0xEE, 0xEC}, 144}, /* ном */
    {{0xE4, 0xE5, 0xED}, 144}, /* ден */
    {{0xE0, 0xED, 0xE5}, 142}, /* ане */
    {{0xEA, 0xEE, 0xED}, 141}, /* кон */
    {{0xEB, 0xF3, 0xF7}, 141}, /* луч */
    {{0xEC, 0xF3, 0xF9}, 140}, /* мущ */
    {{0xEE, 0xE1, 0xDF}, 140}, /* обя */
    {{0xE2, 0xE0, 0xF2}, 138}, /* ват */
    {{0xE2, 0xE0, 0xF0}, 137}, /* вар */
    {{0xE5, 0xF9, 0xE5}, 137}, /* еще */
    {{0xEE, 0xF2, 0xF0}, 137}, /* отр */
    {{0xE4, 0xE5, 0xEB}, 137}, /* дел */
    {{0xED, 0xFB, 0xEC}, 136}, /* ным */
    {{0xE8, 0xEC, 0xF3}, 136}, /* иму */
    {{0x91, 0xF2, 0xE0}, 134}, /* Ста */
    {{0xF3, 0xF7, 0xE0}, 133}, /* уча */
    {{0xF2, 0xF1, 0xF2}, 131}, /* тст */
    {{0xE5, 0xEB, 0xDF}, 130}, /* еля */
    {{0xF1, 0xEB, 0xF3}, 130}, /* слу */
    {{0xE7, 0xE0, 0xEA}, 130}, /* зак */
    {{0xF2, 0xEE, 0xDF}, 129}, /* тоя */
    {{0xEE, 0xEC, 0xE8}, 128}, /* оми */
    {{0xEC, 0xE5, 0xF9}, 128}, /* мещ */
    {{0xE5, 0xE4, 0xF3}, 127}, /* еду */
    {{0xE2, 0xE5, 0xED}, 127}, /* вен */
    {{0xED, 0xEE, 0xE2}, 127}, /* нов */
    {{0xED, 0xEE, 0xE5}, 126}, /* ное */
    {{0xEE, 0xF2, 0xE2}, 125}, /* отв */
    {{0xEA, 0xE0, 0xE7}, 125}, /* каз */
    {{0xE0, 0xE5, 0xF2}, 125}, /* ает */
    {{0xF1, 0xEA, 0xEE}, 125}, /* ско */
    {{0xE5, 0xED, 0xF2}, 124}, /* ент */
    {{0xEC, 0xEE, 0xF2}, 123}, /* мот */
    {{0xE0, 0xE2, 0xEB}, 122}, /* авл */
    {{0xF1, 0xEC, 0xEE}, 122}, /* смо */
    {{0xE8, 0xF7, 0xE8}, 121}, /* ичи */
    {{0xE1, 0xFB, 0xF2}, 120}, /* быт */
    {{0xF3, 0xF1, 0xEC}, 118}, /* усм */
    {{0xF1, 0xF1, 0xE8}, 117}, /* сси */
    {{0xE4, 0xF3, 0xF1}, 117}, /* дус */
    {{0xF5, 0xEE, 0xE4}, 117}, /* ход */
    {{0xF0, 0xE8, 0xF7}, 117}, /* рич */
    {{0xF7, 0xE5, 0xF1}, 115}, /* чес */
    {{0xE3, 0xF0, 0xE0}, 114}, /* гра */
    {{0xEF, 0xF0, 0xEE}, 114}, /* про */
    {{0xE4, 0xEE, 0xE2}, 113}, /* дов */
    {{0xE2, 0xE5, 0xF2}, 112}, /* вет */
    {{0xE5, 0xE4, 0xE5}, 112}, /* еде */
    {{0xF8, 0xE5, 0xED}, 111}, /* шен */
    {{0xF7, 0xE8, 0xED}, 110}, /* чин */
    {{0xED, 0xE0, 0xF1}, 109}, /* нас */
    {{0xE8, 0xF2, 0xFC}, 105}, /* ить */
    {{0xF2, 0xE2, 0xEE}, 105}, /* тво */
    {{0xEA, 0xEB, 0xFE}, 104}, /* клю */
    {{0xF0, 0xE8, 0xF2}, 104}, /* рит */
    {{0xF1, 0xF2, 0xFC}, 104}, /* сть */
    {{0xEB, 0xFE, 0xF7}, 104}, /* люч */
    {{0xF2, 0xEE, 0xEC}, 104}, /* том */
    {{0xF1, 0xEB, 0xE5}, 103}, /* сле */
    {{0xF1, 0xEF, 0xEE}, 102}, /* спо */
    {{0xEE, 0xEB, 0xED}, 102}, /* олн */
    {{0xE5, 0xF1, 0xEB}, 102}, /* есл */
    {{0xE5, 0xF0, 0xE8}, 101}, /* ери */
    {{0xED, 0xEE, 0xE9}, 101}, /* ной */
    {{0xF0, 0xEE, 0xEC}, 101}, /* ром */
    {{0xEE, 0xF2, 0xEE}, 99}, /* ото */
    {{0xED, 0xFB, 0xE5}, 99}, /* ные */
    {{0xE7, 0xED, 0xE0}, 99}, /* зна */
    {{0xE2, 0xEB, 0xDF}, 99}, /* вля */
    {{0xF2, 0xE5, 0xF0}, 98}, /* тер */
    {{0xF3, 0xEF, 0xF0}, 97}, /* упр */
    {{0xE0, 0xEA, 0xEE}, 96}, /* ако */
    {{0xEA, 0xEE, 0xE3}, 96}, /* ког */
    {{0xED, 0xFB, 0xE9}, 96}, /* ный */
    {{0xEE, 0xF0, 0xF3}, 96}, /* ору */
    {{0xE5, 0xEB, 0xE5}, 95}, /* еле */
    {{0xE5, 0xF1, 0xEA}, 95}, /* еск */
    {{0xE0, 0xE7, 0xE0}, 95}, /* аза */
    {{0xE9, 0xF1, 0xF2}, 93}, /* йст */
    {{0xEF, 0xEE, 0xF0}, 93}, /* пор */
    {{0xEE, 0xE6, 0xE5}, 92}, /* оже */
    {{0xE8, 0xED, 0xE5}, 91}, /* ине */
    {{0xF9, 0xE5, 0xE9}, 90}, /* щей */
    {{0xE6, 0xE4, 0xE5}, 90}, /* жде */
    {{0xEF, 0xE5, 0xF0}, 89}, /* пер */
    {{0xED, 0xE8, 0xF2}, 89}, /* нит */
    {{0xEE, 0xEB, 0xFC}, 89}, /* оль */
    {{0xE0, 0xE6, 0xE4}, 88}, /* ажд */
    {{0xE6, 0xE5, 0xED}, 87}, /* жен */
    {{0xEB, 0xE0, 0xE4}, 87}, /* лад */
    {{0xE0, 0xEC, 0xE8}, 87}, /* ами */
    {{0xEA, 0xEE, 0xF2}, 86}, /* кот */
    {{0xF7, 0xE0, 0xE5}, 85}, /* чае */
    {{0xE2, 0xE5, 0xF9}, 85}, /* вещ */
    {{0xE2, 0xE8, 0xDF}, 85}, /* вия */
    {{0xDF, 0xF9, 0xE5}, 85}, /* яще */
    {{0xE8, 0xE5, 0xEC}, 85}, /* ием */
    {{0xEA, 0xEB, 0xE0}, 85}, /* кла */
    {{0xE5, 0xE9, 0xF1}, 84}, /* ейс */
    {{0xFB, 0xF2, 0xFC}, 84}, /* ыть */
    {{0xE0, 0xE2, 0xEE}, 84}, /* аво */
    {{0xF0, 0xE0, 0xE6}, 83}, /* раж */
    {{0xEB, 0xFC, 0xF1}, 83}, /* льс */
    {{0xEE, 0xDF, 0xF9}, 82}, /* оящ */
    {{0xE5, 0xED, 0xEE}, 81}, /* ено */
    {{0xE4, 0xF1, 0xF2}, 81}, /* дст */
    {{0xE4, 0xE5, 0xE9}, 80}, /* дей */
    {{0xF0, 0xE5, 0xE1}, 80}, /* реб */
    {{0xFC, 0xF1, 0xF2}, 79}, /* ьст */
    {{0xE5, 0xE4, 0xF1}, 79}, /* едс */
    {{0xE0, 0xF0, 0xE8}, 79}, /* ари */
    {{0xE4, 0xE0, 0xED}, 79}, /* дан */
    {{0xEC, 0xEE, 0xE6}, 78}, /* мож */
    {{0xE8, 0xEC, 0xE5}, 78}, /* име */
    {{0xE8, 0xED, 0xEE}, 78}, /* ино */
    {{0xF0, 0xE8, 0xED}, 77}, /* рин */
    {{0xE4, 0xEE, 0xF1}, 77}, /* дос */
    {{0xEF, 0xEE, 0xF1}, 77}, /* пос */
    {{0xF2, 0xE0, 0xEA}, 77}, /* так */
    {{0xF9, 0xE5, 0xE3}, 77}, /* щег */
    {{0xE4, 0xE0, 0xF2}, 77}, /* дат */
    {{0xEF, 0xEB, 0xE0}, 76}, /* пла */
    {{0xF3, 0xF1, 0xEB}, 76}, /* усл */
    {{0xE8, 0xF6, 0xE0}, 76}, /* ица */
    {{0xF0, 0xEE, 0xE2}, 75}, /* ров */
    {{0xFD, 0xF2, 0xEE}, 75}, /* это */
    {{0xF3, 0xF7, 0xE5}, 74}, /* уче */
    {{0xE4, 0xEE, 0xEB}, 73}, /* дол */
    {{0xFC, 0xED, 0xFB}, 73}, /* ьны */
    {{0xF0, 0xE0, 0xE7}, 73}, /* раз */
    {{0xEC, 0xE8, 0xF1}, 73}, /* мис */
    {{0xE0, 0xED, 0xEE}, 72}, /* ано */
    {{0xF1, 0xF0, 0xEE}, 72}, /* сро */
    {{0xE0, 0xE2, 0xE8}, 72}, /* ави */
    {{0xF2, 0xFC, 0xE8}, 71}, /* тьи */
    {{0xFE, 0xF7, 0xE5}, 70}, /* юче */
    {{0xF1, 0xEA, 0xEB}, 70}, /* скл */
    {{0xE8, 0xF1, 0xF1}, 70}, /* исс */
    {{0xE6, 0xE5, 0xF2}, 69}, /* жет */
    {{0xE5, 0xE4, 0xEE}, 69}, /* едо */
    {{0xEB, 0xE5, 0xE4}, 69}, /* лед */
    {{0xEB, 0xEE, 0xE2}, 69}, /* лов */
    {{0xFE, 0xF9, 0xE8}, 68}, /* ющи */
    {{0xE8, 0xE1, 0xEE}, 68}, /* ибо */
    {{0xEB, 0xE0, 0xF2}, 67}, /* лат */
    {{0xF0, 0xEE, 0xEA}, 67}, /* рок */
    {{0xE0, 0xEA, 0xEB}, 67}, /* акл */
    {{0xF0, 0xE8, 0xF9}, 67}, /* рищ */
    {{0xE1, 0xEE, 0xE2}, 67}, /* бов */
    {{0xE8, 0xF1, 0xEA}, 67}, /* иск */
    {{0xE5, 0xE1, 0xEE}, 67}, /* ебо */
    {{0xEB, 0xFC, 0xE7}, 67}, /* льз */
    {{0xF3, 0xEA, 0xE0}, 67}, /* ука */
    {{0xEB, 0xE8, 0xE1}, 66}, /* либ */
    {{0xEE, 0xEC, 0xF3}, 66}, /* ому */
    {{0xEE, 0xE2, 0xEB}, 66}, /* овл */
    {{0xF2, 0xED, 0xEE}, 65}, /* тно */
    {{0xE2, 0xEE, 0xE9}, 64}, /* вой */
    {{0xF2, 0xEE, 0xE3}, 64}, /* тог */
    {{0xF1, 0xEB, 0xEE}, 64}, /* сло */
    {{0xEE, 0xE7, 0xED}, 64}, /* озн */
    {{0xF1, 0xEE, 0xEE}, 64}, /* соо */
    {{0xE7, 0xE0, 0xF2}, 63}, /* зат */
    {{0xE8, 0xF1, 0xEF}, 63}, /* исп */
    {{0xE0, 0xF7, 0xE5}, 63}, /* аче */
    {{0xED, 0xE8, 0xFE}, 63}, /* нию */
    {{0xEE, 0xED, 0xE5}, 63}, /* оне */
    {{0xEE, 0xEB, 0xE6}, 62}, /* олж */
    {{0xEE, 0xE2, 0xF9}, 61}, /* овщ */
    {{0xF0, 0xE0, 0xF1}, 61}, /* рас */
    {{0xE2, 0xE8, 0xE4}, 61}, /* вид */
    {{0xE2, 0xF9, 0xE8}, 61}, /* вщи */
    {{0xF1, 0xED, 0xEE}, 61}, /* сно */
    {{0xE8, 0xF6, 0xEE}, 61}, /* ицо */
    {{0xE8, 0xF7, 0xE5}, 61}, /* иче */
    {{0xE0, 0xE2, 0xE5}, 61}, /* аве */
    {{0xE3, 0xEB, 0xE0}, 61}, /* гла */
    {{0xF7, 0xE5, 0xF2}, 61}, /* чет */
    {{0xF9, 0xE8, 0xEA}, 61}, /* щик */
    {{0xF0, 0xF3, 0xE3}, 60}, /* руг */
    {{0xF2, 0xE0, 0xED}, 60}, /* тан */
    {{0xE8, 0xEC, 0xEE}, 60}, /* имо */
    {{0xE0, 0xEB, 0xFC}, 60}, /* аль */
    {{0xEE, 0xE2, 0xE8}, 60}, /* ови */
    {{0xE6, 0xE4, 0xE0}, 60}, /* жда */
    {{0xEF, 0xEE, 0xE2}, 60}, /* пов */
    {{0xE5, 0xEC, 0xF3}, 60}, /* ему */
    {{0xDF, 0xF2, 0xE5}, 60}, /* яте */
    {{0xF1, 0xE8, 0xE8}, 59}, /* сии */
    {{0xE1, 0xEE, 0xF2}, 59}, /* бот */
    {{0xE2, 0xFB, 0xEF}, 59}, /* вып */
    {{0xE0, 0xE1, 0xEE}, 59}, /* або */
    {{0xEB, 0xDF, 0xFE}, 59}, /* ляю */
    {{0xF1, 0xF3, 0xF9}, 58}, /* сущ */
    {{0xEE, 0xE4, 0xE5}, 58}, /* оде */
    {{0xE8, 0xED, 0xE8}, 58}, /* ини */
    {{0xF0, 0xE0, 0xF2}, 58}, /* рат */
    {{0xDF, 0xE2, 0xEB}, 58}, /* явл */
    {{0xED, 0xE0, 0xE3}, 57}, /* наг */
    {{0xE4, 0xF0, 0xF3}, 57}, /* дру */
    {{0xF0, 0xE0, 0xE1}, 57}, /* раб */
    {{0xE0, 0xE3, 0xF0}, 57}, /* агр */
    {{0xE8, 0xEE, 0xED}, 57}, /* ион */
    {{0xEC, 0xE5, 0xF1}, 57}, /* мес */
    {{0xE0, 0xF6, 0xE8}, 56}, /* аци */
    {{0xEE, 0xF1, 0xF3}, 56}, /* осу */
    {{0xEA, 0xEE, 0xE9}, 55}, /* кой */
    {{0xF1, 0xE2, 0xEE}, 55}, /* сво */
    {{0xE7, 0xEE, 0xE2}, 55}, /* зов */
    {{0xEE, 0xEF, 0xF0}, 54}, /* опр */
    {{0xF1, 0xEE, 0xE1}, 54}, /* соб */
    {{0xE2, 0xEF, 0xF0}, 54}, /* впр */
    {{0xEB, 0xED, 0xE5}, 54}, /* лне */
    {{0xEE, 0xEC, 0xEC}, 54}, /* омм */
    {{0xE5, 0xF0, 0xE0}, 54}, /* ера */
    {{0xF7, 0xE8, 0xF2}, 54}, /* чит */
    {{0xE5, 0xF0, 0xF7}, 54}, /* ерч */
    {{0xF0, 0xF7, 0xE5}, 54}, /* рче */
    {{0xE0, 0xF2, 0xE8}, 54}, /* ати */
    {{0xED, 0xE8, 0xEA}, 54}, /* ник */
    {{0xEC, 0xEC, 0xE5}, 54}, /* мме */
    {{0xF3, 0xF1, 0xF2}, 53}, /* уст */
    {{0xF2, 0xE5, 0xED}, 53}, /* тен */
    {{0xE2, 0xE5, 0xE4}, 53}, /* вед */
    {{0xF1, 0xEE, 0xE2}, 52}, /* сов */
    {{0xE0, 0xE6, 0xE5}, 52}, /* аже */
    {{0xEE, 0xEA, 0xE0}, 52}, /* ока */
    {{0xFB, 0xEC, 0xE8}, 52}, /* ыми */
    {{0xFE, 0xF2, 0xF1}, 52}, /* ютс */
    {{0xEE, 0xEE, 0xF2}, 52}, /* оот */
    {{0xEC, 0xE8, 0xF2}, 52}, /* мит */
    {{0xDF, 0xFE, 0xF9}, 51}, /* яющ */
    {{0xE2, 0xF8, 0xE5}, 51}, /* вше */
    {{0xF1, 0xE8, 0xEE}, 51}, /* сио */
    {{0xEE, 0xED, 0xEE}, 51}, /* оно */
    {{0xE0, 0xE2, 0xE0}, 51}, /* ава */
    {{0xE0, 0xF9, 0xE5}, 51}, /* аще */
    {{0xEB, 0xDF, 0xE5}, 50}, /* ляе */
    {{0xE5, 0xED, 0xE5}, 50}, /* ене */
    {{0xEE, 0xE4, 0xE8}, 50}, /* оди */
    {{0xEF, 0xF3, 0xED}, 49}, /* пун */
    {{0xEB, 0xE8, 0xF7}, 49}, /* лич */
    {{0xE2, 0xEE, 0xEC}, 49}, /* вом */
    {{0xED, 0xEA, 0xF2}, 49}, /* нкт */
    {{0xED, 0xE5, 0xF1}, 49}, /* нес */
    {{0xE2, 0xE8, 0xEB}, 49}, /* вил */
    {{0xE5, 0xE6, 0xE4}, 49}, /* ежд */
    {{0xF0, 0xE5, 0xF1}, 49}, /* рес */
    {{0xFE, 0xF9, 0xE5}, 49}, /* юще */
    {{0xFC, 0xE7, 0xEE}, 49}, /* ьзо */
    {{0xEF, 0xEE, 0xF2}, 49}, /* пот */
    {{0xF3, 0xED, 0xEA}, 49}, /* унк */
    {{0xF1, 0xF2, 0xE5}, 49}, /* сте */
    {{0xEA, 0xEE, 0xE2}, 49}, /* ков */
    {{0xEE, 0xF1, 0xEB}, 48}, /* осл */
    {{0xDF, 0xE5, 0xF2}, 48}, /* яет */
    {{0x85, 0xF1, 0xEB}, 48}, /* Есл */
    {{0x8F, 0xF0, 0xE8}, 48}, /* При */
    {{0xF2, 0xE0, 0xE2}, 48}, /* тав */
    {{0xED, 0xE5, 0xF0}, 48}, /* нер */
    {{0xF7, 0xED, 0xEE}, 47}, /* чно */
    {{0xEF, 0xEE, 0xE4}, 47}, /* под */
    {{0xED, 0xF2, 0xE0}, 47}, /* нта */
    {{0xE8, 0xF9, 0xE5}, 47}, /* ище */
    {{0xEE, 0xE1, 0xF9}, 47}, /* общ */
    {{0xE0, 0xE7, 0xEC}, 47}, /* азм */
    {{0xE6, 0xED, 0xEE}, 47}, /* жно */
    {{0xE2, 0xE8, 0xE8}, 46}, /* вии */
    {{0xF0, 0xE0, 0xF9}, 46}, /* ращ */
    {{0xEE, 0xF0, 0xE5}, 46}, /* оре */
    {{0xE2, 0xF8, 0xE8}, 46}, /* вши */
    {{0xE5, 0xEA, 0xF1}, 46}, /* екс */
    {{0xE2, 0xEE, 0xE3}, 46}, /* вог */
    {{0xF7, 0xF2, 0xEE}, 46}, /* что */
    {{0xE8, 0xF7, 0xED}, 45}, /* ичн */
    {{0xEB, 0xE5, 0xEC}, 45}, /* лем */
    {{0xEC, 0xEE, 0xE3}, 45}, /* мог */
    {{0xF2, 0xE2, 0xEB}, 45}, /* твл */
    {{0xE4, 0xEB, 0xE5}, 45}, /* дле */
    {{0xE4, 0xEB, 0xDF}, 45}, /* для */
    {{0xF0, 0xE5, 0xF2}, 45}, /* рет */
    {{0xE0, 0xF0, 0xE0}, 45}, /* ара */
    {{0xED, 0xDF, 0xF2}, 44}, /* нят */
    {{0xE5, 0xF7, 0xE5}, 44}, /* ече */
    {{0xEE, 0xF2, 0xE5}, 44}, /* оте */
    {{0xEE, 0xF0, 0xFB}, 44}, /* оры */
    {{0xEE, 0xF1, 0xED}, 43}, /* осн */
    {{0xEE, 0xE1, 0xEE}, 43}, /* обо */
    {{0xEE, 0xE3, 0xEB}, 43}, /* огл */
    {{0xE8, 0xED, 0xFB}, 43}, /* ины */
    {{0xE5, 0xF1, 0xF1}, 43}, /* есс */
    {{0xEE, 0xE1, 0xF0}, 43}, /* обр */
    {{0xEA, 0xF0, 0xE0}, 43}, /* кра */
    {{0xE8, 0xDF, 0xEC}, 43}, /* иям */
    {{0xE0, 0xEB, 0xEE}, 43}, /* ало */
    {{0xF0, 0xF3, 0xF7}, 43}, /* руч */
    {{0xEE, 0xF0, 0xE3}, 43}, /* орг */
    {{0xF7, 0xE0, 0xDF}, 42}, /* чая */
    {{0xED, 0xE8, 0xEC}, 42}, /* ним */
    {{0xE8, 0xE7, 0xED}, 42}, /* изн */
    {{0xEF, 0xEE, 0xEA}, 42}, /* пок */
    {{0xF1, 0xF2, 0xF3}, 42}, /* сту */
    {{0xE5, 0xEB, 0xFE}, 42}, /* елю */
    {{0xF2, 0xE8, 0xF2}, 42}, /* тит */
    {{0xF6, 0xE5, 0xED}, 42}, /* цен */
    {{0xF7, 0xE0, 0xF1}, 42}, /* час */
    {{0xE3, 0xE0, 0xED}, 42}, /* ган */
    {{0xF0, 0xE3, 0xE0}, 42}, /* рга */
    {{0xF1, 0xF2, 0xED}, 42}, /* стн */
    {{0xF0, 0xE5, 0xE6}, 42}, /* реж */
    {{0xF3, 0xEC, 0xEC}, 42}, /* умм */
    {{0xF2, 0xE2, 0xF3}, 41}, /* тву */
    {{0xF2, 0xF3, 0xEF}, 41}, /* туп */
    {{0xF1, 0xEA, 0xE8}, 40}, /* ски */
    {{0xE4, 0xE5, 0xEA}, 40}, /* дек */
    {{0xEB, 0xE5, 0xE6}, 40}, /* леж */
    {{0xE5, 0xF1, 0xE5}, 40}, /* есе */
    {{0xE2, 0xE8, 0xE5}, 40}, /* вие */
    {{0xF2, 0xEA, 0xE0}, 40}, /* тка */
    {{0xE5, 0xEA, 0xF0}, 40}, /* екр */
    {{0xEE, 0xE4, 0xEE}, 40}, /* одо */
    {{0xEA, 0xF1, 0xE0}, 40}, /* кса */
    {{0xF0, 0xE5, 0xEA}, 40}, /* рек */
    {{0xED, 0xF2, 0xE5}, 40}, /* нте */
    {{0xF3, 0xE3, 0xE8}, 40}, /* уги */
    {{0xE1, 0xFB, 0xEB}, 40}, /* был */
    {{0xE8, 0xED, 0xDF}, 40}, /* иня */
    {{0xE5, 0xF9, 0xE8}, 39}, /* ещи */
    {{0xE3, 0xE5, 0xED}, 39}, /* ген */
    {{0x8A, 0xEE, 0xE4}, 39}, /* Код */
    {{0xE4, 0xE8, 0xF2}, 39}, /* дит */
    {{0xF1, 0xF5, 0xEE}, 39}, /* схо */
    {{0xE8, 0xED, 0xF2}, 39}, /* инт */
    {{0xF1, 0xF3, 0xEC}, 39}, /* сум */
    {{0xF0, 0xEE, 0xED}, 39}, /* рон */
    {{0xEE, 0xF2, 0xEA}, 39}, /* отк */
    {{0xE4, 0xEE, 0xEA}, 39}, /* док */
    {{0xE8, 0xEB, 0xE0}, 38}, /* ила */
    {{0xF6, 0xE5, 0xF1}, 38}, /* цес */
    {{0xE8, 0xEA, 0xE0}, 38}, /* ика */
    {{0xE7, 0xED, 0xE8}, 38}, /* зни */
    {{0xEE, 0xE2, 0xFB}, 38}, /* овы */
    {{0xEB, 0xE6, 0xED}, 38}, /* лжн */
    {{0xF3, 0xEF, 0xEB}, 38}, /* упл */
    {{0xE3, 0xE4, 0xE0}, 37}, /* гда */
    {{0xEB, 0xE0, 0xE6}, 37}, /* лаж */
    {{0xE6, 0xE5, 0xE4}, 37}, /* жед */
    {{0xE1, 0xE5, 0xE7}, 37}, /* без */
    {{0xE4, 0xE5, 0xF2}, 37}, /* дет */
    {{0xEE, 0xF0, 0xDF}, 37}, /* оря */
    {{0xF0, 0xEE, 0xF1}, 37}, /* рос */
    {{0xEE, 0xE1, 0xEB}, 37}, /* обл */
    {{0xF6, 0xE8, 0xE8}, 37}, /* ции */
    {{0xE4, 0xEE, 0xEC}, 37}, /* дом */
    {{0xED, 0xF6, 0xE5}, 37}, /* нце */
    {{0xF8, 0xE5, 0xE3}, 37}, /* шег */
    {{0xEB, 0xEE, 0xE6}, 37}, /* лож */
    {{0xEE, 0xED, 0xE0}, 37}, /* она */
    {{0xEE, 0xEA, 0xEB}, 37}, /* окл */
    {{0xEE, 0xE3, 0xE4}, 37}, /* огд */
    {{0xF0, 0xEE, 0xE4}, 37}, /* род */
    {{0xE5, 0xED, 0xE0}, 37}, /* ена */
    {{0xEE, 0xED, 0xF6}, 37}, /* онц */
    {{0xEE, 0xF2, 0xED}, 37}, /* отн */
    {{0xF1, 0xEE, 0xE3}, 37}, /* сог */
    {{0xE5, 0xE2, 0xF8}, 37}, /* евш */
    {{0xE2, 0xE8, 0xF2}, 36}, /* вит */
    {{0xE5, 0xF0, 0xEF}, 36}, /* ерп */
    {{0xEE, 0xE4, 0xE0}, 36}, /* ода */
    {{0xE5, 0xF2, 0xE5}, 36}, /* ете */
    {{0xED, 0xE5, 0xEE}, 36}, /* нео */
    {{0xF0, 0xEF, 0xE5}, 36}, /* рпе */
    {{0xE5, 0xF0, 0xF8}, 36}, /* ерш */
    {{0xE8, 0xEC, 0xE8}, 36}, /* ими */
    {{0xE8, 0xE2, 0xF8}, 36}, /* ивш */
    {{0xFB, 0xEF, 0xEB}, 36}, /* ыпл */
    {{0xEF, 0xE5, 0xE2}, 36}, /* пев */
    {{0xE0, 0xE4, 0xE0}, 36}, /* ада */
    {{0xEC, 0xEE, 0xF1}, 35}, /* мос */
    {{0xEE, 0xE1, 0xF1}, 35}, /* обс */
    {{0xED, 0xE5, 0xE4}, 34}, /* нед */
    {{0xE8, 0xEA, 0xEE}, 34}, /* ико */
    {{0xF9, 0xE8, 0xEC}, 34}, /* щим */
    {{0xE4, 0xE5, 0xF0}, 34}, /* дер */
    {{0xF1, 0xEA, 0xE0}, 34}, /* ска */
    {{0xEE, 0xF0, 0xEC}, 34}, /* орм */
    {{0xF3, 0xEC, 0xE5}, 34}, /* уме */
    {{0xEE, 0xEE, 0xE1}, 34}, /* ооб */
    {{0xF0, 0xE8, 0xF1}, 34}, /* рис */
    {{0xEE, 0xE1, 0xFA}, 33}, /* объ */
    {{0xEE, 0xEB, 0xF3}, 33}, /* олу */
    {{0xFA, 0xDF, 0xE2}, 33}, /* ъяв */
    {{0xF0, 0xE5, 0xEC}, 33}, /* рем */
    {{0xF9, 0xE8, 0xF5}, 33}, /* щих */
    {{0xF3, 0xFE, 0xF9}, 33}, /* ующ */
    {{0xEA, 0xE6, 0xE5}, 33}, /* кже */
    {{0xE8, 0xE4, 0xE5}, 33}, /* иде */
    {{0xE1, 0xF1, 0xF2}, 33}, /* бст */
    {{0xE0, 0xEA, 0xE6}, 33}, /* акж */
    {{0xE2, 0xF3, 0xFE}, 33}, /* вую */
    {{0xE0, 0xF1, 0xF5}, 33}, /* асх */
    {{0xE0, 0xED, 0xE0}, 32}, /* ана */
    {{0xED, 0xE0, 0xE4}, 32}, /* над */
    {{0xEE, 0xE1, 0xE5}, 32}, /* обе */
    {{0xFB, 0xF2, 0xEA}, 32}, /* ытк */
    {{0xFD, 0xF2, 0xE8}, 32}, /* эти */
    {{0xEE, 0xE6, 0xED}, 32}, /* ожн */
    {{0xE0, 0xF2, 0xFB}, 31}, /* аты */
    {{0xF1, 0xE4, 0xE5}, 31}, /* сде */
    {{0xE0, 0xFE, 0xF2}, 31}, /* ают */
    {{0xDF, 0xF2, 0xFC}, 31}, /* ять */
    {{0xEE, 0xDF, 0xF2}, 31}, /* оят */
    {{0xE5, 0xF2, 0xFC}, 31}, /* еть */
    {{0xE0, 0xE3, 0xE5}, 31}, /* аге */
    {{0xF7, 0xF0, 0xE5}, 31}, /* чре */
    {{0xE5, 0xED, 0xFB}, 31}, /* ены */
    {{0xF3, 0xE1, 0xFB}, 31}, /* убы */
    {{0xE8, 0xF1, 0xF2}, 30}, /* ист */
    {{0xDF, 0xFE, 0xF2}, 30}, /* яют */
    {{0xF0, 0xDF, 0xE4}, 30}, /* ряд */
    {{0xE3, 0xEE, 0xF1}, 30}, /* гос */
    {{0xE8, 0xEC, 0xE0}, 30}, /* има */
    {{0xE7, 0xE0, 0xF1}, 30}, /* зас */
    {{0xE0, 0xFE, 0xF9}, 30}, /* ающ */
    {{0xEE, 0xE7, 0xE2}, 30}, /* озв */
    {{0xE5, 0xE4, 0xE8}, 30}, /* еди */
    {{0xEE, 0xEC, 0xE5}, 30}, /* оме */
    {{0xED, 0xE8, 0xE9}, 30}, /* ний */
    {{0xF1, 0xF3, 0xE4}, 30}, /* суд */
    {{0xE7, 0xE4, 0xEE}, 29}, /* здо */
    {{0xF1, 0xE2, 0xE8}, 29}, /* сви */
    {{0xEE, 0xEB, 0xE8}, 29}, /* оли */
    {{0xEE, 0xE2, 0xFC}, 29}, /* овь */
    {{0xE2, 0xE8, 0xE9}, 29}, /* вий */
    {{0xE4, 0xEE, 0xF0}, 29}, /* дор */
    {{0xE4, 0xE5, 0xDF}, 29}, /* дея */
    {{0xE5, 0xDF, 0xF2}, 29}, /* еят */
    {{0xF6, 0xEE, 0xEC}, 29}, /* цом */
    {{0xE8, 0xE7, 0xE0}, 28}, /* иза */
    {{0xF1, 0xF7, 0xE5}, 28}, /* сче */
    {{0xEA, 0xF2, 0xE0}, 28}, /* кта */
    {{0xEE, 0xE4, 0xED}, 28}, /* одн */
    {{0xE1, 0xEB, 0xE0}, 28}, /* бла */
    {{0xEE, 0xE4, 0xEB}, 28}, /* одл */
    {{0xE8, 0xF2, 0xE0}, 28}, /* ита */
    {{0x84, 0xEE, 0xE3}, 28}, /* Дог */
    {{0xEE, 0xF1, 0xEE}, 28}, /* осо */
    {{0xED, 0xEE, 0xF8}, 28}, /* нош */
    {{0xEA, 0xF3, 0xF0}, 28}, /* кур */
    {{0xE8, 0xED, 0xE0}, 28}, /* ина */
    {{0xEE, 0xF8, 0xE5}, 28}, /* оше */
    {{0xED, 0xE0, 0xEB}, 28}, /* нал */
    {{0xED, 0xE8, 0xE7}, 27}, /* низ */
    {{0xE7, 0xE2, 0xF0}, 27}, /* звр */
    {{0xE2, 0xF0, 0xE0}, 27}, /* вра */
    {{0xEB, 0xE5, 0xF2}, 27}, /* лет */
    {{0xE5, 0xF9, 0xFC}, 27}, /* ещь */
    {{0xF0, 0xE8, 0xE4}, 27}, /* рид */
    {{0xE4, 0xED, 0xEE}, 27}, /* дно */
    {{0xF0, 0xE8, 0xEE}, 27}, /* рио */
    {{0xEE, 0xE8, 0xEC}, 27}, /* оим */
    {{0xE5, 0xF0, 0xE6}, 27}, /* ерж */
    {{0xF3, 0xE2, 0xE5}, 26}, /* уве */
    {{0xEE, 0xED, 0xEA}, 26}, /* онк */
    {{0xE5, 0xEB, 0xEA}, 26}, /* елк */
    {{0xEB, 0xE0, 0xE2}, 26}, /* лав */
    {{0xE0, 0xF2, 0xEE}, 26}, /* ато */
    {{0xDF, 0xEC, 0xE8}, 26}, /* ями */
    {{0xEC, 0xEC, 0xFB}, 26}, /* ммы */
    {{0xE5, 0xF1, 0xEF}, 26}, /* есп */
    {{0xED, 0xEA, 0xF3}, 26}, /* нку */
    {{0xE8, 0xF6, 0xF3}, 25}, /* ицу */
    {{0xE4, 0xF1, 0xEA}, 25}, /* дск */
    {{0xED, 0xE8, 0xED}, 25}, /* нин */
    {{0xEF, 0xEB, 0xE5}, 25}, /* пле */
    {{0xF4, 0xEE, 0xF0}, 25}, /* фор */
    {{0xEB, 0xE0, 0xF1}, 25}, /* лас */
    {{0xE4, 0xE8, 0xEC}, 25}, /* дим */
    {{0xE5, 0xF1, 0xDF}, 25}, /* еся */
    {{0xED, 0xE8, 0xF7}, 25}, /* нич */
    {{0xEE, 0xE2, 0xF0}, 25}, /* овр */
    {{0xE2, 0xF1, 0xEB}, 25}, /* всл */
    {{0xF0, 0xF8, 0xE5}, 25}, /* рше */
    {{0xE5, 0xF9, 0xE0}, 25}, /* еща */
    {{0xE6, 0xED, 0xFB}, 25}, /* жны */
    {{0xF0, 0xE8, 0xEC}, 25}, /* рим */
    {{0xE7, 0xE0, 0xF6}, 25}, /* зац */
    {{0xE1, 0xF9, 0xE5}, 25}, /* бще */
    {{0xE0, 0xEA, 0xF2}, 25}, /* акт */
    {{0xE0, 0xE4, 0xF1}, 25}, /* адс */
    {{0xF3, 0xF7, 0xF0}, 25}, /* учр */
    {{0xF9, 0xE8, 0xE5}, 25}, /* щие */
    {{0xE6, 0xE8, 0xF2}, 24}, /* жит */
    {{0xE1, 0xF0, 0xE5}, 24}, /* бре */
    {{0xF3, 0xE3, 0xEE}, 24}, /* уго */
    {{0xE8, 0xDF, 0xF5}, 24}, /* иях */
    {{0xF2, 0xFC, 0xFE}, 24}, /* тью */
    {{0xFC, 0xF1, 0xDF}, 24}, /* ься */
    {{0xE2, 0xEE, 0xE2}, 24}, /* вов */
    {{0xEE, 0xF7, 0xED}, 24}, /* очн */
    {{0xE2, 0xEE, 0xEE}, 24}, /* воо */
    {{0xEE, 0xE4, 0xFB}, 24}, /* оды */
    {{0xEB, 0xEE, 0xE3}, 24}, /* лог */
    {{0xE2, 0xE0, 0xE5}, 24}, /* вае */
    {{0xE0, 0xDF, 0xF5}, 24}, /* аях */
    {{0xF2, 0xFC, 0xF1}, 24}, /* тьс */
    {{0xE4, 0xE8, 0xF7}, 24}, /* дич */
    {{0xEA, 0xE8, 0xF5}, 24}, /* ких */
    {{0xF6, 0xE0, 0xEC}, 24}, /* цам */
    {{0xE8, 0xE7, 0xE2}, 24}, /* изв */
    {{0xF2, 0xE8, 0xE2}, 24}, /* тив */
    {{0xE5, 0xEE, 0xE1}, 24}, /* еоб */
    {{0xF1, 0xEE, 0xF1}, 24}, /* сос */
    {{0xF8, 0xE8, 0xEC}, 24}, /* шим */
    {{0xFB, 0xEF, 0xEE}, 24}, /* ыпо */
    {{0xE5, 0xE6, 0xE0}, 24}, /* ежа */
    {{0xF2, 0xEE, 0xE8}, 24}, /* тои */
    {{0xEA, 0xF2, 0xEE}, 24}, /* кто */
    {{0xE5, 0xF7, 0xE0}, 24}, /* еча */
    {{0xE8, 0xE4, 0xE8}, 24}, /* иди */
    {{0xE1, 0xF9, 0xE8}, 23}, /* бщи */
    {{0xF2, 0xFC, 0xE5}, 23}, /* тье */
    {{0xE1, 0xFA, 0xDF}, 23}, /* бъя */
    {{0xED, 0xE0, 0xF7}, 23}, /* нач */
    {{0xF2, 0xE5, 0xF7}, 23}, /* теч */
    {{0xF3, 0xF0, 0xF1}, 23}, /* урс */
    {{0xE2, 0xE5, 0xF7}, 23}, /* веч */
    {{0xE5, 0xEC, 0xE5}, 23}, /* еме */
    {{0xEE, 0xE1, 0xF5}, 23}, /* обх */
    {{0xE1, 0xF5, 0xEE}, 23}, /* бхо */
    {{0xE4, 0xE0, 0xE5}, 23}, /* дае */
    {{0xF0, 0xE5, 0xE7}, 23}, /* рез */
    {{0xEA, 0xE0, 0xE6}, 22}, /* каж */
    {{0xEE, 0xEA, 0xF3}, 22}, /* оку */
    {{0xE0, 0xEC, 0xE5}, 22}, /* аме */
    {{0xED, 0xE5, 0xE7}, 22}, /* нез */
    {{0xFB, 0xE2, 0xE0}, 22}, /* ыва */
    {{0xF1, 0xE2, 0xDF}, 22}, /* свя */
    {{0xF0, 0xE0, 0xE4}, 22}, /* рад */
    {{0xE5, 0xE7, 0xE0}, 22}, /* еза */
    {{0xE8, 0xE2, 0xE0}, 22}, /* ива */
    {{0xEA, 0xE0, 0xEC}, 22}, /* кам */
    {{0xED, 0xE5, 0xEC}, 22}, /* нем */
    {{0xF2, 0xEA, 0xEE}, 22}, /* тко */
    {{0xE7, 0xE2, 0xE5}, 22}, /* зве */
    {{0xE2, 0xDF, 0xE7}, 22}, /* вяз */
    {{0xDF, 0xF2, 0xE8}, 22}, /* яти */
    {{0xEE, 0xF5, 0xF0}, 22}, /* охр */
    {{0xF0, 0xEE, 0xF2}, 22}, /* рот */
    {{0xEE, 0xEB, 0xE5}, 22}, /* оле */
    {{0xE1, 0xF0, 0xE0}, 22}, /* бра */
    {{0xE0, 0xE5, 0xEC}, 22}, /* аем */
    {{0xEB, 0xE0, 0xF8}, 21}, /* лаш */
    {{0xE8, 0xE7, 0xEC}, 21}, /* изм */
    {{0xE3, 0xF3, 0xF2}, 21}, /* гут */
    {{0xEE, 0xE6, 0xE4}, 21}, /* ожд */
    {{0xEA, 0xE0, 0xEA}, 21}, /* как */
    {{0xEA, 0xE0, 0xF7}, 21}, /* кач */
    {{0xED, 0xE0, 0xEC}, 21}, /* нам */
    {{0xE4, 0xEE, 0xF5}, 21}, /* дох */
    {{0xEE, 0xF5, 0xEE}, 21}, /* охо */
    {{0xFE, 0xF0, 0xE8}, 21}, /* юри */
    {{0xE2, 0xE0, 0xEC}, 21}, /* вам */
    {{0xE7, 0xEC, 0xEE}, 21}, /* змо */
    {{0xE4, 0xEA, 0xE5}, 21}, /* дке */
    {{0xE1, 0xE0, 0xED}, 21}, /* бан */
    {{0xE5, 0xEB, 0xE8}, 21}, /* ели */
    {{0xF0, 0xE8, 0xE7}, 21}, /* риз */
    {{0xEB, 0xED, 0xEE}, 21}, /* лно */
    {{0xE2, 0xFB, 0xF8}, 21}, /* выш */
    {{0xE4, 0xF6, 0xE0}, 21}, /* дца */
    {{0xDF, 0xE4, 0xEA}, 21}, /* ядк */
    {{0xEE, 0xF2, 0xF1}, 21}, /* отс */
    {{0xF2, 0xE5, 0xE9}, 21}, /* тей */
    {{0xE0, 0xED, 0xEA}, 21}, /* анк */
    {{0xED, 0xE5, 0xE3}, 21}, /* нег */
    {{0xF6, 0xE0, 0xF2}, 21}, /* цат */
    {{0xE5, 0xEC, 0xFB}, 21}, /* емы */
    {{0xE2, 0xEE, 0xE5}, 21}, /* вое */
    {{0xE4, 0xE0, 0xF7}, 21}, /* дач */
    {{0xEE, 0xE3, 0xF3}, 21}, /* огу */
    {{0xEB, 0xE6, 0xE5}, 21}, /* лже */
    {{0xF2, 0xED, 0xE8}, 21}, /* тни */
    {{0xE7, 0xE0, 0xE2}, 21}, /* зав */
    {{0xE2, 0xE5, 0xF1}, 21}, /* вес */
    {{0xF1, 0xE0, 0xEC}, 20}, /* сам */
    {{0xE0, 0xF0, 0xED}, 20}, /* арн */
    {{0xF7, 0xED, 0xFB}, 20}, /* чны */
    {{0xF1, 0xF0, 0xE5}, 20}, /* сре */
    {{0xF2, 0xE8, 0xDF}, 20}, /* тия */
    {{0xE8, 0xF1, 0xEB}, 20}, /* исл */
    {{0x91, 0xF2, 0xF0}, 20}, /* Стр */
    {{0xED, 0xF2, 0xEE}, 20}, /* нто */
    {{0xF3, 0xF2, 0xF0}, 20}, /* утр */
    {{0xE0, 0xF8, 0xE5}, 20}, /* аше */
    {{0xE5, 0xEB, 0xE0}, 20}, /* ела */
    {{0xF3, 0xE4, 0xEE}, 20}, /* удо */
    {{0xE6, 0xE8, 0xE7}, 19}, /* жиз */
    {{0xEF, 0xE8, 0xF1}, 19}, /* пис */
    {{0xE0, 0xE8, 0xEC}, 19}, /* аим */
    {{0xF7, 0xE8, 0xF1}, 19}, /* чис */
    {{0xE5, 0xE6, 0xE8}, 19}, /* ежи */
    {{0xE2, 0xF1, 0xE5}, 19}, /* все */
    {{0xEB, 0xFC, 0xEA}, 19}, /* льк */
    {{0xE0, 0xF2, 0xF3}, 19}, /* ату */
    {{0xF3, 0xE4, 0xE0}, 19}, /* уда */
    {{0xF8, 0xE8, 0xE9}, 19}, /* ший */
    {{0xE7, 0xE0, 0xF0}, 19}, /* зар */
    {{0xE5, 0xE4, 0xED}, 19}, /* едн */
    {{0xE0, 0xE2, 0xF8}, 19}, /* авш */
    {{0xF0, 0xEE, 0xE8}, 19}, /* рои */
    {{0xE8, 0xE4, 0xE0}, 19}, /* ида */
    {{0xE0, 0xF0, 0xEE}, 19}, /* аро */
    {{0xF2, 0xEE, 0xE9}, 19}, /* той */
    {{0xE6, 0xE0, 0xF9}, 19}, /* жащ */
    {{0xE5, 0xF1, 0xEE}, 19}, /* есо */
    {{0xEF, 0xE0, 0xEB}, 19}, /* пал */
    {{0xF9, 0xE0, 0xE5}, 19}, /* щае */
    {{0xF0, 0xFB, 0xE5}, 19}, /* рые */
    {{0xE5, 0xED, 0xDF}, 19}, /* еня */
    {{0xF9, 0xE8, 0xE9}, 19}, /* щий */
    {{0xEB, 0xF3, 0xE3}, 19}, /* луг */
    {{0xFE, 0xF7, 0xE8}, 18}, /* ючи */
    {{0xF3, 0xEB, 0xFC}, 18}, /* уль */
    {{0xEC, 0xFB, 0xF5}, 18}, /* мых */
    {{0xF0, 0xEE, 0xE3}, 18}, /* рог */
    {{0xF1, 0xEE, 0xF5}, 18}, /* сох */
    {{0xEA, 0xEE, 0xE5}, 18}, /* кое */
    {{0xED, 0xF2, 0xF1}, 18}, /* нтс */
    {{0xE0, 0xE7, 0xED}, 18}, /* азн */
    {{0xF2, 0xED, 0xFB}, 18}, /* тны */
    {{0xEE, 0xE4, 0xDF}, 18}, /* одя */
    {{0xEE, 0xE1, 0xED}, 18}, /* обн */
    {{0xE2, 0xFB, 0xE4}, 18}, /* выд */
    {{0xEE, 0xF1, 0xDF}, 18}, /* ося */
    {{0xFC, 0xF2, 0xE0}, 18}, /* ьта */
    {{0xED, 0xDF, 0xFE}, 18}, /* няю */
    {{0xED, 0xE0, 0xF0}, 18}, /* нар */
    {{0xE5, 0xE7, 0xF3}, 18}, /* езу */
    {{0xE0, 0xF1, 0xED}, 18}, /* асн */
    {{0xE7, 0xF3, 0xEB}, 18}, /* зул */
    {{0xF6, 0xE8, 0xEF}, 18}, /* цип */
    {{0xEA, 0xF2, 0xE5}, 18}, /* кте */
    {{0xE4, 0xEE, 0xEF}, 18}, /* доп */
    {{0xED, 0xF6, 0xE8}, 18}, /* нци */
    {{0xF1, 0xEF, 0xE5}, 18}, /* спе */
    {{0xE8, 0xEC, 0xFB}, 18}, /* имы */
    {{0xEC, 0xEE, 0xEC}, 18}, /* мом */
    {{0xEF, 0xE5, 0xF7}, 18}, /* печ */
    {{0x8E, 0xE1, 0xDF}, 18}, /* Обя */
    {{0x8F, 0xF0, 0xE0}, 18}, /* Пра */
    {{0xEE, 0xEB, 0xEE}, 18}, /* оло */
    {{0xF2, 0xF1, 0xEA}, 18}, /* тск */
    {{0xEB, 0xED, 0xE8}, 18}, /* лни */
    {{0xE5, 0xF0, 0xF2}, 18}, /* ерт */
    {{0xE8, 0xF1, 0xFC}, 18}, /* ись */
    {{0xEB, 0xFC, 0xF2}, 18}, /* льт */
    {{0xF1, 0xF3, 0xF2}, 18}, /* сут */
    {{0xE2, 0xEE, 0xE1}, 17}, /* воб */
    {{0xF0, 0xED, 0xFB}, 17}, /* рны */
    {{0xE1, 0xED, 0xFB}, 17}, /* бны */
    {{0xFB, 0xE4, 0xE0}, 17}, /* ыда */
    {{0xFC, 0xE7, 0xF3}, 17}, /* ьзу */
    {{0xE5, 0xE4, 0xEF}, 17}, /* едп */
    {{0xE0, 0xE4, 0xE5}, 17}, /* аде */
    {{0xE8, 0xEF, 0xE0}, 17}, /* ипа */
    {{0xF1, 0xE5, 0xE9}, 17}, /* сей */
    {{0xE5, 0xE5, 0xF1}, 17}, /* еес */
    {{0xEE, 0xE8, 0xE7}, 17}, /* оиз */
    {{0xEE, 0xF1, 0xE2}, 17}, /* осв */
    {{0xE4, 0xE8, 0xE2}, 17}, /* див */
    {{0xED, 0xE0, 0xED}, 17}, /* нан */
    {{0xE5, 0xF2, 0xE0}, 17}, /* ета */
    {{0xE4, 0xED, 0xE5}, 17}, /* дне */
    {{0xE8, 0xEE, 0xE1}, 17}, /* иоб */
    {{0xF3, 0xE5, 0xF2}, 17}, /* ует */
    {{0xED, 0xE0, 0xF5}, 17}, /* нах */
    {{0xF1, 0xEC, 0xE5}, 17}, /* сме */
    {{0xE0, 0xEB, 0xE8}, 17}, /* али */
    {{0xE1, 0xFA, 0xE5}, 17}, /* бъе */
    {{0xEF, 0xE0, 0xF1}, 17}, /* пас */
    {{0xE7, 0xE0, 0xEB}, 17}, /* зал */
    {{0xF0, 0xE6, 0xE0}, 16}, /* ржа */
    {{0xDF, 0xE2, 0xE8}, 16}, /* яви */
    {{0xE6, 0xE0, 0xF2}, 16}, /* жат */
    {{0xE1, 0xEE, 0xE6}, 16}, /* бож */
    {{0xF1, 0xE8, 0xEB}, 16}, /* сил */
    {{0xED, 0xF3, 0xFE}, 16}, /* ную */
    {{0xEF, 0xE5, 0xED}, 16}, /* пен */
    {{0xEC, 0xE0, 0xF2}, 16}, /* мат */
    {{0xEE, 0xED, 0xED}, 16}, /* онн */
    {{0xE2, 0xE8, 0xED}, 16}, /* вин */
    {{0xF2, 0xEA, 0xE8}, 16}, /* тки */
    {{0xF2, 0xEE, 0xF7}, 16}, /* точ */
    {{0xF1, 0xF7, 0xE8}, 16}, /* счи */
    {{0xED, 0xE8, 0xF6}, 16}, /* ниц */
    {{0xF9, 0xE5, 0xE5}, 16}, /* щее */
    {{0xE1, 0xE5, 0xF1}, 16}, /* бес */
    {{0xE0, 0xE4, 0xF6}, 16}, /* адц */
    {{0x8A, 0xEE, 0xEC}, 16}, /* Ком */
    {{0xFC, 0xE8, 0xEC}, 16}, /* ьим */
    {{0xF3, 0xF2, 0xF1}, 16}, /* утс */
    {{0xE0, 0xF7, 0xE8}, 16}, /* ачи */
    {{0xEF, 0xEE, 0xED}, 16}, /* пон */
    {{0xEA, 0xE0, 0xE5}, 16}, /* кае */
    {{0xE8, 0xE3, 0xF0}, 16}, /* игр */
    {{0xE0, 0xEA, 0xE8}, 16}, /* аки */
    {{0xE0, 0xF9, 0xE8}, 16}, /* ащи */
    {{0xEB, 0xFC, 0xF6}, 16}, /* льц */
    {{0xE2, 0xED, 0xEE}, 16}, /* вно */
    {{0xFB, 0xF8, 0xE5}, 15}, /* ыше */
    {{0x8B, 0xE8, 0xF6}, 15}, /* Лиц */
    {{0xFC, 0xE5, 0xE9}, 15}, /* ьей */
    {{0xF8, 0xE5, 0xEC}, 15}, /* шем */
    {{0xF3, 0xE1, 0xEB}, 15}, /* убл */
    {{0xF0, 0xE0, 0xF6}, 15}, /* рац */
    {{0xEA, 0xF3, 0xEC}, 15}, /* кум */
    {{0xF0, 0xE5, 0xE3}, 15}, /* рег */
    {{0xEE, 0xEF, 0xE0}, 15}, /* опа */
    {{0x82, 0xEE, 0xE7}, 15}, /* Воз */
    {{0xF2, 0xE0, 0xE5}, 15}, /* тае */
    {{0xEE, 0xE1, 0xFB}, 15}, /* обы */
    {{0xE1, 0xEB, 0xE8}, 15}, /* бли */
    {{0xF0, 0xEC, 0xE5}, 15}, /* рме */
    {{0xE2, 0xEE, 0xF1}, 15}, /* вос */
    {{0xE0, 0xF1, 0xE8}, 15}, /* аси */
    {{0xF2, 0xE0, 0xEC}, 15}, /* там */
    {{0xFC, 0xEC, 0xE5}, 15}, /* ьме */
    {{0xEE, 0xE3, 0xE0}, 15}, /* ога */
    {{0xE8, 0xEB, 0xEE}, 15}, /* ило */
    {{0xF1, 0xFC, 0xEC}, 15}, /* сьм */
    {{0xF0, 0xF2, 0xE8}, 15}, /* рти */
    {{0xF2, 0xF1, 0xF3}, 15}, /* тсу */
    {{0xF1, 0xE5, 0xED}, 15}, /* сен */
    {{0xF2, 0xE0, 0xEB}, 15}, /* тал */
    {{0xE4, 0xE0, 0xF0}, 15}, /* дар */
    {{0xE0, 0xEC, 0xEE}, 15}, /* амо */
    {{0xE5, 0xE4, 0xEB}, 15}, /* едл */
    {{0xF1, 0xF3, 0xE1}, 15}, /* суб */
    {{0xE5, 0xE9, 0xF4}, 15}, /* ейф */
    {{0x95, 0xF0, 0xE0}, 15}, /* Хра */
    {{0xEB, 0xE0, 0xEC}, 14}, /* лам */
    {{0xE0, 0xF0, 0xF3}, 14}, /* ару */
    {{0xE3, 0xE8, 0xF5}, 14}, /* гих */
    {{0xF6, 0xE8, 0xDF}, 14}, /* ция */
    {{0xE4, 0xE0, 0xE2}, 14}, /* дав */
    {{0xEB, 0xE8, 0xF8}, 14}, /* лиш */
    {{0xFE, 0xF7, 0xE0}, 14}, /* юча */
    {{0xE0, 0xED, 0xF1}, 14}, /* анс */
    {{0xEE, 0xE3, 0xF0}, 14}, /* огр */
    {{0xE8, 0xF9, 0xE0}, 14}, /* ища */
    {{0xE5, 0xED, 0xFC}, 14}, /* ень */
    {{0xEE, 0xF2, 0xE8}, 14}, /* оти */
    {{0xE0, 0xE4, 0xFB}, 13}, /* ады */
    {{0xE0, 0xF9, 0xE0}, 13}, /* аща */
    {{0xE2, 0xEE, 0xE8}, 13}, /* вои */
    {{0xE2, 0xFB, 0xEC}, 13}, /* вым */
    {{0xE2, 0xFC, 0xDF}, 13}, /* вья */
    {{0xEA, 0xE8, 0xE5}, 13}, /* кие */
    {{0xEB, 0xE8, 0xF1}, 13}, /* лис */
    {{0xEC, 0xE5, 0xE4}, 13}, /* мед */
    {{0xF2, 0xE8, 0xF5}, 13}, /* тих */
    {{0xE5, 0xF2, 0xEE}, 13}, /* ето */
    {{0xE7, 0xEB, 0xEE}, 13}, /* зло */
    {{0xEE, 0xEF, 0xE5}, 13}, /* опе */
    {{0xF1, 0xE8, 0xEC}, 13}, /* сим */
    {{0xDF, 0xE7, 0xE8}, 13}, /* язи */
    {{0xE8, 0xED, 0xE4}, 13}, /* инд */
    {{0xF7, 0xF3, 0xE6}, 13}, /* чуж */
    {{0xEB, 0xEA, 0xE8}, 13}, /* лки */
    {{0xE4, 0xEF, 0xF0}, 13}, /* дпр */
    {{0xED, 0xE4, 0xE8}, 13}, /* нди */
    {{0xEE, 0xF2, 0xE0}, 13}, /* ота */
    {{0xEE, 0xF2, 0xFB}, 13}, /* оты */
    {{0xEB, 0xE0, 0xF7}, 13}, /* лач */
    {{0xEA, 0xE8, 0xEC}, 13}, /* ким */
    {{0xE8, 0xF1, 0xE8}, 13}, /* иси */
    {{0xE2, 0xE0, 0xEB}, 13}, /* вал */
    {{0xE5, 0xEC, 0xEE}, 13}, /* емо */
    {{0xEF, 0xF3, 0xE1}, 13}, /* пуб */
    {{0xDF, 0xE5, 0xEC}, 13}, /* яем */
    {{0xE1, 0xEE, 0xEB}, 13}, /* бол */
    {{0xED, 0xF2, 0xF3}, 13}, /* нту */
    {{0xED, 0xE5, 0xE9}, 13}, /* ней */
    {{0xED, 0xE0, 0xDF}, 13}, /* ная */
    {{0xE5, 0xF1, 0xE0}, 13}, /* еса */
    {{0xF0, 0xED, 0xEE}, 13}, /* рно */
    {{0xF9, 0xE5, 0xEC}, 13}, /* щем */
    {{0xE0, 0xED, 0xFB}, 13}, /* аны */
    {{0x84, 0xEE, 0xE2}, 13}, /* Дов */
    {{0xF7, 0xE8, 0xE2}, 13}, /* чив */
    {{0xE2, 0xE8, 0xF1}, 13}, /* вис */
    {{0xEE, 0xEF, 0xEE}, 13}, /* опо */
    {{0xE2, 0xFC, 0xFE}, 13}, /* вью */
    {{0xE0, 0xEB, 0xE0}, 13}, /* ала */
    {{0xEB, 0xE5, 0xE9}, 12}, /* лей */
    {{0xE0, 0xF7, 0xE0}, 12}, /* ача */
    {{0xE5, 0xE7, 0xE2}, 12}, /* езв */
    {{0xE2, 0xE0, 0xDF}, 12}, /* вая */
    {{0xE5, 0xEE, 0xF1}, 12}, /* еос */
    {{0xDF, 0xF9, 0xE8}, 12}, /* ящи */
    {{0xE8, 0xE2, 0xE8}, 12}, /* иви */
    {{0xED, 0xE5, 0xE5}, 12}, /* нее */
    {{0xF2, 0xF0, 0xF3}, 12}, /* тру */
    {{0xF8, 0xE5, 0xE5}, 12}, /* шее */
    {{0xF1, 0xE0, 0xF5}, 12}, /* сах */
    {{0xE8, 0xED, 0xF6}, 12}, /* инц */
    {{0xEE, 0xEC, 0xEF}, 12}, /* омп */
    {{0xF3, 0xE6, 0xEE}, 12}, /* ужо */
    {{0xF3, 0xE0, 0xEB}, 12}, /* уал */
    {{0xED, 0xE0, 0xF2}, 12}, /* нат */
    {{0xE8, 0xE4, 0xF3}, 12}, /* иду */
    {{0xE2, 0xEB, 0xE0}, 12}, /* вла */
    {{0xE7, 0xE2, 0xE0}, 12}, /* зва */
    {{0xEB, 0xE5, 0xE5}, 12}, /* лее */
    {{0xF0, 0xE5, 0xF5}, 12}, /* рех */
    {{0xE6, 0xE4, 0xF3}, 12}, /* жду */
    {{0xEC, 0xE0, 0xEB}, 12}, /* мал */
    {{0xE5, 0xED, 0xF1}, 12}, /* енс */
    {{0xE8, 0xE9, 0xF1}, 12}, /* ийс */
    {{0xEA, 0xEE, 0xEB}, 12}, /* кол */
    {{0xED, 0xE0, 0xE7}, 12}, /* наз */
    {{0xE4, 0xF3, 0xE0}, 12}, /* дуа */
    {{0xEE, 0xED, 0xE8}, 12}, /* они */
    {{0xF1, 0xE5, 0xEC}, 12}, /* сем */
    {{0xE3, 0xEE, 0xE4}, 12}, /* год */
    {{0xEC, 0xE5, 0xE6}, 12}, /* меж */
    {{0xEE, 0xE7, 0xEB}, 12}, /* озл */
    {{0xE2, 0xEC, 0xE5}, 12}, /* вме */
    {{0xF3, 0xE4, 0xE5}, 12}, /* уде */
    {{0xFC, 0xEA, 0xEE}, 12}, /* ько */
    {{0xE5, 0xE2, 0xFB}, 12}, /* евы */
    {{0xE7, 0xE0, 0xEC}, 12}, /* зам */
    {{0xF1, 0xEE, 0xE4}, 12}, /* сод */
    {{0xF0, 0xEE, 0xE5}, 11}, /* рое */
    {{0xEE, 0xF2, 0xE4}, 11}, /* отд */
    {{0xF1, 0xE8, 0xDF}, 11}, /* сия */
    {{0xE8, 0xEA, 0xF3}, 11}, /* ику */
    {{0xFB, 0xEB, 0xE8}, 11}, /* ыли */
    {{0xE3, 0xE8, 0xEC}, 11}, /* гим */
    {{0xED, 0xFC, 0xF8}, 11}, /* ньш */
    {{0xF2, 0xE8, 0xF7}, 11}, /* тич */
    {{0xF0, 0xE0, 0xEB}, 11}, /* рал */
    {{0xF3, 0xF7, 0xE8}, 11}, /* учи */
    {{0xEC, 0xE5, 0xFE}, 11}, /* мею */
    {{0xF2, 0xE5, 0xEA}, 11}, /* тек */
    {{0xEE, 0xE1, 0xF3}, 11}, /* обу */
    {{0xED, 0xED, 0xF3}, 11}, /* нну */
    {{0xED, 0xE5, 0xEF}, 11}, /* неп */
    {{0xE2, 0xE5, 0xEB}, 11}, /* вел */
    {{0xF2, 0xEC, 0xE5}, 11}, /* тме */
    {{0xE1, 0xEE, 0xE3}, 11}, /* бог */
    {{0xEE, 0xF0, 0xE8}, 11}, /* ори */
    {{0xE0, 0xE2, 0xED}, 11}, /* авн */
    {{0xE4, 0xE5, 0xE5}, 11}, /* дее */
    {{0xE6, 0xEE, 0xEC}, 11}, /* жом */
    {{0x82, 0xF0, 0xE5}, 11}, /* Вре */
    {{0xEC, 0xFB, 0xE5}, 11}, /* мые */
    {{0xFC, 0xF6, 0xE0}, 11}, /* ьца */
    {{0xEE, 0xF6, 0xE5}, 11}, /* оце */
    {{0xE8, 0xF2, 0xFB}, 10}, /* иты */
    {{0xE7, 0xF0, 0xE0}, 10}, /* зра */
    {{0xEE, 0xED, 0xFB}, 10}, /* оны */
    {{0xF0, 0xE5, 0xF8}, 10}, /* реш */
    {{0xF3, 0xF8, 0xE5}, 10}, /* уше */
    {{0xF0, 0xE5, 0xE2}, 10}, /* рев */
    {{0xEE, 0xEF, 0xF3}, 10}, /* опу */
    {{0xDF, 0xF2, 0xFB}, 10}, /* яты */
    {{0xF2, 0xE0, 0xF7}, 10}, /* тач */
    {{0xE5, 0xF0, 0xEE}, 10}, /* еро */
    {{0xE2, 0xEA, 0xEB}, 10}, /* вкл */
    {{0xE7, 0xFB, 0xE2}, 10}, /* зыв */
    {{0xE0, 0xEF, 0xF0}, 10}, /* апр */
    {{0xF0, 0xF3, 0xF8}, 10}, /* руш */
    {{0x8E, 0xF2, 0xE2}, 10}, /* Отв */
    {{0xF0, 0xF1, 0xE0}, 10}, /* рса */
    {{0xE5, 0xEA, 0xF2}, 10}, /* ект */
    {{0xEB, 0xE5, 0xEA}, 10}, /* лек */
    {{0xE5, 0xE5, 0xF2}, 10}, /* еет */
    {{0xEE, 0xEF, 0xEB}, 10}, /* опл */
    {{0xF2, 0xF7, 0xE5}, 10}, /* тче */
    {{0xE3, 0xEE, 0xEC}, 10}, /* гом */
    {{0xF2, 0xEE, 0xE6}, 10}, /* тож */
    {{0xEB, 0xE5, 0xF7}, 10}, /* леч */
    {{0xE5, 0xF2, 0xFB}, 10}, /* еты */
    {{0xEE, 0xE6, 0xE8}, 10}, /* ожи */
    {{0xEC, 0xED, 0xEE}, 10}, /* мно */
    {{0xEC, 0xEE, 0xE9}, 10}, /* мой */
    {{0xF6, 0xE5, 0xEB}, 10}, /* цел */
    {{0xF3, 0xEF, 0xE8}, 10}, /* упи */
    {{0xE0, 0xE5, 0xE2}, 10}, /* аев */
    {{0xEF, 0xEE, 0xEC}, 10}, /* пом */
    {{0xE4, 0xDF, 0xF9}, 10}, /* дящ */
    {{0xF2, 0xF0, 0xE8}, 10}, /* три */
    {{0xF8, 0xE8, 0xE5}, 10}, /* шие */
    {{0xE5, 0xEA, 0xE0}, 10}, /* ека */
    {{0xE5, 0xF8, 0xE5}, 10}, /* еше */
    {{0xE7, 0xE0, 0xE8}, 10}, /* заи */
    {{0xE8, 0xF2, 0xEE}, 10}, /* ито */
    {{0xE7, 0xED, 0xFB}, 10}, /* зны */
    {{0xEE, 0xDF, 0xED}, 10}, /* оян */
    {{0xE8, 0xE6, 0xE5}, 10}, /* иже */
    {{0xE2, 0xED, 0xE5}, 10}, /* вне */
    {{0xF0, 0xF1, 0xF2}, 10}, /* рст */
    {{0xE5, 0xEC, 0xDF}, 10}, /* емя */
    {{0xED, 0xE0, 0xE8}, 10}, /* наи */
    {{0xF2, 0xEE, 0xEB}, 10}, /* тол */
    {{0xEB, 0xE8, 0xF2}, 10}, /* лит */
    {{0xEE, 0xF1, 0xF0}, 10}, /* оср */
    {{0xF2, 0xE4, 0xE5}, 10}, /* тде */
    {{0xE5, 0xEC, 0xE8}, 10}, /* еми */
    {{0xEC, 0xE5, 0xE5}, 10}, /* мее */
    {{0xF0, 0xFB, 0xF5}, 10}, /* рых */
    {{0xED, 0xE8, 0xE2}, 10}, /* нив */
    {{0xE5, 0xF0, 0xF3}, 10}, /* еру */
    {{0xF7, 0xE5, 0xEC}, 10}, /* чем */
    {{0xE4, 0xEE, 0xE1}, 10}, /* доб */
    {{0xE5, 0xEB, 0xEE}, 10}, /* ело */
    {{0xE8, 0xEB, 0xF3}, 10}, /* илу */
    {{0xE0, 0xE4, 0xEB}, 10}, /* адл */
    {{0xE8, 0xF7, 0xF2}, 10}, /* ичт */
    {{0xEC, 0xEB, 0xE5}, 10}, /* мле */
};

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* MyENCODING_DETECT_RESOURCE_H */
