use common::sense;

our $VERSION = '0.5';

# ABSTRACT: This is a module used to help with a deck of cards.

package Helper::Deck {
    use Moose;
    
    use common::sense;
 
    use List::Util qw(shuffle);
   
    use feature 'say';
   
    sub roll {
        my $self = shift;
        my $sides = shift;
        return(int( rand( $sides ) + 1));
    }
   
    sub random_nick {
        my $self = shift;
        my @nicks = @_;
 
        return((shuffle(@nicks))[-1]);
    }
   
    sub random_name {
        my $self = shift;
        my @names = @_;
 
        return((shuffle(@names))[-1]);
    }
   
    use Data::Dumper;
    
    sub random_scenario {
        my $self = shift;
        my %args = @_;
       
        my @settings = shuffle(@{$args{settings}});
        my @objectives = shuffle(@{$args{objectives}});
        my @antagonists = shuffle(@{$args{antagonists}});
        my @complications = shuffle(@{$args{complications}});
            
        return(
            'setting' => $settings[-1],
            'objective' => $objectives[-1],
            'antagonist' => $antagonists[-1],
            'complication' => $complications[-1],
        );
    }
   
    sub build_deck {
        my $self = shift;
        
        my @suits = (
            'Spades',
            'Hearts',
            'Clubs',
            'Diamonds',
        );
       
        my @faces = (
            'Two',
            'Three',
            'Four',
            'Five',
            'Six',
            'Seven',
            'Eight',
            'Nine',
            'Ten',
            'Jack',
            'Queen',
            'King',
            'Ace',
        );
       
        my @deck;
       
        foreach my $suit (@suits) {
            foreach my $face (@faces) {
                push @deck,\%{{'face' => $face, 'suit' => $suit}};
            }
        }
        
        return(\@deck);
    }
   
    sub shuffle_deck {
        my $self = shift;
        my $deck_ref = shift;
        my @deck = @{$deck_ref};
        my @shuffled_deck = shuffle(@deck);
        return(\@shuffled_deck);
    }
   
    sub top_card {
        my $self = shift;
        my $deck_ref = shift;
        my $card = pop @{$deck_ref};
        return($card);        
    }
   
    sub card_to_string {
        my $self = shift;
        my $card_ref = shift;
        my %card = %{$card_ref};
       
        return($card{face} . ' of ' . $card{suit});
    }
   
    sub draw {
        my $self = shift;
        my $deck_ref = shift;
        my $max = shift;
        my @deck = @{$deck_ref};
        my @draw;
       
        foreach my $item (1 .. $max ) {
            push(@draw,$self->top_card($deck_ref));
        }
       
        return(\@draw);
    }
   
    sub calculate_odds {
        my $self = shift;
        my $deck = shift;
        my $chosen = shift;
              
        my $remaining = scalar @{$deck};
        my $odds = 0;
        foreach my $card (@{$deck}) {
            $odds++ if (($card->{'face'} eq $chosen->{'face'} && $card->{'suit'} eq $chosen->{'suit'}) || ($card->{'face'} eq '' && $card->{'suit'} eq $chosen->{'suit'}) || ($chosen->{'face'} eq $chosen->{'face'} && $card->{'suit'} eq ''));
        }
       
        return($odds . ' in ' . $remaining);
    }
   
    sub build_lc_letter_array {
        my $self = shift;
        return('a' .. 'z');
    }
    
    sub build_uc_letter_array {
        my $self = shift;
        return('A' .. 'Z');
    }
}
 
1;