use strict;
use warnings;

use Test::More tests => 1;

use Algorithm::Easing::Mediator;
use Algorithm::Easing::Bounce;

use Time::HiRes qw(usleep);

use feature 'say';

# total time for eased translation as a real positive integer value
my $d = 2.5;

# begin
my $b = 0;

# change
my $c = 75;

# time passed in seconds as a real positive integer between each frame
my $frame_time = 0.005;

# this example produces traditional 'bounce' output;
my ($bounce_translation,$x_bounce) = (Algorithm::Easing::Mediator->new(kind => Algorithm::Easing::Bounce->new),0);

print 'Testing bounce translation', "\n";
print "\n";
print ' ' x 75;
for (my $t = 0; $t <= $d + $frame_time; $t += $frame_time) {
    $x_bounce = $bounce_translation->ease_out($t,$b,$c,$d);
    print "\b" x 76;
    print '#' x $x_bounce;
    print ' ' x (76 - $x_bounce);
    usleep(sprintf("%i",$frame_time * 1000));
}
print "\n";

ok($x_bounce > 75,'The bounce translation test was successful.')