package Microsoft::AdCenter::V8::ReportingService::BehavioralTargetReportColumn;
# Copyright (C) 2011 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V8::ReportingService::BehavioralTargetReportColumn - Represents "BehavioralTargetReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdDistribution
    AdGroupId
    AdGroupName
    AverageCpc
    AverageCpm
    AveragePosition
    BehavioralId
    CampaignId
    CampaignName
    Clicks
    Ctr
    CurrencyCode
    Impressions
    LanguageAndRegion
    PricingModel
    Spend
    TimePeriod

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AverageCpm {
    return 'AverageCpm';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub BehavioralId {
    return 'BehavioralId';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Clicks {
    return 'Clicks';
}

sub Ctr {
    return 'Ctr';
}

sub CurrencyCode {
    return 'CurrencyCode';
}

sub Impressions {
    return 'Impressions';
}

sub LanguageAndRegion {
    return 'LanguageAndRegion';
}

sub PricingModel {
    return 'PricingModel';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
