#!perl -T

use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;

# Ensure a recent version of Test::Pod::Coverage
my $min_tpc = 1.08;
eval "use Test::Pod::Coverage $min_tpc";
plan skip_all => "Test::Pod::Coverage $min_tpc required for testing POD coverage"
    if $@;

# Test::Pod::Coverage doesn't require a minimum Pod::Coverage version,
# but older versions don't recognize some common documentation styles
my $min_pc = 0.18;
eval "use Pod::Coverage $min_pc, also_private => dl_load_flags;";
plan skip_all => "Pod::Coverage $min_pc required for testing POD coverage"
    if $@;
    #   The test complains there is "1 naked subroutine: dl_load_flags". I have no idea what it is.
    #   Probably, it is something from Inline guts. Anyway, I am not guing to document it, so let
    #   just declare it private.

all_pod_coverage_ok();

# end of file #
