# This file is part of Software-License-OrLaterPack.

# This is dummy main module of Software-License-OrLaterPack, because CPAN
# does not handle well distributions without a main module. Also, it
# documents Software-License-OrLaterPack distribution as a whole.

package Software::License::OrLaterPack;
# ABSTRACT: Set of GNU licenses with "or later" clause
our $VERSION = '0.009'; # VERSION
1;

#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 WHAT?
#pod
#pod C<Software-License-OrLaterPack> is an add-on for C<Software-License>, a set of licenses with "or
#pod later" clause (like C<GPL_3::or_later>). It allows Perl developers (who use C<Dist-Zilla>) to
#pod release their work under the terms of a I<License> version I<N> or (at user option) any later
#pod version.
#pod
#pod C<Software-License-OrLaterPack> is free sotfware.
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 QUICK START
#pod
#pod Install the distribution:
#pod
#pod     $ cpanm Software::License::OrLaterPack
#pod
#pod Then use desired license in your F<dist.ini> file, e. g.:
#pod
#pod     license = GPL_3::or_later
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 LIST OF PROVIDED LICENSES
#pod
#pod =over
#pod
#pod =item C<AGPL_3::or_later>
#pod
#pod =item C<GPL_1::or_later>
#pod
#pod =item C<GPL_2::or_later>
#pod
#pod =item C<GPL_3::or_later>
#pod
#pod =item C<LGPL_2_1::or_later>
#pod
#pod =item C<LGPL_3_0::or_later>
#pod
#pod =back
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 WHY?
#pod
#pod C<Dist-Zilla> is a popular tool for building CPAN distributions. Build process is controlled by
#pod F<dist.ini>, C<Dist-Zilla> configuration file. A distribution author can specify license covering
#pod his work by a line in F<dist.ini> file:
#pod
#pod     license = NAME
#pod
#pod where I<NAME> is a name of module from L<Software::License> hierarchy.
#pod
#pod C<Software-License> is shipped with a set of popular licenses, from C<Apache_1_1> to C<Zlib>,
#pod including GNU licenses (GPL), including their "Affero" and "Lesser" variants.
#pod
#pod So, if a developer wants to release his work under the terms of the GPL version 3, he should write
#pod in his F<dist.ini>:
#pod
#pod     license = GPL_3
#pod
#pod However, L<Free Software Foundation recommends using clause "license version I<N> or (at your
#pod option) any later version"|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>. Unfortunately, C<Software-License>
#pod distribution does not supply (out of the box) a way to express such clause.
#pod
#pod C<Software-License-OrLaterPack> fulfills the lack. If C<Software-License-OrLaterPack> is installed,
#pod a developer can specify in his F<dist.ini>:
#pod
#pod     license = GPL_3::or_later
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 SOURCE VS DISTRIBUTION
#pod
#pod You may face C<Software-License-OrLaterPack> in I<source> or I<distribution> form.
#pod
#pod If you are going to release I<your> Perl distribution under the terms of "upgradable" license, you
#pod will likely be interested in I<using> C<Software-License-OrLaterPack> I<distribution>.
#pod
#pod Since Perl is an interpreting language, modules in the distribution I<look> like sources. Actually,
#pod they are Perl source files. But they are not I<actual> sources, because they are I<built>
#pod (preprocessed or generated) by L<Dist-Zilla>. If you are going to I<develop> (or I<hack>) the
#pod C<Software-License-OrLaterPack> itself, you will likely need the I<actual source>, not
#pod distribution.
#pod
#pod How to distinguish source and distribution:
#pod
#pod =over
#pod
#pod =item *
#pod
#pod Source may contain Mercurial files and directories F<.hgignore>, F<.hgtags>, F<.hg/>, while
#pod distribution should not.
#pod
#pod =item *
#pod
#pod Source should contain files F<dist.ini>, F<weaver.ini>, while distribution may not.
#pod
#pod =item *
#pod
#pod Source should I<not> contain F<xt/> directory, while distribution should.
#pod
#pod =item *
#pod
#pod Name of source directory does I<not> include version, while name of distribution does.
#pod
#pod =back
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 SOURCE
#pod
#pod C<Software-License-OrLaterPack> source is in Mercurial repository hosted on SourceForge. You can
#pod either L<browse the source online|http://sourceforge.net/p/orlaterpack/code> or clone the repository:
#pod
#pod     $ hg clone http://hg.code.sf.net/p/orlaterpack/code Software-License-OrLaterPack
#pod
#pod =head2 Source files
#pod
#pod C<Software-License-OrLaterPack> source files usually include a comment near the top of the file:
#pod
#pod     This file is part of Software-License-OrLaterPack.
#pod
#pod Not all source files are included into distribution. Some source files are used at distribution
#pod build time only, and not required for installation.
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 DISTRIBUTION
#pod
#pod C<Software-License-OrLaterPack> distributions are published on
#pod L<CPAN|https://metacpan.org/release/Software-License-OrLaterPack>.
#pod
#pod =head2 Generated files
#pod
#pod Distribution may cointain files preprocessed or generated by C<Dist-Zilla> and its plugins. Some
#pod generated files are made from C<Software-License-OrLaterPack> source, but some are generated from
#pod third-party templates. Files generated from third-party templates usually include a comment near
#pod the top of the file:
#pod
#pod     This file was generated with NAME
#pod
#pod (where I<NAME> is a name of the plugin generated the file). Such files are I<not> part of
#pod C<Software-License-OrLaterPack> source, and C<Software-License-OrLaterPack> copyright and license
#pod are not applicable to such files.
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 INSTALLING A DISTRIBUTION
#pod
#pod =head2 With cpanm
#pod
#pod C<cpanm> tool is the easiest way to install distribution. It automates downloading, building,
#pod testing, installing, and uninstalling.
#pod
#pod To install the latest version from CPAN:
#pod
#pod     $ cpanm Software::License::OrLaterPack
#pod
#pod To install a specific version (e. g. I<0.007>) from CPAN:
#pod
#pod     $ cpanm Software::License::OrLaterPack@0.007
#pod
#pod To install locally available distribution (e. g. previously downloaded from CPAN or built from
#pod sources):
#pod
#pod     $ cpanm ./Software-License-OrLaterPack-0.007.tar.gz
#pod
#pod To uninstall the distribution:
#pod
#pod     $ cpanm -U Software::License::OrLaterPack
#pod
#pod =head2 Manually
#pod
#pod To install distribution tarball manually (let us assume you have version I<0.007> of the
#pod distribution):
#pod
#pod     $ tar xaf Software-License-OrLaterPack-0.007.tar.gz
#pod     $ cd Software-License-OrLaterPack-0.007
#pod     $ perl Build.PL
#pod     $ ./Build build
#pod     $ ./Build test
#pod     $ ./Build install
#pod
#pod =head2 See also
#pod
#pod L<How to install CPAN modules|http://www.cpan.org/modules/INSTALL.html>
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 HACKING THE SOURCE
#pod
#pod For hacking, you will need Mercurial, Perl interpreter and C<Dist-Zilla> (with some plugins), and
#pod likely C<cpanm> to install missed parts.
#pod
#pod Clone the repository first:
#pod
#pod     $ hg clone http://hg.code.sf.net/p/orlaterpack/code Software-License-OrLaterPack
#pod     $ cd Software-License-OrLaterPack
#pod
#pod To build a distribution from the source, run:
#pod
#pod     $ PERL5LIB=lib:$PERL5LIB dzil build
#pod
#pod If required C<Dist-Zilla> plugins are missed, C<dzil> tool will warn you and show the command to
#pod install all the required plugins.
#pod
#pod To run the tests:
#pod
#pod     $ PERL5LIB=lib:$PERL5LIB dzil test
#pod
#pod To run all the tests, including release tests:
#pod
#pod     $ PERL5LIB=lib:$PERL5LIB dzil test --release
#pod
#pod To install the distribution:
#pod
#pod     $ PERL5LIB=lib:$PERL5LIB dzil install
#pod
#pod or
#pod
#pod     $ cpanm ./Software-License-OrLaterPack-VERSION.tar.gz
#pod
#pod where I<VERSION> is a version of built distribution.
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 BROWSING THE DOCUMENTATION
#pod
#pod =head2 Online
#pod
#pod The easiest way is browsing the documentation L<online at meta::cpan|https://metacpan.org/release/Software-License-OrLaterPack>.
#pod
#pod =head2 Locally installed
#pod
#pod If you have the distribution installed, use C<perldoc> tool to browse locally
#pod installed documentation:
#pod
#pod     $ perldoc Software::License::OrLaterPack
#pod     $ perldoc Software::License::GPL_3::or_later
#pod
#pod =head2 Built from source
#pod
#pod If you are hacking the sources, build C<Software-License-OrLaterPack> first,
#pod then:
#pod
#pod     $ PERL5LIB=lib:$PERL5LIB perldoc Software::License::OrLaterPack
#pod     $ PERL5LIB=lib:$PERL5LIB perldoc Software::License::GPL_3::or_later
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 REPORTING BUGS
#pod
#pod There are few ways to reports bugs and/or provide feedback:
#pod
#pod =head2 Bug tracker at CPAN
#pod
#pod You need a CPAN/PAUSE account in oder to report bugs via the web interface. Alternatively, you may
#pod try to login using your OpenID. (On 2015-04-27 I have logged in successfully with my OpenID
#pod provided by LiveJournal, but I failed to login with OpenID provided by Google. I did not check
#pod other OpenID providers.)
#pod
#pod Browsing bugs does not require authentication.
#pod
#pod =over
#pod
#pod =item *
#pod
#pod L<Report bugs|https://rt.cpan.org/Public/Bug/Report.html?Queue=Software-License-OrLaterPack>
#pod
#pod =item *
#pod
#pod L<Browse bugs|https://rt.cpan.org/Public/Dist/Display.html?Name=Software-License-OrLaterPack>
#pod
#pod =back
#pod
#pod CPAN web page also says:
#pod
#pod     The quickest way to report a bug in Software-License-OrLaterPack is by
#pod     sending email to bug-Software-License-OrLaterPack [at] rt.cpan.org.
#pod
#pod However, I did not try this yet.
#pod
#pod =head2 Bug tracker at SourceForge
#pod
#pod You need a SourceForge account in order to report bugs.
#pod
#pod =over
#pod
#pod =item *
#pod
#pod L<Tickets|http://sourceforge.net/p/orlaterpack/tickets>
#pod
#pod =back
#pod
#pod =head2 Email to author
#pod
#pod As a last resort, email to author: Van de Bugger <van.de.bugger@gmail.com>. Please start message subject
#pod with "Software-License-OrLaterPack: ".
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 GLOSSARY
#pod
#pod =over
#pod
#pod =item CPAN
#pod
#pod Comprehensive Perl Archive Network, a B<large> collection of Perl software and documentation. See
#pod L<cpan.org|http://www.cpan.org>, L<What is
#pod CPAN?|http://www.cpan.org/misc/cpan-faq.html#What_is_CPAN>.
#pod
#pod =item Distribution
#pod
#pod Tarball, containing Perl modules and accompanying files (documentation, metainfo, tests). Usually
#pod distributions are uploaded to CPAN, and can be installed with dedicated tools (C<cpan>, C<cpanm>,
#pod and others).
#pod
#pod =item Module
#pod
#pod Perl library file, usually with C<.pm> suffix. Usually contains one package. See
#pod L<perlmod|http://perldoc.perl.org/perlmod.html#Perl-Modules>.
#pod
#pod =item Package
#pod
#pod Perl language construct. See L<package|http://perldoc.perl.org/functions/package.html> and
#pod L<perlmod|http://perldoc.perl.org/perlmod.html#Packages>.
#pod
#pod =back
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 SEE ALSO
#pod
#pod =over
#pod
#pod =item *
#pod
#pod L<Dist::Zilla>
#pod
#pod =item *
#pod
#pod L<Software::License>
#pod
#pod =item *
#pod
#pod L<Why should programs say “Version 3 of the GPL or any later version”?|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>
#pod
#pod =item *
#pod
#pod L<Software-License-CCpack|https://metacpan.org/release/Software-License-CCpack> — Another add-on
#pod for C<Software-License>, it provides Creative Commons licenses.
#pod
#pod =item *
#pod
#pod L<meta::cpan search request for C<Software::License>|https://metacpan.org/search?q=Software%3A%3ALicense>
#pod
#pod =item *
#pod
#pod L<Software-License-OrLaterPack @ SourceForge|http://sourceforge.net/projects/orlaterpack>
#pod
#pod =item *
#pod
#pod L<Software-License-OrLaterPack @ meta::cpan|https://metacpan.org/release/Software-License-OrLaterPack>
#pod
#pod =item *
#pod
#pod L<Software-License-OrLaterPack @ search.cpan.org|http://search.cpan.org/dist/Software-License-OrLaterPack>
#pod
#pod =back
#pod
#pod =cut
#pod =pod
#pod
#pod =encoding UTF-8
#pod
#pod =head1 COPYRIGHT AND LICENSE
#pod
#pod Copyright © 2015 Van de Bugger
#pod
#pod C<Software-License-OrLaterPack> is free software: you can redistribute it and/or modify it under the
#pod terms of the GNU General Public License as published by the Free Software Foundation, either
#pod version 3 of the License, or (at your option) any later version.
#pod
#pod C<Software-License-OrLaterPack> is distributed in the hope that it will be useful, but WITHOUT ANY
#pod WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#pod See the GNU General Public License for more details.
#pod
#pod You should have received a copy of the GNU General Public License along with
#pod Software-License-OrLaterPack.  If not, see L<http://www.gnu.org/licenses/>.
#pod
#pod C<Software-License-OrLaterPack> I<distribution> may contain files generated by C<Dist-Zilla> and/or
#pod its plugins from third-party templates; copyright and license specified above are I<not> applicable
#pod to that files.
#pod
#pod =cut

__END__

=pod

=encoding UTF-8

=head1 NAME

Software::License::OrLaterPack - Set of GNU licenses with "or later" clause

=head1 VERSION

Version 0.009.

=head1 WHAT?

C<Software-License-OrLaterPack> is an add-on for C<Software-License>, a set of licenses with "or
later" clause (like C<GPL_3::or_later>). It allows Perl developers (who use C<Dist-Zilla>) to
release their work under the terms of a I<License> version I<N> or (at user option) any later
version.

C<Software-License-OrLaterPack> is free sotfware.

=head1 QUICK START

Install the distribution:

    $ cpanm Software::License::OrLaterPack

Then use desired license in your F<dist.ini> file, e. g.:

    license = GPL_3::or_later

=head1 LIST OF PROVIDED LICENSES

=over

=item C<AGPL_3::or_later>

=item C<GPL_1::or_later>

=item C<GPL_2::or_later>

=item C<GPL_3::or_later>

=item C<LGPL_2_1::or_later>

=item C<LGPL_3_0::or_later>

=back

=head1 WHY?

C<Dist-Zilla> is a popular tool for building CPAN distributions. Build process is controlled by
F<dist.ini>, C<Dist-Zilla> configuration file. A distribution author can specify license covering
his work by a line in F<dist.ini> file:

    license = NAME

where I<NAME> is a name of module from L<Software::License> hierarchy.

C<Software-License> is shipped with a set of popular licenses, from C<Apache_1_1> to C<Zlib>,
including GNU licenses (GPL), including their "Affero" and "Lesser" variants.

So, if a developer wants to release his work under the terms of the GPL version 3, he should write
in his F<dist.ini>:

    license = GPL_3

However, L<Free Software Foundation recommends using clause "license version I<N> or (at your
option) any later version"|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>. Unfortunately, C<Software-License>
distribution does not supply (out of the box) a way to express such clause.

C<Software-License-OrLaterPack> fulfills the lack. If C<Software-License-OrLaterPack> is installed,
a developer can specify in his F<dist.ini>:

    license = GPL_3::or_later

=head1 SOURCE VS DISTRIBUTION

You may face C<Software-License-OrLaterPack> in I<source> or I<distribution> form.

If you are going to release I<your> Perl distribution under the terms of "upgradable" license, you
will likely be interested in I<using> C<Software-License-OrLaterPack> I<distribution>.

Since Perl is an interpreting language, modules in the distribution I<look> like sources. Actually,
they are Perl source files. But they are not I<actual> sources, because they are I<built>
(preprocessed or generated) by L<Dist-Zilla>. If you are going to I<develop> (or I<hack>) the
C<Software-License-OrLaterPack> itself, you will likely need the I<actual source>, not
distribution.

How to distinguish source and distribution:

=over

=item *

Source may contain Mercurial files and directories F<.hgignore>, F<.hgtags>, F<.hg/>, while
distribution should not.

=item *

Source should contain files F<dist.ini>, F<weaver.ini>, while distribution may not.

=item *

Source should I<not> contain F<xt/> directory, while distribution should.

=item *

Name of source directory does I<not> include version, while name of distribution does.

=back

=head1 SOURCE

C<Software-License-OrLaterPack> source is in Mercurial repository hosted on SourceForge. You can
either L<browse the source online|http://sourceforge.net/p/orlaterpack/code> or clone the repository:

    $ hg clone http://hg.code.sf.net/p/orlaterpack/code Software-License-OrLaterPack

=head2 Source files

C<Software-License-OrLaterPack> source files usually include a comment near the top of the file:

    This file is part of Software-License-OrLaterPack.

Not all source files are included into distribution. Some source files are used at distribution
build time only, and not required for installation.

=head1 DISTRIBUTION

C<Software-License-OrLaterPack> distributions are published on
L<CPAN|https://metacpan.org/release/Software-License-OrLaterPack>.

=head2 Generated files

Distribution may cointain files preprocessed or generated by C<Dist-Zilla> and its plugins. Some
generated files are made from C<Software-License-OrLaterPack> source, but some are generated from
third-party templates. Files generated from third-party templates usually include a comment near
the top of the file:

    This file was generated with NAME

(where I<NAME> is a name of the plugin generated the file). Such files are I<not> part of
C<Software-License-OrLaterPack> source, and C<Software-License-OrLaterPack> copyright and license
are not applicable to such files.

=head1 INSTALLING A DISTRIBUTION

=head2 With cpanm

C<cpanm> tool is the easiest way to install distribution. It automates downloading, building,
testing, installing, and uninstalling.

To install the latest version from CPAN:

    $ cpanm Software::License::OrLaterPack

To install a specific version (e. g. I<0.007>) from CPAN:

    $ cpanm Software::License::OrLaterPack@0.007

To install locally available distribution (e. g. previously downloaded from CPAN or built from
sources):

    $ cpanm ./Software-License-OrLaterPack-0.007.tar.gz

To uninstall the distribution:

    $ cpanm -U Software::License::OrLaterPack

=head2 Manually

To install distribution tarball manually (let us assume you have version I<0.007> of the
distribution):

    $ tar xaf Software-License-OrLaterPack-0.007.tar.gz
    $ cd Software-License-OrLaterPack-0.007
    $ perl Build.PL
    $ ./Build build
    $ ./Build test
    $ ./Build install

=head2 See also

L<How to install CPAN modules|http://www.cpan.org/modules/INSTALL.html>

=head1 HACKING THE SOURCE

For hacking, you will need Mercurial, Perl interpreter and C<Dist-Zilla> (with some plugins), and
likely C<cpanm> to install missed parts.

Clone the repository first:

    $ hg clone http://hg.code.sf.net/p/orlaterpack/code Software-License-OrLaterPack
    $ cd Software-License-OrLaterPack

To build a distribution from the source, run:

    $ PERL5LIB=lib:$PERL5LIB dzil build

If required C<Dist-Zilla> plugins are missed, C<dzil> tool will warn you and show the command to
install all the required plugins.

To run the tests:

    $ PERL5LIB=lib:$PERL5LIB dzil test

To run all the tests, including release tests:

    $ PERL5LIB=lib:$PERL5LIB dzil test --release

To install the distribution:

    $ PERL5LIB=lib:$PERL5LIB dzil install

or

    $ cpanm ./Software-License-OrLaterPack-VERSION.tar.gz

where I<VERSION> is a version of built distribution.

=head1 BROWSING THE DOCUMENTATION

=head2 Online

The easiest way is browsing the documentation L<online at meta::cpan|https://metacpan.org/release/Software-License-OrLaterPack>.

=head2 Locally installed

If you have the distribution installed, use C<perldoc> tool to browse locally
installed documentation:

    $ perldoc Software::License::OrLaterPack
    $ perldoc Software::License::GPL_3::or_later

=head2 Built from source

If you are hacking the sources, build C<Software-License-OrLaterPack> first,
then:

    $ PERL5LIB=lib:$PERL5LIB perldoc Software::License::OrLaterPack
    $ PERL5LIB=lib:$PERL5LIB perldoc Software::License::GPL_3::or_later

=head1 REPORTING BUGS

There are few ways to reports bugs and/or provide feedback:

=head2 Bug tracker at CPAN

You need a CPAN/PAUSE account in oder to report bugs via the web interface. Alternatively, you may
try to login using your OpenID. (On 2015-04-27 I have logged in successfully with my OpenID
provided by LiveJournal, but I failed to login with OpenID provided by Google. I did not check
other OpenID providers.)

Browsing bugs does not require authentication.

=over

=item *

L<Report bugs|https://rt.cpan.org/Public/Bug/Report.html?Queue=Software-License-OrLaterPack>

=item *

L<Browse bugs|https://rt.cpan.org/Public/Dist/Display.html?Name=Software-License-OrLaterPack>

=back

CPAN web page also says:

    The quickest way to report a bug in Software-License-OrLaterPack is by
    sending email to bug-Software-License-OrLaterPack [at] rt.cpan.org.

However, I did not try this yet.

=head2 Bug tracker at SourceForge

You need a SourceForge account in order to report bugs.

=over

=item *

L<Tickets|http://sourceforge.net/p/orlaterpack/tickets>

=back

=head2 Email to author

As a last resort, email to author: Van de Bugger <van.de.bugger@gmail.com>. Please start message subject
with "Software-License-OrLaterPack: ".

=head1 GLOSSARY

=over

=item CPAN

Comprehensive Perl Archive Network, a B<large> collection of Perl software and documentation. See
L<cpan.org|http://www.cpan.org>, L<What is
CPAN?|http://www.cpan.org/misc/cpan-faq.html#What_is_CPAN>.

=item Distribution

Tarball, containing Perl modules and accompanying files (documentation, metainfo, tests). Usually
distributions are uploaded to CPAN, and can be installed with dedicated tools (C<cpan>, C<cpanm>,
and others).

=item Module

Perl library file, usually with C<.pm> suffix. Usually contains one package. See
L<perlmod|http://perldoc.perl.org/perlmod.html#Perl-Modules>.

=item Package

Perl language construct. See L<package|http://perldoc.perl.org/functions/package.html> and
L<perlmod|http://perldoc.perl.org/perlmod.html#Packages>.

=back

=head1 SEE ALSO

=over

=item *

L<Dist::Zilla>

=item *

L<Software::License>

=item *

L<Why should programs say “Version 3 of the GPL or any later version”?|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>

=item *

L<Software-License-CCpack|https://metacpan.org/release/Software-License-CCpack> — Another add-on
for C<Software-License>, it provides Creative Commons licenses.

=item *

L<meta::cpan search request for C<Software::License>|https://metacpan.org/search?q=Software%3A%3ALicense>

=item *

L<Software-License-OrLaterPack @ SourceForge|http://sourceforge.net/projects/orlaterpack>

=item *

L<Software-License-OrLaterPack @ meta::cpan|https://metacpan.org/release/Software-License-OrLaterPack>

=item *

L<Software-License-OrLaterPack @ search.cpan.org|http://search.cpan.org/dist/Software-License-OrLaterPack>

=back

=head1 AUTHOR

Van de Bugger <van.de.bugger@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright © 2015 Van de Bugger

C<Software-License-OrLaterPack> is free software: you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software Foundation, either
version 3 of the License, or (at your option) any later version.

C<Software-License-OrLaterPack> is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
Software-License-OrLaterPack.  If not, see L<http://www.gnu.org/licenses/>.

C<Software-License-OrLaterPack> I<distribution> may contain files generated by C<Dist-Zilla> and/or
its plugins from third-party templates; copyright and license specified above are I<not> applicable
to that files.

=cut
