##################################################################
#      $URL: http://perlcritic.tigris.org/svn/perlcritic/trunk/Perl-Critic/lib/Perl/Critic/Policy/BuiltinFunctions/ProhibitLvalueSubstr.pm $
#     $Date: 2005-12-30 12:27:26 -0800 (Fri, 30 Dec 2005) $
#   $Author: thaljef $
# $Revision: 182 $
##################################################################

package Perl::Critic::Policy::BuiltinFunctions::ProhibitLvalueSubstr;

use strict;
use warnings;
use Perl::Critic::Utils;
use Perl::Critic::Violation;
use base 'Perl::Critic::Policy';

our $VERSION = '0.13_03';
$VERSION = eval $VERSION; ## no critic;

#----------------------------------------------------------------------------

my $desc = q{Lvalue form of 'substr' used};
my $expl = [ 165 ];

#----------------------------------------------------------------------------

sub default_severity { return $SEVERITY_MEDIUM }
sub applies_to { return 'PPI::Token::Word' }

#----------------------------------------------------------------------------

sub violates {
    my ($self, $elem, $doc) = @_;
    return if !($elem eq 'substr');
    return if is_method_call($elem);
    return if is_hash_key($elem);

    my $sib = $elem;
    my $sev = $self->get_severity();
    while ($sib = $sib->snext_sibling()) {
	next if ! ( $sib->isa( 'PPI::Token::Operator') && $sib eq q{=} );
	return Perl::Critic::Violation->new( $desc, $expl, $sib, $sev );
    }
    return; #ok!
}

1;

#----------------------------------------------------------------------------

__END__

=pod

=head1 NAME

Perl::Critic::Policy::BuiltinFunctions::ProhibitLvalueSubstr

=head1 DESCRIPTION

Conway discourages the use of C<substr()> as an lvalue, instead
recommending that the 4-arg version of C<substr()> be used instead.

  substr($something, 1, 2) = $newvalue;     # not ok
  substr($something, 1, 2, $newvalue);      # ok

=head1 AUTHOR

Graham TerMarsch <graham@howlingfrog.com>

=head1 COPYRIGHT

Copyright (C) 2005 Graham TerMarsch.  All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
