#pragma once
#include <xs/xs.h>
#include <panda/time.h>
#include <panda/date.h>

#if IVSIZE >= 8
#  define SvMIV(x) SvIV(x)
#  define SvMUV(x) SvUV(x)
#else
#  define SvMIV(x) ((int64_t)SvNV(x))
#  define SvMUV(x) ((uint64_t)SvNV(x))
#endif

namespace xs { namespace date {

using namespace panda::time;
using namespace panda::date;

static const char* DATE_CLASS    = "Panda::Date";
static const char* DATEREL_CLASS = "Panda::Date::Rel";
static const char* DATEINT_CLASS = "Panda::Date::Int";

inline const tz* tzget_required (pTHX_ SV* zone) {
    return (zone && SvOK(zone)) ? tzget(SvPV_nolen(zone)) : tzlocal();
}

inline const tz* tzget_optional (pTHX_ SV* zone) {
    return zone ? (SvOK(zone) ? tzget(SvPV_nolen(zone)) : tzlocal()) : NULL;
}

inline void daterel_chkro (pTHX_ const DateRel* THIS) {
    if (THIS->is_const()) croak("Panda::Date::Rel: cannot change this object - it's read only");
}

}}
