package Date::Manip::TZ::amtiju00;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:29 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::amtiju00 - Support for the America/Tijuana time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.02";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,16,11,56],'-07:48:04',[-7,-48,-4],
          'LMT',0,[1922,1,1,7,59,59],[1922,1,1,0,11,55] ],
     ],
   1922 =>
     [
        [ [1922,1,1,8,0,0],[1922,1,1,1,0,0],'-07:00:00',[-7,0,0],
          'MST',0,[1924,1,1,6,59,59],[1923,12,31,23,59,59] ],
     ],
   1924 =>
     [
        [ [1924,1,1,7,0,0],[1923,12,31,23,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1927,6,11,6,59,59],[1927,6,10,22,59,59] ],
     ],
   1927 =>
     [
        [ [1927,6,11,7,0,0],[1927,6,11,0,0,0],'-07:00:00',[-7,0,0],
          'MST',0,[1930,11,15,6,59,59],[1930,11,14,23,59,59] ],
     ],
   1930 =>
     [
        [ [1930,11,15,7,0,0],[1930,11,14,23,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1931,4,1,7,59,59],[1931,3,31,23,59,59] ],
     ],
   1931 =>
     [
        [ [1931,4,1,8,0,0],[1931,4,1,1,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1931,9,30,6,59,59],[1931,9,29,23,59,59] ],
        [ [1931,9,30,7,0,0],[1931,9,29,23,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1942,4,24,7,59,59],[1942,4,23,23,59,59] ],
     ],
   1942 =>
     [
        [ [1942,4,24,8,0,0],[1942,4,24,1,0,0],'-07:00:00',[-7,0,0],
          'PWT',1,[1945,8,14,22,59,59],[1945,8,14,15,59,59] ],
     ],
   1945 =>
     [
        [ [1945,8,14,23,0,0],[1945,8,14,16,0,0],'-07:00:00',[-7,0,0],
          'PPT',1,[1945,11,12,6,59,59],[1945,11,11,23,59,59] ],
        [ [1945,11,12,7,0,0],[1945,11,11,23,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1948,4,5,7,59,59],[1948,4,4,23,59,59] ],
     ],
   1948 =>
     [
        [ [1948,4,5,8,0,0],[1948,4,5,1,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1949,1,14,6,59,59],[1949,1,13,23,59,59] ],
     ],
   1949 =>
     [
        [ [1949,1,14,7,0,0],[1949,1,13,23,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1954,4,25,9,59,59],[1954,4,25,1,59,59] ],
     ],
   1954 =>
     [
        [ [1954,4,25,10,0,0],[1954,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1954,9,26,8,59,59],[1954,9,26,1,59,59] ],
        [ [1954,9,26,9,0,0],[1954,9,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1955,4,24,9,59,59],[1955,4,24,1,59,59] ],
     ],
   1955 =>
     [
        [ [1955,4,24,10,0,0],[1955,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1955,9,25,8,59,59],[1955,9,25,1,59,59] ],
        [ [1955,9,25,9,0,0],[1955,9,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1956,4,29,9,59,59],[1956,4,29,1,59,59] ],
     ],
   1956 =>
     [
        [ [1956,4,29,10,0,0],[1956,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1956,9,30,8,59,59],[1956,9,30,1,59,59] ],
        [ [1956,9,30,9,0,0],[1956,9,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1957,4,28,9,59,59],[1957,4,28,1,59,59] ],
     ],
   1957 =>
     [
        [ [1957,4,28,10,0,0],[1957,4,28,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1957,9,29,8,59,59],[1957,9,29,1,59,59] ],
        [ [1957,9,29,9,0,0],[1957,9,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1958,4,27,9,59,59],[1958,4,27,1,59,59] ],
     ],
   1958 =>
     [
        [ [1958,4,27,10,0,0],[1958,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1958,9,28,8,59,59],[1958,9,28,1,59,59] ],
        [ [1958,9,28,9,0,0],[1958,9,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1959,4,26,9,59,59],[1959,4,26,1,59,59] ],
     ],
   1959 =>
     [
        [ [1959,4,26,10,0,0],[1959,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1959,9,27,8,59,59],[1959,9,27,1,59,59] ],
        [ [1959,9,27,9,0,0],[1959,9,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1960,4,24,9,59,59],[1960,4,24,1,59,59] ],
     ],
   1960 =>
     [
        [ [1960,4,24,10,0,0],[1960,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1960,9,25,8,59,59],[1960,9,25,1,59,59] ],
        [ [1960,9,25,9,0,0],[1960,9,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1976,4,25,9,59,59],[1976,4,25,1,59,59] ],
     ],
   1976 =>
     [
        [ [1976,4,25,10,0,0],[1976,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1976,10,31,8,59,59],[1976,10,31,1,59,59] ],
        [ [1976,10,31,9,0,0],[1976,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1977,4,24,9,59,59],[1977,4,24,1,59,59] ],
     ],
   1977 =>
     [
        [ [1977,4,24,10,0,0],[1977,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1977,10,30,8,59,59],[1977,10,30,1,59,59] ],
        [ [1977,10,30,9,0,0],[1977,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1978,4,30,9,59,59],[1978,4,30,1,59,59] ],
     ],
   1978 =>
     [
        [ [1978,4,30,10,0,0],[1978,4,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1978,10,29,8,59,59],[1978,10,29,1,59,59] ],
        [ [1978,10,29,9,0,0],[1978,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1979,4,29,9,59,59],[1979,4,29,1,59,59] ],
     ],
   1979 =>
     [
        [ [1979,4,29,10,0,0],[1979,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1979,10,28,8,59,59],[1979,10,28,1,59,59] ],
        [ [1979,10,28,9,0,0],[1979,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1980,4,27,9,59,59],[1980,4,27,1,59,59] ],
     ],
   1980 =>
     [
        [ [1980,4,27,10,0,0],[1980,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1980,10,26,8,59,59],[1980,10,26,1,59,59] ],
        [ [1980,10,26,9,0,0],[1980,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1981,4,26,9,59,59],[1981,4,26,1,59,59] ],
     ],
   1981 =>
     [
        [ [1981,4,26,10,0,0],[1981,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1981,10,25,8,59,59],[1981,10,25,1,59,59] ],
        [ [1981,10,25,9,0,0],[1981,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1982,4,25,9,59,59],[1982,4,25,1,59,59] ],
     ],
   1982 =>
     [
        [ [1982,4,25,10,0,0],[1982,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1982,10,31,8,59,59],[1982,10,31,1,59,59] ],
        [ [1982,10,31,9,0,0],[1982,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1983,4,24,9,59,59],[1983,4,24,1,59,59] ],
     ],
   1983 =>
     [
        [ [1983,4,24,10,0,0],[1983,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1983,10,30,8,59,59],[1983,10,30,1,59,59] ],
        [ [1983,10,30,9,0,0],[1983,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1984,4,29,9,59,59],[1984,4,29,1,59,59] ],
     ],
   1984 =>
     [
        [ [1984,4,29,10,0,0],[1984,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1984,10,28,8,59,59],[1984,10,28,1,59,59] ],
        [ [1984,10,28,9,0,0],[1984,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1985,4,28,9,59,59],[1985,4,28,1,59,59] ],
     ],
   1985 =>
     [
        [ [1985,4,28,10,0,0],[1985,4,28,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1985,10,27,8,59,59],[1985,10,27,1,59,59] ],
        [ [1985,10,27,9,0,0],[1985,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1986,4,27,9,59,59],[1986,4,27,1,59,59] ],
     ],
   1986 =>
     [
        [ [1986,4,27,10,0,0],[1986,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1986,10,26,8,59,59],[1986,10,26,1,59,59] ],
        [ [1986,10,26,9,0,0],[1986,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1987,4,5,9,59,59],[1987,4,5,1,59,59] ],
     ],
   1987 =>
     [
        [ [1987,4,5,10,0,0],[1987,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1987,10,25,8,59,59],[1987,10,25,1,59,59] ],
        [ [1987,10,25,9,0,0],[1987,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1988,4,3,9,59,59],[1988,4,3,1,59,59] ],
     ],
   1988 =>
     [
        [ [1988,4,3,10,0,0],[1988,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1988,10,30,8,59,59],[1988,10,30,1,59,59] ],
        [ [1988,10,30,9,0,0],[1988,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1989,4,2,9,59,59],[1989,4,2,1,59,59] ],
     ],
   1989 =>
     [
        [ [1989,4,2,10,0,0],[1989,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1989,10,29,8,59,59],[1989,10,29,1,59,59] ],
        [ [1989,10,29,9,0,0],[1989,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1990,4,1,9,59,59],[1990,4,1,1,59,59] ],
     ],
   1990 =>
     [
        [ [1990,4,1,10,0,0],[1990,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1990,10,28,8,59,59],[1990,10,28,1,59,59] ],
        [ [1990,10,28,9,0,0],[1990,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1991,4,7,9,59,59],[1991,4,7,1,59,59] ],
     ],
   1991 =>
     [
        [ [1991,4,7,10,0,0],[1991,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1991,10,27,8,59,59],[1991,10,27,1,59,59] ],
        [ [1991,10,27,9,0,0],[1991,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1992,4,5,9,59,59],[1992,4,5,1,59,59] ],
     ],
   1992 =>
     [
        [ [1992,4,5,10,0,0],[1992,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1992,10,25,8,59,59],[1992,10,25,1,59,59] ],
        [ [1992,10,25,9,0,0],[1992,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1993,4,4,9,59,59],[1993,4,4,1,59,59] ],
     ],
   1993 =>
     [
        [ [1993,4,4,10,0,0],[1993,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1993,10,31,8,59,59],[1993,10,31,1,59,59] ],
        [ [1993,10,31,9,0,0],[1993,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1994,4,3,9,59,59],[1994,4,3,1,59,59] ],
     ],
   1994 =>
     [
        [ [1994,4,3,10,0,0],[1994,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1994,10,30,8,59,59],[1994,10,30,1,59,59] ],
        [ [1994,10,30,9,0,0],[1994,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1995,4,2,9,59,59],[1995,4,2,1,59,59] ],
     ],
   1995 =>
     [
        [ [1995,4,2,10,0,0],[1995,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1995,10,29,8,59,59],[1995,10,29,1,59,59] ],
        [ [1995,10,29,9,0,0],[1995,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1996,4,7,9,59,59],[1996,4,7,1,59,59] ],
     ],
   1996 =>
     [
        [ [1996,4,7,10,0,0],[1996,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1996,10,27,8,59,59],[1996,10,27,1,59,59] ],
        [ [1996,10,27,9,0,0],[1996,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1997,4,6,9,59,59],[1997,4,6,1,59,59] ],
     ],
   1997 =>
     [
        [ [1997,4,6,10,0,0],[1997,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1997,10,26,8,59,59],[1997,10,26,1,59,59] ],
        [ [1997,10,26,9,0,0],[1997,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1998,4,5,9,59,59],[1998,4,5,1,59,59] ],
     ],
   1998 =>
     [
        [ [1998,4,5,10,0,0],[1998,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1998,10,25,8,59,59],[1998,10,25,1,59,59] ],
        [ [1998,10,25,9,0,0],[1998,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1999,4,4,9,59,59],[1999,4,4,1,59,59] ],
     ],
   1999 =>
     [
        [ [1999,4,4,10,0,0],[1999,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1999,10,31,8,59,59],[1999,10,31,1,59,59] ],
        [ [1999,10,31,9,0,0],[1999,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2000,4,2,9,59,59],[2000,4,2,1,59,59] ],
     ],
   2000 =>
     [
        [ [2000,4,2,10,0,0],[2000,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2000,10,29,8,59,59],[2000,10,29,1,59,59] ],
        [ [2000,10,29,9,0,0],[2000,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2001,4,1,9,59,59],[2001,4,1,1,59,59] ],
     ],
   2001 =>
     [
        [ [2001,4,1,10,0,0],[2001,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2001,10,28,8,59,59],[2001,10,28,1,59,59] ],
        [ [2001,10,28,9,0,0],[2001,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2002,4,7,9,59,59],[2002,4,7,1,59,59] ],
     ],
   2002 =>
     [
        [ [2002,4,7,10,0,0],[2002,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2002,10,27,8,59,59],[2002,10,27,1,59,59] ],
        [ [2002,10,27,9,0,0],[2002,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2003,4,6,9,59,59],[2003,4,6,1,59,59] ],
     ],
   2003 =>
     [
        [ [2003,4,6,10,0,0],[2003,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2003,10,26,8,59,59],[2003,10,26,1,59,59] ],
        [ [2003,10,26,9,0,0],[2003,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2004,4,4,9,59,59],[2004,4,4,1,59,59] ],
     ],
   2004 =>
     [
        [ [2004,4,4,10,0,0],[2004,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2004,10,31,8,59,59],[2004,10,31,1,59,59] ],
        [ [2004,10,31,9,0,0],[2004,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2005,4,3,9,59,59],[2005,4,3,1,59,59] ],
     ],
   2005 =>
     [
        [ [2005,4,3,10,0,0],[2005,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2005,10,30,8,59,59],[2005,10,30,1,59,59] ],
        [ [2005,10,30,9,0,0],[2005,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2006,4,2,9,59,59],[2006,4,2,1,59,59] ],
     ],
   2006 =>
     [
        [ [2006,4,2,10,0,0],[2006,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2006,10,29,8,59,59],[2006,10,29,1,59,59] ],
        [ [2006,10,29,9,0,0],[2006,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2007,4,1,9,59,59],[2007,4,1,1,59,59] ],
     ],
   2007 =>
     [
        [ [2007,4,1,10,0,0],[2007,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2007,10,28,8,59,59],[2007,10,28,1,59,59] ],
        [ [2007,10,28,9,0,0],[2007,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2008,4,6,9,59,59],[2008,4,6,1,59,59] ],
     ],
   2008 =>
     [
        [ [2008,4,6,10,0,0],[2008,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2008,10,26,8,59,59],[2008,10,26,1,59,59] ],
        [ [2008,10,26,9,0,0],[2008,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2009,4,5,9,59,59],[2009,4,5,1,59,59] ],
     ],
   2009 =>
     [
        [ [2009,4,5,10,0,0],[2009,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2009,10,25,8,59,59],[2009,10,25,1,59,59] ],
        [ [2009,10,25,9,0,0],[2009,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2010,4,4,9,59,59],[2010,4,4,1,59,59] ],
     ],
   2010 =>
     [
        [ [2010,4,4,10,0,0],[2010,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2010,10,31,8,59,59],[2010,10,31,1,59,59] ],
        [ [2010,10,31,9,0,0],[2010,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2011,4,3,9,59,59],[2011,4,3,1,59,59] ],
     ],
   2011 =>
     [
        [ [2011,4,3,10,0,0],[2011,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2011,10,30,8,59,59],[2011,10,30,1,59,59] ],
        [ [2011,10,30,9,0,0],[2011,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2012,4,1,9,59,59],[2012,4,1,1,59,59] ],
     ],
   2012 =>
     [
        [ [2012,4,1,10,0,0],[2012,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2012,10,28,8,59,59],[2012,10,28,1,59,59] ],
        [ [2012,10,28,9,0,0],[2012,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2013,4,7,9,59,59],[2013,4,7,1,59,59] ],
     ],
   2013 =>
     [
        [ [2013,4,7,10,0,0],[2013,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2013,10,27,8,59,59],[2013,10,27,1,59,59] ],
        [ [2013,10,27,9,0,0],[2013,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2014,4,6,9,59,59],[2014,4,6,1,59,59] ],
     ],
   2014 =>
     [
        [ [2014,4,6,10,0,0],[2014,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2014,10,26,8,59,59],[2014,10,26,1,59,59] ],
        [ [2014,10,26,9,0,0],[2014,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2015,4,5,9,59,59],[2015,4,5,1,59,59] ],
     ],
   2015 =>
     [
        [ [2015,4,5,10,0,0],[2015,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2015,10,25,8,59,59],[2015,10,25,1,59,59] ],
        [ [2015,10,25,9,0,0],[2015,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2016,4,3,9,59,59],[2016,4,3,1,59,59] ],
     ],
   2016 =>
     [
        [ [2016,4,3,10,0,0],[2016,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2016,10,30,8,59,59],[2016,10,30,1,59,59] ],
        [ [2016,10,30,9,0,0],[2016,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2017,4,2,9,59,59],[2017,4,2,1,59,59] ],
     ],
   2017 =>
     [
        [ [2017,4,2,10,0,0],[2017,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2017,10,29,8,59,59],[2017,10,29,1,59,59] ],
        [ [2017,10,29,9,0,0],[2017,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2018,4,1,9,59,59],[2018,4,1,1,59,59] ],
     ],
   2018 =>
     [
        [ [2018,4,1,10,0,0],[2018,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2018,10,28,8,59,59],[2018,10,28,1,59,59] ],
        [ [2018,10,28,9,0,0],[2018,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2019,4,7,9,59,59],[2019,4,7,1,59,59] ],
     ],
   2019 =>
     [
        [ [2019,4,7,10,0,0],[2019,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2019,10,27,8,59,59],[2019,10,27,1,59,59] ],
        [ [2019,10,27,9,0,0],[2019,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2020,4,5,9,59,59],[2020,4,5,1,59,59] ],
     ],
   2020 =>
     [
        [ [2020,4,5,10,0,0],[2020,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2020,10,25,8,59,59],[2020,10,25,1,59,59] ],
        [ [2020,10,25,9,0,0],[2020,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2021,4,4,9,59,59],[2021,4,4,1,59,59] ],
     ],
   2021 =>
     [
        [ [2021,4,4,10,0,0],[2021,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2021,10,31,8,59,59],[2021,10,31,1,59,59] ],
        [ [2021,10,31,9,0,0],[2021,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2022,4,3,9,59,59],[2022,4,3,1,59,59] ],
     ],
   2022 =>
     [
        [ [2022,4,3,10,0,0],[2022,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2022,10,30,8,59,59],[2022,10,30,1,59,59] ],
        [ [2022,10,30,9,0,0],[2022,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2023,4,2,9,59,59],[2023,4,2,1,59,59] ],
     ],
   2023 =>
     [
        [ [2023,4,2,10,0,0],[2023,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2023,10,29,8,59,59],[2023,10,29,1,59,59] ],
        [ [2023,10,29,9,0,0],[2023,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2024,4,7,9,59,59],[2024,4,7,1,59,59] ],
     ],
   2024 =>
     [
        [ [2024,4,7,10,0,0],[2024,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2024,10,27,8,59,59],[2024,10,27,1,59,59] ],
        [ [2024,10,27,9,0,0],[2024,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2025,4,6,9,59,59],[2025,4,6,1,59,59] ],
     ],
   2025 =>
     [
        [ [2025,4,6,10,0,0],[2025,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2025,10,26,8,59,59],[2025,10,26,1,59,59] ],
        [ [2025,10,26,9,0,0],[2025,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2026,4,5,9,59,59],[2026,4,5,1,59,59] ],
     ],
   2026 =>
     [
        [ [2026,4,5,10,0,0],[2026,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2026,10,25,8,59,59],[2026,10,25,1,59,59] ],
        [ [2026,10,25,9,0,0],[2026,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2027,4,4,9,59,59],[2027,4,4,1,59,59] ],
     ],
   2027 =>
     [
        [ [2027,4,4,10,0,0],[2027,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2027,10,31,8,59,59],[2027,10,31,1,59,59] ],
        [ [2027,10,31,9,0,0],[2027,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2028,4,2,9,59,59],[2028,4,2,1,59,59] ],
     ],
   2028 =>
     [
        [ [2028,4,2,10,0,0],[2028,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2028,10,29,8,59,59],[2028,10,29,1,59,59] ],
        [ [2028,10,29,9,0,0],[2028,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2029,4,1,9,59,59],[2029,4,1,1,59,59] ],
     ],
   2029 =>
     [
        [ [2029,4,1,10,0,0],[2029,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2029,10,28,8,59,59],[2029,10,28,1,59,59] ],
        [ [2029,10,28,9,0,0],[2029,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2030,4,7,9,59,59],[2030,4,7,1,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-07:00:00',
                'stdoff' => '-08:00:00',

               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'PDT',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'PST',
                        },

               },
);

1;
