#!/usr/bin/perl
#

use strict;
use warnings;
use Test::More;

use Digest::SHA;
use Net::DNS::Resolver::Unbound;

plan skip_all => "perl version $]" if $] > 5.020;

my $resolver = Net::DNS::Resolver::Unbound->new();
ok( $resolver, 'resolver loaded' );

my $alg = 'SHA1 digest';
my $sha = Digest::SHA->new($alg);
diag "\n$alg";
foreach ( sort keys %INC ) {
	next unless m#^Net/DNS|^base#;
	my $filename = $INC{$_};
	s#/#::#g;
	my $package = $_;
	$sha->addfile( $filename, 'U' );
	my $digest = $sha->hexdigest;
	ok( $digest, $package );
	diag "$digest\t$package";
}

done_testing();

exit;

