use strict;
use Test::More tests => 3;
use Bio::Phylo::IO 'parse';

my $forest;
ok( $forest = parse(
        '-format' => 'newick',
        '-string' => do { local $/; <DATA> }
    ), '1 parse string'
);

ok( scalar @{ $forest->get_entities } == 2, '2 have two trees' );

my ( $tree1, $tree2 ) = @{ $forest->get_entities };

ok( $tree1->calc_symdiff( $tree2 ) == 0, '3 calc symdiff' );

__DATA__
(((cne531:0.339269,(((((((dme9697:0.023780,aga8870:0.037111)90:0.047976,(cel10167:0.000000,cbr5952:0.005627)100:0.157710)100:0.147733,((((mmu2705:0.001373,hsa8058:0.033284)99:0.038768,rno26599:0.000000)86:0.012921,gga701:0.017695)82:0.013643,(dre17976:0.000000,(tni4042:0.000000,fru10354:0.023602)100:0.047009)79:0.015901)100:0.086645)98:0.121069,(((((((sce431:0.022073,cgl2990:0.012020)78:0.021273,kla4067:0.042105)70:0.009125,ago4532:0.095439)99:0.071578,dha6577:0.104685)85:0.044547,yli6618:0.165663)91:0.096462,ncr8760:0.271286)80:0.139334,tgo4242:0.259948)27:0.040168)45:0.103778,(((pvi788:0.010532,pkn1748:0.023215)93:0.044149,pyo1354:0.057499)85:0.056958,pfa555:0.006937)100:0.303054)31:0.046502,ddi13003:0.257905)28:0.044253,tps8616:0.294314)31:0.036646)100:0.153925,ath9394:0.044374)100:0.096928,osa53631:0.006705,osa39710:0.017401);
(((cne531:0.339269,(((((((dme9697:0.023780,aga8870:0.037111)89:0.047976,(cel10167:0.000000,cbr5952:0.005627)100:0.157710)100:0.147733,((((mmu2705:0.001373,hsa8058:0.033284)98:0.038768,rno26599:0.000000)73:0.012921,gga701:0.017695)81:0.013643,(dre17976:0.000000,(tni4042:0.000000,fru10354:0.023602)100:0.047009)67:0.015901)100:0.086645)100:0.121069,(((((((sce431:0.022073,cgl2990:0.012020)81:0.021273,kla4067:0.042105)66:0.009125,ago4532:0.095439)98:0.071578,dha6577:0.104685)90:0.044547,yli6618:0.165663)92:0.096462,ncr8760:0.271286)75:0.139334,tgo4242:0.259948)24:0.040168)35:0.103778,(((pvi788:0.010532,pkn1748:0.023215)93:0.044149,pyo1354:0.057499)81:0.056958,pfa555:0.006937)100:0.303054)23:0.046502,ddi13003:0.257905)18:0.044253,tps8616:0.294314)28:0.036646)100:0.153925,ath9394:0.044374)100:0.096928,osa53631:0.006705,osa39710:0.017401);