
package DataFlow::Node::SQL;

BEGIN {
    $DataFlow::Node::SQL::VERSION = '0.91.02';
}

use Moose;
extends 'DataFlow::Node';

use SQL::Abstract;

my $sql = SQL::Abstract->new;

has 'table' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1
);

has '+process_item' => (
    default => sub {
        return sub {
            my ( $self, $data ) = @_;
            my ( $insert, @bind ) = $sql->insert( $self->table, $data );

            # TODO: regex ?
            map { $insert =~ s/\?/'$_'/; } @bind;
            print $insert . "\n";
          }
    }
);

__PACKAGE__->meta->make_immutable;

1;
