#!/usr/bin/env perl

use strict;
use warnings;

use Graph::Easy::Marpa;

use Getopt::Long;

use Pod::Usage;

# -----------------------------------------------

my($option_parser) = Getopt::Long::Parser -> new();

my(%option);

if ($option_parser -> getoptions
(
 \%option,
 'cooked_file=s',
 'description=s',
 'format=s',
 'help',
 'input_file=s',
 'maxlevel=s',
 'minlevel=s',
 'output_file=s',
 'token_file=s',
) )
{
	pod2usage(1) if ($option{'help'});

	# Return 0 for success and 1 for failure.

	exit Graph::Easy::Marpa -> new(%option) -> run;
}
else
{
	pod2usage(2);
}

__END__

=pod

=head1 NAME

gem.pl - Run Graph::Easy::Marpa::Lexer and Graph::Easy::Marpa::Parser.

=head1 SYNOPSIS

gem.pl [options]

	Options:
	-cooked_file aCookedFileName
	-description graphDescription
	-format outputGraphFormat
	-help
	-input_file aRawFileName
	-maxlevel logOption1
	-minlevel logOption2
	-output_file aGraphOutputFile
	-token_file aTokenFileName

All switches can be reduced to a single letter (except min and max).

Exit value: 0 for success, 1 for failure. Die upon error.

=head1 OPTIONS

=over 4

=item -cooked_file aCookedFileName

The name of a CSV file of cooked tokens to write. This file can be input to the parser.

The is no default value.

=item -description graphDescription

Specify a graph description string for the DFA to process.

You are strongly encouraged to surround this string with '...' to protect it from your shell.

See also the -input_file option to read the description from a file.

The -description option takes precedence over the -input_file option.

There is no default value.

=item -format outputGraphFormat

The format (e.g. 'svg') to pass to the rendering engine.

=item -help

Print help and exit.

=item -input_file aRawFileName

Read the graph description string from a file.

See also the -description option to read the graph description from the command line.

The whole file is slurped in as 1 graph.

The first lines of the file can start with /\s*#/, and will be discarded as comments.

The -description option takes precedence over the -input_file option.

There is no default value.

=item -maxlevel logOption1

This option affects Log::Handler.

See the Log::handler docs.

The default maxlevel is 'info'. Another typical value is 'debug'.

=item -minlevel logOption2

This option affects Log::Handler.

See the Log::handler docs.

The default minlevel is 'error'.

No lower levels are used.

=item o -output_file aGraphOutputFile

A file to which the graph is written.

If not specified (the default), the graph is not saved.

The default is ''.

=item o -tokenFile aTokenFileName

The list of tokens generated by the parser will be written to this file.

If not specified (the default), the tokens are not saved.

The default is ''.

=back

=cut
