use strict;
use warnings;

use Test::More tests => 1;
use DBI;

eval {
  if (-f 't/wafers.db') {
    unlink 't/wafers.db' or die "couldn't remove t/wafers.db: $!";
  }

  my $dbh = DBI->connect('dbi:SQLite:dbname=t/wafers.db');

  my %data;

  $data{grown_wafers} = <<'END_DATA';
1|101|GaAs|2|Production|1
2|101|GaAs|2|Production|2
3|101|GaAs|2|Production|3
4|101|GaAs|2|Production|4
5|101|GaAs|2|Production|5
6|101|GaAs|2|Production|6
7|101|GaAs|2|Production|7
8|101|GaAs|2|Production|8
9|101|GaAs|2|Production|9
10|101|GaAs|2|Production|10
11|101|GaAs|2|Calibration|1
12|101|GaAs|2|Calibration|2
13|101|GaAs|2|Calibration|3
14|101|GaAs|2|Calibration|4
15|101|GaAs|2|Calibration|5
16|101|GaAs|2|Calibration|6
17|101|GaAs|2|Calibration|7
18|101|GaAs|2|Calibration|8
19|101|GaAs|2|Calibration|9
20|101|GaAs|2|Calibration|10
21|101|GaAs|3|Production|1
22|101|GaAs|3|Production|2
23|101|GaAs|3|Production|3
24|101|GaAs|3|Production|4
25|101|GaAs|3|Production|5
26|101|GaAs|3|Production|6
27|101|GaAs|3|Production|7
28|101|GaAs|3|Production|8
29|101|GaAs|3|Production|9
30|101|GaAs|3|Production|10
31|101|GaAs|3|Calibration|1
32|101|GaAs|3|Calibration|2
33|101|GaAs|3|Calibration|3
34|101|GaAs|3|Calibration|4
35|101|GaAs|3|Calibration|5
36|101|GaAs|3|Calibration|6
37|101|GaAs|3|Calibration|7
38|101|GaAs|3|Calibration|8
39|101|GaAs|3|Calibration|9
40|101|GaAs|3|Calibration|10
41|101|GaAs|4|Production|1
42|101|GaAs|4|Production|2
43|101|GaAs|4|Production|3
44|101|GaAs|4|Production|4
45|101|GaAs|4|Production|5
46|101|GaAs|4|Production|6
47|101|GaAs|4|Production|7
48|101|GaAs|4|Production|8
49|101|GaAs|4|Production|9
50|101|GaAs|4|Production|10
51|101|GaAs|4|Calibration|1
52|101|GaAs|4|Calibration|2
53|101|GaAs|4|Calibration|3
54|101|GaAs|4|Calibration|4
55|101|GaAs|4|Calibration|5
56|101|GaAs|4|Calibration|6
57|101|GaAs|4|Calibration|7
58|101|GaAs|4|Calibration|8
59|101|GaAs|4|Calibration|9
60|101|GaAs|4|Calibration|10
61|101|GaAs|6|Production|1
62|101|GaAs|6|Production|2
63|101|GaAs|6|Production|3
64|101|GaAs|6|Production|4
65|101|GaAs|6|Production|5
66|101|GaAs|6|Production|6
67|101|GaAs|6|Production|7
68|101|GaAs|6|Production|8
69|101|GaAs|6|Production|9
70|101|GaAs|6|Production|10
71|101|GaAs|6|Calibration|1
72|101|GaAs|6|Calibration|2
73|101|GaAs|6|Calibration|3
74|101|GaAs|6|Calibration|4
75|101|GaAs|6|Calibration|5
76|101|GaAs|6|Calibration|6
77|101|GaAs|6|Calibration|7
78|101|GaAs|6|Calibration|8
79|101|GaAs|6|Calibration|9
80|101|GaAs|6|Calibration|10
81|101|InP|2|Production|1
82|101|InP|2|Production|2
83|101|InP|2|Production|3
84|101|InP|2|Production|4
85|101|InP|2|Production|5
86|101|InP|2|Production|6
87|101|InP|2|Production|7
88|101|InP|2|Production|8
89|101|InP|2|Production|9
90|101|InP|2|Production|10
91|101|InP|2|Calibration|1
92|101|InP|2|Calibration|2
93|101|InP|2|Calibration|3
94|101|InP|2|Calibration|4
95|101|InP|2|Calibration|5
96|101|InP|2|Calibration|6
97|101|InP|2|Calibration|7
98|101|InP|2|Calibration|8
99|101|InP|2|Calibration|9
100|101|InP|2|Calibration|10
101|101|InP|3|Production|1
102|101|InP|3|Production|2
103|101|InP|3|Production|3
104|101|InP|3|Production|4
105|101|InP|3|Production|5
106|101|InP|3|Production|6
107|101|InP|3|Production|7
108|101|InP|3|Production|8
109|101|InP|3|Production|9
110|101|InP|3|Production|10
111|101|InP|3|Calibration|1
112|101|InP|3|Calibration|2
113|101|InP|3|Calibration|3
114|101|InP|3|Calibration|4
115|101|InP|3|Calibration|5
116|101|InP|3|Calibration|6
117|101|InP|3|Calibration|7
118|101|InP|3|Calibration|8
119|101|InP|3|Calibration|9
120|101|InP|3|Calibration|10
121|101|InP|4|Production|1
122|101|InP|4|Production|2
123|101|InP|4|Production|3
124|101|InP|4|Production|4
125|101|InP|4|Production|5
126|101|InP|4|Production|6
127|101|InP|4|Production|7
128|101|InP|4|Production|8
129|101|InP|4|Production|9
130|101|InP|4|Production|10
131|101|InP|4|Calibration|1
132|101|InP|4|Calibration|2
133|101|InP|4|Calibration|3
134|101|InP|4|Calibration|4
135|101|InP|4|Calibration|5
136|101|InP|4|Calibration|6
137|101|InP|4|Calibration|7
138|101|InP|4|Calibration|8
139|101|InP|4|Calibration|9
140|101|InP|4|Calibration|10
141|101|InP|6|Production|1
142|101|InP|6|Production|2
143|101|InP|6|Production|3
144|101|InP|6|Production|4
145|101|InP|6|Production|5
146|101|InP|6|Production|6
147|101|InP|6|Production|7
148|101|InP|6|Production|8
149|101|InP|6|Production|9
150|101|InP|6|Production|10
151|101|InP|6|Calibration|1
152|101|InP|6|Calibration|2
153|101|InP|6|Calibration|3
154|101|InP|6|Calibration|4
155|101|InP|6|Calibration|5
156|101|InP|6|Calibration|6
157|101|InP|6|Calibration|7
158|101|InP|6|Calibration|8
159|101|InP|6|Calibration|9
160|101|InP|6|Calibration|10
161|101|GaN|2|Production|1
162|101|GaN|2|Production|2
163|101|GaN|2|Production|3
164|101|GaN|2|Production|4
165|101|GaN|2|Production|5
166|101|GaN|2|Production|6
167|101|GaN|2|Production|7
168|101|GaN|2|Production|8
169|101|GaN|2|Production|9
170|101|GaN|2|Production|10
171|101|GaN|2|Calibration|1
172|101|GaN|2|Calibration|2
173|101|GaN|2|Calibration|3
174|101|GaN|2|Calibration|4
175|101|GaN|2|Calibration|5
176|101|GaN|2|Calibration|6
177|101|GaN|2|Calibration|7
178|101|GaN|2|Calibration|8
179|101|GaN|2|Calibration|9
180|101|GaN|2|Calibration|10
181|101|GaN|3|Production|1
182|101|GaN|3|Production|2
183|101|GaN|3|Production|3
184|101|GaN|3|Production|4
185|101|GaN|3|Production|5
186|101|GaN|3|Production|6
187|101|GaN|3|Production|7
188|101|GaN|3|Production|8
189|101|GaN|3|Production|9
190|101|GaN|3|Production|10
191|101|GaN|3|Calibration|1
192|101|GaN|3|Calibration|2
193|101|GaN|3|Calibration|3
194|101|GaN|3|Calibration|4
195|101|GaN|3|Calibration|5
196|101|GaN|3|Calibration|6
197|101|GaN|3|Calibration|7
198|101|GaN|3|Calibration|8
199|101|GaN|3|Calibration|9
200|101|GaN|3|Calibration|10
201|101|GaN|4|Production|1
202|101|GaN|4|Production|2
203|101|GaN|4|Production|3
204|101|GaN|4|Production|4
205|101|GaN|4|Production|5
206|101|GaN|4|Production|6
207|101|GaN|4|Production|7
208|101|GaN|4|Production|8
209|101|GaN|4|Production|9
210|101|GaN|4|Production|10
211|101|GaN|4|Calibration|1
212|101|GaN|4|Calibration|2
213|101|GaN|4|Calibration|3
214|101|GaN|4|Calibration|4
215|101|GaN|4|Calibration|5
216|101|GaN|4|Calibration|6
217|101|GaN|4|Calibration|7
218|101|GaN|4|Calibration|8
219|101|GaN|4|Calibration|9
220|101|GaN|4|Calibration|10
221|101|GaN|6|Production|1
222|101|GaN|6|Production|2
223|101|GaN|6|Production|3
224|101|GaN|6|Production|4
225|101|GaN|6|Production|5
226|101|GaN|6|Production|6
227|101|GaN|6|Production|7
228|101|GaN|6|Production|8
229|101|GaN|6|Production|9
230|101|GaN|6|Production|10
231|101|GaN|6|Calibration|1
232|101|GaN|6|Calibration|2
233|101|GaN|6|Calibration|3
234|101|GaN|6|Calibration|4
235|101|GaN|6|Calibration|5
236|101|GaN|6|Calibration|6
237|101|GaN|6|Calibration|7
238|101|GaN|6|Calibration|8
239|101|GaN|6|Calibration|9
240|101|GaN|6|Calibration|10
241|101|Si|2|Production|1
242|101|Si|2|Production|2
243|101|Si|2|Production|3
244|101|Si|2|Production|4
245|101|Si|2|Production|5
246|101|Si|2|Production|6
247|101|Si|2|Production|7
248|101|Si|2|Production|8
249|101|Si|2|Production|9
250|101|Si|2|Production|10
251|101|Si|2|Calibration|1
252|101|Si|2|Calibration|2
253|101|Si|2|Calibration|3
254|101|Si|2|Calibration|4
255|101|Si|2|Calibration|5
256|101|Si|2|Calibration|6
257|101|Si|2|Calibration|7
258|101|Si|2|Calibration|8
259|101|Si|2|Calibration|9
260|101|Si|2|Calibration|10
261|101|Si|3|Production|1
262|101|Si|3|Production|2
263|101|Si|3|Production|3
264|101|Si|3|Production|4
265|101|Si|3|Production|5
266|101|Si|3|Production|6
267|101|Si|3|Production|7
268|101|Si|3|Production|8
269|101|Si|3|Production|9
270|101|Si|3|Production|10
271|101|Si|3|Calibration|1
272|101|Si|3|Calibration|2
273|101|Si|3|Calibration|3
274|101|Si|3|Calibration|4
275|101|Si|3|Calibration|5
276|101|Si|3|Calibration|6
277|101|Si|3|Calibration|7
278|101|Si|3|Calibration|8
279|101|Si|3|Calibration|9
280|101|Si|3|Calibration|10
281|101|Si|4|Production|1
282|101|Si|4|Production|2
283|101|Si|4|Production|3
284|101|Si|4|Production|4
285|101|Si|4|Production|5
286|101|Si|4|Production|6
287|101|Si|4|Production|7
288|101|Si|4|Production|8
289|101|Si|4|Production|9
290|101|Si|4|Production|10
291|101|Si|4|Calibration|1
292|101|Si|4|Calibration|2
293|101|Si|4|Calibration|3
294|101|Si|4|Calibration|4
295|101|Si|4|Calibration|5
296|101|Si|4|Calibration|6
297|101|Si|4|Calibration|7
298|101|Si|4|Calibration|8
299|101|Si|4|Calibration|9
300|101|Si|4|Calibration|10
301|101|Si|6|Production|1
302|101|Si|6|Production|2
303|101|Si|6|Production|3
304|101|Si|6|Production|4
305|101|Si|6|Production|5
306|101|Si|6|Production|6
307|101|Si|6|Production|7
308|101|Si|6|Production|8
309|101|Si|6|Production|9
310|101|Si|6|Production|10
311|101|Si|6|Calibration|1
312|101|Si|6|Calibration|2
313|101|Si|6|Calibration|3
314|101|Si|6|Calibration|4
315|101|Si|6|Calibration|5
316|101|Si|6|Calibration|6
317|101|Si|6|Calibration|7
318|101|Si|6|Calibration|8
319|101|Si|6|Calibration|9
320|101|Si|6|Calibration|10
321|101|PB&J|2|Production|1
322|101|PB&J|2|Production|2
323|101|PB&J|2|Production|3
324|101|PB&J|2|Production|4
325|101|PB&J|2|Production|5
326|101|PB&J|2|Production|6
327|101|PB&J|2|Production|7
328|101|PB&J|2|Production|8
329|101|PB&J|2|Production|9
330|101|PB&J|2|Production|10
331|101|PB&J|2|Calibration|1
332|101|PB&J|2|Calibration|2
333|101|PB&J|2|Calibration|3
334|101|PB&J|2|Calibration|4
335|101|PB&J|2|Calibration|5
336|101|PB&J|2|Calibration|6
337|101|PB&J|2|Calibration|7
338|101|PB&J|2|Calibration|8
339|101|PB&J|2|Calibration|9
340|101|PB&J|2|Calibration|10
341|101|PB&J|3|Production|1
342|101|PB&J|3|Production|2
343|101|PB&J|3|Production|3
344|101|PB&J|3|Production|4
345|101|PB&J|3|Production|5
346|101|PB&J|3|Production|6
347|101|PB&J|3|Production|7
348|101|PB&J|3|Production|8
349|101|PB&J|3|Production|9
350|101|PB&J|3|Production|10
351|101|PB&J|3|Calibration|1
352|101|PB&J|3|Calibration|2
353|101|PB&J|3|Calibration|3
354|101|PB&J|3|Calibration|4
355|101|PB&J|3|Calibration|5
356|101|PB&J|3|Calibration|6
357|101|PB&J|3|Calibration|7
358|101|PB&J|3|Calibration|8
359|101|PB&J|3|Calibration|9
360|101|PB&J|3|Calibration|10
361|101|PB&J|4|Production|1
362|101|PB&J|4|Production|2
363|101|PB&J|4|Production|3
364|101|PB&J|4|Production|4
365|101|PB&J|4|Production|5
366|101|PB&J|4|Production|6
367|101|PB&J|4|Production|7
368|101|PB&J|4|Production|8
369|101|PB&J|4|Production|9
370|101|PB&J|4|Production|10
371|101|PB&J|4|Calibration|1
372|101|PB&J|4|Calibration|2
373|101|PB&J|4|Calibration|3
374|101|PB&J|4|Calibration|4
375|101|PB&J|4|Calibration|5
376|101|PB&J|4|Calibration|6
377|101|PB&J|4|Calibration|7
378|101|PB&J|4|Calibration|8
379|101|PB&J|4|Calibration|9
380|101|PB&J|4|Calibration|10
381|101|PB&J|6|Production|1
382|101|PB&J|6|Production|2
383|101|PB&J|6|Production|3
384|101|PB&J|6|Production|4
385|101|PB&J|6|Production|5
386|101|PB&J|6|Production|6
387|101|PB&J|6|Production|7
388|101|PB&J|6|Production|8
389|101|PB&J|6|Production|9
390|101|PB&J|6|Production|10
391|101|PB&J|6|Calibration|1
392|101|PB&J|6|Calibration|2
393|101|PB&J|6|Calibration|3
394|101|PB&J|6|Calibration|4
395|101|PB&J|6|Calibration|5
396|101|PB&J|6|Calibration|6
397|101|PB&J|6|Calibration|7
398|101|PB&J|6|Calibration|8
399|101|PB&J|6|Calibration|9
400|101|PB&J|6|Calibration|10
401|102|GaAs|2|Production|1
402|102|GaAs|2|Production|2
403|102|GaAs|2|Production|3
404|102|GaAs|2|Production|4
405|102|GaAs|2|Production|5
406|102|GaAs|2|Production|6
407|102|GaAs|2|Production|7
408|102|GaAs|2|Production|8
409|102|GaAs|2|Production|9
410|102|GaAs|2|Production|10
411|102|GaAs|2|Calibration|1
412|102|GaAs|2|Calibration|2
413|102|GaAs|2|Calibration|3
414|102|GaAs|2|Calibration|4
415|102|GaAs|2|Calibration|5
416|102|GaAs|2|Calibration|6
417|102|GaAs|2|Calibration|7
418|102|GaAs|2|Calibration|8
419|102|GaAs|2|Calibration|9
420|102|GaAs|2|Calibration|10
421|102|GaAs|3|Production|1
422|102|GaAs|3|Production|2
423|102|GaAs|3|Production|3
424|102|GaAs|3|Production|4
425|102|GaAs|3|Production|5
426|102|GaAs|3|Production|6
427|102|GaAs|3|Production|7
428|102|GaAs|3|Production|8
429|102|GaAs|3|Production|9
430|102|GaAs|3|Production|10
431|102|GaAs|3|Calibration|1
432|102|GaAs|3|Calibration|2
433|102|GaAs|3|Calibration|3
434|102|GaAs|3|Calibration|4
435|102|GaAs|3|Calibration|5
436|102|GaAs|3|Calibration|6
437|102|GaAs|3|Calibration|7
438|102|GaAs|3|Calibration|8
439|102|GaAs|3|Calibration|9
440|102|GaAs|3|Calibration|10
441|102|GaAs|4|Production|1
442|102|GaAs|4|Production|2
443|102|GaAs|4|Production|3
444|102|GaAs|4|Production|4
445|102|GaAs|4|Production|5
446|102|GaAs|4|Production|6
447|102|GaAs|4|Production|7
448|102|GaAs|4|Production|8
449|102|GaAs|4|Production|9
450|102|GaAs|4|Production|10
451|102|GaAs|4|Calibration|1
452|102|GaAs|4|Calibration|2
453|102|GaAs|4|Calibration|3
454|102|GaAs|4|Calibration|4
455|102|GaAs|4|Calibration|5
456|102|GaAs|4|Calibration|6
457|102|GaAs|4|Calibration|7
458|102|GaAs|4|Calibration|8
459|102|GaAs|4|Calibration|9
460|102|GaAs|4|Calibration|10
461|102|GaAs|6|Production|1
462|102|GaAs|6|Production|2
463|102|GaAs|6|Production|3
464|102|GaAs|6|Production|4
465|102|GaAs|6|Production|5
466|102|GaAs|6|Production|6
467|102|GaAs|6|Production|7
468|102|GaAs|6|Production|8
469|102|GaAs|6|Production|9
470|102|GaAs|6|Production|10
471|102|GaAs|6|Calibration|1
472|102|GaAs|6|Calibration|2
473|102|GaAs|6|Calibration|3
474|102|GaAs|6|Calibration|4
475|102|GaAs|6|Calibration|5
476|102|GaAs|6|Calibration|6
477|102|GaAs|6|Calibration|7
478|102|GaAs|6|Calibration|8
479|102|GaAs|6|Calibration|9
480|102|GaAs|6|Calibration|10
481|102|InP|2|Production|1
482|102|InP|2|Production|2
483|102|InP|2|Production|3
484|102|InP|2|Production|4
485|102|InP|2|Production|5
486|102|InP|2|Production|6
487|102|InP|2|Production|7
488|102|InP|2|Production|8
489|102|InP|2|Production|9
490|102|InP|2|Production|10
491|102|InP|2|Calibration|1
492|102|InP|2|Calibration|2
493|102|InP|2|Calibration|3
494|102|InP|2|Calibration|4
495|102|InP|2|Calibration|5
496|102|InP|2|Calibration|6
497|102|InP|2|Calibration|7
498|102|InP|2|Calibration|8
499|102|InP|2|Calibration|9
500|102|InP|2|Calibration|10
501|102|InP|3|Production|1
502|102|InP|3|Production|2
503|102|InP|3|Production|3
504|102|InP|3|Production|4
505|102|InP|3|Production|5
506|102|InP|3|Production|6
507|102|InP|3|Production|7
508|102|InP|3|Production|8
509|102|InP|3|Production|9
510|102|InP|3|Production|10
511|102|InP|3|Calibration|1
512|102|InP|3|Calibration|2
513|102|InP|3|Calibration|3
514|102|InP|3|Calibration|4
515|102|InP|3|Calibration|5
516|102|InP|3|Calibration|6
517|102|InP|3|Calibration|7
518|102|InP|3|Calibration|8
519|102|InP|3|Calibration|9
520|102|InP|3|Calibration|10
521|102|InP|4|Production|1
522|102|InP|4|Production|2
523|102|InP|4|Production|3
524|102|InP|4|Production|4
525|102|InP|4|Production|5
526|102|InP|4|Production|6
527|102|InP|4|Production|7
528|102|InP|4|Production|8
529|102|InP|4|Production|9
530|102|InP|4|Production|10
531|102|InP|4|Calibration|1
532|102|InP|4|Calibration|2
533|102|InP|4|Calibration|3
534|102|InP|4|Calibration|4
535|102|InP|4|Calibration|5
536|102|InP|4|Calibration|6
537|102|InP|4|Calibration|7
538|102|InP|4|Calibration|8
539|102|InP|4|Calibration|9
540|102|InP|4|Calibration|10
541|102|InP|6|Production|1
542|102|InP|6|Production|2
543|102|InP|6|Production|3
544|102|InP|6|Production|4
545|102|InP|6|Production|5
546|102|InP|6|Production|6
547|102|InP|6|Production|7
548|102|InP|6|Production|8
549|102|InP|6|Production|9
550|102|InP|6|Production|10
551|102|InP|6|Calibration|1
552|102|InP|6|Calibration|2
553|102|InP|6|Calibration|3
554|102|InP|6|Calibration|4
555|102|InP|6|Calibration|5
556|102|InP|6|Calibration|6
557|102|InP|6|Calibration|7
558|102|InP|6|Calibration|8
559|102|InP|6|Calibration|9
560|102|InP|6|Calibration|10
561|102|GaN|2|Production|1
562|102|GaN|2|Production|2
563|102|GaN|2|Production|3
564|102|GaN|2|Production|4
565|102|GaN|2|Production|5
566|102|GaN|2|Production|6
567|102|GaN|2|Production|7
568|102|GaN|2|Production|8
569|102|GaN|2|Production|9
570|102|GaN|2|Production|10
571|102|GaN|2|Calibration|1
572|102|GaN|2|Calibration|2
573|102|GaN|2|Calibration|3
574|102|GaN|2|Calibration|4
575|102|GaN|2|Calibration|5
576|102|GaN|2|Calibration|6
577|102|GaN|2|Calibration|7
578|102|GaN|2|Calibration|8
579|102|GaN|2|Calibration|9
580|102|GaN|2|Calibration|10
581|102|GaN|3|Production|1
582|102|GaN|3|Production|2
583|102|GaN|3|Production|3
584|102|GaN|3|Production|4
585|102|GaN|3|Production|5
586|102|GaN|3|Production|6
587|102|GaN|3|Production|7
588|102|GaN|3|Production|8
589|102|GaN|3|Production|9
590|102|GaN|3|Production|10
591|102|GaN|3|Calibration|1
592|102|GaN|3|Calibration|2
593|102|GaN|3|Calibration|3
594|102|GaN|3|Calibration|4
595|102|GaN|3|Calibration|5
596|102|GaN|3|Calibration|6
597|102|GaN|3|Calibration|7
598|102|GaN|3|Calibration|8
599|102|GaN|3|Calibration|9
600|102|GaN|3|Calibration|10
601|102|GaN|4|Production|1
602|102|GaN|4|Production|2
603|102|GaN|4|Production|3
604|102|GaN|4|Production|4
605|102|GaN|4|Production|5
606|102|GaN|4|Production|6
607|102|GaN|4|Production|7
608|102|GaN|4|Production|8
609|102|GaN|4|Production|9
610|102|GaN|4|Production|10
611|102|GaN|4|Calibration|1
612|102|GaN|4|Calibration|2
613|102|GaN|4|Calibration|3
614|102|GaN|4|Calibration|4
615|102|GaN|4|Calibration|5
616|102|GaN|4|Calibration|6
617|102|GaN|4|Calibration|7
618|102|GaN|4|Calibration|8
619|102|GaN|4|Calibration|9
620|102|GaN|4|Calibration|10
621|102|GaN|6|Production|1
622|102|GaN|6|Production|2
623|102|GaN|6|Production|3
624|102|GaN|6|Production|4
625|102|GaN|6|Production|5
626|102|GaN|6|Production|6
627|102|GaN|6|Production|7
628|102|GaN|6|Production|8
629|102|GaN|6|Production|9
630|102|GaN|6|Production|10
631|102|GaN|6|Calibration|1
632|102|GaN|6|Calibration|2
633|102|GaN|6|Calibration|3
634|102|GaN|6|Calibration|4
635|102|GaN|6|Calibration|5
636|102|GaN|6|Calibration|6
637|102|GaN|6|Calibration|7
638|102|GaN|6|Calibration|8
639|102|GaN|6|Calibration|9
640|102|GaN|6|Calibration|10
641|102|Si|2|Production|1
642|102|Si|2|Production|2
643|102|Si|2|Production|3
644|102|Si|2|Production|4
645|102|Si|2|Production|5
646|102|Si|2|Production|6
647|102|Si|2|Production|7
648|102|Si|2|Production|8
649|102|Si|2|Production|9
650|102|Si|2|Production|10
651|102|Si|2|Calibration|1
652|102|Si|2|Calibration|2
653|102|Si|2|Calibration|3
654|102|Si|2|Calibration|4
655|102|Si|2|Calibration|5
656|102|Si|2|Calibration|6
657|102|Si|2|Calibration|7
658|102|Si|2|Calibration|8
659|102|Si|2|Calibration|9
660|102|Si|2|Calibration|10
661|102|Si|3|Production|1
662|102|Si|3|Production|2
663|102|Si|3|Production|3
664|102|Si|3|Production|4
665|102|Si|3|Production|5
666|102|Si|3|Production|6
667|102|Si|3|Production|7
668|102|Si|3|Production|8
669|102|Si|3|Production|9
670|102|Si|3|Production|10
671|102|Si|3|Calibration|1
672|102|Si|3|Calibration|2
673|102|Si|3|Calibration|3
674|102|Si|3|Calibration|4
675|102|Si|3|Calibration|5
676|102|Si|3|Calibration|6
677|102|Si|3|Calibration|7
678|102|Si|3|Calibration|8
679|102|Si|3|Calibration|9
680|102|Si|3|Calibration|10
681|102|Si|4|Production|1
682|102|Si|4|Production|2
683|102|Si|4|Production|3
684|102|Si|4|Production|4
685|102|Si|4|Production|5
686|102|Si|4|Production|6
687|102|Si|4|Production|7
688|102|Si|4|Production|8
689|102|Si|4|Production|9
690|102|Si|4|Production|10
691|102|Si|4|Calibration|1
692|102|Si|4|Calibration|2
693|102|Si|4|Calibration|3
694|102|Si|4|Calibration|4
695|102|Si|4|Calibration|5
696|102|Si|4|Calibration|6
697|102|Si|4|Calibration|7
698|102|Si|4|Calibration|8
699|102|Si|4|Calibration|9
700|102|Si|4|Calibration|10
701|102|Si|6|Production|1
702|102|Si|6|Production|2
703|102|Si|6|Production|3
704|102|Si|6|Production|4
705|102|Si|6|Production|5
706|102|Si|6|Production|6
707|102|Si|6|Production|7
708|102|Si|6|Production|8
709|102|Si|6|Production|9
710|102|Si|6|Production|10
711|102|Si|6|Calibration|1
712|102|Si|6|Calibration|2
713|102|Si|6|Calibration|3
714|102|Si|6|Calibration|4
715|102|Si|6|Calibration|5
716|102|Si|6|Calibration|6
717|102|Si|6|Calibration|7
718|102|Si|6|Calibration|8
719|102|Si|6|Calibration|9
720|102|Si|6|Calibration|10
721|102|PB&J|2|Production|1
722|102|PB&J|2|Production|2
723|102|PB&J|2|Production|3
724|102|PB&J|2|Production|4
725|102|PB&J|2|Production|5
726|102|PB&J|2|Production|6
727|102|PB&J|2|Production|7
728|102|PB&J|2|Production|8
729|102|PB&J|2|Production|9
730|102|PB&J|2|Production|10
731|102|PB&J|2|Calibration|1
732|102|PB&J|2|Calibration|2
733|102|PB&J|2|Calibration|3
734|102|PB&J|2|Calibration|4
735|102|PB&J|2|Calibration|5
736|102|PB&J|2|Calibration|6
737|102|PB&J|2|Calibration|7
738|102|PB&J|2|Calibration|8
739|102|PB&J|2|Calibration|9
740|102|PB&J|2|Calibration|10
741|102|PB&J|3|Production|1
742|102|PB&J|3|Production|2
743|102|PB&J|3|Production|3
744|102|PB&J|3|Production|4
745|102|PB&J|3|Production|5
746|102|PB&J|3|Production|6
747|102|PB&J|3|Production|7
748|102|PB&J|3|Production|8
749|102|PB&J|3|Production|9
750|102|PB&J|3|Production|10
751|102|PB&J|3|Calibration|1
752|102|PB&J|3|Calibration|2
753|102|PB&J|3|Calibration|3
754|102|PB&J|3|Calibration|4
755|102|PB&J|3|Calibration|5
756|102|PB&J|3|Calibration|6
757|102|PB&J|3|Calibration|7
758|102|PB&J|3|Calibration|8
759|102|PB&J|3|Calibration|9
760|102|PB&J|3|Calibration|10
761|102|PB&J|4|Production|1
762|102|PB&J|4|Production|2
763|102|PB&J|4|Production|3
764|102|PB&J|4|Production|4
765|102|PB&J|4|Production|5
766|102|PB&J|4|Production|6
767|102|PB&J|4|Production|7
768|102|PB&J|4|Production|8
769|102|PB&J|4|Production|9
770|102|PB&J|4|Production|10
771|102|PB&J|4|Calibration|1
772|102|PB&J|4|Calibration|2
773|102|PB&J|4|Calibration|3
774|102|PB&J|4|Calibration|4
775|102|PB&J|4|Calibration|5
776|102|PB&J|4|Calibration|6
777|102|PB&J|4|Calibration|7
778|102|PB&J|4|Calibration|8
779|102|PB&J|4|Calibration|9
780|102|PB&J|4|Calibration|10
781|102|PB&J|6|Production|1
782|102|PB&J|6|Production|2
783|102|PB&J|6|Production|3
784|102|PB&J|6|Production|4
785|102|PB&J|6|Production|5
786|102|PB&J|6|Production|6
787|102|PB&J|6|Production|7
788|102|PB&J|6|Production|8
789|102|PB&J|6|Production|9
790|102|PB&J|6|Production|10
791|102|PB&J|6|Calibration|1
792|102|PB&J|6|Calibration|2
793|102|PB&J|6|Calibration|3
794|102|PB&J|6|Calibration|4
795|102|PB&J|6|Calibration|5
796|102|PB&J|6|Calibration|6
797|102|PB&J|6|Calibration|7
798|102|PB&J|6|Calibration|8
799|102|PB&J|6|Calibration|9
800|102|PB&J|6|Calibration|10
801|103|GaAs|2|Production|1
802|103|GaAs|2|Production|2
803|103|GaAs|2|Production|3
804|103|GaAs|2|Production|4
805|103|GaAs|2|Production|5
806|103|GaAs|2|Production|6
807|103|GaAs|2|Production|7
808|103|GaAs|2|Production|8
809|103|GaAs|2|Production|9
810|103|GaAs|2|Production|10
811|103|GaAs|2|Calibration|1
812|103|GaAs|2|Calibration|2
813|103|GaAs|2|Calibration|3
814|103|GaAs|2|Calibration|4
815|103|GaAs|2|Calibration|5
816|103|GaAs|2|Calibration|6
817|103|GaAs|2|Calibration|7
818|103|GaAs|2|Calibration|8
819|103|GaAs|2|Calibration|9
820|103|GaAs|2|Calibration|10
821|103|GaAs|3|Production|1
822|103|GaAs|3|Production|2
823|103|GaAs|3|Production|3
824|103|GaAs|3|Production|4
825|103|GaAs|3|Production|5
826|103|GaAs|3|Production|6
827|103|GaAs|3|Production|7
828|103|GaAs|3|Production|8
829|103|GaAs|3|Production|9
830|103|GaAs|3|Production|10
831|103|GaAs|3|Calibration|1
832|103|GaAs|3|Calibration|2
833|103|GaAs|3|Calibration|3
834|103|GaAs|3|Calibration|4
835|103|GaAs|3|Calibration|5
836|103|GaAs|3|Calibration|6
837|103|GaAs|3|Calibration|7
838|103|GaAs|3|Calibration|8
839|103|GaAs|3|Calibration|9
840|103|GaAs|3|Calibration|10
841|103|GaAs|4|Production|1
842|103|GaAs|4|Production|2
843|103|GaAs|4|Production|3
844|103|GaAs|4|Production|4
845|103|GaAs|4|Production|5
846|103|GaAs|4|Production|6
847|103|GaAs|4|Production|7
848|103|GaAs|4|Production|8
849|103|GaAs|4|Production|9
850|103|GaAs|4|Production|10
851|103|GaAs|4|Calibration|1
852|103|GaAs|4|Calibration|2
853|103|GaAs|4|Calibration|3
854|103|GaAs|4|Calibration|4
855|103|GaAs|4|Calibration|5
856|103|GaAs|4|Calibration|6
857|103|GaAs|4|Calibration|7
858|103|GaAs|4|Calibration|8
859|103|GaAs|4|Calibration|9
860|103|GaAs|4|Calibration|10
861|103|GaAs|6|Production|1
862|103|GaAs|6|Production|2
863|103|GaAs|6|Production|3
864|103|GaAs|6|Production|4
865|103|GaAs|6|Production|5
866|103|GaAs|6|Production|6
867|103|GaAs|6|Production|7
868|103|GaAs|6|Production|8
869|103|GaAs|6|Production|9
870|103|GaAs|6|Production|10
871|103|GaAs|6|Calibration|1
872|103|GaAs|6|Calibration|2
873|103|GaAs|6|Calibration|3
874|103|GaAs|6|Calibration|4
875|103|GaAs|6|Calibration|5
876|103|GaAs|6|Calibration|6
877|103|GaAs|6|Calibration|7
878|103|GaAs|6|Calibration|8
879|103|GaAs|6|Calibration|9
880|103|GaAs|6|Calibration|10
881|103|InP|2|Production|1
882|103|InP|2|Production|2
883|103|InP|2|Production|3
884|103|InP|2|Production|4
885|103|InP|2|Production|5
886|103|InP|2|Production|6
887|103|InP|2|Production|7
888|103|InP|2|Production|8
889|103|InP|2|Production|9
890|103|InP|2|Production|10
891|103|InP|2|Calibration|1
892|103|InP|2|Calibration|2
893|103|InP|2|Calibration|3
894|103|InP|2|Calibration|4
895|103|InP|2|Calibration|5
896|103|InP|2|Calibration|6
897|103|InP|2|Calibration|7
898|103|InP|2|Calibration|8
899|103|InP|2|Calibration|9
900|103|InP|2|Calibration|10
901|103|InP|3|Production|1
902|103|InP|3|Production|2
903|103|InP|3|Production|3
904|103|InP|3|Production|4
905|103|InP|3|Production|5
906|103|InP|3|Production|6
907|103|InP|3|Production|7
908|103|InP|3|Production|8
909|103|InP|3|Production|9
910|103|InP|3|Production|10
911|103|InP|3|Calibration|1
912|103|InP|3|Calibration|2
913|103|InP|3|Calibration|3
914|103|InP|3|Calibration|4
915|103|InP|3|Calibration|5
916|103|InP|3|Calibration|6
917|103|InP|3|Calibration|7
918|103|InP|3|Calibration|8
919|103|InP|3|Calibration|9
920|103|InP|3|Calibration|10
921|103|InP|4|Production|1
922|103|InP|4|Production|2
923|103|InP|4|Production|3
924|103|InP|4|Production|4
925|103|InP|4|Production|5
926|103|InP|4|Production|6
927|103|InP|4|Production|7
928|103|InP|4|Production|8
929|103|InP|4|Production|9
930|103|InP|4|Production|10
931|103|InP|4|Calibration|1
932|103|InP|4|Calibration|2
933|103|InP|4|Calibration|3
934|103|InP|4|Calibration|4
935|103|InP|4|Calibration|5
936|103|InP|4|Calibration|6
937|103|InP|4|Calibration|7
938|103|InP|4|Calibration|8
939|103|InP|4|Calibration|9
940|103|InP|4|Calibration|10
941|103|InP|6|Production|1
942|103|InP|6|Production|2
943|103|InP|6|Production|3
944|103|InP|6|Production|4
945|103|InP|6|Production|5
946|103|InP|6|Production|6
947|103|InP|6|Production|7
948|103|InP|6|Production|8
949|103|InP|6|Production|9
950|103|InP|6|Production|10
951|103|InP|6|Calibration|1
952|103|InP|6|Calibration|2
953|103|InP|6|Calibration|3
954|103|InP|6|Calibration|4
955|103|InP|6|Calibration|5
956|103|InP|6|Calibration|6
957|103|InP|6|Calibration|7
958|103|InP|6|Calibration|8
959|103|InP|6|Calibration|9
960|103|InP|6|Calibration|10
961|103|GaN|2|Production|1
962|103|GaN|2|Production|2
963|103|GaN|2|Production|3
964|103|GaN|2|Production|4
965|103|GaN|2|Production|5
966|103|GaN|2|Production|6
967|103|GaN|2|Production|7
968|103|GaN|2|Production|8
969|103|GaN|2|Production|9
970|103|GaN|2|Production|10
971|103|GaN|2|Calibration|1
972|103|GaN|2|Calibration|2
973|103|GaN|2|Calibration|3
974|103|GaN|2|Calibration|4
975|103|GaN|2|Calibration|5
976|103|GaN|2|Calibration|6
977|103|GaN|2|Calibration|7
978|103|GaN|2|Calibration|8
979|103|GaN|2|Calibration|9
980|103|GaN|2|Calibration|10
981|103|GaN|3|Production|1
982|103|GaN|3|Production|2
983|103|GaN|3|Production|3
984|103|GaN|3|Production|4
985|103|GaN|3|Production|5
986|103|GaN|3|Production|6
987|103|GaN|3|Production|7
988|103|GaN|3|Production|8
989|103|GaN|3|Production|9
990|103|GaN|3|Production|10
991|103|GaN|3|Calibration|1
992|103|GaN|3|Calibration|2
993|103|GaN|3|Calibration|3
994|103|GaN|3|Calibration|4
995|103|GaN|3|Calibration|5
996|103|GaN|3|Calibration|6
997|103|GaN|3|Calibration|7
998|103|GaN|3|Calibration|8
999|103|GaN|3|Calibration|9
1000|103|GaN|3|Calibration|10
1001|103|GaN|4|Production|1
1002|103|GaN|4|Production|2
1003|103|GaN|4|Production|3
1004|103|GaN|4|Production|4
1005|103|GaN|4|Production|5
1006|103|GaN|4|Production|6
1007|103|GaN|4|Production|7
1008|103|GaN|4|Production|8
1009|103|GaN|4|Production|9
1010|103|GaN|4|Production|10
1011|103|GaN|4|Calibration|1
1012|103|GaN|4|Calibration|2
1013|103|GaN|4|Calibration|3
1014|103|GaN|4|Calibration|4
1015|103|GaN|4|Calibration|5
1016|103|GaN|4|Calibration|6
1017|103|GaN|4|Calibration|7
1018|103|GaN|4|Calibration|8
1019|103|GaN|4|Calibration|9
1020|103|GaN|4|Calibration|10
1021|103|GaN|6|Production|1
1022|103|GaN|6|Production|2
1023|103|GaN|6|Production|3
1024|103|GaN|6|Production|4
1025|103|GaN|6|Production|5
1026|103|GaN|6|Production|6
1027|103|GaN|6|Production|7
1028|103|GaN|6|Production|8
1029|103|GaN|6|Production|9
1030|103|GaN|6|Production|10
1031|103|GaN|6|Calibration|1
1032|103|GaN|6|Calibration|2
1033|103|GaN|6|Calibration|3
1034|103|GaN|6|Calibration|4
1035|103|GaN|6|Calibration|5
1036|103|GaN|6|Calibration|6
1037|103|GaN|6|Calibration|7
1038|103|GaN|6|Calibration|8
1039|103|GaN|6|Calibration|9
1040|103|GaN|6|Calibration|10
1041|103|Si|2|Production|1
1042|103|Si|2|Production|2
1043|103|Si|2|Production|3
1044|103|Si|2|Production|4
1045|103|Si|2|Production|5
1046|103|Si|2|Production|6
1047|103|Si|2|Production|7
1048|103|Si|2|Production|8
1049|103|Si|2|Production|9
1050|103|Si|2|Production|10
1051|103|Si|2|Calibration|1
1052|103|Si|2|Calibration|2
1053|103|Si|2|Calibration|3
1054|103|Si|2|Calibration|4
1055|103|Si|2|Calibration|5
1056|103|Si|2|Calibration|6
1057|103|Si|2|Calibration|7
1058|103|Si|2|Calibration|8
1059|103|Si|2|Calibration|9
1060|103|Si|2|Calibration|10
1061|103|Si|3|Production|1
1062|103|Si|3|Production|2
1063|103|Si|3|Production|3
1064|103|Si|3|Production|4
1065|103|Si|3|Production|5
1066|103|Si|3|Production|6
1067|103|Si|3|Production|7
1068|103|Si|3|Production|8
1069|103|Si|3|Production|9
1070|103|Si|3|Production|10
1071|103|Si|3|Calibration|1
1072|103|Si|3|Calibration|2
1073|103|Si|3|Calibration|3
1074|103|Si|3|Calibration|4
1075|103|Si|3|Calibration|5
1076|103|Si|3|Calibration|6
1077|103|Si|3|Calibration|7
1078|103|Si|3|Calibration|8
1079|103|Si|3|Calibration|9
1080|103|Si|3|Calibration|10
1081|103|Si|4|Production|1
1082|103|Si|4|Production|2
1083|103|Si|4|Production|3
1084|103|Si|4|Production|4
1085|103|Si|4|Production|5
1086|103|Si|4|Production|6
1087|103|Si|4|Production|7
1088|103|Si|4|Production|8
1089|103|Si|4|Production|9
1090|103|Si|4|Production|10
1091|103|Si|4|Calibration|1
1092|103|Si|4|Calibration|2
1093|103|Si|4|Calibration|3
1094|103|Si|4|Calibration|4
1095|103|Si|4|Calibration|5
1096|103|Si|4|Calibration|6
1097|103|Si|4|Calibration|7
1098|103|Si|4|Calibration|8
1099|103|Si|4|Calibration|9
1100|103|Si|4|Calibration|10
1101|103|Si|6|Production|1
1102|103|Si|6|Production|2
1103|103|Si|6|Production|3
1104|103|Si|6|Production|4
1105|103|Si|6|Production|5
1106|103|Si|6|Production|6
1107|103|Si|6|Production|7
1108|103|Si|6|Production|8
1109|103|Si|6|Production|9
1110|103|Si|6|Production|10
1111|103|Si|6|Calibration|1
1112|103|Si|6|Calibration|2
1113|103|Si|6|Calibration|3
1114|103|Si|6|Calibration|4
1115|103|Si|6|Calibration|5
1116|103|Si|6|Calibration|6
1117|103|Si|6|Calibration|7
1118|103|Si|6|Calibration|8
1119|103|Si|6|Calibration|9
1120|103|Si|6|Calibration|10
1121|103|PB&J|2|Production|1
1122|103|PB&J|2|Production|2
1123|103|PB&J|2|Production|3
1124|103|PB&J|2|Production|4
1125|103|PB&J|2|Production|5
1126|103|PB&J|2|Production|6
1127|103|PB&J|2|Production|7
1128|103|PB&J|2|Production|8
1129|103|PB&J|2|Production|9
1130|103|PB&J|2|Production|10
1131|103|PB&J|2|Calibration|1
1132|103|PB&J|2|Calibration|2
1133|103|PB&J|2|Calibration|3
1134|103|PB&J|2|Calibration|4
1135|103|PB&J|2|Calibration|5
1136|103|PB&J|2|Calibration|6
1137|103|PB&J|2|Calibration|7
1138|103|PB&J|2|Calibration|8
1139|103|PB&J|2|Calibration|9
1140|103|PB&J|2|Calibration|10
1141|103|PB&J|3|Production|1
1142|103|PB&J|3|Production|2
1143|103|PB&J|3|Production|3
1144|103|PB&J|3|Production|4
1145|103|PB&J|3|Production|5
1146|103|PB&J|3|Production|6
1147|103|PB&J|3|Production|7
1148|103|PB&J|3|Production|8
1149|103|PB&J|3|Production|9
1150|103|PB&J|3|Production|10
1151|103|PB&J|3|Calibration|1
1152|103|PB&J|3|Calibration|2
1153|103|PB&J|3|Calibration|3
1154|103|PB&J|3|Calibration|4
1155|103|PB&J|3|Calibration|5
1156|103|PB&J|3|Calibration|6
1157|103|PB&J|3|Calibration|7
1158|103|PB&J|3|Calibration|8
1159|103|PB&J|3|Calibration|9
1160|103|PB&J|3|Calibration|10
1161|103|PB&J|4|Production|1
1162|103|PB&J|4|Production|2
1163|103|PB&J|4|Production|3
1164|103|PB&J|4|Production|4
1165|103|PB&J|4|Production|5
1166|103|PB&J|4|Production|6
1167|103|PB&J|4|Production|7
1168|103|PB&J|4|Production|8
1169|103|PB&J|4|Production|9
1170|103|PB&J|4|Production|10
1171|103|PB&J|4|Calibration|1
1172|103|PB&J|4|Calibration|2
1173|103|PB&J|4|Calibration|3
1174|103|PB&J|4|Calibration|4
1175|103|PB&J|4|Calibration|5
1176|103|PB&J|4|Calibration|6
1177|103|PB&J|4|Calibration|7
1178|103|PB&J|4|Calibration|8
1179|103|PB&J|4|Calibration|9
1180|103|PB&J|4|Calibration|10
1181|103|PB&J|6|Production|1
1182|103|PB&J|6|Production|2
1183|103|PB&J|6|Production|3
1184|103|PB&J|6|Production|4
1185|103|PB&J|6|Production|5
1186|103|PB&J|6|Production|6
1187|103|PB&J|6|Production|7
1188|103|PB&J|6|Production|8
1189|103|PB&J|6|Production|9
1190|103|PB&J|6|Production|10
1191|103|PB&J|6|Calibration|1
1192|103|PB&J|6|Calibration|2
1193|103|PB&J|6|Calibration|3
1194|103|PB&J|6|Calibration|4
1195|103|PB&J|6|Calibration|5
1196|103|PB&J|6|Calibration|6
1197|103|PB&J|6|Calibration|7
1198|103|PB&J|6|Calibration|8
1199|103|PB&J|6|Calibration|9
1200|103|PB&J|6|Calibration|10
1201|104|GaAs|2|Production|1
1202|104|GaAs|2|Production|2
1203|104|GaAs|2|Production|3
1204|104|GaAs|2|Production|4
1205|104|GaAs|2|Production|5
1206|104|GaAs|2|Production|6
1207|104|GaAs|2|Production|7
1208|104|GaAs|2|Production|8
1209|104|GaAs|2|Production|9
1210|104|GaAs|2|Production|10
1211|104|GaAs|2|Calibration|1
1212|104|GaAs|2|Calibration|2
1213|104|GaAs|2|Calibration|3
1214|104|GaAs|2|Calibration|4
1215|104|GaAs|2|Calibration|5
1216|104|GaAs|2|Calibration|6
1217|104|GaAs|2|Calibration|7
1218|104|GaAs|2|Calibration|8
1219|104|GaAs|2|Calibration|9
1220|104|GaAs|2|Calibration|10
1221|104|GaAs|3|Production|1
1222|104|GaAs|3|Production|2
1223|104|GaAs|3|Production|3
1224|104|GaAs|3|Production|4
1225|104|GaAs|3|Production|5
1226|104|GaAs|3|Production|6
1227|104|GaAs|3|Production|7
1228|104|GaAs|3|Production|8
1229|104|GaAs|3|Production|9
1230|104|GaAs|3|Production|10
1231|104|GaAs|3|Calibration|1
1232|104|GaAs|3|Calibration|2
1233|104|GaAs|3|Calibration|3
1234|104|GaAs|3|Calibration|4
1235|104|GaAs|3|Calibration|5
1236|104|GaAs|3|Calibration|6
1237|104|GaAs|3|Calibration|7
1238|104|GaAs|3|Calibration|8
1239|104|GaAs|3|Calibration|9
1240|104|GaAs|3|Calibration|10
1241|104|GaAs|4|Production|1
1242|104|GaAs|4|Production|2
1243|104|GaAs|4|Production|3
1244|104|GaAs|4|Production|4
1245|104|GaAs|4|Production|5
1246|104|GaAs|4|Production|6
1247|104|GaAs|4|Production|7
1248|104|GaAs|4|Production|8
1249|104|GaAs|4|Production|9
1250|104|GaAs|4|Production|10
1251|104|GaAs|4|Calibration|1
1252|104|GaAs|4|Calibration|2
1253|104|GaAs|4|Calibration|3
1254|104|GaAs|4|Calibration|4
1255|104|GaAs|4|Calibration|5
1256|104|GaAs|4|Calibration|6
1257|104|GaAs|4|Calibration|7
1258|104|GaAs|4|Calibration|8
1259|104|GaAs|4|Calibration|9
1260|104|GaAs|4|Calibration|10
1261|104|GaAs|6|Production|1
1262|104|GaAs|6|Production|2
1263|104|GaAs|6|Production|3
1264|104|GaAs|6|Production|4
1265|104|GaAs|6|Production|5
1266|104|GaAs|6|Production|6
1267|104|GaAs|6|Production|7
1268|104|GaAs|6|Production|8
1269|104|GaAs|6|Production|9
1270|104|GaAs|6|Production|10
1271|104|GaAs|6|Calibration|1
1272|104|GaAs|6|Calibration|2
1273|104|GaAs|6|Calibration|3
1274|104|GaAs|6|Calibration|4
1275|104|GaAs|6|Calibration|5
1276|104|GaAs|6|Calibration|6
1277|104|GaAs|6|Calibration|7
1278|104|GaAs|6|Calibration|8
1279|104|GaAs|6|Calibration|9
1280|104|GaAs|6|Calibration|10
1281|104|InP|2|Production|1
1282|104|InP|2|Production|2
1283|104|InP|2|Production|3
1284|104|InP|2|Production|4
1285|104|InP|2|Production|5
1286|104|InP|2|Production|6
1287|104|InP|2|Production|7
1288|104|InP|2|Production|8
1289|104|InP|2|Production|9
1290|104|InP|2|Production|10
1291|104|InP|2|Calibration|1
1292|104|InP|2|Calibration|2
1293|104|InP|2|Calibration|3
1294|104|InP|2|Calibration|4
1295|104|InP|2|Calibration|5
1296|104|InP|2|Calibration|6
1297|104|InP|2|Calibration|7
1298|104|InP|2|Calibration|8
1299|104|InP|2|Calibration|9
1300|104|InP|2|Calibration|10
1301|104|InP|3|Production|1
1302|104|InP|3|Production|2
1303|104|InP|3|Production|3
1304|104|InP|3|Production|4
1305|104|InP|3|Production|5
1306|104|InP|3|Production|6
1307|104|InP|3|Production|7
1308|104|InP|3|Production|8
1309|104|InP|3|Production|9
1310|104|InP|3|Production|10
1311|104|InP|3|Calibration|1
1312|104|InP|3|Calibration|2
1313|104|InP|3|Calibration|3
1314|104|InP|3|Calibration|4
1315|104|InP|3|Calibration|5
1316|104|InP|3|Calibration|6
1317|104|InP|3|Calibration|7
1318|104|InP|3|Calibration|8
1319|104|InP|3|Calibration|9
1320|104|InP|3|Calibration|10
1321|104|InP|4|Production|1
1322|104|InP|4|Production|2
1323|104|InP|4|Production|3
1324|104|InP|4|Production|4
1325|104|InP|4|Production|5
1326|104|InP|4|Production|6
1327|104|InP|4|Production|7
1328|104|InP|4|Production|8
1329|104|InP|4|Production|9
1330|104|InP|4|Production|10
1331|104|InP|4|Calibration|1
1332|104|InP|4|Calibration|2
1333|104|InP|4|Calibration|3
1334|104|InP|4|Calibration|4
1335|104|InP|4|Calibration|5
1336|104|InP|4|Calibration|6
1337|104|InP|4|Calibration|7
1338|104|InP|4|Calibration|8
1339|104|InP|4|Calibration|9
1340|104|InP|4|Calibration|10
1341|104|InP|6|Production|1
1342|104|InP|6|Production|2
1343|104|InP|6|Production|3
1344|104|InP|6|Production|4
1345|104|InP|6|Production|5
1346|104|InP|6|Production|6
1347|104|InP|6|Production|7
1348|104|InP|6|Production|8
1349|104|InP|6|Production|9
1350|104|InP|6|Production|10
1351|104|InP|6|Calibration|1
1352|104|InP|6|Calibration|2
1353|104|InP|6|Calibration|3
1354|104|InP|6|Calibration|4
1355|104|InP|6|Calibration|5
1356|104|InP|6|Calibration|6
1357|104|InP|6|Calibration|7
1358|104|InP|6|Calibration|8
1359|104|InP|6|Calibration|9
1360|104|InP|6|Calibration|10
1361|104|GaN|2|Production|1
1362|104|GaN|2|Production|2
1363|104|GaN|2|Production|3
1364|104|GaN|2|Production|4
1365|104|GaN|2|Production|5
1366|104|GaN|2|Production|6
1367|104|GaN|2|Production|7
1368|104|GaN|2|Production|8
1369|104|GaN|2|Production|9
1370|104|GaN|2|Production|10
1371|104|GaN|2|Calibration|1
1372|104|GaN|2|Calibration|2
1373|104|GaN|2|Calibration|3
1374|104|GaN|2|Calibration|4
1375|104|GaN|2|Calibration|5
1376|104|GaN|2|Calibration|6
1377|104|GaN|2|Calibration|7
1378|104|GaN|2|Calibration|8
1379|104|GaN|2|Calibration|9
1380|104|GaN|2|Calibration|10
1381|104|GaN|3|Production|1
1382|104|GaN|3|Production|2
1383|104|GaN|3|Production|3
1384|104|GaN|3|Production|4
1385|104|GaN|3|Production|5
1386|104|GaN|3|Production|6
1387|104|GaN|3|Production|7
1388|104|GaN|3|Production|8
1389|104|GaN|3|Production|9
1390|104|GaN|3|Production|10
1391|104|GaN|3|Calibration|1
1392|104|GaN|3|Calibration|2
1393|104|GaN|3|Calibration|3
1394|104|GaN|3|Calibration|4
1395|104|GaN|3|Calibration|5
1396|104|GaN|3|Calibration|6
1397|104|GaN|3|Calibration|7
1398|104|GaN|3|Calibration|8
1399|104|GaN|3|Calibration|9
1400|104|GaN|3|Calibration|10
1401|104|GaN|4|Production|1
1402|104|GaN|4|Production|2
1403|104|GaN|4|Production|3
1404|104|GaN|4|Production|4
1405|104|GaN|4|Production|5
1406|104|GaN|4|Production|6
1407|104|GaN|4|Production|7
1408|104|GaN|4|Production|8
1409|104|GaN|4|Production|9
1410|104|GaN|4|Production|10
1411|104|GaN|4|Calibration|1
1412|104|GaN|4|Calibration|2
1413|104|GaN|4|Calibration|3
1414|104|GaN|4|Calibration|4
1415|104|GaN|4|Calibration|5
1416|104|GaN|4|Calibration|6
1417|104|GaN|4|Calibration|7
1418|104|GaN|4|Calibration|8
1419|104|GaN|4|Calibration|9
1420|104|GaN|4|Calibration|10
1421|104|GaN|6|Production|1
1422|104|GaN|6|Production|2
1423|104|GaN|6|Production|3
1424|104|GaN|6|Production|4
1425|104|GaN|6|Production|5
1426|104|GaN|6|Production|6
1427|104|GaN|6|Production|7
1428|104|GaN|6|Production|8
1429|104|GaN|6|Production|9
1430|104|GaN|6|Production|10
1431|104|GaN|6|Calibration|1
1432|104|GaN|6|Calibration|2
1433|104|GaN|6|Calibration|3
1434|104|GaN|6|Calibration|4
1435|104|GaN|6|Calibration|5
1436|104|GaN|6|Calibration|6
1437|104|GaN|6|Calibration|7
1438|104|GaN|6|Calibration|8
1439|104|GaN|6|Calibration|9
1440|104|GaN|6|Calibration|10
1441|104|Si|2|Production|1
1442|104|Si|2|Production|2
1443|104|Si|2|Production|3
1444|104|Si|2|Production|4
1445|104|Si|2|Production|5
1446|104|Si|2|Production|6
1447|104|Si|2|Production|7
1448|104|Si|2|Production|8
1449|104|Si|2|Production|9
1450|104|Si|2|Production|10
1451|104|Si|2|Calibration|1
1452|104|Si|2|Calibration|2
1453|104|Si|2|Calibration|3
1454|104|Si|2|Calibration|4
1455|104|Si|2|Calibration|5
1456|104|Si|2|Calibration|6
1457|104|Si|2|Calibration|7
1458|104|Si|2|Calibration|8
1459|104|Si|2|Calibration|9
1460|104|Si|2|Calibration|10
1461|104|Si|3|Production|1
1462|104|Si|3|Production|2
1463|104|Si|3|Production|3
1464|104|Si|3|Production|4
1465|104|Si|3|Production|5
1466|104|Si|3|Production|6
1467|104|Si|3|Production|7
1468|104|Si|3|Production|8
1469|104|Si|3|Production|9
1470|104|Si|3|Production|10
1471|104|Si|3|Calibration|1
1472|104|Si|3|Calibration|2
1473|104|Si|3|Calibration|3
1474|104|Si|3|Calibration|4
1475|104|Si|3|Calibration|5
1476|104|Si|3|Calibration|6
1477|104|Si|3|Calibration|7
1478|104|Si|3|Calibration|8
1479|104|Si|3|Calibration|9
1480|104|Si|3|Calibration|10
1481|104|Si|4|Production|1
1482|104|Si|4|Production|2
1483|104|Si|4|Production|3
1484|104|Si|4|Production|4
1485|104|Si|4|Production|5
1486|104|Si|4|Production|6
1487|104|Si|4|Production|7
1488|104|Si|4|Production|8
1489|104|Si|4|Production|9
1490|104|Si|4|Production|10
1491|104|Si|4|Calibration|1
1492|104|Si|4|Calibration|2
1493|104|Si|4|Calibration|3
1494|104|Si|4|Calibration|4
1495|104|Si|4|Calibration|5
1496|104|Si|4|Calibration|6
1497|104|Si|4|Calibration|7
1498|104|Si|4|Calibration|8
1499|104|Si|4|Calibration|9
1500|104|Si|4|Calibration|10
1501|104|Si|6|Production|1
1502|104|Si|6|Production|2
1503|104|Si|6|Production|3
1504|104|Si|6|Production|4
1505|104|Si|6|Production|5
1506|104|Si|6|Production|6
1507|104|Si|6|Production|7
1508|104|Si|6|Production|8
1509|104|Si|6|Production|9
1510|104|Si|6|Production|10
1511|104|Si|6|Calibration|1
1512|104|Si|6|Calibration|2
1513|104|Si|6|Calibration|3
1514|104|Si|6|Calibration|4
1515|104|Si|6|Calibration|5
1516|104|Si|6|Calibration|6
1517|104|Si|6|Calibration|7
1518|104|Si|6|Calibration|8
1519|104|Si|6|Calibration|9
1520|104|Si|6|Calibration|10
1521|104|PB&J|2|Production|1
1522|104|PB&J|2|Production|2
1523|104|PB&J|2|Production|3
1524|104|PB&J|2|Production|4
1525|104|PB&J|2|Production|5
1526|104|PB&J|2|Production|6
1527|104|PB&J|2|Production|7
1528|104|PB&J|2|Production|8
1529|104|PB&J|2|Production|9
1530|104|PB&J|2|Production|10
1531|104|PB&J|2|Calibration|1
1532|104|PB&J|2|Calibration|2
1533|104|PB&J|2|Calibration|3
1534|104|PB&J|2|Calibration|4
1535|104|PB&J|2|Calibration|5
1536|104|PB&J|2|Calibration|6
1537|104|PB&J|2|Calibration|7
1538|104|PB&J|2|Calibration|8
1539|104|PB&J|2|Calibration|9
1540|104|PB&J|2|Calibration|10
1541|104|PB&J|3|Production|1
1542|104|PB&J|3|Production|2
1543|104|PB&J|3|Production|3
1544|104|PB&J|3|Production|4
1545|104|PB&J|3|Production|5
1546|104|PB&J|3|Production|6
1547|104|PB&J|3|Production|7
1548|104|PB&J|3|Production|8
1549|104|PB&J|3|Production|9
1550|104|PB&J|3|Production|10
1551|104|PB&J|3|Calibration|1
1552|104|PB&J|3|Calibration|2
1553|104|PB&J|3|Calibration|3
1554|104|PB&J|3|Calibration|4
1555|104|PB&J|3|Calibration|5
1556|104|PB&J|3|Calibration|6
1557|104|PB&J|3|Calibration|7
1558|104|PB&J|3|Calibration|8
1559|104|PB&J|3|Calibration|9
1560|104|PB&J|3|Calibration|10
1561|104|PB&J|4|Production|1
1562|104|PB&J|4|Production|2
1563|104|PB&J|4|Production|3
1564|104|PB&J|4|Production|4
1565|104|PB&J|4|Production|5
1566|104|PB&J|4|Production|6
1567|104|PB&J|4|Production|7
1568|104|PB&J|4|Production|8
1569|104|PB&J|4|Production|9
1570|104|PB&J|4|Production|10
1571|104|PB&J|4|Calibration|1
1572|104|PB&J|4|Calibration|2
1573|104|PB&J|4|Calibration|3
1574|104|PB&J|4|Calibration|4
1575|104|PB&J|4|Calibration|5
1576|104|PB&J|4|Calibration|6
1577|104|PB&J|4|Calibration|7
1578|104|PB&J|4|Calibration|8
1579|104|PB&J|4|Calibration|9
1580|104|PB&J|4|Calibration|10
1581|104|PB&J|6|Production|1
1582|104|PB&J|6|Production|2
1583|104|PB&J|6|Production|3
1584|104|PB&J|6|Production|4
1585|104|PB&J|6|Production|5
1586|104|PB&J|6|Production|6
1587|104|PB&J|6|Production|7
1588|104|PB&J|6|Production|8
1589|104|PB&J|6|Production|9
1590|104|PB&J|6|Production|10
1591|104|PB&J|6|Calibration|1
1592|104|PB&J|6|Calibration|2
1593|104|PB&J|6|Calibration|3
1594|104|PB&J|6|Calibration|4
1595|104|PB&J|6|Calibration|5
1596|104|PB&J|6|Calibration|6
1597|104|PB&J|6|Calibration|7
1598|104|PB&J|6|Calibration|8
1599|104|PB&J|6|Calibration|9
1600|104|PB&J|6|Calibration|10
1601|105|GaAs|2|Production|1
1602|105|GaAs|2|Production|2
1603|105|GaAs|2|Production|3
1604|105|GaAs|2|Production|4
1605|105|GaAs|2|Production|5
1606|105|GaAs|2|Production|6
1607|105|GaAs|2|Production|7
1608|105|GaAs|2|Production|8
1609|105|GaAs|2|Production|9
1610|105|GaAs|2|Production|10
1611|105|GaAs|2|Calibration|1
1612|105|GaAs|2|Calibration|2
1613|105|GaAs|2|Calibration|3
1614|105|GaAs|2|Calibration|4
1615|105|GaAs|2|Calibration|5
1616|105|GaAs|2|Calibration|6
1617|105|GaAs|2|Calibration|7
1618|105|GaAs|2|Calibration|8
1619|105|GaAs|2|Calibration|9
1620|105|GaAs|2|Calibration|10
1621|105|GaAs|3|Production|1
1622|105|GaAs|3|Production|2
1623|105|GaAs|3|Production|3
1624|105|GaAs|3|Production|4
1625|105|GaAs|3|Production|5
1626|105|GaAs|3|Production|6
1627|105|GaAs|3|Production|7
1628|105|GaAs|3|Production|8
1629|105|GaAs|3|Production|9
1630|105|GaAs|3|Production|10
1631|105|GaAs|3|Calibration|1
1632|105|GaAs|3|Calibration|2
1633|105|GaAs|3|Calibration|3
1634|105|GaAs|3|Calibration|4
1635|105|GaAs|3|Calibration|5
1636|105|GaAs|3|Calibration|6
1637|105|GaAs|3|Calibration|7
1638|105|GaAs|3|Calibration|8
1639|105|GaAs|3|Calibration|9
1640|105|GaAs|3|Calibration|10
1641|105|GaAs|4|Production|1
1642|105|GaAs|4|Production|2
1643|105|GaAs|4|Production|3
1644|105|GaAs|4|Production|4
1645|105|GaAs|4|Production|5
1646|105|GaAs|4|Production|6
1647|105|GaAs|4|Production|7
1648|105|GaAs|4|Production|8
1649|105|GaAs|4|Production|9
1650|105|GaAs|4|Production|10
1651|105|GaAs|4|Calibration|1
1652|105|GaAs|4|Calibration|2
1653|105|GaAs|4|Calibration|3
1654|105|GaAs|4|Calibration|4
1655|105|GaAs|4|Calibration|5
1656|105|GaAs|4|Calibration|6
1657|105|GaAs|4|Calibration|7
1658|105|GaAs|4|Calibration|8
1659|105|GaAs|4|Calibration|9
1660|105|GaAs|4|Calibration|10
1661|105|GaAs|6|Production|1
1662|105|GaAs|6|Production|2
1663|105|GaAs|6|Production|3
1664|105|GaAs|6|Production|4
1665|105|GaAs|6|Production|5
1666|105|GaAs|6|Production|6
1667|105|GaAs|6|Production|7
1668|105|GaAs|6|Production|8
1669|105|GaAs|6|Production|9
1670|105|GaAs|6|Production|10
1671|105|GaAs|6|Calibration|1
1672|105|GaAs|6|Calibration|2
1673|105|GaAs|6|Calibration|3
1674|105|GaAs|6|Calibration|4
1675|105|GaAs|6|Calibration|5
1676|105|GaAs|6|Calibration|6
1677|105|GaAs|6|Calibration|7
1678|105|GaAs|6|Calibration|8
1679|105|GaAs|6|Calibration|9
1680|105|GaAs|6|Calibration|10
1681|105|InP|2|Production|1
1682|105|InP|2|Production|2
1683|105|InP|2|Production|3
1684|105|InP|2|Production|4
1685|105|InP|2|Production|5
1686|105|InP|2|Production|6
1687|105|InP|2|Production|7
1688|105|InP|2|Production|8
1689|105|InP|2|Production|9
1690|105|InP|2|Production|10
1691|105|InP|2|Calibration|1
1692|105|InP|2|Calibration|2
1693|105|InP|2|Calibration|3
1694|105|InP|2|Calibration|4
1695|105|InP|2|Calibration|5
1696|105|InP|2|Calibration|6
1697|105|InP|2|Calibration|7
1698|105|InP|2|Calibration|8
1699|105|InP|2|Calibration|9
1700|105|InP|2|Calibration|10
1701|105|InP|3|Production|1
1702|105|InP|3|Production|2
1703|105|InP|3|Production|3
1704|105|InP|3|Production|4
1705|105|InP|3|Production|5
1706|105|InP|3|Production|6
1707|105|InP|3|Production|7
1708|105|InP|3|Production|8
1709|105|InP|3|Production|9
1710|105|InP|3|Production|10
1711|105|InP|3|Calibration|1
1712|105|InP|3|Calibration|2
1713|105|InP|3|Calibration|3
1714|105|InP|3|Calibration|4
1715|105|InP|3|Calibration|5
1716|105|InP|3|Calibration|6
1717|105|InP|3|Calibration|7
1718|105|InP|3|Calibration|8
1719|105|InP|3|Calibration|9
1720|105|InP|3|Calibration|10
1721|105|InP|4|Production|1
1722|105|InP|4|Production|2
1723|105|InP|4|Production|3
1724|105|InP|4|Production|4
1725|105|InP|4|Production|5
1726|105|InP|4|Production|6
1727|105|InP|4|Production|7
1728|105|InP|4|Production|8
1729|105|InP|4|Production|9
1730|105|InP|4|Production|10
1731|105|InP|4|Calibration|1
1732|105|InP|4|Calibration|2
1733|105|InP|4|Calibration|3
1734|105|InP|4|Calibration|4
1735|105|InP|4|Calibration|5
1736|105|InP|4|Calibration|6
1737|105|InP|4|Calibration|7
1738|105|InP|4|Calibration|8
1739|105|InP|4|Calibration|9
1740|105|InP|4|Calibration|10
1741|105|InP|6|Production|1
1742|105|InP|6|Production|2
1743|105|InP|6|Production|3
1744|105|InP|6|Production|4
1745|105|InP|6|Production|5
1746|105|InP|6|Production|6
1747|105|InP|6|Production|7
1748|105|InP|6|Production|8
1749|105|InP|6|Production|9
1750|105|InP|6|Production|10
1751|105|InP|6|Calibration|1
1752|105|InP|6|Calibration|2
1753|105|InP|6|Calibration|3
1754|105|InP|6|Calibration|4
1755|105|InP|6|Calibration|5
1756|105|InP|6|Calibration|6
1757|105|InP|6|Calibration|7
1758|105|InP|6|Calibration|8
1759|105|InP|6|Calibration|9
1760|105|InP|6|Calibration|10
1761|105|GaN|2|Production|1
1762|105|GaN|2|Production|2
1763|105|GaN|2|Production|3
1764|105|GaN|2|Production|4
1765|105|GaN|2|Production|5
1766|105|GaN|2|Production|6
1767|105|GaN|2|Production|7
1768|105|GaN|2|Production|8
1769|105|GaN|2|Production|9
1770|105|GaN|2|Production|10
1771|105|GaN|2|Calibration|1
1772|105|GaN|2|Calibration|2
1773|105|GaN|2|Calibration|3
1774|105|GaN|2|Calibration|4
1775|105|GaN|2|Calibration|5
1776|105|GaN|2|Calibration|6
1777|105|GaN|2|Calibration|7
1778|105|GaN|2|Calibration|8
1779|105|GaN|2|Calibration|9
1780|105|GaN|2|Calibration|10
1781|105|GaN|3|Production|1
1782|105|GaN|3|Production|2
1783|105|GaN|3|Production|3
1784|105|GaN|3|Production|4
1785|105|GaN|3|Production|5
1786|105|GaN|3|Production|6
1787|105|GaN|3|Production|7
1788|105|GaN|3|Production|8
1789|105|GaN|3|Production|9
1790|105|GaN|3|Production|10
1791|105|GaN|3|Calibration|1
1792|105|GaN|3|Calibration|2
1793|105|GaN|3|Calibration|3
1794|105|GaN|3|Calibration|4
1795|105|GaN|3|Calibration|5
1796|105|GaN|3|Calibration|6
1797|105|GaN|3|Calibration|7
1798|105|GaN|3|Calibration|8
1799|105|GaN|3|Calibration|9
1800|105|GaN|3|Calibration|10
1801|105|GaN|4|Production|1
1802|105|GaN|4|Production|2
1803|105|GaN|4|Production|3
1804|105|GaN|4|Production|4
1805|105|GaN|4|Production|5
1806|105|GaN|4|Production|6
1807|105|GaN|4|Production|7
1808|105|GaN|4|Production|8
1809|105|GaN|4|Production|9
1810|105|GaN|4|Production|10
1811|105|GaN|4|Calibration|1
1812|105|GaN|4|Calibration|2
1813|105|GaN|4|Calibration|3
1814|105|GaN|4|Calibration|4
1815|105|GaN|4|Calibration|5
1816|105|GaN|4|Calibration|6
1817|105|GaN|4|Calibration|7
1818|105|GaN|4|Calibration|8
1819|105|GaN|4|Calibration|9
1820|105|GaN|4|Calibration|10
1821|105|GaN|6|Production|1
1822|105|GaN|6|Production|2
1823|105|GaN|6|Production|3
1824|105|GaN|6|Production|4
1825|105|GaN|6|Production|5
1826|105|GaN|6|Production|6
1827|105|GaN|6|Production|7
1828|105|GaN|6|Production|8
1829|105|GaN|6|Production|9
1830|105|GaN|6|Production|10
1831|105|GaN|6|Calibration|1
1832|105|GaN|6|Calibration|2
1833|105|GaN|6|Calibration|3
1834|105|GaN|6|Calibration|4
1835|105|GaN|6|Calibration|5
1836|105|GaN|6|Calibration|6
1837|105|GaN|6|Calibration|7
1838|105|GaN|6|Calibration|8
1839|105|GaN|6|Calibration|9
1840|105|GaN|6|Calibration|10
1841|105|Si|2|Production|1
1842|105|Si|2|Production|2
1843|105|Si|2|Production|3
1844|105|Si|2|Production|4
1845|105|Si|2|Production|5
1846|105|Si|2|Production|6
1847|105|Si|2|Production|7
1848|105|Si|2|Production|8
1849|105|Si|2|Production|9
1850|105|Si|2|Production|10
1851|105|Si|2|Calibration|1
1852|105|Si|2|Calibration|2
1853|105|Si|2|Calibration|3
1854|105|Si|2|Calibration|4
1855|105|Si|2|Calibration|5
1856|105|Si|2|Calibration|6
1857|105|Si|2|Calibration|7
1858|105|Si|2|Calibration|8
1859|105|Si|2|Calibration|9
1860|105|Si|2|Calibration|10
1861|105|Si|3|Production|1
1862|105|Si|3|Production|2
1863|105|Si|3|Production|3
1864|105|Si|3|Production|4
1865|105|Si|3|Production|5
1866|105|Si|3|Production|6
1867|105|Si|3|Production|7
1868|105|Si|3|Production|8
1869|105|Si|3|Production|9
1870|105|Si|3|Production|10
1871|105|Si|3|Calibration|1
1872|105|Si|3|Calibration|2
1873|105|Si|3|Calibration|3
1874|105|Si|3|Calibration|4
1875|105|Si|3|Calibration|5
1876|105|Si|3|Calibration|6
1877|105|Si|3|Calibration|7
1878|105|Si|3|Calibration|8
1879|105|Si|3|Calibration|9
1880|105|Si|3|Calibration|10
1881|105|Si|4|Production|1
1882|105|Si|4|Production|2
1883|105|Si|4|Production|3
1884|105|Si|4|Production|4
1885|105|Si|4|Production|5
1886|105|Si|4|Production|6
1887|105|Si|4|Production|7
1888|105|Si|4|Production|8
1889|105|Si|4|Production|9
1890|105|Si|4|Production|10
1891|105|Si|4|Calibration|1
1892|105|Si|4|Calibration|2
1893|105|Si|4|Calibration|3
1894|105|Si|4|Calibration|4
1895|105|Si|4|Calibration|5
1896|105|Si|4|Calibration|6
1897|105|Si|4|Calibration|7
1898|105|Si|4|Calibration|8
1899|105|Si|4|Calibration|9
1900|105|Si|4|Calibration|10
1901|105|Si|6|Production|1
1902|105|Si|6|Production|2
1903|105|Si|6|Production|3
1904|105|Si|6|Production|4
1905|105|Si|6|Production|5
1906|105|Si|6|Production|6
1907|105|Si|6|Production|7
1908|105|Si|6|Production|8
1909|105|Si|6|Production|9
1910|105|Si|6|Production|10
1911|105|Si|6|Calibration|1
1912|105|Si|6|Calibration|2
1913|105|Si|6|Calibration|3
1914|105|Si|6|Calibration|4
1915|105|Si|6|Calibration|5
1916|105|Si|6|Calibration|6
1917|105|Si|6|Calibration|7
1918|105|Si|6|Calibration|8
1919|105|Si|6|Calibration|9
1920|105|Si|6|Calibration|10
1921|105|PB&J|2|Production|1
1922|105|PB&J|2|Production|2
1923|105|PB&J|2|Production|3
1924|105|PB&J|2|Production|4
1925|105|PB&J|2|Production|5
1926|105|PB&J|2|Production|6
1927|105|PB&J|2|Production|7
1928|105|PB&J|2|Production|8
1929|105|PB&J|2|Production|9
1930|105|PB&J|2|Production|10
1931|105|PB&J|2|Calibration|1
1932|105|PB&J|2|Calibration|2
1933|105|PB&J|2|Calibration|3
1934|105|PB&J|2|Calibration|4
1935|105|PB&J|2|Calibration|5
1936|105|PB&J|2|Calibration|6
1937|105|PB&J|2|Calibration|7
1938|105|PB&J|2|Calibration|8
1939|105|PB&J|2|Calibration|9
1940|105|PB&J|2|Calibration|10
1941|105|PB&J|3|Production|1
1942|105|PB&J|3|Production|2
1943|105|PB&J|3|Production|3
1944|105|PB&J|3|Production|4
1945|105|PB&J|3|Production|5
1946|105|PB&J|3|Production|6
1947|105|PB&J|3|Production|7
1948|105|PB&J|3|Production|8
1949|105|PB&J|3|Production|9
1950|105|PB&J|3|Production|10
1951|105|PB&J|3|Calibration|1
1952|105|PB&J|3|Calibration|2
1953|105|PB&J|3|Calibration|3
1954|105|PB&J|3|Calibration|4
1955|105|PB&J|3|Calibration|5
1956|105|PB&J|3|Calibration|6
1957|105|PB&J|3|Calibration|7
1958|105|PB&J|3|Calibration|8
1959|105|PB&J|3|Calibration|9
1960|105|PB&J|3|Calibration|10
1961|105|PB&J|4|Production|1
1962|105|PB&J|4|Production|2
1963|105|PB&J|4|Production|3
1964|105|PB&J|4|Production|4
1965|105|PB&J|4|Production|5
1966|105|PB&J|4|Production|6
1967|105|PB&J|4|Production|7
1968|105|PB&J|4|Production|8
1969|105|PB&J|4|Production|9
1970|105|PB&J|4|Production|10
1971|105|PB&J|4|Calibration|1
1972|105|PB&J|4|Calibration|2
1973|105|PB&J|4|Calibration|3
1974|105|PB&J|4|Calibration|4
1975|105|PB&J|4|Calibration|5
1976|105|PB&J|4|Calibration|6
1977|105|PB&J|4|Calibration|7
1978|105|PB&J|4|Calibration|8
1979|105|PB&J|4|Calibration|9
1980|105|PB&J|4|Calibration|10
1981|105|PB&J|6|Production|1
1982|105|PB&J|6|Production|2
1983|105|PB&J|6|Production|3
1984|105|PB&J|6|Production|4
1985|105|PB&J|6|Production|5
1986|105|PB&J|6|Production|6
1987|105|PB&J|6|Production|7
1988|105|PB&J|6|Production|8
1989|105|PB&J|6|Production|9
1990|105|PB&J|6|Production|10
1991|105|PB&J|6|Calibration|1
1992|105|PB&J|6|Calibration|2
1993|105|PB&J|6|Calibration|3
1994|105|PB&J|6|Calibration|4
1995|105|PB&J|6|Calibration|5
1996|105|PB&J|6|Calibration|6
1997|105|PB&J|6|Calibration|7
1998|105|PB&J|6|Calibration|8
1999|105|PB&J|6|Calibration|9
2000|105|PB&J|6|Calibration|10
END_DATA

  $data{reactors} = <<'END_DATA';
101
102
103
104
105
END_DATA

  $data{failurecodes} = <<'END_DATA';
1|0.40524464992723
2|0.793404781117232
3|0.15942092592935
4|0.667733599521803
5|0.0948198092056209
6|0.548004144788123
7|0.950288514976219
8|0.553967010038001
9|0.295963458708147
10|0.268934699299962
END_DATA

  $dbh->do("
    CREATE TABLE grown_wafers (
      wafer_id INTEGER PRIMARY KEY,
      reactor_id integer NOT NULL,
      material varchar NOT NULL,
      diameter integer NOT NULL,
      product_type varchar,
      failurecode integer
    );
  ");

  {
    my @lines = split /\n/, $data{grown_wafers};
    for my $line (@lines) {
      chomp $line;
      my @fields = split /\|/, $line;
      $dbh->do(
        "INSERT INTO grown_wafers VALUES (?, ?, ?, ?, ?, ?);",
        undef,
        @fields,
      );
    }
  }

  $dbh->do("CREATE TABLE reactors (reactor_id integer NOT NULL);");

  {
    my @lines = split /\n/, $data{reactors};
    for my $line (@lines) {
      chomp $line;
      $dbh->do("INSERT INTO reactors VALUES (?);", undef, $line);
    }
  }

  $dbh->do("
    CREATE TABLE failurecodes (
      failurecode integer NOT NULL,
      brief varchar NOT NULL
    );
  ");

  {
    my @lines = split /\n/, $data{failurecodes};
    for my $line (@lines) {
      chomp $line;
      my @fields = split /\|/, $line;
      $dbh->do("INSERT INTO failurecodes VALUES (?, ?);", undef, @fields);
    }
  }
};

if (my $error = $@) {
  BAIL_OUT("makedb failed: $error");
}

pass("build database for testing");
