use Test::More tests => 7;
use Games::Goban;

use strict;

my $x = new Games::Goban; 
$x->move("pp");
$x->move("pd"); 
$x->move("dp"); 
$x->move("jj"); 

isa_ok($x, 'Games::Goban');

is($x->get('aa'),undef, "nothing at 'aa'");
isa_ok($x->get('pp'),'Games::Goban::Piece');

is($x->as_sgf, <<EOF, "simple SGF file");
(;GM[1]FF[4]AP[Games::Goban]SZ[19]PB[Mr. Black]PW[Miss White]
;B[pp];W[pd];B[dp];W[jj])
EOF

is($x->as_text, <<EOF, "simple text diagram");
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . + . . . . . + . . . . . O . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . + . . . . .(O). . . . . + . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . X . . . . . + . . . . . X . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
. . . . . . . . . . . . . . . . . . . 
EOF

my $y = new Games::Goban (size=>9); 
eval {$y->move("pp")};
ok($@,"invalid move attempt");
$y->move("ab");
ok($y->as_text eq <<EOF,"small text diagram");
. . . . . . . . . 
X). . . . . . . . 
. . + . . . + . . 
. . . . . . . . . 
. . . . + . . . . 
. . . . . . . . . 
. . + . . . + . . 
. . . . . . . . . 
. . . . . . . . . 
EOF
