use strict;
use warnings;
use 5.006;

BEGIN {
  if ($^O eq 'MSWin32') {
    print <<'EOE';
OS unsupported
This program is very CLI and POSIX oriented, and as such makes no sense on Windows
(On the other hand Cygwin works just fine)

Note: MSWin32 support *may* be added in the future (via a separate codepath)

EOE
    exit;
  }

  require Config;;

  if ( $Config::Config{d_fork} ne 'define' ) {
    print <<'EOE';
OS unsupported
This program makes very heavy use of fork() which seems to be unavailable on this perl

EOE
    exit;
  }
}

# saddest panda (see comments in t/bin/stdio_is_X detailing why)
if ( -f 'META.yml' ) {
  require Fcntl;
  my $sys_getfl_value = Fcntl::F_GETFL();
  my $sys_now = localtime();
  system (
    $^X, qw( -0777 -p -i -e ),
    's/
      ^( \s* \$F_GETFL \s* \= ) \s* [0-9]+ \s* \; \s+ \#\Q hardcoded by packager, possibly on different OS\E
     /$1 ' . "$sys_getfl_value;   # substituted at configure-time by Makefile.PL on '$^O' on $sys_now/mx",
    't/bin/stdio_is_X'
  );
}

my %META = (
  provides => {
    'Test::SmokeSTDIO' => { file => '' },
  },
  name => 'Test::SmokeSTDIO',
  license => 'perl_5',
  prereqs => {
    configure => {
      requires => {
        'ExtUtils::MakeMaker' => 0,
      },
    },
    build => {
      requires => {
      },
    },
    test => {
      requires => {
      },
    },
    runtime => {
      requires => {
      },
    },
    develop   => {
      requires => {
      },
    },
  },
  dynamic_config => 0,
  resources => {
    license => [ 'perl_5' ],
  },
  no_index => {
    directory => [ 't', 'xt' ]
  },
  x_authority => 'cpan:RIBASUSHI',
);

my %MM_ARGS = (
  VERSION => '0.05',
  PREREQ_PM => {
  },
);

## BOILERPLATE ###############################################################
require ExtUtils::MakeMaker;

# have to do this since old EUMM dev releases miss the eval $VERSION line
my $eumm_version  = eval $ExtUtils::MakeMaker::VERSION;
my $mymeta        = $eumm_version >= 6.57_02;
my $mymeta_broken = $mymeta && $eumm_version < 6.57_07;

($MM_ARGS{NAME} = $META{name}) =~ s/-/::/g;

#($MM_ARGS{VERSION_FROM} = "lib/$MM_ARGS{NAME}.pm") =~ s{::}{/}g;

$META{license} = [ $META{license} ]
  if $META{license} && !ref $META{license};

$MM_ARGS{LICENSE} = $META{license}[0]
  if $META{license} && $eumm_version >= 6.30;

$MM_ARGS{NO_MYMETA} = 1
  if $mymeta_broken;

$MM_ARGS{META_ADD} = { 'meta-spec' => { version => 2 }, %META }
  unless -f 'META.yml';

for (qw(configure build test runtime)) {
  my $key = $_ eq 'runtime' ? 'PREREQ_PM' : uc $_.'_REQUIRES';
  my $r = $MM_ARGS{$key} = {
    %{$META{prereqs}{$_}{requires} || {}},
    %{delete $MM_ARGS{$key} || {}},
  };
  defined $r->{$_} or delete $r->{$_} for keys %$r;
}

$MM_ARGS{MIN_PERL_VERSION} = delete $MM_ARGS{PREREQ_PM}{perl} || 0;

delete $MM_ARGS{MIN_PERL_VERSION}
  if $eumm_version < 6.47_01;
$MM_ARGS{BUILD_REQUIRES} = {%{$MM_ARGS{BUILD_REQUIRES}}, %{delete $MM_ARGS{TEST_REQUIRES}}}
  if $eumm_version < 6.63_03;
$MM_ARGS{PREREQ_PM} = {%{$MM_ARGS{PREREQ_PM}}, %{delete $MM_ARGS{BUILD_REQUIRES}}}
  if $eumm_version < 6.55_01;
delete $MM_ARGS{CONFIGURE_REQUIRES}
  if $eumm_version < 6.51_03;

ExtUtils::MakeMaker::WriteMakefile(%MM_ARGS);
## END BOILERPLATE ###########################################################
