use strict;
use warnings;
use File::Slurp;

my $text = join '', <DATA>;

# Shall I test against autodie.pm or Fatal.pm ?
my @mods = qw/autodie Fatal/;

# Shall I load autodie/Fatal before or after Errno::AnyString ?
my %how = (
    before => '',
    after  => 'BEGIN { require Errno::AnyString; }',
);

foreach my $mod (@mods) {
    my $stage1 = $text;
    $stage1 =~ s/---mod---/$mod/g or die;
    while ( my ($name, $how) = each %how ) {
        $_ = $stage1;
        s/---name---/$name/ or die;
        s/---load-me---/$how/ or die;
        write_file "t/with-$mod-$name.t", $_;
    }
}

__DATA__
# Automatically generated by Errno::AnyString 0.50 lib/t_autodie.t.PL
# Inter-operation with autodie, ---mod--- loaded ---name--- Errno::AnyString

use strict;
use warnings;

---load-me---

use Test::More;
use Test::Exception;
BEGIN {
    eval 'require ---mod---';
    plan skip_all => '---mod--- required' if $@;

    plan tests => 3;
}
use Test::NoWarnings;

sub try_but_fail1 {
    $! = custom_errstr("set with custom errstr");
    return;
}
sub try_but_fail2 {
    $! = 999_999_999;
    return;
}
use ---mod--- qw/try_but_fail1 try_but_fail2/;

use Errno::AnyString qw/custom_errstr register_errstr/;
register_errstr "set with register errstr", 999_999_999;

throws_ok { try_but_fail1() } qr/set with custom errstr/,   "custom errstr seen by ---mod---";
throws_ok { try_but_fail2() } qr/set with register errstr/, "register errstr seen by ---mod---";

