# Errno::AnyString 0.01 lib/in-pm-files.t.PL
# Check that the effects of loading Errno::AnyString materialise in other
# already-loaded modules.

use strict;
use warnings;
use File::Slurp;

my %use_errno = (
    none => '# none',
    use  => 'use Errno;',
    euse => 'eval "use Errno"; die $@ if $@;',
    impl => 'my @implicitly_load_Errno_pm = keys(%!);',
);
my $data = join '', <DATA>;

my $mod_count = 4;
my $pkg_names = join " ", map {"Foo$_"} (1 .. $mod_count);
my $pkg_use = join "", map {"use Foo$_;\n"} (1 .. $mod_count);

foreach my $use (keys %use_errno) {
    $_ = $data;
    s/---use_errno---/$use_errno{$use}/g;
    s/---pkg_use---/$pkg_use/g;
    s/---pkg_names---/$pkg_names/g;
    write_file "t/in-pm-files-$use.t", $_;
}

__DATA__
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
# This file was auto-generated by lib/in-pm-files.t.PL
#
# Make changes there, not here.
#
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

use strict;
use warnings;

# The line below differs between t/in-pm-files-*.t - it pulls
# in Errno.pm (or not) in various different ways.
---use_errno---

use Test::More;
use Test::NoWarnings;

use lib 't';
---pkg_use---
use Errno::AnyString qw/ERRSTR_SET/;

my @pkgs = qw/---pkg_names---/;
plan tests => @pkgs*6 + 1;

foreach my $pkg (@pkgs) {
    my $x = $pkg->new;

    $! = "--string1";
    is $x->errstr, "string1", "$pkg special errstr set";
    is $x->errno, ERRSTR_SET, "$pkg special errno set";

    my $save = $!;

    $! = 0;
    isnt $x->errstr, "string1", "$pkg special errstr unset";
    isnt $x->errno, ERRSTR_SET, "$pkg special errno unset";

    $! = $save;
    is $x->errstr, "string1", "$pkg special errstr restored";
    is $x->errno, ERRSTR_SET, "$pkg special errno restored";
}

