## Domain Registry Interface, IRIS Protocols (RFC 3981,3982,3983,4414,4698,4991,4992,4993,5144)
##
## Copyright (c) 2008 Patrick Mevzek <netdri@dotandco.com>. All rights reserved.
##
## This file is part of Net::DRI
##
## Net::DRI is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## See the LICENSE file that comes with this distribution for more details.
#
# 
#
####################################################################################################

package Net::DRI::Protocol::IRIS;

use strict;

use base qw(Net::DRI::Protocol);

use Net::DRI::Util;
use Net::DRI::Protocol::IRIS::Message;
use Net::DRI::Protocol::IRIS::DCHK::Status;

our $VERSION=do { my @r=(q$Revision: 1.1 $=~/\d+/g); sprintf("%d".".%02d" x $#r, @r); };

=pod

=head1 NAME

Net::DRI::Protocol::IRIS - IRIS Protocols (RFC 3981,3982,3983,4414,4698,4991,4992,4993,5144) for Net::DRI

=head1 DESCRIPTION

Please see the README file for details.

Currently only DCHK (RFC5144) over LWZ (RFC4993) is supported.

=head1 SUPPORT

For now, support questions should be sent to:

E<lt>netdri@dotandco.comE<gt>

Please also see the SUPPORT file in the distribution.

=head1 SEE ALSO

E<lt>http://www.dotandco.com/services/software/Net-DRI/E<gt>

=head1 AUTHOR

Patrick Mevzek, E<lt>netdri@dotandco.comE<gt>

=head1 COPYRIGHT

Copyright (c) 2008 Patrick Mevzek <netdri@dotandco.com>.
All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

See the LICENSE file that comes with this distribution for more details.

=cut

####################################################################################################

sub new
{
 my $c=shift;
 my ($drd,$version,$authority)=@_;

 my $self=$c->SUPER::new();
 $self->name('IRIS');
 $version=Net::DRI::Util::check_equal($version,['1.0'],'1.0');
 $self->version($version);
 $self->ns({ iris1 => ['urn:ietf:params:xml:ns:iris1','iris1.xsd'],
             dchk1 => ['urn:ietf:params:xml:ns:dchk1','dchk1.xsd'],
          });
 $self->factories('message',sub { my $m=Net::DRI::Protocol::IRIS::Message->new(@_); $m->ns($self->ns()); $m->version($version); $m->authority($authority); return $m; });
 $self->factories('status',sub { return Net::DRI::Protocol::IRIS::DCHK::Status->new(); });
 $self->_load('Net::DRI::Protocol::IRIS::DCHK::Domain');

 return $self;
}

sub ns
{
 my ($self,$add)=@_;
 $self->{ns}={ ref($self->{ns})? %{$self->{ns}} : (), %$add } if (defined($add) && ref($add) eq 'HASH');
 return $self->{ns};
}

####################################################################################################
1;
