# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package Billing::GEN::Invoice;

use strict;

use base 'Billing';

use Billing::Model::invoice qw(
    $INVOICE
);
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Invoices' );

    my $retval = {
        headings       => [
            'Number',
            'Customer',
            'Status',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $INVOICE->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->number,
                    $row->customer->foreign_display(),
                    $row->status->foreign_display(),
                ],
                options => [
                    {
                        text => 'Tasks',
                        link => "/lineitem/main/$id",
                    },
                    {
                        text => 'PDF',
                        link => $self->location() . "/pdf/$id",
                    },
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $INVOICE->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        name       => 'invoice',
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        javascript => $self->calendar_month_js( 'invoice' ),
        fields     => [
            {
                name => 'number',
                label => 'Number',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{status},
                name => 'status',
                label => 'Status',
                type => 'select',
                is => 'int4',
            },
            {
                date_select_text => 'Popup Calendar',
                name => 'sent',
                optional => 1,
                label => 'Sent On',
                type => 'text',
                is => 'date',
            },
            {
                date_select_text => 'Popup Calendar',
                name => 'paid',
                optional => 1,
                label => 'Paid On',
                type => 'text',
                is => 'date',
            },
            {
                options => $selections->{my_company},
                name => 'my_company',
                label => 'My Company',
                type => 'select',
                is => 'int4',
            },
            {
                options => $selections->{customer},
                name => 'customer',
                label => 'Customer',
                type => 'select',
                is => 'int4',
            },
            {
                name => 'notes',
                optional => 1,
                label => 'Notes to Customer',
                type => 'textarea',
                is => 'text',
                rows => 4,
                cols => 50,
            },
            {
                name => 'description',
                optional => 1,
                label => 'Notes to Self',
                type => 'textarea',
                is => 'text',
                rows => 4,
                cols => 50,
            },
        ],
    };
} # END form


1;

=head1 NAME

Billing::GEN::Invoice - generated support module for Billing::Invoice

=head1 SYNOPSIS

In Billing::Invoice:

    use Billing::GEN::Invoice qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in Billing::Invoice to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

