#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

BEGIN {
   plan skip_all => "Future is not available"
      unless eval { require Future };
   plan skip_all => "Future::AsyncAwait >= 0.36 is not available"
      unless eval { require Future::AsyncAwait;
                    Future::AsyncAwait->VERSION( '0.36' ) };
   plan skip_all => "Object::Pad >= 0.15 is not available"
      unless eval { require Object::Pad;
                    Object::Pad->VERSION( '0.15' ) };

   Future::AsyncAwait->import;
   Object::Pad->import;

   diag( "Future::AsyncAwait $Future::AsyncAwait::VERSION, " .
         "Object::Pad $Object::Pad::VERSION" );
}

# async method
{
   class Thunker {
      has $_times_thunked = 0;

      method count { $_times_thunked }

      async method thunk {
         my ( $f ) = @_;
         await $f;
         $_times_thunked++;
         return "result";
      }
   }

   my $thunker = Thunker->new;

   my $f1 = Future->new;
   my $fret = $thunker->thunk( $f1 );

   is( $thunker->count, 0, 'count is 0 before $f1->done' );

   $f1->done;

   is( $thunker->count, 1, 'count is 1 after $f1->done' );
   is( $fret->get, "result", '$fret for await in async method' );
}

done_testing;
