#!/usr/bin/perl

use strict;
use warnings;

use Device::Chip::Adapter;

use Getopt::Long;
use Time::HiRes qw( sleep );

GetOptions(
   'i|interface=s' => \(my $INTERFACE = "SPI4"),
   'adapter|A=s' => \( my $ADAPTER ),
   'mount|M=s'   => \( my $MOUNTPARAMS ),
) or exit 1;

my $cls = "Device::Chip::SSD1306::$INTERFACE";
require ( "$cls.pm" =~ s{::}{/}gr );

my $chip = $cls->new;
$chip->mount_from_paramstr(
   Device::Chip::Adapter->new_from_description( $ADAPTER ),
   $MOUNTPARAMS,
)->get;

$chip->power(1)->get;

$SIG{INT} = $SIG{TERM} = sub { exit 1; };

END {
   $chip and $chip->power(0)->get;
}

sub send_cmd { $chip->send_cmd( @_ ) }

$chip->init->get;

$chip->display( 1 )->get;
$chip->display_lamptest( 1 )->get;

sleep 3;

$chip->display_lamptest( 0 )->get;

sleep 2;

foreach my $i ( 0 .. 7 ) {
   $chip->send_display( join "", ( chr ( 1 << $i ) ) x (128*8) )->get;
   sleep 0.5;
}

$chip->display( 0 )->get;
