package Log::Any::IfLOG;

our $DATE = '2015-02-21'; # DATE
our $VERSION = '0.01'; # VERSION

sub import {
    my $self = shift;

    my $caller = caller();
    if ($ENV{LOG}) {
        require Log::Any;
        Log::Any->_export_to_caller($caller, @_);
    } else {
        my $saw_log_param = grep { $_ eq '$log' } @_;
        if ($saw_log_param) {
            *{"$caller\::log"} = \Object::Dumb->new;
        }
    }
}

package
    Object::Dumb;
sub new { my $o = ""; bless \$o, shift }
sub AUTOLOAD { 0 }

1;
# ABSTRACT: Load Log::Any only if LOG environment variable is true

__END__

=pod

=encoding UTF-8

=head1 NAME

Log::Any::IfLOG - Load Log::Any only if LOG environment variable is true

=head1 VERSION

This document describes version 0.01 of Log::Any::IfLOG (from Perl distribution Log-Any-IfLOG), released on 2015-02-21.

=head1 SYNOPSIS

 use Log::Any::IfLOG '$log';

=head1 DESCRIPTION

This module will load L<Log::Any> only when C<LOG> environment variable is true.
Otherwise, the module is not loaded and if user imports C<$log>, a dumb object
will be returned instead that will accept any method but return false.

This is a quick-hack solution to avoid the cost of loading Log::Any under
"normal condition" (when C<LOG> is not set to true).

=for Pod::Coverage ^(.+)$

=head1 ENVIRONMENT

=head2 LOG => bool

If set to true, will load Log::Any as usual. Otherwise, won't load Log::Any and
will return a dumb object in C<$log> instead.

=head1 SEE ALSO

L<Log::Any>

L<http://github.com/dagolden/Log-Any/issues/24>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Log-Any-IfLOG>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Log-Any-IfLOG>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Log-Any-IfLOG>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
